/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.watermarkpack.flamefractal;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import org.pushingpixels.substance.watermarkpack.flamefractal.Functions;
import org.pushingpixels.substance.watermarkpack.flamefractal.IteratedFunction;

public class IteratedFunctionSystem {
    private List<IteratedFunction> functions = new ArrayList<IteratedFunction>();
    private IteratedFunction[] rotations;
    private int rotationDegree;
    private int rotIndex;

    public IteratedFunctionSystem(int rotationDegree, IteratedFunction ... fs) {
        for (IteratedFunction f : fs) {
            this.functions.add(f);
        }
        this.rotationDegree = rotationDegree;
        this.rotations = new IteratedFunction[this.rotationDegree];
        switch (this.rotationDegree) {
            case 1: {
                this.rotations[0] = new Functions.Rotation0Function();
                break;
            }
            case 2: {
                this.rotations[0] = new Functions.Rotation0Function();
                this.rotations[1] = new Functions.Rotation180Function();
                break;
            }
            case 3: {
                this.rotations[0] = new Functions.Rotation0Function();
                this.rotations[1] = new Functions.Rotation120Function();
                this.rotations[2] = new Functions.Rotation240Function();
                break;
            }
            case 4: {
                this.rotations[0] = new Functions.Rotation0Function();
                this.rotations[1] = new Functions.Rotation90Function();
                this.rotations[2] = new Functions.Rotation180Function();
                this.rotations[3] = new Functions.Rotation270Function();
                break;
            }
            default: {
                double delta = Math.PI * 2 / (double)this.rotationDegree;
                for (int i = 0; i < this.rotationDegree; ++i) {
                    this.rotations[i] = new Functions.RotationFunction(delta * (double)i);
                }
            }
        }
    }

    protected IteratedFunction getRandom() {
        int index = (int)((double)this.functions.size() * Math.random());
        return this.functions.get(index);
    }

    public void apply(Point2D bc) {
        this.getRandom().apply(bc);
        if (this.rotationDegree > 1) {
            int rotRandom = (int)(Math.random() * (double)this.rotationDegree);
            ++this.rotIndex;
            if (this.rotIndex >= this.rotationDegree) {
                this.rotIndex = 0;
            }
            this.rotations[rotRandom].apply(bc);
        }
    }
}

