/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.scala;

import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.internal.tasks.compile.JavaCompileSpec;
import org.gradle.api.internal.tasks.scala.ScalaCompileSpec;
import org.gradle.api.internal.tasks.scala.ScalaJavaJointCompileSpec;
import org.gradle.api.tasks.WorkResult;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.language.base.internal.compile.CompileSpec;
import org.gradle.language.base.internal.compile.Compiler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultScalaJavaJointCompiler
implements Compiler<ScalaJavaJointCompileSpec> {
    private final Compiler<ScalaCompileSpec> scalaCompiler;
    private final Compiler<JavaCompileSpec> javaCompiler;

    public DefaultScalaJavaJointCompiler(Compiler<ScalaCompileSpec> scalaCompiler, Compiler<JavaCompileSpec> javaCompiler) {
        this.scalaCompiler = scalaCompiler;
        this.javaCompiler = javaCompiler;
    }

    public WorkResult execute(ScalaJavaJointCompileSpec spec) {
        this.scalaCompiler.execute((CompileSpec)spec);
        PatternSet patternSet = new PatternSet();
        patternSet.include(new String[]{"**/*.java"});
        FileTree javaSource = spec.getSource().getAsFileTree().matching((PatternFilterable)patternSet);
        if (!javaSource.isEmpty()) {
            spec.setSource((FileCollection)javaSource);
            this.javaCompiler.execute((CompileSpec)spec);
        }
        return new WorkResult(){

            public boolean getDidWork() {
                return true;
            }
        };
    }
}

