/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.logging.internal;

import org.gradle.internal.Factory;
import org.gradle.logging.LoggingManagerInternal;
import org.gradle.logging.internal.DefaultLoggingManager;
import org.gradle.logging.internal.LoggingConfigurer;
import org.gradle.logging.internal.LoggingOutputInternal;
import org.gradle.logging.internal.LoggingSystem;
import org.gradle.logging.internal.LoggingSystemAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultLoggingManagerFactory
implements Factory<LoggingManagerInternal> {
    private final LoggingSystem slfLoggingSystem;
    private final LoggingSystem javaUtilLoggingSystem;
    private final LoggingSystem stdOutLoggingSystem;
    private final LoggingSystem stdErrLoggingSystem;
    private final LoggingOutputInternal loggingOutput;
    private final DefaultLoggingManager rootManager;
    private boolean created;

    public DefaultLoggingManagerFactory(LoggingConfigurer loggingConfigurer, LoggingOutputInternal loggingOutput, LoggingSystem javaUtilLoggingSystem, LoggingSystem stdOutLoggingSystem, LoggingSystem stdErrLoggingSystem) {
        this.loggingOutput = loggingOutput;
        this.javaUtilLoggingSystem = javaUtilLoggingSystem;
        this.stdOutLoggingSystem = stdOutLoggingSystem;
        this.stdErrLoggingSystem = stdErrLoggingSystem;
        this.slfLoggingSystem = new LoggingSystemAdapter(loggingConfigurer);
        this.rootManager = this.newManager();
    }

    public LoggingManagerInternal getRoot() {
        return this.rootManager;
    }

    public LoggingManagerInternal create() {
        if (!this.created) {
            this.created = true;
            return this.getRoot();
        }
        return this.newManager();
    }

    private DefaultLoggingManager newManager() {
        return new DefaultLoggingManager(this.slfLoggingSystem, this.javaUtilLoggingSystem, this.stdOutLoggingSystem, this.stdErrLoggingSystem, this.loggingOutput);
    }
}

