/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.nativeplatform.tasks;

import java.io.File;
import org.gradle.api.Incubating;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.language.nativeplatform.internal.incremental.sourceparser.DefaultInclude;
import org.gradle.language.nativeplatform.tasks.AbstractNativeCompileTask;
import org.gradle.nativeplatform.toolchain.internal.NativeCompileSpec;
import org.gradle.nativeplatform.toolchain.internal.PCHUtils;
import org.gradle.nativeplatform.toolchain.internal.PreCompiledHeader;

@Incubating
public abstract class AbstractNativeSourceCompileTask
extends AbstractNativeCompileTask {
    private PreCompiledHeader preCompiledHeader;

    protected void configureSpec(NativeCompileSpec spec) {
        super.configureSpec(spec);
        if (this.preCompiledHeader != null) {
            File pchObjectFile = this.preCompiledHeader.getObjectFile();
            File pchDir = PCHUtils.generatePCHObjectDirectory((File)spec.getTempDir(), (File)this.preCompiledHeader.getPrefixHeaderFile(), (File)pchObjectFile);
            spec.setPrefixHeaderFile(new File(pchDir, this.preCompiledHeader.getPrefixHeaderFile().getName()));
            spec.setPreCompiledHeaderObjectFile(new File(pchDir, pchObjectFile.getName()));
            spec.setPreCompiledHeader(DefaultInclude.parse(this.preCompiledHeader.getIncludeString(), true).getValue());
        }
    }

    @Nested
    @Optional
    public PreCompiledHeader getPreCompiledHeader() {
        return this.preCompiledHeader;
    }

    public void setPreCompiledHeader(PreCompiledHeader preCompiledHeader) {
        this.preCompiledHeader = preCompiledHeader;
    }
}

