/*

   Copyright (C) 2001,2002,2003,2004 Michael Rubinstein

   This file is part of the L-function package L.

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   Check the License for details. You should have received a copy of it, along
   with the package; see the file 'COPYING'. If not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

*/


//Reiemann Siegel formula using band limited interpolation
#ifndef Lriemannsiegel_blfi_H
#define Lriemannsiegel_blfi_H


Double sinc(Double u);
Double kernel(Double u);
Double theta_r(Double t);
Complex theta(Double t);
Double remain(Double t);
void init_klog0();
Double block0_r(Double t,int start, int end);
Double blfi_fun(int i,int j,int n,int ll,int md);
Complex blfi_inter(Double t,Double v_denom,int i,int j,int ll, int &success);
void init_blfi(Double t);
void init_arrays(int md);
void clean_arrays(int md);
void initialize(Double t);
int check();
void init_blfi_simulate();
int initialize_all(Double t,int md);
int check1(Double t, int length0);
Complex my_zeta(Double t,int &success);
void output_detail(Double t);
int set_up(Double t, Double error, Double input_mean_spacing_given);
Complex rs(Double t, Double error_given, Double input_mean_spacing_given, int &success, const char *return_type="pure");


#endif
