/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.model.parameter;

import java.util.Collections;
import java.util.Set;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.sejda.common.collection.NullSafeSet;
import org.sejda.model.RectangularBox;
import org.sejda.model.parameter.base.SinglePdfSourceSingleOutputParameters;
import org.sejda.model.pdf.form.AcroFormPolicy;
import org.sejda.model.validation.constraint.NotEmpty;
import org.sejda.model.validation.constraint.SingleOutputAllowedExtensions;

@SingleOutputAllowedExtensions
public class CropParameters
extends SinglePdfSourceSingleOutputParameters {
    @Valid
    @NotEmpty
    private final Set<RectangularBox> cropAreas = new NullSafeSet<RectangularBox>();
    @NotNull
    private AcroFormPolicy acroFormPolicy = AcroFormPolicy.MERGE;

    public Set<RectangularBox> getCropAreas() {
        return Collections.unmodifiableSet(this.cropAreas);
    }

    public void clearCropAreas() {
        this.cropAreas.clear();
    }

    public void addCropArea(RectangularBox area) {
        this.cropAreas.add(area);
    }

    public AcroFormPolicy getAcroFormPolicy() {
        return this.acroFormPolicy;
    }

    public void setAcroFormPolicy(AcroFormPolicy acroFormPolicy) {
        this.acroFormPolicy = acroFormPolicy;
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append(this.cropAreas).append(this.acroFormPolicy).toHashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CropParameters)) {
            return false;
        }
        CropParameters parameter = (CropParameters)other;
        return new EqualsBuilder().appendSuper(super.equals(other)).append(this.cropAreas, parameter.cropAreas).append(this.acroFormPolicy, parameter.acroFormPolicy).isEquals();
    }
}

