/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.details.jdk.ui;

import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.BoundedRangeModel;
import javax.swing.Box;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollBar;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JToolBar;
import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.modules.profiler.heapwalk.details.jdk.ui.BaseBuilders;
import org.netbeans.modules.profiler.heapwalk.details.jdk.ui.ComponentBuilders;
import org.netbeans.modules.profiler.heapwalk.details.jdk.ui.Utils;
import org.netbeans.modules.profiler.heapwalk.details.spi.DetailsUtils;

final class JComponentBuilders {
    JComponentBuilders() {
    }

    static ComponentBuilders.ComponentBuilder getBuilder(Instance instance, Heap heap) {
        if (DetailsUtils.isSubclassOf(instance, JLabel.class.getName())) {
            return new JLabelBuilder(instance, heap);
        }
        if (DetailsUtils.isSubclassOf(instance, JPanel.class.getName())) {
            return new JPanelBuilder(instance, heap);
        }
        if (DetailsUtils.isSubclassOf(instance, JToolBar.class.getName())) {
            return new JToolBarBuilder(instance, heap);
        }
        if (DetailsUtils.isSubclassOf(instance, Box.Filler.class.getName())) {
            return new BoxFillerBuilder(instance, heap);
        }
        if (DetailsUtils.isSubclassOf(instance, Box.class.getName())) {
            return new BoxBuilder(instance, heap);
        }
        if (DetailsUtils.isSubclassOf(instance, JScrollBar.class.getName())) {
            return new JScrollBarBuilder(instance, heap);
        }
        if (DetailsUtils.isSubclassOf(instance, JToolBar.Separator.class.getName())) {
            return new JToolBarSeparatorBuilder(instance, heap);
        }
        if (DetailsUtils.isSubclassOf(instance, JPopupMenu.Separator.class.getName())) {
            return new JPopupMenuSeparatorBuilder(instance, heap);
        }
        if (DetailsUtils.isSubclassOf(instance, JSeparator.class.getName())) {
            return new JSeparatorBuilder(instance, heap);
        }
        if (DetailsUtils.isSubclassOf(instance, JProgressBar.class.getName())) {
            return new JProgressBarBuilder(instance, heap);
        }
        if (DetailsUtils.isSubclassOf(instance, JSlider.class.getName())) {
            return new JSliderBuilder(instance, heap);
        }
        if (DetailsUtils.isSubclassOf(instance, JSpinner.class.getName())) {
            return new JSpinnerBuilder(instance, heap);
        }
        if (DetailsUtils.isSubclassOf(instance, JPopupMenu.class.getName())) {
            return new JPopupMenuBuilder(instance, heap);
        }
        return null;
    }

    private static Number getNumber(Instance instance, Heap heap) {
        if (!DetailsUtils.isSubclassOf(instance, Number.class.getName())) {
            return null;
        }
        String string = DetailsUtils.getInstanceString(instance, heap);
        if (string == null || string.isEmpty()) {
            return null;
        }
        try {
            if (DetailsUtils.isSubclassOf(instance, Integer.class.getName())) {
                return Integer.valueOf(string);
            }
            if (DetailsUtils.isSubclassOf(instance, Byte.class.getName())) {
                return Byte.valueOf(string);
            }
            if (DetailsUtils.isSubclassOf(instance, Short.class.getName())) {
                return Short.valueOf(string);
            }
            if (DetailsUtils.isSubclassOf(instance, Long.class.getName())) {
                return Long.valueOf(string);
            }
            if (DetailsUtils.isSubclassOf(instance, Float.class.getName())) {
                return Float.valueOf(string);
            }
            if (DetailsUtils.isSubclassOf(instance, Double.class.getName())) {
                return Double.valueOf(string);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return null;
    }

    private static class JPopupMenuBuilder
    extends ComponentBuilders.JComponentBuilder<JPopupMenu> {
        private final String label;
        private final boolean paintBorder;

        JPopupMenuBuilder(Instance instance, Heap heap) {
            super(instance, heap);
            this.label = Utils.getFieldString(instance, "label");
            this.paintBorder = DetailsUtils.getBooleanFieldValue(instance, "paintBorder", true);
        }

        @Override
        protected void setupInstance(JPopupMenu jPopupMenu) {
            super.setupInstance(jPopupMenu);
            if (this.label != null) {
                jPopupMenu.setLabel(this.label);
            }
            jPopupMenu.setBorderPainted(this.paintBorder);
        }

        @Override
        protected JPopupMenu createInstanceImpl() {
            return new Utils.JPopupMenuImpl();
        }
    }

    private static class JSpinnerBuilder
    extends ComponentBuilders.JComponentBuilder<JSpinner> {
        private Number value;

        JSpinnerBuilder(Instance instance, Heap heap) {
            super(instance, heap, false);
            Object object;
            Number number = null;
            Object object2 = instance.getValueOfField("model");
            if (object2 instanceof Instance && (object = ((Instance)object2).getValueOfField("value")) instanceof Instance) {
                number = JComponentBuilders.getNumber((Instance)object, heap);
            }
            this.value = number;
        }

        @Override
        protected void setupInstance(JSpinner jSpinner) {
            super.setupInstance(jSpinner);
            if (this.value != null) {
                jSpinner.setValue(this.value);
            }
        }

        @Override
        protected JSpinner createInstanceImpl() {
            return new JSpinner();
        }
    }

    private static class JSliderBuilder
    extends ComponentBuilders.JComponentBuilder<JSlider> {
        private final boolean paintTicks;
        private final boolean paintTrack;
        private final boolean paintLabels;
        private final boolean isInverted;
        private final DefaultBoundedRangeModelBuilder sliderModel;
        private final int majorTickSpacing;
        private final int minorTickSpacing;
        private final boolean snapToTicks;
        private final int orientation;

        JSliderBuilder(Instance instance, Heap heap) {
            super(instance, heap, false);
            this.paintTicks = DetailsUtils.getBooleanFieldValue(instance, "paintTicks", false);
            this.paintTrack = DetailsUtils.getBooleanFieldValue(instance, "paintTrack", true);
            this.paintLabels = DetailsUtils.getBooleanFieldValue(instance, "paintLabels", false);
            this.isInverted = DetailsUtils.getBooleanFieldValue(instance, "isInverted", false);
            this.sliderModel = DefaultBoundedRangeModelBuilder.fromField(instance, "sliderModel", heap);
            this.majorTickSpacing = DetailsUtils.getIntFieldValue(instance, "majorTickSpacing", 0);
            this.minorTickSpacing = DetailsUtils.getIntFieldValue(instance, "minorTickSpacing", 0);
            this.snapToTicks = DetailsUtils.getBooleanFieldValue(instance, "snapToTicks", false);
            this.orientation = DetailsUtils.getIntFieldValue(instance, "orientation", 0);
        }

        @Override
        protected void setupInstance(JSlider jSlider) {
            super.setupInstance(jSlider);
            jSlider.setPaintTicks(this.paintTicks);
            jSlider.setPaintTrack(this.paintTrack);
            jSlider.setPaintLabels(this.paintLabels);
            jSlider.setInverted(this.isInverted);
            if (this.sliderModel != null) {
                jSlider.setModel((BoundedRangeModel)this.sliderModel.createInstance());
            }
            jSlider.setMajorTickSpacing(this.majorTickSpacing);
            jSlider.setMinorTickSpacing(this.minorTickSpacing);
            jSlider.setSnapToTicks(this.snapToTicks);
        }

        @Override
        protected JSlider createInstanceImpl() {
            return new JSlider(this.orientation);
        }
    }

    private static class JProgressBarBuilder
    extends ComponentBuilders.JComponentBuilder<JProgressBar> {
        private final int orientation;
        private final boolean paintBorder;
        private final DefaultBoundedRangeModelBuilder model;
        private final String progressString;
        private final boolean paintString;
        private final boolean indeterminate;

        JProgressBarBuilder(Instance instance, Heap heap) {
            super(instance, heap, false);
            this.orientation = DetailsUtils.getIntFieldValue(instance, "orientation", 0);
            this.paintBorder = DetailsUtils.getBooleanFieldValue(instance, "paintBorder", true);
            this.model = DefaultBoundedRangeModelBuilder.fromField(instance, "model", heap);
            this.progressString = Utils.getFieldString(instance, "progressString");
            this.paintString = DetailsUtils.getBooleanFieldValue(instance, "paintString", false);
            this.indeterminate = DetailsUtils.getBooleanFieldValue(instance, "indeterminate", false);
        }

        @Override
        protected void setupInstance(JProgressBar jProgressBar) {
            super.setupInstance(jProgressBar);
            jProgressBar.setBorderPainted(this.paintBorder);
            if (this.model != null) {
                jProgressBar.setModel((BoundedRangeModel)this.model.createInstance());
            }
            if (this.progressString != null) {
                jProgressBar.setString(this.progressString);
            }
            jProgressBar.setStringPainted(this.paintString);
            jProgressBar.setIndeterminate(this.indeterminate);
        }

        @Override
        protected JProgressBar createInstanceImpl() {
            return new JProgressBar(this.orientation);
        }
    }

    private static class JPopupMenuSeparatorBuilder
    extends JSeparatorBuilder {
        JPopupMenuSeparatorBuilder(Instance instance, Heap heap) {
            super(instance, heap);
        }

        @Override
        protected JSeparator createInstanceImpl() {
            return new JPopupMenu.Separator();
        }
    }

    private static class JToolBarSeparatorBuilder
    extends JSeparatorBuilder {
        private final BaseBuilders.DimensionBuilder separatorSize;

        JToolBarSeparatorBuilder(Instance instance, Heap heap) {
            super(instance, heap);
            this.separatorSize = BaseBuilders.DimensionBuilder.fromField(instance, "separatorSize", heap);
        }

        @Override
        protected JSeparator createInstanceImpl() {
            return this.separatorSize == null ? new JToolBar.Separator() : new JToolBar.Separator((Dimension)this.separatorSize.createInstance());
        }
    }

    private static class JSeparatorBuilder
    extends ComponentBuilders.JComponentBuilder<JSeparator> {
        private final int orientation;

        JSeparatorBuilder(Instance instance, Heap heap) {
            super(instance, heap, false);
            this.orientation = DetailsUtils.getIntFieldValue(instance, "orientation", 0);
        }

        @Override
        protected JSeparator createInstanceImpl() {
            return new JSeparator(this.orientation);
        }
    }

    private static class JScrollBarBuilder
    extends ComponentBuilders.JComponentBuilder<JScrollBar> {
        private final DefaultBoundedRangeModelBuilder model;
        private final int orientation;

        JScrollBarBuilder(Instance instance, Heap heap) {
            super(instance, heap, false);
            this.model = DefaultBoundedRangeModelBuilder.fromField(instance, "model", heap);
            this.orientation = DetailsUtils.getIntFieldValue(instance, "orientation", 1);
        }

        static JScrollBarBuilder fromField(Instance instance, String string, Heap heap) {
            Object object = instance.getValueOfField(string);
            if (!(object instanceof Instance)) {
                return null;
            }
            return new JScrollBarBuilder((Instance)object, heap);
        }

        @Override
        protected void setupInstance(JScrollBar jScrollBar) {
            super.setupInstance(jScrollBar);
            if (this.model != null) {
                jScrollBar.setModel((BoundedRangeModel)this.model.createInstance());
            }
        }

        @Override
        protected JScrollBar createInstanceImpl() {
            return new JScrollBar(this.orientation);
        }
    }

    private static class DefaultBoundedRangeModelBuilder
    extends Utils.InstanceBuilder<DefaultBoundedRangeModel> {
        private final int value;
        private final int extent;
        private final int min;
        private final int max;

        DefaultBoundedRangeModelBuilder(Instance instance, Heap heap) {
            super(instance, heap);
            this.value = DetailsUtils.getIntFieldValue(instance, "value", 0);
            this.extent = DetailsUtils.getIntFieldValue(instance, "extent", 0);
            this.min = DetailsUtils.getIntFieldValue(instance, "min", 0);
            this.max = DetailsUtils.getIntFieldValue(instance, "max", 100);
        }

        static DefaultBoundedRangeModelBuilder fromField(Instance instance, String string, Heap heap) {
            Object object = instance.getValueOfField(string);
            if (!(object instanceof Instance)) {
                return null;
            }
            if (!DetailsUtils.isSubclassOf((Instance)object, DefaultBoundedRangeModel.class.getName())) {
                return null;
            }
            return new DefaultBoundedRangeModelBuilder((Instance)object, heap);
        }

        @Override
        protected DefaultBoundedRangeModel createInstanceImpl() {
            return new DefaultBoundedRangeModel(this.value, this.extent, this.min, this.max);
        }
    }

    private static class BoxFillerBuilder
    extends ComponentBuilders.JComponentBuilder<Box.Filler> {
        BoxFillerBuilder(Instance instance, Heap heap) {
            super(instance, heap);
        }

        @Override
        protected Box.Filler createInstanceImpl() {
            return new Box.Filler(null, null, null);
        }
    }

    private static class BoxBuilder
    extends ComponentBuilders.JComponentBuilder<Box> {
        BoxBuilder(Instance instance, Heap heap) {
            super(instance, heap);
        }

        @Override
        protected Box createInstanceImpl() {
            return new Box(0){

                @Override
                public void layout() {
                }

                @Override
                public void setLayout(LayoutManager layoutManager) {
                }
            };
        }
    }

    private static class JToolBarBuilder
    extends ComponentBuilders.JComponentBuilder<JToolBar> {
        private final boolean paintBorder;
        private final BaseBuilders.InsetsBuilder margin;
        private final boolean floatable;
        private final int orientation;

        JToolBarBuilder(Instance instance, Heap heap) {
            super(instance, heap);
            this.paintBorder = DetailsUtils.getBooleanFieldValue(instance, "paintBorder", true);
            this.margin = BaseBuilders.InsetsBuilder.fromField(instance, "margin", heap);
            this.floatable = DetailsUtils.getBooleanFieldValue(instance, "floatable", true);
            this.orientation = DetailsUtils.getIntFieldValue(instance, "orientation", 0);
        }

        @Override
        protected void setupInstance(JToolBar jToolBar) {
            super.setupInstance(jToolBar);
            jToolBar.setBorderPainted(this.paintBorder);
            if (this.margin != null) {
                jToolBar.setMargin((Insets)this.margin.createInstance());
            }
            jToolBar.setFloatable(this.floatable);
            jToolBar.setOrientation(this.orientation);
        }

        @Override
        protected JToolBar createInstanceImpl() {
            return new JToolBar();
        }
    }

    private static class JPanelBuilder
    extends ComponentBuilders.JComponentBuilder<JPanel> {
        JPanelBuilder(Instance instance, Heap heap) {
            super(instance, heap);
        }

        @Override
        protected JPanel createInstanceImpl() {
            return new JPanel(null);
        }
    }

    private static final class JLabelBuilder
    extends ComponentBuilders.JComponentBuilder<JLabel> {
        private final String text;
        private final BaseBuilders.IconBuilder defaultIcon;
        private final int verticalAlignment;
        private final int horizontalAlignment;
        private final int verticalTextPosition;
        private final int horizontalTextPosition;
        private final int iconTextGap;

        JLabelBuilder(Instance instance, Heap heap) {
            super(instance, heap, false);
            this.text = Utils.getFieldString(instance, "text");
            this.defaultIcon = BaseBuilders.IconBuilder.fromField(instance, "defaultIcon", heap);
            this.verticalAlignment = DetailsUtils.getIntFieldValue(instance, "verticalAlignment", 0);
            this.horizontalAlignment = DetailsUtils.getIntFieldValue(instance, "horizontalAlignment", 10);
            this.verticalTextPosition = DetailsUtils.getIntFieldValue(instance, "verticalTextPosition", 0);
            this.horizontalTextPosition = DetailsUtils.getIntFieldValue(instance, "horizontalTextPosition", 11);
            this.iconTextGap = DetailsUtils.getIntFieldValue(instance, "iconTextGap", 4);
        }

        @Override
        protected void setupInstance(JLabel jLabel) {
            super.setupInstance(jLabel);
            jLabel.setText(this.text);
            if (this.defaultIcon != null) {
                jLabel.setIcon((Icon)this.defaultIcon.createInstance());
            }
            jLabel.setVerticalAlignment(this.verticalAlignment);
            jLabel.setHorizontalAlignment(this.horizontalAlignment);
            jLabel.setVerticalTextPosition(this.verticalTextPosition);
            jLabel.setHorizontalTextPosition(this.horizontalTextPosition);
            jLabel.setIconTextGap(this.iconTextGap);
        }

        @Override
        protected JLabel createInstanceImpl() {
            return new JLabel();
        }
    }
}

