/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.bundling;

import groovy.lang.Closure;
import java.io.File;
import org.gradle.api.tasks.AbstractCopyTask;
import org.gradle.api.tasks.OutputFile;
import org.gradle.util.GUtil;

public abstract class AbstractArchiveTask
extends AbstractCopyTask {
    private File destinationDir;
    private String customName;
    private String baseName;
    private String appendix;
    private String version;
    private String extension;
    private String classifier = "";

    public String getArchiveName() {
        if (this.customName != null) {
            return this.customName;
        }
        String name = (String)GUtil.elvis((Object)this.getBaseName(), (Object)"") + this.maybe(this.getBaseName(), this.getAppendix());
        name = name + this.maybe(name, this.getVersion());
        name = name + this.maybe(name, this.getClassifier());
        name = name + (GUtil.isTrue((Object)this.getExtension()) ? "." + this.getExtension() : "");
        return name;
    }

    public void setArchiveName(String name) {
        this.customName = name;
    }

    private String maybe(String prefix, String value) {
        if (GUtil.isTrue((Object)value)) {
            if (GUtil.isTrue((Object)prefix)) {
                return "-".concat(value);
            }
            return value;
        }
        return "";
    }

    @OutputFile
    public File getArchivePath() {
        return new File(this.getDestinationDir(), this.getArchiveName());
    }

    public File getDestinationDir() {
        return this.destinationDir;
    }

    public void setDestinationDir(File destinationDir) {
        this.destinationDir = destinationDir;
    }

    public String getBaseName() {
        return this.baseName;
    }

    public void setBaseName(String baseName) {
        this.baseName = baseName;
    }

    public String getAppendix() {
        return this.appendix;
    }

    public void setAppendix(String appendix) {
        this.appendix = appendix;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getExtension() {
        return this.extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public void setClassifier(String classifier) {
        this.classifier = classifier;
    }

    public AbstractArchiveTask into(Object destPath) {
        super.into(destPath);
        return this;
    }

    public AbstractArchiveTask into(Object destPath, Closure configureClosure) {
        super.into(destPath, configureClosure);
        return this;
    }
}

