/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.output;

import java.io.IOException;
import org.sejda.io.CountingWritableByteChannel;
import org.sejda.io.DevNullWritableByteChannel;
import org.sejda.sambox.cos.COSBase;
import org.sejda.sambox.cos.COSDictionary;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.cos.COSObjectable;
import org.sejda.sambox.cos.COSStream;
import org.sejda.sambox.cos.IndirectCOSObjectReference;
import org.sejda.sambox.output.AbstractPDFBodyWriter;
import org.sejda.sambox.output.IndirectObjectsWriter;
import org.sejda.sambox.output.PDFWriteContext;
import org.sejda.sambox.output.WriteOption;
import org.sejda.sambox.pdmodel.PDPage;
import org.sejda.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExistingPagesSizePredictor
extends AbstractPDFBodyWriter {
    private static final Logger LOG = LoggerFactory.getLogger(ExistingPagesSizePredictor.class);
    private static final int STREAM_WRAPPING_SIZE = 19;
    private IndirectObjectsWriter writer;
    private CountingWritableByteChannel channel = CountingWritableByteChannel.from(new DevNullWritableByteChannel());
    private long streamsSize;
    private long pages;

    public ExistingPagesSizePredictor(WriteOption ... opts) {
        super(new PDFWriteContext(null, opts));
        this.writer = new IndirectObjectsWriter(this.channel, this.context()){

            @Override
            protected void onWritten(IndirectCOSObjectReference ref) {
            }
        };
    }

    public void addPage(PDPage page) throws IOException {
        if (page != null) {
            ++this.pages;
            COSDictionary pageCopy = page.getCOSObject().duplicate();
            pageCopy.removeItem(COSName.PARENT);
            this.createIndirectReferenceIfNeededFor(pageCopy);
            this.startWriting();
            LOG.debug("Page {} addition simulated, now at {} body bytes and {} xref bytes", page, this.predictedPagesSize(), this.predictedXrefTableSize());
        }
    }

    public void addIndirectReferenceFor(COSObjectable value) throws IOException {
        if (value != null) {
            this.createIndirectReferenceIfNeededFor(value.getCOSObject());
            this.startWriting();
            LOG.debug("{} addition simulated, now at {} body bytes and {} xref bytes", value.getCOSObject(), this.predictedPagesSize(), this.predictedXrefTableSize());
        }
    }

    public long predictedPagesSize() throws IOException {
        this.writer.writer().writer().flush();
        return this.streamsSize + this.channel.count();
    }

    public long predictedXrefTableSize() {
        return 21 * (this.context().written() + 1) + 10;
    }

    @Override
    void writeObject(IndirectCOSObjectReference ref) throws IOException {
        COSBase wrapped;
        if (!this.context().hasWritten(ref.xrefEntry()) && (wrapped = ref.getCOSObject().getCOSObject()) instanceof COSStream) {
            COSStream stream = (COSStream)wrapped;
            this.streamsSize += stream.getFilteredLength();
            this.streamsSize += 19L;
            ref.setValue(stream.duplicate());
        }
        this.writer.writeObject(ref);
    }

    @Override
    void onCompletion() {
    }

    public boolean hasPages() {
        return this.pages > 0L;
    }

    public long pages() {
        return this.pages;
    }

    @Override
    public void close() throws IOException {
        super.close();
        IOUtils.close(this.writer);
    }
}

