/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.cpu;

import java.text.NumberFormat;
import org.netbeans.lib.profiler.results.CCTNode;
import org.netbeans.lib.profiler.results.ExportDataDumper;
import org.netbeans.lib.profiler.results.cpu.CPUCCTContainer;
import org.netbeans.lib.profiler.results.cpu.PrestimeCPUCCTNode;

public class PrestimeCPUCCTNodeFree
extends PrestimeCPUCCTNode {
    private static NumberFormat percentFormat = null;
    protected int methodId;
    protected int nCalls;
    protected long sleepTime0;
    protected long totalTime0;
    protected long totalTime1;
    protected long waitTime0;

    protected PrestimeCPUCCTNodeFree(CPUCCTContainer cPUCCTContainer, PrestimeCPUCCTNode prestimeCPUCCTNode, int n) {
        super(cPUCCTContainer, prestimeCPUCCTNode);
        this.methodId = n;
    }

    @Override
    public CCTNode getChild(int n) {
        return this.children[n];
    }

    @Override
    public CCTNode[] getChildren() {
        return this.children;
    }

    public void setMethodId(int n) {
        this.methodId = n;
    }

    @Override
    public int getMethodId() {
        return this.methodId;
    }

    @Override
    public int getNCalls() {
        return this.nCalls;
    }

    @Override
    public int getNChildren() {
        return this.children != null ? this.children.length : 0;
    }

    @Override
    public long getSleepTime0() {
        return 0L;
    }

    @Override
    public int getThreadId() {
        return this.container.getThreadId();
    }

    @Override
    public long getTotalTime0() {
        return this.totalTime0;
    }

    @Override
    public float getTotalTime0InPerCent() {
        float f = (float)((double)this.totalTime0 / (double)this.container.getWholeGraphNetTime0() * 100.0);
        return f < 100.0f ? f : 100.0f;
    }

    @Override
    public long getTotalTime1() {
        return this.totalTime1;
    }

    @Override
    public float getTotalTime1InPerCent() {
        return (float)((double)this.totalTime1 / (double)this.container.getWholeGraphNetTime1() * 100.0);
    }

    @Override
    public long getWaitTime0() {
        return 0L;
    }

    void merge(PrestimeCPUCCTNodeFree prestimeCPUCCTNodeFree) {
        this.addNCalls(prestimeCPUCCTNodeFree.getNCalls());
        this.addSleepTime0(prestimeCPUCCTNodeFree.getSleepTime0());
        this.addTotalTime0(prestimeCPUCCTNodeFree.getTotalTime0());
        this.addTotalTime1(prestimeCPUCCTNodeFree.getTotalTime1());
        this.addWaitTime0(prestimeCPUCCTNodeFree.getWaitTime0());
        if (prestimeCPUCCTNodeFree.children != null) {
            for (PrestimeCPUCCTNode prestimeCPUCCTNode : prestimeCPUCCTNodeFree.children) {
                prestimeCPUCCTNode.parent = this;
            }
            int n = this.children == null ? 0 : this.children.length;
            int n2 = prestimeCPUCCTNodeFree.children.length;
            PrestimeCPUCCTNodeFree[] prestimeCPUCCTNodeFreeArray = new PrestimeCPUCCTNodeFree[n + n2];
            if (this.children != null) {
                System.arraycopy(this.children, 0, prestimeCPUCCTNodeFreeArray, 0, n);
            }
            System.arraycopy(prestimeCPUCCTNodeFree.children, 0, prestimeCPUCCTNodeFreeArray, n, n2);
            this.children = prestimeCPUCCTNodeFreeArray;
        }
    }

    public void addChild(PrestimeCPUCCTNodeFree prestimeCPUCCTNodeFree) {
        if (this.children == null) {
            this.children = new PrestimeCPUCCTNodeFree[1];
        } else {
            PrestimeCPUCCTNodeFree[] prestimeCPUCCTNodeFreeArray = new PrestimeCPUCCTNodeFree[this.children.length + 1];
            System.arraycopy(this.children, 0, prestimeCPUCCTNodeFreeArray, 0, this.children.length);
            this.children = prestimeCPUCCTNodeFreeArray;
        }
        this.children[this.children.length - 1] = prestimeCPUCCTNodeFree;
    }

    public void addNCalls(int n) {
        this.nCalls += n;
    }

    public void addSleepTime0(long l) {
        this.sleepTime0 += l;
    }

    public void addTotalTime0(long l) {
        this.totalTime0 += l;
    }

    public void addTotalTime1(long l) {
        this.totalTime1 += l;
    }

    public void addWaitTime0(long l) {
        this.waitTime0 += l;
    }

    public PrestimeCPUCCTNodeFree createChildlessCopy() {
        try {
            PrestimeCPUCCTNodeFree prestimeCPUCCTNodeFree = (PrestimeCPUCCTNodeFree)this.clone();
            prestimeCPUCCTNodeFree.children = null;
            return prestimeCPUCCTNodeFree;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    @Override
    public void sortChildren(int n, boolean bl) {
        if (this.children != null) {
            this.doSortChildren(n, bl);
        }
    }

    public void exportXMLData(ExportDataDumper exportDataDumper, String string) {
        String string2 = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer(string + "<node>" + string2);
        stringBuffer.append(string).append(" <Name>").append(this.replaceHTMLCharacters(this.getNodeName())).append("</Name>").append(string2);
        stringBuffer.append(string).append(" <Parent>").append(this.replaceHTMLCharacters(this.getParent() == null ? "none" : ((PrestimeCPUCCTNodeFree)this.getParent()).getNodeName())).append("</Parent>").append(string2);
        stringBuffer.append(string).append(" <Time_Relative>").append(percentFormat.format((double)this.getTotalTime0InPerCent() / 100.0)).append("</Time_Relative>").append(string2);
        stringBuffer.append(string).append(" <Time>").append(this.getTotalTime0()).append("</Time>").append(string2);
        if (this.container.collectingTwoTimeStamps) {
            stringBuffer.append(string).append(" <Time-CPU>").append(this.getTotalTime1()).append("</Time-CPU>").append(string2);
        }
        stringBuffer.append(string).append(" <Invocations>").append(this.getNCalls()).append("</Invocations>").append(string2);
        exportDataDumper.dumpData(stringBuffer);
        if (this.children != null) {
            for (int i = 0; i < this.getNChildren(); ++i) {
                ((PrestimeCPUCCTNodeFree)this.children[i]).exportXMLData(exportDataDumper, string + "  ");
            }
        }
        stringBuffer = new StringBuffer(string + "</node>");
        exportDataDumper.dumpData(stringBuffer);
    }

    public void exportHTMLData(ExportDataDumper exportDataDumper, int n) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer("<tr><td class=\"method\"><pre class=\"method\">");
        for (n2 = 0; n2 < n; ++n2) {
            stringBuffer.append(".");
        }
        stringBuffer.append(this.replaceHTMLCharacters(this.getNodeName())).append("</pre></td><td class=\"right\">").append(percentFormat.format((double)this.getTotalTime0InPerCent() / 100.0)).append("</td><td class=\"right\">").append(this.getTotalTime0());
        if (this.container.collectingTwoTimeStamps) {
            stringBuffer.append("</td><td class=\"right\">").append(this.getTotalTime1());
        }
        stringBuffer.append("</td><td class=\"right\">").append(this.getNCalls()).append("</td></tr>");
        exportDataDumper.dumpData(stringBuffer);
        if (this.children != null) {
            for (n2 = 0; n2 < this.getNChildren(); ++n2) {
                ((PrestimeCPUCCTNodeFree)this.children[n2]).exportHTMLData(exportDataDumper, n + 1);
            }
        }
    }

    private String replaceHTMLCharacters(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = string.length();
        block6: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '<': {
                    stringBuilder.append("&lt;");
                    continue block6;
                }
                case '>': {
                    stringBuilder.append("&gt;");
                    continue block6;
                }
                case '&': {
                    stringBuilder.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    stringBuilder.append("&quot;");
                    continue block6;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }

    public void exportCSVData(String string, int n, ExportDataDumper exportDataDumper) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = "\r\n";
        String string3 = "\"";
        String string4 = " ";
        stringBuffer.append(string3);
        for (n2 = 0; n2 < n; ++n2) {
            stringBuffer.append(string4);
        }
        stringBuffer.append(this.getNodeName()).append(string3).append(string);
        stringBuffer.append(string3).append(this.getTotalTime0InPerCent()).append(string3).append(string);
        stringBuffer.append(string3).append(this.getTotalTime0()).append(string3).append(string);
        if (this.container.collectingTwoTimeStamps) {
            stringBuffer.append(string3).append(this.getTotalTime1()).append(string3).append(string);
        }
        stringBuffer.append(string3).append(this.getNCalls()).append(string3).append(string2);
        exportDataDumper.dumpData(stringBuffer);
        if (this.children != null) {
            for (n2 = 0; n2 < this.getNChildren(); ++n2) {
                ((PrestimeCPUCCTNodeFree)this.children[n2]).exportCSVData(string, n + 1, exportDataDumper);
            }
        }
    }

    public static void setPercentFormat(NumberFormat numberFormat) {
        percentFormat = numberFormat;
    }
}

