/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.tasks;

import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskListener;

public final class LoggingTaskListener<Response>
implements TaskListener<Response> {
    private static final ESLogger logger = Loggers.getLogger(LoggingTaskListener.class);
    private static final LoggingTaskListener<Object> INSTANCE = new LoggingTaskListener();

    public static <Response> TaskListener<Response> instance() {
        return INSTANCE;
    }

    private LoggingTaskListener() {
    }

    @Override
    public void onResponse(Task task, Response response) {
        logger.info("{} finished with response {}", task.getId(), response);
    }

    @Override
    public void onFailure(Task task, Throwable e) {
        logger.warn("{} failed with exception", e, task.getId());
    }
}

