/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.reindex;

import java.io.IOException;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.index.reindex.AbstractBulkByScrollRequest;
import org.elasticsearch.script.Script;

public abstract class AbstractBulkIndexByScrollRequest<Self extends AbstractBulkIndexByScrollRequest<Self>>
extends AbstractBulkByScrollRequest<Self> {
    private Script script;

    public AbstractBulkIndexByScrollRequest() {
    }

    public AbstractBulkIndexByScrollRequest(SearchRequest source) {
        super(source);
    }

    public Script getScript() {
        return this.script;
    }

    public Self setScript(@Nullable Script script) {
        this.script = script;
        return (Self)((Object)((AbstractBulkIndexByScrollRequest)((Object)this.self())));
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        if (in.readBoolean()) {
            this.script = Script.readScript((StreamInput)in);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeOptionalStreamable((Streamable)this.script);
    }

    @Override
    protected void searchToString(StringBuilder b) {
        super.searchToString(b);
        if (this.script != null) {
            b.append(" updated with [").append(this.script).append(']');
        }
    }
}

