/******************************************************************************
 * This file is part of the Gluon Development Platform
 * Copyright (c) 2010 Arjen Hiemstra <ahiemstra@heimr.nl>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef GLUON_CORE_GLOBAL_H
#define GLUON_CORE_GLOBAL_H

#define GLUON_INSTALL_PREFIX    QString("/usr")
#define GLUON_SHARE_INSTALL_DIR QString("/usr/share")
#define GLUON_LIB_INSTALL_DIR   QString("/usr/lib")

#define GLUON_VERSION_MAJOR     0
#define GLUON_VERSION_MINOR     71
#define GLUON_VERSION_PATCH     0
#define GLUON_VERSION_NAME      QString("Electron")
#define GLUON_VERSION_STRING    QString("0.71.0")

#define GLUON_PLATFORM_NAME     "Gluon Development Platform"

#include <QtCore/QString>

namespace GluonCore
{
    class Global
    {
        public:
            static QString installPrefix()
            {
                return GLUON_INSTALL_PREFIX;
            }

            static QString dataDirectory()
            {
                return GLUON_SHARE_INSTALL_DIR;
            }

            static QString libDirectory()
            {
                return GLUON_LIB_INSTALL_DIR;
            }

            static QString versionString()
            {
                return GLUON_VERSION_STRING;
            }
    };
}

#endif
