/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.local;

import java.util.LinkedList;
import java.util.List;
import org.gradle.internal.hash.HashValue;
import org.gradle.internal.resource.local.LocallyAvailableResource;
import org.gradle.internal.resource.local.LocallyAvailableResourceCandidates;
import org.gradle.internal.resource.local.LocallyAvailableResourceFinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeLocallyAvailableResourceFinder<C>
implements LocallyAvailableResourceFinder<C> {
    private final List<LocallyAvailableResourceFinder<C>> composites;

    public CompositeLocallyAvailableResourceFinder(List<LocallyAvailableResourceFinder<C>> composites) {
        this.composites = composites;
    }

    @Override
    public LocallyAvailableResourceCandidates findCandidates(C criterion) {
        LinkedList<LocallyAvailableResourceCandidates> allCandidates = new LinkedList<LocallyAvailableResourceCandidates>();
        for (LocallyAvailableResourceFinder<C> finder : this.composites) {
            allCandidates.add(finder.findCandidates(criterion));
        }
        return new CompositeLocallyAvailableResourceCandidates(allCandidates);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CompositeLocallyAvailableResourceCandidates
    implements LocallyAvailableResourceCandidates {
        private final List<LocallyAvailableResourceCandidates> allCandidates;

        public CompositeLocallyAvailableResourceCandidates(List<LocallyAvailableResourceCandidates> allCandidates) {
            this.allCandidates = allCandidates;
        }

        @Override
        public boolean isNone() {
            for (LocallyAvailableResourceCandidates candidates : this.allCandidates) {
                if (candidates.isNone()) continue;
                return false;
            }
            return true;
        }

        @Override
        public LocallyAvailableResource findByHashValue(HashValue hashValue) {
            for (LocallyAvailableResourceCandidates candidates : this.allCandidates) {
                LocallyAvailableResource match = candidates.findByHashValue(hashValue);
                if (match == null) continue;
                return match;
            }
            return null;
        }
    }
}

