/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.validator;

import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.data.validation.util.MultipleNameVisitor;
import org.openstreetmap.josm.gui.dialogs.validator.ValidatorTreeRenderer;
import org.openstreetmap.josm.gui.preferences.validator.ValidatorPreference;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.tools.Destroyable;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.MultiMap;
import org.openstreetmap.josm.tools.Predicate;
import org.openstreetmap.josm.tools.Predicates;
import org.openstreetmap.josm.tools.Utils;

public class ValidatorTreePanel
extends JTree
implements Destroyable {
    protected DefaultTreeModel valTreeModel = new DefaultTreeModel(new DefaultMutableTreeNode());
    private transient List<TestError> errors = new ArrayList<TestError>();
    private transient Set<? extends OsmPrimitive> filter;
    private int updateCount;

    public ValidatorTreePanel(List<TestError> list) {
        ToolTipManager.sharedInstance().registerComponent(this);
        this.setModel(this.valTreeModel);
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.expandRow(0);
        this.setVisibleRowCount(8);
        this.setCellRenderer(new ValidatorTreeRenderer());
        this.getSelectionModel().setSelectionMode(4);
        this.setErrorList(list);
        for (KeyListener keyListener : this.getKeyListeners()) {
            if (!"javax.swing.plaf.basic.BasicTreeUI$Handler".equals(keyListener.getClass().getName())) continue;
            this.removeKeyListener(keyListener);
        }
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        String string = null;
        TreePath treePath = this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (treePath != null) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            Object object = defaultMutableTreeNode.getUserObject();
            if (object instanceof TestError) {
                TestError testError = (TestError)object;
                MultipleNameVisitor multipleNameVisitor = new MultipleNameVisitor();
                multipleNameVisitor.visit(testError.getPrimitives());
                string = "<html>" + multipleNameVisitor.getText() + "<br>" + testError.getMessage();
                String string2 = testError.getDescription();
                if (string2 != null) {
                    string = string + "<br>" + string2;
                }
                string = string + "</html>";
            } else {
                string = defaultMutableTreeNode.toString();
            }
        }
        return string;
    }

    public ValidatorTreePanel() {
        this((List<TestError>)null);
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            this.buildTree();
        } else {
            this.valTreeModel.setRoot(new DefaultMutableTreeNode());
        }
        super.setVisible(bl);
    }

    public void buildTree() {
        Object object;
        Cloneable cloneable;
        Serializable serializable;
        ++this.updateCount;
        final DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode();
        if (this.errors == null || this.errors.isEmpty()) {
            GuiHelper.runInEDTAndWait(new Runnable(){

                @Override
                public void run() {
                    ValidatorTreePanel.this.valTreeModel.setRoot(defaultMutableTreeNode);
                }
            });
            return;
        }
        Collections.sort(this.errors);
        HashSet<Object> hashSet = new HashSet<Object>();
        Enumeration<TreePath> enumeration = this.getExpandedDescendants(new TreePath(this.getRoot()));
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                serializable = enumeration.nextElement();
                cloneable = (DefaultMutableTreeNode)((TreePath)serializable).getLastPathComponent();
                object = ((DefaultMutableTreeNode)cloneable).getUserObject();
                if (object instanceof Severity) {
                    hashSet.add(object);
                    continue;
                }
                if (!(object instanceof String)) continue;
                String string = (String)object;
                int n = string.lastIndexOf(" (");
                if (n > 0) {
                    string = string.substring(0, n);
                }
                hashSet.add(string);
            }
        }
        serializable = new EnumMap(Severity.class);
        cloneable = new EnumMap(Severity.class);
        for (Severity severity : Severity.values()) {
            serializable.put(severity, new MultiMap(20));
            cloneable.put(severity, new HashMap());
        }
        object = ValidatorPreference.PREF_OTHER.get();
        for (TestError testError : this.errors) {
            Severity severity;
            if (testError.isIgnored()) continue;
            severity = testError.getSeverity();
            if (!((Boolean)object).booleanValue() && severity == Severity.OTHER) continue;
            String string = testError.getDescription();
            Object object2 = testError.getMessage();
            if (this.filter != null) {
                boolean bl = false;
                for (OsmPrimitive object3 : testError.getPrimitives()) {
                    if (!this.filter.contains(object3)) continue;
                    bl = true;
                    break;
                }
                if (!bl) continue;
            }
            if (string != null) {
                MultiMap<String, TestError> multiMap = (MultiMap<String, TestError>)((HashMap)cloneable.get((Object)severity)).get(object2);
                if (multiMap == null) {
                    multiMap = new MultiMap<String, TestError>(20);
                    ((HashMap)cloneable.get((Object)severity)).put(object2, multiMap);
                }
                multiMap.put(string, testError);
                continue;
            }
            ((MultiMap)serializable.get((Object)severity)).put(object2, testError);
        }
        ArrayList arrayList = new ArrayList();
        for (Object object2 : Severity.values()) {
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            MultiMap multiMap = (MultiMap)serializable.get(object2);
            Map map = (Map)cloneable.get(object2);
            if (multiMap.isEmpty() && map.isEmpty()) continue;
            GroupTreeNode groupTreeNode = new GroupTreeNode(object2);
            defaultMutableTreeNode.add(groupTreeNode);
            if (hashSet.contains(object2)) {
                arrayList.add(new TreePath(new Object[]{defaultMutableTreeNode, groupTreeNode}));
            }
            for (Map.Entry entry : multiMap.entrySet()) {
                object6 = entry.getValue();
                object5 = I18n.tr("{0} ({1})", entry.getKey(), object6.size());
                DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(object5);
                groupTreeNode.add(defaultMutableTreeNode2);
                if (hashSet.contains(entry.getKey())) {
                    arrayList.add(new TreePath(new Object[]{defaultMutableTreeNode, groupTreeNode, defaultMutableTreeNode2}));
                }
                Iterator iterator = object6.iterator();
                while (iterator.hasNext()) {
                    object4 = (TestError)iterator.next();
                    object3 = new DefaultMutableTreeNode(object4);
                    defaultMutableTreeNode2.add((MutableTreeNode)object3);
                }
            }
            for (Map.Entry<Object, Set<Object>> entry : map.entrySet()) {
                object6 = (MultiMap)((Object)entry.getValue());
                object5 = null;
                if (((MultiMap)object6).size() > 1) {
                    object5 = new GroupTreeNode(entry.getKey());
                    groupTreeNode.add((MutableTreeNode)object5);
                    if (hashSet.contains(entry.getKey())) {
                        arrayList.add(new TreePath(new Object[]{defaultMutableTreeNode, groupTreeNode, object5}));
                    }
                }
                for (Map.Entry entry2 : ((MultiMap)object6).entrySet()) {
                    object4 = (Set)entry2.getValue();
                    object3 = object5 != null ? I18n.tr("{0} ({1})", entry2.getKey(), object4.size()) : I18n.tr("{0} - {1} ({2})", entry2.getKey(), entry.getKey(), object4.size());
                    DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(object3);
                    if (object5 != null) {
                        ((DefaultMutableTreeNode)object5).add(defaultMutableTreeNode3);
                    } else {
                        groupTreeNode.add(defaultMutableTreeNode3);
                    }
                    if (hashSet.contains(entry2.getKey())) {
                        if (object5 != null) {
                            arrayList.add(new TreePath(new Object[]{defaultMutableTreeNode, groupTreeNode, object5, defaultMutableTreeNode3}));
                        } else {
                            arrayList.add(new TreePath(new Object[]{defaultMutableTreeNode, groupTreeNode, defaultMutableTreeNode3}));
                        }
                    }
                    Iterator iterator = object4.iterator();
                    while (iterator.hasNext()) {
                        TestError testError = (TestError)iterator.next();
                        DefaultMutableTreeNode defaultMutableTreeNode4 = new DefaultMutableTreeNode(testError);
                        defaultMutableTreeNode3.add(defaultMutableTreeNode4);
                    }
                }
            }
        }
        this.valTreeModel.setRoot(defaultMutableTreeNode);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            TreePath treePath = (TreePath)iterator.next();
            this.expandPath(treePath);
        }
    }

    public final void setErrorList(List<TestError> list) {
        this.errors = list;
        if (this.isVisible()) {
            this.buildTree();
        }
    }

    public void setErrors(List<TestError> list) {
        if (this.errors == null) {
            return;
        }
        this.clearErrors();
        DataSet dataSet = Main.main.getCurrentDataSet();
        for (TestError testError : list) {
            if (testError.isIgnored()) continue;
            this.errors.add(testError);
            if (dataSet == null) continue;
            dataSet.addDataSetListener(testError);
        }
        if (this.isVisible()) {
            this.buildTree();
        }
    }

    public List<TestError> getErrors() {
        return this.errors != null ? this.errors : Collections.emptyList();
    }

    public void selectRelatedErrors(Collection<OsmPrimitive> collection) {
        ArrayList<TreePath> arrayList = new ArrayList<TreePath>();
        this.walkAndSelectRelatedErrors(new TreePath(this.getRoot()), Predicates.inCollection(new HashSet<OsmPrimitive>(collection)), arrayList);
        this.getSelectionModel().clearSelection();
        for (TreePath treePath : arrayList) {
            this.expandPath(treePath);
            this.getSelectionModel().addSelectionPath(treePath);
        }
    }

    private void walkAndSelectRelatedErrors(TreePath treePath, Predicate<OsmPrimitive> predicate, Collection<TreePath> collection) {
        int n = this.getModel().getChildCount(treePath.getLastPathComponent());
        for (int i = 0; i < n; ++i) {
            Object object = this.getModel().getChild(treePath.getLastPathComponent(), i);
            if (this.getModel().isLeaf(object) && object instanceof DefaultMutableTreeNode && ((DefaultMutableTreeNode)object).getUserObject() instanceof TestError) {
                TestError testError = (TestError)((DefaultMutableTreeNode)object).getUserObject();
                if (testError.getPrimitives() == null || !Utils.exists(testError.getPrimitives(), predicate)) continue;
                collection.add(treePath.pathByAddingChild(object));
                continue;
            }
            this.walkAndSelectRelatedErrors(treePath.pathByAddingChild(object), predicate, collection);
        }
    }

    public Set<? extends OsmPrimitive> getFilter() {
        return this.filter;
    }

    public void setFilter(Set<? extends OsmPrimitive> set) {
        this.filter = set != null && set.isEmpty() ? null : set;
        if (this.isVisible()) {
            this.buildTree();
        }
    }

    public void resetErrors() {
        ArrayList<TestError> arrayList = new ArrayList<TestError>(this.errors);
        this.setErrors(arrayList);
    }

    public void expandAll() {
        DefaultMutableTreeNode defaultMutableTreeNode = this.getRoot();
        int n = 0;
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            enumeration.nextElement();
            this.expandRow(n++);
        }
    }

    public DefaultMutableTreeNode getRoot() {
        return (DefaultMutableTreeNode)this.valTreeModel.getRoot();
    }

    public int getUpdateCount() {
        return this.updateCount;
    }

    private void clearErrors() {
        if (this.errors != null) {
            DataSet dataSet = Main.main.getCurrentDataSet();
            if (dataSet != null) {
                for (TestError testError : this.errors) {
                    dataSet.removeDataSetListener(testError);
                }
            }
            this.errors.clear();
        }
    }

    @Override
    public void destroy() {
        this.clearErrors();
    }

    private static final class GroupTreeNode
    extends DefaultMutableTreeNode {
        GroupTreeNode(Object object) {
            super(object);
        }

        @Override
        public String toString() {
            return I18n.tr("{0} ({1})", super.toString(), this.getLeafCount());
        }
    }
}

