/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.pdmodel.encryption;

import java.io.IOException;
import java.util.Objects;
import org.sejda.sambox.cos.COSArray;
import org.sejda.sambox.cos.COSBase;
import org.sejda.sambox.cos.COSBoolean;
import org.sejda.sambox.cos.COSDictionary;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.cos.COSString;
import org.sejda.sambox.pdmodel.encryption.PDCryptFilterDictionary;
import org.sejda.sambox.pdmodel.encryption.SecurityHandler;
import org.sejda.sambox.pdmodel.encryption.SecurityHandlerFactory;

public class PDEncryption {
    public static final int VERSION0_UNDOCUMENTED_UNSUPPORTED = 0;
    public static final int VERSION1_40_BIT_ALGORITHM = 1;
    public static final int VERSION2_VARIABLE_LENGTH_ALGORITHM = 2;
    public static final int VERSION3_UNPUBLISHED_ALGORITHM = 3;
    public static final int VERSION4_SECURITY_HANDLER = 4;
    public static final String DEFAULT_NAME = "Standard";
    public static final int DEFAULT_LENGTH = 40;
    public static final int DEFAULT_VERSION = 0;
    private final COSDictionary dictionary;
    private SecurityHandler securityHandler;

    public PDEncryption() {
        this.dictionary = new COSDictionary();
    }

    public PDEncryption(COSDictionary dictionary) {
        this.dictionary = dictionary;
        this.securityHandler = SecurityHandlerFactory.INSTANCE.newSecurityHandlerForFilter(this.getFilter());
    }

    public SecurityHandler getSecurityHandler() throws IOException {
        if (this.securityHandler == null) {
            throw new IOException("No security handler for filter " + this.getFilter());
        }
        return this.securityHandler;
    }

    public void setSecurityHandler(SecurityHandler securityHandler) {
        this.securityHandler = securityHandler;
    }

    public boolean hasSecurityHandler() {
        return this.securityHandler == null;
    }

    public COSDictionary getCOSDictionary() {
        return this.dictionary;
    }

    public void setFilter(String filter) {
        this.dictionary.setItem(COSName.FILTER, (COSBase)COSName.getPDFName(filter));
    }

    public final String getFilter() {
        return this.dictionary.getNameAsString(COSName.FILTER);
    }

    public String getSubFilter() {
        return this.dictionary.getNameAsString(COSName.SUB_FILTER);
    }

    public void setSubFilter(String subfilter) {
        this.dictionary.setName(COSName.SUB_FILTER, subfilter);
    }

    public void setVersion(int version) {
        this.dictionary.setInt(COSName.V, version);
    }

    public int getVersion() {
        return this.dictionary.getInt(COSName.V, 0);
    }

    public void setLength(int length) {
        this.dictionary.setInt(COSName.LENGTH, length);
    }

    public int getLength() {
        return this.dictionary.getInt(COSName.LENGTH, 40);
    }

    public void setRevision(int revision) {
        this.dictionary.setInt(COSName.R, revision);
    }

    public int getRevision() {
        return this.dictionary.getInt(COSName.R, 0);
    }

    public void setOwnerKey(byte[] o) {
        this.dictionary.setItem(COSName.O, (COSBase)COSString.newInstance(o));
    }

    public byte[] getOwnerKey() {
        byte[] o = null;
        COSString owner = (COSString)this.dictionary.getDictionaryObject(COSName.O);
        if (owner != null) {
            o = owner.getBytes();
        }
        return o;
    }

    public void setUserKey(byte[] u) {
        this.dictionary.setItem(COSName.U, (COSBase)COSString.newInstance(u));
    }

    public byte[] getUserKey() {
        byte[] u = null;
        COSString user = (COSString)this.dictionary.getDictionaryObject(COSName.U);
        if (user != null) {
            u = user.getBytes();
        }
        return u;
    }

    public void setOwnerEncryptionKey(byte[] oe) {
        this.dictionary.setItem(COSName.OE, (COSBase)COSString.newInstance(oe));
    }

    public byte[] getOwnerEncryptionKey() {
        byte[] oe = null;
        COSString ownerEncryptionKey = (COSString)this.dictionary.getDictionaryObject(COSName.OE);
        if (ownerEncryptionKey != null) {
            oe = ownerEncryptionKey.getBytes();
        }
        return oe;
    }

    public void setUserEncryptionKey(byte[] ue) {
        this.dictionary.setItem(COSName.UE, (COSBase)COSString.newInstance(ue));
    }

    public byte[] getUserEncryptionKey() {
        byte[] ue = null;
        COSString userEncryptionKey = (COSString)this.dictionary.getDictionaryObject(COSName.UE);
        if (userEncryptionKey != null) {
            ue = userEncryptionKey.getBytes();
        }
        return ue;
    }

    public void setPermissions(int permissions) {
        this.dictionary.setInt(COSName.P, permissions);
    }

    public int getPermissions() {
        return this.dictionary.getInt(COSName.P, 0);
    }

    public boolean isEncryptMetaData() {
        boolean encryptMetaData = true;
        COSBase value = this.dictionary.getDictionaryObject(COSName.ENCRYPT_META_DATA);
        if (value instanceof COSBoolean) {
            encryptMetaData = ((COSBoolean)value).getValue();
        }
        return encryptMetaData;
    }

    public void setRecipients(byte[][] recipients) {
        COSArray array = new COSArray();
        for (byte[] recipient : recipients) {
            array.add(COSString.newInstance(recipient));
        }
        this.dictionary.setItem(COSName.RECIPIENTS, (COSBase)array);
    }

    public int getRecipientsLength() {
        COSArray array = (COSArray)this.dictionary.getItem(COSName.RECIPIENTS);
        return array.size();
    }

    public COSString getRecipientStringAt(int i) {
        COSArray array = (COSArray)this.dictionary.getItem(COSName.RECIPIENTS);
        return (COSString)array.get(i);
    }

    public PDCryptFilterDictionary getStdCryptFilterDictionary() {
        return this.getCryptFilterDictionary(COSName.STD_CF);
    }

    public PDCryptFilterDictionary getCryptFilterDictionary(COSName cryptFilterName) {
        COSDictionary stdCryptFilterDictionary;
        COSDictionary cryptFilterDictionary = (COSDictionary)this.dictionary.getDictionaryObject(COSName.CF);
        if (cryptFilterDictionary != null && (stdCryptFilterDictionary = (COSDictionary)cryptFilterDictionary.getDictionaryObject(cryptFilterName)) != null) {
            return new PDCryptFilterDictionary(stdCryptFilterDictionary);
        }
        return null;
    }

    public void setCryptFilterDictionary(COSName cryptFilterName, PDCryptFilterDictionary cryptFilterDictionary) {
        COSDictionary cfDictionary = (COSDictionary)this.dictionary.getDictionaryObject(COSName.CF);
        if (cfDictionary == null) {
            cfDictionary = new COSDictionary();
            this.dictionary.setItem(COSName.CF, (COSBase)cfDictionary);
        }
        cfDictionary.setItem(cryptFilterName, (COSBase)cryptFilterDictionary.getCOSDictionary());
    }

    public void setStdCryptFilterDictionary(PDCryptFilterDictionary cryptFilterDictionary) {
        this.setCryptFilterDictionary(COSName.STD_CF, cryptFilterDictionary);
    }

    public COSName getStreamFilterName() {
        COSName stmF = (COSName)this.dictionary.getDictionaryObject(COSName.STM_F);
        if (stmF == null) {
            stmF = COSName.IDENTITY;
        }
        return stmF;
    }

    public void setStreamFilterName(COSName streamFilterName) {
        this.dictionary.setItem(COSName.STM_F, (COSBase)streamFilterName);
    }

    public COSName getStringFilterName() {
        COSName strF = (COSName)this.dictionary.getDictionaryObject(COSName.STR_F);
        if (strF == null) {
            strF = COSName.IDENTITY;
        }
        return strF;
    }

    public void setStringFilterName(COSName stringFilterName) {
        this.dictionary.setItem(COSName.STR_F, (COSBase)stringFilterName);
    }

    public void setPerms(byte[] perms) {
        this.dictionary.setItem(COSName.PERMS, (COSBase)COSString.newInstance(perms));
    }

    public byte[] getPerms() {
        COSString permsCosString = this.dictionary.getDictionaryObject(COSName.PERMS, COSString.class);
        if (Objects.nonNull(permsCosString)) {
            return permsCosString.getBytes();
        }
        return null;
    }

    public void removeV45filters() {
        this.dictionary.setItem(COSName.CF, null);
        this.dictionary.setItem(COSName.STM_F, null);
        this.dictionary.setItem(COSName.STR_F, null);
    }
}

