/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.j3d;

import com.eteks.sweethome3d.j3d.ModelManager;
import com.eteks.sweethome3d.j3d.Object3DBranch;
import com.eteks.sweethome3d.j3d.TextureManager;
import com.eteks.sweethome3d.model.Content;
import com.eteks.sweethome3d.model.Home;
import com.eteks.sweethome3d.model.HomeEnvironment;
import com.eteks.sweethome3d.model.HomeFurnitureGroup;
import com.eteks.sweethome3d.model.HomeLight;
import com.eteks.sweethome3d.model.HomeMaterial;
import com.eteks.sweethome3d.model.HomePieceOfFurniture;
import com.eteks.sweethome3d.model.HomeTexture;
import com.eteks.sweethome3d.model.Level;
import com.eteks.sweethome3d.model.Light;
import com.eteks.sweethome3d.model.LightSource;
import com.eteks.sweethome3d.model.Room;
import com.eteks.sweethome3d.model.Selectable;
import com.eteks.sweethome3d.model.SelectionEvent;
import com.eteks.sweethome3d.model.SelectionListener;
import com.sun.j3d.utils.geometry.Box;
import java.awt.Color;
import java.awt.Rectangle;
import java.lang.ref.WeakReference;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.media.j3d.Appearance;
import javax.media.j3d.BoundingBox;
import javax.media.j3d.BoundingLeaf;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.CapabilityNotSetException;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.Group;
import javax.media.j3d.Link;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.PointLight;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.RenderingAttributes;
import javax.media.j3d.Shape3D;
import javax.media.j3d.TexCoordGeneration;
import javax.media.j3d.Texture;
import javax.media.j3d.TextureAttributes;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransparencyAttributes;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import javax.vecmath.Vector4f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HomePieceOfFurniture3D
extends Object3DBranch {
    private static final TransparencyAttributes DEFAULT_TEXTURED_SHAPE_TRANSPARENCY_ATTRIBUTES = new TransparencyAttributes(1, 0.0f);
    private static final PolygonAttributes DEFAULT_TEXTURED_SHAPE_POLYGON_ATTRIBUTES = new PolygonAttributes(2, 0, 0.0f, false);
    private static final PolygonAttributes NORMAL_FLIPPED_TEXTURED_SHAPE_POLYGON_ATTRIBUTES = new PolygonAttributes(2, 0, 0.0f, true);
    private static final TextureAttributes MODULATE_TEXTURE_ATTRIBUTES = new TextureAttributes();
    private static final Bounds DEFAULT_INFLUENCING_BOUNDS = new BoundingSphere(new Point3d(), 1.0E7);
    private final Home home;

    public HomePieceOfFurniture3D(HomePieceOfFurniture homePieceOfFurniture, Home home) {
        this(homePieceOfFurniture, home, false, false);
    }

    public HomePieceOfFurniture3D(HomePieceOfFurniture homePieceOfFurniture, Home home, boolean bl, boolean bl2) {
        this.setUserData(homePieceOfFurniture);
        this.home = home;
        this.setCapability(17);
        this.setCapability(12);
        this.setCapability(14);
        this.createPieceOfFurnitureNode(homePieceOfFurniture, bl, bl2);
    }

    private void createPieceOfFurnitureNode(final HomePieceOfFurniture homePieceOfFurniture, final boolean bl, final boolean bl2) {
        BoundingLeaf boundingLeaf;
        TransformGroup transformGroup = new TransformGroup();
        transformGroup.setCapability(18);
        transformGroup.setCapability(12);
        transformGroup.setCapability(13);
        transformGroup.setCapability(14);
        this.addChild((Node)transformGroup);
        if (homePieceOfFurniture instanceof HomeLight) {
            boundingLeaf = new BoundingLeaf();
            boundingLeaf.setCapability(13);
            this.addChild((Node)boundingLeaf);
        }
        boundingLeaf = new BranchGroup();
        boundingLeaf.setCapability(17);
        boundingLeaf.addChild(this.getModelBox(Color.WHITE));
        this.setModelCapabilities((Node)boundingLeaf);
        transformGroup.addChild((Node)boundingLeaf);
        this.updatePieceOfFurnitureTransform();
        Content content = homePieceOfFurniture.getModel();
        ModelManager.getInstance().loadModel(content, bl2, new ModelManager.ModelObserver(){

            public void modelUpdated(BranchGroup branchGroup) {
                float[][] fArray = homePieceOfFurniture.getModelRotation();
                TransformGroup transformGroup = ModelManager.getInstance().getNormalizedTransformGroup((Node)branchGroup, fArray, 1.0f);
                this.cloneHomeTextures((Node)branchGroup);
                HomePieceOfFurniture3D.this.updatePieceOfFurnitureModelNode((Node)branchGroup, transformGroup, bl, bl2);
            }

            public void modelError(Exception exception) {
                HomePieceOfFurniture3D.this.updatePieceOfFurnitureModelNode(HomePieceOfFurniture3D.this.getModelBox(Color.RED), new TransformGroup(), bl, bl2);
            }

            private void cloneHomeTextures(Node node) {
                Texture texture;
                Appearance appearance;
                if (node instanceof Group) {
                    Enumeration enumeration = ((Group)node).getAllChildren();
                    while (enumeration.hasMoreElements()) {
                        this.cloneHomeTextures((Node)enumeration.nextElement());
                    }
                } else if (node instanceof Link) {
                    this.cloneHomeTextures((Node)((Link)node).getSharedGroup());
                } else if (node instanceof Shape3D && (appearance = ((Shape3D)node).getAppearance()) != null && (texture = appearance.getTexture()) != null) {
                    appearance.setTexture(HomePieceOfFurniture3D.this.getHomeTextureClone(texture, HomePieceOfFurniture3D.this.home));
                }
            }
        });
    }

    @Override
    public void update() {
        this.updatePieceOfFurnitureTransform();
        this.updatePieceOfFurnitureModelMirrored();
        this.updatePieceOfFurnitureColorAndTexture(false);
        this.updateLight();
        this.updatePieceOfFurnitureVisibility();
    }

    private void updatePieceOfFurnitureTransform() {
        Transform3D transform3D = ModelManager.getInstance().getPieceOFFurnitureNormalizedModelTransformation((HomePieceOfFurniture)this.getUserData());
        ((TransformGroup)this.getChild(0)).setTransform(transform3D);
    }

    private void updatePieceOfFurnitureColorAndTexture(boolean bl) {
        HomePieceOfFurniture homePieceOfFurniture = (HomePieceOfFurniture)this.getUserData();
        Node node = this.getFilledModelNode();
        if (homePieceOfFurniture.getColor() != null) {
            this.setColorAndTexture(node, homePieceOfFurniture.getColor(), null, homePieceOfFurniture.getShininess(), null, false, null, null, new HashSet<Appearance>());
        } else if (homePieceOfFurniture.getTexture() != null) {
            this.setColorAndTexture(node, null, homePieceOfFurniture.getTexture(), homePieceOfFurniture.getShininess(), null, bl, new Vector3f(homePieceOfFurniture.getWidth(), homePieceOfFurniture.getHeight(), homePieceOfFurniture.getDepth()), ModelManager.getInstance().getBounds(((Group)node).getChild(0)), new HashSet<Appearance>());
        } else if (homePieceOfFurniture.getModelMaterials() != null) {
            this.setColorAndTexture(node, null, null, null, homePieceOfFurniture.getModelMaterials(), bl, new Vector3f(homePieceOfFurniture.getWidth(), homePieceOfFurniture.getHeight(), homePieceOfFurniture.getDepth()), ModelManager.getInstance().getBounds(((Group)node).getChild(0)), new HashSet<Appearance>());
        } else {
            this.setColorAndTexture(node, null, null, homePieceOfFurniture.getShininess(), null, false, null, null, new HashSet<Appearance>());
        }
    }

    private void updateLight() {
        HomePieceOfFurniture homePieceOfFurniture = (HomePieceOfFurniture)this.getUserData();
        if (homePieceOfFurniture instanceof HomeLight && this.home != null) {
            boolean bl = this.home.getEnvironment().getSubpartSizeUnderLight() > 0.0f && homePieceOfFurniture.isVisible() && (homePieceOfFurniture.getLevel() == null || homePieceOfFurniture.getLevel().isViewableAndVisible());
            HomeLight homeLight = (HomeLight)homePieceOfFurniture;
            LightSource[] lightSourceArray = homeLight.getLightSources();
            if (this.numChildren() > 2) {
                float f;
                float f2;
                Object object;
                Color color = new Color(this.home.getEnvironment().getLightColor());
                float f3 = (float)color.getRed() / 3072.0f;
                float f4 = (float)color.getGreen() / 3072.0f;
                float f5 = (float)color.getBlue() / 3072.0f;
                float f6 = homeLight.getAngle();
                float f7 = (float)Math.cos(f6);
                float f8 = (float)Math.sin(f6);
                Group group = (Group)this.getChild(2);
                for (int i = 0; i < lightSourceArray.length; ++i) {
                    LightSource lightSource = lightSourceArray[i];
                    Color serializable = new Color(lightSource.getColor());
                    float f9 = homeLight.getPower();
                    object = (PointLight)group.getChild(i);
                    object.setColor(new Color3f((float)serializable.getRed() / 255.0f * f9 + (f9 > 0.0f ? f3 : 0.0f), (float)serializable.getGreen() / 255.0f * f9 + (f9 > 0.0f ? f4 : 0.0f), (float)serializable.getBlue() / 255.0f * f9 + (f9 > 0.0f ? f5 : 0.0f)));
                    float f10 = -homeLight.getWidth() / 2.0f + lightSource.getX() * homeLight.getWidth();
                    f2 = homeLight.getDepth() / 2.0f - lightSource.getY() * homeLight.getDepth();
                    f = homeLight.getGroundElevation();
                    object.setPosition(homeLight.getX() + f10 * f7 - f2 * f8, f + lightSource.getZ() * homeLight.getHeight(), homeLight.getY() + f10 * f8 + f2 * f7);
                    object.setEnable(bl);
                }
                if (bl) {
                    Bounds bounds = DEFAULT_INFLUENCING_BOUNDS;
                    for (Room room : this.home.getRooms()) {
                        Level level = room.getLevel();
                        if (!homeLight.isAtLevel(level) || !(object = this.getShape(room.getPoints())).contains(homeLight.getX(), homeLight.getY())) continue;
                        Rectangle rectangle = object.getBounds();
                        f2 = level != null ? level.getElevation() : 0.0f;
                        f = level != null ? f2 + level.getHeight() : 1.0E7f;
                        float f11 = 0.1f;
                        bounds = new BoundingBox(new Point3d(rectangle.getMinX() - (double)f11, (double)(f2 - f11), rectangle.getMinY() - (double)f11), new Point3d(rectangle.getMaxX() + (double)f11, (double)(f + f11), rectangle.getMaxY() + (double)f11));
                        break;
                    }
                    ((BoundingLeaf)this.getChild(1)).setRegion(bounds);
                }
            }
        }
    }

    private Node getFilledModelNode() {
        TransformGroup transformGroup = (TransformGroup)this.getChild(0);
        BranchGroup branchGroup = (BranchGroup)transformGroup.getChild(0);
        return branchGroup.getChild(0);
    }

    private Node getOutlineModelNode() {
        TransformGroup transformGroup = (TransformGroup)this.getChild(0);
        BranchGroup branchGroup = (BranchGroup)transformGroup.getChild(0);
        if (branchGroup.numChildren() > 1) {
            return branchGroup.getChild(1);
        }
        return null;
    }

    private void updatePieceOfFurnitureVisibility() {
        HomePieceOfFurniture homePieceOfFurniture = (HomePieceOfFurniture)this.getUserData();
        Node node = this.getOutlineModelNode();
        HomeEnvironment.DrawingMode drawingMode = this.home != null && node != null ? this.home.getEnvironment().getDrawingMode() : null;
        boolean bl = homePieceOfFurniture.isVisible() && (homePieceOfFurniture.getLevel() == null || homePieceOfFurniture.getLevel().isViewableAndVisible());
        HomeMaterial[] homeMaterialArray = homePieceOfFurniture.getColor() == null && homePieceOfFurniture.getTexture() == null ? homePieceOfFurniture.getModelMaterials() : null;
        this.setVisible(this.getFilledModelNode(), bl && (drawingMode == null || drawingMode == HomeEnvironment.DrawingMode.FILL || drawingMode == HomeEnvironment.DrawingMode.FILL_AND_OUTLINE), homeMaterialArray);
        if (node != null) {
            this.setVisible(node, bl && (drawingMode == HomeEnvironment.DrawingMode.OUTLINE || drawingMode == HomeEnvironment.DrawingMode.FILL_AND_OUTLINE), homeMaterialArray);
        }
    }

    private void updatePieceOfFurnitureModelMirrored() {
        HomePieceOfFurniture homePieceOfFurniture = (HomePieceOfFurniture)this.getUserData();
        this.setCullFace(this.getFilledModelNode(), homePieceOfFurniture.isModelMirrored(), homePieceOfFurniture.isBackFaceShown());
    }

    private void updatePieceOfFurnitureModelNode(Node node, TransformGroup transformGroup, boolean bl, boolean bl2) {
        transformGroup.addChild(node);
        this.setModelCapabilities((Node)transformGroup);
        BranchGroup branchGroup = new BranchGroup();
        branchGroup.setCapability(12);
        branchGroup.addChild((Node)transformGroup);
        if (!bl) {
            branchGroup.addChild(this.createOutlineModelNode((Node)transformGroup));
        }
        TransformGroup transformGroup2 = (TransformGroup)this.getChild(0);
        transformGroup2.removeAllChildren();
        transformGroup2.addChild((Node)branchGroup);
        HomePieceOfFurniture homePieceOfFurniture = (HomePieceOfFurniture)this.getUserData();
        if (homePieceOfFurniture instanceof HomeLight) {
            BranchGroup branchGroup2 = new BranchGroup();
            branchGroup2.setCapability(12);
            HomeLight homeLight = (HomeLight)homePieceOfFurniture;
            for (int i = homeLight.getLightSources().length; i > 0; --i) {
                PointLight pointLight = new PointLight(new Color3f(), new Point3f(), new Point3f(0.25f, 0.0f, 2.5E-6f));
                pointLight.setCapability(19);
                pointLight.setCapability(15);
                pointLight.setCapability(13);
                BoundingLeaf boundingLeaf = (BoundingLeaf)this.getChild(1);
                pointLight.setInfluencingBoundingLeaf(boundingLeaf);
                branchGroup2.addChild((Node)pointLight);
            }
            this.addChild((Node)branchGroup2);
        }
        if (homePieceOfFurniture.isBackFaceShown()) {
            this.setBackFaceNormalFlip(this.getFilledModelNode(), true);
        }
        this.updatePieceOfFurnitureModelMirrored();
        this.updatePieceOfFurnitureColorAndTexture(bl2);
        this.updateLight();
        this.updatePieceOfFurnitureVisibility();
        if (this.home != null && this.getUserData() instanceof Light) {
            this.home.addSelectionListener(new LightSelectionListener(this));
        }
    }

    private Node getModelBox(Color color) {
        Material material = new Material();
        material.setDiffuseColor(new Color3f(color));
        material.setAmbientColor(new Color3f(color.darker()));
        Appearance appearance = new Appearance();
        appearance.setMaterial(material);
        return new Box(0.5f, 0.5f, 0.5f, appearance);
    }

    private Node createOutlineModelNode(Node node) {
        Node node2 = ModelManager.getInstance().cloneNode(node);
        this.setOutlineAppearance(node2);
        return node2;
    }

    private void setOutlineAppearance(Node node) {
        if (node instanceof Group) {
            Enumeration enumeration = ((Group)node).getAllChildren();
            while (enumeration.hasMoreElements()) {
                this.setOutlineAppearance((Node)enumeration.nextElement());
            }
        } else if (node instanceof Link) {
            this.setOutlineAppearance((Node)((Link)node).getSharedGroup());
        } else if (node instanceof Shape3D) {
            Appearance appearance = new Appearance();
            ((Shape3D)node).setAppearance(appearance);
            appearance.setCapability(12);
            RenderingAttributes renderingAttributes = new RenderingAttributes();
            renderingAttributes.setCapability(6);
            appearance.setRenderingAttributes(renderingAttributes);
            appearance.setColoringAttributes(Object3DBranch.OUTLINE_COLORING_ATTRIBUTES);
            appearance.setPolygonAttributes(Object3DBranch.OUTLINE_POLYGON_ATTRIBUTES);
            appearance.setLineAttributes(Object3DBranch.OUTLINE_LINE_ATTRIBUTES);
        }
    }

    private void setModelCapabilities(Node node) {
        if (node instanceof Group) {
            node.setCapability(12);
            if (node instanceof TransformGroup) {
                node.setCapability(17);
            }
            Enumeration enumeration = ((Group)node).getAllChildren();
            while (enumeration.hasMoreElements()) {
                this.setModelCapabilities((Node)enumeration.nextElement());
            }
        } else if (node instanceof Link) {
            node.setCapability(12);
            this.setModelCapabilities((Node)((Link)node).getSharedGroup());
        } else if (node instanceof Shape3D) {
            Shape3D shape3D = (Shape3D)node;
            Appearance appearance = shape3D.getAppearance();
            if (appearance != null) {
                this.setAppearanceCapabilities(appearance);
            }
            Enumeration enumeration = shape3D.getAllGeometries();
            while (enumeration.hasMoreElements()) {
                this.setGeometryCapabilities((Geometry)enumeration.nextElement());
            }
            node.setCapability(14);
            node.setCapability(15);
            node.setCapability(3);
        }
    }

    private void setColorAndTexture(Node node, Integer n, HomeTexture homeTexture, Float f, HomeMaterial[] homeMaterialArray, boolean bl, Vector3f vector3f, BoundingBox boundingBox, Set<Appearance> set) {
        if (node instanceof Group) {
            Enumeration enumeration = ((Group)node).getAllChildren();
            while (enumeration.hasMoreElements()) {
                this.setColorAndTexture((Node)enumeration.nextElement(), n, homeTexture, f, homeMaterialArray, bl, vector3f, boundingBox, set);
            }
        } else if (node instanceof Link) {
            this.setColorAndTexture((Node)((Link)node).getSharedGroup(), n, homeTexture, f, homeMaterialArray, bl, vector3f, boundingBox, set);
        } else if (node instanceof Shape3D) {
            Shape3D shape3D = (Shape3D)node;
            String string = (String)shape3D.getUserData();
            Appearance appearance = shape3D.getAppearance();
            if (appearance == null) {
                appearance = this.createAppearanceWithChangeCapabilities();
                ((Shape3D)node).setAppearance(appearance);
            }
            if (!set.contains(appearance)) {
                DefaultMaterialAndTexture defaultMaterialAndTexture = null;
                boolean bl2 = n != null;
                boolean bl3 = !bl2 && homeTexture != null;
                boolean bl4 = !bl2 && !bl3 && homeMaterialArray != null && homeMaterialArray.length > 0;
                boolean bl5 = bl2 || bl3 || bl4 || f != null;
                boolean bl6 = string != null && string.startsWith("sweethome3d_window_pane");
                float f2 = 0.0f;
                if (bl5) {
                    defaultMaterialAndTexture = (DefaultMaterialAndTexture)appearance.getUserData();
                    if (defaultMaterialAndTexture == null) {
                        defaultMaterialAndTexture = new DefaultMaterialAndTexture(appearance);
                        appearance.setUserData((Object)defaultMaterialAndTexture);
                    }
                    float f3 = f != null ? f.floatValue() : (f2 = defaultMaterialAndTexture.getMaterial() != null ? defaultMaterialAndTexture.getMaterial().getShininess() / 128.0f : 0.0f);
                }
                if (bl2) {
                    if (bl6) {
                        this.restoreDefaultMaterialAndTexture(appearance, Float.valueOf(f2));
                    } else {
                        appearance.setMaterial(this.getMaterial(n, n, f2));
                        appearance.setTransparencyAttributes(defaultMaterialAndTexture.getTransparencyAttributes());
                        appearance.setPolygonAttributes(defaultMaterialAndTexture.getPolygonAttributes());
                        appearance.setTexCoordGeneration(defaultMaterialAndTexture.getTexCoordGeneration());
                        appearance.setTextureAttributes(defaultMaterialAndTexture.getTextureAttributes());
                        appearance.setTexture(null);
                    }
                } else if (bl3) {
                    if (bl6) {
                        this.restoreDefaultMaterialAndTexture(appearance, Float.valueOf(f2));
                    } else {
                        appearance.setTexCoordGeneration(this.getTextureCoordinates(appearance, homeTexture, vector3f, boundingBox));
                        appearance.setMaterial(this.getMaterial(DEFAULT_COLOR, DEFAULT_AMBIENT_COLOR, f2));
                        appearance.setTextureAttributes(MODULATE_TEXTURE_ATTRIBUTES);
                        TextureManager.getInstance().loadTexture(homeTexture.getImage(), homeTexture.getAngle(), bl, this.getTextureObserver(appearance));
                    }
                } else if (bl4) {
                    boolean bl7 = false;
                    for (HomeMaterial homeMaterial : homeMaterialArray) {
                        if (homeMaterial == null || !homeMaterial.getName().equals(appearance.getName())) continue;
                        if (homeMaterial.getShininess() != null) {
                            f2 = homeMaterial.getShininess().floatValue();
                        }
                        if ((n = homeMaterial.getColor()) != null && (n & 0xFF000000) != 0) {
                            appearance.setMaterial(this.getMaterial(n, n, f2));
                            appearance.setTexture(null);
                            appearance.setTransparencyAttributes(defaultMaterialAndTexture.getTransparencyAttributes());
                            appearance.setPolygonAttributes(defaultMaterialAndTexture.getPolygonAttributes());
                        } else if (n == null && homeMaterial.getTexture() != null) {
                            if (this.isTexturesCoordinatesDefined(shape3D)) {
                                this.restoreDefaultTextureCoordinatesGeneration(appearance);
                            } else {
                                appearance.setTexCoordGeneration(this.getTextureCoordinates(appearance, homeMaterial.getTexture(), vector3f, boundingBox));
                            }
                            appearance.setMaterial(this.getMaterial(DEFAULT_COLOR, DEFAULT_AMBIENT_COLOR, f2));
                            appearance.setTextureAttributes(MODULATE_TEXTURE_ATTRIBUTES);
                            HomeTexture homeTexture2 = homeMaterial.getTexture();
                            TextureManager.getInstance().loadTexture(homeTexture2.getImage(), homeTexture2.getAngle(), bl, this.getTextureObserver(appearance));
                        } else {
                            this.restoreDefaultMaterialAndTexture(appearance, homeMaterial.getShininess());
                        }
                        bl7 = true;
                        break;
                    }
                    if (!bl7) {
                        this.restoreDefaultMaterialAndTexture(appearance, null);
                    }
                } else {
                    this.restoreDefaultMaterialAndTexture(appearance, f);
                }
                set.add(appearance);
            }
        }
    }

    private TextureManager.TextureObserver getTextureObserver(final Appearance appearance) {
        return new TextureManager.TextureObserver(){

            public void textureUpdated(Texture texture) {
                DefaultMaterialAndTexture defaultMaterialAndTexture;
                if (TextureManager.getInstance().isTextureTransparent(texture)) {
                    appearance.setTransparencyAttributes(DEFAULT_TEXTURED_SHAPE_TRANSPARENCY_ATTRIBUTES);
                    defaultMaterialAndTexture = (DefaultMaterialAndTexture)appearance.getUserData();
                    if (defaultMaterialAndTexture != null && defaultMaterialAndTexture.getPolygonAttributes() != null && defaultMaterialAndTexture.getPolygonAttributes().getBackFaceNormalFlip()) {
                        appearance.setPolygonAttributes(NORMAL_FLIPPED_TEXTURED_SHAPE_POLYGON_ATTRIBUTES);
                    } else {
                        appearance.setPolygonAttributes(DEFAULT_TEXTURED_SHAPE_POLYGON_ATTRIBUTES);
                    }
                } else {
                    defaultMaterialAndTexture = (DefaultMaterialAndTexture)appearance.getUserData();
                    if (defaultMaterialAndTexture != null) {
                        appearance.setTransparencyAttributes(defaultMaterialAndTexture.getTransparencyAttributes());
                        appearance.setPolygonAttributes(defaultMaterialAndTexture.getPolygonAttributes());
                    }
                }
                defaultMaterialAndTexture = HomePieceOfFurniture3D.this.getHomeTextureClone(texture, HomePieceOfFurniture3D.this.home);
                if (appearance.getTexture() != defaultMaterialAndTexture) {
                    appearance.setTexture((Texture)defaultMaterialAndTexture);
                }
            }
        };
    }

    private TexCoordGeneration getTextureCoordinates(Appearance appearance, HomeTexture homeTexture, Vector3f vector3f, BoundingBox boundingBox) {
        Point3d point3d = new Point3d();
        boundingBox.getLower(point3d);
        Point3d point3d2 = new Point3d();
        boundingBox.getUpper(point3d2);
        float f = ModelManager.getInstance().getMinimumSize();
        float f2 = TextureManager.getInstance().getRotatedTextureWidth(homeTexture);
        float f3 = TextureManager.getInstance().getRotatedTextureHeight(homeTexture);
        float f4 = vector3f.x / (float)Math.max(point3d2.x - point3d.x, (double)f) / f2;
        float f5 = homeTexture.isLeftToRightOriented() ? (float)(-point3d.x) * f4 : 0.0f;
        float f6 = vector3f.y / (float)Math.max(point3d2.y - point3d.y, (double)f) / f3;
        float f7 = vector3f.z / (float)Math.max(point3d2.z - point3d.z, (double)f) / f3;
        float f8 = homeTexture.isLeftToRightOriented() ? (float)(-point3d.y * (double)f6 + point3d2.z * (double)f7) : 0.0f;
        return new TexCoordGeneration(0, 0, new Vector4f(f4, 0.0f, 0.0f, f5), new Vector4f(0.0f, f6, -f7, f8));
    }

    private boolean isTexturesCoordinatesDefined(Shape3D shape3D) {
        int n = shape3D.numGeometries();
        for (int i = 0; i < n; ++i) {
            Geometry geometry = shape3D.getGeometry(i);
            if (!(geometry instanceof GeometryArray) || (((GeometryArray)geometry).getVertexFormat() & 0x20) != 0) continue;
            return false;
        }
        return true;
    }

    private void restoreDefaultMaterialAndTexture(Appearance appearance, Float f) {
        DefaultMaterialAndTexture defaultMaterialAndTexture = (DefaultMaterialAndTexture)appearance.getUserData();
        if (defaultMaterialAndTexture != null) {
            Material material = defaultMaterialAndTexture.getMaterial();
            if (material != null && f != null) {
                material = (Material)material.cloneNodeComponent(true);
                material.setSpecularColor(new Color3f(f.floatValue(), f.floatValue(), f.floatValue()));
                material.setShininess(f.floatValue() * 128.0f);
            }
            appearance.setMaterial(material);
            appearance.setTransparencyAttributes(defaultMaterialAndTexture.getTransparencyAttributes());
            appearance.setPolygonAttributes(defaultMaterialAndTexture.getPolygonAttributes());
            appearance.setTexCoordGeneration(defaultMaterialAndTexture.getTexCoordGeneration());
            appearance.setTexture(this.getHomeTextureClone(defaultMaterialAndTexture.getTexture(), this.home));
            appearance.setTextureAttributes(defaultMaterialAndTexture.getTextureAttributes());
        }
    }

    private void restoreDefaultTextureCoordinatesGeneration(Appearance appearance) {
        DefaultMaterialAndTexture defaultMaterialAndTexture = (DefaultMaterialAndTexture)appearance.getUserData();
        if (defaultMaterialAndTexture != null) {
            appearance.setTexCoordGeneration(defaultMaterialAndTexture.getTexCoordGeneration());
        }
    }

    private void setVisible(Node node, boolean bl, HomeMaterial[] homeMaterialArray) {
        if (node instanceof Group) {
            Enumeration enumeration = ((Group)node).getAllChildren();
            while (enumeration.hasMoreElements()) {
                this.setVisible((Node)enumeration.nextElement(), bl, homeMaterialArray);
            }
        } else if (node instanceof Link) {
            this.setVisible((Node)((Link)node).getSharedGroup(), bl, homeMaterialArray);
        } else if (node instanceof Shape3D) {
            RenderingAttributes renderingAttributes;
            Shape3D shape3D = (Shape3D)node;
            Appearance appearance = shape3D.getAppearance();
            if (appearance == null) {
                appearance = this.createAppearanceWithChangeCapabilities();
                ((Shape3D)node).setAppearance(appearance);
            }
            if ((renderingAttributes = appearance.getRenderingAttributes()) == null) {
                renderingAttributes = new RenderingAttributes();
                renderingAttributes.setCapability(6);
                appearance.setRenderingAttributes(renderingAttributes);
            }
            String string = (String)shape3D.getUserData();
            if (bl && string != null && this.getUserData() instanceof Light && string.startsWith("sweethome3d_light") && this.home != null && !this.isSelected(this.home.getSelectedItems())) {
                bl = false;
            }
            if (bl && homeMaterialArray != null) {
                for (HomeMaterial homeMaterial : homeMaterialArray) {
                    if (homeMaterial == null || !homeMaterial.getName().equals(appearance.getName())) continue;
                    Integer n = homeMaterial.getColor();
                    bl = n == null || (n & 0xFF000000) != 0;
                    break;
                }
            }
            renderingAttributes.setVisible(bl);
        }
    }

    private boolean isSelected(List<? extends Selectable> list) {
        Object object = this.getUserData();
        for (Selectable selectable : list) {
            if (selectable != object && (!(selectable instanceof HomeFurnitureGroup) || !this.isSelected(((HomeFurnitureGroup)selectable).getFurniture()))) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setCullFace(Node node, boolean bl, boolean bl2) {
        if (node instanceof Group) {
            Enumeration enumeration = ((Group)node).getAllChildren();
            while (enumeration.hasMoreElements()) {
                this.setCullFace((Node)enumeration.nextElement(), bl, bl2);
            }
            return;
        } else if (node instanceof Link) {
            this.setCullFace((Node)((Link)node).getSharedGroup(), bl, bl2);
            return;
        } else {
            PolygonAttributes polygonAttributes;
            if (!(node instanceof Shape3D)) return;
            Appearance appearance = ((Shape3D)node).getAppearance();
            if (appearance == null) {
                appearance = this.createAppearanceWithChangeCapabilities();
                ((Shape3D)node).setAppearance(appearance);
            }
            if ((polygonAttributes = appearance.getPolygonAttributes()) == null) {
                polygonAttributes = this.createPolygonAttributesWithChangeCapabilities();
                appearance.setPolygonAttributes(polygonAttributes);
            }
            try {
                int n = polygonAttributes.getCullFace();
                if (n == 0) return;
                Integer n2 = (Integer)polygonAttributes.getUserData();
                if (n2 == null) {
                    n2 = n;
                    polygonAttributes.setUserData((Object)n2);
                }
                polygonAttributes.setCullFace(bl ^ bl2 ^ n2 == 2 ? 2 : 1);
                return;
            }
            catch (CapabilityNotSetException capabilityNotSetException) {
                capabilityNotSetException.printStackTrace();
            }
        }
    }

    private void setBackFaceNormalFlip(Node node, boolean bl) {
        if (node instanceof Group) {
            Enumeration enumeration = ((Group)node).getAllChildren();
            while (enumeration.hasMoreElements()) {
                this.setBackFaceNormalFlip((Node)enumeration.nextElement(), bl);
            }
        } else if (node instanceof Link) {
            this.setBackFaceNormalFlip((Node)((Link)node).getSharedGroup(), bl);
        } else if (node instanceof Shape3D) {
            PolygonAttributes polygonAttributes;
            Appearance appearance = ((Shape3D)node).getAppearance();
            if (appearance == null) {
                appearance = this.createAppearanceWithChangeCapabilities();
                ((Shape3D)node).setAppearance(appearance);
            }
            if ((polygonAttributes = appearance.getPolygonAttributes()) == null) {
                polygonAttributes = this.createPolygonAttributesWithChangeCapabilities();
                appearance.setPolygonAttributes(polygonAttributes);
            }
            polygonAttributes.setBackFaceNormalFlip(bl ^ polygonAttributes.getCullFace() == 2);
        }
    }

    private PolygonAttributes createPolygonAttributesWithChangeCapabilities() {
        PolygonAttributes polygonAttributes = new PolygonAttributes();
        polygonAttributes.setCapability(0);
        polygonAttributes.setCapability(1);
        polygonAttributes.setCapability(6);
        polygonAttributes.setCapability(7);
        return polygonAttributes;
    }

    private Appearance createAppearanceWithChangeCapabilities() {
        Appearance appearance = new Appearance();
        this.setAppearanceCapabilities(appearance);
        return appearance;
    }

    private void setAppearanceCapabilities(Appearance appearance) {
        appearance.setCapability(0);
        appearance.setCapability(1);
        Material material = appearance.getMaterial();
        if (material != null) {
            material.setCapability(0);
        }
        appearance.setCapability(12);
        appearance.setCapability(13);
        appearance.setCapability(14);
        appearance.setCapability(15);
        appearance.setCapability(4);
        appearance.setCapability(5);
        appearance.setCapability(2);
        appearance.setCapability(3);
        appearance.setCapability(6);
        appearance.setCapability(7);
        appearance.setCapability(10);
        appearance.setCapability(11);
        PolygonAttributes polygonAttributes = appearance.getPolygonAttributes();
        if (polygonAttributes != null) {
            polygonAttributes.setCapability(0);
            polygonAttributes.setCapability(1);
            polygonAttributes.setCapability(6);
            polygonAttributes.setCapability(7);
        }
    }

    private void setGeometryCapabilities(Geometry geometry) {
        if (!geometry.isLive() && geometry instanceof GeometryArray) {
            geometry.setCapability(17);
            geometry.setCapability(8);
            geometry.setCapability(21);
            geometry.setCapability(0);
            geometry.setCapability(4);
            geometry.setCapability(6);
        }
    }

    static {
        MODULATE_TEXTURE_ATTRIBUTES.setTextureMode(2);
        DEFAULT_TEXTURED_SHAPE_POLYGON_ATTRIBUTES.setCapability(0);
        NORMAL_FLIPPED_TEXTURED_SHAPE_POLYGON_ATTRIBUTES.setCapability(0);
    }

    private static class DefaultMaterialAndTexture {
        private final Material material;
        private final TransparencyAttributes transparencyAttributes;
        private final PolygonAttributes polygonAttributes;
        private final TexCoordGeneration texCoordGeneration;
        private final Texture texture;
        private final TextureAttributes textureAttributes;

        public DefaultMaterialAndTexture(Appearance appearance) {
            this.material = appearance.getMaterial();
            this.transparencyAttributes = appearance.getTransparencyAttributes();
            this.polygonAttributes = appearance.getPolygonAttributes();
            this.texCoordGeneration = appearance.getTexCoordGeneration();
            this.texture = appearance.getTexture();
            this.textureAttributes = appearance.getTextureAttributes();
        }

        public Material getMaterial() {
            return this.material;
        }

        public TransparencyAttributes getTransparencyAttributes() {
            return this.transparencyAttributes;
        }

        public PolygonAttributes getPolygonAttributes() {
            return this.polygonAttributes;
        }

        public TexCoordGeneration getTexCoordGeneration() {
            return this.texCoordGeneration;
        }

        public Texture getTexture() {
            return this.texture;
        }

        public TextureAttributes getTextureAttributes() {
            return this.textureAttributes;
        }
    }

    private static class LightSelectionListener
    implements SelectionListener {
        private WeakReference<HomePieceOfFurniture3D> piece;

        public LightSelectionListener(HomePieceOfFurniture3D homePieceOfFurniture3D) {
            this.piece = new WeakReference<HomePieceOfFurniture3D>(homePieceOfFurniture3D);
        }

        public void selectionChanged(SelectionEvent selectionEvent) {
            HomePieceOfFurniture3D homePieceOfFurniture3D = (HomePieceOfFurniture3D)((Object)this.piece.get());
            Home home = (Home)selectionEvent.getSource();
            if (homePieceOfFurniture3D == null) {
                home.removeSelectionListener(this);
            } else {
                homePieceOfFurniture3D.updatePieceOfFurnitureVisibility();
            }
        }
    }
}

