/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.umleditor.format;

import ch.ehi.umleditor.umlpresentation.PresentationEdge;
import ch.ehi.umleditor.umlpresentation.PresentationNode;
import java.util.Iterator;
import java.util.List;

public class Layout {
    public static double delta1 = 1.0;
    public static double delta2 = 0.01;
    public static double delta3 = 1.0E-4;
    public static double delta4 = 100.0;
    public static double delta10 = 0.75;
    public static double delta11 = 0.75;
    private static final double M_PI = Math.PI;
    private double min_x;
    private double max_x;
    private double min_y;
    private double max_y;
    private double maxdist;
    private List nodev;
    private List edgev;
    private int oldpos_i;
    private double oldpos_x;
    private double oldpos_y;

    public static void layout(List nodev, List edgev, double min_x1, double min_y1, double max_x1, double max_y1) {
        Layout utility = new Layout();
        utility.nodev = nodev;
        utility.edgev = edgev;
        utility.min_x = min_x1;
        utility.min_y = min_y1;
        utility.max_x = max_x1;
        utility.max_y = max_y1;
        utility.doit();
    }

    private double cost() {
        double a = 0.0;
        if (delta1 > 0.0) {
            a = this.node_distribution();
        }
        double b = 0.0;
        if (delta2 > 0.0) {
            b = this.borderline();
        }
        double c = 0.0;
        if (delta3 > 0.0) {
            c = this.edgelength();
        }
        double d = 0.0;
        if (delta4 > 0.0) {
            d = this.edgecrossing();
        }
        return a + b + c + d;
    }

    private void neighborhood(double radius) {
        int new_y;
        int new_x;
        PresentationNode node;
        while (true) {
            int i = this.random(0, this.nodev.size() - 1);
            double alpha = (double)this.random(0, 7) * 50.0 / 400.0 * 2.0 * Math.PI;
            this.oldpos_i = i;
            node = this.getNode(i);
            if (!node.isMoveable()) continue;
            this.oldpos_x = node.getEast();
            this.oldpos_y = node.getSouth();
            new_x = (int)((double)node.getEast() + radius * Math.cos(alpha));
            new_y = (int)((double)node.getSouth() + radius * Math.sin(alpha));
            if ((double)new_x < this.min_x) {
                new_x = (int)this.min_x;
            }
            if ((double)new_y < this.min_y) {
                new_y = (int)this.min_y;
            }
            if ((double)new_x > this.max_x) {
                new_x = (int)this.max_x;
            }
            if ((double)new_y > this.max_y) {
                new_y = (int)this.max_y;
            }
            if ((double)new_x != this.oldpos_x || (double)new_y != this.oldpos_y) break;
        }
        node.setEast(new_x);
        node.setSouth(new_y);
    }

    private void moveback() {
        int i = this.oldpos_i;
        this.getNode(i).setEast((int)this.oldpos_x);
        this.getNode(i).setSouth((int)this.oldpos_y);
    }

    private double node_distribution() {
        double sum = 0.0;
        for (int i = 0; i < this.nodev.size(); ++i) {
            double x = this.getNode(i).getEast();
            double y = this.getNode(i).getSouth();
            for (int j = 0; j < this.nodev.size(); ++j) {
                double y2;
                if (i == j) continue;
                double x2 = this.getNode(j).getEast();
                double dist = this.getdist(x, y, x2, y2 = (double)this.getNode(j).getSouth());
                if (dist != 0.0) {
                    sum += delta1 / dist / dist;
                    continue;
                }
                sum += delta1;
            }
        }
        return sum;
    }

    private double edgelength() {
        double sum = 0.0;
        for (int i = 0; i < this.edgev.size(); ++i) {
            double x = this.getBeginNode(i).getEast();
            double y = this.getBeginNode(i).getSouth();
            double x2 = this.getEndNode(i).getEast();
            double y2 = this.getEndNode(i).getSouth();
            double dist = this.getdist(x, y, x2, y2) / this.maxdist;
            sum += delta3 * dist * dist;
        }
        return sum;
    }

    private double edgecrossing() {
        double sum = 0.0;
        for (int i = 0; i < this.edgev.size(); ++i) {
            for (int j = i + 1; j < this.edgev.size(); ++j) {
                if (!this.edgecross(i, j)) continue;
                sum += delta4;
            }
        }
        return sum;
    }

    private double nodeedgedistances() {
        double sum = 0.0;
        for (int j = 0; j < this.nodev.size(); ++j) {
            PresentationNode node = this.getNode(j);
            for (int i = 0; i < this.edgev.size(); ++i) {
                PresentationNode endNode;
                PresentationNode begNode = this.getBeginNode(i);
                if (begNode == node || (endNode = this.getEndNode(i)) == node) continue;
                double dist = this.pt2line(node.getEast(), node.getSouth(), begNode.getEast(), begNode.getSouth(), endNode.getEast(), endNode.getSouth());
                sum += delta4 / dist / dist;
            }
        }
        return sum;
    }

    private double borderline() {
        double sum = 0.0;
        for (int i = 0; i < this.nodev.size(); ++i) {
            double dx1 = (double)this.getNode(i).getEast() - this.min_x;
            double dy1 = (double)this.getNode(i).getSouth() - this.min_y;
            double dx2 = this.max_x - (double)this.getNode(i).getEast();
            double dy2 = this.max_y - (double)this.getNode(i).getSouth();
            double f = 0.0;
            f = dx1 != 0.0 ? (f += 1.0 / dx1 / dx1) : (f += 1.0);
            f = dy1 != 0.0 ? (f += 1.0 / dy1 / dy1) : (f += 1.0);
            f = dx2 != 0.0 ? (f += 1.0 / dx2 / dx2) : (f += 1.0);
            f = dy2 != 0.0 ? (f += 1.0 / dy2 / dy2) : (f += 1.0);
            sum += delta2 * f;
        }
        return sum;
    }

    private int random(int lb, int ub) {
        double d = ub - lb + 1;
        return (int)(Math.random() * d) + lb;
    }

    private boolean edgecross(int edge1, int edge2) {
        double x1 = this.getBeginNode(edge1).getEast();
        double y1 = this.getBeginNode(edge1).getSouth();
        double x2 = this.getEndNode(edge1).getEast();
        double y2 = this.getEndNode(edge1).getSouth();
        double x3 = this.getBeginNode(edge2).getEast();
        double y3 = this.getBeginNode(edge2).getSouth();
        double x4 = this.getEndNode(edge2).getEast();
        double y4 = this.getEndNode(edge2).getSouth();
        if (x2 == x1) {
            if (x4 == x3) {
                return false;
            }
            double t34 = (y4 - y3) / (x4 - x3);
            double ys3 = (x1 - x3) * t34;
            if (y4 - y3 > 0.0 && ys3 > 0.0 && ys3 < y4 - y3) {
                return true;
            }
            return y3 - y4 > 0.0 && ys3 < 0.0 && ys3 > y4 - y3;
        }
        double t12 = (y2 - y1) / (x2 - x1);
        if (x3 == x4) {
            double ys1 = (x4 - x1) * t12;
            if (y2 - y1 > 0.0 && ys1 > 0.0 && ys1 < y2 - y1) {
                return true;
            }
            return y1 - y2 > 0.0 && ys1 < 0.0 && ys1 > y2 - y1;
        }
        double t34 = (y4 - y3) / (x4 - x3);
        if (t12 == t34) {
            return false;
        }
        double xs1 = (y3 - y1 - (x3 - x1) * t34) / (t12 - t34);
        if (x2 - x1 > 0.0 && xs1 > 0.0 && xs1 < x2 - x1) {
            return true;
        }
        return x1 - x2 > 0.0 && xs1 < 0.0 && xs1 > x2 - x1;
    }

    private double getdist(double x1, double y1, double x2, double y2) {
        double d1 = x1 - x2;
        double d2 = y1 - y2;
        return Math.sqrt(d1 * d1 + d2 * d2);
    }

    private double pt2line(double x1, double y1, double xa, double ya, double xb, double yb) {
        double dx = xb - xa;
        if (dx == 0.0) {
            return Math.abs(x1 - xb);
        }
        double m = (yb - ya) / dx;
        if (m == 0.0) {
            return Math.abs(y1 - yb);
        }
        double xs = (y1 - ya + m * xa + x1 / m) / (m + 1.0 / m);
        double ys = m * (xs - xa) + ya;
        return this.getdist(x1, y1, xs, ys);
    }

    private void doit() {
        double temp = 1.0;
        this.maxdist = this.getdist(this.min_x, this.min_y, this.max_x, this.max_y);
        double radius = this.maxdist / 2.0;
        double e = this.cost();
        int max_stages = 10;
        int nodev_size = this.nodev.size();
        int max_trials = 30 * nodev_size;
        if (nodev_size > 30) {
            max_stages = (int)Math.sqrt(10000.0 / (double)nodev_size / 2.0);
            max_trials = nodev_size;
            return;
        }
        for (int stages = 0; stages < max_stages; ++stages) {
            for (int trials = 0; trials < max_trials; ++trials) {
                this.neighborhood(radius);
                double ep = this.cost();
                if (ep < e) {
                    e = ep;
                    continue;
                }
                this.moveback();
            }
            radius *= delta11;
            temp *= delta10;
        }
    }

    private PresentationEdge getEdge(int i) {
        return (PresentationEdge)this.edgev.get(i);
    }

    private PresentationNode getNode(int i) {
        return (PresentationNode)this.nodev.get(i);
    }

    private PresentationNode getBeginNode(int edgeIdx) {
        PresentationEdge edge = this.getEdge(edgeIdx);
        Iterator it = edge.iteratorEndpoint();
        return (PresentationNode)it.next();
    }

    private PresentationNode getEndNode(int edgeIdx) {
        PresentationEdge edge = this.getEdge(edgeIdx);
        Iterator it = edge.iteratorEndpoint();
        it.next();
        return (PresentationNode)it.next();
    }

    private String dumpNodes() {
        StringBuffer ret = new StringBuffer();
        for (PresentationNode node : this.nodev) {
            ret.append("(");
            ret.append(Integer.toString(node.getEast()));
            ret.append(",");
            ret.append(Integer.toString(node.getSouth()));
            ret.append(") ");
        }
        return ret.toString();
    }
}

