/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.indices.template.head;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.template.get.GetIndexTemplatesRequest;
import org.elasticsearch.action.admin.indices.template.get.GetIndexTemplatesResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.support.RestResponseListener;

public class RestHeadIndexTemplateAction
extends BaseRestHandler {
    @Inject
    public RestHeadIndexTemplateAction(Settings settings, RestController controller, Client client) {
        super(settings, controller, client);
        controller.registerHandler(RestRequest.Method.HEAD, "/_template/{name}", this);
    }

    @Override
    public void handleRequest(RestRequest request, RestChannel channel, Client client) {
        GetIndexTemplatesRequest getIndexTemplatesRequest = new GetIndexTemplatesRequest(request.param("name"));
        getIndexTemplatesRequest.local(request.paramAsBoolean("local", getIndexTemplatesRequest.local()));
        getIndexTemplatesRequest.masterNodeTimeout(request.paramAsTime("master_timeout", getIndexTemplatesRequest.masterNodeTimeout()));
        client.admin().indices().getTemplates(getIndexTemplatesRequest, (ActionListener<GetIndexTemplatesResponse>)new RestResponseListener<GetIndexTemplatesResponse>(channel){

            @Override
            public RestResponse buildResponse(GetIndexTemplatesResponse getIndexTemplatesResponse) {
                boolean templateExists;
                boolean bl = templateExists = getIndexTemplatesResponse.getIndexTemplates().size() > 0;
                if (templateExists) {
                    return new BytesRestResponse(RestStatus.OK);
                }
                return new BytesRestResponse(RestStatus.NOT_FOUND);
            }
        });
    }
}

