/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.mindmapmode.actions;

import freemind.controller.actions.generated.instance.RevertXmlAction;
import freemind.controller.actions.generated.instance.XmlAction;
import freemind.main.Resources;
import freemind.modes.MindMap;
import freemind.modes.mindmapmode.MindMapController;
import freemind.modes.mindmapmode.actions.FreemindAction;
import freemind.modes.mindmapmode.actions.xml.ActionPair;
import freemind.modes.mindmapmode.actions.xml.ActorXml;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringWriter;
import javax.swing.JOptionPane;

public class RevertAction
extends FreemindAction
implements ActorXml {
    private final MindMapController mindMapController;

    public RevertAction(MindMapController modeController) {
        super("RevertAction", (String)null, modeController);
        this.mindMapController = modeController;
        this.addActor(this);
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        try {
            File file = this.mindMapController.getMap().getFile();
            if (file == null) {
                JOptionPane.showMessageDialog(this.mindMapController.getView(), this.mindMapController.getText("map_not_saved"), "FreeMind", 0);
                return;
            }
            RevertXmlAction doAction = this.createRevertXmlAction(file);
            RevertXmlAction undoAction = this.createRevertXmlAction(this.mindMapController.getMap(), null, file.getName());
            this.mindMapController.doTransaction(this.getClass().getName(), new ActionPair((XmlAction)doAction, (XmlAction)undoAction));
        }
        catch (IOException e) {
            Resources.getInstance().logException(e);
        }
    }

    public void openXmlInsteadOfMap(String xmlFileContent) {
        try {
            RevertXmlAction doAction = this.createRevertXmlAction(xmlFileContent, null, null);
            RevertXmlAction undoAction = this.createRevertXmlAction(this.mindMapController.getMap(), null, null);
            this.mindMapController.doTransaction(this.getClass().getName(), new ActionPair((XmlAction)doAction, (XmlAction)undoAction));
        }
        catch (IOException e) {
            Resources.getInstance().logException(e);
        }
    }

    public RevertXmlAction createRevertXmlAction(File file) throws IOException {
        int c;
        String fileName = file.getAbsolutePath();
        FileReader f = new FileReader(file);
        StringBuffer buffer = new StringBuffer();
        while ((c = f.read()) != -1) {
            buffer.append((char)c);
        }
        f.close();
        return this.createRevertXmlAction(buffer.toString(), fileName, null);
    }

    public RevertXmlAction createRevertXmlAction(MindMap map, String fileName, String filePrefix) throws IOException {
        StringWriter writer = new StringWriter();
        map.getXml(writer);
        return this.createRevertXmlAction(writer.getBuffer().toString(), fileName, filePrefix);
    }

    public RevertXmlAction createRevertXmlAction(String xmlPackedFile, String fileName, String filePrefix) {
        RevertXmlAction revertXmlAction = new RevertXmlAction();
        revertXmlAction.setLocalFileName(fileName);
        revertXmlAction.setMap(xmlPackedFile);
        revertXmlAction.setFilePrefix(filePrefix);
        return revertXmlAction;
    }

    @Override
    public void act(XmlAction action) {
        if (action instanceof RevertXmlAction) {
            try {
                RevertXmlAction revertAction = (RevertXmlAction)action;
                this.mindMapController.getController().close(true);
                if (revertAction.getLocalFileName() != null) {
                    this.mindMapController.load(new File(revertAction.getLocalFileName()));
                } else {
                    String filePrefix = this.mindMapController.getText("freemind_reverted");
                    if (revertAction.getFilePrefix() != null) {
                        filePrefix = revertAction.getFilePrefix();
                    }
                    String xmlMap = revertAction.getMap();
                    this.mindMapController.load(xmlMap, filePrefix);
                }
            }
            catch (Exception e) {
                Resources.getInstance().logException(e);
            }
        }
    }

    @Override
    public Class getDoActionClass() {
        return RevertXmlAction.class;
    }
}

