/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.scala;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.typesafe.zinc.IncOptions;
import com.typesafe.zinc.Inputs;
import com.typesafe.zinc.SbtJars;
import com.typesafe.zinc.ScalaLocation;
import com.typesafe.zinc.Setup;
import java.io.File;
import java.io.Serializable;
import java.util.List;
import org.gradle.api.internal.tasks.SimpleWorkResult;
import org.gradle.api.internal.tasks.compile.CompilationFailedException;
import org.gradle.api.internal.tasks.compile.JavaCompileSpec;
import org.gradle.api.internal.tasks.compile.JavaCompilerArgumentsBuilder;
import org.gradle.api.internal.tasks.scala.ScalaJavaJointCompileSpec;
import org.gradle.api.internal.tasks.scala.ZincScalaCompilerArgumentsGenerator;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.WorkResult;
import org.gradle.cache.CacheRepository;
import org.gradle.cache.PersistentCache;
import org.gradle.cache.internal.CacheRepositoryServices;
import org.gradle.cache.internal.FileLockManager;
import org.gradle.cache.internal.filelock.LockOptions;
import org.gradle.cache.internal.filelock.LockOptionsBuilder;
import org.gradle.internal.Factory;
import org.gradle.internal.SystemProperties;
import org.gradle.internal.jvm.Jvm;
import org.gradle.internal.nativeintegration.services.NativeServices;
import org.gradle.internal.service.DefaultServiceRegistry;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.service.scopes.GlobalScopeServices;
import org.gradle.util.GFileUtils;
import scala.Option;
import xsbti.CompileFailed;
import xsbti.F0;
import xsbti.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZincScalaCompiler
implements org.gradle.language.base.internal.compile.Compiler<ScalaJavaJointCompileSpec>,
Serializable {
    private static final org.gradle.api.logging.Logger LOGGER = Logging.getLogger(ZincScalaCompiler.class);
    private final Iterable<File> scalaClasspath;
    private Iterable<File> zincClasspath;
    private final File gradleUserHome;
    public static final String ZINC_CACHE_HOME_DIR_SYSTEM_PROPERTY = "org.gradle.zinc.home.dir";
    private static final String ZINC_DIR_SYSTEM_PROPERTY = "zinc.dir";
    public static final String ZINC_DIR_IGNORED_MESSAGE = "In order to guarantee parallel safe Scala compilation, Gradle does not support the 'zinc.dir' system property and ignores any value provided.";

    public ZincScalaCompiler(Iterable<File> scalaClasspath, Iterable<File> zincClasspath, File gradleUserHome) {
        this.scalaClasspath = scalaClasspath;
        this.zincClasspath = zincClasspath;
        this.gradleUserHome = gradleUserHome;
    }

    public WorkResult execute(ScalaJavaJointCompileSpec spec) {
        return Compiler.execute(this.scalaClasspath, this.zincClasspath, this.gradleUserHome, spec);
    }

    private static class ZincCompilerServices
    extends DefaultServiceRegistry {
        private static ZincCompilerServices instance;

        private ZincCompilerServices(File gradleUserHome) {
            super(new ServiceRegistry[]{NativeServices.getInstance()});
            this.addProvider(new GlobalScopeServices(true));
            this.addProvider(new CacheRepositoryServices(gradleUserHome, null));
        }

        public static ZincCompilerServices getInstance(File gradleUserHome) {
            if (instance == null) {
                NativeServices.initialize((File)gradleUserHome);
                instance = new ZincCompilerServices(gradleUserHome);
            }
            return instance;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SbtLoggerAdapter
    implements Logger {
        private SbtLoggerAdapter() {
        }

        public void error(F0<String> msg) {
            LOGGER.error((String)msg.apply());
        }

        public void warn(F0<String> msg) {
            LOGGER.warn((String)msg.apply());
        }

        public void info(F0<String> msg) {
            LOGGER.info((String)msg.apply());
        }

        public void debug(F0<String> msg) {
            LOGGER.debug((String)msg.apply());
        }

        public void trace(F0<Throwable> exception) {
            LOGGER.trace(((Throwable)exception.apply()).toString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Compiler {
        private Compiler() {
        }

        static WorkResult execute(Iterable<File> scalaClasspath, Iterable<File> zincClasspath, File gradleUserHome, ScalaJavaJointCompileSpec spec) {
            LOGGER.info("Compiling with Zinc Scala compiler.");
            SbtLoggerAdapter logger = new SbtLoggerAdapter();
            com.typesafe.zinc.Compiler compiler = Compiler.createParallelSafeCompiler(scalaClasspath, zincClasspath, logger, gradleUserHome);
            List<String> scalacOptions = new ZincScalaCompilerArgumentsGenerator().generate(spec);
            List javacOptions = new JavaCompilerArgumentsBuilder((JavaCompileSpec)spec).includeClasspath(false).build();
            Inputs inputs = Inputs.create((List)ImmutableList.copyOf((Iterable)spec.getClasspath()), (List)ImmutableList.copyOf((Iterable)spec.getSource()), (File)spec.getDestinationDir(), scalacOptions, (List)javacOptions, (File)spec.getScalaCompileOptions().getIncrementalOptions().getAnalysisFile(), spec.getAnalysisMap(), (String)"mixed", (IncOptions)Compiler.getIncOptions(), (boolean)true);
            if (LOGGER.isDebugEnabled()) {
                Inputs.debug((Inputs)inputs, (Logger)logger);
            }
            if (spec.getScalaCompileOptions().isForce()) {
                GFileUtils.deleteDirectory((File)spec.getDestinationDir());
            }
            try {
                compiler.compile(inputs, (Logger)logger);
            }
            catch (CompileFailed e) {
                throw new CompilationFailedException((Throwable)e);
            }
            return new SimpleWorkResult(true);
        }

        private static IncOptions getIncOptions() {
            int transitiveStep = 3;
            double recompileAllFraction = 0.5;
            boolean relationsDebug = false;
            boolean apiDebug = false;
            int apiDiffContextSize = 5;
            Option apiDumpDirectory = Option.empty();
            boolean transactional = false;
            Option backup = Option.empty();
            IncOptions options = new IncOptions(transitiveStep, recompileAllFraction, relationsDebug, apiDebug, apiDiffContextSize, apiDumpDirectory, transactional, backup);
            return options;
        }

        static com.typesafe.zinc.Compiler createCompiler(Iterable<File> scalaClasspath, Iterable<File> zincClasspath, Logger logger) {
            ScalaLocation scalaLocation = ScalaLocation.fromPath((List)Lists.newArrayList(scalaClasspath));
            SbtJars sbtJars = SbtJars.fromPath((List)Lists.newArrayList(zincClasspath));
            Setup setup = Setup.create((ScalaLocation)scalaLocation, (SbtJars)sbtJars, (File)Jvm.current().getJavaHome(), (boolean)true);
            if (LOGGER.isDebugEnabled()) {
                Setup.debug((Setup)setup, (Logger)logger);
            }
            com.typesafe.zinc.Compiler compiler = com.typesafe.zinc.Compiler.getOrCreate((Setup)setup, (Logger)logger);
            return compiler;
        }

        static com.typesafe.zinc.Compiler createParallelSafeCompiler(final Iterable<File> scalaClasspath, final Iterable<File> zincClasspath, final Logger logger, File gradleUserHome) {
            String zincCacheHomeProperty = System.getProperty(ZincScalaCompiler.ZINC_CACHE_HOME_DIR_SYSTEM_PROPERTY);
            File zincCacheHomeDir = zincCacheHomeProperty != null ? new File(zincCacheHomeProperty) : gradleUserHome;
            CacheRepository cacheRepository = (CacheRepository)ZincCompilerServices.getInstance(zincCacheHomeDir).get(CacheRepository.class);
            final PersistentCache zincCache = cacheRepository.cache("zinc").withDisplayName("Zinc compiler cache").withLockOptions((LockOptions)LockOptionsBuilder.mode((FileLockManager.LockMode)FileLockManager.LockMode.Exclusive)).open();
            File cacheDir = zincCache.getBaseDir();
            String userSuppliedZincDir = System.getProperty(ZincScalaCompiler.ZINC_DIR_SYSTEM_PROPERTY);
            if (userSuppliedZincDir != null && !userSuppliedZincDir.equals(cacheDir.getAbsolutePath())) {
                LOGGER.warn(ZincScalaCompiler.ZINC_DIR_IGNORED_MESSAGE);
            }
            com.typesafe.zinc.Compiler compiler = (com.typesafe.zinc.Compiler)SystemProperties.getInstance().withSystemProperty(ZincScalaCompiler.ZINC_DIR_SYSTEM_PROPERTY, cacheDir.getAbsolutePath(), (Factory)new Factory<com.typesafe.zinc.Compiler>(){

                public com.typesafe.zinc.Compiler create() {
                    return (com.typesafe.zinc.Compiler)zincCache.useCache("initialize", (Factory)new Factory<com.typesafe.zinc.Compiler>(){

                        public com.typesafe.zinc.Compiler create() {
                            return Compiler.createCompiler(scalaClasspath, zincClasspath, logger);
                        }
                    });
                }
            });
            zincCache.close();
            return compiler;
        }
    }
}

