# 1.9.0 changelog

## Removal of default regions

Perhaps the most conspicuous change with this release is the removal of default regions. Since v1.6.0 users have had the ability to create service objects without explicitly defining geographic regions.

This has serious implications, however, for data jurisdiction - so we decided to move towards a system where users have to explicitly decide where their data sits. We want to ensure that the user retains control over where their data is stored, rather than making that decision on their behalf.

The changes are very small, you just need to pass in an additional argument (which has always existed):

```php
$compute = $client->computeService('cloudServersOpenStack', 'DFW');
```

If this is too verbose, we've also added a new feature to the Identity service that allows users to setup a default region for their own user accounts. If a default region has been set for their user account, explicitly setting one on object creation is not necessary.

## Identity/Keystone support

We now have full support for Rackspace Cloud Identity, and also support for OpenStack Keystone. The resources that you can interact with are:

* Users (list, get, create, update, delete)
* API keys (get, reset)
* Roles (list, get, assign, revoke)
* Tokens (generate, revoke)
* Tenants (list)

## Coveralls integration

We have externalized our test coverage with Coveralls and are currently in the process of bumping it to 100%. This allows for greater transparency and holds the project to a far higher standard. We've tied it into Jenkins CI, so a coverage report is generated every time the project is built.

## New iterator for DNS collections

There was an issue (#258) that made DNS collections iterate incorrectly (results were being duplicated). The reason was because the API for the DNS service handled pagination differently than most other services, so we needed to create a specialized concrete class for DNS iteration. This class extends the new iterator functionality implemented in the last release.

## Updating Swift object metadata is now easier and more efficient

Instead of having to do a full update, you can now update metadata in a separate call (`OpenCloud\ObjectStore\Resource\AbstractResource::saveMetadata`) with the option of prepending all array keys with the object's metadata prefix. So for objects, an array in the format of `['foo' => 1, 'bar' => 2]` would become `['X-Object-Meta-foo' => 1, 'X-Object-Meta-bar' => 2]` by default unless `false` is explicitly passed in as the second parameter.

## Misc fixes

- Removal of callable type hint in `OpenCloud\Common\Collection\ResourceIterator` that was causing errors (fixes #249)
- Fix to `OpenStack\Rackspace` so it references the correct `CredentialError` class (fixes #253)
- Updating various Orchestration models to reference the correct PersistentObject class path

## Doc changes/fixes
- Addition of Keystone docs
- Addition and improvement of Nova docs
- Fix to Swift object doc so that the mode is included in `fopen()` (fixes #262)
- Fix to sprintf in code sample in Getting Started guide (fixes #254, #259)