/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox;

import java.io.File;
import org.sejda.common.ComponentsUtility;
import org.sejda.core.notification.dsl.ApplicationEventsNotifier;
import org.sejda.core.support.io.IOUtils;
import org.sejda.core.support.io.MultipleOutputWriter;
import org.sejda.core.support.io.OutputWriters;
import org.sejda.core.support.io.model.FileOutput;
import org.sejda.core.support.prefix.NameGenerator;
import org.sejda.core.support.prefix.model.NameGenerationRequest;
import org.sejda.impl.sambox.component.DefaultPdfSourceOpener;
import org.sejda.impl.sambox.component.PDDocumentHandler;
import org.sejda.impl.sambox.component.PdfTextExtractor;
import org.sejda.model.exception.TaskException;
import org.sejda.model.input.PdfSource;
import org.sejda.model.input.PdfSourceOpener;
import org.sejda.model.parameter.ExtractTextParameters;
import org.sejda.model.pdf.encryption.PdfAccessPermission;
import org.sejda.model.task.BaseTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtractTextTask
extends BaseTask<ExtractTextParameters> {
    private static final Logger LOG = LoggerFactory.getLogger(ExtractTextTask.class);
    private int totalSteps;
    private PDDocumentHandler documentHandler = null;
    private MultipleOutputWriter outputWriter;
    private PdfSourceOpener<PDDocumentHandler> documentLoader;
    private PdfTextExtractor textExtractor;

    @Override
    public void before(ExtractTextParameters parameters) throws TaskException {
        this.totalSteps = parameters.getSourceList().size();
        this.documentLoader = new DefaultPdfSourceOpener();
        this.textExtractor = new PdfTextExtractor(parameters.getTextEncoding());
        this.outputWriter = OutputWriters.newMultipleOutputWriter(parameters.getExistingOutputPolicy());
    }

    @Override
    public void execute(ExtractTextParameters parameters) throws TaskException {
        int currentStep = 0;
        for (PdfSource<?> source : parameters.getSourceList()) {
            this.stopTaskIfCancelled();
            ++currentStep;
            LOG.debug("Opening {}", (Object)source);
            this.documentHandler = source.open(this.documentLoader);
            this.documentHandler.getPermissions().ensurePermission(PdfAccessPermission.COPY_AND_EXTRACT);
            File tmpFile = IOUtils.createTemporaryBuffer();
            LOG.debug("Created output on temporary buffer {}", (Object)tmpFile);
            this.textExtractor.extract(this.documentHandler.getUnderlyingPDDocument(), tmpFile);
            String outName = NameGenerator.nameGenerator(parameters.getOutputPrefix()).generate(NameGenerationRequest.nameRequest("txt").originalName(source.getName()).fileNumber(currentStep));
            this.outputWriter.addOutput(FileOutput.file(tmpFile).name(outName));
            this.closeResources();
            ApplicationEventsNotifier.notifyEvent(this.getNotifiableTaskMetadata()).stepsCompleted(currentStep).outOf(this.totalSteps);
        }
        parameters.getOutput().accept(this.outputWriter);
        LOG.debug("Text extracted from input documents and written to {}", (Object)parameters.getOutput());
    }

    @Override
    public void after() {
        this.closeResources();
    }

    private void closeResources() {
        ComponentsUtility.nullSafeCloseQuietly(this.documentHandler);
        ComponentsUtility.nullSafeCloseQuietly(this.textExtractor);
    }
}

