/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.control;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import net.sf.freecol.common.model.Ability;
import net.sf.freecol.common.model.Feature;
import net.sf.freecol.common.model.FoundingFather;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.HistoryEvent;
import net.sf.freecol.common.model.LastSale;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.ModelMessage;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Ownable;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Stance;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TradeRoute;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.WorkLocation;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.server.model.ServerPlayer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class ChangeSet {
    private static final Comparator<Change> changeComparator = Comparator.comparingInt(Change::getPriority);
    private final ArrayList<Change> changes;

    public ChangeSet() {
        this.changes = new ArrayList();
    }

    public ChangeSet(ChangeSet other) {
        this.changes = new ArrayList<Change>(other.changes);
    }

    public void remove(FreeColGameObject fcgo) {
        Iterator<Change> ci = this.changes.iterator();
        while (ci.hasNext()) {
            Change c = ci.next();
            if (!c.matches(fcgo)) continue;
            ci.remove();
        }
    }

    public ChangeSet add(See see, FreeColGameObject ... objects) {
        for (FreeColGameObject o : objects) {
            this.changes.add(new ObjectChange(see, o));
        }
        return this;
    }

    public ChangeSet add(See see, Collection<? extends FreeColGameObject> objects) {
        for (FreeColGameObject freeColGameObject : objects) {
            this.changes.add(new ObjectChange(see, freeColGameObject));
        }
        return this;
    }

    public ChangeSet add(See see, ChangePriority cp, DOMMessage message) {
        this.changes.add(new MessageChange(see, cp, message));
        return this;
    }

    public ChangeSet addAttack(See see, Unit attacker, Unit defender, boolean success) {
        this.changes.add(new AttackChange(see, attacker, defender, success));
        return this;
    }

    public ChangeSet addAttribute(See see, String key, String value) {
        this.changes.add(new AttributeChange(see, key, value));
        return this;
    }

    public ChangeSet addDead(ServerPlayer serverPlayer) {
        this.addTrivial(See.all(), "setDead", ChangePriority.CHANGE_EARLY, "player", serverPlayer.getId());
        return this;
    }

    public ChangeSet addDisappear(ServerPlayer owner, Tile tile, FreeColGameObject fcgo) {
        ArrayList<FreeColGameObject> objects = new ArrayList<FreeColGameObject>();
        objects.add(fcgo);
        this.changes.add(new RemoveChange(See.perhaps().except(owner), tile, objects));
        this.changes.add(new ObjectChange(See.perhaps().except(owner), tile));
        return this;
    }

    public ChangeSet addFather(ServerPlayer serverPlayer, FoundingFather father) {
        this.changes.add(new OwnedChange(See.only(serverPlayer), father));
        serverPlayer.addFather(father);
        return this;
    }

    public ChangeSet addFeatureChange(ServerPlayer serverPlayer, FreeColGameObject object, Ability ability, boolean add) {
        this.changes.add(new FeatureChange(See.only(serverPlayer), object, ability, add));
        if (add) {
            object.addAbility(ability);
        } else {
            object.removeAbility(ability);
        }
        return this;
    }

    public ChangeSet addFeatureChange(ServerPlayer serverPlayer, FreeColGameObject object, Modifier modifier, boolean add) {
        this.changes.add(new FeatureChange(See.only(serverPlayer), object, modifier, add));
        if (add) {
            object.addModifier(modifier);
        } else {
            object.removeModifier(modifier);
        }
        return this;
    }

    public ChangeSet addGlobalHistory(Game game, HistoryEvent history) {
        this.changes.add(new OwnedChange(See.all(), history));
        for (Player p : game.getLiveEuropeanPlayers(null)) {
            p.addHistory(history);
        }
        return this;
    }

    public ChangeSet addHistory(ServerPlayer serverPlayer, HistoryEvent history) {
        this.changes.add(new OwnedChange(See.only(serverPlayer), history));
        serverPlayer.addHistory(history);
        return this;
    }

    public ChangeSet addMessage(See see, ModelMessage message) {
        this.changes.add(new OwnedChange(see, message));
        return this;
    }

    public ChangeSet addMove(See see, Unit unit, Location loc, Tile tile) {
        this.changes.add(new MoveChange(see, unit, loc, tile));
        return this;
    }

    public ChangeSet addPartial(See see, FreeColGameObject fcgo, String ... fields) {
        this.changes.add(new PartialObjectChange(see, fcgo, fields));
        return this;
    }

    public ChangeSet addPlayer(ServerPlayer serverPlayer) {
        this.changes.add(new PlayerChange(See.all().except(serverPlayer), serverPlayer));
        return this;
    }

    public ChangeSet addRemove(See see, Location loc, FreeColGameObject obj) {
        this.changes.add(new RemoveChange(see, loc, obj.getDisposeList()));
        return this;
    }

    public ChangeSet addRemoves(See see, Location loc, List<? extends FreeColGameObject> objects) {
        for (FreeColGameObject freeColGameObject : objects) {
            this.changes.add(new RemoveChange(see, loc, freeColGameObject.getDisposeList()));
        }
        return this;
    }

    public ChangeSet addSale(ServerPlayer serverPlayer, Settlement settlement, GoodsType type, int price) {
        Game game = settlement.getGame();
        LastSale sale = new LastSale(settlement, type, game.getTurn(), price);
        this.changes.add(new OwnedChange(See.only(serverPlayer), sale));
        serverPlayer.addLastSale(sale);
        return this;
    }

    public ChangeSet addSpy(See see, Settlement settlement) {
        this.changes.add(new SpyChange(see, settlement));
        return this;
    }

    public ChangeSet addStance(See see, Player first, Stance stance, Player second) {
        this.changes.add(new StanceChange(see, first, stance, second));
        return this;
    }

    public ChangeSet addTradeRoute(ServerPlayer serverPlayer, TradeRoute tradeRoute) {
        this.changes.add(new OwnedChange(See.only(serverPlayer), tradeRoute));
        return this;
    }

    public ChangeSet addTrivial(See see, String name, ChangePriority cp, String ... attributes) {
        this.changes.add(new TrivialChange(see, name, cp.getPriority(), attributes));
        return this;
    }

    private static boolean canSeeUnit(ServerPlayer serverPlayer, Unit unit) {
        Tile tile;
        return serverPlayer.owns(unit) ? true : ((tile = unit.getTile()) == null ? false : (!serverPlayer.canSee(tile) ? false : (tile.hasSettlement() ? false : !unit.isOnCarrier())));
    }

    private static void collapseElements(Element head, Element tail) {
        while (tail.hasChildNodes()) {
            head.appendChild(tail.removeChild(tail.getFirstChild()));
        }
    }

    private static boolean collapseOK(Element e1, Element e2) {
        if (!e1.getTagName().equals(e2.getTagName())) {
            return false;
        }
        NamedNodeMap nnm1 = e1.getAttributes();
        NamedNodeMap nnm2 = e2.getAttributes();
        if (nnm1.getLength() != nnm2.getLength()) {
            return false;
        }
        for (int i = 0; i < nnm1.getLength(); ++i) {
            if (nnm1.item(i).getNodeType() != nnm2.item(i).getNodeType()) {
                return false;
            }
            if (!nnm1.item(i).getNodeName().equals(nnm2.item(i).getNodeName())) {
                return false;
            }
            if (nnm1.item(i).getNodeValue().equals(nnm2.item(i).getNodeValue())) continue;
            return false;
        }
        return true;
    }

    private static List<Element> collapseElementList(List<Element> elements) {
        ArrayList<Element> results = new ArrayList<Element>();
        if (!elements.isEmpty()) {
            Element head = elements.remove(0);
            while (!elements.isEmpty()) {
                Element e = elements.remove(0);
                if (ChangeSet.collapseOK(head, e)) {
                    ChangeSet.collapseElements(head, e);
                    continue;
                }
                results.add(head);
                head = e;
            }
            results.add(head);
        }
        return results;
    }

    public Element build(ServerPlayer serverPlayer) {
        Element result;
        ArrayList<Change> c = new ArrayList<Change>(this.changes);
        List<Element> elements = new ArrayList<Element>();
        ArrayList<Change> diverted = new ArrayList<Change>();
        Document doc = DOMMessage.createNewDocument();
        Collections.sort(c, changeComparator);
        while (!c.isEmpty()) {
            Change change = (Change)c.remove(0);
            if (!change.isNotifiable(serverPlayer)) continue;
            if (change.convertsToElement()) {
                elements.add(change.toElement(serverPlayer, doc));
            } else {
                diverted.add(change);
            }
            c.addAll(change.consequences(serverPlayer));
        }
        elements = ChangeSet.collapseElementList(elements);
        switch (elements.size()) {
            case 0: {
                if (diverted.isEmpty()) {
                    return null;
                }
                result = doc.createElement("update");
                break;
            }
            case 1: {
                result = elements.get(0);
                break;
            }
            default: {
                result = doc.createElement("multiple");
                for (Element e : elements) {
                    result.appendChild(e);
                }
            }
        }
        doc.appendChild(result);
        for (Change change : diverted) {
            change.attachToElement(result);
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        Collections.sort(this.changes, changeComparator);
        for (Change c : this.changes) {
            sb.append(c).append("\n");
        }
        return sb.toString();
    }

    private static class TrivialChange
    extends Change {
        private final int priority;
        private final String name;
        private final String[] attributes;

        public TrivialChange(See see, String name, int priority, String[] attributes) {
            super(see);
            if ((attributes.length & 1) == 1) {
                throw new IllegalArgumentException("Attributes must be even sized");
            }
            this.name = name;
            this.priority = priority;
            this.attributes = attributes;
        }

        @Override
        public int getPriority() {
            return this.priority;
        }

        @Override
        public Element toElement(ServerPlayer serverPlayer, Document doc) {
            Element element = doc.createElement(this.name);
            for (int i = 0; i < this.attributes.length; i += 2) {
                element.setAttribute(this.attributes[i], this.attributes[i + 1]);
            }
            return element;
        }

        @Override
        public void attachToElement(Element element) {
        }

        public String toString() {
            String ret = "[" + this.getClass().getName() + " " + this.see + " #" + this.getPriority() + " " + this.name;
            for (String a : this.attributes) {
                ret = ret + " " + a;
            }
            return ret + "]";
        }
    }

    private static class StanceChange
    extends Change {
        private final Player first;
        private final Stance stance;
        private final Player second;

        public StanceChange(See see, Player first, Stance stance, Player second) {
            super(see);
            this.first = first;
            this.stance = stance;
            this.second = second;
        }

        @Override
        public int getPriority() {
            return ChangePriority.CHANGE_STANCE.getPriority();
        }

        @Override
        public Element toElement(ServerPlayer serverPlayer, Document doc) {
            Element element = doc.createElement("setStance");
            element.setAttribute("stance", this.stance.toString());
            element.setAttribute("first", this.first.getId());
            element.setAttribute("second", this.second.getId());
            return element;
        }

        @Override
        public void attachToElement(Element element) {
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(32);
            sb.append("[").append(this.getClass().getName()).append(" ").append(this.see).append(" #").append(this.getPriority()).append(" ").append(this.first.getId()).append(" ").append(this.stance).append(" ").append(this.second.getId()).append("]");
            return sb.toString();
        }
    }

    private static class SpyChange
    extends Change {
        private final Tile tile;

        public SpyChange(See see, Settlement settlement) {
            super(see);
            this.tile = settlement.getTile();
        }

        @Override
        public int getPriority() {
            return ChangePriority.CHANGE_NORMAL.getPriority();
        }

        @Override
        public Element toElement(ServerPlayer serverPlayer, Document doc) {
            Element element = doc.createElement("spyResult");
            element.setAttribute("tile", this.tile.getId());
            element.appendChild(this.tile.toXMLElement(doc));
            element.appendChild(this.tile.getCachedTile(serverPlayer).toXMLElement(doc, serverPlayer));
            return element;
        }

        @Override
        public void attachToElement(Element element) {
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(32);
            sb.append("[").append(this.getClass().getName()).append(" ").append(this.see).append(" #").append(this.getPriority()).append(" ").append(this.tile.getId()).append("]");
            return sb.toString();
        }
    }

    private static class FeatureChange
    extends Change {
        private final FreeColGameObject object;
        private final Feature feature;
        private final boolean add;

        public FeatureChange(See see, FreeColGameObject object, Feature feature, boolean add) {
            super(see);
            this.object = object;
            this.feature = feature;
            this.add = add;
        }

        @Override
        public int getPriority() {
            return ChangePriority.CHANGE_OWNED.getPriority();
        }

        @Override
        public Element toElement(ServerPlayer serverPlayer, Document doc) {
            Element element = doc.createElement("featureChange");
            element.setAttribute("add", Boolean.toString(this.add));
            element.setAttribute("id", this.object.getId());
            Element child = this.feature.toXMLElement(doc);
            element.appendChild(child);
            return element;
        }

        @Override
        public void attachToElement(Element element) {
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(32);
            sb.append("[").append(this.getClass().getName()).append(" ").append(this.see).append(" #").append(this.getPriority()).append(" ").append(this.add ? "add" : "remove").append(" ").append(this.feature).append(" ").append(this.add ? "to" : "from").append(" ").append(this.object.getId()).append("]");
            return sb.toString();
        }
    }

    private static class OwnedChange
    extends Change {
        private final FreeColObject fco;

        public OwnedChange(See see, FreeColObject fco) {
            super(see);
            this.fco = fco;
        }

        @Override
        public int getPriority() {
            return ChangePriority.CHANGE_OWNED.getPriority();
        }

        @Override
        public Element toElement(ServerPlayer serverPlayer, Document doc) {
            Element element = doc.createElement("addObject");
            Element child = this.fco.toXMLElement(doc, serverPlayer);
            child.setAttribute("owner", serverPlayer.getId());
            element.appendChild(child);
            return element;
        }

        @Override
        public void attachToElement(Element element) {
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(32);
            sb.append("[").append(this.getClass().getName()).append(" ").append(this.see).append(" #").append(this.getPriority()).append(" ").append(this.fco.getId()).append("]");
            return sb.toString();
        }
    }

    private static class RemoveChange
    extends Change {
        private final Tile tile;
        private final FreeColGameObject fcgo;
        private final List<? extends FreeColGameObject> contents;

        public RemoveChange(See see, Location loc, List<? extends FreeColGameObject> objects) {
            super(see);
            this.tile = loc instanceof Tile ? (Tile)loc : null;
            this.fcgo = objects.remove(objects.size() - 1);
            this.contents = objects;
        }

        @Override
        public int getPriority() {
            return ChangePriority.CHANGE_REMOVE.getPriority();
        }

        @Override
        public boolean isPerhapsNotifiable(ServerPlayer serverPlayer) {
            Settlement settlement;
            return this.tile != null && serverPlayer.canSee(this.tile) && ((settlement = this.tile.getSettlement()) == null || settlement.isDisposed() || serverPlayer.owns(settlement));
        }

        @Override
        public Element toElement(ServerPlayer serverPlayer, Document doc) {
            Element element = doc.createElement("remove");
            if (this.fcgo instanceof Ownable && serverPlayer.owns((Ownable)((Object)this.fcgo))) {
                for (FreeColGameObject freeColGameObject : this.contents) {
                    element.appendChild(freeColGameObject.toXMLElementPartial(doc, new String[0]));
                }
                element.setAttribute("divert", this.tile != null ? this.tile.getId() : serverPlayer.getId());
            }
            element.appendChild(this.fcgo.toXMLElementPartial(doc, new String[0]));
            return element;
        }

        @Override
        public void attachToElement(Element element) {
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(32);
            sb.append("[").append(this.getClass().getName()).append(" ").append(this.see).append(" #").append(this.getPriority()).append(" ").append(this.tile == null ? "<null>" : this.tile.getId());
            for (FreeColGameObject freeColGameObject : this.contents) {
                sb.append(" ").append(freeColGameObject.getId());
            }
            sb.append(" ").append(this.fcgo.getId()).append("]");
            return sb.toString();
        }
    }

    private static class PlayerChange
    extends Change {
        private final ServerPlayer player;

        public PlayerChange(See see, ServerPlayer player) {
            super(see);
            this.player = player;
        }

        @Override
        public int getPriority() {
            return ChangePriority.CHANGE_EARLY.getPriority();
        }

        @Override
        public boolean isNotifiable(ServerPlayer serverPlayer) {
            return true;
        }

        @Override
        public Element toElement(ServerPlayer serverPlayer, Document doc) {
            Game game = serverPlayer.getGame();
            Element element = doc.createElement("addPlayer");
            element.appendChild(this.player.toXMLElement(doc, serverPlayer));
            return element;
        }

        @Override
        public void attachToElement(Element element) {
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(32);
            sb.append("[").append(this.getClass().getName()).append(" ").append(this.see).append(" #").append(this.getPriority()).append(" ").append(this.player.getId()).append("]");
            return sb.toString();
        }
    }

    private static class PartialObjectChange
    extends ObjectChange {
        private final String[] fields;

        public PartialObjectChange(See see, FreeColGameObject fcgo, String ... fields) {
            super(see, fcgo);
            this.fields = fields;
        }

        @Override
        public boolean isPerhapsNotifiable(ServerPlayer serverPlayer) {
            return false;
        }

        @Override
        public Element toElement(ServerPlayer serverPlayer, Document doc) {
            Element element = doc.createElement("update");
            element.appendChild(this.fcgo.toXMLElementPartial(doc, this.fields));
            return element;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder(32);
            sb.append("[").append(this.getClass().getName()).append(" ").append(this.see).append(" #").append(this.getPriority()).append(" ").append(this.fcgo.getId());
            for (String f : this.fields) {
                sb.append(" ").append(f);
            }
            sb.append("]");
            return sb.toString();
        }
    }

    private static class ObjectChange
    extends Change {
        protected final FreeColGameObject fcgo;

        public ObjectChange(See see, FreeColGameObject fcgo) {
            super(see);
            this.fcgo = fcgo;
        }

        @Override
        public boolean matches(FreeColGameObject fcgo) {
            return this.fcgo == fcgo;
        }

        @Override
        public int getPriority() {
            return ChangePriority.CHANGE_UPDATE.getPriority();
        }

        @Override
        public boolean isPerhapsNotifiable(ServerPlayer serverPlayer) {
            if (this.fcgo instanceof Unit) {
                return ChangeSet.canSeeUnit(serverPlayer, (Unit)this.fcgo);
            }
            if (this.fcgo instanceof Ownable && serverPlayer.owns((Ownable)((Object)this.fcgo))) {
                return true;
            }
            if (this.fcgo instanceof WorkLocation) {
                return false;
            }
            if (this.fcgo instanceof Location) {
                Tile tile = ((Location)((Object)this.fcgo)).getTile();
                return serverPlayer.canSee(tile);
            }
            return false;
        }

        @Override
        public Element toElement(ServerPlayer serverPlayer, Document doc) {
            Element element = doc.createElement("update");
            element.appendChild(this.fcgo.toXMLElement(doc, serverPlayer));
            return element;
        }

        @Override
        public void attachToElement(Element element) {
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(32);
            sb.append("[").append(this.getClass().getName()).append(" ").append(this.see).append(" #").append(this.getPriority()).append(" ").append(this.fcgo.getId()).append("]");
            return sb.toString();
        }
    }

    private static class MoveChange
    extends Change {
        private final Unit unit;
        private final Location oldLocation;
        private final Tile newTile;

        private boolean seeOld(ServerPlayer serverPlayer) {
            Tile oldTile = this.oldLocation.getTile();
            return serverPlayer.owns(this.unit) || oldTile != null && serverPlayer.canSee(oldTile) && !oldTile.hasSettlement() && !(this.oldLocation instanceof Unit);
        }

        private boolean seeNew(ServerPlayer serverPlayer) {
            return ChangeSet.canSeeUnit(serverPlayer, this.unit);
        }

        public MoveChange(See see, Unit unit, Location oldLocation, Tile newTile) {
            super(see);
            this.unit = unit;
            this.oldLocation = oldLocation;
            this.newTile = newTile;
        }

        @Override
        public int getPriority() {
            return ChangePriority.CHANGE_ANIMATION.getPriority();
        }

        @Override
        public boolean isPerhapsNotifiable(ServerPlayer serverPlayer) {
            return this.seeOld(serverPlayer) || this.seeNew(serverPlayer);
        }

        @Override
        public List<Change> consequences(ServerPlayer serverPlayer) {
            if (this.seeOld(serverPlayer) && !this.seeNew(serverPlayer) && !this.unit.isDisposed()) {
                ArrayList<Unit> units = new ArrayList<Unit>();
                units.add(this.unit);
                ArrayList<Change> changes = new ArrayList<Change>();
                changes.add(new RemoveChange(See.only(serverPlayer), this.unit.getLocation(), units));
                return changes;
            }
            return Collections.emptyList();
        }

        @Override
        public Element toElement(ServerPlayer serverPlayer, Document doc) {
            Element element = doc.createElement("animateMove");
            element.setAttribute("unit", this.unit.getId());
            element.setAttribute("oldTile", this.oldLocation.getTile().getId());
            element.setAttribute("newTile", this.newTile.getId());
            if (!this.seeOld(serverPlayer)) {
                element.appendChild(this.unit.toXMLElement(doc, serverPlayer));
            }
            return element;
        }

        @Override
        public void attachToElement(Element element) {
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(32);
            sb.append("[").append(this.getClass().getName()).append(" ").append(this.see).append(" #").append(this.getPriority()).append(" ").append(this.unit.getId()).append(" ").append(this.oldLocation.getId()).append(" ").append(this.newTile.getId()).append("]");
            return sb.toString();
        }
    }

    private static class MessageChange
    extends Change {
        private final ChangePriority priority;
        private final DOMMessage message;

        public MessageChange(See see, ChangePriority priority, DOMMessage message) {
            super(see);
            this.priority = priority;
            this.message = message;
        }

        @Override
        public int getPriority() {
            return this.priority.getPriority();
        }

        @Override
        public Element toElement(ServerPlayer serverPlayer, Document doc) {
            Element element = this.message.toXMLElement();
            return (Element)doc.importNode(element, true);
        }

        @Override
        public void attachToElement(Element element) {
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(32);
            sb.append("[").append(this.getClass().getName()).append(" ").append(this.see).append(" #").append(this.getPriority()).append(" ").append(this.message).append("]");
            return sb.toString();
        }
    }

    private static class AttributeChange
    extends Change {
        private final String key;
        private final String value;

        public AttributeChange(See see, String key, String value) {
            super(see);
            this.key = key;
            this.value = value;
        }

        @Override
        public int getPriority() {
            return ChangePriority.CHANGE_ATTRIBUTE.getPriority();
        }

        @Override
        public boolean convertsToElement() {
            return false;
        }

        @Override
        public Element toElement(ServerPlayer serverPlayer, Document doc) {
            return null;
        }

        @Override
        public void attachToElement(Element element) {
            element.setAttribute(this.key, this.value);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(32);
            sb.append("[").append(this.getClass().getName()).append(" ").append(this.see).append(" #").append(this.getPriority()).append(" ").append(this.key).append("=").append(this.value).append("]");
            return sb.toString();
        }
    }

    private static class AttackChange
    extends Change {
        private final Unit attacker;
        private final Unit defender;
        private final boolean success;
        private final boolean defenderInSettlement;

        public AttackChange(See see, Unit attacker, Unit defender, boolean success) {
            super(see);
            Game game = attacker.getGame();
            this.defenderInSettlement = defender.getTile().hasSettlement();
            this.attacker = attacker.copy(game, Unit.class);
            this.attacker.setLocationNoUpdate(this.attacker.getTile());
            this.defender = defender.copy(game, Unit.class);
            this.defender.setLocationNoUpdate(this.defender.getTile());
            this.success = success;
        }

        @Override
        public int getPriority() {
            return ChangePriority.CHANGE_ANIMATION.getPriority();
        }

        @Override
        public boolean isPerhapsNotifiable(ServerPlayer serverPlayer) {
            return serverPlayer == this.attacker.getOwner() || serverPlayer == this.defender.getOwner() || serverPlayer.canSee(this.attacker.getTile()) && serverPlayer.canSee(this.defender.getTile());
        }

        @Override
        public Element toElement(ServerPlayer serverPlayer, Document doc) {
            Game game = serverPlayer.getGame();
            Element element = doc.createElement("animateAttack");
            element.setAttribute("attacker", this.attacker.getId());
            element.setAttribute("defender", this.defender.getId());
            element.setAttribute("attackerTile", this.attacker.getTile().getId());
            element.setAttribute("defenderTile", this.defender.getTile().getId());
            element.setAttribute("success", Boolean.toString(this.success));
            if (!ChangeSet.canSeeUnit(serverPlayer, this.attacker)) {
                element.appendChild(this.attacker.toXMLElement(doc));
                if (this.attacker.getLocation() instanceof Unit) {
                    Unit loc = (Unit)this.attacker.getLocation();
                    element.appendChild(loc.toXMLElement(doc, serverPlayer));
                }
            }
            if (!ChangeSet.canSeeUnit(serverPlayer, this.defender) || this.defenderInSettlement) {
                this.defender.setWorkType(null);
                element.appendChild(this.defender.toXMLElement(doc));
            }
            return element;
        }

        @Override
        public void attachToElement(Element element) {
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(64);
            sb.append("[").append(this.getClass().getName()).append(" ").append(this.see).append(" #").append(this.getPriority()).append(" ").append(this.attacker.getId()).append("@").append(this.attacker.getTile().getId()).append(" ").append(this.success).append(" ").append(this.defender.getId()).append("@").append(this.defender.getTile().getId()).append("]");
            return sb.toString();
        }
    }

    private static abstract class Change {
        protected final See see;

        public Change(See see) {
            this.see = see;
        }

        public boolean matches(FreeColGameObject fcgo) {
            return false;
        }

        public abstract int getPriority();

        public boolean isNotifiable(ServerPlayer serverPlayer) {
            return this.see.check(serverPlayer, this.isPerhapsNotifiable(serverPlayer));
        }

        public boolean isPerhapsNotifiable(ServerPlayer serverPlayer) {
            return false;
        }

        public List<Change> consequences(ServerPlayer serverPlayer) {
            return Collections.emptyList();
        }

        public boolean convertsToElement() {
            return true;
        }

        public abstract Element toElement(ServerPlayer var1, Document var2);

        public abstract void attachToElement(Element var1);
    }

    public static class See {
        private static final int ALL = 1;
        private static final int PERHAPS = 0;
        private static final int ONLY = -1;
        private ServerPlayer seeAlways = null;
        private ServerPlayer seePerhaps = null;
        private ServerPlayer seeNever = null;
        private final int type;

        private See(int type) {
            this.type = type;
        }

        public boolean check(ServerPlayer player, boolean perhapsResult) {
            return this.seeNever == player ? false : (this.seeAlways == player ? true : (this.seePerhaps == player ? perhapsResult : (this.type == -1 ? false : (this.type == 1 ? true : perhapsResult))));
        }

        public static See all() {
            return new See(1);
        }

        public static See perhaps() {
            return new See(0);
        }

        public static See only(ServerPlayer player) {
            return new See(-1).always(player);
        }

        public See always(ServerPlayer player) {
            this.seeAlways = player;
            return this;
        }

        public See perhaps(ServerPlayer player) {
            this.seePerhaps = player;
            return this;
        }

        public See except(ServerPlayer player) {
            this.seeNever = player;
            return this;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(64);
            sb.append(this.type == 1 ? "ALL" : (this.type == 0 ? "PERHAPS" : (this.type == -1 ? "ONLY" : "BADTYPE")));
            if (this.seeAlways != null) {
                sb.append(",always(").append(this.seeAlways.getId()).append(")");
            }
            if (this.seePerhaps != null) {
                sb.append(",perhaps(").append(this.seePerhaps.getId()).append(")");
            }
            if (this.seeNever != null) {
                sb.append(",never(").append(this.seeNever.getId()).append(")");
            }
            return sb.toString();
        }
    }

    public static enum ChangePriority {
        CHANGE_ATTRIBUTE(-1),
        CHANGE_ANIMATION(0),
        CHANGE_REMOVE(100),
        CHANGE_STANCE(5),
        CHANGE_OWNED(20),
        CHANGE_UPDATE(10),
        CHANGE_EARLY(1),
        CHANGE_NORMAL(15),
        CHANGE_LATE(90);

        private final int level;

        private ChangePriority(int level) {
            this.level = level;
        }

        public int getPriority() {
            return this.level;
        }
    }
}

