/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.logging;

import org.gradle.api.internal.tasks.testing.logging.AbstractTestLogger;
import org.gradle.api.internal.tasks.testing.logging.TestExceptionFormatter;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.tasks.testing.TestDescriptor;
import org.gradle.api.tasks.testing.TestListener;
import org.gradle.api.tasks.testing.TestOutputEvent;
import org.gradle.api.tasks.testing.TestOutputListener;
import org.gradle.api.tasks.testing.TestResult;
import org.gradle.api.tasks.testing.logging.TestLogEvent;
import org.gradle.api.tasks.testing.logging.TestLogging;
import org.gradle.logging.StyledTextOutputFactory;
import org.gradle.util.TextUtil;

public class TestEventLogger
extends AbstractTestLogger
implements TestListener,
TestOutputListener {
    private static final String INDENT = "    ";
    private final TestExceptionFormatter exceptionFormatter;
    private final TestLogging testLogging;

    public TestEventLogger(StyledTextOutputFactory textOutputFactory, LogLevel logLevel, TestLogging testLogging, TestExceptionFormatter exceptionFormatter) {
        super(textOutputFactory, logLevel, testLogging.getDisplayGranularity());
        this.exceptionFormatter = exceptionFormatter;
        this.testLogging = testLogging;
    }

    public void beforeSuite(TestDescriptor descriptor) {
        this.before(descriptor);
    }

    public void afterSuite(TestDescriptor descriptor, TestResult result) {
        this.after(descriptor, result);
    }

    public void beforeTest(TestDescriptor descriptor) {
        this.before(descriptor);
    }

    public void afterTest(TestDescriptor descriptor, TestResult result) {
        this.after(descriptor, result);
    }

    public void onOutput(TestDescriptor descriptor, TestOutputEvent outputEvent) {
        if (outputEvent.getDestination() == TestOutputEvent.Destination.StdOut && this.isLoggedEventType(TestLogEvent.STANDARD_OUT)) {
            this.logEvent(descriptor, TestLogEvent.STANDARD_OUT, TextUtil.indent((String)outputEvent.getMessage(), (String)INDENT) + "\n");
        } else if (outputEvent.getDestination() == TestOutputEvent.Destination.StdErr && this.isLoggedEventType(TestLogEvent.STANDARD_ERROR)) {
            this.logEvent(descriptor, TestLogEvent.STANDARD_ERROR, TextUtil.indent((String)outputEvent.getMessage(), (String)INDENT) + "\n");
        }
    }

    private void before(TestDescriptor descriptor) {
        if (this.shouldLogEvent(descriptor, TestLogEvent.STARTED)) {
            this.logEvent(descriptor, TestLogEvent.STARTED);
        }
    }

    private void after(TestDescriptor descriptor, TestResult result) {
        TestLogEvent event = this.getEvent(result);
        if (this.shouldLogEvent(descriptor, event)) {
            String details = this.shouldLogExceptions(result) ? this.exceptionFormatter.format(descriptor, result.getExceptions()) : null;
            this.logEvent(descriptor, event, details);
        }
    }

    private TestLogEvent getEvent(TestResult result) {
        switch (result.getResultType()) {
            case SUCCESS: {
                return TestLogEvent.PASSED;
            }
            case FAILURE: {
                return TestLogEvent.FAILED;
            }
            case SKIPPED: {
                return TestLogEvent.SKIPPED;
            }
        }
        throw new AssertionError();
    }

    private boolean shouldLogEvent(TestDescriptor descriptor, TestLogEvent event) {
        return this.isLoggedGranularity(descriptor) && this.isLoggedEventType(event);
    }

    private boolean shouldLogExceptions(TestResult result) {
        return this.testLogging.getShowExceptions() && !result.getExceptions().isEmpty();
    }

    private boolean isLoggedGranularity(TestDescriptor descriptor) {
        int level = this.getLevel(descriptor);
        return (this.testLogging.getMinGranularity() == -1 && !descriptor.isComposite() || this.testLogging.getMinGranularity() > -1 && level >= this.testLogging.getMinGranularity()) && (this.testLogging.getMaxGranularity() == -1 || level <= this.testLogging.getMaxGranularity());
    }

    private int getLevel(TestDescriptor descriptor) {
        int level = 0;
        while (descriptor.getParent() != null) {
            ++level;
            descriptor = descriptor.getParent();
        }
        return level;
    }

    private boolean isLoggedEventType(TestLogEvent event) {
        return this.testLogging.getEvents().contains((Object)event);
    }
}

