/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.messaging.remote.internal.hub;

import java.util.HashSet;
import java.util.Set;
import org.gradle.messaging.remote.internal.RemoteConnection;
import org.gradle.messaging.remote.internal.hub.ConnectionState;
import org.gradle.messaging.remote.internal.hub.IncomingQueue;
import org.gradle.messaging.remote.internal.hub.OutgoingQueue;
import org.gradle.messaging.remote.internal.hub.protocol.ConnectionClosed;
import org.gradle.messaging.remote.internal.hub.protocol.ConnectionEstablished;
import org.gradle.messaging.remote.internal.hub.protocol.EndOfStream;
import org.gradle.messaging.remote.internal.hub.protocol.InterHubMessage;
import org.gradle.messaging.remote.internal.hub.queue.EndPointQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ConnectionSet {
    private final Set<ConnectionState> connections = new HashSet<ConnectionState>();
    private final IncomingQueue incomingQueue;
    private final OutgoingQueue outgoingQueue;
    private boolean stopping;

    ConnectionSet(IncomingQueue incomingQueue, OutgoingQueue outgoingQueue) {
        this.incomingQueue = incomingQueue;
        this.outgoingQueue = outgoingQueue;
    }

    public ConnectionState add(RemoteConnection<InterHubMessage> connection) {
        this.incomingQueue.queue(new ConnectionEstablished(connection));
        EndPointQueue queue = this.outgoingQueue.newEndpoint();
        ConnectionState state = new ConnectionState(this, connection, queue);
        this.connections.add(state);
        return state;
    }

    public void finished(ConnectionState connectionState) {
        this.incomingQueue.queue(new ConnectionClosed(connectionState.getConnection()));
        this.connections.remove(connectionState);
        if (this.stopping) {
            this.maybeStop();
        }
    }

    public void requestStop() {
        this.stopping = true;
        this.maybeStop();
    }

    private void maybeStop() {
        if (this.connections.isEmpty()) {
            this.outgoingQueue.discardQueued();
            this.incomingQueue.queue(new EndOfStream());
        }
    }
}

