/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transport.file;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.gradle.internal.resource.local.DefaultLocallyAvailableExternalResource;
import org.gradle.internal.resource.local.DefaultLocallyAvailableResource;
import org.gradle.internal.resource.local.LocalResource;
import org.gradle.internal.resource.local.LocallyAvailableExternalResource;
import org.gradle.internal.resource.local.LocallyAvailableResource;
import org.gradle.internal.resource.metadata.ExternalResourceMetaData;
import org.gradle.internal.resource.transport.ExternalResourceRepository;
import org.gradle.util.GFileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileResourceConnector
implements ExternalResourceRepository {
    @Override
    public ExternalResourceRepository withProgressLogging() {
        return this;
    }

    @Override
    public List<String> list(URI parent) {
        String[] names;
        File dir = FileResourceConnector.getFile(parent);
        if (dir.exists() && dir.isDirectory() && (names = dir.list()) != null) {
            return Arrays.asList(names);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(LocalResource source, URI destination) throws IOException {
        File target = FileResourceConnector.getFile(destination);
        if (!target.canWrite()) {
            target.delete();
        }
        GFileUtils.mkdirs((File)target.getParentFile());
        InputStream input = source.open();
        try {
            FileOutputStream output = new FileOutputStream(target);
            try {
                IOUtils.copyLarge((InputStream)input, (OutputStream)output);
            }
            finally {
                output.close();
            }
        }
        finally {
            input.close();
        }
    }

    public LocallyAvailableExternalResource getResource(URI uri) {
        File localFile = FileResourceConnector.getFile(uri);
        if (!localFile.exists()) {
            return null;
        }
        return new DefaultLocallyAvailableExternalResource(uri, (LocallyAvailableResource)new DefaultLocallyAvailableResource(localFile));
    }

    @Override
    public ExternalResourceMetaData getResourceMetaData(URI location) {
        LocallyAvailableExternalResource resource = this.getResource(location);
        return resource == null ? null : resource.getMetaData();
    }

    private static File getFile(URI uri) {
        return new File(uri);
    }
}

