/*
 * Decompiled with CFR 0.152.
 */
package com.kitfox.svg;

import com.kitfox.svg.FillElement;
import com.kitfox.svg.Marker;
import com.kitfox.svg.RenderableElement;
import com.kitfox.svg.SVGException;
import com.kitfox.svg.xml.StyleAttribute;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;

public abstract class ShapeElement
extends RenderableElement {
    protected float strokeWidthScalar = 1.0f;

    @Override
    public abstract void render(Graphics2D var1) throws SVGException;

    @Override
    void pick(Point2D point2D, boolean bl, List list) throws SVGException {
        if ((bl ? this.getBoundingBox() : this.getShape()).contains(point2D)) {
            list.add(this.getPath(null));
        }
    }

    @Override
    void pick(Rectangle2D rectangle2D, AffineTransform affineTransform, boolean bl, List list) throws SVGException {
        StyleAttribute styleAttribute = new StyleAttribute();
        if (affineTransform.createTransformedShape(bl ? this.getBoundingBox() : this.getShape()).intersects(rectangle2D)) {
            list.add(this.getPath(null));
        }
    }

    private Paint handleCurrentColor(StyleAttribute styleAttribute) throws SVGException {
        if (styleAttribute.getStringValue().equals("currentColor")) {
            StyleAttribute styleAttribute2 = new StyleAttribute();
            if (this.getStyle(styleAttribute2.setName("color")) && !styleAttribute2.getStringValue().equals("none")) {
                return styleAttribute2.getColorValue();
            }
            return null;
        }
        return styleAttribute.getColorValue();
    }

    protected void renderShape(Graphics2D graphics2D, Shape shape) throws SVGException {
        Object object;
        Object object2;
        Object object3;
        Serializable serializable;
        Serializable serializable2;
        Object object4;
        Object object5;
        Object object6;
        StyleAttribute styleAttribute = new StyleAttribute();
        if (this.getStyle(styleAttribute.setName("visibility")) && !styleAttribute.getStringValue().equals("visible")) {
            return;
        }
        if (this.getStyle(styleAttribute.setName("display")) && styleAttribute.getStringValue().equals("none")) {
            return;
        }
        Paint paint = Color.black;
        if (this.getStyle(styleAttribute.setName("fill"))) {
            if (styleAttribute.getStringValue().equals("none")) {
                paint = null;
            } else {
                URI uRI;
                paint = this.handleCurrentColor(styleAttribute);
                if (paint == null && (uRI = styleAttribute.getURIValue(this.getXMLBase())) != null) {
                    Rectangle2D rectangle2D = shape.getBounds2D();
                    object6 = graphics2D.getTransform();
                    object5 = this.diagram.getUniverse().getElement(uRI);
                    if (object5 != null) {
                        paint = ((FillElement)object5).getPaint(rectangle2D, (AffineTransform)object6);
                    }
                }
            }
        }
        float f = 1.0f;
        if (this.getStyle(styleAttribute.setName("opacity"))) {
            f = styleAttribute.getRatioValue();
        }
        float f2 = f;
        if (this.getStyle(styleAttribute.setName("fill-opacity"))) {
            f2 *= styleAttribute.getRatioValue();
        }
        object6 = null;
        if (this.getStyle(styleAttribute.setName("stroke"))) {
            if (styleAttribute.getStringValue().equals("none")) {
                object6 = null;
            } else {
                object6 = this.handleCurrentColor(styleAttribute);
                if (object6 == null && (object5 = styleAttribute.getURIValue(this.getXMLBase())) != null) {
                    Rectangle2D rectangle2D = shape.getBounds2D();
                    AffineTransform affineTransform = graphics2D.getTransform();
                    object4 = this.diagram.getUniverse().getElement((URI)object5);
                    if (object4 != null) {
                        object6 = ((FillElement)object4).getPaint(rectangle2D, affineTransform);
                    }
                }
            }
        }
        object5 = null;
        if (this.getStyle(styleAttribute.setName("stroke-dasharray")) && ((Object)(object5 = (Object)styleAttribute.getFloatList())).length == 0) {
            object5 = null;
        }
        float f3 = 0.0f;
        if (this.getStyle(styleAttribute.setName("stroke-dashoffset"))) {
            f3 = styleAttribute.getFloatValueWithUnits();
        }
        int n = 0;
        if (this.getStyle(styleAttribute.setName("stroke-linecap"))) {
            object4 = styleAttribute.getStringValue();
            if (((String)object4).equals("round")) {
                n = 1;
            } else if (((String)object4).equals("square")) {
                n = 2;
            }
        }
        int n2 = 0;
        if (this.getStyle(styleAttribute.setName("stroke-linejoin"))) {
            String string = styleAttribute.getStringValue();
            if (string.equals("round")) {
                n2 = 1;
            } else if (string.equals("bevel")) {
                n2 = 2;
            }
        }
        float f4 = 4.0f;
        if (this.getStyle(styleAttribute.setName("stroke-miterlimit"))) {
            f4 = Math.max(styleAttribute.getFloatValueWithUnits(), 1.0f);
        }
        float f5 = f;
        if (this.getStyle(styleAttribute.setName("stroke-opacity"))) {
            f5 *= styleAttribute.getRatioValue();
        }
        float f6 = 1.0f;
        if (this.getStyle(styleAttribute.setName("stroke-width"))) {
            f6 = styleAttribute.getFloatValueWithUnits();
        }
        f6 *= this.strokeWidthScalar;
        Marker marker = null;
        if (this.getStyle(styleAttribute.setName("marker-start")) && !styleAttribute.getStringValue().equals("none")) {
            serializable2 = styleAttribute.getURIValue(this.getXMLBase());
            marker = (Marker)this.diagram.getUniverse().getElement((URI)serializable2);
        }
        serializable2 = null;
        if (this.getStyle(styleAttribute.setName("marker-mid")) && !styleAttribute.getStringValue().equals("none")) {
            serializable = styleAttribute.getURIValue(this.getXMLBase());
            serializable2 = (Marker)this.diagram.getUniverse().getElement((URI)serializable);
        }
        serializable = null;
        if (this.getStyle(styleAttribute.setName("marker-end")) && !styleAttribute.getStringValue().equals("none")) {
            object3 = styleAttribute.getURIValue(this.getXMLBase());
            serializable = (Marker)this.diagram.getUniverse().getElement((URI)object3);
        }
        if (paint != null && f2 != 0.0f && !(f2 <= 0.0f)) {
            if (f2 < 1.0f) {
                object3 = graphics2D.getComposite();
                graphics2D.setComposite(AlphaComposite.getInstance(3, f2));
                graphics2D.setPaint(paint);
                graphics2D.fill(shape);
                graphics2D.setComposite((Composite)object3);
            } else {
                graphics2D.setPaint(paint);
                graphics2D.fill(shape);
            }
        }
        if (object6 != null && f5 != 0.0f) {
            object3 = object5 == null ? new BasicStroke(f6, n, n2, f4) : new BasicStroke(f6, n, n2, f4, (float[])object5, f3);
            AffineTransform affineTransform = graphics2D.getTransform();
            if (this.vectorEffect == 1) {
                object2 = affineTransform.createTransformedShape(shape);
                object2 = ((BasicStroke)object3).createStrokedShape((Shape)object2);
            } else {
                object2 = ((BasicStroke)object3).createStrokedShape(shape);
            }
            if (!(f5 <= 0.0f)) {
                object = graphics2D.getComposite();
                if (f5 < 1.0f) {
                    graphics2D.setComposite(AlphaComposite.getInstance(3, f5));
                }
                if (this.vectorEffect == 1) {
                    graphics2D.setTransform(new AffineTransform());
                }
                graphics2D.setPaint((Paint)object6);
                graphics2D.fill((Shape)object2);
                if (this.vectorEffect == 1) {
                    graphics2D.setTransform(affineTransform);
                }
                if (f5 < 1.0f) {
                    graphics2D.setComposite((Composite)object);
                }
            }
        }
        if (marker != null || serializable2 != null || serializable != null) {
            object3 = new Marker.MarkerLayout();
            ((Marker.MarkerLayout)object3).layout(shape);
            object2 = ((Marker.MarkerLayout)object3).getMarkerList();
            block5: for (int i = 0; i < ((ArrayList)object2).size(); ++i) {
                object = (Marker.MarkerPos)((ArrayList)object2).get(i);
                switch (((Marker.MarkerPos)object).type) {
                    case 0: {
                        if (marker == null) continue block5;
                        marker.render(graphics2D, (Marker.MarkerPos)object, f6);
                        continue block5;
                    }
                    case 1: {
                        if (serializable2 == null) continue block5;
                        ((Marker)serializable2).render(graphics2D, (Marker.MarkerPos)object, f6);
                        continue block5;
                    }
                    case 2: {
                        if (serializable == null) continue block5;
                        ((Marker)serializable).render(graphics2D, (Marker.MarkerPos)object, f6);
                    }
                }
            }
        }
    }

    public abstract Shape getShape();

    protected Rectangle2D includeStrokeInBounds(Rectangle2D rectangle2D) throws SVGException {
        StyleAttribute styleAttribute = new StyleAttribute();
        if (!this.getStyle(styleAttribute.setName("stroke"))) {
            return rectangle2D;
        }
        double d = 1.0;
        if (this.getStyle(styleAttribute.setName("stroke-width"))) {
            d = styleAttribute.getDoubleValue();
        }
        rectangle2D.setRect(rectangle2D.getX() - d / 2.0, rectangle2D.getY() - d / 2.0, rectangle2D.getWidth() + d, rectangle2D.getHeight() + d);
        return rectangle2D;
    }
}

