/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.TagMap;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.MultiMap;

public class DuplicateWay
extends Test {
    protected static final int DUPLICATE_WAY = 1401;
    protected static final int SAME_WAY = 1402;
    private MultiMap<WayPair, OsmPrimitive> ways;
    private MultiMap<WayPairNoTags, OsmPrimitive> waysNoTags;
    private Set<Integer> knownHashCodes;

    public DuplicateWay() {
        super(I18n.tr("Duplicated ways", new Object[0]), I18n.tr("This test checks that there are no ways with same node coordinates and optionally also same tags.", new Object[0]));
    }

    @Override
    public void startTest(ProgressMonitor progressMonitor) {
        super.startTest(progressMonitor);
        this.ways = new MultiMap(1000);
        this.waysNoTags = new MultiMap(1000);
        this.knownHashCodes = new HashSet<Integer>(1000);
    }

    @Override
    public void endTest() {
        Object object;
        super.endTest();
        for (Set<OsmPrimitive> set : this.ways.values()) {
            if (set.size() <= 1) continue;
            object = new TestError((Test)this, Severity.ERROR, I18n.tr("Duplicated ways", new Object[0]), 1401, set);
            this.errors.add(object);
        }
        for (Set<OsmPrimitive> set : this.waysNoTags.values()) {
            if (set.size() <= 1) continue;
            object = null;
            boolean bl = true;
            for (OsmPrimitive osmPrimitive : set) {
                if (object == null) {
                    object = osmPrimitive.getKeys();
                    this.removeUninterestingKeys((Map<String, String>)object);
                    continue;
                }
                TagMap tagMap = osmPrimitive.getKeys();
                this.removeUninterestingKeys(tagMap);
                if (tagMap.equals(object)) continue;
                bl = false;
                break;
            }
            if (bl) continue;
            TestError testError = new TestError((Test)this, Severity.WARNING, I18n.tr("Ways with same position", new Object[0]), 1402, set);
            this.errors.add(testError);
        }
        this.ways = null;
        this.waysNoTags = null;
        this.knownHashCodes = null;
    }

    public void removeUninterestingKeys(Map<String, String> map) {
        for (String string : OsmPrimitive.getDiscardableKeys()) {
            map.remove(string);
        }
    }

    @Override
    public void visit(Way way) {
        Object object;
        int n;
        if (!way.isUsable()) {
            return;
        }
        Object object2 = DuplicateWay.getOrderedNodes(way);
        if (!way.hasDirectionKeys() && !this.knownHashCodes.contains(n = object2.hashCode())) {
            object = new ArrayList<LatLon>((Collection<LatLon>)object2);
            Collections.reverse(object);
            int n2 = object.hashCode();
            if (!this.knownHashCodes.contains(n2)) {
                this.knownHashCodes.add(n);
            } else {
                object2 = object;
            }
        }
        TagMap tagMap = way.getKeys();
        this.removeUninterestingKeys(tagMap);
        object = new WayPair((List<LatLon>)object2, tagMap);
        this.ways.put((WayPair)object, way);
        WayPairNoTags wayPairNoTags = new WayPairNoTags((List<LatLon>)object2);
        this.waysNoTags.put(wayPairNoTags, way);
    }

    public static List<LatLon> getOrderedNodes(Way way) {
        List<Node> list = way.getNodes();
        ArrayList<Node> arrayList = new ArrayList<Node>(list.size());
        if (way.isClosed()) {
            int n;
            int n2 = 0;
            long l = list.get(0).getUniqueId();
            for (n = 1; n < list.size(); ++n) {
                if (list.get(n).getUniqueId() >= l) continue;
                l = list.get(n).getUniqueId();
                n2 = n;
            }
            for (n = n2; n < list.size() - 1; ++n) {
                arrayList.add(list.get(n));
            }
            for (n = 0; n < n2; ++n) {
                arrayList.add(list.get(n));
            }
            arrayList.add(list.get(n2));
        } else {
            arrayList.addAll(list);
        }
        ArrayList<LatLon> arrayList2 = new ArrayList<LatLon>(arrayList.size());
        for (Node node : arrayList) {
            arrayList2.add(node.getCoor());
        }
        return arrayList2;
    }

    @Override
    public Command fixError(TestError testError) {
        Collection<? extends OsmPrimitive> collection = testError.getPrimitives();
        HashSet<Way> hashSet = new HashSet<Way>();
        for (OsmPrimitive osmPrimitive : collection) {
            if (!(osmPrimitive instanceof Way) || osmPrimitive.isDeleted()) continue;
            hashSet.add((Way)osmPrimitive);
        }
        if (hashSet.size() < 2) {
            return null;
        }
        long l = 0L;
        Way object = (Way)hashSet.iterator().next();
        Way object2 = null;
        List<Relation> list = null;
        for (Way object3 : hashSet) {
            List<Relation> list2 = OsmPrimitive.getFilteredList(object3.getReferrers(), Relation.class);
            if (!list2.isEmpty()) {
                if (object2 != null) {
                    throw new AssertionError((Object)"Cannot fix duplicate Ways: More than one way is relation member.");
                }
                object2 = object3;
                list = list2;
            }
            if (object3.isNew() || l != 0L && object3.getId() >= l) continue;
            l = object3.getId();
            object = object3;
        }
        LinkedList linkedList = new LinkedList();
        if (object2 != null && object != object2) {
            for (Relation relation : list) {
                Relation relation2 = new Relation(relation);
                for (int i = 0; i < relation2.getMembers().size(); ++i) {
                    RelationMember relationMember = relation2.getMember(i);
                    if (!object2.equals(relationMember.getMember())) continue;
                    relation2.setMember(i, new RelationMember(relationMember.getRole(), object));
                }
                linkedList.add(new ChangeCommand(relation, relation2));
            }
        }
        hashSet.remove(object);
        linkedList.add(new DeleteCommand(hashSet));
        return new SequenceCommand(I18n.tr("Delete duplicate ways", new Object[0]), linkedList);
    }

    @Override
    public boolean isFixable(TestError testError) {
        if (!(testError.getTester() instanceof DuplicateWay)) {
            return false;
        }
        if (testError.getCode() != 1401) {
            return false;
        }
        Collection<? extends OsmPrimitive> collection = testError.getPrimitives();
        HashSet<Way> hashSet = new HashSet<Way>();
        for (OsmPrimitive object : collection) {
            if (!(object instanceof Way)) continue;
            hashSet.add((Way)object);
        }
        if (hashSet.size() < 2) {
            return false;
        }
        int n = 0;
        for (Way way : hashSet) {
            List<Relation> list = OsmPrimitive.getFilteredList(way.getReferrers(), Relation.class);
            if (list.isEmpty()) continue;
            ++n;
        }
        return n <= 1;
    }

    private static class WayPairNoTags {
        private final List<LatLon> coor;

        WayPairNoTags(List<LatLon> list) {
            this.coor = list;
        }

        public int hashCode() {
            return Objects.hash(this.coor);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            WayPairNoTags wayPairNoTags = (WayPairNoTags)object;
            return Objects.equals(this.coor, wayPairNoTags.coor);
        }
    }

    private static class WayPair {
        private final List<LatLon> coor;
        private final Map<String, String> keys;

        WayPair(List<LatLon> list, Map<String, String> map) {
            this.coor = list;
            this.keys = map;
        }

        public int hashCode() {
            return Objects.hash(this.coor, this.keys);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            WayPair wayPair = (WayPair)object;
            return Objects.equals(this.coor, wayPair.coor) && Objects.equals(this.keys, wayPair.keys);
        }
    }
}

