/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.conflict.pair;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.conflict.pair.ComparePairListCellRenderer;
import org.openstreetmap.josm.gui.conflict.pair.ComparePairType;
import org.openstreetmap.josm.gui.conflict.pair.IConflictResolver;
import org.openstreetmap.josm.gui.conflict.pair.ListMergeModel;
import org.openstreetmap.josm.gui.conflict.pair.ListRole;
import org.openstreetmap.josm.gui.conflict.pair.MergeDecisionType;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.util.AdjustmentSynchronizer;
import org.openstreetmap.josm.gui.widgets.JosmComboBox;
import org.openstreetmap.josm.gui.widgets.OsmPrimitivesTable;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public abstract class ListMerger<T extends PrimitiveId>
extends JPanel
implements PropertyChangeListener,
ChangeListener,
IConflictResolver {
    protected OsmPrimitivesTable myEntriesTable;
    protected OsmPrimitivesTable mergedEntriesTable;
    protected OsmPrimitivesTable theirEntriesTable;
    protected transient ListMergeModel<T> model;
    private CopyStartLeftAction copyStartLeftAction;
    private CopyBeforeCurrentLeftAction copyBeforeCurrentLeftAction;
    private CopyAfterCurrentLeftAction copyAfterCurrentLeftAction;
    private CopyEndLeftAction copyEndLeftAction;
    private CopyAllLeft copyAllLeft;
    private CopyStartRightAction copyStartRightAction;
    private CopyBeforeCurrentRightAction copyBeforeCurrentRightAction;
    private CopyAfterCurrentRightAction copyAfterCurrentRightAction;
    private CopyEndRightAction copyEndRightAction;
    private CopyAllRight copyAllRight;
    private MoveUpMergedAction moveUpMergedAction;
    private MoveDownMergedAction moveDownMergedAction;
    private RemoveMergedAction removeMergedAction;
    private FreezeAction freezeAction;
    private transient AdjustmentSynchronizer adjustmentSynchronizer;
    private JLabel lblMyVersion;
    private JLabel lblMergedVersion;
    private JLabel lblTheirVersion;
    private JLabel lblFrozenState;

    protected abstract JScrollPane buildMyElementsTable();

    protected abstract JScrollPane buildMergedElementsTable();

    protected abstract JScrollPane buildTheirElementsTable();

    protected JScrollPane embeddInScrollPane(JTable jTable) {
        JScrollPane jScrollPane = new JScrollPane(jTable);
        if (this.adjustmentSynchronizer == null) {
            this.adjustmentSynchronizer = new AdjustmentSynchronizer();
        }
        return jScrollPane;
    }

    protected void wireActionsToSelectionModels() {
        this.myEntriesTable.getSelectionModel().addListSelectionListener(this.copyStartLeftAction);
        this.myEntriesTable.getSelectionModel().addListSelectionListener(this.copyBeforeCurrentLeftAction);
        this.mergedEntriesTable.getSelectionModel().addListSelectionListener(this.copyBeforeCurrentLeftAction);
        this.myEntriesTable.getSelectionModel().addListSelectionListener(this.copyAfterCurrentLeftAction);
        this.mergedEntriesTable.getSelectionModel().addListSelectionListener(this.copyAfterCurrentLeftAction);
        this.myEntriesTable.getSelectionModel().addListSelectionListener(this.copyEndLeftAction);
        this.theirEntriesTable.getSelectionModel().addListSelectionListener(this.copyStartRightAction);
        this.theirEntriesTable.getSelectionModel().addListSelectionListener(this.copyBeforeCurrentRightAction);
        this.mergedEntriesTable.getSelectionModel().addListSelectionListener(this.copyBeforeCurrentRightAction);
        this.theirEntriesTable.getSelectionModel().addListSelectionListener(this.copyAfterCurrentRightAction);
        this.mergedEntriesTable.getSelectionModel().addListSelectionListener(this.copyAfterCurrentRightAction);
        this.theirEntriesTable.getSelectionModel().addListSelectionListener(this.copyEndRightAction);
        this.mergedEntriesTable.getSelectionModel().addListSelectionListener(this.moveUpMergedAction);
        this.mergedEntriesTable.getSelectionModel().addListSelectionListener(this.moveDownMergedAction);
        this.mergedEntriesTable.getSelectionModel().addListSelectionListener(this.removeMergedAction);
        this.model.addChangeListener(this.copyAllLeft);
        this.model.addChangeListener(this.copyAllRight);
        this.model.addPropertyChangeListener(this.copyAllLeft);
        this.model.addPropertyChangeListener(this.copyAllRight);
    }

    protected JPanel buildLeftButtonPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.copyStartLeftAction = new CopyStartLeftAction();
        JButton jButton = new JButton(this.copyStartLeftAction);
        jButton.setName("button.copystartleft");
        jPanel.add((Component)jButton, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.copyBeforeCurrentLeftAction = new CopyBeforeCurrentLeftAction();
        jButton = new JButton(this.copyBeforeCurrentLeftAction);
        jButton.setName("button.copybeforecurrentleft");
        jPanel.add((Component)jButton, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.copyAfterCurrentLeftAction = new CopyAfterCurrentLeftAction();
        jButton = new JButton(this.copyAfterCurrentLeftAction);
        jButton.setName("button.copyaftercurrentleft");
        jPanel.add((Component)jButton, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        this.copyEndLeftAction = new CopyEndLeftAction();
        jButton = new JButton(this.copyEndLeftAction);
        jButton.setName("button.copyendleft");
        jPanel.add((Component)jButton, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        this.copyAllLeft = new CopyAllLeft();
        jButton = new JButton(this.copyAllLeft);
        jButton.setName("button.copyallleft");
        jPanel.add((Component)jButton, gridBagConstraints);
        return jPanel;
    }

    protected JPanel buildRightButtonPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.copyStartRightAction = new CopyStartRightAction();
        jPanel.add((Component)new JButton(this.copyStartRightAction), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.copyBeforeCurrentRightAction = new CopyBeforeCurrentRightAction();
        jPanel.add((Component)new JButton(this.copyBeforeCurrentRightAction), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.copyAfterCurrentRightAction = new CopyAfterCurrentRightAction();
        jPanel.add((Component)new JButton(this.copyAfterCurrentRightAction), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        this.copyEndRightAction = new CopyEndRightAction();
        jPanel.add((Component)new JButton(this.copyEndRightAction), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        this.copyAllRight = new CopyAllRight();
        jPanel.add((Component)new JButton(this.copyAllRight), gridBagConstraints);
        return jPanel;
    }

    protected JPanel buildMergedListControlButtons() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.3;
        gridBagConstraints.weighty = 0.0;
        this.moveUpMergedAction = new MoveUpMergedAction();
        jPanel.add((Component)new JButton(this.moveUpMergedAction), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.moveDownMergedAction = new MoveDownMergedAction();
        jPanel.add((Component)new JButton(this.moveDownMergedAction), gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        this.removeMergedAction = new RemoveMergedAction();
        jPanel.add((Component)new JButton(this.removeMergedAction), gridBagConstraints);
        return jPanel;
    }

    protected JPanel buildAdjustmentLockControlPanel(JCheckBox jCheckBox) {
        JPanel jPanel = new JPanel(new FlowLayout(2));
        jPanel.add(new JLabel(I18n.tr("lock scrolling", new Object[0])));
        jPanel.add(jCheckBox);
        return jPanel;
    }

    protected JPanel buildComparePairSelectionPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(0));
        jPanel.add(new JLabel(I18n.tr("Compare ", new Object[0])));
        JosmComboBox<ComparePairType> josmComboBox = new JosmComboBox<ComparePairType>(this.model.getComparePairListModel());
        josmComboBox.setRenderer(new ComparePairListCellRenderer());
        jPanel.add(josmComboBox);
        return jPanel;
    }

    protected JPanel buildFrozeStateControlPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(0));
        this.lblFrozenState = new JLabel();
        jPanel.add(this.lblFrozenState);
        this.freezeAction = new FreezeAction();
        JToggleButton jToggleButton = new JToggleButton(this.freezeAction);
        this.freezeAction.adapt(jToggleButton);
        jToggleButton.setName("button.freeze");
        jPanel.add(jToggleButton);
        return jPanel;
    }

    protected final void build() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.lblMyVersion = new JLabel(I18n.tr("My version", new Object[0]));
        this.lblMyVersion.setToolTipText(I18n.tr("List of elements in my dataset, i.e. the local dataset", new Object[0]));
        this.add((Component)this.lblMyVersion, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        this.lblMergedVersion = new JLabel(I18n.tr("Merged version", new Object[0]));
        this.lblMergedVersion.setToolTipText(I18n.tr("List of merged elements. They will replace the list of my elements when the merge decisions are applied.", new Object[0]));
        this.add((Component)this.lblMergedVersion, gridBagConstraints);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        this.lblTheirVersion = new JLabel(I18n.tr("Their version", new Object[0]));
        this.lblTheirVersion.setToolTipText(I18n.tr("List of elements in their dataset, i.e. the server dataset", new Object[0]));
        this.add((Component)this.lblTheirVersion, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 0.33;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        JCheckBox jCheckBox = new JCheckBox();
        jCheckBox.setName("checkbox.lockmyscrolling");
        this.add((Component)this.buildAdjustmentLockControlPanel(jCheckBox), gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        JCheckBox jCheckBox2 = new JCheckBox();
        jCheckBox2.setName("checkbox.lockmergedscrolling");
        this.add((Component)this.buildAdjustmentLockControlPanel(jCheckBox2), gridBagConstraints);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        JCheckBox jCheckBox3 = new JCheckBox();
        jCheckBox3.setName("checkbox.locktheirscrolling");
        this.add((Component)this.buildAdjustmentLockControlPanel(jCheckBox3), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 0.33;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        JScrollPane jScrollPane = this.buildMyElementsTable();
        this.lblMyVersion.setLabelFor(jScrollPane);
        this.adjustmentSynchronizer.adapt(jCheckBox, jScrollPane.getVerticalScrollBar());
        this.add((Component)jScrollPane, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.add((Component)this.buildLeftButtonPanel(), gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 0.33;
        gridBagConstraints.weighty = 0.0;
        jScrollPane = this.buildMergedElementsTable();
        this.lblMergedVersion.setLabelFor(jScrollPane);
        this.adjustmentSynchronizer.adapt(jCheckBox2, jScrollPane.getVerticalScrollBar());
        this.add((Component)jScrollPane, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.add((Component)this.buildRightButtonPanel(), gridBagConstraints);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 0.33;
        gridBagConstraints.weighty = 0.0;
        jScrollPane = this.buildTheirElementsTable();
        this.lblTheirVersion.setLabelFor(jScrollPane);
        this.adjustmentSynchronizer.adapt(jCheckBox3, jScrollPane.getVerticalScrollBar());
        this.add((Component)jScrollPane, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.add((Component)this.buildMergedListControlButtons(), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.add((Component)this.buildComparePairSelectionPanel(), gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.add((Component)this.buildFrozeStateControlPanel(), gridBagConstraints);
        this.wireActionsToSelectionModels();
    }

    public ListMerger(ListMergeModel<T> listMergeModel) {
        this.model = listMergeModel;
        listMergeModel.addChangeListener(this);
        this.build();
        listMergeModel.addPropertyChangeListener(this);
    }

    protected void handlePropertyChangeFrozen(boolean bl, boolean bl2) {
        this.myEntriesTable.getSelectionModel().clearSelection();
        this.myEntriesTable.setEnabled(!bl2);
        this.theirEntriesTable.getSelectionModel().clearSelection();
        this.theirEntriesTable.setEnabled(!bl2);
        this.mergedEntriesTable.getSelectionModel().clearSelection();
        this.mergedEntriesTable.setEnabled(!bl2);
        this.freezeAction.putValue(FreezeActionProperties.PROP_SELECTED, bl2);
        if (bl2) {
            this.lblFrozenState.setText(I18n.tr("<html>Click <strong>{0}</strong> to start merging my and their entries.</html>", this.freezeAction.getValue("Name")));
        } else {
            this.lblFrozenState.setText(I18n.tr("<html>Click <strong>{0}</strong> to finish merging my and their entries.</html>", this.freezeAction.getValue("Name")));
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals(ListMergeModel.FROZEN_PROP)) {
            this.handlePropertyChangeFrozen((Boolean)propertyChangeEvent.getOldValue(), (Boolean)propertyChangeEvent.getNewValue());
        }
    }

    public ListMergeModel<T> getModel() {
        return this.model;
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.lblMyVersion.setText(I18n.trn("My version ({0} entry)", "My version ({0} entries)", this.model.getMyEntriesSize(), this.model.getMyEntriesSize()));
        this.lblMergedVersion.setText(I18n.trn("Merged version ({0} entry)", "Merged version ({0} entries)", this.model.getMergedEntriesSize(), this.model.getMergedEntriesSize()));
        this.lblTheirVersion.setText(I18n.trn("Their version ({0} entry)", "Their version ({0} entries)", this.model.getTheirEntriesSize(), this.model.getTheirEntriesSize()));
    }

    public void unlinkAsListener() {
        this.myEntriesTable.unlinkAsListener();
        this.mergedEntriesTable.unlinkAsListener();
        this.theirEntriesTable.unlinkAsListener();
    }

    protected final <P extends OsmPrimitive> OsmDataLayer findLayerFor(P p) {
        if (p != null) {
            List<OsmDataLayer> list = Main.map.mapView.getLayersOfType(OsmDataLayer.class);
            for (OsmDataLayer osmDataLayer : list) {
                if (osmDataLayer.data != p.getDataSet()) continue;
                return osmDataLayer;
            }
            for (OsmDataLayer osmDataLayer : list) {
                Collection<OsmPrimitive> collection = p instanceof Way ? osmDataLayer.data.getWays() : (p instanceof Relation ? osmDataLayer.data.getRelations() : osmDataLayer.data.allPrimitives());
                for (OsmPrimitive osmPrimitive : collection) {
                    if (!osmPrimitive.getPrimitiveId().equals(p.getPrimitiveId())) continue;
                    return osmDataLayer;
                }
            }
        }
        return null;
    }

    @Override
    public void decideRemaining(MergeDecisionType mergeDecisionType) {
        if (!this.model.isFrozen()) {
            this.model.copyAll(MergeDecisionType.KEEP_MINE.equals((Object)mergeDecisionType) ? ListRole.MY_ENTRIES : ListRole.THEIR_ENTRIES);
            this.model.setFrozen(true);
        }
    }

    private final class FreezeAction
    extends AbstractAction
    implements ItemListener,
    FreezeActionProperties {
        private FreezeAction() {
            this.putValue("Name", I18n.tr("Freeze", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Freeze the current list of merged elements.", new Object[0]));
            this.putValue(PROP_SELECTED, Boolean.FALSE);
            this.setEnabled(true);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
        }

        public void adapt(final JToggleButton jToggleButton) {
            jToggleButton.addItemListener(this);
            this.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (propertyChangeEvent.getPropertyName().equals(FreezeActionProperties.PROP_SELECTED)) {
                        jToggleButton.setSelected((Boolean)propertyChangeEvent.getNewValue());
                    }
                }
            });
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            int n = itemEvent.getStateChange();
            if (n == 1) {
                this.putValue("Name", I18n.tr("Unfreeze", new Object[0]));
                this.putValue("ShortDescription", I18n.tr("Unfreeze the list of merged elements and start merging.", new Object[0]));
                ListMerger.this.model.setFrozen(true);
            } else if (n == 2) {
                this.putValue("Name", I18n.tr("Freeze", new Object[0]));
                this.putValue("ShortDescription", I18n.tr("Freeze the current list of merged elements.", new Object[0]));
                ListMerger.this.model.setFrozen(false);
            }
            boolean bl = (Boolean)this.getValue(PROP_SELECTED);
            if (bl != (itemEvent.getStateChange() == 1)) {
                this.putValue(PROP_SELECTED, itemEvent.getStateChange() == 1);
            }
        }
    }

    private static interface FreezeActionProperties {
        public static final String PROP_SELECTED = FreezeActionProperties.class.getName() + ".selected";
    }

    class RemoveMergedAction
    extends AbstractAction
    implements ListSelectionListener {
        RemoveMergedAction() {
            ImageIcon imageIcon = ImageProvider.get("dialogs/conflict", "remove");
            this.putValue("SmallIcon", imageIcon);
            if (imageIcon == null) {
                this.putValue("Name", I18n.tr("Remove", new Object[0]));
            }
            this.putValue("ShortDescription", I18n.tr("Remove the selected entries from the list of merged elements.", new Object[0]));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = ListMerger.this.mergedEntriesTable.getSelectedRows();
            ListMerger.this.model.removeMerged(nArray);
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            int[] nArray = ListMerger.this.mergedEntriesTable.getSelectedRows();
            this.setEnabled(nArray != null && nArray.length > 0);
        }
    }

    class MoveDownMergedAction
    extends AbstractAction
    implements ListSelectionListener {
        MoveDownMergedAction() {
            ImageIcon imageIcon = ImageProvider.get("dialogs/conflict", "movedown");
            this.putValue("SmallIcon", imageIcon);
            if (imageIcon == null) {
                this.putValue("Name", I18n.tr("Down", new Object[0]));
            }
            this.putValue("ShortDescription", I18n.tr("Move down the selected entries by one position.", new Object[0]));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = ListMerger.this.mergedEntriesTable.getSelectedRows();
            ListMerger.this.model.moveDownMerged(nArray);
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            int[] nArray = ListMerger.this.mergedEntriesTable.getSelectedRows();
            this.setEnabled(nArray != null && nArray.length > 0 && nArray[nArray.length - 1] != ListMerger.this.mergedEntriesTable.getRowCount() - 1);
        }
    }

    class MoveUpMergedAction
    extends AbstractAction
    implements ListSelectionListener {
        MoveUpMergedAction() {
            ImageIcon imageIcon = ImageProvider.get("dialogs/conflict", "moveup");
            this.putValue("SmallIcon", imageIcon);
            if (imageIcon == null) {
                this.putValue("Name", I18n.tr("Up", new Object[0]));
            }
            this.putValue("ShortDescription", I18n.tr("Move up the selected entries by one position.", new Object[0]));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = ListMerger.this.mergedEntriesTable.getSelectedRows();
            ListMerger.this.model.moveUpMerged(nArray);
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            int[] nArray = ListMerger.this.mergedEntriesTable.getSelectedRows();
            this.setEnabled(nArray != null && nArray.length > 0 && nArray[0] != 0);
        }
    }

    class CopyAllRight
    extends AbstractAction
    implements ChangeListener,
    PropertyChangeListener {
        CopyAllRight() {
            ImageIcon imageIcon = ImageProvider.get("dialogs/conflict", "useallright");
            this.putValue("SmallIcon", imageIcon);
            this.putValue("ShortDescription", I18n.tr("Copy all their elements to the target", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ListMerger.this.model.copyAll(ListRole.THEIR_ENTRIES);
            ListMerger.this.model.setFrozen(true);
        }

        private void updateEnabledState() {
            this.setEnabled(ListMerger.this.model.getMergedEntries().isEmpty() && !ListMerger.this.model.isFrozen());
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            this.updateEnabledState();
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.updateEnabledState();
        }
    }

    class CopyAllLeft
    extends AbstractAction
    implements ChangeListener,
    PropertyChangeListener {
        CopyAllLeft() {
            ImageIcon imageIcon = ImageProvider.get("dialogs/conflict", "useallleft");
            this.putValue("SmallIcon", imageIcon);
            this.putValue("ShortDescription", I18n.tr("Copy all my elements to the target", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ListMerger.this.model.copyAll(ListRole.MY_ENTRIES);
            ListMerger.this.model.setFrozen(true);
        }

        private void updateEnabledState() {
            this.setEnabled(ListMerger.this.model.getMergedEntries().isEmpty() && !ListMerger.this.model.isFrozen());
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            this.updateEnabledState();
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.updateEnabledState();
        }
    }

    class CopyAfterCurrentRightAction
    extends CopyAction {
        CopyAfterCurrentRightAction() {
            super("copyaftercurrentright", I18n.tr("< after", new Object[0]), I18n.tr("Copy their selected element after the first selected element in the list of merged elements", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = ListMerger.this.mergedEntriesTable.getSelectedRows();
            if (nArray == null || nArray.length == 0) {
                return;
            }
            int[] nArray2 = ListMerger.this.theirEntriesTable.getSelectedRows();
            int n = nArray[0];
            ListMerger.this.model.copyTheirAfterCurrent(nArray2, n);
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.setEnabled(!ListMerger.this.theirEntriesTable.getSelectionModel().isSelectionEmpty() && !ListMerger.this.mergedEntriesTable.getSelectionModel().isSelectionEmpty());
        }
    }

    class CopyBeforeCurrentRightAction
    extends CopyAction {
        CopyBeforeCurrentRightAction() {
            super("copybeforecurrentright", I18n.tr("< before", new Object[0]), I18n.tr("Copy their selected elements before the first selected element in the list of merged elements.", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = ListMerger.this.mergedEntriesTable.getSelectedRows();
            if (nArray == null || nArray.length == 0) {
                return;
            }
            int[] nArray2 = ListMerger.this.theirEntriesTable.getSelectedRows();
            int n = nArray[0];
            ListMerger.this.model.copyTheirBeforeCurrent(nArray2, n);
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.setEnabled(!ListMerger.this.theirEntriesTable.getSelectionModel().isSelectionEmpty() && !ListMerger.this.mergedEntriesTable.getSelectionModel().isSelectionEmpty());
        }
    }

    class CopyEndRightAction
    extends CopyAction {
        CopyEndRightAction() {
            super("copyendright", I18n.tr("< bottom", new Object[0]), I18n.tr("Copy their selected elements to the end of the list of merged elements.", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ListMerger.this.model.copyTheirToEnd(ListMerger.this.theirEntriesTable.getSelectedRows());
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.setEnabled(!ListMerger.this.theirEntriesTable.getSelectionModel().isSelectionEmpty());
        }
    }

    class CopyStartRightAction
    extends CopyAction {
        CopyStartRightAction() {
            super("copystartright", I18n.tr("< top", new Object[0]), I18n.tr("Copy their selected element to the start of the list of merged elements.", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ListMerger.this.model.copyTheirToTop(ListMerger.this.theirEntriesTable.getSelectedRows());
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.setEnabled(!ListMerger.this.theirEntriesTable.getSelectionModel().isSelectionEmpty());
        }
    }

    class CopyAfterCurrentLeftAction
    extends CopyAction {
        CopyAfterCurrentLeftAction() {
            super("copyaftercurrentleft", I18n.tr("> after", new Object[0]), I18n.tr("Copy my selected elements after the first selected element in the list of merged elements.", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = ListMerger.this.mergedEntriesTable.getSelectedRows();
            if (nArray == null || nArray.length == 0) {
                return;
            }
            int[] nArray2 = ListMerger.this.myEntriesTable.getSelectedRows();
            int n = nArray[0];
            ListMerger.this.model.copyMyAfterCurrent(nArray2, n);
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.setEnabled(!ListMerger.this.myEntriesTable.getSelectionModel().isSelectionEmpty() && !ListMerger.this.mergedEntriesTable.getSelectionModel().isSelectionEmpty());
        }
    }

    class CopyBeforeCurrentLeftAction
    extends CopyAction {
        CopyBeforeCurrentLeftAction() {
            super("copybeforecurrentleft", I18n.tr("> before", new Object[0]), I18n.tr("Copy my selected elements before the first selected element in the list of merged elements.", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = ListMerger.this.mergedEntriesTable.getSelectedRows();
            if (nArray == null || nArray.length == 0) {
                return;
            }
            int[] nArray2 = ListMerger.this.myEntriesTable.getSelectedRows();
            int n = nArray[0];
            ListMerger.this.model.copyMyBeforeCurrent(nArray2, n);
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.setEnabled(!ListMerger.this.myEntriesTable.getSelectionModel().isSelectionEmpty() && !ListMerger.this.mergedEntriesTable.getSelectionModel().isSelectionEmpty());
        }
    }

    class CopyEndLeftAction
    extends CopyAction {
        CopyEndLeftAction() {
            super("copyendleft", I18n.tr("> bottom", new Object[0]), I18n.tr("Copy my selected elements to the end of the list of merged elements.", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ListMerger.this.model.copyMyToEnd(ListMerger.this.myEntriesTable.getSelectedRows());
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.setEnabled(!ListMerger.this.myEntriesTable.getSelectionModel().isSelectionEmpty());
        }
    }

    class CopyStartLeftAction
    extends CopyAction {
        CopyStartLeftAction() {
            super("copystartleft", I18n.tr("> top", new Object[0]), I18n.tr("Copy my selected nodes to the start of the merged node list", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ListMerger.this.model.copyMyToTop(ListMerger.this.myEntriesTable.getSelectedRows());
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.setEnabled(!ListMerger.this.myEntriesTable.getSelectionModel().isSelectionEmpty());
        }
    }

    static abstract class CopyAction
    extends AbstractAction
    implements ListSelectionListener {
        protected CopyAction(String string, String string2, String string3) {
            ImageIcon imageIcon = ImageProvider.get("dialogs/conflict", string);
            this.putValue("SmallIcon", imageIcon);
            if (imageIcon == null) {
                this.putValue("Name", string2);
            }
            this.putValue("ShortDescription", string3);
            this.setEnabled(false);
        }
    }
}

