/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.debug;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import java.util.ArrayList;
import java.util.List;
import org.jcodings.Encoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.builtins.CoreClass;
import org.jruby.truffle.builtins.CoreMethod;
import org.jruby.truffle.builtins.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.builtins.CoreMethodNode;
import org.jruby.truffle.core.array.ArrayStrategy;
import org.jruby.truffle.core.string.StringOperations;
import org.jruby.truffle.language.backtrace.BacktraceFormatter;
import org.jruby.truffle.language.methods.InternalMethod;
import org.jruby.truffle.platform.UnsafeGroup;
import org.jruby.truffle.tools.simpleshell.SimpleShell;

@CoreClass(value="Truffle::Debug")
public abstract class TruffleDebugNodes {

    @CoreMethod(names={"array_storage"}, onSingleton=true, required=1)
    public static abstract class ArrayStorageNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(guards={"isRubyArray(array)"})
        public DynamicObject arrayStorage(DynamicObject array) {
            String storage = ArrayStrategy.of(array).toString();
            return StringOperations.createString(this.getContext(), StringOperations.createRope(storage, (Encoding)USASCIIEncoding.INSTANCE));
        }
    }

    @CoreMethod(names={"object_type_of"}, onSingleton=true, required=1)
    public static abstract class ObjectTypeOfNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public DynamicObject objectTypeOf(DynamicObject value) {
            return this.getSymbol(value.getShape().getObjectType().getClass().getSimpleName());
        }
    }

    @CoreMethod(names={"ast"}, onSingleton=true, required=1)
    public static abstract class ASTNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(guards={"isRubyMethod(method)"})
        public DynamicObject astMethod(DynamicObject method) {
            return this.ast(Layouts.METHOD.getMethod(method));
        }

        @Specialization(guards={"isRubyUnboundMethod(method)"})
        public DynamicObject astUnboundMethod(DynamicObject method) {
            return this.ast(Layouts.UNBOUND_METHOD.getMethod(method));
        }

        @Specialization(guards={"isRubyProc(proc)"})
        public DynamicObject astProc(DynamicObject proc) {
            return this.ast(Layouts.PROC.getMethod(proc));
        }

        @CompilerDirectives.TruffleBoundary
        private DynamicObject ast(InternalMethod method) {
            if (method.getCallTarget() instanceof RootCallTarget) {
                return this.ast(((RootCallTarget)method.getCallTarget()).getRootNode());
            }
            return this.nil();
        }

        private DynamicObject ast(Node node) {
            if (node == null) {
                return this.nil();
            }
            ArrayList<DynamicObject> array = new ArrayList<DynamicObject>();
            array.add(this.getSymbol(node.getClass().getSimpleName()));
            for (Node child : node.getChildren()) {
                array.add(this.ast(child));
            }
            return Layouts.ARRAY.createArray(this.coreLibrary().getArrayFactory(), array.toArray(), array.size());
        }
    }

    @CoreMethod(names={"print_backtrace"}, onSingleton=true, unsafe={UnsafeGroup.IO})
    public static abstract class PrintBacktraceNode
    extends CoreMethodNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject printBacktrace() {
            List<String> rubyBacktrace = BacktraceFormatter.createDefaultFormatter(this.getContext()).formatBacktrace(this.getContext(), null, this.getContext().getCallStack().getBacktrace(this));
            for (String line : rubyBacktrace) {
                System.err.println(line);
            }
            return this.nil();
        }
    }

    @CoreMethod(names={"simple_shell"}, onSingleton=true, unsafe={UnsafeGroup.IO})
    public static abstract class SimpleShellNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject simpleShell() {
            new SimpleShell(this.getContext()).run(this.getContext().getCallStack().getCallerFrameIgnoringSend().getFrame(FrameInstance.FrameAccess.MATERIALIZE, true).materialize(), this);
            return this.nil();
        }
    }

    @CoreMethod(names={"java_class_of"}, onSingleton=true, required=1)
    public static abstract class JavaClassOfNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public DynamicObject javaClassOf(Object value) {
            return this.createString(StringOperations.encodeRope(value.getClass().getSimpleName(), (Encoding)UTF8Encoding.INSTANCE));
        }
    }
}

