var tipuesearch = { "pages": [ {"title":"dxViewer", "text":"dxViewer dxViewer 3.0.2 User Docs API Docs Release Notes Forum Github OSD_ARTICLE_TITLE SYNOPSIS DESCRIPTION OPTIONS SEE ALSO SYNOPSIS dxViewer  -d isolation level   -c animation loops  objfiles DESCRIPTION dxViewer is a stand-alone application that showcases the application of uniform and feature adaptive subdivision schemes to a collection of geometric shapes. Multiple controls are available to experiment with the algorithms. Note dxViewer requires Microsofts DirectX D3D11 SDK OPTIONS -d isolation level Select the desired isolation level of adaptive feature isolation. This can be useful when trying to load large pieces of geometry. -c animation frequency Number of repetitions of the animation loop default0 is infinite SEE ALSO Other examples  glViewer , glShareTopology , glStencilViewer , glPtexViewer , glEvalLimit , glFVarViewer , dxViewer , dxPtexViewer , mayaPolySmooth , Generated on 2016-06-13 0020 UTC. User Docs API Docs Release Notes Forum", "tags": "", "loc":"dxviewer.html"}, 
{"title":"Getting Started", "text":"Getting Started Getting Started 3.0.2 User Docs API Docs Release Notes Forum Github OSD_ARTICLE_TITLE Downloading the code Branches Git Flow Checking out branches API Versions Making Changes Code Overview Downloading the code The code is hosted on a Github public repository. Download and setup information for Git tools can be found here . You can access the OpenSubdiv Git repository at httpsgithub.comPixarAnimationStudiosOpenSubdiv From there, there are several ways of downloading the OpenSubdiv source code. Zip archive  downloaded from here Using a GUI client  you can find a list here Please refer to the documentation of your preferred application. From the GitShell, Cygwin or the CLI  assuming that you have the Git tools installed, you can clone the OpenSubdiv repository directly with the following command git clone https  github.comPixarAnimationStudiosOpenSubdiv.git These methods only pull static archives, which is are not under the version control system and therefore cannot pull updates or push changes back. If you intend on contributing features or fixes to the main trunk of the code, you will need to create a free Github account and clone a fork of the OpenSubdiv repository. Submissions to the main code trunk can be sent using Gits pull-request mechanisms. Please note that we are using the git flow tools so all changes should be made to our dev branch. Before we can accept submissions however, we will need a signed Contributors License Agreement . Branches Git Flow Since version 1.1.0, OpenSubdiv has adopted the Git Flow branching model . Our active development branch is named dev  all new features and bug fixes should be submitted to this branch. The changes submitted to the dev branch are periodically patched to the master branch as new versions are released. Checking out branches The Git Flow tools are not a requisite for working with the OpenSubdiv code base, but new work should always be performed in the dev branch, or dedicated feature-branches. By default, a cloned repository will be pointing to the master branch. You can switch to the dev branch using the following command git checkout dev You can check that the branch has now been switched simply with git branch Which should return  dev master API Versions OpenSubdiv maintains an internal API versioning system. The version number can be read from the file .opensubdivversion.h . Following the Git-Flow pattern, our releases are indexed using Gits tagging system. List of the existing tags git tag -- list Checking out version 1.2.0 git checkout v1_2_0 Making Changes Direct push access to the OpenSubdiv master repository is currently limited to a small internal development team. External code should be submitted by sending Git pull-requests from forks of our dev branch. Code Overview The OpenSubdiv code base contains the following main areas Directory Contents .opensubdiv The main subdivision APIs  Sdc, Vtr, Far and Osd. .examples A small collection of standalone applications that illustrate how to deploy the various features and optimizations of the OpenSubdiv APIs. The GL-based examples rely on the cross-platform GLFW API for interactive window management, while the DirectX ones are OS-native. .tutorials Tutorials showing how to manipulate the APIs of OpenSubdiv. .documentation The reStructuredText source files along with python scripts that generate the HTML documentation site. .regression Standalone regression tests and baseline data to help maintain the integrity of our APIs. If GPU SDKs are detected, some tests will attempt to run computations on those GPUs. Generated on 2016-06-13 0020 UTC. User Docs API Docs Release Notes Forum", "tags": "", "loc":"getting_started.html"}, 
{"title":"Code Examples", "text":"Code Examples Code Examples 3.0.2 User Docs API Docs Release Notes Forum Github OSD_ARTICLE_TITLE Standalone Viewers OpenSubdiv builds a number of standalone viewers that demonstrate various aspects of the software. OpenGL examples glViewer glPtexViewer glEvalLimit glStencilViewer glPaintTest glShareTopology glFVarViewer DirectX examples dxViewer dxPtexViewer Plugin examples Maya osdPolySmooth Common Keyboard Controls Left mouse button drag  orbit camera Middle mouse button drag  pan camera Right mouse button  dolly camera n , p  next  prev model 1 , 2 , 3 , ..., 9 , 0  specify adaptive isolation or uniform refinement level  , -  increase  decrease tessellation Tab  toggle full - screen Esc  turn on  off the HUD w  switch display mode q  quit Generated on 2016-06-13 0020 UTC. User Docs API Docs Release Notes Forum", "tags": "", "loc":"code_examples.html"}, 
{"title":"Roadmap", "text":"Roadmap Roadmap 3.0.2 User Docs API Docs Release Notes Forum Github OSD_ARTICLE_TITLE 3.x Release Cycle Near Term Feature parity for Loop subdivision Improved support for infinitely sharp features Dynamic feature adaptive isolation DFAS Longer Term Implement a high-level API layer Next-gen back-ends A means to control edge curvature Always in Need of Improvement Regression testing Documentation 3.x Release Cycle For more details, please see the Release Notes . 3.0 Master Release Q2 2015 freeze subdivision specification enforce backward compatibility 3.1 Supplemental Release Q3Q4 2015 include any noteworthy omissions arising from 3.0 add support for bi-cubic face-varying limit patches add support for higher order differentiation of limit patches 3.2 Future Release 2016 TBD Near Term The following is a short list of topics already expressed as priorities and receiving ongoing attention -- some being actively prototyped to varying degrees. Feature parity for Loop subdivision The more popular Catmark scheme has long received more attention and effort than the Loop scheme. Given OpenSubdiv claims to support both, additional effort is required to bring Loop to the same level of functionality as Catmark. With the feature-adaptive analysis now scheme-independent, the addition of triangular patches to the PatchTables will go a long way towards that goal. Prototype patch gathering and evaluation methods have already been tested within the existing code base and discussions on extending the internal patch infra-structure are underway. Improved support for infinitely sharp features The current implementation of adaptive feature isolation requires infinitely sharp creases to be pushed to the highest level of isolation -- eventually representing the result with a regular patch. The surface is therefore both inefficient and incorrect. Patches with a single infinitely sharp edge can be represented exactly with regular boundary patches and could be isolated at a much higher level. Continuity with dart patches is necessary in such cases, and approximating more sharp irregular regions with alternate patch types e.g. Gregory or Bezier will help this goal and others. Dynamic feature adaptive isolation DFAS Adaptive feature isolation can produce a large number of patches, especially when the model contains a lot of semi-sharp creases. We need a LOD solution that can dynamically isolate features based on distance to view-point. Note paper from Matthias Niessner Henry Schafer Longer Term The following is a list of pending projects and future directions for OpenSubdiv. Implement a high-level API layer One of the original goals of the OpenSubdiv project is to provide a robust and simple API to display subdivision surfaces interactively. Now that the algorithms and code-base have matured, we would like to foster a consistent implementation of subdivision surfaces suitable for adoption in the lower layers of the graphics stack, such as GPU drivers. We have been working on the draft of a specification document detailing the workings of a high- level interface for subdivision surface data and functionality. We need an implementation of this high-level API. Note this document drafting has been started at Pixar with partners. Next-gen back-ends Implement Osd Evaluator and Patch Drawing for next-gen GPU APIs such as Mantle, Metal, DX12, Vulkan. A means to control edge curvature Edge sharpness provides insufficient control over the overall contour of the surfaces. Artists often duplicate edge-loops around semi-sharp edges in order to control the local surface curvature. Ideally, they would like to be able to specify a radius of curvature that produces circular rounded edges. This will likely require the introduction of non-uniform rational splines NURCCS  in OpenSubdiv. Always in Need of Improvement And finally, a few topics that always benefit from continual improvement. Any and all contributions in this area are greatly appreciated. Regression testing OpenSubdiv currently ships with some regression testing code which can be run using CTest. Its always great to have more regression testing that covers more of the code base. Implement a robust regression harness for numerical correctness Implement a cross-platform regression harness for GPU drawing correctness Implement a cross-platform regression harness for performance speed memory Implement code coverage analysis Documentation In order to facilitate adoption of OpenSubdiv, we need to provide clear, concise and comprehensive documentation of all APIs. In particular Update and flesh out high-level ReST documentation Clean up the Doxygen documentation Expand code tutorials Generated on 2016-06-13 0020 UTC. User Docs API Docs Release Notes Forum", "tags": "", "loc":"roadmap.html"}, 
{"title":"glFVarViewer", "text":"glFVarViewer glFVarViewer 3.0.2 User Docs API Docs Release Notes Forum Github OSD_ARTICLE_TITLE SYNOPSIS DESCRIPTION OPTIONS SEE ALSO SYNOPSIS glFVarViewer  -d isolation level   -c animation loops   -f  objfiles DESCRIPTION glFVarViewer is a stand-alone application that allows the inspection of face-varying data interpolation. The window displays 2 views left side regular 3D view of the model, with a procedural u,v texture right side a 2D view of the face-varying u,v pair The HUD allows interactive manipulation of the various face-varying boundary interpolation rules and tags. OPTIONS -d isolation level Select the desired isolation level of adaptive feature isolation. This can be useful when trying to load large pieces of geometry. -c animation frequency Number of repetitions of the animation loop default0 is infinite -f Launches the application in full-screen mode if is supported by GLFW on the OS SEE ALSO Other examples  glViewer , glShareTopology , glStencilViewer , glPtexViewer , glEvalLimit , glFVarViewer , dxViewer , dxPtexViewer , mayaPolySmooth , Generated on 2016-06-13 0020 UTC. User Docs API Docs Release Notes Forum", "tags": "", "loc":"glfvarviewer.html"}, 
{"title":"Sdc Overview", "text":"Sdc Overview Sdc Overview 3.0.2 User Docs API Docs Release Notes Forum Github OSD_ARTICLE_TITLE Subdivision Core Sdc Types, Traits and Options Creasing support Scheme-specific support The FACE , EDGE and VERTEX interfaces The MASK interface Subdivision Core Sdc Sdc is the lowest level layer in OpenSubdiv. Its intent is to separate the core subdivision details from any particular representation of a mesh it was previously bound to Hbr to facilitate the generation of consistent results with other mesh representations, both internal and external to OpenSubdiv. The functionality can be divided roughly into three sections types, traits and options for the supported subdivision schemes computations required to support semi-sharp creasing computations for mask weights of subdivided vertices for all schemes For most common usage, familiarity with only the first of these is necessary -- primarily the use of public types and constants for the choice of subdivision scheme and its associated options. The latter two provide the basis for a more comprehensive implementation of subdivision, which requires considerably more understanding and effort. Overall, the approach was to extract the functionality at the lowest level possible. In some cases, the implementation is not far from being simple global functions. The intent was to start at a low level and build any higher level functionality as needed. What exists now is functional for ongoing development and anticipated needs within OpenSubdiv for the near future. The intent of Sdc is to provide the building blocks for OpenSubdiv and its clients to efficiently process the specific set of supported subdivision schemes. It is not intended to be a general framework for defining customized subdivision schemes. Types, Traits and Options The most basic type is the enum SdcSchemeType that identifies the fixed set of subdivision schemes supported by OpenSubdiv Bilinear , Catmark and Loop . With this alone, we intend to avoid all dynamic casting issues related to the scheme by simply adding members to the associated subclasses for inspection. In addition to the type enum itself, a class defining a fixed set of traits associated with each scheme is provided. While these traits are available as static methods in the interface of a class supporting more functionality for each scheme to be described shortly, the SchemeTypeTraits provide queries of the traits for a variable of type SdcSchemeType -- enabling parameterization of code by the value of a trait without templates or virtual inheritance a simple internal table of traits is constructed and trivially indexed. The second contribution is the collection of all variations in one place that can be applied to the subdivision schemes, i.e. the boundary interpolation rules, creasing method, edge subdivision choices, etc. The fact that these are all declared in one place alone should help clients see the full set of variations that are possible. A simple Options struct a set of bitfields aggregates all of these variations into a single object the equivalent of an integer in this case that are passed around to other Sdc classes andor methods and are expected to be used at a higher level both within OpenSubdiv and externally. By aggregating the options and passing them around as a group, it allows us to extend the set easily in future without the need to rewire a lot of interfaces to accommodate the new choice. Clients can enable new choices at the highest level and be assured that they will propagate to the lowest level where they are relevant. Unlike other options structs used elsewhere to specify variations of a particular method, SdcOptions defines all options that affect the shape of the underlying limit surface of a subdivision mesh. Other operations at higher levels in the library may have options that approximate the shape and so create a slightly different appearance, but SdcOptions is a fundamental part of the definition of the true limit surface. Creasing support Since the computations involved in the support of semi-sharp creasing are independent of the subdivision scheme, the goal in Sdc was to encapsulate all related creasing functionality in a similarly independent manner. Computations involving sharpness values are also much less dependent on topology -- there are vertices and edges with sharpness values, but knowledge of faces or boundary edges is not required, -- so the complexity of topological neighborhoods required for more scheme-specific functionality is arguably not necessary here. Creasing computations have been provided as methods defined on a Crease class that is constructed with a set of Options. Its methods typically take sharpness values as inputs and compute a corresponding set of sharpness values as a result. For the Uniform creasing method previously known as Normal , the computations may be so trivial as to question whether such an interface is worth it, but for Chaikin or other schemes in the future that are non-trivial, the benefits should be clear. Functionality is divided between both uniform and non-uniform, so clients have some control over avoiding unnecessary overhead, e.g. non-uniform computations typically require neighboring sharpness values around a vertex, while uniform does not. Also included as part of the Crease class is the Rule enum -- this indicates if a vertex is Smooth, Crease, Dart or Corner referred to as the mask in Hbr and is a function of the sharpness values at and around a vertex. Knowing the Rule for a vertex can accelerate mask queries, and the Rule can often be inferred based on the origin of a vertex e.g. it originated from the middle of a face, was the child of a Smooth vertex, etc.. Methods are defined for the Crease class to subdivide edge and vertex sharpness values determine the Rule for a vertex based on incident sharpness values determine the transitional weight between two sets of sharpness values Being all low-level and working directly on sharpness values, it is a clients responsibility to coordinate the application of any hierarchical crease edits with their computations. Similarly, in keeping with this as a low-level interface, values are passed as primitive arrays. This follows the trend in OpenSubdiv of dealing with data of various kinds e.g. weights, component indices, now sharpness values, etc. in small contiguous sets of values. In most internal cases we can refer to a set of values or gather what will typically be a small number of values on the stack for temporary use. Scheme-specific support While the SchemeTypeTraits class provides traits for each subdivision scheme supported by OpenSubdiv i.e. Bilinear , Catmark and Loop , the Scheme class provides these more directly, Additionally, the Scheme class provides methods for computing the various sets of weights used to compute new vertices resulting from subdivision. The collection of weights used to compute a single vertex at a new subdivision level is typically referred to as a mask . The primary purpose of the Scheme class is to provide such masks in a manner both general and efficient. Each subdivision scheme has its own values for its masks, and each are provided as specializations of the template class Scheme SchemeType TYPE . The intent is to minimize the amount of code specific to each scheme. The computation of mask weights for subdivided vertices is the most significant contribution of Sdc. The use of semi-sharp creasing with each non-linear subdivision scheme complicates what are otherwise simple masks determined solely by the topology, and packaging that functionality to achieve both the generality and efficiency desired has been a challenge. Mask queries are defined in the Scheme class template, which has specializations for each of the supported subdivision schemes. Mask queries are defined in terms of interfaces for two template parameters the first defining the topological neighborhood of a vertex, and a second defining a container in which to gather the individual weights template typename FACE , typename MASK void ComputeFaceVertexMask  FACE const faceNeighborhood , MASK faceVertexMask , ... const  Each mask query is expected to call methods defined for the FACE , EDGE or VERTEX classes to obtain the information they require  typically these methods are simple queries about the topology and associated sharpness values. Clients are free to use their own mesh representations to gather the requested information as quickly as possible, or to cache some subset as member variables for immediate inline retrieval. In general, the set of weights for a subdivided vertex is dependent on the following the topology around the parent component from which the vertex originates the type of subdivision Rule applicable to the parent component the type of subdivision Rule applicable to the new child vertex a transitional weight blending the effect between differing parent and child rules This seems fairly straight-forward, until we look at some of the dependencies involved the parent Rule requires the sharpness values at and around the parent component the child Rule requires the subdivided sharpness values at and around the new child vertex though it can sometimes be trivially inferred from the parent the transitional weight between differing rules requires all parent and child sharpness values Clearly the sharpness values are inspected multiple times and so it pays to have them available for retrieval. Computing them on an as-needed basis may be simple for uniform creasing, but a non-uniform creasing method requires traversing topological neighborhoods, and that in addition to the computation itself can be costly. The point here is that it is potentially unreasonable to expect to evaluate the mask weights completely independent of any other consideration. Expecting and encouraging the client to have subdivided sharpness values first, for use in more than one place, is therefore recommended. The complexity of the general case above is also unnecessary for most vertices. Any client using Sdc typically has more information about the nature of the vertex being subdivided and much of this can be avoided -- particularly for the smooth interior case that often dominates. More on that in the details of the Scheme classes. Given that most of the complexity has been moved into the template parameters for the mask queries, the Scheme class remains fairly simple. Like the Crease class, it is instantiated with a set of Options to avoid them cluttering the interface. It is currently little more than a few methods for the limit and refinement masks for each vertex type, plus the few fixed traits of the scheme as static methods. The mask queries have been written in a way that greatly simplifies the specializations required for each scheme. The generic implementation for both the edge-vertex and vertex-vertex masks take care of all of the creasing logic, requiring only a small set of specific masks to be assigned for each Scheme smooth and crease masks for an edge-vertex, and smooth, crease and corner masks for a vertex-vertex. Other than the Bilinear case, which will specialize the mask queries to trivialize them for linear interpolation, the specializations for each Scheme should only require defining this set of masks -- and with two of them common edge-vertex crease and vertex-vertex corner the Catmark scheme only needs to define three. The FACE , EDGE and VERTEX interfaces Mask queries require an interface to a topological neighborhood, currently labeled FACE , EDGE and VERTEX . This naming potentially implies more generality than intended, as such classes are only expected to provide the methods required of the mask queries to compute its associated weights. While all methods must be defined, some may rarely be invoked, and the client has considerable flexibility in the implementation of these they can defer some evaluations lazily until required, or be pro-active and cache information in member variables for immediate access. An approach discussed in the past has alluded to iterator classes that clients would write to traverse their meshes. The mask queries would then be parameterized in terms of a more general and generic mesh component that would make use of more general traversal iterators. The advantage here is the iterators are written once, then traversal is left to the query and only what is necessary is gathered. The disadvantages are that clients are forced to write these to do anything, getting them correct and efficient may not be trivial or possible in some cases, and that the same data e.g. subdivided sharpness may be gathered or computed multiple times for different purposes. The other extreme was to gather everything possible required at once, but that is objectionable. The approach taken here provides a reasonable compromise between the two. The mask queries ask for exactly what they want, and the provided classes are expected to deliver it as efficiently as possible. In some cases the client may already be storing it in a more accessible form and general topological iteration can be avoided. The information requested of these classes in the three mask queries is as follows For FACE  the number of incident vertices For EDGE  the number of incident faces the sharpness value of the parent edge the sharpness values of the two child edges the number of vertices per incident face For VERTEX  the number of incident faces the number of incident edges the sharpness value of the parent vertex the sharpness values for each incident parent edge the sharpness value of the child vertex the sharpness values for each incident child edge The latter should not be surprising given the dependencies noted above. There are also a few more to consider for future use, e.g. whether the EDGE or VERTEX is manifold or not. In most cases, additional information can be provided to the mask queries i.e. pre-determined Rules, and most of the child sharpness values are not necessary. The most demanding situation is a fractional crease that decays to zero -- in which case all parent and child sharpness values in the neighborhood are required to determine the proper transitional weight. The MASK interface Methods dealing with the collections of weights defining a mask are typically parameterized by a MASK template parameter that contains the weights. The set of mask weights is currently divided into vertex-weights, edge-weights and face-weights -- consistent with previous usage in OpenSubdiv and providing some useful correlation between the full set of weights and topology. The vertex-weights refer to parent vertices incident the parent component from which a vertex originated, the edge-weights the vertices opposite incident edges of the parent, and the face-weights the center of incident parent faces. Note the latter is NOT in terms of vertices of the parent but potentially vertices in the child originating from faces of the parent. This has been done historically in OpenSubdiv but is finding less use -- particularly when it comes to providing greater support for the Loop scheme -- and is a point needing attention. So the mask queries require the following capabilities assign the number of vertex, edge andor face weights retrieve the number of vertex, edge andor face weights assign individual vertex, edge andor face weights by index retrieve individual vertex, edge andor face weights by index through a set of methods required of all MASK classes. Since the maximum number of weights is typically known based on the topology, usage within Vtr, Far or Hbr is expected to simply define buffers on the stack. Another option is to utilize pre-allocated tables, partitioned into the three sets of weights on construction of a MASK , and populated by the mask queries. A potentially useful side-effect of this is that the client can define their weights to be stored in either single or double-precision. With that possibility in mind, care was taken within the mask queries to make use of a declared type in the MASK interface  MASKWeight  for intermediate calculations. Having support for double-precision masks in Sdc does enable it at higher levels in OpenSubdiv if later desired, and that support is made almost trivial with MASK being generic. It is important to remember here that these masks are being defined consistent with existing usage within OpenSubdiv both Hbr and the subdivision tables generated by Far . As noted above, the face weights correspond to the centers of incident faces, i.e. vertices on the same level as the vertex for which the mask is being computed, and not relative to vertices in the parent level as with the other sets of weights. It is true that the weights can be translated into a set in terms solely of parent vertices, but in the general case i.e. Catmark subdivision with non-quads in the base mesh this requires additional topological association. In general we would need N-3 weights for the N-3 vertices between the two incident edges, where N is the number of vertices of each face typically 4 even at level 0. Perhaps such a translation method could be provided on the mask class, with an optional indication of the incident face topology for the irregular cases. The Loop scheme does not have face weights , for a vertex-vertex mask, but for an edge-vertex mask it does require weights associated with the faces incident the edge -- either the vertex opposite the edge for each triangle, or its center which has no other use for Loop. Generated on 2016-06-13 0020 UTC. User Docs API Docs Release Notes Forum", "tags": "", "loc":"sdc_overview.html"}, 
{"title":"Using OpenSubdiv", "text":"Using OpenSubdiv Using OpenSubdiv 3.0.2 User Docs API Docs Release Notes Forum Github OSD_ARTICLE_TITLE OpenSubdiv APIs Coding With OpenSubdiv OpenSubdiv APIs APIs Overview Overview Sdc API Vtr API Far API Osd API Coding With OpenSubdiv General Topics Compiling Linking Tutorials Writing Shaders Textures UV Ptex Generated on 2016-06-13 0020 UTC. User Docs API Docs Release Notes Forum", "tags": "", "loc":"using_osd.html"}, 
{"title":"far_tutorial_2.cpp", "text":"far_tutorial_2.cpp far_tutorial_2.cpp 3.0.2 User Docs API Docs Release Notes Forum Github OSD_ARTICLE_TITLE httpsgithub.comPixarAnimationStudiosOpenSubdivblobmastertutorialsfartutorial_2far_tutorial_2.cpp ------------------------------------------------------------------------------  Tutorial description   Building on tutorial 0, this example shows how to instantiate a simple mesh,  refine it uniformly and then interpolate additional sets of primvar data.  include opensubdivfartopologyDescriptor.h include opensubdivfarprimvarRefiner.h include cstdio ------------------------------------------------------------------------------  Vertex container implementation.   We are adding a per-vertex color attribute to our primvar data. While they  are separate properties and exist in separate buffers as when read from an  Alembic file they are both of the form float3 and so we can use the same  underlying type.   While color and position may be the same, well make the color a varying  primvar, e.g. it is constrained to being linearly interpolated between  vertices, rather than smoothly like position and other vertex data.  struct Point3   Minimal required interface ---------------------- Point3    void Clear  void   0   _point  0   _point  1   _point  2   0.0f   void AddWithWeight  Point3 const src , float weight   _point  0   weight  src . _point  0  _point  1   weight  src . _point  1  _point  2   weight  src . _point  2    Public interface ------------------------------------ void SetPoint  float x , float y , float z   _point  0   x  _point  1   y  _point  2   z   const float  GetPoint  const  return _point   private  float _point  3   typedef Point3 VertexPosition  typedef Point3 VertexColor  ------------------------------------------------------------------------------  Cube geometry from catmark_cube.h static float g_verts  8  3    - 0.5f , - 0.5f , 0.5f ,  0.5f , - 0.5f , 0.5f ,  - 0.5f , 0.5f , 0.5f ,  0.5f , 0.5f , 0.5f ,  - 0.5f , 0.5f , - 0.5f ,  0.5f , 0.5f , - 0.5f ,  - 0.5f , - 0.5f , - 0.5f ,  0.5f , - 0.5f , - 0.5f   Per-vertex RGB color data static float g_colors  8  3    1.0f , 0.0f , 0.5f ,  0.0f , 1.0f , 0.0f ,  0.0f , 0.0f , 1.0f ,  1.0f , 1.0f , 1.0f ,  1.0f , 1.0f , 0.0f ,  0.0f , 1.0f , 1.0f ,  1.0f , 0.0f , 1.0f ,  0.0f , 0.0f , 0.0f  static int g_nverts  8 , g_nfaces  6  static int g_vertsperface  6    4 , 4 , 4 , 4 , 4 , 4  static int g_vertIndices  24    0 , 1 , 3 , 2 , 2 , 3 , 5 , 4 , 4 , 5 , 7 , 6 , 6 , 7 , 1 , 0 , 1 , 7 , 5 , 3 , 6 , 0 , 2 , 4  using namespace OpenSubdiv  static Far  TopologyRefiner  createFarTopologyRefiner  ------------------------------------------------------------------------------ int main  int , char    int maxlevel  5  Far  TopologyRefiner  refiner  createFarTopologyRefiner   Uniformly refine the topolgy up to maxlevel refiner - RefineUniform  Far  TopologyRefiner  UniformOptions  maxlevel   Allocate buffers for vertex primvar data.   We assume we received the coarse data for the mesh in separate buffers  from some other source, e.g. an Alembic file. Meanwhile, we want buffers  for the lastfinest subdivision level to persist. We have no interest  in the intermediate levels.   Determine the sizes for our needs int nCoarseVerts  g_nverts  int nFineVerts  refiner - GetLevel  maxlevel . GetNumVertices  int nTotalVerts  refiner - GetNumVerticesTotal  int nTempVerts  nTotalVerts - nCoarseVerts - nFineVerts   Allocate and intialize the primvar data for the original coarse vertices std  vector VertexPosition coarsePosBuffer  nCoarseVerts  std  vector VertexColor coarseClrBuffer  nCoarseVerts  for  int i  0  i nCoarseVerts   i   coarsePosBuffer  i . SetPoint  g_verts  i  0 , g_verts  i  1 , g_verts  i  2  coarseClrBuffer  i . SetPoint  g_colors  i  0 , g_colors  i  1 , g_colors  i  2    Allocate intermediate and final storage to be populated std  vector VertexPosition tempPosBuffer  nTempVerts  std  vector VertexPosition finePosBuffer  nFineVerts  std  vector VertexColor tempClrBuffer  nTempVerts  std  vector VertexColor fineClrBuffer  nFineVerts   Interpolate all primvar data -- separate buffers can be populated on  separate threads if desired VertexPosition  srcPos  coarsePosBuffer  0  VertexPosition  dstPos  tempPosBuffer  0  VertexColor  srcClr  coarseClrBuffer  0  VertexColor  dstClr  tempClrBuffer  0  Far  PrimvarRefiner primvarRefiner   refiner  for  int level  1  level maxlevel   level   primvarRefiner . Interpolate  level , srcPos , dstPos  primvarRefiner . InterpolateVarying  level , srcClr , dstClr  srcPos  dstPos , dstPos  refiner - GetLevel  level . GetNumVertices  srcClr  dstClr , dstClr  refiner - GetLevel  level . GetNumVertices    Interpolate the last level into the separate buffers for our final data primvarRefiner . Interpolate  maxlevel , srcPos , finePosBuffer  primvarRefiner . InterpolateVarying  maxlevel , srcClr , fineClrBuffer    Visualization with Maya  print a MEL script that generates colored  particles at the location of the refined vertices dont forget to  turn shading on in the viewport to see the colors int nverts  nFineVerts   Output particle positions printf  particle  for  int vert  0  vert nverts   vert   float const  pos  finePosBuffer  vert . GetPoint  printf  -p f f f n , pos  0 , pos  1 , pos  2   printf   n   Set particle point size 20 -- very large printf  addAttr -is true -ln  pointSize  -at long -dv 20 particleShape1 n   Add per-particle color attribute rgbPP printf  addAttr -ln  rgbPP  -dt vectorArray particleShape1 n   Set per-particle color values from our primvar data printf  setAttr  particleShape1.rgbPP  -type  vectorArray  d , nverts  for  int vert  0  vert nverts   vert   float const  color  fineClrBuffer  vert . GetPoint  printf  f f f n , color  0 , color  1 , color  2   printf   n    ------------------------------------------------------------------------------  Creates FarTopologyRefiner from raw geometry   see far_tutorial_0 for more details  static Far  TopologyRefiner  createFarTopologyRefiner    Populate a topology descriptor with our raw data typedef Far  TopologyDescriptor Descriptor  Sdc  SchemeType type  OpenSubdiv  Sdc  SCHEME_CATMARK  Sdc  Options options  options . SetVtxBoundaryInterpolation  Sdc  Options  VTX_BOUNDARY_EDGE_ONLY  Descriptor desc  desc . numVertices  g_nverts  desc . numFaces  g_nfaces  desc . numVertsPerFace  g_vertsperface  desc . vertIndicesPerFace  g_vertIndices   Instantiate a FarTopologyRefiner from the descriptor Far  TopologyRefiner  refiner  Far  TopologyRefinerFactory Descriptor  Create  desc , Far  TopologyRefinerFactory Descriptor  Options  type , options  return refiner   ------------------------------------------------------------------------------ Generated on 2016-06-13 0020 UTC. User Docs API Docs Release Notes Forum", "tags": "", "loc":"far_tutorial_2.html"}, 
{"title":"glEvalLimit", "text":"glEvalLimit glEvalLimit 3.0.2 User Docs API Docs Release Notes Forum Github OSD_ARTICLE_TITLE SYNOPSIS DESCRIPTION OPTIONS SEE ALSO SYNOPSIS limitEval  -f  objfiles DESCRIPTION glEvalLimit is a stand-alone application that showcases the limit surface Eval module. On the given shape, random samples are generated in local s,t space. Vertex, varying and face-varying data is then computed on the surface limit and displayed as colors. In order to emphasize the dynamic nature of the EvalLimit API, where the locations can be arbitrarily updated before each evaluation, the glEvalLimit example treats each sample as a ST particle. ST Particles are a simplified parametric-space particle dynamics simulation each particle is assigned a location on the subdivision surface limit that is composed of a unique ptex face index, with a local s,t parametric pair. The system also generates an array of parametric velocities ds, dt for each particle. An Update function then applies the velocities to the locations and moves the points along the parametric space. Face boundaries are managed using a ptex adjacency table obtained from the FarTopologyRefiner. Every time a particle moves outside of the 0.0f, 1.0f parametric range, a warp function moves it to the neighboring face, or bounces it, if the edge happens to be a boundary. Note currently the adjacency code does not handle diagonal crossings, nor crossings between quad and non-quad faces. Multiple controls are available to experiment with the algorithms. OPTIONS -f Launches the application in full-screen mode if is supported by GLFW on the OS SEE ALSO Other examples  glViewer , glShareTopology , glStencilViewer , glPtexViewer , glEvalLimit , glFVarViewer , dxViewer , dxPtexViewer , mayaPolySmooth , Generated on 2016-06-13 0020 UTC. User Docs API Docs Release Notes Forum", "tags": "", "loc":"glevallimit.html"}, 
{"title":"far_tutorial_5.cpp", "text":"far_tutorial_5.cpp far_tutorial_5.cpp 3.0.2 User Docs API Docs Release Notes Forum Github OSD_ARTICLE_TITLE httpsgithub.comPixarAnimationStudiosOpenSubdivblobmastertutorialsfartutorial_5far_tutorial_5.cpp ------------------------------------------------------------------------------  Tutorial description   This tutorial shows how to create and manipulate both vertex and varying  FarStencilTable to interpolate 2 primvar data buffers vertex positions and  vertex colors.  include opensubdivfartopologyDescriptor.h include opensubdivfarstencilTable.h include opensubdivfarstencilTableFactory.h include cstdio include cstring ------------------------------------------------------------------------------  Vertex container implementation.  struct Vertex   Minimal required interface ---------------------- Vertex    Vertex  Vertex const src   _data  0   src . _data  0  _data  1   src . _data  1  _data  2   src . _data  2   void Clear  void   0   _data  0   _data  1   _data  2   0.0f   void AddWithWeight  Vertex const src , float weight   _data  0   weight  src . _data  0  _data  1   weight  src . _data  1  _data  2   weight  src . _data  2    Public interface ------------------------------------ float const  GetData  const  return _data   private  float _data  3   ------------------------------------------------------------------------------  Cube geometry from catmark_cube.h static float g_verts  24    - 0.5f , - 0.5f , 0.5f , 0.5f , - 0.5f , 0.5f , - 0.5f , 0.5f , 0.5f , 0.5f , 0.5f , 0.5f , - 0.5f , 0.5f , - 0.5f , 0.5f , 0.5f , - 0.5f , - 0.5f , - 0.5f , - 0.5f , 0.5f , - 0.5f , - 0.5f   Per-vertex RGB color data static float g_colors  24    1.0f , 0.0f , 0.5f , 0.0f , 1.0f , 0.0f , 0.0f , 0.0f , 1.0f , 1.0f , 1.0f , 1.0f , 1.0f , 1.0f , 0.0f , 0.0f , 1.0f , 1.0f , 1.0f , 0.0f , 1.0f , 0.0f , 0.0f , 0.0f  static int g_nverts  8 , g_nfaces  6  static int g_vertsperface  6    4 , 4 , 4 , 4 , 4 , 4  static int g_vertIndices  24    0 , 1 , 3 , 2 , 2 , 3 , 5 , 4 , 4 , 5 , 7 , 6 , 6 , 7 , 1 , 0 , 1 , 7 , 5 , 3 , 6 , 0 , 2 , 4  using namespace OpenSubdiv  static Far  TopologyRefiner  createTopologyRefiner  ------------------------------------------------------------------------------ int main  int , char     Generate some FarTopologyRefiner see far_tutorial_0 for details. Far  TopologyRefiner  refiner  createTopologyRefiner   Uniformly refine the topolgy up to maxlevel. int maxlevel  4  refiner - RefineUniform  Far  TopologyRefiner  UniformOptions  maxlevel  int nverts  refiner - GetLevel  maxlevel . GetNumVertices   Use the FarStencilTable factory to create discrete stencil table Far  StencilTableFactory  Options options  options . generateIntermediateLevels  false   only the highest refinement level. options . generateOffsets  true    Vertex primvar data   Create stencils table for vertex interpolation options . interpolationMode  Far  StencilTableFactory  INTERPOLATE_VERTEX  Far  StencilTable const  vertexStencils  Far  StencilTableFactory  Create   refiner , options  assert  nverts  vertexStencils - GetNumStencils   Allocate vertex primvar buffer 1 stencil for each vertex std  vector Vertex vertexBuffer  vertexStencils - GetNumStencils   Use the cube vertex positions as vertex primvar data Vertex  vertexCVs  reinterpret_cast Vertex   g_verts    Varying primvar data   Create stencils table for varying interpolation options . interpolationMode  Far  StencilTableFactory  INTERPOLATE_VARYING  Far  StencilTable const  varyingStencils  Far  StencilTableFactory  Create   refiner , options  assert  nverts  varyingStencils - GetNumStencils   Allocate varying primvar buffer 1 stencil for each vertex std  vector Vertex varyingBuffer  varyingStencils - GetNumStencils   Use the a per-vertex array of RGB colors as varying primvar data Vertex  varyingCVs  reinterpret_cast Vertex   g_colors  delete refiner    Apply stencils in frame loop    This section would be applied every frame after control vertices have  been moved.  Apply stencils on the control vertex data to update the primvar data  of the refined vertices. vertexStencils - UpdateValues  vertexCVs , vertexBuffer  0  varyingStencils - UpdateValues  varyingCVs , varyingBuffer  0     Visualization with Maya  print a MEL script that generates particles  at the location of the refined vertices printf  particle  for  int vert  0  vert  int  nverts   vert   float const  pos  vertexBuffer  vert . GetData  printf  -p f f f n , pos  0 , pos  1 , pos  2   printf  -c 1 n   Set particle point size 20 -- very large printf  addAttr -is true -ln  pointSize  -at long -dv 20 particleShape1 n   Add per-particle color attribute rgbPP printf  addAttr -ln  rgbPP  -dt vectorArray particleShape1 n   Set per-particle color values from our varying primvar data printf  setAttr  particleShape1.rgbPP  -type  vectorArray  d , nverts  for  int vert  0  vert nverts   vert   float const  color  varyingBuffer  vert . GetData  printf  f f f n , color  0 , color  1 , color  2   printf   n   delete vertexStencils  delete varyingStencils   ------------------------------------------------------------------------------ static Far  TopologyRefiner  createTopologyRefiner    Populate a topology descriptor with our raw data. typedef Far  TopologyDescriptor Descriptor  Sdc  SchemeType type  OpenSubdiv  Sdc  SCHEME_CATMARK  Sdc  Options options  options . SetVtxBoundaryInterpolation  Sdc  Options  VTX_BOUNDARY_EDGE_ONLY  Descriptor desc  desc . numVertices  g_nverts  desc . numFaces  g_nfaces  desc . numVertsPerFace  g_vertsperface  desc . vertIndicesPerFace  g_vertIndices   Instantiate a FarTopologyRefiner from the descriptor. Far  TopologyRefiner  refiner  Far  TopologyRefinerFactory Descriptor  Create  desc , Far  TopologyRefinerFactory Descriptor  Options  type , options  return refiner   ------------------------------------------------------------------------------ Generated on 2016-06-13 0020 UTC. User Docs API Docs Release Notes Forum", "tags": "", "loc":"far_tutorial_5.html"}, 
{"title":"far_tutorial_3.cpp", "text":"far_tutorial_3.cpp far_tutorial_3.cpp 3.0.2 User Docs API Docs Release Notes Forum Github OSD_ARTICLE_TITLE httpsgithub.comPixarAnimationStudiosOpenSubdivblobmastertutorialsfartutorial_3far_tutorial_3.cpp ------------------------------------------------------------------------------  Tutorial description   Building on tutorial 0, this example shows how to instantiate a simple mesh,  refine it uniformly and then interpolate both vertex and face-varying  primvar data.  The resulting interpolated data is output as an obj file, with the  face-varying data recorded in the uv texture layout.  include opensubdivfartopologyDescriptor.h include opensubdivfarprimvarRefiner.h include cstdio ------------------------------------------------------------------------------  Face-varying implementation.   struct Vertex   Minimal required interface ---------------------- Vertex    Vertex  Vertex const src   _position  0   src . _position  0  _position  1   src . _position  1  _position  2   src . _position  2   void Clear  void   0   _position  0   _position  1   _position  2   0.0f   void AddWithWeight  Vertex const src , float weight   _position  0   weight  src . _position  0  _position  1   weight  src . _position  1  _position  2   weight  src . _position  2    Public interface ------------------------------------ void SetPosition  float x , float y , float z   _position  0   x  _position  1   y  _position  2   z   const float  GetPosition  const  return _position   private  float _position  3   ------------------------------------------------------------------------------  Face-varying container implementation.   We are using a uv texture layout as a face-varying primtiive variable  attribute. Because face-varying data is specified per-face-per-vertex,  we cannot use the same container that we use for vertex or varying  data. We specify a new container, which only carries u,v coordinates.  Similarly to our Vertex container, we add a minimaliztic interpolation  interface with a Clear and AddWithWeight methods.  struct FVarVertexUV   Minimal required interface ---------------------- void Clear   u  v  0.0f   void AddWithWeight  FVarVertexUV const src , float weight   u  weight  src . u  v  weight  src . v    Basic uv layout channel float u , v   struct FVarVertexColor   Minimal required interface ---------------------- void Clear   r  g  b  a  0.0f   void AddWithWeight  FVarVertexColor const src , float weight   r  weight  src . r  g  weight  src . g  b  weight  src . b  a  weight  src . a    Basic color layout channel float r , g , b , a   ------------------------------------------------------------------------------  Cube geometry from catmark_cube.h  vertex primitive variable data topology static float g_verts  8  3    - 0.5f , - 0.5f , 0.5f ,  0.5f , - 0.5f , 0.5f ,  - 0.5f , 0.5f , 0.5f ,  0.5f , 0.5f , 0.5f ,  - 0.5f , 0.5f , - 0.5f ,  0.5f , 0.5f , - 0.5f ,  - 0.5f , - 0.5f , - 0.5f ,  0.5f , - 0.5f , - 0.5f  static int g_nverts  8 , g_nfaces  6  static int g_vertsperface  6    4 , 4 , 4 , 4 , 4 , 4  static int g_vertIndices  24    0 , 1 , 3 , 2 , 2 , 3 , 5 , 4 , 4 , 5 , 7 , 6 , 6 , 7 , 1 , 0 , 1 , 7 , 5 , 3 , 6 , 0 , 2 , 4   face-varying primitive variable data topology for UVs static float g_uvs  14  2    0.375 , 0.00 ,  0.625 , 0.00 ,  0.375 , 0.25 ,  0.625 , 0.25 ,  0.375 , 0.50 ,  0.625 , 0.50 ,  0.375 , 0.75 ,  0.625 , 0.75 ,  0.375 , 1.00 ,  0.625 , 1.00 ,  0.875 , 0.00 ,  0.875 , 0.25 ,  0.125 , 0.00 ,  0.125 , 0.25  static int g_nuvs  14  static int g_uvIndices  24    0 , 1 , 3 , 2 , 2 , 3 , 5 , 4 , 4 , 5 , 7 , 6 , 6 , 7 , 9 , 8 , 1 , 10 , 11 , 3 , 12 , 0 , 2 , 13   face-varying primitive variable data topology for color static float g_colors  24  4    1.0 , 1.0 , 1.0 , 1.0 ,  1.0 , 1.0 , 1.0 , 1.0 ,  1.0 , 1.0 , 1.0 , 1.0 ,  1.0 , 1.0 , 1.0 , 1.0 ,  1.0 , 1.0 , 1.0 , 1.0 ,  1.0 , 1.0 , 1.0 , 1.0 ,  1.0 , 1.0 , 1.0 , 1.0 ,  1.0 , 1.0 , 1.0 , 1.0 ,  1.0 , 1.0 , 1.0 , 1.0 ,  1.0 , 0.0 , 0.0 , 1.0 ,  1.0 , 0.0 , 0.0 , 1.0 ,  1.0 , 0.0 , 0.0 , 1.0 ,  1.0 , 1.0 , 1.0 , 1.0 ,  1.0 , 1.0 , 1.0 , 1.0 ,  1.0 , 1.0 , 1.0 , 1.0 ,  1.0 , 1.0 , 1.0 , 1.0 ,  1.0 , 1.0 , 1.0 , 1.0 ,  1.0 , 1.0 , 1.0 , 1.0 ,  1.0 , 1.0 , 1.0 , 1.0 ,  1.0 , 1.0 , 1.0 , 1.0 ,  1.0 , 1.0 , 1.0 , 1.0 ,  1.0 , 1.0 , 1.0 , 1.0 ,  1.0 , 1.0 , 1.0 , 1.0 ,  1.0 , 1.0 , 1.0 , 1.0  static int g_ncolors  24  static int g_colorIndices  24    0 , 3 , 9 , 6 , 7 , 10 , 15 , 12 , 13 , 16 , 21 , 18 , 19 , 22 , 4 , 1 , 5 , 23 , 17 , 11 , 20 , 2 , 8 , 14  using namespace OpenSubdiv  ------------------------------------------------------------------------------ int main  int , char    int maxlevel  3  typedef Far  TopologyDescriptor Descriptor  Sdc  SchemeType type  OpenSubdiv  Sdc  SCHEME_CATMARK  Sdc  Options options  options . SetVtxBoundaryInterpolation  Sdc  Options  VTX_BOUNDARY_EDGE_ONLY  options . SetFVarLinearInterpolation  Sdc  Options  FVAR_LINEAR_NONE   Populate a topology descriptor with our raw data Descriptor desc  desc . numVertices  g_nverts  desc . numFaces  g_nfaces  desc . numVertsPerFace  g_vertsperface  desc . vertIndicesPerFace  g_vertIndices  int channelUV  0  int channelColor  1   Create a face-varying channel descriptor Descriptor  FVarChannel channels  2  channels  channelUV . numValues  g_nuvs  channels  channelUV . valueIndices  g_uvIndices  channels  channelColor . numValues  g_ncolors  channels  channelColor . valueIndices  g_colorIndices   Add the channel topology to the main descriptor desc . numFVarChannels  2  desc . fvarChannels  channels   Instantiate a FarTopologyRefiner from the descriptor Far  TopologyRefiner  refiner  Far  TopologyRefinerFactory Descriptor  Create  desc , Far  TopologyRefinerFactory Descriptor  Options  type , options   Uniformly refine the topolgy up to maxlevel  note fullTopologyInLastLevel must be true to work with face-varying data  Far  TopologyRefiner  UniformOptions refineOptions  maxlevel  refineOptions . fullTopologyInLastLevel  true  refiner - RefineUniform  refineOptions    Allocate and initialize the vertex primvar data see tutorial 2 for  more details. std  vector Vertex vbuffer  refiner - GetNumVerticesTotal  Vertex  verts  vbuffer  0  for  int i  0  i g_nverts   i   verts  i . SetPosition  g_verts  i  0 , g_verts  i  1 , g_verts  i  2    Allocate and initialize the first channel of face-varying primvar data UVs std  vector FVarVertexUV fvBufferUV  refiner - GetNumFVarValuesTotal  channelUV  FVarVertexUV  fvVertsUV  fvBufferUV  0  for  int i  0  i g_nuvs   i   fvVertsUV  i . u  g_uvs  i  0  fvVertsUV  i . v  g_uvs  i  1    Allocate interpolate the face-varying primvar data colors std  vector FVarVertexColor fvBufferColor  refiner - GetNumFVarValuesTotal  channelColor  FVarVertexColor  fvVertsColor  fvBufferColor  0  for  int i  0  i g_ncolors   i   fvVertsColor  i . r  g_colors  i  0  fvVertsColor  i . g  g_colors  i  1  fvVertsColor  i . b  g_colors  i  2  fvVertsColor  i . a  g_colors  i  3    Interpolate both vertex and face-varying primvar data Far  PrimvarRefiner primvarRefiner   refiner  Vertex  srcVert  verts  FVarVertexUV  srcFVarUV  fvVertsUV  FVarVertexColor  srcFVarColor  fvVertsColor  for  int level  1  level  maxlevel   level   Vertex  dstVert  srcVert  refiner - GetLevel  level - 1 . GetNumVertices  FVarVertexUV  dstFVarUV  srcFVarUV  refiner - GetLevel  level - 1 . GetNumFVarValues  channelUV  FVarVertexColor  dstFVarColor  srcFVarColor  refiner - GetLevel  level - 1 . GetNumFVarValues  channelColor  primvarRefiner . Interpolate  level , srcVert , dstVert  primvarRefiner . InterpolateFaceVarying  level , srcFVarUV , dstFVarUV , channelUV  primvarRefiner . InterpolateFaceVarying  level , srcFVarColor , dstFVarColor , channelColor  srcVert  dstVert  srcFVarUV  dstFVarUV  srcFVarColor  dstFVarColor     Output OBJ of the highest level refined ----------- Far  TopologyLevel const refLastLevel  refiner - GetLevel  maxlevel  int nverts  refLastLevel . GetNumVertices  int nuvs  refLastLevel . GetNumFVarValues  channelUV  int ncolors  refLastLevel . GetNumFVarValues  channelColor  int nfaces  refLastLevel . GetNumFaces   Print vertex positions int firstOfLastVerts  refiner - GetNumVerticesTotal  - nverts  for  int vert  0  vert nverts   vert   float const  pos  verts  firstOfLastVerts  vert . GetPosition  printf  v f f f n , pos  0 , pos  1 , pos  2    Print uvs int firstOfLastUvs  refiner - GetNumFVarValuesTotal  channelUV  - nuvs  for  int fvvert  0  fvvert nuvs   fvvert   FVarVertexUV const uv  fvVertsUV  firstOfLastUvs  fvvert  printf  vt f f n , uv . u , uv . v    Print colors int firstOfLastColors  refiner - GetNumFVarValuesTotal  channelColor  - ncolors  for  int fvvert  0  fvvert nuvs   fvvert   FVarVertexColor const c  fvVertsColor  firstOfLastColors  fvvert  printf  c f f f f n , c . r , c . g , c . b , c . a    Print faces for  int face  0  face nfaces   face   Far  ConstIndexArray fverts  refLastLevel . GetFaceVertices  face  Far  ConstIndexArray fuvs  refLastLevel . GetFaceFVarValues  face , channelUV   all refined Catmark faces should be quads assert  fverts . size   4 and fuvs . size   4  printf  f  for  int vert  0  vert fverts . size   vert    OBJ uses 1-based arrays... printf  dd , fverts  vert   1 , fuvs  vert   1   printf  n     ------------------------------------------------------------------------------ Generated on 2016-06-13 0020 UTC. User Docs API Docs Release Notes Forum", "tags": "", "loc":"far_tutorial_3.html"}, 
{"title":"3.0 Release Notes", "text":"3.0 Release Notes 3.0 Release Notes 3.0.2 User Docs API Docs Release Notes Forum Github OSD_ARTICLE_TITLE Release 3.0.2 Release 3.0.1 Release 3.0.0 Release 3.0.0 RC2 Release 3.0.0 RC1 Previous 2.x Release Notes Release 3.0.2 Release 3.0.2 is a minor release for a specific fix. Bug Fixes Fixed drawing of single crease patches Release 3.0.1 Release 3.0.1 is a minor release focused on stability and correctness. Changes Added a references section to the documentation, please see References Removed references to AddVaryingWithWeight from examples and tutorials Added more regression test shapes Addressed general compiler warnings e.g. signed vs unsigned comparisons Addressed compiler warnings in the core libraries reported by GCCs -Wshadow Eased GCC version restriction, earlier requirement for version 4.8 or newer is no longer needed Replaced topology initialization assertions with errors Improved compatibility with ICC Improved descriptive content and formatting of Far error messages Improved build when configured to include no GPU specific code Bug Fixes Fixed handling of unconnected vertices to avoid out of bounds data access Fixed non-zero starting offsets for TbbEvalStencils and OmpEvalStencils Fixed FarStencilTableFactoryOptionsfactorizeIntermediateLevels Fixed FarPatchTablesFactoryOptionsgenerateAllLevels Fixed the behavior of VTX_BOUNDARY_NONE for meshes with bilinear scheme Fixed some template method specializations which produced duplicate definitions Disabled depth buffering when drawing the UI in the example viewers Disabled the fractional tessellation spacing option in example viewers since this mode is currently not supported Release 3.0.0 Release 3.0.0 is a major release with many significant improvements and changes. For more information on the following, please see Introduction to 3.0 New Features Faster subdivision using less memory Support for non-manifold topology Face-Varying data specified topologically Elimination of fixed valence tables Single-crease patch for semi-sharp edges Additional irregular patch approximations Introduction of Stencil Tables Faster, simpler GPU kernels Unified adaptive shaders Updated coding style with namespaces More documentation and tutorials Bug Fixes Smooth Face-Varying interpolation around creases Release 3.0.0 RC2 New Features Documentation updates far_tutorial_3 updates for the multiple face-varying channels maya example plugin interpolates a UV channel and a vertex color channel Bug Fixes Fixed a LimitStencilTableFactory bug, which returns an invalid table PatchParam encoding changed to support refinement levels up to 10 Added Xinerama link dependency Fixed MSVC 32bit build problem Fixed minor cmake issues Fixed glViewerfarViewer stability bugs Release 3.0.0 RC1 Changes FarTopologyRefiner was split into several classes to clarify and focus the API. Interpolation of Vertex and Varying primvars in a single pass is no longer supported. The Osd layer was largely refactored. Previous 2.x Release Notes Previous releases Generated on 2016-06-13 0020 UTC. User Docs API Docs Release Notes Forum", "tags": "", "loc":"release_notes.html"}, 
{"title":"Maya osdPolySmooth", "text":"Maya osdPolySmooth Maya osdPolySmooth 3.0.2 User Docs API Docs Release Notes Forum Github OSD_ARTICLE_TITLE DESCRIPTION Usage Attributes 9 SEE ALSO DESCRIPTION The Maya OsdPolySmooth node takes a base mesh and generates an OpenSubdiv subdivided mesh. Note This plugin is not representative of actual workflows in the application. The intended use is for quick comparisons with Rendermans interpolation settings. Usage Once the plugin is loaded in Maya Select a poly mesh Polygons - Edit Mesh - OSD Subdivide Meshes Attributes 9 inputPolymesh, output, recommendedIsolation, subdivisionLevels, vertBoundaryMethod, fvarBoundaryMethod, fvarPropagateCorners, smoothTriangles, creaseMethod, Long Name Short Name Type Default Flags inputPolymesh ip This is a description for this attribute mesh input hidden connectable storable output out This is a description for this attribute mesh hidden connectable storable output subdivisionLevels sl The number of recursive quad subdivisions to perform on each face. int 2 input connectable storable recommendedIsolation ri The recommended levels of subdivision required to account for crease sharpness int output connectable storable vertBoundaryMethod vbm Controls how boundary edges and vertices are interpolated. Smooth, Edges InterpolateBoundaryEdgeOnly Smooth, Edges and Corners InterpolateBoundaryEdgeAndCorner enum EdgeOnly input connectable storable fvarBoundaryMethod fvbm Controls how boundaries are treated for face-varying data UVs and Vertex Colors. Bi-linear None InterpolateBoundaryNone Smooth Edge Only InterpolateBoundaryEdgeOnly Smooth Edges and Corners InterpolateBoundaryEdgeAndCorner Smooth ZBrush and Maya Smooth Internal Only  InterpolateBoundaryAlwaysSharp enum None input connectable storable fvarPropagateCorners fvpc Check all faces to see if two edges side by side are facevarying boundary edges bool false input connectable storable smoothTriangles stri Apply a special subdivision rule be applied to all triangular faces that was empirically determined to make triangles subdivide more smoothly. bool true input connectable storable creaseMethod crm Controls how boundary edges and vertices are interpolated. Normal No Crease sharpness smoothing Chaikin Improves the appearance of multiedge creases with varying weight enum 0 input connectable storable SEE ALSO Other examples  glViewer , glShareTopology , glStencilViewer , glPtexViewer , glEvalLimit , glFVarViewer , dxViewer , dxPtexViewer , mayaPolySmooth , Generated on 2016-06-13 0020 UTC. User Docs API Docs Release Notes Forum", "tags": "", "loc":"maya_osdpolysmooth.html"}, 
{"title":"glPaintTest", "text":"glPaintTest glPaintTest 3.0.2 User Docs API Docs Release Notes Forum Github OSD_ARTICLE_TITLE SYNOPSIS DESCRIPTION OPTIONS Keyboard Controls SEE ALSO SYNOPSIS glPaintTest  -f  objfiles DESCRIPTION glPaintTest is a small stand-alone application showing the potential of using GPU limit tessellation for painting and sculpting applications. OPTIONS -f Launches the application in full-screen mode if is supported by GLFW on the OS objfiles A sequence of obj files used as an animation loop the topology has to match the data contained in all the ptex files  Keyboard Controls c  use texture as color d  use texture as displacement SEE ALSO Other examples  glViewer , glShareTopology , glStencilViewer , glPtexViewer , glEvalLimit , glFVarViewer , dxViewer , dxPtexViewer , mayaPolySmooth , Generated on 2016-06-13 0021 UTC. User Docs API Docs Release Notes Forum", "tags": "", "loc":"glpainttest.html"}, 
{"title":"Overview of Release 3.0", "text":"Overview of Release 3.0 Overview of Release 3.0 3.0.2 User Docs API Docs Release Notes Forum Github OSD_ARTICLE_TITLE Release 3.0 Subdivision Core Sdc Topology and Refinement Limit Properties and Patches Faster Evaluation and Display Updated Source-Code Style Documentation and Tutorials Additional Resources Porting Guide Subdivision Compatibility Release 3.0 OpenSubdiv 3.0 represents a landmark release, with profound changes to the core algorithms, simplified APIs, and streamlined GPU execution. Providing faster, more efficient, and more flexible subdivision code remains our principal goal. To achieve this, OpenSubdiv 3.0 introduces many improvements that constitute a fairly radical departure from previous versions. This document highlights some of the major changes that have gone in to the 3.0 release. Subdivision Core Sdc In consideration of past, present and future topological representations, all low-level details fundamental to subdivision and the specific subdivision schemes have been factored into a new low-level layer called Sdc SubDivision Core. This layer encapsulates the full set of applicable options, the formulae required to support semi-sharp creasing, the formulae for the refinement masks of each subdivision scheme, etc. As initially conceived, its goal was often expressed as separating the math from the mesh . Sdc provides the low-level nuts and bolts to provide a subdivision implementation consistent with OpenSubdiv. It is used by OpenSubdivs libraries and may also be useful in providing an existing clients implementation with the details necessary to make that implementation consistent with OpenSubdiv. Topology and Refinement OpenSubdiv 3.0 introduces a new intermediate internal topological representation named Vtr Vectorized Topology Representation. Compared to the Hbr library used in previous versions, Vtr is much more efficient for the kinds of topological analysis required by Far and is more flexible. While Hbr is no longer used by OpenSubdiv, it will remain in the source distribution for legacy and regression purposes. Faster Subdivision A major focus of the 3.0 release is performance, and the improvement to the initial refinement of a mesh required for topological analysis is close to an order magnitude often much more for uniform, but less for adaptive. Supporting for Non-manifold Topology With topology conversion no longer constrained by Hbr, OpenSubdiv is no longer restricted to meshes of manifold topology. With one exception non-triangles with Loop subdivision, any set of faces and vertices that can be represented in common container formats such as Obj or Alembic can be represented and subdivided. With future efforts to bring the functionality for the Loop scheme up to par with Catmark, that last remaining topological restriction will be removed. Simpler Conversion of Topology Several entry-points are now available for client topology, rather than the single incremental assembly of an HbrMesh that previously existed. The new topological relationships can be populated using either a high-level interface where simplicity has been emphasized, or a more complex lower-level interface for enhanced efficiency. Face Varying Topology Previously, face-varying data was assigned by value to the vertex for each face, and whether or not the set of values around a vertex was continuous was determined by comparing these values later. In some cases this could result in two values that were not meant to be shared being welded together. Face-varying data is now specified topologically just as the vertex topology is defined from a set of vertices and integer references indices to these vertices for the corner of each face, face-varying topology is defined from a set of values and integer references indices to these values for the corner of each face. So if values are to be considered distinct around a vertex, they are given distinct indices and no comparison of any data is ever performed. Note that the number of vertices and values will typically differ, but since indices are assigned to the corners of all faces for both, the total number of indices assigned to all faces will be the same. This ensures that OpenSubdivs face-varying topology matches what is often specified in common geometry container formats like Obj, Alembic and USD. Multiple channels of face-varying data can be defined and each is topologically independent of the others. Limit Properties and Patches A fundamental goal of OpenSubdiv is to provide an accurate and reliable representation of the limit surface. Improvements have been made both to the properties positions and tangents at discrete points in the subdivision hierarchy, as well as to the representations of patches used for the continuous limit surface between them. Removed Fixed Valence Tables Limit properties of extra-ordinary vertices are computed for arbitrary valence and new patch types no longer rely on small table sizes. All tables that restricted the valence of a vertex to some relatively small table size have now been removed. The only restriction on valence that exists is within the new topology representation, which restricts it to the size of an unsigned 16-bit integer 65,535. This limit could also be removed, by recompiling with a certain size changed from 16- to 32-bits, but doing so would increase the memory cost for all common cases. We feel the 16-bit limit is a reasonable compromise. Single Crease Patch OpenSubdiv 3.0 newly implements efficient evaluation of semi-smooth creases using single crease patches. With this optimization, high-order edge sharpness tags can be handled very efficiently for both computation time and memory consumption.  Niessner et al., Efficient Evaluation of Semi-Smooth Creases in Catmull-Clark Subdivision Surfaces. Eurographics Short Papers. 2012. httpresearch.microsoft.comen-usumpeoplecloopEG2012.pdf New Irregular Patch Approximations While legacy Gregory patch support is still available, we have introduced several new options for representing irregular patches Legacy Gregory, fast Gregory Basis stencils, and BSpline patches. Gregory basis stencils provide the same high quality approximation of Legacy Gregory patches, but execute considerably faster with a simpler GPU representation. While BSpline patches are not as close an approximation as Gregory patches, they enable an entire adaptively refined mesh to be drawn with screen space tessellation via a single global shader configuration Gregory Basis patches require one additional global shader configuration. The new implementations of the GregoryBasis and BSpline approximations relax the previous max valence limit. Legacy Gregory patch still has a limitation of max valence typically 24, depending on the hardware capability of GL_MAX_VARYING_VECTORS. Users are still encouraged to use models with vertices of low valence for both improved model quality and performance. Faster Evaluation and Display OpenSubdiv 3.0 also introduces new data structures and algorithms that greatly enhance performance for the common case of repeated evaluation both on the CPU and GPU. Introducing Stencil Tables OpenSubdiv 3.0 replaces the serialized subdivision tables with factorized stencil tables. The SubdivisionTables class of earlier releases contained a large number of data inter-dependencies, which incurred penalties from fences or force additional kernel launches. Most of these dependencies have now been factorized away in the pre-computation stage, yielding stencil tables FarStencilTable instead. Stencils remove all data dependencies and simplify all the computations into a single trivial kernel. This simplification results in a faster pre-computation stage, faster execution on GPU, with less driver overhead. The new stencil tables Compute back-end is supported on all the same platforms as previous releases except GCD. Faster, Simpler GPU Kernels On the GPU side, the replacement of subdivision tables with stencils greatly reduces bottlenecks in compute, yielding as much as a 4x interpolation speed-up. At the same time, stencils reduce the complexity of interpolation to a single kernel launch per primitive, a critical improvement for mobile platforms. As a result of these changes, compute batching is now trivial, which in turn enabled API simplifications in the Osd layer. Unified Adaptive Shaders Adaptive tessellation shader configurations have been greatly simplified. The number of shader configurations has been reduced from a combinatorial per-patch explosion down to a constant two global configurations. This massive improvement over the 2.x code base results in significantly faster load times and a reduced per-frame cost for adaptive drawing. Similar to compute kernel simplification, this shader simplification has resulted in additional simplifications in the Osd layer. Updated Source-Code Style OpenSubdiv 3.0 replaces naming prefixes with C namespaces for all API layers, bringing the source style more in line with contemporary specifications mostly inspired from the Google C Style Guide . The large-scale changes introduced in this release generally break compatibility with existing client-code. However, this gives us the opportunity to effect some much needed updates to our code-style guidelines and general conventions, throughout the entire OpenSubdiv code-base. We are hoping to drastically improve the quality, consistency and readability of the source code. Documentation and Tutorials The documentation has been reorganized and fleshed out. This release introduces a number of new tutorials . The tutorials provide an easier entry point for learning the API than do the programs provided in examples. The examples provide more fleshed out solutions and are a good next step after the tutorials are mastered. Additional Resources Porting Guide Please see the Porting Guide for help on how to port existing code written for OpenSubdiv 2.x to the new 3.0 release. Subdivision Compatibility The 3.0 release has made some minor changes to the subdivision specification and rules. See Subdivision Compatibility for a complete list. Generated on 2016-06-13 0020 UTC. User Docs API Docs Release Notes Forum", "tags": "", "loc":"intro_30.html"}, 
{"title":"Building with CMake", "text":"Building with CMake Building with CMake 3.0.2 User Docs API Docs Release Notes Forum Github OSD_ARTICLE_TITLE Overview Step 1 Dependencies Required Optional Step 2 Configuring CMake Useful Build Options Environment Variables Automated Script Using Intels C Studio XE Using Clang Step 3 Building Build Targets Compiling Linking an OpenSubdiv Application Overview Assuming that you have cloned the source repository and selected an appropriate release branch, the following instructions will walk you through the CMake and configuration and build process. CMake is a cross-platform, open-source build system. CMake controls the compilation process using platform independent configuration files in order to generate Makefiles and workspaces that are native to the platform of choice. The process involves the following steps Locate build the requisite dependencies Configure run CMake to generate Makefiles  MSVC solution  XCode project Run the build from make  MSVC  XCode Step 1 Dependencies CMake will adapt the build based on which dependencies have been successfully discovered and will disable certain features and code examples accordingly. Please refer to the documentation of each of the dependency packages for specific build and installation instructions. Required CMake version 2.8 Optional Ptex support features for ptex textures and the ptexViewer example Zlib required for Ptex under Windows GLEW CUDA TBB OpenCL DX11 SDK GLFW required for standalone examples and some regression tests Docutils required for reST-based documentation Python Pygments required for Docutils reST styling Doxygen Step 2 Configuring CMake One way to configure CMake is to use the CMake GUI . In many cases CMake can fall back on default standard paths in order to find the packages that OpenSubdiv depends on. For non-standard installations however, a complete set of override variables is available. The following sub-section lists some of these variables. For more specific details, please consult the source of the custom CMake modules in the OpenSubdivcmake folder. Useful Build Options The following configuration arguments can be passed to the CMake command line. - DCMAKE_BUILD_TYPE   Debug  Release  - DCMAKE_INSTALL_PREFIX   base path to install OpenSubdiv  default  Current directory  - DCMAKE_LIBDIR_BASE   library directory basename  default  lib  - DCUDA_TOOLKIT_ROOT_DIR   path to CUDA  - DPTEX_LOCATION   path to Ptex  - DGLEW_LOCATION   path to GLEW  - DGLFW_LOCATION   path to GLFW  - DMAYA_LOCATION   path to Maya  - DTBB_LOCATION   path to Intel  s TBB  - DICC_LOCATION   path to Intel  s C  Studio XE  - DNO_LIB  1  disable the opensubdiv libs build caveat emptor - DNO_EXAMPLES  1  disable examples build - DNO_TUTORIALS  1  disable tutorials build - DNO_REGRESSION  1  disable regression tests build - DNO_MAYA  1  disable Maya plugin build - DNO_PTEX  1  disable PTex support - DNO_DOC  1  disable documentation build - DNO_OMP  1  disable OpenMP - DNO_TBB  1  disable TBB - DNO_CUDA  1  disable CUDA - DNO_OPENCL  1  disable OpenCL - DNO_OPENGL  1  disable OpenGL - DNO_CLEW  1  disable CLEW wrapper library Environment Variables The paths to Maya, Ptex, GLFW, GLEW and other dependencies can also be specified through the following environment variables MAYA_LOCATION , PTEX_LOCATION , GLFW_LOCATION , GLEW_LOCATION Automated Script The GUI solution will probably become a burden for active developpers who tend to re-run the configuration step fairly often. A scripted solution can save a lot of time. Here is a typical workflow git clone https  github.comPixarAnimationStudiosOpenSubdiv.git folder cd folder mkdir build cd build source ..  ..  cmake_setup Where cmake_setup is a configuration script. Here is an example CMake configuration script for a full typical windows-based build that can be run in GitShell  bintcsh  Replace the .. with a full path to the root of the OpenSubdiv source tree if necessary cProgram Files x86CMake 2.8bincmake.exe  - G Visual Studio 10 Win64  - D GLEW_LOCATIONstringcProgram Filesglew-1.9.0  - D GLFW_LOCATIONstringcProgram Filesglfw-2.7.7.bin.WIN64  - D OPENCL_INCLUDE_DIRSstringcProgramDataNVIDIA CorporationNVIDIA GPU Computing SDK 4.2OpenCLcommoninc  - D _OPENCL_CPP_INCLUDE_DIRSstringcProgramDataNVIDIA CorporationNVIDIA GPU Computing SDK 4.2OpenCLcommoninc  - D OPENCL_LIBRARIESstringcProgramDataNVIDIA CorporationNVIDIA GPU Computing SDK 4.2OpenCLcommonlibx64OpenCL.lib  - D MAYA_LOCATIONstringcProgram FilesAutodeskMaya2013.5  - D PTEX_LOCATIONstringcUsersopensubdivdemosrcptexx64  ..  copy Ptex dependencies Windows only mkdir - p bin   Debug , Release   cp - f c   Users  opensubdiv  demo  src  zlib - 1.2.7  contrib  vstudio  vc10  x64  ZlibDllRelease  zlibwapi . dll bin  Debug   cp - f c   Users  opensubdiv  demo  src  zlib - 1.2.7  contrib  vstudio  vc10  x64  ZlibDllRelease  zlibwapi . dll bin  Release   cp - f c   Users  opensubdiv  demo  src  ptex  x64  lib  Ptex . dll bin  Debug   cp - f c   Users  opensubdiv  demo  src  ptex  x64  lib  Ptex . dll bin  Release  Important Notice that the following scripts start by recursively removing the ..build and ..inst directories. Make sure you modify them to suit your build workflow. Here is a similar script for Nix-based platforms echo  Removing build cd .. rm - rf build  inst   mkdir build  cd build  echo  Running cmake cmake - DPTEX_LOCATION  home  opensubdiv  dev  opensource  ptex  install  - DGLEW_LOCATION  home  opensubdiv  dev  opensource  glew  glew - 1.9.0  - DGLFW_LOCATION  home  opensubdiv  dev  opensource  glfw  build  - DDOXYGEN_EXECUTABLE  home  opensubdiv  dev  opensource  doxygen  inst  bin  doxygen  - DCMAKE_INSTALL_PREFIX  ..  inst  - DCMAKE_BUILD_TYPE  Debug  .. Here is a similar script for OSX echo  Removing build cd .. rm - rf build  inst   mkdir build  cd build  echo  Running cmake cmake - DOPENGL_INCLUDE_DIR  Applications  Xcode . app  Contents  Developer  Platforms  MacOSX . platform  Developer  SDKs  MacOSX10 .9 . sdk  System  Library  Frameworks  OpenGL . framework  Headers  - DGLFW_LOCATION  Users  opensubdiv  dev  opensource  glfw  inst  - DNO_OMP  1 - DNO_REGRESSION  0  - DCMAKE_INSTALL_PREFIX  ..  inst  - DCMAKE_BUILD_TYPE  Debug  .. Using Intels C Studio XE OpenSubdiv can be also be built with Intels C compiler icc. The default compiler can be overriden in CMake with the following configuration options - DCMAKE_CXX_COMPILER   path to icc executable  - DCMAKE_C_COMPILER   path to icc executable  The installation location of the C Studio XE can be overriden with - DICC_LOCATION   path to Intel  s C  Studio XE  Using Clang CMake can also be overriden to use the clang compilers by configuring the following options - DCMAKE_CXX_COMPILER  clang   - DCMAKE_C_COMPILER  clang  Step 3 Building CMake provides a cross-platform command-line build cmake -- build . -- target install -- config Release Alternatively, you can use native toolkits to launch the build. The steps differ for each OS Windows  launch VC with the solution generated by CMake in your build directory. OSX  run make in the build directory Nix  run make in your build directory - use the clean target to remove previous build results - use VERBOSE1 for verbose build output Note We recommend against using CMakes Xcode project generator -G Xcode  on OSX, as it seems to generate some dependencies incorrectly. We recommend instead reverting to Makefiles on OSX, and launching make , instead of xcodebuild to execute the build make sure to install the command line tools in Xcode Build Targets Makefile-based builds allow the use of named target. Here are some of the more useful target names osd_ staticdynamic _ CPUGPU The core components of the OpenSubdiv libraries example_name Builds specific code examples by name glViewer, ptexViewer... doc Builds ReST and doxygen documentation doc_html Builds ReST documentation doc_doxy Builds Doxygen documentation Compiling Linking an OpenSubdiv Application Here are example commands for building an OpenSubdiv application on several architectures Linux g -IOPENSUBDIVinclude -c myapp.cpp g myapp.o -LOPENSUBDIVlib -losdCPU -losdGPU -o myapp Mac OS-X g -IOPENSUBDIVinclude -c myapp.cpp g myapp.o -LOPENSUBDIVlib -losdCPU -losdGPU -o myapp install_name_tool -add_rpath OPENSUBDIVlib myapp On 64-bit OS-X add -m64 after each g . Windows cl nologo MT TP DWIN32 I OPENSUBDIVinclude -c myapp.cpp link nologo outmyapp.exe LIBPATH OPENSUBDIVlib libosdCPU.lib libosdGPU.lib myapp.obj Note HBR uses the offsetof macro on a templated struct, which appears to spurriously set off a warning in both gcc and Clang. It is recommended to turn the warning off with the -Wno-invalid-offsetof flag. Generated on 2016-06-13 0020 UTC. User Docs API Docs Release Notes Forum", "tags": "", "loc":"cmake_build.html"}, 
{"title":"far_tutorial_1.cpp", "text":"far_tutorial_1.cpp far_tutorial_1.cpp 3.0.2 User Docs API Docs Release Notes Forum Github OSD_ARTICLE_TITLE httpsgithub.comPixarAnimationStudiosOpenSubdivblobmastertutorialsfartutorial_1far_tutorial_1.cpp ------------------------------------------------------------------------------  Tutorial description   This tutorial shows how to interface a high-level topology representation  with Far for better efficiency. In tutorial 0, we showed how to instantiate  topology from a simple face-vertex list. Here we will show how to take  advantage of more complex data structures.   Many client applications that manipulate geometry use advanced data structures  such as half-edge, quad-edge or winged-edge in order to represent complex  topological relationships beyond the usual face-vertex lists. We can take  advantage of this information.   Far provides an advanced interface that allows such a client application to  communicate advanced component relationships directly and avoid having Far  rebuilding them redundantly.  include opensubdivfartopologyRefinerFactory.h include opensubdivfarprimvarRefiner.h include cstdio ------------------------------------------------------------------------------ using namespace OpenSubdiv  ------------------------------------------------------------------------------   For this tutorial, we provide the complete topological representation of a  simple pyramid. In our case, we store it as a simple sequence of integers,  with the understanding that client-code would provide a fully implemented  data-structure such as quad-edges or winged-edges.   Pyramid geometry from catmark_pyramid.h - extended for this tutorial  static int g_nverts  5 , g_nedges  8 , g_nfaces  5   vertex positions static float g_verts  5  3    0.0f , 0.0f , 2.0f ,  0.0f , - 2.0f , 0.0f ,  2.0f , 0.0f , 0.0f ,  0.0f , 2.0f , 0.0f ,  - 2.0f , 0.0f , 0.0f   number of vertices in each face static int g_facenverts  5    3 , 3 , 3 , 3 , 4   index of face vertices static int g_faceverts  16    0 , 1 , 2 , 0 , 2 , 3 , 0 , 3 , 4 , 0 , 4 , 1 , 4 , 3 , 2 , 1   index of edge vertices 2 per edge static int g_edgeverts  16    0 , 1 , 1 , 2 , 2 , 0 , 2 , 3 , 3 , 0 , 3 , 4 , 4 , 0 , 4 , 1   index of face edges static int g_faceedges  16    0 , 1 , 2 , 2 , 3 , 4 , 4 , 5 , 6 , 6 , 7 , 0 , 5 , 3 , 1 , 7   number of faces adjacent to each edge static int g_edgenfaces  8    2 , 2 , 2 , 2 , 2 , 2 , 2 , 2   index of faces incident to a given edge static int g_edgefaces  16    0 , 3 , 0 , 4 , 0 , 1 , 1 , 4 , 1 , 2 , 2 , 4 , 2 , 3 , 3 , 4   number of faces incident to each vertex static int g_vertexnfaces  5    4 , 3 , 3 , 3 , 3   index of faces incident to each vertex static int g_vertexfaces  25    0 , 1 , 2 , 3 , 0 , 3 , 4 , 0 , 4 , 1 , 1 , 4 , 2 , 2 , 4 , 3   number of edges incident to each vertex static int g_vertexnedges  5    4 , 3 , 3 , 3 , 3   index of edges incident to each vertex static int g_vertexedges  25    0 , 2 , 4 , 6 , 1 , 0 , 7 , 2 , 1 , 3 , 4 , 3 , 5 , 6 , 5 , 7   Edge crease sharpness static float g_edgeCreases  8    0.0f , 2.5f , 0.0f , 2.5f , 0.0f , 2.5f , 0.0f , 2.5f  ------------------------------------------------------------------------------   Because existing client-code may not provide an exact match for the  topological queries required by Fars interface, we can provide a converter  class. This can be particularly useful for instance if the client  data-structure requires additional relationships to be mapped. For instance,  half-edge representations do not store unique edge indices and it can be  difficult to traverse edges or faces adjacent to a given vertex.   Using an intermediate wrapper class allows us to leverage existing  relationships information from a mesh, and generate the missing components  temporarily.   For a practical example, you can look at the file hbr_to_vtr.h in the same  tutorial directory. This example implements a OsdHbrConverter class as a  way of interfacing PRmans half-edge representation to Far.  struct Converter  public  Sdc  SchemeType GetType  const  return Sdc  SCHEME_CATMARK   Sdc  Options GetOptions  const  Sdc  Options options  options . SetVtxBoundaryInterpolation  Sdc  Options  VTX_BOUNDARY_EDGE_ONLY  return options   int GetNumFaces  const  return g_nfaces   int GetNumEdges  const  return g_nedges   int GetNumVertices  const  return g_nverts     Face relationships  int GetNumFaceVerts  int face  const  return g_facenverts  face   int const  GetFaceVerts  int face  const  return g_faceverts  getCompOffset  g_facenverts , face   int const  GetFaceEdges  int face  const  return g_faceedges  getCompOffset  g_facenverts , face     Edge relationships  int const  GetEdgeVertices  int edge  const  return g_edgeverts  edge  2   int GetNumEdgeFaces  int edge  const  return g_edgenfaces  edge   int const  GetEdgeFaces  int edge  const  return g_edgefaces  getCompOffset  g_edgenfaces , edge     Vertex relationships  int GetNumVertexEdges  int vert  const  return g_vertexnedges  vert   int const  GetVertexEdges  int vert  const  return g_vertexedges  getCompOffset  g_vertexnedges , vert   int GetNumVertexFaces  int vert  const  return g_vertexnfaces  vert   int const  GetVertexFaces  int vert  const  return g_vertexfaces  getCompOffset  g_vertexnfaces , vert   private  int getCompOffset  int const  comps , int comp  const  int ofs  0  for  int i  0  i comp   i   ofs  comps  i   return ofs    ------------------------------------------------------------------------------ namespace OpenSubdiv  namespace OPENSUBDIV_VERSION  namespace Far  template bool TopologyRefinerFactory Converter  resizeComponentTopology  TopologyRefiner refiner , Converter const conv    Faces and face-verts int nfaces  conv . GetNumFaces  setNumBaseFaces  refiner , nfaces  for  int face  0  face nfaces   face   int nv  conv . GetNumFaceVerts  face  setNumBaseFaceVertices  refiner , face , nv    Edges and edge-faces int nedges  conv . GetNumEdges  setNumBaseEdges  refiner , nedges  for  int edge  0  edge nedges   edge   int nf  conv . GetNumEdgeFaces  edge  setNumBaseEdgeFaces  refiner , edge , nf    Vertices and vert-faces and vert-edges int nverts  conv . GetNumVertices  setNumBaseVertices  refiner , nverts  for  int vert  0  vert nverts   vert   int ne  conv . GetNumVertexEdges  vert , nf  conv . GetNumVertexFaces  vert  setNumBaseVertexEdges  refiner , vert , ne  setNumBaseVertexFaces  refiner , vert , nf   return true   template bool TopologyRefinerFactory Converter  assignComponentTopology  TopologyRefiner refiner , Converter const conv   typedef Far  IndexArray IndexArray    Face relations int nfaces  conv . GetNumFaces  for  int face  0  face nfaces   face   IndexArray dstFaceVerts  getBaseFaceVertices  refiner , face  IndexArray dstFaceEdges  getBaseFaceEdges  refiner , face  int const  faceverts  conv . GetFaceVerts  face  int const  faceedges  conv . GetFaceEdges  face  for  int vert  0  vert conv . GetNumFaceVerts  face   vert   dstFaceVerts  vert   faceverts  vert  dstFaceEdges  vert   faceedges  vert       Edge relations   Note if your representation is unable to provide edge relationships  ex half-edges, you can comment out this section and Far will  automatically generate the missing information.  int nedges  conv . GetNumEdges  for  int edge  0  edge nedges   edge    Edge-vertices IndexArray dstEdgeVerts  getBaseEdgeVertices  refiner , edge  dstEdgeVerts  0   conv . GetEdgeVertices  edge  0  dstEdgeVerts  1   conv . GetEdgeVertices  edge  1   Edge-faces IndexArray dstEdgeFaces  getBaseEdgeFaces  refiner , edge  for  int face  0  face conv . GetNumEdgeFaces  face   face   dstEdgeFaces  face   conv . GetEdgeFaces  edge  face       Vertex relations int nverts  conv . GetNumVertices  for  int vert  0  vert nverts   vert    Vert-Faces IndexArray vertFaces  getBaseVertexFaces  refiner , vert  LocalIndexArray vertInFaceIndices  getBaseVertexFaceLocalIndicesrefiner, vert for  int face  0  face conv . GetNumVertexFaces  vert   face   vertFaces  face   conv . GetVertexFaces  vert  face    Vert-Edges IndexArray vertEdges  getBaseVertexEdges  refiner , vert  LocalIndexArray vertInEdgeIndices  getBaseVertexEdgeLocalIndicesrefiner, vert for  int edge  0  edge conv . GetNumVertexEdges  vert   edge   vertEdges  edge   conv . GetVertexEdges  vert  edge     populateBaseLocalIndices  refiner  return true   template bool TopologyRefinerFactory Converter  assignComponentTags  TopologyRefiner refiner , Converter const conv    arbitrarily sharpen the 4 bottom edges of the pyramid to 2.5f for  int edge  0  edge conv . GetNumEdges   edge   setBaseEdgeSharpness  refiner , edge , g_edgeCreases  edge   return true   ifdef _MSC_VER template void TopologyRefinerFactory Converter  reportInvalidTopology  TopologyError  errCode  , char const  msg , Converter const  mesh      Optional topology validation error reporting  This method is called whenever the factory encounters topology validation  errors. By default, nothing is reported  Warning  msg   template bool TopologyRefinerFactory Converter  assignFaceVaryingTopology  TopologyRefiner  refiner  , Converter const  conv     Because of the way MSVC specializes templated functions, we had to  remove the default stubs in FarTopologyRefinerFactory. In this  example, no face-varying data is being added, but we still need to  implement a template specialization or MSVC linker fails. return true   endif   namespace Far   namespace OPENSUBDIV_VERSION   namespace OpenSubdiv ------------------------------------------------------------------------------   Vertex container implementation.  struct Vertex   Minimal required interface ---------------------- Vertex    Vertex  Vertex const src   _position  0   src . _position  0  _position  1   src . _position  1  _position  2   src . _position  2   void Clear  void   0   _position  0   _position  1   _position  2   0.0f   void AddWithWeight  Vertex const src , float weight   _position  0   weight  src . _position  0  _position  1   weight  src . _position  1  _position  2   weight  src . _position  2    Public interface ------------------------------------ void SetPosition  float x , float y , float z   _position  0   x  _position  1   y  _position  2   z   const float  GetPosition  const  return _position   private  float _position  3   ------------------------------------------------------------------------------ int main  int , char    Converter conv  Far  TopologyRefiner  refiner  Far  TopologyRefinerFactory Converter  Create  conv , Far  TopologyRefinerFactory Converter  Options  conv . GetType , conv . GetOptions  int maxlevel  5   Uniformly refine the topolgy up to maxlevel refiner - RefineUniform  Far  TopologyRefiner  UniformOptions  maxlevel   Allocate a buffer for vertex primvar data. The buffer length is set to  be the sum of all children vertices up to the highest level of refinement. std  vector Vertex vbuffer  refiner - GetNumVerticesTotal  Vertex  verts  vbuffer  0   Initialize coarse mesh positions int nCoarseVerts  g_nverts  for  int i  0  i nCoarseVerts   i   verts  i . SetPosition  g_verts  i  0 , g_verts  i  1 , g_verts  i  2    Interpolate vertex primvar data Far  PrimvarRefiner primvarRefiner   refiner  Vertex  src  verts  for  int level  1  level  maxlevel   level   Vertex  dst  src  refiner - GetLevel  level - 1 . GetNumVertices  primvarRefiner . Interpolate  level , src , dst  src  dst     Output OBJ of the highest level refined ----------- Far  TopologyLevel const refLastLevel  refiner - GetLevel  maxlevel  int nverts  refLastLevel . GetNumVertices  int nfaces  refLastLevel . GetNumFaces   Print vertex positions int firstOfLastVerts  refiner - GetNumVerticesTotal  - nverts  for  int vert  0  vert nverts   vert   float const  pos  verts  firstOfLastVerts  vert . GetPosition  printf  v f f f n , pos  0 , pos  1 , pos  2    Print faces for  int face  0  face nfaces   face   Far  ConstIndexArray fverts  refLastLevel . GetFaceVertices  face   all refined Catmark faces should be quads assert  fverts . size   4  printf  f  for  int vert  0  vert fverts . size   vert   printf  d , fverts  vert   1   OBJ uses 1-based arrays...  printf  n     ------------------------------------------------------------------------------ Generated on 2016-06-13 0021 UTC. User Docs API Docs Release Notes Forum", "tags": "", "loc":"far_tutorial_1.html"}, 
{"title":"Tutorials", "text":"Tutorials Tutorials 3.0.2 User Docs API Docs Release Notes Forum Github OSD_ARTICLE_TITLE The tutorial source code can be found in the github.com repository or in your local repository root turorials . Far Tutorials Tutorial 0 This tutorial presents in a very succinct way the requisite steps to instantiate a Far mesh from simple topological data. code Tutorial 1 This tutorial shows how to interface a high-level topology representation with Far for better efficiency. In tutorial 0, we showed how to instantiate topology from a simple face-vertex list. Here we will show how to take advantage of more complex data structures. code Tutorial 2 Building on tutorial 0, this example shows how to instantiate a simple mesh, refine it uniformly and then interpolate both vertex and varying primvar data. code Tutorial 3 Building on tutorial 0, this example shows how to instantiate a simple mesh, refine it uniformly and then interpolate both vertex and face-varying primvar data. The resulting interpolated data is output as an obj file, with the face-varying data recorded in the uv texture layout. code Tutorial 4 This tutorial shows how to create and manipulate FarStencilTable. We use the factorized stencils to interpolate vertex primvar data buffers. code Tutorial 5 This tutorial shows how to create and manipulate both vertex and varying FarStencilTable to interpolate 2 primvar data buffers vertex positions and vertex colors. code Tutorial 6 This tutorial shows how to interpolate surface limits at arbitrary parametric locations using feature adaptive FarPatchTable. code Tutorial 7 This tutorial shows how to create and manipulate tables of cascading stencils to apply hierarchical vertex edits. code Osd Tutorials Tutorial 0 This tutorial demonstrates the manipulation of Osd Evaluator and BufferDescriptor. code Hbr Tutorials Tutorial 0 This tutorial presents, in a very succinct way, the requisite steps to instantiate an Hbr mesh from simple topological data. code Tutorial 1 This tutorial shows how to safely create Hbr meshes from arbitrary topology. Because Hbr is a half-edge data structure, it cannot represent non-manifold topology. Ensuring that the geometry used is manifold is a requirement to use Hbr safely. This tutorial presents some simple tests to detect inappropriate topology. code Tutorial 2 This tutorial shows how to subdivide uniformly a simple Hbr mesh. We are building upon previous tutorials and assuming a fully instantiated mesh we start with an HbrMesh pointer initialized from the same pyramid shape used in hbr_tutorial_0. We then apply the Refine function sequentially to all the faces in the mesh to generate several levels of uniform subdivision. The resulting data is then dumped to the terminal in Wavefront OBJ format for inspection. code Generated on 2016-06-13 0020 UTC. User Docs API Docs Release Notes Forum", "tags": "", "loc":"tutorials.html"}, 
{"title":"glViewer", "text":"glViewer glViewer 3.0.2 User Docs API Docs Release Notes Forum Github OSD_ARTICLE_TITLE SYNOPSIS DESCRIPTION OPTIONS SEE ALSO SYNOPSIS glViewer  -d isolation level   -c animation loops   -f   -axis  objfiles DESCRIPTION glViewer is a stand-alone application that showcases the application of uniform and feature adaptive subdivision schemes to a collection of geometric shapes. Multiple controls are available to experiment with the algorithms. OPTIONS -d isolation level Select the desired isolation level of adaptive feature isolation. This can be useful when trying to load large pieces of geometry. -c animation frequency Number of repetitions of the animation loop default0 is infinite -f Launches the application in full-screen mode if is supported by GLFW on the OS -axis Swap Y-up  Z-up axis when loading obj files objfiles A sequence of obj files used as an animation loop the topology has to match the data contained in all the ptex files  SEE ALSO Other examples  glViewer , glShareTopology , glStencilViewer , glPtexViewer , glEvalLimit , glFVarViewer , dxViewer , dxPtexViewer , mayaPolySmooth , Generated on 2016-06-13 0020 UTC. User Docs API Docs Release Notes Forum", "tags": "", "loc":"glviewer.html"}, 
{"title":"Modeling Tips", "text":"Modeling Tips Modeling Tips 3.0.2 User Docs API Docs Release Notes Forum Github OSD_ARTICLE_TITLE Topology Use Fewer Spans Avoid High Valence vertices Edge-Loop Transitions Practical Topology Primer Triangles and N-Gons Semi-Sharp Creases Use crease sets Additional Resources The following sections describe common techniques specific to modeling with subdivision surfaces. Note The following information contains techniques specific to the Catmull-Clark subdivision scheme. Some elements need to be adjusted for Loop surfaces. Topology Well-constructed subdivision meshes have several important properties They consist primarily of quad faces They contain few extraordinary vertices They efficiently describe the intended shape They are topologically manifold Use Fewer Spans While polygon models need to use a large number of spans to approximate smooth curved surfaces, subdivision models require significantly fewer control points. In most situations, 6 spans are enough to create accurate circular shapes, and 4 is often enough to approximate background objects. Avoid High Valence vertices A high valence vertex is a vertex connected to more than 4 adjacent edges. High valence vertices cause several problems when subdivided The Catmull-Clark scheme can produce wavy surfaces when a revolution vertex is surrounded by triangles see here  High valence vertices incur fairly large performance hits Currently, OpenSubdiv has a hard constraint imposed by GPU shaders on the maximum valence of a vertex 27 on current hardware Instead, here are some topological strategies to cap revolution shapes Note that all these cylinders use only quad faces, and all the vertices in the caps have a valence of 4 except the bottom left example Edge-Loop Transitions It is often necessary to vary the density of control vertices over the surface mesh areas around the fingers of a hand require more CVs than the comparatively simpler region around the palm. It is important to handle the topology around these transitions efficiently. One strategy is to use extraordinary vertices, such as this example, using a valence 5 vertex to expand 3 edge loops into 5. Practical Topology Primer Some real-world examples showing how to produce detailed shapes with sparse topology, few extraordinary vertices, and no high-valence revolution poles. Triangles and N-Gons Used sparsely, non-quads can be very useful to gather 3 or more diverging edge-loops. These are often encountered in highly deforming areas with curvature saddle-points ex arm-torso connection. The strategic placement of a pentagon in one of these critical spots ensures that the surface remains smooth, while allowing for complex topology to flow around. Semi-Sharp Creases Semi-sharp creases can be a very powerful tool for hard-surface modeling. Both edges and vertices can be tagged with a sharpness value. Crease sharpness values range from 0 smooth to 10 infinitely sharp It is generally cheaper to use creases whenever possible, instead of adding extra edgesedge-loops. However... Creases introduce extra computation costs that are proportional to the sharpness value. So... Sharpness values above 5 should rarely be needed. The following sections introduce some techniques to best leverage them. Use crease sets Complex hard-surface models giant robots, vehicles, buildings... are likely to tag large number of edges  it is extremely useful to organize these edgesedge loops into logical sets with descriptive names. Edges or vertices in a crease set group all share the same sharpness value. If you are modeling with Maya, the CreaseSetEditor implements this type of workflow. Additionally, for debugging purposes, it is often very helpful if the name of a set contains the sharpness value ex topDeck_2. Besides authoring convenience, one of the benefits of having many edge-loops share identical sharpness values is that it enables very powerful performance optimizations within the feature adaptive algorithm faster renders less memory. Additional Resources An excellent short tutorial from the Guerrilla CG Project that illustrates many of the common pitfalls of subdivision modeling, and the strategies to overcome them Ivo Kos, Modelling Technical Director at Pixar Animation Studios, shows some of the modeling techniques he uses when modeling props and architecture sets for feature films. Generated on 2016-06-13 0020 UTC. User Docs API Docs Release Notes Forum", "tags": "", "loc":"mod_notes.html"}, 
{"title":"OSD Overview", "text":"OSD Overview OSD Overview 3.0.2 User Docs API Docs Release Notes Forum Github OSD_ARTICLE_TITLE OpenSubdiv Osd Refinement Limit Stencil Evaluation Limit Evaluation with PatchTable OpenGLDX11 Drawing with Hardware Tessellation InterleavedBatched Buffer Configuration Cross-Platform Implementation OpenSubdiv Osd Osd contains device dependent code that makes Far structures available on various backends such as TBB, CUDA, OpenCL, GLSL, etc. The main roles of Osd are Refinement Compute stencil-based uniformadaptive subdivision on CPUGPU backends Limit Stencil Evaluation Compute limit surfaces by limit stencils on CPUGPU backends Limit Evaluation with PatchTable Compute limit surfaces by patch evaluation on CPUGPU backends OpenGLDX11 Drawing with hardware tessellation Provide GLSLHLSL tessellation functions for patch table InterleavedBatched buffer configuration Provide consistent buffer descriptor to deal with arbitrary buffer layout. Cross-Platform Implementation Provide convenient classes to interop between compute and draw APIs These are independently used by clients. For example, a client can use only the limit stencil evaluation, or a client can refine subdivision surfaces and draw them with the PatchTable and Osd tessellation shaders. All device specific evaluation kernels are implemented in the Evaluator classes. Since Evaluators dont own vertex buffers, clients should provide their own buffers as a source and destination. There are some interop classes defined in Osd for convenience. OpenSubdiv utilizes a series of regression tests to compare and enforce identical results across different computational devices. Refinement Osd supports both uniform subdivision and adaptive subdivision . Once clients create a FarStencilTable for the topology, they can convert it into device-specific stencil tables if necessary. The following table shows which evaluator classes and stencil table interfaces can be used together. Note that while Osd provides these stencil table classes which can be easily constructed from FarStencilTable, clients arent required to use these table classes. Clients may have their own entities as a stencil tables as long as EvaluatorEvalStencils can access the necessary interfaces. Backend Evaluator class compatible stencil table CPU CPU single-threaded CpuEvaluator FarStencilTable TBB CPU multi-threaded TbbEvaluator FarStencilTable OpenMP CPU multi-threaded OmpEvaluator FarStencilTable CUDA GPU CudaEvaluator CudaStencilTable OpenCL CPUGPU CLEvaluator CLStencilTable GL ComputeShader GPU GLComputeEvaluator GLStencilTableSSBO GL Transform Feedback GPU GLXFBEvaluator GLStencilTableTBO DX11 ComputeShader GPU D3D11ComputeEvaluator D3D11StencilTable Limit Stencil Evaluation Limit stencil evaluation is quite similar to refinement in Osd . At first clients create FarLimitStencilTable for the locations to evaluate the limit surfaces, then convert it into an evaluator compatible stencil table and call EvaluatorEvalStencils. Limit Evaluation with PatchTable Another way to evaluate the limit surfaces is to use the PatchTable. Once all control vertices and local points are resolved by the stencil evaluation, Osd can evaluate the limit surfaces through the PatchTable. Backend Evaluator class compatible patch table CPU CPU single-threaded CpuEvaluator CpuPatchTable TBB CPU multi-threaded TbbEvaluator CpuPatchTable OpenMP CPU multi-threaded OmpEvaluator CpuPatchTable CUDA GPU CudaEvaluator CudaPatchTable OpenCL CPUGPU CLEvaluator CLPatchTable GL ComputeShader GPU GLComputeEvaluator GLPatchTable GL Transform Feedback GPU GLXFBEvaluator GLPatchTable DX11 ComputeShader GPU D3D11ComputeEvaluator not yet supported D3D11PatchTable Release Notes 3.0.0 GPU limit evaluation backends EvaluatorEvalPatches only support BSpline patches. Clients need to specify BSpline approximation for endcap when creating a patch table. See end capping . OpenGLDX11 Drawing with Hardware Tessellation One of the most interesting use cases of the Osd layer is realtime drawing of subdivision surfaces using hardware tessellation. This is somewhat similar to limit evaluation with PatchTable described above. Drawing differs from limit evaluation in that Osd provides shader snippets for patch evaluation and clients will inject them into their own shader source. See shader interface for a more detailed discussion of the shader interface. InterleavedBatched Buffer Configuration All Osd layer APIs assume that each primitive variables to be computed points, colors, uvs ... are contiguous arrays of 32bit floating point values. The Osd API refers to such an array as a buffer . A buffer can exist on CPU memory or GPU memory. Osd Evaluators typically take one source buffer and one destination buffer, or three destination buffers if derivatives are being computed. Osd Evaluators also take BufferDescriptors, that are used to specify the layout of the source and destination buffers. A BufferDescriptor is a struct of 3 integers which specify an offset, length and stride. For example Vertex 0 Vertex 1 ... X Y Z X Y Z ... The layout of this buffer can be described as Osd  BufferDescriptor desc  offset   0 , length   3 , stride   3  BufferDescriptor can be used for an interleaved buffer too. Vertex 0 Vertex 1 ... X Y Z R G B A X Y Z R G B A ... Osd  BufferDescriptor xyzDesc  0 , 3 , 7  Osd  BufferDescriptor rgbaDesc  3 , 4 , 7  Although the source and destination buffers dont need to be the same buffer for EvalStencils, adaptive patch tables are constructed to first index the coarse vertices and the refined vertices immediately afterward. In this case, the BufferDescriptor for the destination should include the offset as the number of coarse vertices to be skipped. Coarse vertices n  Src Refined vertices  Dst Vertex 0 Vertex 1 ... Vertex n Vertex n1 X Y Z X Y Z ... X Y Z X Y Z ... Osd  BufferDescriptor srcDesc  0 , 3 , 3  Osd  BufferDescriptor dstDesc  n  3 , 3 , 3  Also note that the source descriptor doesnt have to start with offset  0. This is useful when a client has a big buffer with multiple objects batched together. Cross-Platform Implementation One of the key goals of OpenSubdiv is to achieve as much cross-platform flexibility as possible and leverage all optimized hardware paths where available. This can be very challenging as there is a very large variety of plaftorms and APIs available, with very distinct capabilities. In Osd , Evaluators dont care about interops between those APIs. All Evaluators have two kinds of APIs for both EvalStencils and EvalPatches. Explicit signatures which directly take device-specific buffer representation e.g., pointer for CpuEvaluator, GLuint buffer for GLComputeEvaluator, etc. Generic signatures which take arbitrary buffer classes. The buffer class is required to have a certain method to return the device-specific buffer representation. The later interface is useful if the client supports multiple backends at the same time. The methods that need to be implemented for the Evaluators are Evaluator class object method CpuEvaluator TbbEvaluator OmpEvaluator pointer to cpu memory BindCpuBuffer CudaEvaluator pointer to cuda memory BindCudaBuffer CLEvaluator cl_mem BindCLBuffer GLComputeEvaluator GLXFBEvaluator GL buffer object BindVBO D3D11ComputeEvaluator D3D11 UAV BindD3D11UAV The buffers can use these methods as a trigger of interop. Osd provides a default implementation of interop buffer for most of the backend combinations. For example, if the client wants to use CUDA as a computation backend and use OpenGL as the drawing API, OsdCudaGLVertexBuffer fits the case since it implements BindCudaBuffer and BindVBO. Again, clients can implement their own buffer class and pass it to the Evaluators. Generated on 2016-06-13 0020 UTC. User Docs API Docs Release Notes Forum", "tags": "", "loc":"osd_overview.html"}, 
{"title":"License", "text":"License License 3.0.2 User Docs API Docs Release Notes Forum Github OSD_ARTICLE_TITLE Open Source License OpenSubdiv is covered by a modified Apache 2.0 license included below, and is free to use for commercial or non-commercial use. All Pixar patents in the area of subdivision surface algorithms have also been released for public use. We welcome any involvement in the development or extension of this code in fact, we would love it. Please contact us if you are interested. For information on Apache licenses, see httpwww.apache.orglicenses The following license text describes the open source policy adopted by Pixar and is included in every source file. Copyright 2013 Pixar Licensed under the Apache License, Version 2.0 the Apache License  with the following modification you may not use this file except in compliance with the Apache License and the following modification to it Section 6. Trademarks. is deleted and replaced with 6. Trademarks. This License does not grant permission to use the trade names, trademarks, service marks, or product names of the Licensor and its affiliates, except as required to comply with Section 4c of the License and to reproduce the content of the NOTICE file. You may obtain a copy of the Apache License at httpwww.apache.orglicensesLICENSE-2.0 Unless required by applicable law or agreed to in writing, software distributed under the Apache License with the above modification is distributed on an AS IS BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the Apache License for the specific language governing permissions and limitations under the Apache License. Generated on 2016-06-13 0020 UTC. User Docs API Docs Release Notes Forum", "tags": "", "loc":"license.html"}, 
{"title":"Additional Resources", "text":"Additional Resources Additional Resources 3.0.2 User Docs API Docs Release Notes Forum Github OSD_ARTICLE_TITLE Links Videos Feature Adaptive GPU Rendering of Catmull-Clark Subdivision Surfaces 2012 Open Subdivision Technology Review 2012 Autodesk User Group At Anaheim 2013 Why Model with Subdivisions 2013 Meet the Experts The OpenSubdiv Project 2013 Links OpenSubdiv Github Repository OpenSubdiv with Mudbox and Maya Videos Feature Adaptive GPU Rendering of Catmull-Clark Subdivision Surfaces 2012 Open Subdivision Technology Review 2012 First public demonstration of OpenSubdiv at Siggraph 2012. Autodesk User Group At Anaheim 2013 Bill Polson, Director of Industry Strategy at Pixar Animation Studios Why Model with Subdivisions 2013 Ivo Kos, Modelling Technical Director at Pixar Animation Studios Meet the Experts The OpenSubdiv Project 2013 Join special guests, Bill Polson, Dirk Van Gelder, Manuel Kraemer, Takahito Tejima, David G. Yu and Dale Ruffolo, from Pixar Animation Studios GPU team, as they show how real time display of subdivision surfaces helps artists be more productive, and how this code is open source and engineered for ease of integration. Generated on 2016-06-13 0020 UTC. User Docs API Docs Release Notes Forum", "tags": "", "loc":"additional_resources.html"}, 
{"title":"API Overview", "text":"API Overview API Overview 3.0.2 User Docs API Docs Release Notes Forum Github OSD_ARTICLE_TITLE API Layers Using the Right Tools Use case 1 Simple refinement Use case 2 GL adaptive tessellation drawing of animating mesh Tutorials and Examples API Layers OpenSubdiv is structured as a set of layered libraries. This structure facilitates operation on a variety of computing resources, and allows developers to only opt-in to the layers and feature sets that they require. From a top-down point of view, OpenSubdiv is comprised of several layers, some public, and some private. Layers list Sdc Subdivision Core Sdc Overview The lowest level layer, implements the core subdivision details to facilitate the generation of consistent results. Most cases will only require the use of simple public types and constants from Sdc. Vtr Vectorized Topological Representation Vtr Overview A suite of classes to provide an intermediate representation of topology that supports efficient refinement. Vtr is intended for internal use only. Far Feature Adaptive Representation Far Overview The central interface that processes client-supplied geometry and turns it into a serialized data representation ready for parallel processing in Osd . Far also provides a fully-featured single-threaded implementation of subdivision interpolation algorithms. Osd OpenSubdiv cross platform Osd Overview A suite of classes to provide parallel subdivision kernels and drawing utilities on a variety of platforms such as TBB, CUDA, OpenCL, GLSL and DirectX. Client mesh data enters the API through the Far layer. Typically, results will be collected from the Osd layer. However, it is possible to use functionality from Far without introducing any dependency on Osd. Although there are several entry-points to provide topology and primitive variable data to OpenSubdiv, eventually everything must pass through the private Vtr and Sdc representations for topological analysis. Using the Right Tools OpenSubdivs tiered interface offers a lot flexibility to make your application both fast and robust. Because navigating through the large collection of classes and features can be challenging, here are use cases that should help sketch the broad lines of going about using subdivisions in your application. General client application requirements Surface Limit For some applications, a polygonal approximation of the smooth surface is enough. Others require C 2 continuous differentiable bi-cubic patches ex deformable displacement mapping, smooth normals and semi-sharp creases... Deforming Surface Applications such as off-line image renderers often process a single frame at a time. Others, such as interactive games need to evaluate deforming character surface every frame. Because we can amortize many computations if the topology of the mesh does not change, OpenSubdiv provides stencil tables in order to leverage subdivision refinement into a pre-computation step. Multi-threading OpenSubdiv also provides dedicated interfaces to leverage parallelism on a wide variety of platforms and API standards, including both CPUs and GPUs. GPU Draw If the application requires interactive drawing on screen, OpenSubdiv provides several back-end implementations, including D3D11 and OpenGL. These back-ends provide full support for programmable shading. Use case 1 Simple refinement The following example shows the most simple case to get your mesh refined uniformly. Define a class for the primvar you want to refine. Its required to have Clear and AddWithWeight functions. struct Vertex  void Clear   x  y  z  0   void AddWithWeight  Vertex const src , float weight   x  weight  src . x  y  weight  src . y  z  weight  src . z   float x , y , z   2. Instantiate a FarTopologyRefiner from the FarTopologyDescriptor . Far  TopologyDescriptor desc  desc . numVertices  the number of vertices desc . numFaces  the number of faces desc . numVertsPerFace  array of the number of verts per face desc . vertIndicesPerFace  array of vert indices Far  TopologyRefiner  refiner  Far  TopologyRefinerFactory Descriptor  Create  desc  Call RefineUniform to refine the topology up to maxlevel. refiner - RefineUniform  Far  TopologyRefiner  UniformOptions  maxlevel  4. Interpolate vertex primvar data at level using FarPrimvarRefiner Far  PrimvarRefiner primvarRefiner   refiner  Vertex const  src  coarse vertices Vertex  dst  refined vertices primvarRefiner . Interpolate  level , src , dst  The topology at the refined level can be obtained from FarTopologyLevel Far  TopologyLevel const refLastLevel  refiner - GetLevel  maxlevel  int nverts  refLastLevel . GetNumVertices  int nfaces  refLastLevel . GetNumFaces  for  int face  0  face nfaces   face   Far  ConstIndexArray fverts  refLastLevel . GetFaceVertices  face   do something with dst and fverts  Done See far_tutorial_0 for the complete code example. Use case 2 GL adaptive tessellation drawing of animating mesh The next example is showing how to draw adaptive tessellated patches in GL using OpenSubdiv. The osd layer helps you to interact with GL and other device specific APIs. Also for an efficient refinement of animating mesh on a static topology, we create a stencil table to refine the positions changing over time. The following example code uses an OsdGLMesh utility class which composites a stencil table, patch table, vertex buffer and evaluator in osd layer. You can also use those classes independently. 1. Instantiate a FarTopologyRefiner from the FarTopologyDescriptor , same as usecase 1. Setup OsdMesh. In this example we use b-spline endcap. int numVertexElements  3   x, y, z Osd  MeshBitset bits  bits . set  Osd  MeshAdaptive , true   set adaptive bits . set  Osd  MeshEndCapBSplineBasis , true   use b-spline basis patch for endcap. Osd  GLMeshInterface  mesh  new Osd  Mesh Osd  CpuGLVertexBuffer , Far  StencilTable , Osd  CpuEvaluator , Osd  GLPatchTable  refiner , numVertexElements , 0 , level , bits  3. Update coarse vertices and refine OsdMeshRefine calls OsdCpuEvaluatorEvalStencils  mesh - UpdateVertexBuffer  vertex  0 , 0 , nverts  mesh - Refine  Bind index buffer, PatchParamBuffer and vertex buffer  index buffer glBindBuffer  GL_ELEMENT_ARRAY_BUFFER , mesh - GetPatchTable  - GetPatchIndexBuffer   vertex buffer glBindBuffer  GL_ARRAY_BUFFER , mesh - BindVertexBuffer  glEnableVertexAttribArray  0  glVertexAttribPointer  0 , numVertexElements , GL_FLOAT , GL_FALSE , numVertexElements  sizeof  float , 0   patch param buffer glActiveTexture  GL_TEXTURE0  glBindTexture  GL_TEXTURE_BUFFER , mesh - GetPatchTable  - GetPatchParamTextureBuffer  Draw. Since we use b-spline endcaps in this example, there is only one PatchArray in the patch table. You may need to iterate patch arrays as you use other type of endcap. To configure GLSL program for each patch type, see osd shader interface for more details. Osd  PatchArray const patch  mesh - GetPatchTable  - GetPatchArrays  0  Far  PatchDescriptor desc  patch . GetDescriptor  int numVertsPerPatch  desc . GetNumControlVertices   16 for B-spline patches glUseProgram  BSplinePatchProgram  glPatchParameteri  GL_PATCH_VERTICES , numVertsPerPatch  glDrawElements  GL_PATCHES , patch . GetNumPatches   numVertsPerPatch , GL_UNSIGNED_INT , 0  As the mesh animates, repeat from step 3 to update positions, refine, and draw. See glViewer and other examples for more complete usage. Tutorials and Examples For more use cases, please see Tutorials and Examples Generated on 2016-06-13 0020 UTC. User Docs API Docs Release Notes Forum", "tags": "", "loc":"api_overview.html"}, 
{"title":"Release Notes", "text":"Release Notes Release Notes 3.0.2 User Docs API Docs Release Notes Forum Github OSD_ARTICLE_TITLE Release 2.6.0 Release 2.5.1 Release 2.5.0 Release 2.4.1 Release 2.4.0 Release 2.3.5 Release 2.3.4 Release 2.3.3 Release 2.3.2 Release 2.3.1 Release 2.3.0 Release 2.2.0 Release 2.1.0 Release 2.0.1 Release 2.0.0 Release 1.2.4 Release 1.2.3 Release 1.2.2 Release 1.2.1 Release 1.2.0 Release 1.1.0 Release 1.0.0 Release 2.6.0 New Features Add subdivision kernels for ARM NEON Add OsdUtilVertexSplit which creates a vertex-varying data table by duplicating vertices in a FarMesh Add basic functions to work with FV data via evaluator API Changes Added Catmark restricted vertex compute kernels that optimize for vertices with no semi-sharp creases Fix accessor omissions in osdmesh.h Add support for different subdivision schemes for OsdUtilMesh Bug Fixes Fix crashes when using rather low-end cards like Intel ones Fix a bug in the creation of an edge-vertex kernel batch Fix mismatch in declaration and usage of OsdCudaComputeRestrictedVertexA Fix a bug in the vertex order for restricted Catmark vertex-vertex kernel batches Fix a bug in FarCatmarkSubdivisionTablesFactory that prevented the CATMARK_QUAD_FACE_VERTEX kernel from being selected for subdivision level 2 or greater. Fix a bug in OsdUtilVertexSplit that occurs when getting the address of the end of a stdvector Fix error in createCLBuffer that occurs when the buffer size is zero Fix a bug in the CUDA computeRestrictedEdge kernel Fix duplicate variables with identical name Fix osdutil build errors Fix cmake diagnostic messsage Release 2.5.1 New Features Add CATMARK_QUAD_FACE_VERTEX and CATMARK_TRI_QUAD_FACE_VERTEX compute kernels optimization that takes advantage of all-quads or all-triange-and-quads meshes Bug Fixes Fix a compiler error in the GLSL Transform Feedback kernels on OS X Fix boundary interpolation in osdutil Fix bilinear stencil tangent computions Release 2.5.0 New Features Add ability to generate triangle patches for a uniformly subdivided mesh Add new example topologySharing Add interleaved buffer mode in glViewer Add GLSL compute kernel to glBatchViewer Add TBB compute kernel to glBatchViewer Add a PullDown widget to our HUD in examplescommon GUI updates cosmetic changes to GL example code Adding a programmable image shader to gl_hud Code cleanup for GLFrameBuffer in examplescommon Implement C-API accessor to evaluator topology osdutil Add command line option to CMakes options Add a CMake option to disable OpenCL Add a FindCLEW.cmake module in anticipation of using CLEW as a dependency Integrate CLEW into osd library and examples Changes Change interleaved buffer support in OsdCompute Removed OsdVertexDescriptor and replaced with OsdVertexBufferDescriptor Reorganize ComputeContext and ComputeController. Reorganize EvalStencilContext and EvalStencilController Moved transient states current vertex buffer etc to controller Reorganize EvalLimitContext and EvalLimitController Moved transient states current vertex buffer etc to controller Fix adaptive isolation of sharp corner vertices Fix incorrect FarMeshFactory logic for isolating multiple corner vertices in corner patches Change EvalLimit Gregory patch kernels to the large weights table to accomodate higher valences Fix calculation of screen space LOD tess factors for transition corner patches. Add a public constructor to OsdMesh Decrease compiler warning thresholds and fix outstanding warnings Make PTex support optional Add a NO_MAYA flag to CMakeLists to disable all Autodesk Maya dependencies in the build Document NO_MAYA command line option Bug Fixes Fix mistakenly deleted memory barrier in glsl OsdCompute kernel. Fix shape_utils genRIB function to use streams correctly. Temporary workaround for the synchronization bug of glsl compute kernel Fix Hud display for higher DPI MBP retina Fix Hud d3d11 Fix examples to use GL timer query to measure the GPU draw timing more precisely Fix glViewer stop updating during freeze. Fix file permissions on farPatchTablesFactory.h Fix some meory leaks in adaptive evaluator osdutil Fix OsdUtilAdaptiveEvaluator concurrency issue Fix OsdUtilRefiner incorrect Invalid size of patch array error reporting. Fix OsdUtilPatchPartitioner failure for triangle patches Fixes a bug that causes OsdUtilPatchPartitioner to fail to rebuild the face-varying data table correctly for triangle patches. Add missing third parameter to templated OsdDrawContext usage osdutilbatch.h Return success status from openSubdiv_finishEvaluatorDescr osdutil Remove debugging stdcout calls osdutil Build errors warnings Fix OSX Core Profile build GLFrameBuffer Fix ptexViewer build error on OSX Fix framebuffer shader compiling for OSX Reordering includes to address a compile error on OSXglew environment Fix compilation errors with CLEW enabled Fix icc build problems Fix compiler warnings in OsdClVertexBuffer Fix compilation error on windowsmsvc2013 Fix build warningserrors with VS2010 Pro Fix Windows build warning in FarPatchTablesFactory Fix doxygen generation errors Release 2.4.1 Changes Add correct OpenSubdiv namespace beginend blocks. Bug Fixes Compile osdutil with -fPIC for correct linking. Fix a bug of OsdUtilMeshBatch, the varying buffer isnt computed with CL kernels Fix FindGLFW.cmake to use the GLFW_LOCATION environment variable in Windows Fix Draw contexts do not fully initialize patch arrays Release 2.4.0 New Features Adding functionality to store uniform face-varying data across multiple levels of subdivision Add OsdUtilPatchPartitioner. It splits patcharray into subsets so that clients can draw partial surfaces for both adaptive and uniform. Changes Remove FarMesh dependency from OsdContext. Use DSA APIs for GL buffer update if available. Refactor Far API replace void- of all kernel applications with CONTEXT template parameter. It eliminates many static_casts from void- for both far and osd classes. move the big switch-cases of far default kernel launches out of Refine so that osd controllers can arbitrary mix default kernels and custom kernels. change FarKernelBatchkernelType from enum to int, clients can add custom kernel types. remove a back-pointer to farmesh from subdivision table. untemplate all subdivision table classes and template their compute methods instead. Those methods take a typed vertex storage. remove an unused argument FarMesh from the constructor of subdivision table factories. Refactor FarSubdivisionTables. Delete scheme specialized subdivision tables. The base class FarSubdivisionTables already has all tables, so we just need scheme enum to identify which scheme the subdivision tables belong to. This brings a lot of code cleanups around far factory classes. Move FarMultiMeshFactory to OsdUtil. Move table splicing functions of FarMultiMeshFactory into factories Change PxOsdUtil prefix to final OsdUtil prefix. Improve error reporting in osdutil refinement classes, and fix a build issue Bug Fixes Fix another multi mesh splicing bug of face varying data. Make CMake path variables more robust Fixing a crash on Marvericks wglew Update dxViewer example documentation Fix wrong logic in openSubdiv_setEvaluatorCoarsePositions Remove debug print from adaptive evaluators initialization Release 2.3.5 New Features Add the ability to read obj files to the dxViewer example Add screen-capture function to ptexViewer Update documention for Xcode builds Add documentation boundary interpolation rules and face-varying boundary interpolation rules Changes Refactoring FarPatchTables and FarPatchTablesFactory Move GL vertex buffer VBO buffer allocation out of allocate and into BindVBO Enable uvViewer on OS X now that Mavericks is released. Replacing un-necessary dynamic_cast with reinterpret_cast within FarDispatcher Minor code cleanup of FarMeshFactory Remove address space qualifiers from OpenCL kernel functions Fix OpenCL initialization to be slightly more robust Add OpenCL header include paths where necessary Add static specifiers for non-kernel CL funcs at program scope Add stddef.h to pythonosdosdshim.i Modify ptexViewer and uvViewer shaders to address some portability issues Bug Fixes Fix Gregory Boundary patch buffer overrun Fix black texels when the resolution of a ptex face is less than 4 Fix a splicing bug in FarMultiMeshFactory Fix a build error when using older versions of GLFW Fix build warnings optimized Fix FindTBB.cmake Fix FindMaya.cmake Fix glViewer support for GLSL compute Fix ptexViewer enable specular pass in both IBL and point lighting Fix Zlib include in ptexViewer Fix ptexViewer shader errors. Fix osdPolySmooth Maya plugin Fix UV merging in osdPolySmooth code example Add cleanup function to osdPolySmooth Maya plugin Fix Maya OsdPolySmooth node component output Fix GLSL array instantiation syntax for glStencilViewer Fix examples to run correctly on high DPI displays with GLFW 3 Release 2.3.4 New Features Adding CPUOMPTBB Context  Controller pairs for CPU evaluation of smooth normals Added adaptiveEvaluator class inspired by Sergeys work in blender OsdUtil Changes Changed the HUD to ignore mouse clicks when not visible. Updates for blender development OsdUtil Add C compatible API to access the adaptiveEvaluator class from non-C OsdUtil Update license headers to apache OsdUtil CMake build improvement  make osd a cmake object library remove compiling redundancies Improve stringification of shaders kernels in CMake build Bug Fixes Fixed iOS build Fixed VS2010 warningserrors. Fix OsdCpuEvalLimitKernel Fix maxvalence calculation in FarMeshFactory Fix FarStencilFactory control stencil caching Removing assert for high-valence vertices running off limit tangent pre-computed table. Fix degenerate stencil limit tangent code path. Fix unused variable build warnings gcc 4.8.2 - Fedora 19 Fix build warning from osdutiladaptiveEvaluator.cpp Release 2.3.3 Changes Modify Far remapping of singular vertices to point to their source vertex. Refactoring Ptex Mipmap and Analytic Displacement code Adding some documentation for Chaikin crease rule Misc. improvements to PxOsdUtilsMesh Adding recommended isolation output to OsdPolySmooth node Bug Fixes Adding an error check on version parsing of main CMakeLists Fix regex in FindMaya.cmake that breaks with recent versions of Maya Fix crashes induced by typeid Fixed VS2010 build warning Fix build break in hbr_regression Fix incorrect capitalization in GL ptexViewer shader.glsl Fix OSX build add stdlib.h include Release 2.3.2 New Features Adding control cage drawing to ptexViewer Adding Maya osdPolySmooth plugin into OpenSubdiv examples. Changes Removing some glGetError checks that are causing problems for Autodesk D3D11DrawRegistry returns the common shader config for all non-tess patcharrays. Updates to simple cpu osdutil classes Bug Fixes Fix Hbr Chaikin crease rule Fix Chaikin tag parsing Fix return value of allocate function for OsdCPUGLVertxBuffer Fixed GLSL shader portability. Fix FindGLFW.cmake for GLFW 3.03 on OSX Fixed compiler warnings. Fixed VS2010 build errors Fixed WIN32 build error when no DXSDK installed. Fix OSX build stdlib.h needs to be included in glPtexMipmapTexture.h Fix for crash in new meshrefiner code in OsdUtil Release 2.3.1 New Features Add DX11 version of ptex mipmap loader Add DX11 ptex viewer work in progress Add DX11 fractional partitioning, normal derivatives computation Add memory usage controls to Ptex loader Add face-varying boundary interpolation parsing to shape_utils Add simple HbrMesh and FarMesh wrapper classes to osdutil Changes Amend language of attribution file NOTICE.txt Optimize a bit of ptex mipmap lookup. Show ptex memory usage in GL and DX11 ptexViewers Improve ptex guttering Addding some video links to our collection of external resources Bug Fixes Fix edge-only face-varying interpolation Fix Far to handle disconnected vertices in an Hbr mesh Fixed ptex cache resource release sequence Fix build symbol conflict in Far Fix patch parambuffer generation in OsdD3D11DrawContext Fix a minor osdutil build warning seen with gcc 4.8.1 Fix VS2010 build errors Release 2.3.0 New Features Added Analytical displacement mapping Analytic Displacement Mapping using Hardware Tessellation Niessner and Loop TOG 2013 Added a new ptex mipmap loader Added face varying macros for loop subdivision Added the uvViewer example to see how face varying interpolation rule works Added a slider component and cleanup hud code. Changes Adding license attribution files, improved language of the code headers Install documentation into the Filesystem Hierarchy Standard location Set GLFW_OPENGL_FORWARD_COMPAT on Mac OS to make samples work on that platform Added surface normal mode mipmap to ptxViewer Bug Fixes Fix a bug of bad fvar splicing for loop surface. Fix incorrect bilinear limit tangents in FarStencilTablesFactory Fix boundary interpolation rules doc Added an error check on updating cuda buffer Fix face varying rendering on loop surface Fixed glBatchViewer build for GLFW 2.x Expand search paths for FindGLFW.cmake for Debian and other Linux architectures Fix CMake executable builds for ICC Fix bhr baseline regression, so reference files are real OBJs Fixed clKernelBundle.cpp to build on Android. Fix misc build warings Release 2.2.0 New Features Added subdivision stencil functionality Far OsdEval Bug Fixes Fix D3D11DrawContext to check for NULL pointers Fix cpuEvalLimitController crash bug Fixed search path suffixes for ICC libs Fixed invalid initialization of glslTransformFeedback kernel. Release 2.1.0 New Features Added TBB Compute back-end on Linux contribution from Sheng Fu Added support for ICC compiler still Beta Changes Added constructor to OsdMesh with a FarMesh  as input Modify CMake to name and sym-link DSOs based on Linux ABI versioning spec Added command line input to DX11 viewer FarMultiMesh can splice uniform and adaptive meshes together. Bug Fixes Fix FarMultiMesh splicing Removed unnecessary cudaThreadSynchronize calls. Fix glViewer overlapping HUD menus Fix facevarying rendering in glBatchViewer Fix build of GLSL transform feedback kernels Fix Getting Started documentation Release 2.0.1 New Features New CLA files to reflect Apache 2.0 licensing Changes Move all public headers to includeopensubdiv... Adding Osd documentation based on Siggraph slides Bug Fixes Fix incorrect transition pattern 3 in GLSL  HLSL shaders Fix CMake build to not link GPU-based libraries into libosdCPU Fix support for GLEW on OSX Fix GLFW Xrandr xf86vmode dependency paths for X11 based systems Fix HUD display overlaps in code examples Fix FindGLEW.cmake to be aware of multiarch on linux systems Fix some hard-coded include paths in CMake build Release 2.0.0 New Features New CMake build flags NO_LIB, NO_CUDA, NO_PYTHON Changes OpenSubdiv is now under Apache 2.0 license HbrHalfedge and HbrFVarData copy constructors are now private Documentation style matched to graphics.pixar.com  new content Add an animation freeze button to ptexViewer Variable name changes for better readability across all example shader code Bug Fixes Fix incorrect patch generation for patches with 2 non-consecutive boundary edges Fix undefined gl_PrimitiveID shader build errors Fix for shader macro OSD_DISPLACEMENT_CALLBACK Fix out-of-bounds stdvector access in FarPatchTablesFactory Release 1.2.4 New Features Adding support for fractional tessellation of patches Adding a much needed API documention system based on Docutils RST markup Adding support for face-varying interpolation in GLSL APIs Adding varying data buffers to OsdMesh Adding accessors to the vertex buffers in OsdGlMesh Adding face-varying data to regression shapes Changes Cleanup of common bicubic patch shader code GLSL  HLSL for portability ATI  OSX drivers Bug Fixes Fix FarVertexEditTablesFactory to insert properly vertex edit batches fixes incorrect hierarchical hole in regression shape Fix FarPatchMap quadtree to not drop top-level non-quad faces Fix Gregory patches bug with incorrect max-valence Fix FarPatchTablesGetNumFaces and FarPatchTablesGetFaceVertices functions to return the correct values Fix face indexing GLSL code ptex works on non-quads again Fix face-varying data splicing in FarMultiMeshFactory Fix ptex face indexing in FarMultiMeshFactory Fix glew include to not break builds Fix Clang  ICC build failures with FarPatchTables Fix build and example code to work with GFLW 3.0 Fix cmake to have ptex dynamically linked in OSX Release 1.2.3 New Features Adding Varying and Face-Varying data interpolation to EvalLimit Changes EvalLimit API refactor  the EvalContext now has dedicated structs to track all the vertex, varying and face-varying data streams. Also renamed some buffers into tables to maintain code consistency EvalLimit optimization  switch serial indexing to a quad-tree based search Bug Fixes Face-varying data bug fixes  making sure the data is carried around appropriately Fixes for OpenCL use with the new batching APIs GLSL general shader code cleanup fixes for better portability GLSL Tranform Feedback initialization fix Critical fix for FarMultiMesh batching indexing was incorrect Fix osdutil CL implementation protect includes on systems with no OpenCL SDK installed Fix face-varying interpolation on adaptive patches FarPatchTables  fix IsFeatureAdaptive to return the correct answer Fix Far factories to handle the absence of face-varying data correctly. Many GLSL shader code style fixes which should help with ATI  OSX shader compiling Release 1.2.2 New Features Introducing the EvalLimit API  the Eval module aims at providing support for computational tasks that are not related to drawing the surfaces. The EvalLimit sub-module provides an API that enables client code to evaluate primitive variables on the limit surface. Osd xxx ComputeController  minor optimization. Added early exit to Refine method to avoid unnecessary interop. Changes OsdGLDawContext  minor API change. Protecting some member variables and adding const accessors OsdError  minor API refactor, added Warning functions. Bug Fixes Fix Ptex bug  prevent corner texel guttering code to from going into infinite loops Adding the ability for a FarMeshFactory to construct patchTables starting from firstLevel in uniform subdivision mode Consolidating the color coding of bicubic patch types through all our our code examples this is used mostly as a debugging tool Fixing some MSVC build warnings Update to the outdated README.md Release 1.2.1 New Features Added CUDA runtime error checking Release 1.2.0 Changes Major Far refactor around patchTables to introduce the draw batching API Renaming osd_util to osdutil Bug Fixes Fix GLSL transform feedback initialization bug in ptexViewer Minor bug typo fixes Release 1.1.0 New Features release initiated because of the switch to Git Flow Release 1.0.0 Oringal release Generated on 2016-06-13 0020 UTC. User Docs API Docs Release Notes Forum", "tags": "", "loc":"release_notes_2x.html"}, 
{"title":"dxPtexViewer", "text":"dxPtexViewer dxPtexViewer 3.0.2 User Docs API Docs Release Notes Forum Github OSD_ARTICLE_TITLE SYNOPSIS DESCRIPTION OPTIONS Keyboard Controls SEE ALSO SYNOPSIS dxPtexViewer  -e environment map   -d HDR diffuse map   -s HDR specular map   -y   --disp displacement scale   -l isolation level  ptex color file ptex displacement file ptex occlusion file ptex specular file objfiles DESCRIPTION dxPtexViewer is a stand-alone application that showcases advanced HDR shading with color, displacement, occlusion and specular ptex maps. Multiple controls are available to experiment with the algorithms. Content under development.... OPTIONS -e environment map A low dynamic range spherical environment map used as a background. Ideally, a color-normalized version of the HDR light probe. -d HDR diffuse map An HDR file containing a diffuse environment map typically they are low resolution blurry hemispherical convolutions of the environment light probe. -s environment map An HDR file containing a specular environment map. --disp displacement scale A scalar multiplier for the shader displacement values. -y Swap Z-up geometry to Y-UP. -l isolation level Select the desired isolation level of adaptive feature isolation. This can be useful when trying to load large pieces of geometry. ptex color file A ptex file containing RGB channels read as material albedo color. ptex displacement file A single-channel ptex file preferrably float precision containing the displacement values. ptex occlusion file A single-channel ptex file preferrably 8 bits precision containing a pre-computed ambient occlusion signal. ptex specular file A single-channel ptex file preferrably 8 bits precision applied to modulate the specular reflectance of the material objfiles A sequence of obj files used as an animation loop the topology has to match the data contained in all the ptex files  Keyboard Controls q  quit esc  hide GUI f  fit frame -  increase  decrese tessellation rate SEE ALSO Other examples  glViewer , glShareTopology , glStencilViewer , glPtexViewer , glEvalLimit , glFVarViewer , dxViewer , dxPtexViewer , mayaPolySmooth , Generated on 2016-06-13 0020 UTC. User Docs API Docs Release Notes Forum", "tags": "", "loc":"dxptexviewer.html"}, 
{"title":"Using Hbr", "text":"Using Hbr Using Hbr 3.0.2 User Docs API Docs Release Notes Forum Github OSD_ARTICLE_TITLE Vertex Template API Creating a Mesh Instantiating an HbrMesh Creating Vertices Creating Faces Wrapping Things Up Boundary Interpolation Rules Adding Creases Vertex Creases Edge Creases Holes Hierarchical Edits Face-varying Data Instantiating the HbrMesh Setting the Face-Varying Data Retrieving the Face-Varying Data Valence Operators Managing Singular Vertices Note As of OpenSubdiv 3.0, all Hbr dependencies have been removed from the core APIs  Sdc , Vtr , Far , Osd . The legacy source code of Hbr is provided purely for regression and legacy purposes. If your code is currently depending on Hbr functionality, we recommend migrating to the newer APIs as we cannot guarantee that this code will be maintained in future releases. For more information see the 3.0 release notes Vertex Template API The Hbr API abstracts the vertex class through templating. Client-code is expected to provide a vertex class that implements the requisite interpolation functionality. Here is an example of a simple vertex class that accounts for 3D position, but does not support arbitrary variables or varying interpolation. struct Vertex  Vertex    Vertex  int i    Vertex  const Vertex src   _pos  0   src . _pos  0  _pos  1   src . _pos  1  _pos  2   src . _pos  2    Vertex     void AddWithWeight  const Vertex src , float weight , void   0   _pos  0   weight  src . _pos  0  _pos  1   weight  src . _pos  1  _pos  2   weight  src . _pos  2   void AddVaryingWithWeight  const Vertex , float , void   0    void Clear  void   0   _pos  0   _pos  1   _pos  2   0.0f   void SetPosition  float x , float y , float z   _pos  0   x  _pos  1   y  _pos  2   z   void ApplyVertexEdit  const OpenSubdiv  HbrVertexEdit Vertex edit   const float  src  edit . GetEdit  switch  edit . GetOperation   case OpenSubdiv  HbrHierarchicalEdit Vertex  Set  _pos  0   src  0  _pos  1   src  1  _pos  2   src  2  break  case OpenSubdiv  HbrHierarchicalEdit Vertex  Add  _pos  0   src  0  _pos  1   src  1  _pos  2   src  2  break  case OpenSubdiv  HbrHierarchicalEdit Vertex  Subtract  _pos  0  - src  0  _pos  1  - src  1  _pos  2  - src  2  break    void ApplyMovingVertexEdit  const OpenSubdiv  HbrMovingVertexEdit Vertex     custom functions data not required by Hbr ------------------------- Vertex  float x , float y , float z   _pos  0   x  _pos  1   y  _pos  2   z   const float  GetPos  const  return _pos   float _pos  3   In some cases, if only topological analysis is required, the class can be left un-implemented. Far and Osd for instance store vertex data in serialized interleaved vectors. Here is the OsdVertex class for reference class Vertex  public  Vertex   Vertex  int  index    Vertex  Vertex const  src    void AddWithWeight  Vertex const  i  , float  weight  , void   0   void AddVaryingWithWeight  const Vertex  i  , float  weight  , void   0   void Clear  void   0   void ApplyVertexEdit  FarVertexEdit const     Creating a Mesh The following tutorial walks through the steps of instantiating a simple Hbr mesh. The code found in regressioncommonshape_utils.h can also be used as an example. While this implementation covers many of Hbr s features, it does not provide coverage for the complete Renderman specification though. Instantiating an HbrMesh First we need to instantiate a mesh object. Hbr supports 3 subdivision schemes Catmull-Clark catmark Loop Bilinear The scheme is selected by passing an specialized instance of HbrSubdivision T , HbrCatmarkSubdivision T in this case. The scheme can be shared across multiple mesh objects, so we only need a single instance. static OpenSubdiv  HbrCatmarkSubdivision Vertex _scheme  OpenSubdiv  HbrMesh Vertex  mesh  new OpenSubdiv  HbrMesh Vertex  _scheme  Creating Vertices Adding vertices to the mesh is accomplished using the HbrMeshNewVertex method. Because Hbr uses a dedicated vertex allocator to help alleviate the performance impact of intensive fragmented memory allocations. This optimization results in the following design pattern Vertex vtx  for  int i  0  i numVerts  i    Vertex  v  mesh - NewVertex  i , vtx   v- SetPosition  We instantiate a single default vertex object named vtx on the stack. We then recover the pointer to the actual vertex created in the mesh from the NewVertex method. Once we have recovered that pointer, we can set the data for our vertex by using any of the custom accessors. Creating Faces Once all the vertices have been registered in the mesh, we can start adding the faces with HbrMeshNewFace . Assuming we had an obj style reader, we need to know the number of vertices in the face and the indices of these vertices. for  int f  0  f numFaces   f   int nverts  obj - GetNumVertices  f  const int  faceverts  obj - GetFaceVerts  f  mesh - NewFace  nv , fv , 0   However, currently Hbr is not able to handle non-manifold geometry. In order to avoid tripping asserts or causing memory violations, lets rewrite the previous loop with some some prototype code to check the validity of the topology. for  int f  0  f numFaces   f   int nv  obj - GetNumVertices  f  const int  fv  obj - GetFaceVerts  f   triangles only for Loop subdivision  if  scheme  kLoop  and  nv  3   printf  Trying to create a Loop subd with non-triangle face n  continue    now check the half-edges connectivity for  int j  0  j nv  j    OpenSubdiv  HbrVertex T  origin  mesh - GetVertex  fv  j   OpenSubdiv  HbrVertex T  destination  mesh - GetVertex  fv  j  1   nv   OpenSubdiv  HbrHalfedge T  opposite  destination - GetEdge  origin  if  origin  NULL  destination  NULL   printf  An edge was specified that connected a nonexistent vertex n  continue   if  origin  destination   printf  An edge was specified that connected a vertex to itself n  continue   if  opposite opposite - GetOpposite    printf  A non-manifold edge incident to more than 2 faces was found n  continue   if  origin - GetEdge  destination   printf  An edge connecting two vertices was specified more than once. Its likely that an incident face was flipped n  continue    mesh - NewFace  nv , fv , 0   Wrapping Things Up Once we have vertices and faces set in our mesh, we still need to wrap things up by calling HbrMeshFinish  mesh - Finish  Finish iterates over the mesh to apply the boundary interpolation rules and checks for singular vertices. At this point, there is one final topology check remaining to validate the mesh mesh - Finish  if  mesh - GetNumDisconnectedVertices   printf  The specified subdivmesh contains disconnected surface components. n   abort or iterate over the mesh to remove the offending vertices  Boundary Interpolation Rules The rule-set can be selected using the following accessors Vertex and varying data mesh - SetInterpolateBoundaryMethod  OpenSubdiv  HbrMesh Vertex  k_InterpolateBoundaryEdgeOnly  Face-varying data mesh - SetFVarInterpolateBoundaryMethod  OpenSubdiv  HbrMesh Vertex  k_InterpolateBoundaryEdgeOnly  Additional information on boundary interpolation rules can be found here and here Warning The boundary interpolation rules must be set before the call to HbrMeshFinish , which sets the sharpness values to boundary edges and vertices based on these rules. Adding Creases Hbr supports a sharpness attribute on both edges and vertices. Sharpness is set using the SetSharpnessfloat accessors. Vertex Creases Given an index, vertices are very easy to access in the mesh. int idx   vertex index float sharp   the edge sharpness OpenSubdiv  HbrVertex Vertex  v  mesh - GetVertex  idx  if  v   v - SetSharpness  std  max  0.0f , sharp    else printf  cannot find vertex for corner tag d n , idx  Edge Creases Usually, edge creases are described with a vertex indices pair. Here is some sample code to locate the matching half-edge and set a crease sharpness. int v0 , v1   vertex indices float sharp   the edge sharpness OpenSubdiv  HbrVertex Vertex  v  mesh - GetVertex  v0 ,  w  mesh - GetVertex  v1  OpenSubdiv  HbrHalfedge Vertex  e  0  if  v w   if  e  v - GetEdge  w   0  e  w - GetEdge  v  if  e   e - SetSharpness  std  max  0.0f , sharp    else printf  cannot find edge for crease tag d,d n , v0 , v1   Holes Hbr faces support a hole tag. int idx   the face index OpenSubdiv  HbrFace Vertex  f  mesh - GetFace  idx  if  f   f - SetHole   else printf  cannot find face for hole tag d n , idx  Note The hole tag is hierarchical  sub-faces can also be marked as holes. See Hierarchical Edits Hierarchical Edits Hbr supports the following types of hierarchical edits Type Function Corner edits Modify vertex sharpness Crease edits Modify edge sharpness FaceEdit Modify custom face data FVarEdit Modify face-varying data VertexEdit Modify vertex and varying data HoleEdit Set hole tag Modifications are one of the following 3 operations Operation Set Add Subtract Here is a simple example that creates a hierarchical vertex edit that corresponds to this example .  path  655, 2, 3, 0 int faceid  655 , nsubfaces  2 , subfaces  2    2 , 3 , vertexid  0  int offset  0 ,  offset to the vertex or varying data numElems  3   number of elements to apply the modifier to x,y,z  3 bool isP  false   shortcut to identify modifications to the vertex position P OpenSubdiv  HbrHierarchicalEdit Vertex  Operation op  OpenSubdiv  HbrHierarchicalEdit T  Set  float values  3    1.0f , 0.5f , 0.0f   edit values OpenSubdiv  HbrVertexEdit T  edit  new OpenSubdiv  HbrVertexEdit T  faceid , nsubfaces , subfaces , vertexid , offset , floatwidth , isP , op , values  Face-varying Data Here is a walk-through of how to store face-varying data for a u,v pair. Unlike vertex and varying data which is accessed through the templated vertex API, face-varying data is directly aggregated as vectors of float data. Instantiating the HbrMesh The HbrMesh needs to retain some knowledge about the face-varying data that it carries in order to refine it correctly. int fvarwidth  2   total width of the fvar data static int indices  1    0 ,  1 offset set to 0 widths  1    2   2 floats in a u,v pair int const fvarcount  fvarwidth 0  1  0 ,  fvarindices  fvarwidth 0  indices  NULL ,  fvarwidths  fvarwidth 0  widths  NULL  mesh  new OpenSubdiv  HbrMesh T  _scheme , fvarcount , fvarindices , fvarwidths , fvarwidth  Setting the Face-Varying Data After the topology has been created, Hbr is ready to accept face-varying data. Here is some sample code for  int i  0 , idx  0  i numFaces   i   OpenSubdiv  HbrFace Vertex  f  mesh - GetFace  i  int nv  f - GetNumVertices   note this is not the fastest way OpenSubdiv  HbrHalfedge Vertex  e  f - GetFirstEdge  for  int j  0  j nv   j , e  e - GetNext   OpenSubdiv  HbrFVarData Vertex fvt  e - GetOrgVertex  - GetFVarData  f  float const  fvdata  GetFaceVaryingData  i , j  if  not fvt . IsInitialized    if no fvar daa exists yet on the vertex fvt . SetAllData  2 , fvdata   else if  not fvt . CompareAll  2 , fvdata    if there already is fvar data and there is a boundary add the new data OpenSubdiv  HbrFVarData T nfvt  e - GetOrgVertex  - NewFVarData  f  nfvt . SetAllData  2 , fvdata     Retrieving the Face-Varying Data The HbrFVarData structures are expanded during the refinement process, with every sub-face being assigned a set of interpolated face-varying data. This data can be accessed in 2 ways  From a face, passing a vertex index  OpenSubdivHbrFace Vertex  f OpenSubdiv  HbrFVarData const fv  f . GetFVarData  vindex  const float  data  fv . GetData  From a vertex, passing a pointer to an incident face  OpenSubdivHbrFace Vertex  f OpenSubdiv  HbrFVarData const fv  myVertex . GetFVarData  f  const float  data  fv . GetData  Valence Operators When manipulating meshes, it is often necessary to iterate over neighboring faces or vertices. Rather than gather lists of pointers and return them, Hbr exposes an operator pattern that guarantees consistent mesh traversals. The following example shows how to use an operator to count the number of neighboring vertices use HbrVertexGetValence for proper valence counts OpenSubdivHbrVertex Vertex  v class MyOperator  public OpenSubdiv  HbrVertexOperator Vertex  public  int count  MyOperator   count  0    virtual void operator   OpenSubdiv  HbrVertex Vertex v    count    MyOperator op  v - ApplyOperatorSurroundingVertices  op  Managing Singular Vertices Certain topological configurations would force vertices to share multiple half-edge cycles. Because Hbr is a half-edge representation, these singular vertices have to be duplicated as part of the HbrMeshFinish phase of the instantiation. These duplicated vertices can cause problems for client-code that tries to populate buffers of vertex or varying data. The following sample code shows how to match the vertex data to singular vertex splits  Populating an OsdCpuVertexBuffer with vertex data positions,... float const  vtxData  inMeshFn . getRawPoints  returnStatus  OpenSubdiv  OsdCpuVertexBuffer  vertexBuffer  OpenSubdiv  OsdCpuVertexBuffer  Create  numVertexElements , numFarVerts  vertexBuffer - UpdateData  vtxData , 0 , numVertices   Duplicate the vertex data into the split singular vertices std  vector std  pair int , int const splits  hbrMesh - GetSplitVertices  for  int i  0  i  int  splits . size   i   vertexBuffer - UpdateData  vtxData  splits  i . second  numVertexElements , splits  i . first , 1   Generated on 2016-06-13 0020 UTC. User Docs API Docs Release Notes Forum", "tags": "", "loc":"using_osd_hbr.html"}, 
{"title":"far_tutorial_7.cpp", "text":"far_tutorial_7.cpp far_tutorial_7.cpp 3.0.2 User Docs API Docs Release Notes Forum Github OSD_ARTICLE_TITLE httpsgithub.comPixarAnimationStudiosOpenSubdivblobmastertutorialsfartutorial_7far_tutorial_7.cpp ------------------------------------------------------------------------------  Tutorial description   This tutorial shows how to create and manipulate table of cascading stencils.   We initalize a FarTopologyRefiner initalized with a cube and apply uniform  refinement. We then use a FarStencilTableFactory to generate a stencil  table. We set the factory Options to not factorize intermediate levels,  thus giving a table of cascading stencils.   We then apply the stencils to the vertex position primvar data, and insert  a hierarchical edit at level 1. This edit is smoothed by the application  of the subsequent stencil cascades.   The results are dumped into an OBJ file that shows the intermediate levels  of refinement of the original cube.  include opensubdivfartopologyDescriptor.h include opensubdivfarstencilTable.h include opensubdivfarstencilTableFactory.h include cstdio include cstring ------------------------------------------------------------------------------  Vertex container implementation.  struct Vertex   Minimal required interface ---------------------- Vertex    Vertex  Vertex const src   _position  0   src . _position  0  _position  1   src . _position  1  _position  2   src . _position  2   void Clear  void   0   _position  0   _position  1   _position  2   0.0f   void AddWithWeight  Vertex const src , float weight   _position  0   weight  src . _position  0  _position  1   weight  src . _position  1  _position  2   weight  src . _position  2    Public interface ------------------------------------ void SetPosition  float x , float y , float z   _position  0   x  _position  1   y  _position  2   z   float const  GetPosition  const  return _position   float  GetPosition   return _position   private  float _position  3   ------------------------------------------------------------------------------  Cube geometry from catmark_cube.h static float g_verts  24    - 0.5f , - 0.5f , 0.5f , 0.5f , - 0.5f , 0.5f , - 0.5f , 0.5f , 0.5f , 0.5f , 0.5f , 0.5f , - 0.5f , 0.5f , - 0.5f , 0.5f , 0.5f , - 0.5f , - 0.5f , - 0.5f , - 0.5f , 0.5f , - 0.5f , - 0.5f  static int g_nverts  8 , g_nfaces  6  static int g_vertsperface  6    4 , 4 , 4 , 4 , 4 , 4  static int g_vertIndices  24    0 , 1 , 3 , 2 , 2 , 3 , 5 , 4 , 4 , 5 , 7 , 6 , 6 , 7 , 1 , 0 , 1 , 7 , 5 , 3 , 6 , 0 , 2 , 4  using namespace OpenSubdiv  static Far  TopologyRefiner  createTopologyRefiner  ------------------------------------------------------------------------------ int main  int , char     Generate some FarTopologyRefiner see far_tutorial_0 for details. Far  TopologyRefiner  refiner  createTopologyRefiner   Uniformly refine the topolgy up to maxlevel. int maxlevel  4  refiner - RefineUniform  Far  TopologyRefiner  UniformOptions  maxlevel   Use the FarStencilTable factory to create cascading stencil table  note we want stencils for the each refinement level  cascade mode is achieved by setting factorizeIntermediateLevels  to false Far  StencilTableFactory  Options options  options . generateIntermediateLevels  true  options . factorizeIntermediateLevels  false  options . generateOffsets  true  Far  StencilTable const  stencilTable  Far  StencilTableFactory  Create   refiner , options  std  vector Vertex vertexBuffer  refiner - GetNumVerticesTotal  - g_nverts  Vertex  destVerts  vertexBuffer  0  int start  0 , end  0   stencils batches for each level of subdivision for  int level  0  level maxlevel   level   int nverts  refiner - GetLevel  level  1 . GetNumVertices  Vertex const  srcVerts  reinterpret_cast Vertex   g_verts  if  level 0   srcVerts  vertexBuffer  start   start  end  end  nverts  stencilTable - UpdateValues  srcVerts , destVerts , start , end   apply 2 hierarchical edits on level 1 vertices if  level  1   float  pos  destVerts  start  5 . GetPosition  pos  1   0.5f  pos  destVerts  start  20 . GetPosition  pos  0   0.25f      Output OBJ of the highest level refined ----------- Vertex  verts  vertexBuffer  0   Print vertex positions for  int level  1 , firstvert  0  level  maxlevel   level   Far  TopologyLevel const refLevel  refiner - GetLevel  level  printf  g level_d n , level  int nverts  refLevel . GetNumVertices  for  int vert  0  vert nverts   vert   float const  pos  verts  vert . GetPosition  printf  v f f f n , pos  0 , pos  1 , pos  2   verts  nverts   Print faces for  int face  0  face refLevel . GetNumFaces   face   Far  ConstIndexArray fverts  refLevel . GetFaceVertices  face   all refined Catmark faces should be quads assert  fverts . size   4  printf  f  for  int vert  0  vert fverts . size   vert   printf  d , fverts  vert   firstvert  1   OBJ uses 1-based arrays...  printf  n   firstvert  nverts    delete refiner  delete stencilTable   ------------------------------------------------------------------------------ static Far  TopologyRefiner  createTopologyRefiner    Populate a topology descriptor with our raw data. typedef Far  TopologyDescriptor Descriptor  Sdc  SchemeType type  OpenSubdiv  Sdc  SCHEME_CATMARK  Sdc  Options options  options . SetVtxBoundaryInterpolation  Sdc  Options  VTX_BOUNDARY_EDGE_ONLY  Descriptor desc  desc . numVertices  g_nverts  desc . numFaces  g_nfaces  desc . numVertsPerFace  g_vertsperface  desc . vertIndicesPerFace  g_vertIndices   Instantiate a FarTopologyRefiner from the descriptor. return Far  TopologyRefinerFactory Descriptor  Create  desc , Far  TopologyRefinerFactory Descriptor  Options  type , options   ------------------------------------------------------------------------------ Generated on 2016-06-13 0020 UTC. User Docs API Docs Release Notes Forum", "tags": "", "loc":"far_tutorial_7.html"}, 
{"title":"Contributing to OpenSubdiv", "text":"Contributing to OpenSubdiv Contributing to OpenSubdiv 3.0.2 User Docs API Docs Release Notes Forum Github OSD_ARTICLE_TITLE Contributor License Agreement Understand Git Recommended Git Workflow Sending a Pull Request Contributor License Agreement In order for us to accept code submissions merge git pull-requests, contributors need to sign the Contributor License Agreement CLA. There are two CLAs, one for individuals and one for corporations. As for the end-user license, both are based on Apache. They are found in the code repository  individual form , corporate form . Please email the signed CLA to opensubdiv-cla pixar.com . Understand Git First, you should familiarize yourself with the Git data model and commands. For small changes you may not need to understand Git deeply, but for larger changes or working with the codebase over a long period of time, it becomes critical to understand more of whats going on under the hood. There are many free resources on the internet, one which weve found useful is the following e-book httpsgithub.compluralsightgit-internals-pdfreleases Recommended Git Workflow Once you have a local development tree cloned and working, you can start making changes. You will need to integrate changes from the source tree as you work the following outlines the workflow used by core OpenSubdiv engineers at Pixar and DreamWorks Fork the master repository into your own local copy. This can be done via the GitHub website using the fork button. Clone your fork locally git clone your_fork_url OpenSubdiv. your_name e.g. git clone httpsgithub.comjcowlesOpenSubdiv.git OpenSubdiv.jcowles Setup two remotes, origin and upstream . Origin will be setup as a result of cloning your remote repository, but upstream must be setup manually git remote add upstream httpsgithub.comPixarAnimationStudiosOpenSubdiv.git Verify your remotes are setup correctly git remote -v Which should look something like origin httpsgithub.comjcowlesOpenSubdiv.git fetch origin httpsgithub.comjcowlesOpenSubdiv.git push upstream httpsgithub.comPixarAnimationStudiosOpenSubdiv.git fetch upstream httpsgithub.comPixarAnimationStudiosOpenSubdiv.git push Finally, fetch the upstream content this is required for the next step git fetch upstream Setup a new branch for each change. Working with branches in Git is its greatest pleasure, we strongly suggest setting up a new branch for each change which you plan to pull-request. All work is done in the dev branch, so be sure to keep your change in sync with this upstream branch. To begin, start your new branch from the dev branch git checkout -b dev-feature upstreamdev As you are working on your feature, new changes will be merged into the upstream repository, to sync these changes down and preserve your local edits, you can continually rebase your local work git pull --rebase upstream dev Notice the --rebase option here. It updates the current branch to the upstreamdev branch and rebases all edits so they are at the head of your local feature branch. Alternatively, you can rebase all your work at once when your feature is complete. Sending a Pull Request First, rebase and squash your changes appropriately to produce a clean set of changes at the head of your tree. We require changes to be grouped locally to ensure that rolling back changes can be done easily. If youve followed the steps above, your pending change should already be queued up as required. If you have not, you may need to rebase and squash changes at this point. Once the change is clean, push your changes to origin and go to the GitHub website to submit your pull request. Be sure to submit your request against the dev branch. Generated on 2016-06-13 0020 UTC. User Docs API Docs Release Notes Forum", "tags": "", "loc":"contributing.html"}, 
{"title":"Subdivision Compatibility", "text":"Subdivision Compatibility Subdivision Compatibility 3.0.2 User Docs API Docs Release Notes Forum Github OSD_ARTICLE_TITLE Subdivision Compatibility Compatibility with OpenSubdiv 2.x Compatibility with RenderMan Incompatibilities Other Differences Subdivision Compatibility This document highlights areas of compatibility with other software that makes use of subdivision surfaces, including previous versions of OpenSubdiv. The compatibility here refers to the choice of subdivision rules that define the shape of the resulting surfaces. Different subdivision rules will lead to different shapes. Choices affecting shape include the types of subdivision schemes supported e.g. Catmull-Clark, Loop, etc. the basic rules applied for these schemes any extended rules to affect sharpness or creasing rules applied separately to face-varying data Ensuring all of these rules are consistent provides the basis for consistent shapes, but further approximations to the limit surface create the potential for subtle deviations. Even within OpenSubdiv, multiple approximations are possible and vary. For now we focus on the compatibility of subdivision rules and deal with the limit approximations only when noteworthy. Compatibility with OpenSubdiv 2.x The refactoring of OpenSubdiv 3.0 data representations presented a unique opportunity to revisit some corners of the subdivision specification and remove or update some legacy features. Face-varying Interpolation Options Face-varying interpolation options have been consolidated into a single enum with one additional choice new to 3.0. No functionality from 2.x has been removed -- just re-expressed in a simpler and more comprehensible form. Face-varying interpolation was previously defined by a boundary interpolation enum with four modes and an additional boolean propagate corners option, which was little understood, i.e. void HbrMeshSetFVarInterpolateBoundarMethodInterpolateBoundaryMethod const void HbrMeshSetFVarPropagateCornersbool const The latter was only used in conjunction with one of the four modes  edge and corner , so it was effectively a unique fifth choice. Closer inspection of all of these modes also revealed some unexpected and undesirable behavior in some common cases -- to an extent that could not simply be changed -- and so an additional mode was added to avoid such behavior. All choices are now provided through a single linear interpolation enum, described and illustrated in more detail in the overview of Face-Varying Interpolation . The use of boundary in the name of the enum was intentionally removed as the choice also affects interior interpolation. The new use of linear is now intended to reflect the fact that interpolation is constrained to be linear where specified by the choice applied. All five of Hbrs original modes of face-varying interpolation are supported with minor modifications where Hbr was found to be incorrect in the presence of semi-sharp creasing. An additional mode  corners only  has also been added to avoid some of the undesired side-effects of some existing modes illustrated below. The new values for the SdcOptionsFVarLinearInterpolation enum and its equivalents for HbrMeshs InterpolateBoundaryMethod and PropagateCorners flag are as follows ordered such that the set of linear constraints applied is always increasing -- from completely smooth to completely linear Sdc FVarLinearInterpolation Hbr FVarInterpolateBoundaryMethod Hbr FVarPropogateCorners FVAR_LINEAR_NONE k_InterpolateBoundaryEdgeOnly NA ignored FVAR_LINEAR_CORNERS_ONLY NA NA FVAR_LINEAR_CORNERS_PLUS1 k_InterpolateBoundaryEdgeAndCorner false FVAR_LINEAR_CORNERS_PLUS2 k_InterpolateBoundaryEdgeAndCorner true FVAR_LINEAR_BOUNDARIES k_InterpolateBoundaryAlwaysSharp NA ignored FVAR_LINEAR_ALL k_InterpolateBoundaryNone NA ignored Aside from the two corners plus modes that preserve Hbr behavior, all other modes are designed so that the interpolation of a disjoint face-varying region is not affected by changes to other regions that may share the same vertex. So the behavior of a disjoint region should be well understood and predictable when looking at it in isolation e.g. with corners only one would expect to see linear constraints applied where there are topological corners or infinitely sharp creasing applied within the region, and nowhere else. This is not true of the plus modes, and they are named to reflect the fact that more is taken into account where disjoint regions meet. The following example illustrates some undesired effects of the plus modes, which in part motivated the addition of the new corners only mode. The example uses the catmark_fvar_bound0 and catmark_fvar_bound1 shapes from the suite of regression shapes. Both shapes are a simple regular 4x4 grid of quads with face-varying UV data partitioned into multiple disjoint regions. The bound0 shape has two disjoint UV regions -- an upper and lower region -- while the bound1 shape further splits the lower region in two. This first figure illustrates the effect of the original plus1 mode which is also the same for plus2  Note that the effect of splitting the lower UV region in two has the undesired side effect of sharpening the boundary of the upper region. This is the result of the plus1 mode making collective decisions about the sharpness of all face-varying boundaries at the vertex rather than decisions local to each region. In both the plus1 and plus2 cases, all face-varying boundaries sharing a vertex will be sharpened if there are more than two regions meeting at that vertex. The second figure illustrates the effect of the new corners only mode As expected, the splitting of the lower region does not impact the upper region. In this case the decision to sharpen a face-varying boundary is made based on the local topology of each region. Vertex Interpolation Options Since the various options are now presented through a new API Sdc rather than Hbr, based on the history of some of these options and input from interested parties, the following changes have been implemented The naming of the standard creasing method has been changed from Normal to Uniform . Values for SdcOptionsCreasingMethod are now CREASE_UNIFORM standard integer subtraction per level default CREASE_CHAIKIN Chaikin non-uniform averaging around vertices Legacy modes of the smoothtriangle rule have been removed as they were never actually enabled in the code. Values for SdcOptionsTriangleSubdivision are now TRI_SUB_CATMARK Catmull-Clark weights default TRI_SUB_SMOOTH smooth triangle weights These should have little impact since one is a simple change in terminology as part of a new API while the other was removal of an option that was never used. Change to Chaikin creasing method In the process of re-implementing the Chaikin creasing method, observations lead to a conscious choice to change the behavior of Chaikin creasing in the presence of infinitely sharp edges most noticeable at boundaries. Previously, the inclusion of infinite sharpness values in the Chaikin methods computation of edge sharpness around a vertex would prevent a semi-sharp edge from decaying to zero. Infinitely sharp edges are now excluded from the Chaikin non-uniform averaging yielding a much more predictable and desirable result. For example, where the sharpness assignment is actually uniform at such a vertex, the result will now behave the same as the Uniform method. Since this feature has received little use only recently activated in RenderMan, now seemed the best time to make the change before more widespread adoption. Hierarchical Edits While extremely powerful, Hierarchical Edits come with additional maintenance and implementation complexity. Support for them in popular interchange formats and major DCC applications has either been dropped or was never implemented. As a result, the need for Hierarchical Edits is too limited to justify the cost and support for them, and they have therefore been removed from the 3.0 release of OpenSubdiv. Dropping support for Hierarchical Edits allows for significant simplifications of many areas of the subdivision algorithms. While the 3.0 release does not offer direct support for Hierarchical Edits, the architectural changes and direction of 3.0 still facilitate the application of the most common value edits for those wishing to use them -- though not always in the same optimized context. Of course, support for Hierarchical Edits in the future will be considered based on demand and resources. Non-Manifold Topology OpenSubdiv 2.x and earlier was limited to dealing with meshes whose topology was manifold -- a limitation imposed by the use of Hbr. With 3.0 no longer using Hbr, the manifold restriction has also been removed. OpenSubdiv 3.0, therefore, supports a superset of the meshes supported by 2.x and earlier versions with one known exception noted below. Non-manifold meshes that are acceptable to 3.0 however will likely not work with 2.x or earlier. The one known case that 3.0 will not represent the same as 2.x is ironically a case that is non-manifold, and for which Hbr did make special accommodation. That case occurs at a non-manifold vertex where two or more faces meet at a common vertex, but do not share a common edge, and when the boundary interpolation mode is set for smooth corners i.e. edge only , as illustrated below The cage is on the left and is refined to level 2 on the right. On the immediate right, boundary interpolation is set to sharp corners and the results appear the same for 2.x and 3.0. The center and far right illustrate the affects of setting boundary interpolation to smooth corners with 2.x and 3.0 respectively. Note that the 2.x result allows the refined mesh and so the limit surface to split into two while the 3.0 result keeps it connected. When Hbr encounters such vertices, regardless of the boundary mode it splits the vertex -- creating a separate instance of it for each face. So when building an HbrMesh, after finalizing the mesh, it will result in having more vertices than were originally defined termed split vertices . OpenSubdiv 2.x and earlier successfully hid the presence of these extra vertices from users. This case behaves in such a way that violates certain properties of the surface that 3.0 has attempted to emphasize. One of these relates to the nature of the limit surface and becomes more significant in the context of face varying if the cage is connected then so too is its limit surface, or similarly, if the cage consists of N connected regions then the limit surface similarly consists of N connected regions. Another undesirable property here is that the vertex V at which these faces meet must have more than one child vertex V . This makes it difficult to hide split vertices -- OpenSubdiv 2.x tables had an extra level of indirection that made it possible to do this relatively easily, but 3.0 has dispensed with such indirection where possible to streamline performance. Compatibility with RenderMan Since RenderMan and OpenSubdiv versions prior to 3.0 share a common library Hbr, most differences between RenderMan and OpenSubdiv 3.0 are covered in the preceding section of compatibility with OpenSubdiv 2.x. In addition to some features between RenderMan and OpenSubdiv that are not compatible, there are also other differences that may be present due to differences in the implementations of similar features. For most use cases, OpenSubdiv 3.0 is largely compatible with RenderMan. There are however some cases where some differences can be expected. These are highlighted below for completeness. Incompatibilities OpenSubdiv and RenderMan will be incompatible when certain features are used that are not common to both. They are fully described in the 2.x compatibility section and are listed briefly here. OpenSubdiv 3.0 Features Not Supported by RenderMan Non-manifold meshes Choice of the corners only face varying interpolation option RenderMan Features Not Supported by OpenSubdiv 3.0 Hierarchical Edits Other Differences Some differences can occur due to the differing implementations of the feature sets. Additionally, OpenSubdiv 3.0s implementation fixes some issues discovered in Hbr. Smooth Face-Varying Interpolation with Creasing There have been two discrepancies noted in the way that face-varying data is interpolated smoothly in the presence of creases. Smooth face-varying interpolation is expected to match vertex interpolation in the interior and only differ along the boundaries or discontinuities where the face-varying topology is intentionally made to differ from the vertex topology. A simple and effective way to identify discrepancies is to use the X and Y coordinates of vertex positions as the U and V of texture coordinates. If these U and V coordinates are assigned to a face-varying channel, smooth interpolation of U and V is expected to exactly match interpolation of X and Y, regardless of the presence of any sharpness and creasing. Two discrepancies can be seen with Hbr when superimposing the XY vertex interpolation with the projected UV face-varying interpolation. The first discrepancy occurs with interpolation around dart vertices This example shows a simple regular XY grid on the left with an interior sharp edge creating a dart vertex in the center. With no asymmetry in the vertices, the sharpness has no asymmetric affect and the XY vertex interpolation on the immediate right shows the regular grid expected from refinement. On the far right is the UV interpolation from Hbr, which exhibits distortion around the center dart vertex. The second discrepancy occurs with interpolation involving any fractional sharpness values. Hbr effectively ignores any fractional sharpness value in its face-varying interpolation. So edges of vertices with sharpness of say 2.5, will be treated as though their sharpness is 2.0 when face-varying values are interpolated. Similarly, any non-zero sharpness value less than 1.0 is treated as zero by truncation and so is essentially ignored. This example shows an asymmetric 2x2 grid of quads on the left with the center vertex progressively sharpened from 0.5 to 1.0. The three cases of the vertex smooth and sharpened are superimposed on the immediate right to display the three distinct interpolation results. On the far right the interpolation from Hbr displays the same three cases, but only two are visibly distinct -- the sharpness of 0.5 being treated the same as if it were 0.0. Both of these cases are corrected in OpenSubdiv 3.0. Smooth face-varying interpolation in the presence of creasing should match the expected behavior of the vertex interpolation, except where the face-varying topology is explicitly made to differ. The Chaikin Creasing Method At least two discrepancies are know to exist between the implementations of Hbr in RenderMan and OpenSubdiv 3.0 Use of Chaikin creasing with boundaries or infinitely sharp edges Subtle shape differences due to Hbrs use of predictive sharpness Fortunately, this feature was only recently added to Hbr and RenderMan and is little used, so it is expected these differences will have little impact. The first discrepancy is mentioned briefly in the previous section on compatibility between OpenSubdiv 2.x and 3.0. A conscious decision was made to change the averaging of sharpness values involving infinitely sharp edges in order to make results more predictable and favorable. The effects can be seen comparing the regression shape catmark_chaikin2 . The second is more subtle and results from an oversight within Hbrs implementation that is not easily corrected. When determining what subdivision rule to apply from one level to the next, the sharpness values at the next level must be known in order to determine whether or not a transition between differing rules is required. If the rule at the next level differs from the previous, a combination of the two is applied. Such a change results from the sharpness values of one or more edges or the vertex itself decaying to zero. Rather than compute the sharpness values at the next level accurately, Hbr predicts it by simply subtracting 1.0 from it, as is done with the uniform creasing method, and it bases decisions on that predicted result. This does not work for Chaikin though. A sharpness value less than 1.0 may not decay to 0 if it is averaged with neighboring sharpness values greater than 1.0, so this sharpness prediction can result in the wrong rule being chosen for the next level. A typical case would have the subdivision rules for Chaikin creasing transition from Corner to Crease at one level, then from Crease to Smooth at the next. Hbrs predictive creasing might mistakenly detect the transition as Corner to Smooth at one level, then after properly computing the sharpness values for the next level later, from Crease to Smooth for the next. One of the regression shapes  catmark_chakin1  was disabled from the regression suite because of this effect. The differences in shape that trigger its regression failure were investigated and determined to be the result of this issue. From observations thus far these differences are subtle but can be noticeable. Numerical Precision Since its inception, OpenSubdiv has sought to produce results that were numerically consistent to RenderMan. A regression suite to ensure a certain level of accuracy was provided to detect any substantial deviation. At some point in the development of OpenSubdiv, the point was made that numerical accuracy of Hbr could be improved by changing the order of operations and combining the vertex with the lowest coefficient first in one of the subdivision rules. This was applied more thoroughly in the independent implementation of 3.0 there seemed no reason not to. In most cases the relative magnitudes of the coefficients of subdivision and limit masks is clear so no overhead was necessary to detect them. At a certain point though, this greater accuracy came in conflict with the regression suite. It turned out that high-valence vertices could not be computed to within the desired tolerances set within the suite. The summation of many small coefficients for the adjacent vertices first, before the addition of the much larger coefficient for the primary vertex, allowed for the accumulation of precision that was being truncated by adding the much larger coefficient first in the Hbr implementation. With extremely high valence vertices, a difference in magnitude between the most and least significant coefficients of several orders of magnitude is likely, and that has a significant impact on the single-precision floating point computations. The improved accuracy of OpenSubdiv 3.0 can reach a magnitude that will not go undetected. Whether or not this can lead to visual artifacts is unclear. Generated on 2016-06-13 0020 UTC. User Docs API Docs Release Notes Forum", "tags": "", "loc":"compatibility.html"}, 
{"title":"HBR Overview", "text":"HBR Overview HBR Overview 3.0.2 User Docs API Docs Release Notes Forum Github OSD_ARTICLE_TITLE Hierarchical Boundary Representation Hbr Half-edge Data Structure Half-edge cycles and Manifold Topology Templated Vertex Class Boundary Interpolation Rules Hierarchical Boundary Representation Hbr Hbr is an interconnected topological data representation. The high level of vertex connectivity information makes this representation well suited for creation and editing purposes. It is however inefficient for interactive refinement operations Separate objects are allocated for each vertex and edge with pointers to neighboring vertices and edges. Hbr is also the lowest-level subdivision library in Pixars Photorealistic RenderMan . Note As of OpenSubdiv 3.0, all Hbr dependencies have been removed from the core APIs  Sdc , Vtr , Far , Osd . The legacy source code of Hbr is provided purely for regression and legacy purposes. If your code is currently depending on Hbr functionality, we recommend migrating to the newer APIs as we cannot guarantee that this code will be maintained in future releases. For more information see the 3.0 release notes Half-edge Data Structure The current implementation is based on a half-edge data structure. Half-edge cycles and Manifold Topology Because half-edges only carry a reference to their opposite half-edge, a given edge can only access a single neighboring edge cycle. This is a fundamental limitation of the half-edge data structure, in that it cannot represent non-manifold geometry, in particular fan-type topologies. A different approach to topology will probably be necessary in order to accommodate non-manifold geometry. Templated Vertex Class The vertex class has been abstracted into a set of templated function accesses. Providing Hbr with a template vertex class that does not implement these functions allows client-code to use Hbr as a pure topological analysis tool without having to pay any costs for data interpolation. It also allows client-code to remain in complete control of the layout of the vertex data  interleaved or non-interleaved. Boundary Interpolation Rules Hbr recognizes 4 rule-sets of boundary interpolation Interpolation Rule-Sets k_InterpolateBoundaryNone k_InterpolateBoundaryEdgeOnly k_InterpolateBoundaryEdgeAndCorner k_InterpolateBoundaryAlwaysSharp This enum is shared for both vertex and face-varying interpolation , with the following distinctions vertex boundaries the BoundaryNone rule skips all boundary vertices results are undefined the AlwaysSharp rule does not apply face-varying boundaries the BoundaryNone rule selects bilinear face-varying interpolation Generated on 2016-06-13 0020 UTC. User Docs API Docs Release Notes Forum", "tags": "", "loc":"hbr_overview.html"}, 
{"title":"osd_tutorial_0.cpp", "text":"osd_tutorial_0.cpp osd_tutorial_0.cpp 3.0.2 User Docs API Docs Release Notes Forum Github OSD_ARTICLE_TITLE httpsgithub.comPixarAnimationStudiosOpenSubdivblobmastertutorialsosdtutorial_0osd_tutorial_0.cpp ------------------------------------------------------------------------------  Tutorial description   This tutorial demonstrates the manipulation of Osd Evaluator and  BufferDescriptor.  include opensubdivfartopologyDescriptor.h include opensubdivfarstencilTableFactory.h include opensubdivosdcpuEvaluator.h include opensubdivosdcpuVertexBuffer.h include cstdio include cstring ------------------------------------------------------------------------------  Cube geometry from catmark_cube.h static float g_verts  24    - 0.5f , - 0.5f , 0.5f , 0.5f , - 0.5f , 0.5f , - 0.5f , 0.5f , 0.5f , 0.5f , 0.5f , 0.5f , - 0.5f , 0.5f , - 0.5f , 0.5f , 0.5f , - 0.5f , - 0.5f , - 0.5f , - 0.5f , 0.5f , - 0.5f , - 0.5f  static int g_nverts  8 , g_nfaces  6  static int g_vertsperface  6    4 , 4 , 4 , 4 , 4 , 4  static int g_vertIndices  24    0 , 1 , 3 , 2 , 2 , 3 , 5 , 4 , 4 , 5 , 7 , 6 , 6 , 7 , 1 , 0 , 1 , 7 , 5 , 3 , 6 , 0 , 2 , 4  using namespace OpenSubdiv  static Far  TopologyRefiner const  createTopologyRefiner  int maxlevel  ------------------------------------------------------------------------------ int main  int , char    int maxlevel  2 , nCoarseVerts  0 , nRefinedVerts  0    Setup phase  Far  StencilTable const  stencilTable  NULL    Setup FarStencilTable Far  TopologyRefiner const  refiner  createTopologyRefiner  maxlevel   Setup a factory to create FarStencilTable for more details see  Far tutorials Far  StencilTableFactory  Options options  options . generateOffsets  true  options . generateIntermediateLevels  false  stencilTable  Far  StencilTableFactory  Create   refiner , options  nCoarseVerts  refiner - GetLevel  0 . GetNumVertices  nRefinedVerts  stencilTable - GetNumStencils   We are done with Far cleanup table delete refiner    Setup a buffer for vertex primvar data Osd  CpuVertexBuffer  vbuffer  Osd  CpuVertexBuffer  Create  3 , nCoarseVerts  nRefinedVerts    Execution phase every frame    Pack the control vertex data at the start of the vertex buffer  and update every time control data changes vbuffer - UpdateData  g_verts , 0 , nCoarseVerts  Osd  BufferDescriptor srcDesc  0 , 3 , 3  Osd  BufferDescriptor dstDesc  nCoarseVerts  3 , 3 , 3   Launch the computation Osd  CpuEvaluator  EvalStencils  vbuffer , srcDesc , vbuffer , dstDesc , stencilTable     Visualization with Maya  print a MEL script that generates particles  at the location of the refined vertices printf  particle  float const  refinedVerts  vbuffer - BindCpuBuffer   3  nCoarseVerts  for  int i  0  i nRefinedVerts   i   float const  vert  refinedVerts  3  i  printf  -p f f f n , vert  0 , vert  1 , vert  2   printf  -c 1 n   delete stencilTable  delete vbuffer   ------------------------------------------------------------------------------ static Far  TopologyRefiner const  createTopologyRefiner  int maxlevel    Populate a topology descriptor with our raw data typedef Far  TopologyDescriptor Descriptor  Sdc  SchemeType type  OpenSubdiv  Sdc  SCHEME_CATMARK  Sdc  Options options  options . SetVtxBoundaryInterpolation  Sdc  Options  VTX_BOUNDARY_EDGE_ONLY  Descriptor desc  desc . numVertices  g_nverts  desc . numFaces  g_nfaces  desc . numVertsPerFace  g_vertsperface  desc . vertIndicesPerFace  g_vertIndices   Instantiate a FarTopologyRefiner from the descriptor Far  TopologyRefiner  refiner  Far  TopologyRefinerFactory Descriptor  Create  desc , Far  TopologyRefinerFactory Descriptor  Options  type , options   Uniformly refine the topolgy up to maxlevel refiner - RefineUniform  Far  TopologyRefiner  UniformOptions  maxlevel  return refiner   ------------------------------------------------------------------------------ Generated on 2016-06-13 0020 UTC. User Docs API Docs Release Notes Forum", "tags": "", "loc":"osd_tutorial_0.html"}, 
{"title":"far_tutorial_0.cpp", "text":"far_tutorial_0.cpp far_tutorial_0.cpp 3.0.2 User Docs API Docs Release Notes Forum Github OSD_ARTICLE_TITLE httpsgithub.comPixarAnimationStudiosOpenSubdivblobmastertutorialsfartutorial_0far_tutorial_0.cpp ------------------------------------------------------------------------------  Tutorial description   This tutorial presents in a very succint way the requisite steps to  instantiate and refine a mesh with Far from simple topological data.  include opensubdivfartopologyDescriptor.h include opensubdivfarprimvarRefiner.h include cstdio ------------------------------------------------------------------------------  Vertex container implementation.  struct Vertex   Minimal required interface ---------------------- Vertex    Vertex  Vertex const src   _position  0   src . _position  0  _position  1   src . _position  1  _position  2   src . _position  2   void Clear  void   0   _position  0   _position  1   _position  2   0.0f   void AddWithWeight  Vertex const src , float weight   _position  0   weight  src . _position  0  _position  1   weight  src . _position  1  _position  2   weight  src . _position  2    Public interface ------------------------------------ void SetPosition  float x , float y , float z   _position  0   x  _position  1   y  _position  2   z   const float  GetPosition  const  return _position   private  float _position  3   ------------------------------------------------------------------------------  Cube geometry from catmark_cube.h static float g_verts  8  3    - 0.5f , - 0.5f , 0.5f ,  0.5f , - 0.5f , 0.5f ,  - 0.5f , 0.5f , 0.5f ,  0.5f , 0.5f , 0.5f ,  - 0.5f , 0.5f , - 0.5f ,  0.5f , 0.5f , - 0.5f ,  - 0.5f , - 0.5f , - 0.5f ,  0.5f , - 0.5f , - 0.5f  static int g_nverts  8 , g_nfaces  6  static int g_vertsperface  6    4 , 4 , 4 , 4 , 4 , 4  static int g_vertIndices  24    0 , 1 , 3 , 2 , 2 , 3 , 5 , 4 , 4 , 5 , 7 , 6 , 6 , 7 , 1 , 0 , 1 , 7 , 5 , 3 , 6 , 0 , 2 , 4  using namespace OpenSubdiv  ------------------------------------------------------------------------------ int main  int , char     Populate a topology descriptor with our raw data typedef Far  TopologyDescriptor Descriptor  Sdc  SchemeType type  OpenSubdiv  Sdc  SCHEME_CATMARK  Sdc  Options options  options . SetVtxBoundaryInterpolation  Sdc  Options  VTX_BOUNDARY_EDGE_ONLY  Descriptor desc  desc . numVertices  g_nverts  desc . numFaces  g_nfaces  desc . numVertsPerFace  g_vertsperface  desc . vertIndicesPerFace  g_vertIndices   Instantiate a FarTopologyRefiner from the descriptor Far  TopologyRefiner  refiner  Far  TopologyRefinerFactory Descriptor  Create  desc , Far  TopologyRefinerFactory Descriptor  Options  type , options  int maxlevel  2   Uniformly refine the topolgy up to maxlevel refiner - RefineUniform  Far  TopologyRefiner  UniformOptions  maxlevel   Allocate a buffer for vertex primvar data. The buffer length is set to  be the sum of all children vertices up to the highest level of refinement. std  vector Vertex vbuffer  refiner - GetNumVerticesTotal  Vertex  verts  vbuffer  0   Initialize coarse mesh positions int nCoarseVerts  g_nverts  for  int i  0  i nCoarseVerts   i   verts  i . SetPosition  g_verts  i  0 , g_verts  i  1 , g_verts  i  2    Interpolate vertex primvar data Far  PrimvarRefiner primvarRefiner   refiner  Vertex  src  verts  for  int level  1  level  maxlevel   level   Vertex  dst  src  refiner - GetLevel  level - 1 . GetNumVertices  primvarRefiner . Interpolate  level , src , dst  src  dst     Output OBJ of the highest level refined ----------- Far  TopologyLevel const refLastLevel  refiner - GetLevel  maxlevel  int nverts  refLastLevel . GetNumVertices  int nfaces  refLastLevel . GetNumFaces   Print vertex positions int firstOfLastVerts  refiner - GetNumVerticesTotal  - nverts  for  int vert  0  vert nverts   vert   float const  pos  verts  firstOfLastVerts  vert . GetPosition  printf  v f f f n , pos  0 , pos  1 , pos  2    Print faces for  int face  0  face nfaces   face   Far  ConstIndexArray fverts  refLastLevel . GetFaceVertices  face   all refined Catmark faces should be quads assert  fverts . size   4  printf  f  for  int vert  0  vert fverts . size   vert   printf  d , fverts  vert   1   OBJ uses 1-based arrays...  printf  n     ------------------------------------------------------------------------------ Generated on 2016-06-13 0020 UTC. User Docs API Docs Release Notes Forum", "tags": "", "loc":"far_tutorial_0.html"}, 
{"title":"FAR Overview", "text":"FAR Overview FAR Overview 3.0.2 User Docs API Docs Release Notes Forum Github OSD_ARTICLE_TITLE Feature Adaptive Representation Far Topology Refinement Primvar Refinement FarTopologyRefiner FarTopologyRefinerFactory FarPrimvarRefiner FarPatchTable Patch Arrays Patch Types Patch Parameterization Single-Crease Patches Local Points Legacy Gregory Patches FarStencilTable Advantages Principles Cascading Stencils Limit Stencils Sample Location On Extraordinary Faces Code example Feature Adaptive Representation Far Far is the primary API layer for processing client-supplied mesh data into subdivided surfaces. The Far interface may be used directly and also may be used to prepare mesh data for further processing by Osd . The two main aspects of the subdivision process are Topology Refinement and Primvar Refinement . Topology Refinement Topology refinement is the process of splitting the mesh topology according to the specified subdivison rules to generate new topological vertices, edges, and faces. This process is purely topological and does not depend on the speciific values of any primvar data point positions, etc. Topology refinement can be either uniform or adaptive, where extraordinary features are automatically isolated see feature adaptive subdivision . The Far topology classes present a public interface for the refinement functionality provided in Vtr , The main classes in Far related to topology refinement are TopologyRefiner A class encapsulating mesh refinement. TopologyLevel A class representing one level of refinement within a TopologyRefiner. TopologyRefinerFactory MESH A factory class template specialized in terms of the applications mesh representation used to construct TopologyRefiner instances. Primvar Refinement Primvar refinement is the process of computing values for primvar data points, colors, normals, texture coordinates, etc by applying weights determined by the specified subdivision rules. There are many advantages gained by distinguishing between topology refinement and primvar interpolation including the ability to apply a single static topological refinement to multiple primvar instances or to different animated primvar time samples. Far supports methods to refine primvar data at the locations of topological vertices and at arbitrary locations on the subdivision limit surface. The main classes in Far related to primvar refinement are PrimvarRefiner A class implementing refinement of primvar data at the locations of topological vertices. PatchTable A representation of the refined surface topology that can be used for efficient evaluation of primvar data at arbitrary locations. StencilTable A representation of refinement weights suitable for efficient parallel processing of primvar refinement. LimitStencilTable A representation of refinement weights suitable for efficient parallel processing of primvar refinement at arbitrary limit surface locations. FarTopologyRefiner TopologyRefiner is the building block for many other useful classes in Far . It performs refinement of an arbitrary mesh and provides access to the refined mesh topology. It can be used for primvar refinement directly using PrimvarRefiner or indirectly by being used to create a stencil table , or a patch table , etc. TopologyRefiner provides the public refinement methods RefineUniform and RefineAdapative which perform refinement operations using Vtr. TopologyRefiner provides access to the refined topology via TopologyLevel instances. FarTopologyRefinerFactory Consistent with other classes in Far, instances of TopologyRefiner are created by a factory class -- in this case FarTopologyRefinerFactory. Here we outline several approaches for converting mesh topology into the required FarTopologyRefiner. Additional documentation is provided with the FarTopologyRefinerFactory MESH class template used by all, and each has a concrete example provided in one of the tutorials or in the Far code itself. There are three ways to create TopologyRefiners use the existing TopologyRefinerFactory TopologyDescriptor with a populated instance of TopologyDescriptor specialize TopologyRefinerFactory class MESH for more efficient conversion, using only face-vertex information fully specialize TopologyRefinerFactor class MESH for most control over conversion Use the FarTopologyDescriptor FarTopologyDescriptor is a simple struct that can be initialized to refer to raw mesh topology information -- primarily a face-vertex list -- and then passed to a provided factory class to create a TopologyRefiner from each. Topologically, the minimal requirement consists of the number of vertices and faces of the mesh an array containing the number of vertices per face an array containing the vertices assigned to each face These last two define one of the six topological relations that are needed internally by Vtr, but this one relation is sufficient to construct the rest. Additional members are available to assign sharpness values per edge andor vertex, hole tags to faces, or to define multiple sets channels of face-varying data. Almost all of the Far tutorials i.e. tutorialsfartutorial_ illustrate use of the TopologyDescriptor and its factory for creating TopologyRefiners, i.e. TopologyRefinerFactory TopologyDescriptor . For situations when users have raw mesh data and have not yet constructed a boundary representation of their own, it is hoped that this will suffice. Options have even been provided to indicate that raw topology information has been defined in a left-hand winding order and the factory will handle the conversion to right-hand counter-clockwise winding on-the-fly to avoid unnecessary data duplication. Custom Factory for Face Vertices If the nature of the TopologyDescriptors data expectations is not helpful, and so conversion to large temporary arrays would be necessary to properly make use of it, it may be worth writing a custom factory. Specialization of TopologyRefinerFactory class MESH should be done with care as the goal here is to maximize the performance of the conversion and so minimize overhead due to runtime validation. The template provides the high-level construction of the required topology vectors of the underlying Vtr. There are two ways to write such a factory provide only the face-vertex information for topology and let the factory infer all edges and other relationships, or provide the complete edge list and all other topological relationships directly. The latter is considerably more involved and described in a following section. The definition of TopologyRefinerFactory TopologyDescriptor provides a clear and complete example of constructing a TopologyRefiner with minimal topology information, i.e. the face-vertex list. The class template TopologyRefinerFactory MESH documents the needs here and the TopologyDescriptor instantiation and specialization should illustrate that. Custom Factory for Direct Conversion Fully specializing a factory for direct conversion is needed only for those requiring ultimate control and is not generally recommended. It is recommended that one of the previous two methods initially be used to convert your mesh topology into a TopologyRefiner. If the conversion performance is critical, or significant enough to warrant improvement, then it is worth writing a factory for full topological conversion. Writing a custom factory requires the specificationspecialization of two methods with the following purpose specify the sizes of topological data so that vectors can be pre-allocated assign the topological data to the newly allocated vectors As noted above, the assumption here is that the clients boundary-rep knows best how to retrieve the data that we require most efficiently. After the factory class gathers sizing information and allocates appropriate memory, the factory provides the client with locations of the appropriate tables to be populated using the same Array classes and interface used to access the tables. The client is expected to load a complete topological description along with additional optional data, i.e. the six topological relations required by Vtr, oriented when manifold sharpness values for edges andor vertices optional additional tags related to the components, e.g. holes optional values-per-face for face-varying channels optional This approach requires dealing directly with edges, unlike the other two. In order to convert edges into a TopologyRefiners representation, the edges need to be expressed as a collection of known size N -- each of which is referred to directly by indices 0,N-1. This can be awkward for representations such as half-edge or quad-edge that do not treat the instance of an edge uniquely. Particular care is also necessary when representing non-manifold features. The previous two approaches will construct non-manifold features as required from the face-vertex list -- dealing with degenerate edges and other non-manifold features as encountered. When directly translating full topology it is necessary to tag non-manifold features, and also to ensure that certain edge relationships are satisfied in their presence. More details are available with the assembly methods of the factory class template. While there is plenty of opportunity for user error here, that is no different from any other conversion process. Given that Far controls the construction process through the Factory class, we do have ample opportunity to insert runtime validation, and to vary that level of validation at any time on an instance of the Factory. The factory does provide run-time validation on the topology constructed that can be used for debugging purposes. A common base class has been created for the factory class, i.e. template class MESH class TopologyRefinerFactory  public TopologyRefinerFactoryBase both to provide common code independent of MESH and also potentially to protect core code from unwanted specialization. FarPrimvarRefiner PrimvarRefiner supports refinement of arbitrary primvar data at the locations of topological vertices. A PrimvarRefiner accesses topology data directly from a TopologyRefiner. Different methods are provided to support three different classes of primvar interpolation. These methods may be used to refine primvar data to a specified refinement level. Interpolate... Interpolate using vertex weights InterpolateVarying... Interpolate using linear weights InterpolateFaceVarying... Interpolate using face-varying weights Additional methods allow primvar data to be interpolated to the final limit surface including the calculation of first derivative tangents. Limitdst Interpolate to the limit surface using vertex weights Limitdst, dstTan1, dstTan2 Interpolate including first derivatives to the limit surface using vertex weights LimitFaceVarying... Interpolate to the limit surface using face-varying weights PrimarRefiner provides a straightforward interface for refining primvar data, but depending on the application use case, it can be more efficient to create and use a StencilTable , or PatchTable , to refine primvar data. FarPatchTable The patch table is a serialized topology representation. This container is generated using FarPatchTableFactory from an instance FarTopologyRefiner after a refinement has been applied. The FarPatchTableFactory traverses the data-structures of the TopologyRefiner and serializes the sub-faces into collections of bi-linear and bi-cubic patches as dictated by the refinement mode uniform or adaptive. The patches are then sorted into arrays based on their types. Release Notes 3.0.0 The organization and API of FarPatchTable is likely to change in the 3.1 release to accommodate additional functionality including smooth face-varying interpolation on patches, and dynamic feature adaptive isolation DFAS, and patch evaluation of Loop subdivision surfaces. Patch Arrays The patch table is a collection of control vertex indices. Meshes are decomposed into a collection of patches, which can be of different types. Each type has different requirements for the internal organization of its control-vertices. A PatchArray contains a sequence of multiple patches that share a common set of attributes. While all patches in a PatchArray will have the same type, each patch in the array is associated with a distinct PatchParam which specifies additional information about the individual patch. Each PatchArray contains a patch Descriptor that provides the fundamental description of the patches in the array. The PatchArray ArrayRange provides the indices necessary to track the records of individual patches in the table. Patch Types The following are the different patch types that can be represented in the PatchTable Patch Type CVs Description NON_PATCH na Undefined patch type POINTS 1 Points  useful for cage drawing LINES 2 Lines  useful for cage drawing QUADS 4 Bi-linear quads-only patches TRIANGLES 3 Bi-linear triangles-only mesh LOOP na Loop patch currently unsupported REGULAR 16 B-spline Basis patches GREGORY 4 Legacy Gregory patches GREGORY_BOUNDARY 4 Legacy Gregory Boundary patches GREGORY_BASIS 20 Gregory Basis patches The type of a patch dictates the number of control vertices expected in the table as well as the method used to evaluate values. Patch Parameterization Each patch represents a specific portion of the parametric space of the coarse topological face identified by the PatchParam FaceId. As topological refinement progresses through successive levels, each resulting patch corresponds to a smaller and smaller subdomain of the face. The PatchParam UV origin describes the mapping from the uv domain of the patch to the uv subdomain of the topological face. We encode this uv origin using log2 integer values for compactness and efficiency. It is important to note that this uv parameterization is the intrinsic parameterization within a given patch or coarse face and is distinct from any client specified face-varying channel data. Patches which result from irregular coarse faces non-quad faces in the Catmark scheme, or non-trianglular faces in the Loop scheme are offset by the one additional level needed to quadrangulate or triangulate the irregular face. A patch along an interpolated boundary edge is supported by an incomplete sets of control vertices. For consistency, patches in the PatchTable always have a full set of control vertex indices and the PatchParam Boundary bitmask identifies which control vertices are incomplete the incomplete control vertex indices are assigned values which duplicate the first valid index. Each bit in the boundary bitmask corresponds to one edge of the patch starting from the edge from the first vertex and continuing around the patch. With feature adaptive refinement, regular B-spline basis patches along interpolated boundaries will fall into one of the eight cases four boundary and four corner illustrated below Transition edges occur during feature adaptive refinement where a patch at one level of refinement is adjacent to pairs of patches at the next level of refinement. These T-junctions do not pose a problem when evaluating primvar data on patches, but they must be taken into consideration when tessellating patches e.g. while drawing in order to avoid cracks. The PatchParam Transition bitmask identifies the transition edges of a patch. Each bit in the bitmask corresponds to one edge of the patch just like the encoding of boundary edges. After refining an arbitrary mesh, any of the 16 possible transition edge configurations might occur. The method of handling transition edges is delegated to patch drawing code. Single-Crease Patches Using single-crease patches allows a mesh with creases to be represented with many fewer patches than would be needed otherwise. A single-crease patch is a variation of a regular BSpline patch with one additional crease sharpness parameter. Release Notes 3.0.0 Currently, the crease sharpness parameter is encoded as a separate PatchArray within the PatchTable. This parameter may be combined with the other PatchParam values in future releases. Also, evaluation of single-crease patches is currently only implemented for OSD patch drawing, but we expect to implement support in all of the evaluation code paths for future releases. Local Points The control vertices represented by a PatchTable are primarily refined points, i.e. points which result from applying the subdivision scheme uniformly or adaptively to the points of the coarse mesh. However, the final patches generated from irregular faces, e.g. patches incident on an extraordinary vertex might have a representation which requires additional local points. Release Notes 3.0.0 Currently, representations which require local points also require the use of a StencilTable to compute the values of local points. This requirement, as well as the rest of the API related to local points may change in future releases. Legacy Gregory Patches Using Gregory patches to approximate the surface at the final patches generated from irregular faces is an alternative representation which does not require any additional local points to be computed. Instead, when Legacy Gregory patches are used, the PatchTable must also have an alternative representation of the mesh topology encoded as a vertex valence table and a quad offsets table. Release Notes 3.0.0 The encoding and support for Legacy Gregory patches may change in future releases. The current encoding of the vertex valence and quad offsets tables may be prohibitively expensive for some use cases. FarStencilTable The base container for stencil data is the StencilTable class. As with most other Far entities, it has an associated StencilTableFactory that requires a TopologyRefiner Advantages Stencils are used to factorize the interpolation calculations that subdivision schema apply to vertices of smooth surfaces. If the topology being subdivided remains constant, factorizing the subdivision weights into stencils during a pre-compute pass yields substantial amortizations at run-time when re-posing the control cage. Factorizing the subdivision weights also allows to express each subdivided vertex as a weighted sum of vertices from the control cage. This step effectively removes any data inter-dependency between subdivided vertices  the computations of subdivision interpolation can be applied to each vertex in parallel without any barriers or constraint. The Osd classes leverage these properties by exploiting CPU and GPU parallelism. Principles Iterative subdivision algorithms converge towards the limit surface by successively refining the vertices of the coarse control cage. Each successive iteration interpolates the new vertices by applying polynomial weights to a basis of supporting vertices . The interpolation calculations for any given vertex can be broken down into sequences of multiply-add operations applied to the supporting vertices. Stencil table encodes a factorization of these weighted sums  each stencils is created by combining the list of control vertices from the 1-ring. With iterative subdivision, each refinement step is dependent upon the previous subdivision step being completed, and a substantial number of steps may be required in order approximate the limit  each subdivision step incurs an O4 n  growing amount of computations. Instead, once the weights of the contributing coarse control vertices for a given refined vertex have been factorized, it is possible to apply the stencil and directly obtain the interpolated vertex data without having to process the data for the intermediate refinement levels. Cascading Stencils Client-code can control the amount of factorization of the stencils  the tables can be generated with contributions all the way from a basis of coarse vertices, or reduced only to contributions from vertices from the previous level of refinement. The latter mode allows client-code to access and insert modifications to the vertex data at set refinement levels see hierarchical vertex edits . Once the edits have been applied by the client-code, another set of stencils can be used to smoothe the vertex data to a higher level of refinement. See implementation details, see the Far cascading stencil tutorial Limit Stencils Stencil tables can be trivially extended from discrete subdivided vertices to arbitrary locations on the limit surface. Aside from extraordinary points, every location on the limit surface can be expressed as a closed-form weighted average of a set of coarse control vertices from the 1-ring surrounding the face. The weight accumulation process is similar  the control cage is adaptively subdivided around extraordinary locations. A stencil is then generated for each limit location simply by factorizing the bi-cubic Bspline patch weights over those of the contributing basis of control-vertices. The use of bi-cubic patches also allows the accumulation of analytical derivatives, so limit stencils carry a set of weights for tangent vectors. Once the stencil table has been generated, limit stencils are the most direct and efficient method of evaluation of specific locations on the limit of a subdivision surface, starting from the coarse vertices of the control cage. Also just as discrete stencils, limit stencils that are factorized from coarse control vertices do not have inter-dependencies and can be evaluated in parallel. For implementation details, see the glStencilViewer code example. Sample Location On Extraordinary Faces Each stencil is associated with a singular parametric location on the coarse mesh. The parametric location is defined as face location and local 0.0 - 1.0 u,v triplet In the case of face that are not quads, a parametric sub-face quadrant needs to be identified. This can be done either explicitly or implicitly by using the unique ptex face indices for instance. Code example When the control vertices controlPoints move in space, the limit locations can be very efficiently recomputed simply by applying the blending weights to the series of coarse control vertices class StencilType  public  void Clear   memset  x , 0 , sizeof  StencilType   void AddWithWeight  StencilType const cv , float weight   x  cv . x  weight  y  cv . y  weight  z  cv . z  weight   float x , y , z   std  vector StencilType controlPoints , points , utan , vtan   Update points by applying stencils controlStencils . UpdateValues StencilType  controlPoints  0 , points  0    Update tangents by applying derivative stencils controlStencils . UpdateDerivs StencilType  controlPoints  0 , utan  0 , vtan  0   Generated on 2016-06-13 0020 UTC. User Docs API Docs Release Notes Forum", "tags": "", "loc":"far_overview.html"}, 
{"title":"Hierarchical Edits", "text":"Hierarchical Edits Hierarchical Edits 3.0.2 User Docs API Docs Release Notes Forum Github OSD_ARTICLE_TITLE Hierarchical Edits Hierarchical Edits Paths Vertex Edits Edge Edits Face Edits Hierarchical Edits To understand the hierarchical aspect of subdivision, we realize that subdivision itself leads to a natural hierarchy after the first level of subdivision, each face in a subdivision mesh subdivides to four quads in the Catmull-Clark scheme, or four triangles in the Loop scheme. This creates a parent and child relationship between the original face and the resulting four subdivided faces, which in turn leads to a hierarchy of subdivision as each child in turn subdivides. A hierarchical edit is an edit made to any one of the faces, edges, or vertices that arise anywhere during subdivision. Normally these subdivision components inherit values from their parents based on a set of subdivision rules that depend on the subdivision scheme. A hierarchical edit overrides these values. This allows for a compact specification of localized detail on a subdivision surface, without having to express information about the rest of the subdivision surface at the same level of detail. Release Notes 3.0.0 Hierarchical Edits have been marked as extended specification and support for hierarchical features has been removed from the 3.0 release. This decision allows for great simplifications of many areas of the subdivision algorithms. If we can identify legitimate use-cases for hierarchical tags, we will consider re-implementing them in future releases, as time and resources allow. Hierarchical Edits Paths In order to perform a hierarchical edit, we need to be able to name the subdivision component we are interested in, no matter where it may occur in the subdivision hierarchy. This leads us to a hierarchical path specification for faces, since once we have a face we can navigate to an incident edge or vertex by association. We note that in a subdivision mesh, a face always has incident vertices, which are labelled in relation to the face with an integer index starting at zero and in consecutive order according to the usual winding rules for subdivision surfaces. Faces also have incident edges, and these are labelled according to the origin vertex of the edge. In this diagram, the indices of the vertices of the base face are marked in red  so on the left we have an extraordinary Catmull-Clark face with five vertices labeled 0-4  and on the right we have a regular Catmull-Clark face with four vertices labelled 0-3 . The indices of the child faces are blue  note that in both the extraordinary and regular cases, the child faces are indexed the same way, i.e. the sub-face labeled n has one incident vertex that is the result of the subdivision of the parent vertex also labeled n in the parent face. Specifically, we note that the sub-face 1 in both the regular and extraordinary face is nearest to the vertex labelled 1 in the parent. The indices of the vertices of the child faces are labeled green , and this is where the difference lies between the extraordinary and regular case in the extraordinary case, vertex to vertex subdivision always results in a vertex labeled 0 , while in the regular case, vertex to vertex subdivision assigns the same index to the child vertex. Again, specifically, we note that the parent vertex indexed 1 in the extraordinary case has a child vertex 0 , while in the regular case the parent vertex indexed 1 actually has a child vertex that is indexed 1 . Note that this indexing scheme was chosen to maintain the property that the vertex labeled 0 always has the lowest uv parametric value on the face. By appending a vertex index to a face index, we can create a vertex path specification. For example,  655 2 3 0 specifies the 1st. vertex of the 3 rd. child face of the 2 nd. child face of the of the 655 th. face of the subdivision mesh. Vertex Edits Vertex hierarchical edits can modify the value or the sharpness of primitive variables for vertices and sub-vertices anywhere in the subdivision hierarchy. The edits are performed using either an add or a set operator. set indicates the primitive variable value or sharpness is to be set directly to the values specified. add adds a value to the normal result computed via standard subdivision rules. In other words, this operation allows value offsets to be applied to the mesh at any level of the hierarchy. Edge Edits Edge hierarchical edits can only modify the sharpness of primitive variables for edges and sub-edges anywhere in the subdivision hierarchy. Face Edits Face hierarchical edits can modify several properties of faces and sub-faces anywhere in the subdivision hierarchy. Modifiable properties include The set or add operators modify the value of primitive variables associated with faces. The hole operation introduces holes missing faces into the subdivision mesh at any level in the subdivision hierarchy. The faces will be deleted, and none of their children will appear you cannot unhole a face if any ancestor is a hole . This operation takes no float or string arguments. Generated on 2016-06-13 0020 UTC. User Docs API Docs Release Notes Forum", "tags": "", "loc":"hedits.html"}, 
{"title":"far_tutorial_4.cpp", "text":"far_tutorial_4.cpp far_tutorial_4.cpp 3.0.2 User Docs API Docs Release Notes Forum Github OSD_ARTICLE_TITLE httpsgithub.comPixarAnimationStudiosOpenSubdivblobmastertutorialsfartutorial_4far_tutorial_4.cpp ------------------------------------------------------------------------------  Tutorial description   This tutorial shows how to create and manipulate FarStencilTable. We use the  factorized stencils to interpolate vertex primvar data buffers.  include opensubdivfartopologyDescriptor.h include opensubdivfarstencilTable.h include opensubdivfarstencilTableFactory.h include cstdio include cstring ------------------------------------------------------------------------------  Vertex container implementation.  struct Vertex   Minimal required interface ---------------------- Vertex    Vertex  Vertex const src   _position  0   src . _position  0  _position  1   src . _position  1  _position  2   src . _position  2   void Clear  void   0   _position  0   _position  1   _position  2   0.0f   void AddWithWeight  Vertex const src , float weight   _position  0   weight  src . _position  0  _position  1   weight  src . _position  1  _position  2   weight  src . _position  2    Public interface ------------------------------------ void SetPosition  float x , float y , float z   _position  0   x  _position  1   y  _position  2   z   float const  GetPosition  const  return _position   private  float _position  3   ------------------------------------------------------------------------------  Cube geometry from catmark_cube.h static float g_verts  24    - 0.5f , - 0.5f , 0.5f , 0.5f , - 0.5f , 0.5f , - 0.5f , 0.5f , 0.5f , 0.5f , 0.5f , 0.5f , - 0.5f , 0.5f , - 0.5f , 0.5f , 0.5f , - 0.5f , - 0.5f , - 0.5f , - 0.5f , 0.5f , - 0.5f , - 0.5f  static int g_nverts  8 , g_nfaces  6  static int g_vertsperface  6    4 , 4 , 4 , 4 , 4 , 4  static int g_vertIndices  24    0 , 1 , 3 , 2 , 2 , 3 , 5 , 4 , 4 , 5 , 7 , 6 , 6 , 7 , 1 , 0 , 1 , 7 , 5 , 3 , 6 , 0 , 2 , 4  using namespace OpenSubdiv  static Far  TopologyRefiner  createTopologyRefiner  ------------------------------------------------------------------------------ int main  int , char     Generate some FarTopologyRefiner see far_tutorial_0 for details. Far  TopologyRefiner  refiner  createTopologyRefiner   Uniformly refine the topolgy up to maxlevel. int maxlevel  3  refiner - RefineUniform  Far  TopologyRefiner  UniformOptions  maxlevel   Use the FarStencilTable factory to create discrete stencil table  note we only want stencils for the highest refinement level. Far  StencilTableFactory  Options options  options . generateIntermediateLevels  false  options . generateOffsets  true  Far  StencilTable const  stencilTable  Far  StencilTableFactory  Create   refiner , options   Allocate vertex primvar buffer 1 stencil for each vertex int nstencils  stencilTable - GetNumStencils  std  vector Vertex vertexBuffer  nstencils   Quick dirty re-cast of the primvar data from our cube  this is where you would drive shape deformations every frame Vertex  controlValues  reinterpret_cast Vertex   g_verts    This section would be applied every frame after control vertices have  been moved.  Apply stencils on the control vertex data to update the primvar data  of the refined vertices. stencilTable - UpdateValues  controlValues , vertexBuffer  0     Visualization with Maya  print a MEL script that generates particles  at the location of the refined vertices printf  particle  for  int i  0  i  int  vertexBuffer . size   i   float const  pos  vertexBuffer  i . GetPosition  printf  -p f f f n , pos  0 , pos  1 , pos  2   printf  -c 1 n   delete refiner  delete stencilTable   ------------------------------------------------------------------------------ static Far  TopologyRefiner  createTopologyRefiner    Populate a topology descriptor with our raw data. typedef Far  TopologyDescriptor Descriptor  Sdc  SchemeType type  OpenSubdiv  Sdc  SCHEME_CATMARK  Sdc  Options options  options . SetVtxBoundaryInterpolation  Sdc  Options  VTX_BOUNDARY_EDGE_ONLY  Descriptor desc  desc . numVertices  g_nverts  desc . numFaces  g_nfaces  desc . numVertsPerFace  g_vertsperface  desc . vertIndicesPerFace  g_vertIndices   Instantiate a FarTopologyRefiner from the descriptor. return Far  TopologyRefinerFactory Descriptor  Create  desc , Far  TopologyRefinerFactory Descriptor  Options  type , options   ------------------------------------------------------------------------------ Generated on 2016-06-13 0020 UTC. User Docs API Docs Release Notes Forum", "tags": "", "loc":"far_tutorial_4.html"}, 
{"title":"glShareTopology", "text":"glShareTopology glShareTopology 3.0.2 User Docs API Docs Release Notes Forum Github OSD_ARTICLE_TITLE SYNOPSIS DESCRIPTION OPTIONS SEE ALSO SYNOPSIS glShareTopology  -d isolation level  objfiles DESCRIPTION glShareTopology is a stand-alone application that showcases the implementation of topology instancing across Compute contexts. Multiple controls are available to experiment with the algorithms. OPTIONS -d isolation level Select the desired isolation level of adaptive feature isolation. This can be useful when trying to load large pieces of geometry. SEE ALSO Other examples  glViewer , glShareTopology , glStencilViewer , glPtexViewer , glEvalLimit , glFVarViewer , dxViewer , dxPtexViewer , mayaPolySmooth , Generated on 2016-06-13 0020 UTC. User Docs API Docs Release Notes Forum", "tags": "", "loc":"glsharetopology.html"}, 
{"title":"References", "text":"References References 3.0.2 User Docs API Docs Release Notes Forum Github OSD_ARTICLE_TITLE References References Analytic Displacement Mapping using Hardware Tessellation Matthias Niessner, Charles Loop ACM Transactions on Graphics, Vol. 32 No. 3 Article 26 June 2013 httpresearch.microsoft.comen-usumpeoplecloopTOG2013.pdf httpdoi.org10.11452487228.2487234 Feature Adaptive GPU Rendering of Catmull-Clark Subdivision Surfaces Matthias Niessner, Charles Loop, Mark Meyer, and Tony DeRose ACM Transactions on Graphics, Vol. 31 No. 1 Article 6 January 2012 httpresearch.microsoft.comen-usumpeopleclooptog2012.pdf httpdoi.org10.11452077341.2077347 Efficient Evaluation of Semi-Smooth Creases in Catmull-Clark Subdivision Surfaces Matthias Niessner, Charles Loop, and Guenter Greiner. Eurographics Proceedings, Cagliari, 2012 httpresearch.microsoft.comen-usumpeoplecloopEG2012.pdf httpdoi.org10.2312confEG2012short041-044 Approximating Subdivision Surfaces with Gregory Patches for Hardware Tessellation Charles Loop, Scott Schaefer, Tianyun Ni, Ignacio Castano SIGGRAPH Asia Conference Proceedings 2009 httpwww.dgp.toronto.edupeoplestamrealityResearchpdfsig98.pdf httpdoi.org10.11451661412.1618497 GPU Smoothing of Quad Meshes T. L. Ni, Y. Yeo, A. Myles, V. Goel and J. Peters Proc. IEEE SMI 2008 httpwww.cise.ufl.eduresearchSurfLabpaperssmi08.pdf httpdoi.org10.1109SMI.2008.4547938 Fast Parallel Construction of Smooth Surfaces from Meshes with TriQuadPent Facets A. Myles and T. Ni and J. Peters Eurographics Symposium on Geometry Processing 2008 httpswww.cise.ufl.eduresearchSurfLabpapers08poly.pdf httpdoi.org10.1111j.1467-8659.2008.01276.x Approximating Catmull-Clark Subdivision Surfaces with Bicubic Patches Charles Loop, Scott Schaefer ACM Transactions on Graphics, Vol. 27 No. 1 Article 8 March 2008 httpresearch.microsoft.comen-usumpeoplecloopacctog.pdf httpdoi.org10.11451330511.1330519 Rapid Evaluation of Catmull-Clark Subdivision Surfaces Jeffrey Bolz and Peter Schroder Web3D Proceedings 2002 httpwww.multires.caltech.edupubsfastsubd.pdf httpdoi.org10.1145504502.504505 Piecewise Smooth Subdivision Surfaces with Normal Control Henning Biermann, Adi Levin and Denis Zorin SIGGRAPH 2000 Conference Proceedings httpmrl.nyu.edudzorinpapersbiermann2000pss.pdf httpdoi.org10.1145344779.344841 Subdivision for Modeling and Animation Denis Zorin, Peter Schroder Course Notes of SIGGRAPH 1999 httpwww.multires.caltech.edupubssig99notes.pdf Exact Evaluation of Catmull-Clark Subdivision Surfaces at Arbitrary Parameter Values Jos Stam SIGGRAPH 98 Conference Proceedings, Annual Conference Series, July 1998 httpwww.dgp.toronto.edupeoplestamrealityResearchpdfsig98.pdf httpdoi.org10.1145280814.280945 Subdivision Surfaces in Character Animation Tony DeRose, Michael Kass, Tien Truong Proceedings of SIGGRAPH 1998 httpgraphics.pixar.comlibraryGeripaper.pdf httpdoi.org10.1145280814.280826 Efficient, Fair Interpolation Using Catmull-Clark Surfaces Mark Halstead, Michael Kass, Tony DeRose SIGGRAPH 93 Conference Proceedings httpgraphics.pixar.comlibraryFairSubdivisionpaper.pdf httpdoi.org10.1145166117.166121 Recursively generated B-spline surfaces on arbitrary topological meshes Catmull, E. Clark, J. Computer-Aided Design 10 6 1978 httpdoi.org10.10160010-448528782990110-0 Generated on 2016-06-13 0020 UTC. User Docs API Docs Release Notes Forum", "tags": "", "loc":"references.html"}, 
{"title":"far_tutorial_6.cpp", "text":"far_tutorial_6.cpp far_tutorial_6.cpp 3.0.2 User Docs API Docs Release Notes Forum Github OSD_ARTICLE_TITLE httpsgithub.comPixarAnimationStudiosOpenSubdivblobmastertutorialsfartutorial_6far_tutorial_6.cpp ------------------------------------------------------------------------------  Tutorial description   This tutorial shows how to interpolate surface limits at arbitrary  parametric locations using feature adaptive FarPatchTables.   The evaluation of the limit surface at arbitrary locations requires the  adaptive isolation of topological features. This process converts the  input polygonal control cage into a collection of bi-cubic patches.   We can then evaluate the patches at random parametric locations and  obtain analytical positions and tangents on the limit surface.   The results are dumped into a MEL script that draws streak particle  systems that show the tangent and bi-tangent at the random samples locations.  include opensubdivfartopologyDescriptor.h include opensubdivfarprimvarRefiner.h include opensubdivfarpatchTableFactory.h include opensubdivfarpatchMap.h include opensubdivfarptexIndices.h include cassert include cstdio include cstring include cfloat using namespace OpenSubdiv   pyramid geometry from catmark_pyramid_crease0.h static int const g_nverts  5  static float const g_verts  24    0.0f , 0.0f , 2.0f , 0.0f , - 2.0f , 0.0f , 2.0f , 0.0f , 0.0f , 0.0f , 2.0f , 0.0f , - 2.0f , 0.0f , 0.0f ,  static int const g_vertsperface  5    3 , 3 , 3 , 3 , 4  static int const g_nfaces  5  static int const g_faceverts  16    0 , 1 , 2 , 0 , 2 , 3 , 0 , 3 , 4 , 0 , 4 , 1 , 4 , 3 , 2 , 1  static int const g_ncreases  4  static int const g_creaseverts  8    4 , 3 , 3 , 2 , 2 , 1 , 1 , 4  static float const g_creaseweights  4    3.0f , 3.0f , 3.0f , 3.0f   Creates a FarTopologyRefiner from the pyramid shape above static Far  TopologyRefiner  createTopologyRefiner  ------------------------------------------------------------------------------  Vertex container implementation.  struct Vertex   Minimal required interface ---------------------- Vertex    void Clear  void   0   point  0   point  1   point  2   0.0f   void AddWithWeight  Vertex const src , float weight   point  0   weight  src . point  0  point  1   weight  src . point  1  point  2   weight  src . point  2   float point  3   ------------------------------------------------------------------------------  Limit frame container implementation -- this interface is not strictly  required but follows a similar pattern to Vertex.  struct LimitFrame  void Clear  void   0   point  0   point  1   point  2   0.0f  deriv1  0   deriv1  1   deriv1  2   0.0f  deriv2  0   deriv2  1   deriv2  2   0.0f   void AddWithWeight  Vertex const src , float weight , float d1Weight , float d2Weight   point  0   weight  src . point  0  point  1   weight  src . point  1  point  2   weight  src . point  2  deriv1  0   d1Weight  src . point  0  deriv1  1   d1Weight  src . point  1  deriv1  2   d1Weight  src . point  2  deriv2  0   d2Weight  src . point  0  deriv2  1   d2Weight  src . point  1  deriv2  2   d2Weight  src . point  2   float point  3 , deriv1  3 , deriv2  3   ------------------------------------------------------------------------------ int main  int , char     Generate a FarTopologyRefiner see far_tutorial_0 for details. Far  TopologyRefiner  refiner  createTopologyRefiner   Adaptively refine the topology with an isolation level capped at 3  because the sharpest crease in the shape is 3.0f in g_creaseweights int maxIsolation  3  refiner - RefineAdaptive  Far  TopologyRefiner  AdaptiveOptions  maxIsolation   Generate a set of FarPatchTable that we will use to evaluate the  surface limit Far  PatchTableFactory  Options patchOptions  patchOptions . endCapType  Far  PatchTableFactory  Options  ENDCAP_GREGORY_BASIS  Far  PatchTable const  patchTable  Far  PatchTableFactory  Create   refiner , patchOptions   Compute the total number of points we need to evaluate patchtable.  we use local points around extraordinary features. int nRefinerVertices  refiner - GetNumVerticesTotal  int nLocalPoints  patchTable - GetNumLocalPoints   Create a buffer to hold the position of the refined verts and  local points, then copy the coarse positions at the beginning. std  vector Vertex verts  nRefinerVertices  nLocalPoints  memcpy  verts  0 , g_verts , g_nverts  3  sizeof  float   Interpolate vertex primvar data  they are the control vertices  of the limit patches see far_tutorial_0 for details Vertex  src  verts  0  for  int level  1  level  maxIsolation   level   Vertex  dst  src  refiner - GetLevel  level - 1 . GetNumVertices  Far  PrimvarRefiner   refiner . Interpolate  level , src , dst  src  dst    Evaluate local points from interpolated vertex primvars. patchTable - ComputeLocalPointValues  verts  0 , verts  nRefinerVertices   Create a FarPatchMap to help locating patches in the table Far  PatchMap patchmap   patchTable   Create a FarPtexIndices to help find indices of ptex faces. Far  PtexIndices ptexIndices   refiner   Generate random samples on each ptex face int nsamples  200 , nfaces  ptexIndices . GetNumFaces  std  vector LimitFrame samples  nsamples  nfaces  srand  static_cast int  2147483647   float pWeights  20 , dsWeights  20 , dtWeights  20  for  int face  0 , count  0  face nfaces   face   for  int sample  0  sample nsamples   sample ,  count   float s   float  rand    float  RAND_MAX , t   float  rand    float  RAND_MAX   Locate the patch corresponding to the face ptex idx and s,t Far  PatchTable  PatchHandle const  handle  patchmap . FindPatch  face , s , t  assert  handle   Evaluate the patch weights, identify the CVs and compute the limit frame patchTable - EvaluateBasis   handle , s , t , pWeights , dsWeights , dtWeights  Far  ConstIndexArray cvs  patchTable - GetPatchVertices   handle  LimitFrame dst  samples  count  dst . Clear  for  int cv  0  cv cvs . size   cv   dst . AddWithWeight  verts  cvs  cv , pWeights  cv , dsWeights  cv , dtWeights  cv       Visualization with Maya  print a MEL script that generates particles  at the location of the limit vertices int nsamples   int  samples . size  printf  file -f -new n   Output particle positions for the tangent printf  particle -n deriv1  for  int sample  0  sample nsamples   sample   float const  pos  samples  sample . point  printf  -p f f f n , pos  0 , pos  1 , pos  2   printf   n   Set per-particle direction using the limit tangent display as Streak printf  setAttr  deriv1.particleRenderType  6 n  printf  setAttr  deriv1.velocity  -type  vectorArray  d , nsamples  for  int sample  0  sample nsamples   sample   float const  tan1  samples  sample . deriv1  printf  f f f n , tan1  0 , tan1  1 , tan1  2   printf   n   Output particle positions for the bi-tangent printf  particle -n deriv2  for  int sample  0  sample nsamples   sample   float const  pos  samples  sample . point  printf  -p f f f n , pos  0 , pos  1 , pos  2   printf   n  printf  setAttr  deriv2.particleRenderType  6 n  printf  setAttr  deriv2.velocity  -type  vectorArray  d , nsamples  for  int sample  0  sample nsamples   sample   float const  tan2  samples  sample . deriv2  printf  f f f n , tan2  0 , tan2  1 , tan2  2   printf   n   Exercise to the reader  cross tangent bi-tangent for limit  surface normal...  Force Maya DAG update to see the result in the viewport printf  currentTime -edit currentTime -q n  printf  select deriv1Shape deriv2Shape n    ------------------------------------------------------------------------------ static Far  TopologyRefiner  createTopologyRefiner   typedef Far  TopologyDescriptor Descriptor  Sdc  SchemeType type  OpenSubdiv  Sdc  SCHEME_CATMARK  Sdc  Options options  options . SetVtxBoundaryInterpolation  Sdc  Options  VTX_BOUNDARY_EDGE_ONLY  Descriptor desc  desc . numVertices  g_nverts  desc . numFaces  g_nfaces  desc . numVertsPerFace  g_vertsperface  desc . vertIndicesPerFace  g_faceverts  desc . numCreases  g_ncreases  desc . creaseVertexIndexPairs  g_creaseverts  desc . creaseWeights  g_creaseweights   Instantiate a FarTopologyRefiner from the descriptor. Far  TopologyRefiner  refiner  Far  TopologyRefinerFactory Descriptor  Create  desc , Far  TopologyRefinerFactory Descriptor  Options  type , options  return refiner   Generated on 2016-06-13 0020 UTC. User Docs API Docs Release Notes Forum", "tags": "", "loc":"far_tutorial_6.html"}, 
{"title":"Porting Guide 2.x to 3.0", "text":"Porting Guide 2.x to 3.0 Porting Guide 2.x to 3.0 3.0.2 User Docs API Docs Release Notes Forum Github OSD_ARTICLE_TITLE Porting Guide 2.x to 3.0 Source Code Organization Hbr Layer Translation Subdivision Schemes and Options in Sdc Specifying Face Varying Topology and Options Far Layer Translation Ordering of Refined Vertices Osd Layer Translation Controller Objects ComputeContext, DrawContext EvalLimitContext OsdMesh OsdKernelBatch OsdVertex Feature Adaptive Shader Changes End Cap Strategies Changes to Subdivision Build Support for Combining 2.x and 3.0 Porting Guide 2.x to 3.0 This document is a high-level description of how to port exiting OpenSubdiv 2.x code to use OpenSubdiv 3.0. NOTE If your questions are not answered here, please contact us on the OpenSubdiv forum and we will be happy to help Source Code Organization Given the scale of functional changes that were being made to the public interface, we took the opportunity in 3.0 to update the coding style and organization -- most notably making use of namespaces for each library. Subdirectory Namespace Relevance hbr NA Historical, no longer used sdc Sdc New, low-level, public options, constants, etc. vtr Vtr New, internal use, topology representation far Far Revised, similar functionality with new API osd Osd Revised, similar functionality with new API Hbr Layer Translation Client mesh topology is now translated into an instance of FarTopologyRefiner instead of HbrMesh. OpenSubdiv 2.x OpenSubdiv 3.0 HbrMesh VTX_TYPE FarTopologyRefiner The FarTopologyRefiner is now the core representation of topology from which all other major classes in Far and Osd are constructed. It was designed to support efficient refinement uniform or sparse of a base mesh of arbitrary topology no manifold restrictions. Once constructed it can be directly refined to meet some need, or passed to other contexts that will refine it to meet their needs. In contrast to directly assembling an HbrMesh, the TopologyRefiner, like other classes in Far, requires a Factory class for its construction. One of the early goals of these factories was to allow a client to convert their existing boundary representation -- with its full topological traversal abilities -- directly into the TopologyRefiners representation. While this is now possible, this also represents the most complex construction process and is only recommended for usage where this conversion process is critical. Details on how to construct a TopologyRefiner can be found in the Far overview documentation. Additionally, documentation for FarTopologyRefinerFactory MESH outlines the requirements, and a Far tutorial tutorialsfartutorial_1 provides an example of a factory for directly converting HbrMeshes to TopologyRefiners. Its worth a reminder here that FarTopologyRefiner contains only topological information which does include sharpness, since that is considered relating to subdivision topology and not the positions or other data associated with a mesh. While HbrMesh T required some definition of a vertex type T and dimensions of face-varying data, TopologyRefiner is more clearly separated from the data. So the construction of the TopologyRefiner does not involve data specification at all. Subdivision Schemes and Options in Sdc The creation of a new TopologyRefiner requires specification of a subdivision scheme and a set of options that are applicable to all schemes. With HbrMesh, the scheme was specified by declaring a static instance of a specific subclass of a subdivision object, and the options were specified with a number of methods on the different classes. Such general information about the schemes has now been encapsulated in the Sdc layer for use throughout OpenSubdiv. The subdivision scheme is now a simple enumerated type SdcSchemeType and the entire set of options that can be applied to a scheme is encapsulated in a single simple struct of flags and enumerated types SdcOptions. OpenSubdiv 2.x OpenSubdiv 3.0 HbrMesh T SetInterpolateBoundaryMethod SdcOptionsSetVtxBoundaryInterpolation HbrMesh T SetFVarInterpolateBoundaryMethod SdcOptionsSetFVarLinearInterpolation HbrSubdivision T SetCreaseSubdivisionMethod SdcOptionsSetCreasingMethod Specifying Face Varying Topology and Options Both the way in which face varying data is associated with a mesh and the options used to control its interpolation have changed. The documentation on Compatibility with OpenSubdiv 2.x details the equivalence of interpolation options between Hbr and the new SdcOptionsFVarLinearInterpolation enum, while the section on Face Varying Interpolation illustrates their effects. Face varying data is now specified by index rather than by value, or as often stated, it is specified topologically. Just as vertices for faces are specified by indices into a potential buffer of positions, face varying values are specified by indices into a potential buffer of values. Both vertices and face varying values frequently referred to as FVarValues in the API are assigned and associated with the corners of all faces. In many cases this will simplify representation as many common geometry container formats such as Obj or Alembic specify texture coordinates the same way. For other cases, where a value per face-corner is provided with no indication of which values incident each vertex should be considered shared, it will be necessary to determine shared indices for values at each vertex if any non-linear interpolation is desired. Far Layer Translation While TopologyRefiner was introduced into Far as the new intermediate topology representation, several other changes were made to classes in Far to provide more modular building blocks for use by the Osd layer or directly. OpenSubdiv 2.x OpenSubdiv 3.0 FarMesh U NA, no longer needed FarSubdivisionTables FarStencilTable FarPatchTables FarPatchTable Ordering of Refined Vertices The FarMesh was previously responsible for refining an HbrMesh -- generating new vertices and faces in successive levels of refinement in the FarSubdivisionTables. Vertices were grouped and reordered from the native ordering of HbrMesh so that vertices requiring similar processing were consecutive. Such grouping alleviated most of the idiosyncrasies of HbrMeshs native ordering but not all. FarToplogyRefiner is inherently a collection of refinement levels, and within each refined level so excluding the base level, all components are still grouped for the same reasons. There are two issues here though the ordering of these groups has changed though an option exists to preserve it the ordering of components within these groups is not guaranteed to have been preserved Vertices in a refined level are grouped according to the type of component in the parent level from which they originated, i.e. some vertices originate from the center of a face face-vertices, some from an edge edge-vertices and some from a vertex vertex-vertices. Note that there is a conflict in terminology here -- face-vertices and edge-vertices most often refer to vertices incident a face or edge -- but for the sake of this discussion, we use them to refer to the component from which a child vertex originates. The following table shows the ordering of these groups in 2.x and the two choices available in 3.0. The option is the orderVerticesFromFacesFirst flag that can be set in the Option structs passed to the uniform and adaptive refinement methods of TopologyRefiner Version and option Vertex group ordering 2.x face-vertices, edge-vertices, vertex-vertices 3.0 default vertex-vertices, face-vertices, edge-vertices 3.0 orderVerticesFromFacesFirst  true face-vertices, edge-vertices, vertex-vertices The decision to change the default ordering was based on common feedback the rationale was to allow a trivial mapping from vertices in the cage to their descendants at all refinement levels. While the grouping is fundamental to the refinement process, the ordering of the groups is internally flexible, and the full set of possible orderings can be made publicly available in future if there is demand for such flexibility. The ordering of vertices within these groups was never clearly defined given the way that HbrMesh applied its refinement. For example, for the face-vertices in a level, it was never clear which face-vertices would be first as it depended on the order in which HbrMesh traversed the parent faces and generated them. Given one face, HbrMesh would often visit neighboring faces first before moving to the next intended face. The ordering with FarTopologyRefiner is much clearer and predictable. Using the face-vertices as an example, the order of the face-vertices in level N1 is identical to the order of the parent faces in level N from which they originated. So if we have face-vertices Vi , Vj and Vk at some level, originating from faces Fi , Fj and Fk in the previous level, they will be ordered in increasing order of i , j and k . For uniform refinement the ordering of face vertices Vi will therefore exactly match the ordering of the parent faces Fi . For adaptive or otherwise sparse refinement, the subset of Vi will be ordered similarly, just with components missing from those not refined. The same is true of all vertices, i.e. edge-vertices and vertex-vertices, and also for other components in refined levels, i.e. the child faces and edges. For child faces and edges, more than one will originate from the same parent face or edge. In addition to the overall ordering based on the parent faces or edges, another ordering is imposed on multiple children originating from the same face or edge. They will be ordered based on the corner or end-vertex with which they are associated. In the case of refined faces, another way to view the ordering is to consider the way that faces are originally defined -- by specifying the set of vertices for the corners of each face, often aggregated into a single large array. The ordering of the set of refined faces for each level will correspond directly to such an array of vertices per face in the previous level. Osd Layer Translation Two big changes in the 3.0 API have allowed the Osd layer to be significantly simpler, the first is the move to stencil tables from subdivision tables and the second is shader simplification. With this refactoring, the focus has been to use more meaningful names and to make the data contained within an object more apparent. Controller Objects The API-specific ComputeController has been replaced with the Evaluator . It reflects the fact that stencil compute batches are significantly simpler than subdivision table compute batches. The name Evaluator was chosen with the hope that is more meaningful than the generic ComputeController moniker the Evaluator evaluates stencil and patch tables. In the 2.x code base, subdiv level buffers were always required to be allocated contiguously, however in 3.0 with the shift to stencil tables, this strict allocation scheme is no longer required. As a result, the EvalStencils and EvalPatches methods now accept both a source and a destination descriptor. OpenSubdiv 2.x OpenSubdiv 3.0 ComputeControllerRefine Osd...EvaluatorEvalStencils ComputeControllerSynchronize Osd...EvaluatorSynchronize EvalStencilsControllerUpdateValues Osd...EvaluatorEvalStencils EvalStencilsControllerUpdateDerivs Osd...EvaluatorEvalStencils EvalLimitControllerEvalLimitSample Osd...EvaluatorEvalPatches Also note that OsdVertexDescriptor has been renamed, however its data members and semantic purpose remains the same OpenSubdiv 2.x OpenSubdiv 3.0 OsdVertexBufferDescriptor OsdBufferDescriptor ComputeContext, DrawContext ComputeContext and DrawContext have been replaced with API-specific StencilTable and PatchTable objects, for example OsdGLStencilTableSSBO. OpenSubdiv 2.x OpenSubdiv 3.0 ComputeContext Osd...StencilTable e.g. GLStencilTableTBO EvalStencilsContext Osd...StencilTable DrawContext Osd...PatchTable e.g. GLPatchTable EvalLimitContext The data stored in EvalLimitContext has been merged into the Evaluator class as well. EvalCoords have been moved into their own type, OsdPatchCoords. The primary change here is that the PTex face ID is no longer part of the data structure, rather the client can use a FarPatchMap to convert from PTex face ID to a FarPatchTablePatchHandle. OpenSubdiv 2.x OpenSubdiv 3.0 EvalLimitContext PatchTable EvalLimitContextEvalCoords OsdPatchCoords types.h OsdMesh While not strictly required, OsdMesh is still supported in 3.0 as convenience API for allocating buffers. OsdMesh serves as a simple way to allocate all required data, in the location required by the API for example, GPU buffers for OpenGL. OsdKernelBatch No translation, it is no longer part of the API. OsdVertex No translation, it is no longer part of the API. Feature Adaptive Shader Changes In 3.0, the feature adaptive screen-space tessellation shaders have been dramatically simplified, and the client-facing API has changed dramatically as well. The primary shift is to reduce the total number of shader combinations, and as a result, some of the complexity management mechanisms are no longer necessary. In the discussion below, some key changes are highlighted, but deep integrations may require additional discussion please feel free to send follow up questions to the OpenSubdiv google group. The number of feature adaptive shaders has been reduced from N to exactly 1 or 2, depending on how end-caps are handled. Osd layer no longer compiles shaders, rather it returns shader source for the client to compile. This source is obtained via OsdGLSLHLSLPatchShaderSource. The API exposed in shaders to access patch-based data has been consolidated and formalized, see osdglslPatchCommon.glsl and osdhlslPatchCommon.hlsl for details. Patches are no longer rotated and transition patches have been eliminated, simplifying PatchDescriptor to a 4 bits. Additionally, FarPatchTablesDescriptor has been moved into its own class in the Far namespace. The following table outlines the API translation between 2.x and 3.0 OpenSubdiv 2.x OpenSubdiv 3.0 OsdDrawContextPatchDescriptor NA, no longer needed. OsdDrawContextPatchArray OSdPatchArray types.h FarPatchTablesPatchDescriptor FarPatchDescriptor patchDescriptor.h FarPatchTablesPatchArray made private. End Cap Strategies By default, OpenSubdiv uses Gregory patches to approximate the patches around extraordinary vertices at the maximum isolation level, this process is referred to as end-capping . If ENDCAP_BSPLINE_BASIS is specified to PatchTableFactoryOptions, BSpline patches are used, which gives less accuracy, but it makes possible to render an entire mesh in a single draw call. Both patches require additional control points that are not part of the mesh, we refer to these as local points . In 3.0, the local points of those patches are computed by applying a stencil table to refined vertices to construct a new stencil table for the local points. Since this new stencil table is topologically compatible with the primary stencil table for refinement, it is convenient and efficient to splice those stencil tables together. This splicing can be done in the following way FarStencilTable const refineStencils  FarStencilTableFactoryCreatetopologyRefiner FarPatchTable cosnt patchTable  FarPatchTableFactoryCreatetopologyRefiner FarStencilTable const localPointStencils  patchTable- GetLocalPointStencilTable FarStencilTable const splicedStencils  FarStencilTableFactoryAppendLocalPointStencilTablestopologyRefiner, refineStencils, localPointStencils NOTE Once the spliced stencil table is created, the refined stencils can be released, but the local point stencils are owned by patchTable, it should not be released. OpenSubdiv 3.0 also supports 2.x style Gregory patches, if ENDCAP_LEGACY_GREGORY is specified to PatchTableFactoryOptions. In this case, such an extra stencil splicing isnt needed, however clients must still bind additional buffers VertexValence buffer and QuadOffsets buffer. See OsdGLLegacyGregoryPatchTable for additional details. Changes to Subdivision The refactoring of OpenSubdiv 3.0 data representations presented a unique opportunity to revisit some corners of the subdivision specification and remove or update some legacy features -- none of which was taken lightly. More details are provided in Subdivision Compatibility , while the following offers a quick overview All face-varying interpolation options have been combined into a single enum. Vertex interpolation options have been renamed or removed The naming of the standard creasing method has changed from Normal to Uniform . Unused legacy modes of the smoothtriangle option have been removed. The averaging of Chaikin creasing with infinitely sharp edges has changed. Support for Hierarchical Edits has been removed. Build Support for Combining 2.x and 3.0 Running OpenSubdiv 2.0 and 3.0 in a single process is supported, however some special care must be taken to avoid namespace collisions, both in terms of run-time symbols avoid using OpenSubdivOsd , for example and in terms of build-time search paths. To support both OpenSubdiv 2.0 and 3.0 in your build environment, you can prefix the header install directory of OpenSubdiv 3.0. Do this using the build flag CMAKE_INCDIR_BASE when configuring cmake i.e. -DCMAKE_INCDIR_BASEincludeopensubdiv3 and then including files from opensubdiv3... in client code. Generated on 2016-06-13 0020 UTC. User Docs API Docs Release Notes Forum", "tags": "", "loc":"porting.html"}, 
{"title":"Vtr Overview", "text":"Vtr Overview Vtr Overview 3.0.2 User Docs API Docs Release Notes Forum Github OSD_ARTICLE_TITLE Vectorized Topology Representation Vtr VtrLevel Topological Relationships Memory Efficiency VtrRefinement Parent-child and child-parent relationships Data flexibility Vectorized Topology Representation Vtr Vtr consists of a suite of classes that collectively provide an intermediate representation of topology that supports efficient refinement. Vtr is intended for internal use only and is currently accessed through the Far layer by the FarTopologyRefiner , which assembles these Vtr classes to meet the topological and refinement needs of the Far layer. What follows is therefore more intended to provide insite into the underlying architecture than to describe particular usage. For documentation more relevant to direct usage, proceed to the Far section previously noted. Vtr is vectorized in that its topological data is stored more as a collection of vectors of primitive elements rather than as the faces, vertices and edges that make up many other topological representations. It is essentially a structure-of-arrays SOA approach to topology in contrast to the more common array-of-structures pattern found in many other topological representations. Vtrs use of vectors allows it to be fairly efficient in its use of memory and similarly efficient to refine, but the topology is fixed once defined. Vtr classes are purely topological. They are even more independent of the representation of vertices, faces, etc. than Hbr in that they are not even parameterized by an interface to such components. So the same set of Vtr objects can eventually be used to serve more than one representation of these components. The primary requirement is that a mesh be expressable as an indexable set i.e. a vector or array of vertices, edges and faces. The index of a component uniquely identifies it and properties are retrieved by referring to it by index. Its worth qualifying the term topological here and elsewhere -- we generally refer to topology as subdivision topology rather than mesh topology . A subdivision hierarchy is impacted by the presence of semi-sharp creasing, as the subdivision rules change in response to that creasing. So subdivision topology includes the sharpness values assigned to edges and vertices that affect the semi-sharp creasing. The two primary classes in Vtr consist of VtrLevel - a class representing complete vertex topology for a level VtrRefinement - a class mapping a parent VtrLevel to a child level Others exist to represent the following selection and appropriate tagging of components for sparse refinement divergence of face-varying topology from the vertex topology mapping between face-varying topology at successive levels common low-level utilities, e.g. simple array classes VtrLevel VtrLevel is a complete topological description of a subdivision level, with the topological relations, sharpness values and component tags all stored in vectors literally stdvectors, but easily changed via typedefs. There are no classes or objects for the mesh component types i.e. faces, edges and vertices but simply an integer index to identify each. It can be viewed as a structure-of-arrays representation of the topology any property related to a particular component is stored in an array and accessible using the index identifying that component. So with no classes the for the components, its difficult to say what constitutes a vertex or a face  they are each the sum of all the fields scattered amongst the many vectors included. Level represents a single level of a potential hierarchy and is capable of representing the complete base mesh. There are no members that relate data in one level to any other, either below or above. As such, any Level can be used as the base level for a new subdivision hierarchy potentially more than one. All relationships between separate levels are maintained in the VtrRefinement class. Topological Relationships Level requires the definition of and associations between a fixed set of indexable components for all three component types, i.e. an explicit edge list in addition to the expected set of vertices and faces. There are no explicit component objects in the representation, only an integer index  VtrIndex  identifying each component within the set and data associated with that component in the various vectors. The topology is stored as six sets of incident relations between the components two each for the two other component types incident each component type, i.e. for each face, its incident vertices and incident edges for each edge, its incident vertices and incident faces for each vertex, its incident edges and incident faces The collection of incidence relations is a vectorized variation of AIF the Adjacency and Incidence Framework . The set of these six incidence relations is not minimal only four are required, but that set excludes the most desired face-vertex relation but all six are kept and maintained to facilitate faster refinement. While the sizes of several vectors are directly proportional to the number of vertices, edges or faces to which the data is associated, the sizes of some of the vectors for these relations is more cumulative and so additional vectors of offsets is required typical of the face-vertex list commonly used as the minimal definition of mesh topology. Vectors for the sharpness values associated with crease edges and corner vertices are included and so sized according to the number of edges and vertices, along with additional tags for the components that may be helpful to refinement i.e. the type of subdivision Rule associated with each vertex. A Level is really just a container for data in a subdivision level, and so its public methods are primarily to access that data. Modification of the data is protected and only made available to classes that are intended to construct Levels  currently the Far factory class that is responsible for building the base level, and the VtrRefinement class that constructs subsequent levels during refinement. Memory Efficiency One of the advantages in storing data in what is essentially a structure-of-arrays, rather than the array-of-structures more typical of topological representations, is that we can be more selective about memory usage in some cases. Particularly in the case of uniform refinement, when the data in subsequent levels is typically 4x its predecessor, we can minimize what we either generate or keep around at each level. For instance, if only a face-list is required at the finest level, we only need to generate one of the six topological relations the vertices incident each face. When we do keep Levels around in memory as is the case with the FarTopologyRefiner  we do have do have the opportunity to prune what is not strictly necessary after the refinement. Just as with construction, whatever classes are privileged to construct a Level are likely those that will be privileged to prune its contents when needed. The current implementation of Level is far from optimal though -- there are opportunities for improvement. After one level of subdivision, the faces in a Level will be either all quads or tris. Having specializations for these cases and using the more general case in support of N-sided faces for the base level only is one possibility. Levels also allocate dozens of vectors in which to store all data. Since these vectors are of fixed size once created, they could be aggregated by partitioning one or a smaller number of larger block of memory into the desired pieces. The desire to make some of these improvements is part of why Vtr is not directly exposed for public use and instead exposed via Far. VtrRefinement While VtrLevel contains the topology for each subdivision level, VtrRefinement is responsible for creating a new level via refinement of an existing one, and for maintaining the relationships between the components in the parent and child levels. So a simplified view of a subdivision hierarchy with Vtr is a set of Levels with a Refinement between each successive pair. Refinement is a friend of Level and will populate a child level from a parent given a set of refinement parameters. Aside from parameters related to data or depth, there are two kinds of refinement supported uniform and sparse. The latter sparse refinement requires selection of an arbitrary set of components -- any dependent or neighboring components that are required for the limit will be automatically included. So feature-adaptive refinement is just one form of this selective sparse refinement, the criteria being the topological features of interest creases and extra-ordinary vertices. The intent is to eventually provide more flexibility to facilitate the refinement of particular regions of interest or more dynamicadaptive needs. Refinement has also been subclassed according to the type of topological split being performed, i.e. splitting all faces into quads or tris via the QuadRefinement and TriRefinement subclasses. As noted with VtrLevel , there is further room for improvement in memory andor performance here by combining more optimal specializations for both Refinement and Level -- with consideration of separating the uniform and sparse cases. Parent-child and child-parent relationships While Refinement populates a new child Level as part of its refinement operation, it also accumulates the relationships between the parent and child level and as with Level , this data is stored in vectors indexable by the components. The associations between components in the two levels was initially only uni-directional child components were associated with incident components of a parent component based on the parent components topology, so we had a parent-to-child mapping one to many. Storing the reverse child-to-parent mapping was avoided to reduce memory particularly in the case of uniform refinement as it often was not necessary, but a growing need for it, particularly in the case of sparse feature-adaptive refinement, lead to it being included. Data flexibility One of the advantages of the structure-of-arrays representation in both Level and Refinement is that we can make more dynamic choices about what type of data we choose to allocate and use based on needs. For instance, we can choose between maintaining the parent-child or child-parent mapping in Refinement , or both if needed, and we can remove one if no longer necessary. An active example of this is uniform refinement if we only require the face-vertex list at the finest subdivision level, there is no need to generate a complete topological description of that level as would be required of more traditional representations, and given that level is 4x the magnitude of its parent, the savings are considerable. Currently there is nothing specific to a subdivision scheme in the refinement other than the type of topological splitting to apply. The refinement does subdivide sharpness values for creasing, but that too is independent of scheme. Tags were added to the base level that are propagated through the refinement and these too are dependent on the scheme, but are applied externally. Generated on 2016-06-13 0020 UTC. User Docs API Docs Release Notes Forum", "tags": "", "loc":"vtr_overview.html"}, 
{"title":"hbr_tutorial_2.cpp", "text":"hbr_tutorial_2.cpp hbr_tutorial_2.cpp 3.0.2 User Docs API Docs Release Notes Forum Github OSD_ARTICLE_TITLE httpsgithub.comPixarAnimationStudiosOpenSubdivblobmastertutorialshbrtutorial_2hbr_tutorial_2.cpp ------------------------------------------------------------------------------  Tutorial description   This tutorial shows how to subdivide uniformly a simple Hbr mesh. We are  building upon previous turtorials and assuming a fully instantiated mesh  we start with an HbrMesh pointer initialized from the same pyramid shape  used in hbr_tutorial_0.   We then apply the Refine function sequentially to all the faces in the  mesh to generate several levels of uniform subdivision. The resulting data  is then dumped to the terminal in Wavefront OBJ format for inspection.  include opensubdivhbrmesh.h include opensubdivhbrcatmark.h include cassert include cstdio ------------------------------------------------------------------------------   For this tutorial, we have to flesh the Vertex class further. Note that now  the copy constructor, Clear and AddwithWeight methods have been  implemented to interpolate our float3 position data.   This vertex specialization pattern leaves client-code free to implement  arbitrary vertex primvar data schemes or none at all to conserve efficiency  struct Vertex   Hbr minimal required interface ---------------------- Vertex    Vertex  int i    Vertex  Vertex const src   _position  0   src . _position  0  _position  1   src . _position  1  _position  2   src . _position  2   void Clear  void   0   _position  0   _position  1   _position  2   0.0f   void AddWithWeight  Vertex const src , float weight   _position  0   weight  src . _position  0  _position  1   weight  src . _position  1  _position  2   weight  src . _position  2   void AddVaryingWithWeight  Vertex const , float     Public interface ------------------------------------ void SetPosition  float x , float y , float z   _position  0   x  _position  1   y  _position  2   z   const float  GetPosition  const  return _position   private  float _position  3   typedef OpenSubdiv  HbrMesh Vertex Hmesh  typedef OpenSubdiv  HbrFace Vertex Hface  typedef OpenSubdiv  HbrVertex Vertex Hvertex  typedef OpenSubdiv  HbrHalfedge Vertex Hhalfedge  Hmesh  createMesh  ------------------------------------------------------------------------------ int main  int , char    Hmesh  hmesh  createMesh  int maxlevel  2 ,  2 levels of subdivision firstface  0 ,  marker to the first face index of level 2 firstvertex  0   marker to the first vertex index of level 2  Refine the mesh to maxlevel for  int level  0  level maxlevel   level    Total number of faces in the mesh, across all levels   Mote this function iterates over the list of faces and can be slow int nfaces  hmesh - GetNumFaces  if  level   maxlevel - 1    Save our vertex marker firstvertex  hmesh - GetNumVertices    Iterate over the faces of the current level of subdivision for  int face  firstface  face nfaces   face   Hface  f  hmesh - GetFace  face   Mote  hole tags would have to be dealt with here. f - Refine    Save our face index marker for the next level firstface  nfaces     Output OBJ of the highest level refined -----------  Print vertex positions int nverts  hmesh - GetNumVertices  for  int vert  firstvertex  vert nverts   vert   float const  pos  hmesh - GetVertex  vert  - GetData . GetPosition  printf  v f f f n , pos  0 , pos  1 , pos  2    Print faces for  int face  firstface  face hmesh - GetNumFaces   face   Hface  f  hmesh - GetFace  face  assert  f - GetNumVertices   4  printf  f  for  int vert  0  vert 4   vert    OBJ uses 1-based arrays printf  d , f - GetVertex  vert  - GetID  - firstvertex  1   printf  n     ------------------------------------------------------------------------------  Creates an Hbr mesh   see hbr_tutorial_0 and hbr_tutorial_1 for more details  Hmesh  createMesh    Pyramid geometry from catmark_pyramid.h static float verts  5  3    0.0f , 0.0f , 2.0f ,  0.0f , - 2.0f , 0.0f ,  2.0f , 0.0f , 0.0f ,  0.0f , 2.0f , 0.0f ,  - 2.0f , 0.0f , 0.0f  static int nverts  5 , nfaces  5  static int facenverts  5    3 , 3 , 3 , 3 , 4  static int faceverts  16    0 , 1 , 2 , 0 , 2 , 3 , 0 , 3 , 4 , 0 , 4 , 1 , 4 , 3 , 2 , 1  OpenSubdiv  HbrCatmarkSubdivision Vertex  catmark  new OpenSubdiv  HbrCatmarkSubdivision Vertex  Hmesh  hmesh  new Hmesh  catmark   Populate the vertices Vertex v  for  int i  0  i nverts   i   v . SetPosition  verts  i  0 , verts  i  1 , verts  i  2  hmesh - NewVertex  i , v    Create the topology int  fv  faceverts  for  int i  0  i nfaces   i   int nv  facenverts  i  bool valid  true  for  int j  0  j nv  j    Hvertex const  origin  hmesh - GetVertex  fv  j ,  destination  hmesh - GetVertex  fv  j  1   nv  Hhalfedge const  opposite  destination - GetEdge  origin   Make sure that the vertices exist in the mesh if  origin  NULL or destination  NULL   printf  An edge was specified that connected a nonexistent vertex n  valid  false  break    Check for a degenerate edge if  origin  destination   printf  An edge was specified that connected a vertex to itself n  valid  false  break    Check that no more than 2 faces are adjacent to the edge if  opposite and opposite - GetOpposite    printf  A non-manifold edge incident to more than 2 faces was found n  valid  false  break    Check that the edge is unique and oriented properly if  origin - GetEdge  destination   printf  An edge connecting two vertices was specified more than once. Its likely that an incident face was flipped n  valid  false  break    if  valid   hmesh - NewFace  nv , fv , 0   else  printf  Skipped face d n , i   fv  nv   hmesh - SetInterpolateBoundaryMethod  Hmesh  k_InterpolateBoundaryEdgeOnly  hmesh - Finish  return hmesh   ------------------------------------------------------------------------------ Generated on 2016-06-13 0021 UTC. User Docs API Docs Release Notes Forum", "tags": "", "loc":"hbr_tutorial_2.html"}, 
{"title":"Using Textures", "text":"Using Textures Using Textures 3.0.2 User Docs API Docs Release Notes Forum Github OSD_ARTICLE_TITLE Ptex Face Indices Non-quad topology Filtering Ptex Face Indices Non-quad topology Filtering Content under development.... Generated on 2016-06-13 0020 UTC. User Docs API Docs Release Notes Forum", "tags": "", "loc":"using_osd_textures.html"}, 
{"title":"glStencilViewer", "text":"glStencilViewer glStencilViewer 3.0.2 User Docs API Docs Release Notes Forum Github OSD_ARTICLE_TITLE SYNOPSIS DESCRIPTION OPTIONS SEE ALSO SYNOPSIS glStencilViewer  -d isolation level   -f  objfiles DESCRIPTION glStencilViewer is a stand-alone application that showcases the application of pre-computed stencil tables to a collection of geometric test shapes. Multiple controls are available to experiment with the algorithms. OPTIONS -d isolation level Select the desired isolation level of adaptive feature isolation. This can be useful when trying to load large pieces of geometry. -f Launches the application in full-screen mode if is supported by GLFW on the OS SEE ALSO Other examples  glViewer , glShareTopology , glStencilViewer , glPtexViewer , glEvalLimit , glFVarViewer , dxViewer , dxPtexViewer , mayaPolySmooth , Generated on 2016-06-13 0020 UTC. User Docs API Docs Release Notes Forum", "tags": "", "loc":"glstencilviewer.html"}, 
{"title":"hbr_tutorial_1.cpp", "text":"hbr_tutorial_1.cpp hbr_tutorial_1.cpp 3.0.2 User Docs API Docs Release Notes Forum Github OSD_ARTICLE_TITLE httpsgithub.comPixarAnimationStudiosOpenSubdivblobmastertutorialshbrtutorial_1hbr_tutorial_1.cpp ------------------------------------------------------------------------------  Tutorial description   This tutorial shows how to safely create Hbr meshes from arbitrary topology.  Because Hbr is a half-edge data structure, it cannot represeent non-manifold  topology. Ensuring that the geometry used is manifold is a requirement to use  Hbr safely. This tutorial presents some simple tests to detect inappropriate  topology.  include opensubdivhbrmesh.h include opensubdivhbrcatmark.h include cstdio ------------------------------------------------------------------------------ struct Vertex   Hbr minimal required interface ---------------------- Vertex    Vertex  int i    Vertex  Vertex const src   _position  0   src . _position  0  _position  1   src . _position  1  _position  2   src . _position  2   void Clear  void   0    void AddWithWeight  Vertex const , float    void AddVaryingWithWeight  Vertex const , float     Public interface ------------------------------------ void SetPosition  float x , float y , float z   _position  0   x  _position  1   y  _position  2   z   const float  GetPosition  const  return _position   private  float _position  3   typedef OpenSubdiv  HbrMesh Vertex Hmesh  typedef OpenSubdiv  HbrFace Vertex Hface  typedef OpenSubdiv  HbrVertex Vertex Hvertex  typedef OpenSubdiv  HbrHalfedge Vertex Hhalfedge  ------------------------------------------------------------------------------  Non-manifold geometry from catmark_fan.h   o             o    f2      o------------o------------o             f0   f1       o------------ o------------o   The shared edge of a fan is adjacent to 3 faces, and therefore non-manifold.  static float verts  8  3    - 1.0 , 0.0 , - 1.0 ,  - 1.0 , 0.0 , 0.0 ,  0.0 , 0.0 , 0.0 ,  0.0 , 0.0 , - 1.0 ,  1.0 , 0.0 , 0.0 ,  1.0 , 0.0 , - 1.0 ,  0.0 , 1.0 , 0.0 ,  0.0 , 1.0 , - 1.0  static int nverts  8 , nfaces  3  static int facenverts  3    4 , 4 , 4  static int faceverts  12    0 , 1 , 2 , 3 , 3 , 2 , 4 , 5 , 3 , 2 , 6 , 7  ------------------------------------------------------------------------------ int main  int , char    OpenSubdiv  HbrCatmarkSubdivision Vertex  catmark  new OpenSubdiv  HbrCatmarkSubdivision Vertex  Hmesh  hmesh  new Hmesh  catmark  Vertex v  for  int i  0  i nverts   i   v . SetPosition  verts  i  0 , verts  i  1 , verts  i  2  hmesh - NewVertex  i , v    Create the topology int  fv  faceverts  for  int i  0  i nfaces   i   int nv  facenverts  i  bool valid  true  for  int j  0  j nv  j    Hvertex const  origin  hmesh - GetVertex  fv  j ,  destination  hmesh - GetVertex  fv  j  1   nv  Hhalfedge const  opposite  destination - GetEdge  origin   Make sure that the vertices exist in the mesh if  origin  NULL or destination  NULL   printf  An edge was specified that connected a nonexistent vertex n  valid  false  break    Check for a degenerate edge if  origin  destination   printf  An edge was specified that connected a vertex to itself n  valid  false  break    Check that no more than 2 faces are adjacent to the edge if  opposite and opposite - GetOpposite    printf  A non-manifold edge incident to more than 2 faces was found n  valid  false  break    Check that the edge is unique and oriented properly if  origin - GetEdge  destination   printf  An edge connecting two vertices was specified more than once. Its likely that an incident face was flipped n  valid  false  break    if  valid   hmesh - NewFace  nv , fv , 0   else  printf  Skipped face d n , i   fv  nv   hmesh - SetInterpolateBoundaryMethod  Hmesh  k_InterpolateBoundaryEdgeOnly  hmesh - Finish  printf  Created a fan with d faces and d vertices. n , hmesh - GetNumFaces , hmesh - GetNumVertices  delete hmesh  delete catmark   ------------------------------------------------------------------------------ Generated on 2016-06-13 0020 UTC. User Docs API Docs Release Notes Forum", "tags": "", "loc":"hbr_tutorial_1.html"}, 
{"title":"glPtexViewer", "text":"glPtexViewer glPtexViewer 3.0.2 User Docs API Docs Release Notes Forum Github OSD_ARTICLE_TITLE SYNOPSIS DESCRIPTION OPTIONS Keyboard Controls SEE ALSO SYNOPSIS glPtexViewer  -e environment map   -d HDR diffuse map   -s HDR specular map   -y   --disp displacement scale   --bump bump scale   -l isolation level   -c animation loops   -f  ptex color file ptex displacement file ptex occlusion file ptex specular file objfiles DESCRIPTION glPtexViewer is a stand-alone application that showcases advanced HDR shading with color, displacement, occlusion and specular ptex maps. Multiple controls are available to experiment with the algorithms. OPTIONS -e environment map A low dynamic range spherical environment map used as a background. Ideally, a color-normalized version of the HDR light probe. -d HDR diffuse map An HDR file containing a diffuse environment map typically they are low resolution blurry hemispherical convolutions of the environment light probe. -s environment map An HDR file containing a specular environment map. --disp displacement scale A scalar multiplier for the shader displacement values. --bump displacement scale A scalar multiplier for the shader bump values. -y Swap Z-up geometry to Y-UP. -l isolation level Select the desired isolation level of adaptive feature isolation. This can be useful when trying to load large pieces of geometry. -c animation frequency Number of repetitions of the animation loop default0 is infinite -f Launches the application in full-screen mode if is supported by GLFW on the OS ptex color file A ptex file containing RGB channels read as material albedo color. ptex displacement file A single-channel ptex file preferably float precision containing the displacement values. ptex occlusion file A single-channel ptex file preferably 8 bits precision containing a pre-computed ambient occlusion signal. ptex specular file A single-channel ptex file preferably 8 bits precision applied to modulate the specular reflectance of the material objfiles A sequence of obj files used as an animation loop the topology has to match the data contained in all the ptex files  Keyboard Controls q  quit esc  hide GUI x  save screenshot f  fit frame -  increase  decrease tessellation rate r  reload and re - compile the shader files e  draw normals SEE ALSO Other examples  glViewer , glShareTopology , glStencilViewer , glPtexViewer , glEvalLimit , glFVarViewer , dxViewer , dxPtexViewer , mayaPolySmooth , Generated on 2016-06-13 0020 UTC. User Docs API Docs Release Notes Forum", "tags": "", "loc":"glptexviewer.html"}, 
{"title":"Downloads", "text":"Downloads Downloads 3.0.2 User Docs API Docs Release Notes Forum Github OSD_ARTICLE_TITLE Coupe Car Coupe Car Note  we can use javascripts buttons to trigger download see button-download or we can just paste regular ReST hyperlinks to the files here. Direct links probably more reliable though. Coupe car maya Download Coupe car obj Download EULA OpenSubdiv is covered by a modified Apache 2.0 license included below, and is free to use for commercial or non-commercial use. All Pixar patents in the area of subdivision surface algorithms have also been released for public use. We welcome any involvement in the development or extension of this code in fact, we would love it. Please contact us if you are interested. Copyright 2013 Pixar Licensed under the Apache License, Version 2.0 the Apache License  with the following modification you may not use this file except in compliance with the Apache License and the following modification to it Section 6. Trademarks. is deleted and replaced with 6. Trademarks. This License does not grant permission to use the trade names, trademarks, service marks, or product names of the Licensor and its affiliates, except as required to comply with Section 4c of the License and to reproduce the content of the NOTICE file. You may obtain a copy of the Apache License at httpwww.apache.orglicensesLICENSE-2.0 Unless required by applicable law or agreed to in writing, software distributed under the Apache License with the above modification is distributed on an AS IS BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the Apache License for the specific language governing permissions and limitations under the Apache License. Accept Generated on 2016-06-13 0020 UTC. User Docs API Docs Release Notes Forum", "tags": "", "loc":"downloads.html"}, 
{"title":"hbr_tutorial_0.cpp", "text":"hbr_tutorial_0.cpp hbr_tutorial_0.cpp 3.0.2 User Docs API Docs Release Notes Forum Github OSD_ARTICLE_TITLE httpsgithub.comPixarAnimationStudiosOpenSubdivblobmastertutorialshbrtutorial_0hbr_tutorial_0.cpp ------------------------------------------------------------------------------  Tutorial description   This tutorial presents in a very succint way the requisite steps to  instantiate an Hbr mesh from simple topological data.  include opensubdivhbrmesh.h include opensubdivhbrcatmark.h include cstdio ------------------------------------------------------------------------------  Vertex container implementation.   The HbrMesh T class is a templated interface that expects a vertex class to  perform interpolation on arbitrary vertex data.   For the template specialization of the HbrMesh interface to be met, our  Vertex object to implement a minimal set of constructors and member  functions.   Since we are not going to subdivide the mesh, the struct presented here has  been left minimalistic. The only customization added to our container was to  provide storage and accessors for the position of a 3D vertex.  struct Vertex   Hbr minimal required interface ---------------------- Vertex    Vertex  int i    Vertex  Vertex const src   _position  0   src . _position  0  _position  1   src . _position  1  _position  2   src . _position  2   void Clear  void   0    void AddWithWeight  Vertex const , float    void AddVaryingWithWeight  Vertex const , float     Public interface ------------------------------------ void SetPosition  float x , float y , float z   _position  0   x  _position  1   y  _position  2   z   const float  GetPosition  const  return _position   private  float _position  3   typedef OpenSubdiv  HbrMesh Vertex Hmesh  typedef OpenSubdiv  HbrFace Vertex Hface  typedef OpenSubdiv  HbrVertex Vertex Hvertex  typedef OpenSubdiv  HbrHalfedge Vertex Hhalfedge  ------------------------------------------------------------------------------  Pyramid geometry from catmark_pyramid.h static float verts  5  3    0.0f , 0.0f , 2.0f ,  0.0f , - 2.0f , 0.0f ,  2.0f , 0.0f , 0.0f ,  0.0f , 2.0f , 0.0f ,  - 2.0f , 0.0f , 0.0f  static int nverts  5 , nfaces  5  static int facenverts  5    3 , 3 , 3 , 3 , 4  static int faceverts  16    0 , 1 , 2 , 0 , 2 , 3 , 0 , 3 , 4 , 0 , 4 , 1 , 4 , 3 , 2 , 1  ------------------------------------------------------------------------------ int main  int , char     Create a subdivision scheme Catmull-Clark here OpenSubdiv  HbrCatmarkSubdivision Vertex  catmark  new OpenSubdiv  HbrCatmarkSubdivision Vertex   Create an empty Hbr mesh Hmesh  hmesh  new Hmesh  catmark   Populate the vertices Vertex v  for  int i  0  i nverts   i    Primitive variable data must be set here in our case we set  the 3D position of the vertex. v . SetPosition  verts  i  0 , verts  i  1 , verts  i  2   Add the vertex to the mesh. hmesh - NewVertex  i , v    Create the topology int  fv  faceverts  for  int i  0  i nfaces   i   int nv  facenverts  i  hmesh - NewFace  nv , fv , 0  fv  nv    Set subdivision options   By default vertex interpolation is set to none on boundaries, which  can produce un-expected results, so we change it to edge-only .  hmesh - SetInterpolateBoundaryMethod  Hmesh  k_InterpolateBoundaryEdgeOnly   Call Finish to finalize the data structures before using the mesh. hmesh - Finish  printf  Created a pyramid with d faces and d vertices. n , hmesh - GetNumFaces , hmesh - GetNumVertices  delete hmesh  delete catmark   ------------------------------------------------------------------------------ Generated on 2016-06-13 0020 UTC. User Docs API Docs Release Notes Forum", "tags": "", "loc":"hbr_tutorial_0.html"}, 
{"title":"Introduction", "text":"Introduction Introduction 3.0.2 User Docs API Docs Release Notes Forum Github OSD_ARTICLE_TITLE Introduction Why Fast Subdivision  Research Heritage Licensing Contributing External Resources Introduction OpenSubdiv is a set of open source libraries that implement high performance subdivision surface subdiv evaluation on massively parallel CPU and GPU architectures. This code path is optimized for drawing deforming surfaces with static topology at interactive framerates. OpenSubdiv is an API ready to be integrated into 3rd party digital content creation tools. It is not an application, nor a tool that can be used directly to create digital assets. Why Fast Subdivision  Subdivision surfaces are commonly used for final rendering of character shapes for a smooth and controllable limit surfaces. However, subdivision surfaces in interactive apps are typically drawn as their polygonal control hulls because of performance. The polygonal control hull is an approximation that is offset from the true limit surface. Looking at an approximation in the interactive app makes it difficult to see exact contact, like fingers touching a potion bottle or hands touching a cheek. It also makes it difficult to see poke-throughs in cloth simulation if the skin and cloth are both approximations. This problem is particularly bad when one character is much larger than another and unequal subdiv face sizes cause approximation errors to be magnified. Maya and Pixars proprietary Presto animation system can take 100ms to subdivide a character of 30,000 polygons to the second level of subdivision 500,000 polygons. Being able to perform the same operation in less than 3ms allows the user to interact with the smooth, accurate limit surface at all times. Research The new GPU technology behind OpenSubdiv is the result of a joint research effort between Pixar and Microsoft. Feature Adaptive GPU Rendering of Catmull-Clark Subdivision Surfaces Matthias Niessner, Charles Loop, Mark Meyer, and Tony DeRose ACM Transactions on Graphics, Vol. 31 No. 1 Article 6 January 2012 httpresearch.microsoft.comen-usumpeopleclooptog2012.pdf Efficient Evaluation of Semi-Smooth Creases in Catmull-Clark Subdivision Surfaces Matthias Niessner, Charles Loop, and Guenter Greiner. Eurographics Proceedings, Cagliari, 2012 httpresearch.microsoft.comen-usumpeoplecloopEG2012.pdf Analytic Displacement Mapping using Hardware Tessellation Matthias Niessner, Charles Loop ACM Transactions on Graphics, Vol. 32 No. 3 Article 26 June 2013 httpresearch.microsoft.comen-usumpeoplecloopTOG2013.pdf Heritage This is the fifth-generation subdiv library in use by Pixars proprietary animation system in a lineage that started with code written by Tony DeRose and Tien Truong for Geris Game in 1996. Each generation has been a from-scratch rewrite that has built upon our experience using subdivision surfaces to make animated films. This code is live, so Pixars changes to OpenSubdiv for current and future films will be released as open source at the same time they are rolled out to Pixar animation production. Subdivision for Modeling and Animation Denis Zorin, Peter Schroder Course Notes of SIGGRAPH 1999 httpwww.multires.caltech.edupubssig99notes.pdf Subdivision Surfaces in Character Animation Tony DeRose, Michael Kass, Tien Truong Proceedings of SIGGRAPH 1998 httpgraphics.pixar.comlibraryGeripaper.pdf Recursively generated B-spline surfaces on arbitrary topological meshes Catmull, E. Clark, J. Computer-Aided Design 10 6 1978 Licensing OpenSubdiv is covered by the Apache License, and is free to use for commercial or non-commercial use. This is the same code that Pixar uses internally for animated film production. Our intent is to encourage a geometry standard for subdivision surfaces, by providing consistent i.e. yielding the same limit surface, high performance implementations on a variety of platforms. Why Apache We were looking for a commercial-friendly license that would convey our patents to the end users. This quickly narrowed the field to Microsoft Public License or Apache. Initially we chose MSPL because it handled trademarks better. But at the request of several companies we gave Apache another look, and decided to go with Apache with a very slight modification that simply says you cannot use any contributors trademarks. In other words, you can use OpenSubdiv to make a product, but you cannot use a Luxo Lamp or other character, etc. when marketing your product. License Header Contributing For details on how to contribute to OpenSubdiv, see the page on Contributing External Resources Microsoft Research Charles Loop Matthias Niessner Pixar Research Pixar R D Portal Generated on 2016-06-13 0020 UTC. User Docs API Docs Release Notes Forum", "tags": "", "loc":"intro.html"}, 
{"title":"Subdivision Surfaces", "text":"Subdivision Surfaces Subdivision Surfaces 3.0.2 User Docs API Docs Release Notes Forum Github OSD_ARTICLE_TITLE Introduction Arbitrary Topology Uniform Subdivision Feature Adaptive Subdivision Uniform or Adaptive  Boundary Interpolation Rules Face-Varying Interpolation Rules Semi-Sharp Creases Chaikin Rule Triangle Subdivision Rule Manifold vs Non-Manifold Geometry Non-Manifold Fan Non-Manifold Disconnected Vertex Introduction The most common way to model complex smooth surfaces is by using a patchwork of bicubic patches such as BSplines or NURBS. However, while they do provide a reliable smooth limit surface definition, bi-cubic patch surfaces are limited to 2-dimensional topologies, which only describe a very small fraction of real-world shapes. This fundamental parametric limitation requires authoring tools to implement at least the following functionalities smooth trimming seams stitching Both trimming and stitching need to guarantee the smoothness of the model both spatially and temporally as the model is animated. Attempting to meet these requirements introduces a lot of expensive computations and complexity. Subdivision surfaces on the other hand can represent arbitrary topologies, and therefore are not constrained by these difficulties. Arbitrary Topology A subdivision surface, like a parametric surface, is described by its control mesh of points. The surface itself can approximate or interpolate this control mesh while being piecewise smooth. But where polygonal surfaces require large numbers of data points to approximate being smooth, a subdivision surface is smooth - meaning that polygonal artifacts are never present, no matter how the surface animates or how closely it is viewed. Ordinary cubic B-spline surfaces are rectangular grids of tensor-product patches. Subdivision surfaces generalize these to control grids with arbitrary connectivity. Uniform Subdivision Applies a uniform refinement scheme to the coarse faces of a mesh. The mesh converges closer to the limit surface with each iteration of the algorithm. Feature Adaptive Subdivision Applies a progressive refinement strategy to isolate irregular features. The resulting vertices can be assembled into bi-cubic patches defining the limit surface. Uniform or Adaptive  Feature adaptive refinement can be much more economical in terms of time and memory use, but the best method to use depends on application needs. The following table identifies several factors to consider Uniform Feature Adaptive Exponential geometry growth Geometry growth close to linear and occuring only in the neighborhood of isolated topological features Current implementation only produces bi-linear patches for uniform refinement Current implementation only produces bi-cubic patches for feature adaptive refinement All face-varying interpolation rules supported at refined vertex locations Currently, only bi-linear face-varying interpolation is supported for bi-cubic patches Release Notes 3.0.0 Full support for bi-cubic face-varying interpolation is a significant feature which will be supported in future releases. Feature adaptive refinement for the Loop subdivision scheme is expected to be supported in future releases. Boundary Interpolation Rules Boundary interpolation rules control how boundary edges and vertices are interpolated. The following rule sets can be applied to vertex data interpolation Mode Behavior VTX_BOUNDARY_NONE No boundary edge interpolation should occur instead boundary faces are tagged as holes so that the boundary edge-chain continues to support the adjacent interior faces but is not considered to be part of the refined surface VTX_BOUNDARY_EDGE_ONLY All the boundary edge-chains are sharp creases boundary vertices are not affected VTX_BOUNDARY_EDGE_AND_CORNER All the boundary edge-chains are sharp creases and boundary vertices with exactly one incident face are sharp corners On a grid example Face-Varying Interpolation Rules Face-varying data is used when discontinuities are required in the data over the surface -- mostly commonly the seams between disjoint UV regions. Face-varying data can follow the same interpolation behavior as vertex data, or it can be constrained to interpolate linearly around selective features from corners, boundaries, or the entire interior of the mesh. The following rules can be applied to face-varying data interpolation -- the ordering here applying progressively more linear constraints Mode Behavior FVAR_LINEAR_NONE smooth everywhere the mesh is smooth FVAR_LINEAR_CORNERS_ONLY sharpen linearly interpolate corners only FVAR_LINEAR_CORNERS_PLUS1 CORNERS_ONLY  sharpening of junctions of 3 or more regions FVAR_LINEAR_CORNERS_PLUS2 CORNERS_PLUS1  sharpening of darts and concave corners FVAR_LINEAR_BOUNDARIES linear interpolation along all boundary edges and corners FVAR_LINEAR_ALL linear interpolation everywhere boundaries and interior These rules cannot make the interpolation of the face-varying data smoother than that of the vertices. The presence of sharp features of the mesh created by sharpness values, boundary interpolation rules, or the subdivision scheme itself e.g. Bilinear take precedence. All face-varying interpolation modes illustrated in UV space using the catmark_fvar_bound1 regression shape -- a simple 4x4 grid of quads segmented into three UV regions their control point locations implied by interpolation in the FVAR_LINEAR_ALL case Semi-Sharp Creases It is possible to modify the subdivision rules to create piecewise smooth surfaces containing infinitely sharp features such as creases and corners. As a special case, surfaces can be made to interpolate their boundaries by tagging their boundary edges as sharp. However, weve recognized that real world surfaces never really have infinitely sharp edges, especially when viewed sufficiently close. To this end, weve added the notion of semi-sharp creases, i.e. rounded creases of controllable sharpness. These allow you to create features that are more akin to fillets and blends. As you tag edges and edge chains as creases, you also supply a sharpness value that ranges from 0-10, with sharpness values 10 treated as infinitely sharp. It should be noted that infinitely sharp creases are really tangent discontinuities in the surface, implying that the geometric normals are also discontinuous there. Therefore, displacing along the normal will likely tear apart the surface along the crease. If you really want to displace a surface at a crease, it may be better to make the crease semi-sharp. Chaikin Rule Chaikins curve subdivision algorithm improves the appearance of multi-edge semi-sharp creases with varying weights. The Chaikin rule interpolates the sharpness of incident edges. Mode Behavior CREASE_UNIFORM Apply regular semi-sharp crease rules CREASE_CHAIKIN Apply Chaikin semi-sharp crease rules Example of contiguous semi-sharp creases interpolation Triangle Subdivision Rule The triangle subdivision rule is a rule added to the Catmull-Clark scheme that can be applied to all triangular faces this rule was empirically determined to make triangles subdivide more smoothly. However, this rule breaks the nice property that two separate meshes can be joined seamlessly by overlapping their boundaries i.e. when there are triangles at either boundary, it is impossible to join the meshes seamlessly Mode Behavior TRI_SUB_CATMARK Default Catmark scheme weights TRI_SUB_SMOOTH Smooth triangle weights Cylinder example  Manifold vs Non-Manifold Geometry Continuous limit surfaces generally require that the topology be a two-dimensional manifold for the limit surface to be unambiguous. It is possible and sometimes useful, if only temporarily to model non-manifold geometry and so create surfaces whose limit is not as well-defined. The following examples show typical cases of non-manifold topological configurations. Non-Manifold Fan This fan configuration shows an edge shared by 3 distinct faces. With this configuration, it is unclear which face should contribute to the limit surface assuming it is singular as three of them share the same edge. Fan configurations are not limited to three incident faces any configuration where an edge is shared by more than two faces incurs the same problem. These and other regions involving non-manifold edges are dealt with by considering regions that are locally manifold . Rather than a single limit surface through this problematic edge with its many incident faces, the edge locally partitions a single limit surface into more than one. So each of the three faces here will have their own locally manifold limit surface -- all of which meet at the shared edge. Non-Manifold Disconnected Vertex A vertex is disconnected from any edge and face. This case is fairly trivial there is a very clear limit surface for the four vertices and the face they define, but no possible way to exact a limit surface from the disconnected vertex. While the vertex does not contribute to any limit surface, it may not be completely irrelevant though. Such vertices may be worth retaining during subdivision if for no other reason than to preserve certain vertex ordering and simply ignored when it comes time to consider the limit surface. Generated on 2016-06-13 0020 UTC. User Docs API Docs Release Notes Forum", "tags": "", "loc":"subdivision_surfaces.html"}, 
{"title":"OSD Tessellation shader Interface", "text":"OSD Tessellation shader Interface OSD Tessellation shader Interface 3.0.2 User Docs API Docs Release Notes Forum Github OSD_ARTICLE_TITLE Basic Tessellation Control Shader Example for BSpline patches Tessellation Evaluation Shader Example for BSpline patches Basis Conversion B-spline Patch Gregory Basis Patch Legacy Gregory Patch 2.x compatibility Tessellation levels Basic Starting with 3.0, Osd tessellation shaders can be used as a set of functions from client shader code. In order to tessellate Osd patches, client shader code should perform the following steps regular B-spline patch case In a tessellation control shader fetch a PatchParam for the current patch call OsdComputePerPatchVertexBSpline to compute OsdPerPatchVertexBezier. compute tessellation level. To prevent cracks on transition patches, two vec4 parameters tessOuterHi, tessOuterLo will be needed in addition to built-in gl_TessLevelInnerOuters. In a tessellation evaluation shader call OsdGetTessParameterization to remap gl_TessCoord to a patch parameter at which to evaluate. call OsdEvalPatchBezierOsdEvalPatchGregory to evaluate the current patch. The following is a minimal example of GLSL code explaining how client shader code uses OpenSubdiv shader functions to tessellate patches of a patch table. Tessellation Control Shader Example for BSpline patches layout  vertices  16  out  in vec3 position  patch out vec4 tessOuterLo , tessOuterHi  out OsdPerPatchVertexBezier v  void main    Get a patch param from texture buffer. ivec3 patchParam  OsdGetPatchParam  gl_PrimitiveID   Compute per-patch vertices. OsdComputePerPatchVertexBSpline  patchParam , gl_InvocationID , position , v   Compute tessellation factors. if  gl_InvocationID  0   vec4 tessLevelOuter  vec4  0  vec2 tessLevelInner  vec2  0  OsdGetTessLevelsUniform  patchParam , tessLevelOuter , tessLevelInner , tessOuterLo , tessOuterHi  gl_TessLevelOuter  0   tessLevelOuter  0  gl_TessLevelOuter  1   tessLevelOuter  1  gl_TessLevelOuter  2   tessLevelOuter  2  gl_TessLevelOuter  3   tessLevelOuter  3  gl_TessLevelInner  0   tessLevelInner  0  gl_TessLevelInner  1   tessLevelInner  1    Tessellation Evaluation Shader Example for BSpline patches layout  quads  in  patch in vec4 tessOuterLo , tessOuterHi  in OsdPerPatchVertexBezier v  uniform mat4 mvpMatrix  void main    Compute tesscoord. vec2 UV  OsdGetTessParameterization  gl_TessCoord . xy , tessOuterLo , tessOuterHi  vec3 P  vec3  0 , dPu  vec3  0 , dPv  vec3  0  vec3 N  vec3  0 , dNu  vec3  0 , dNv  vec3  0  ivec3 patchParam  inpt  0 . v . patchParam   Evaluate patch at the tess coord UV OsdEvalPatchBezier  patchParam , UV , v , P , dPu , dPv , N , dNu , dNv   Apply model-view-projection matrix. gl_Position  mvpMatrix  vec4  P , 1   Basis Conversion B-spline Patch The following diagram shows how the Osd shaders process b-spline patches. While regular patches are expressed as b-spline patches in FarPatchTable, the Osd shader converts them into Bezier basis patches for simplicity and efficiency. This conversion is performed in the tessellation control stage. The boundary edge evaluation and single crease matrix evaluation are also resolved during this conversion. OsdComputePerPatchVertexBSpline can be used for this process. The resulting Bezier control vertices are stored in OsdPerPatchVertexBezier struct. void OsdComputePerPatchVertexBSpline  ivec3 patchParam , int ID , vec3 cv  16 , out OsdPerPatchVertexBezier result  The tessellation evaluation shader takes an array of OsdPerPatchVertexBezier struct, and then evaluates the patch using the OsdEvalPatchBezier function. void OsdEvalPatchBezier  ivec3 patchParam , vec2 UV , OsdPerPatchVertexBezier cv  16 , out vec3 P , out vec3 dPu , out vec3 dPv , out vec3 N , out vec3 dNu , out vec3 dNv  Gregory Basis Patch In a similar way, Gregory basis patches are processed as follows OsdComputePerPatchVertexGregoryBasis can be used for the Gregory patches although no basis conversion involved for the Gregory patches and the resulting vertices are stored in a OsdPerPatchVertexGreogryBasis struct. void OsdComputePerPatchVertexGregoryBasis  ivec3 patchParam , int ID , vec3 cv , out OsdPerPatchVertexGregoryBasis result  The tessellation evaluation shader takes an array of OsdPerPatchVertexGregoryBasis struct, and then evaluates the patch using the OsdEvalPatchGregory function. void OsdEvalPatchGregory  ivec3 patchParam , vec2 UV , vec3 cv  20 , out vec3 P , out vec3 dPu , out vec3 dPv , out vec3 N , out vec3 dNu , out vec3 dNv  Legacy Gregory Patch 2.x compatibility OpenSubdiv 3.0 also supports 2.x style Gregory patch evaluation see far_overview. In order to evaluate a legacy Gregory patch, client needs to bind extra buffers and to perform extra steps in the vertex shader as shown in the following diagram Tessellation levels Osd provides both uniform and screen-space adaptive tessellation level computation. Uniform tessellation OsdGetTessLevelsUniform Screen-space adaptive tessellation OsdGetTessLevelsAdaptiveLimitPoints Because of the nature of feature adaptive subdivision , we need to pay extra attention for a patchs outer tessellation level for the screen-space adaptive case so that cracks dont appear. An edge of the patch marked as a transition edge is split into two segments Hi and Lo. The Osd shaders uses these two segments to ensure the same tessellation along the edge between different levels of subdivision. In the following example, suppose the left hand side patch has determined the tessellation level of its right edge to be 5. gl_TessLevelOuter is set to 5 for the edge, and at the same time we also pass 2 and 3 to the tessellation evaluation shader as separate levels for the two segments of the edge split at the middle. Then the tessellation evaluation shader takes gl_TessCoord and those two values, and remaps gl_TessCoord using OsdGetTessParameterization to ensure the parameters are consistent across adjacent patches. vec2 OsdGetTessParameterization  vec2 uv , vec4 tessOuterLo , vec4 tessOuterHi  These tessellation levels can be computed by OsdGetTessLevelsAdaptiveLimitPoints in the tessellation control shader. Note that this function requires all 16 bezier control points, you need to call barrier to ensure the conversion is done for all invocations. See osdglslPatchBSpline.glsl for more details. void OsdGetTessLevelsAdaptiveLimitPoints  OsdPerPatchVertexBezier cpBezier  16 , ivec3 patchParam , out vec4 tessLevelOuter , out vec2 tessLevelInner , out vec4 tessOuterLo , out vec4 tessOuterHi  Release Notes 3.0.0 Currently OsdGetTessParameterization doesnt support fraction spacing. It will be fixed in a future release. Generated on 2016-06-13 0020 UTC. User Docs API Docs Release Notes Forum", "tags": "", "loc":"osd_shader_interface.html"}, 
]};