/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.io;

import com.eteks.sweethome3d.io.Base64;
import com.eteks.sweethome3d.io.ContentDigestManager;
import com.eteks.sweethome3d.io.ContentRecording;
import com.eteks.sweethome3d.io.HomeURLContent;
import com.eteks.sweethome3d.model.Content;
import com.eteks.sweethome3d.model.Home;
import com.eteks.sweethome3d.tools.ResourceURLContent;
import com.eteks.sweethome3d.tools.SimpleURLContent;
import com.eteks.sweethome3d.tools.TemporaryURLContent;
import com.eteks.sweethome3d.tools.URLContent;
import java.io.File;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class DefaultHomeOutputStream
extends FilterOutputStream {
    private int compressionLevel;
    private ContentRecording contentRecording;

    public DefaultHomeOutputStream(OutputStream outputStream) throws IOException {
        this(outputStream, 0, false);
    }

    public DefaultHomeOutputStream(OutputStream outputStream, int n, boolean bl) throws IOException {
        this(outputStream, n, bl ? ContentRecording.INCLUDE_TEMPORARY_CONTENT : ContentRecording.INCLUDE_ALL_CONTENT);
    }

    public DefaultHomeOutputStream(OutputStream outputStream, int n, ContentRecording contentRecording) throws IOException {
        super(outputStream);
        this.compressionLevel = n;
        this.contentRecording = contentRecording;
    }

    private static void checkCurrentThreadIsntInterrupted() throws InterruptedIOException {
        if (Thread.interrupted()) {
            throw new InterruptedIOException();
        }
    }

    public void writeHome(Home home) throws IOException {
        ZipOutputStream zipOutputStream = new ZipOutputStream(this.out);
        zipOutputStream.setLevel(this.compressionLevel);
        DefaultHomeOutputStream.checkCurrentThreadIsntInterrupted();
        zipOutputStream.putNextEntry(new ZipEntry("Home"));
        HomeObjectOutputStream homeObjectOutputStream = new HomeObjectOutputStream(zipOutputStream);
        homeObjectOutputStream.writeObject(home);
        homeObjectOutputStream.flush();
        zipOutputStream.closeEntry();
        List<Content> list = homeObjectOutputStream.getSavedContents();
        if (list.size() > 0) {
            zipOutputStream.putNextEntry(new ZipEntry("ContentDigests"));
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)zipOutputStream, "UTF-8");
            ContentDigestManager contentDigestManager = ContentDigestManager.getInstance();
            outputStreamWriter.write("ContentDigests-Version: 1.0\n\n");
            for (Content content : list) {
                outputStreamWriter.write("Name: " + homeObjectOutputStream.getContentEntry(content) + "\n");
                outputStreamWriter.write("SHA-1-Digest: " + Base64.encodeBytes(contentDigestManager.getContentDigest(content)) + "\n\n");
            }
            outputStreamWriter.flush();
            zipOutputStream.closeEntry();
        }
        int n = 0;
        for (Content content : list) {
            String string = String.valueOf(n++);
            if (content instanceof ResourceURLContent) {
                this.writeResourceZipEntries(zipOutputStream, string, (ResourceURLContent)content);
                continue;
            }
            if (content instanceof URLContent && !(content instanceof SimpleURLContent) && ((URLContent)content).isJAREntry()) {
                URLContent uRLContent = (URLContent)content;
                if (uRLContent instanceof HomeURLContent) {
                    this.writeHomeZipEntries(zipOutputStream, string, (HomeURLContent)uRLContent);
                    continue;
                }
                this.writeZipEntries(zipOutputStream, string, uRLContent);
                continue;
            }
            this.writeZipEntry(zipOutputStream, string, content);
        }
        zipOutputStream.finish();
    }

    private void writeResourceZipEntries(ZipOutputStream zipOutputStream, String string, ResourceURLContent resourceURLContent) throws IOException {
        if (resourceURLContent.isMultiPartResource()) {
            if (resourceURLContent.isJAREntry()) {
                URL uRL = resourceURLContent.getJAREntryURL();
                String string2 = resourceURLContent.getJAREntryName();
                int n = string2.lastIndexOf(47);
                if (n != -1) {
                    String string3 = string2.substring(0, n + 1);
                    for (String string4 : ContentDigestManager.getInstance().getZipURLEntries(resourceURLContent)) {
                        if (!string4.startsWith(string3)) continue;
                        URLContent uRLContent = new URLContent(new URL("jar:" + uRL + "!/" + URLEncoder.encode(string4, "UTF-8").replace("+", "%20")));
                        this.writeZipEntry(zipOutputStream, string + string4.substring(n), uRLContent);
                    }
                } else {
                    this.writeZipEntry(zipOutputStream, string, resourceURLContent);
                }
            } else {
                try {
                    File[] fileArray;
                    File file = new File(resourceURLContent.getURL().toURI());
                    File file2 = new File(file.getParent());
                    for (File file3 : fileArray = file2.listFiles()) {
                        if (file3.isDirectory()) continue;
                        this.writeZipEntry(zipOutputStream, string + "/" + file3.getName(), new URLContent(file3.toURI().toURL()));
                    }
                }
                catch (URISyntaxException uRISyntaxException) {
                    IOException iOException = new IOException();
                    iOException.initCause(uRISyntaxException);
                    throw iOException;
                }
            }
        } else {
            this.writeZipEntry(zipOutputStream, string, resourceURLContent);
        }
    }

    private void writeHomeZipEntries(ZipOutputStream zipOutputStream, String string, HomeURLContent homeURLContent) throws IOException {
        String string2 = homeURLContent.getJAREntryName();
        int n = string2.indexOf(47);
        if (n > 0) {
            URL uRL = homeURLContent.getJAREntryURL();
            String string3 = string2.substring(0, n + 1);
            for (String string4 : ContentDigestManager.getInstance().getZipURLEntries(homeURLContent)) {
                if (!string4.startsWith(string3)) continue;
                URLContent uRLContent = new URLContent(new URL("jar:" + uRL + "!/" + URLEncoder.encode(string4, "UTF-8").replace("+", "%20")));
                this.writeZipEntry(zipOutputStream, string + string4.substring(n), uRLContent);
            }
        } else {
            this.writeZipEntry(zipOutputStream, string, homeURLContent);
        }
    }

    private void writeZipEntries(ZipOutputStream zipOutputStream, String string, URLContent uRLContent) throws IOException {
        for (String string2 : ContentDigestManager.getInstance().getZipURLEntries(uRLContent)) {
            URLContent uRLContent2 = new URLContent(new URL("jar:" + uRLContent.getJAREntryURL() + "!/" + URLEncoder.encode(string2, "UTF-8").replace("+", "%20")));
            this.writeZipEntry(zipOutputStream, string + "/" + string2, uRLContent2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeZipEntry(ZipOutputStream zipOutputStream, String string, Content content) throws IOException {
        DefaultHomeOutputStream.checkCurrentThreadIsntInterrupted();
        byte[] byArray = new byte[8192];
        InputStream inputStream = null;
        try {
            int n;
            zipOutputStream.putNextEntry(new ZipEntry(string));
            inputStream = content.openStream();
            while ((n = inputStream.read(byArray)) != -1) {
                zipOutputStream.write(byArray, 0, n);
            }
            zipOutputStream.closeEntry();
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class HomeObjectOutputStream
    extends ObjectOutputStream {
        private Map<Content, URLContent> savedContents;

        public HomeObjectOutputStream(OutputStream outputStream) throws IOException {
            super(outputStream);
            this.savedContents = new LinkedHashMap<Content, URLContent>();
            if (DefaultHomeOutputStream.this.contentRecording != ContentRecording.INCLUDE_NO_CONTENT) {
                this.enableReplaceObject(true);
            }
        }

        @Override
        protected Object replaceObject(Object object) throws IOException {
            if (object instanceof TemporaryURLContent || object instanceof HomeURLContent || DefaultHomeOutputStream.this.contentRecording == ContentRecording.INCLUDE_ALL_CONTENT && object instanceof Content) {
                URLContent uRLContent;
                String string = "";
                if (object instanceof URLContent) {
                    Object object2;
                    uRLContent = (URLContent)object;
                    ContentDigestManager contentDigestManager = ContentDigestManager.getInstance();
                    Object object3 = this.savedContents.entrySet().iterator();
                    while (object3.hasNext()) {
                        object2 = object3.next();
                        if (!contentDigestManager.equals(uRLContent, object2.getKey())) continue;
                        return object2.getValue();
                    }
                    DefaultHomeOutputStream.checkCurrentThreadIsntInterrupted();
                    if (uRLContent.isJAREntry()) {
                        object3 = uRLContent.getJAREntryName();
                        if (uRLContent instanceof HomeURLContent) {
                            int n = ((String)object3).indexOf(47);
                            if (n > 0) {
                                string = ((String)object3).substring(n);
                            }
                        } else if (uRLContent instanceof ResourceURLContent) {
                            int n;
                            object2 = (ResourceURLContent)uRLContent;
                            if (((ResourceURLContent)object2).isMultiPartResource() && (n = ((String)object3).lastIndexOf(47)) != -1) {
                                string = ((String)object3).substring(n);
                            }
                        } else if (!(uRLContent instanceof SimpleURLContent)) {
                            string = "/" + (String)object3;
                        }
                    } else if (uRLContent instanceof ResourceURLContent && ((ResourceURLContent)(object3 = (ResourceURLContent)uRLContent)).isMultiPartResource()) {
                        try {
                            string = "/" + new File(((URLContent)object3).getURL().toURI()).getName();
                        }
                        catch (URISyntaxException uRISyntaxException) {
                            IOException iOException = new IOException();
                            iOException.initCause(uRISyntaxException);
                            throw iOException;
                        }
                    }
                }
                uRLContent = new URLContent(new URL("jar:file:temp!/" + this.savedContents.size() + string));
                this.savedContents.put((Content)object, uRLContent);
                return uRLContent;
            }
            return object;
        }

        public List<Content> getSavedContents() {
            return new ArrayList<Content>(this.savedContents.keySet());
        }

        public String getContentEntry(Content content) {
            return this.savedContents.get(content).getJAREntryName();
        }
    }
}

