/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.pipeline.derivative;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.search.aggregations.AggregationExecutionException;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.elasticsearch.search.aggregations.bucket.histogram.HistogramAggregator;
import org.elasticsearch.search.aggregations.bucket.histogram.InternalHistogram;
import org.elasticsearch.search.aggregations.pipeline.BucketHelpers;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregatorFactory;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregatorStreams;
import org.elasticsearch.search.aggregations.pipeline.derivative.InternalDerivative;
import org.elasticsearch.search.aggregations.support.format.ValueFormatter;
import org.elasticsearch.search.aggregations.support.format.ValueFormatterStreams;
import org.joda.time.DateTime;

public class DerivativePipelineAggregator
extends PipelineAggregator {
    public static final InternalAggregation.Type TYPE = new InternalAggregation.Type("derivative");
    public static final PipelineAggregatorStreams.Stream STREAM = new PipelineAggregatorStreams.Stream(){

        @Override
        public DerivativePipelineAggregator readResult(StreamInput in) throws IOException {
            DerivativePipelineAggregator result = new DerivativePipelineAggregator();
            result.readFrom(in);
            return result;
        }
    };
    private ValueFormatter formatter;
    private BucketHelpers.GapPolicy gapPolicy;
    private Double xAxisUnits;

    public static void registerStreams() {
        PipelineAggregatorStreams.registerStream(STREAM, TYPE.stream());
    }

    public DerivativePipelineAggregator() {
    }

    public DerivativePipelineAggregator(String name, String[] bucketsPaths, ValueFormatter formatter, BucketHelpers.GapPolicy gapPolicy, Long xAxisUnits, Map<String, Object> metadata) {
        super(name, bucketsPaths, metadata);
        this.formatter = formatter;
        this.gapPolicy = gapPolicy;
        this.xAxisUnits = xAxisUnits == null ? null : Double.valueOf(xAxisUnits.longValue());
    }

    @Override
    public InternalAggregation.Type type() {
        return TYPE;
    }

    @Override
    public InternalAggregation reduce(InternalAggregation aggregation, InternalAggregation.ReduceContext reduceContext) {
        InternalHistogram histo = (InternalHistogram)aggregation;
        List buckets = histo.getBuckets();
        InternalHistogram.Factory factory = histo.getFactory();
        ArrayList<Object> newBuckets = new ArrayList<Object>();
        Long lastBucketKey = null;
        Double lastBucketValue = null;
        for (InternalHistogram.Bucket bucket : buckets) {
            Long thisBucketKey = this.resolveBucketKeyAsLong(bucket);
            Double thisBucketValue = BucketHelpers.resolveBucketValue(histo, (MultiBucketsAggregation.Bucket)bucket, this.bucketsPaths()[0], this.gapPolicy);
            if (lastBucketValue != null && thisBucketValue != null) {
                double gradient = thisBucketValue - lastBucketValue;
                double xDiff = -1.0;
                if (this.xAxisUnits != null) {
                    xDiff = (double)(thisBucketKey - lastBucketKey) / this.xAxisUnits;
                }
                ArrayList<InternalAggregation> aggs = new ArrayList<InternalAggregation>(CollectionUtils.eagerTransform(bucket.getAggregations().asList(), AGGREGATION_TRANFORM_FUNCTION));
                aggs.add(new InternalDerivative(this.name(), gradient, xDiff, this.formatter, new ArrayList<PipelineAggregator>(), this.metaData()));
                Object newBucket = factory.createBucket(bucket.getKey(), bucket.getDocCount(), new InternalAggregations(aggs), bucket.getKeyed(), bucket.getFormatter());
                newBuckets.add(newBucket);
            } else {
                newBuckets.add(bucket);
            }
            lastBucketKey = thisBucketKey;
            lastBucketValue = thisBucketValue;
        }
        return factory.create(newBuckets, histo);
    }

    private Long resolveBucketKeyAsLong(InternalHistogram.Bucket bucket) {
        Object key = bucket.getKey();
        if (key instanceof DateTime) {
            return ((DateTime)key).getMillis();
        }
        if (key instanceof Number) {
            return ((Number)key).longValue();
        }
        throw new AggregationExecutionException("Bucket keys must be either a Number or a DateTime for aggregation " + this.name() + ". Found bucket with key " + key);
    }

    @Override
    public void doReadFrom(StreamInput in) throws IOException {
        this.formatter = ValueFormatterStreams.readOptional(in);
        this.gapPolicy = BucketHelpers.GapPolicy.readFrom(in);
        this.xAxisUnits = in.readBoolean() ? Double.valueOf(in.readDouble()) : null;
    }

    @Override
    public void doWriteTo(StreamOutput out) throws IOException {
        ValueFormatterStreams.writeOptional(this.formatter, out);
        this.gapPolicy.writeTo(out);
        boolean hasXAxisUnitsValue = this.xAxisUnits != null;
        out.writeBoolean(hasXAxisUnitsValue);
        if (hasXAxisUnitsValue) {
            out.writeDouble(this.xAxisUnits);
        }
    }

    public static class Factory
    extends PipelineAggregatorFactory {
        private final ValueFormatter formatter;
        private BucketHelpers.GapPolicy gapPolicy;
        private Long xAxisUnits;

        public Factory(String name, String[] bucketsPaths, ValueFormatter formatter, BucketHelpers.GapPolicy gapPolicy, Long xAxisUnits) {
            super(name, TYPE.name(), bucketsPaths);
            this.formatter = formatter;
            this.gapPolicy = gapPolicy;
            this.xAxisUnits = xAxisUnits;
        }

        @Override
        protected PipelineAggregator createInternal(Map<String, Object> metaData) throws IOException {
            return new DerivativePipelineAggregator(this.name, this.bucketsPaths, this.formatter, this.gapPolicy, this.xAxisUnits, metaData);
        }

        @Override
        public void doValidate(AggregatorFactory parent, AggregatorFactory[] aggFactories, List<PipelineAggregatorFactory> pipelineAggregatorFactories) {
            if (this.bucketsPaths.length != 1) {
                throw new IllegalStateException(PipelineAggregator.Parser.BUCKETS_PATH.getPreferredName() + " must contain a single entry for aggregation [" + this.name + "]");
            }
            if (!(parent instanceof HistogramAggregator.Factory)) {
                throw new IllegalStateException("derivative aggregation [" + this.name + "] must have a histogram or date_histogram as parent");
            }
            HistogramAggregator.Factory histoParent = (HistogramAggregator.Factory)parent;
            if (histoParent.minDocCount() != 0L) {
                throw new IllegalStateException("parent histogram of derivative aggregation [" + this.name + "] must have min_doc_count of 0");
            }
        }
    }
}

