/*
 * Decompiled with CFR 0.152.
 */
package a_vcard.android.syncml.pim.vcard;

import a_vcard.android.syncml.pim.VDataBuilder;
import a_vcard.android.syncml.pim.vcard.VCardException;
import a_vcard.android.syncml.pim.vcard.VCardParser_V21;
import a_vcard.android.syncml.pim.vcard.VCardParser_V30;
import java.io.ByteArrayInputStream;
import java.io.IOException;

public class VCardParser {
    VCardParser_V21 mParser = null;
    public static final String VERSION_VCARD21 = "vcard2.1";
    public static final String VERSION_VCARD30 = "vcard3.0";
    public static final int VERSION_VCARD21_INT = 1;
    public static final int VERSION_VCARD30_INT = 2;
    String mVersion = null;
    private static final String TAG = "VCardParser";

    private void judgeVersion(String vcardStr) {
        if (this.mVersion == null) {
            String verStr;
            int verIdx = vcardStr.indexOf("\nVERSION:");
            this.mVersion = verIdx == -1 ? VERSION_VCARD21 : ((verStr = vcardStr.substring(verIdx, vcardStr.indexOf("\n", verIdx + 1))).indexOf("2.1") > 0 ? VERSION_VCARD21 : (verStr.indexOf("3.0") > 0 ? VERSION_VCARD30 : VERSION_VCARD21));
        }
        if (this.mVersion.equals(VERSION_VCARD21)) {
            this.mParser = new VCardParser_V21();
        }
        if (this.mVersion.equals(VERSION_VCARD30)) {
            this.mParser = new VCardParser_V30();
        }
    }

    private String verifyVCard(String vcardStr) {
        this.judgeVersion(vcardStr);
        vcardStr = vcardStr.replaceAll("\r\n", "\n");
        String[] strlist = vcardStr.split("\n");
        StringBuilder v21str = new StringBuilder("");
        for (int i = 0; i < strlist.length; ++i) {
            if (strlist[i].indexOf(":") < 0) {
                if (strlist[i].length() == 0 && strlist[i + 1].indexOf(":") > 0) {
                    v21str.append(strlist[i]).append("\r\n");
                    continue;
                }
                v21str.append(" ").append(strlist[i]).append("\r\n");
                continue;
            }
            v21str.append(strlist[i]).append("\r\n");
        }
        return v21str.toString();
    }

    private void setVersion(String version) {
        this.mVersion = version;
    }

    public boolean parse(String vcardStr, String encoding, VDataBuilder builder) throws VCardException, IOException {
        boolean isSuccess = this.mParser.parse(new ByteArrayInputStream((vcardStr = this.verifyVCard(vcardStr)).getBytes(encoding)), encoding, builder);
        if (!isSuccess) {
            if (this.mVersion.equals(VERSION_VCARD21)) {
                this.setVersion(VERSION_VCARD30);
                return this.parse(vcardStr, builder);
            }
            throw new VCardException("parse failed.(even use 3.0 parser)");
        }
        return true;
    }

    public boolean parse(String vcardStr, VDataBuilder builder) throws VCardException, IOException {
        return this.parse(vcardStr, "US-ASCII", builder);
    }
}

