/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.io;

import java.awt.Component;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import javax.annotation.Nullable;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.io.VFS;
import org.gjt.sp.jedit.io.VFSFile;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.Task;
import org.gjt.sp.util.ThreadUtilities;

public class CopyFileWorker
extends Task {
    private String source;
    private final Component comp;
    private List<String> sources;
    private final Behavior behavior;
    private final String target;
    private CountDownLatch latch;

    public CopyFileWorker(Component component, String string, String string2) {
        this(component, string, string2, null);
    }

    private CopyFileWorker(Component component, String string, String string2, @Nullable CountDownLatch countDownLatch) {
        if (string == null || string2 == null) {
            throw new NullPointerException("The source and target cannot be null");
        }
        if (string.equals(string2)) {
            throw new IllegalArgumentException("The source and target must not be the same");
        }
        this.comp = component;
        this.source = string;
        this.target = string2;
        this.behavior = Behavior.OVERWRITE;
        this.latch = countDownLatch;
        this.setLabel("Copy " + string + " to " + string2);
    }

    public CopyFileWorker(Component component, List<String> list, String string) {
        this(component, list, string, Behavior.SKIP);
    }

    public CopyFileWorker(Component component, List<String> list, String string, Behavior behavior) {
        if (list == null || string == null) {
            throw new NullPointerException("The source and target cannot be null");
        }
        this.comp = component;
        this.sources = list;
        this.target = string;
        this.behavior = behavior;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void _run() {
        Log.log(1, this, this + ".run()");
        if (this.source != null) {
            try {
                VFS.copy(this, this.source, this.target, this.comp, false, false);
            }
            catch (IOException iOException) {
                Log.log(9, this, iOException, iOException);
            }
            finally {
                if (this.latch != null) {
                    this.latch.countDown();
                }
            }
        } else {
            this.copyFileList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void copyFileList() {
        VFS vFS = VFSManager.getVFSForPath(this.target);
        Object object = null;
        try {
            object = vFS.createVFSSession(this.target, this.comp);
            if (object == null) {
                Log.log(9, this, "Target VFS path cannot be reached");
                return;
            }
            VFSFile vFSFile = vFS._getFile(object, this.target, this.comp);
            if (vFSFile == null) {
                Log.log(9, this, "Target is unreachable or do not exist");
                return;
            }
            if (vFSFile.getType() != 1) {
                Log.log(9, this, "Target is not a directory");
                return;
            }
            if (this.sources == null) return;
            this.setMaximum(this.sources.size());
            int n = 0;
            while (n < this.sources.size()) {
                this.setValue(n);
                String string = this.sources.get(n);
                String string2 = MiscUtilities.getFileName(string);
                this.setLabel(string2);
                this.copy(object, vFS, string, string2, this.target);
                ++n;
            }
            return;
        }
        catch (IOException iOException) {
            Log.log(9, this, iOException);
            return;
        }
        catch (InterruptedException interruptedException) {
            Log.log(7, this, "Copy was interrupted");
            return;
        }
        finally {
            VFSManager.sendVFSUpdate(vFS, this.target, true);
            try {
                if (object != null) {
                    vFS._endVFSSession(object, this.comp);
                }
            }
            catch (IOException iOException) {}
        }
    }

    private void copy(Object object, VFS vFS, String string, String string2, String string3) throws IOException, InterruptedException {
        String string4 = this.getTargetName(object, vFS, string3, string2);
        if (string4 == null) {
            return;
        }
        String string5 = MiscUtilities.constructPath(string3, string4);
        CountDownLatch countDownLatch = new CountDownLatch(1);
        ThreadUtilities.runInBackground(new CopyFileWorker(this.comp, string, string5, countDownLatch));
        countDownLatch.await();
    }

    @Nullable
    private String getTargetName(Object object, VFS vFS, String string, String string2) throws IOException {
        if (this.behavior == Behavior.OVERWRITE) {
            return string2;
        }
        String string3 = MiscUtilities.constructPath(this.target, string2);
        VFSFile vFSFile = vFS._getFile(object, string3, this.comp);
        if (vFSFile == null) {
            return string2;
        }
        if (this.behavior == Behavior.SKIP) {
            return null;
        }
        String string4 = MiscUtilities.getFileExtension(string2);
        String string5 = MiscUtilities.getBaseName(string2);
        for (int i = 1; i < 1000; ++i) {
            String string6 = string5 + "-copy-" + i;
            if (string4 != null) {
                string6 = string6 + string4;
            }
            if ((vFSFile = vFS._getFile(object, string3 = MiscUtilities.constructPath(string, string6), this.comp)) != null) continue;
            return string6;
        }
        return null;
    }

    @Override
    public String toString() {
        return "CopyFileWorker[" + this.source + ',' + this.target + ']';
    }

    public static enum Behavior {
        SKIP,
        OVERWRITE,
        RENAME;

    }
}

