/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.textarea;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.SwingConstants;
import javax.swing.ToolTipManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.MatteBorder;
import javax.swing.event.MouseInputAdapter;
import org.gjt.sp.jedit.Registers;
import org.gjt.sp.jedit.buffer.BufferAdapter;
import org.gjt.sp.jedit.buffer.BufferListener;
import org.gjt.sp.jedit.buffer.JEditBuffer;
import org.gjt.sp.jedit.textarea.ChunkCache;
import org.gjt.sp.jedit.textarea.ExtensionManager;
import org.gjt.sp.jedit.textarea.FoldPainter;
import org.gjt.sp.jedit.textarea.GutterPopupHandler;
import org.gjt.sp.jedit.textarea.MouseActionsProvider;
import org.gjt.sp.jedit.textarea.Selection;
import org.gjt.sp.jedit.textarea.StructureMatcher;
import org.gjt.sp.jedit.textarea.TextArea;
import org.gjt.sp.jedit.textarea.TextAreaExtension;
import org.gjt.sp.jedit.textarea.TextAreaMouseHandler;
import org.gjt.sp.jedit.textarea.TriangleFoldPainter;
import org.gjt.sp.util.Log;

public class Gutter
extends JComponent
implements SwingConstants {
    public static final int LOWEST_LAYER = Integer.MIN_VALUE;
    public static final int DEFAULT_LAYER = 0;
    public static final int HIGHEST_LAYER = Integer.MAX_VALUE;
    public static final String FOLD_PAINTER_PROPERTY = "foldPainter";
    public static final String FOLD_PAINTER_SERVICE = "org.gjt.sp.jedit.textarea.FoldPainter";
    public static final String DEFAULT_FOLD_PAINTER_SERVICE = "Triangle";
    private static final int FOLD_MARKER_SIZE = 12;
    private static final int SELECTION_GUTTER_WIDTH = 12;
    private boolean enabled;
    private final TextArea textArea;
    private MouseHandler mouseHandler;
    private ExtensionManager extensionMgr;
    private Dimension gutterSize = new Dimension(0, 0);
    private Dimension collapsedSize = new Dimension(0, 0);
    private int lineNumberWidth;
    private Dimension disabledSize = new Dimension(0, 0);
    private Color intervalHighlight;
    private Color currentLineHighlight;
    private Color foldColor;
    private Color selectionAreaBgColor;
    private FontMetrics fm;
    private int alignment;
    private int interval;
    private boolean currentLineHighlightEnabled;
    private boolean expanded;
    private boolean selectionAreaEnabled;
    private boolean structureHighlight;
    private Color structureHighlightColor;
    private int borderWidth;
    private Border focusBorder;
    private Border noFocusBorder;
    private FoldPainter foldPainter;
    private JEditBuffer buffer;
    private BufferListener bufferListener;
    private int minLineNumberDigits;
    private int selectionAreaWidth;

    public void setFoldPainter(FoldPainter foldPainter) {
        this.foldPainter = foldPainter == null ? new TriangleFoldPainter() : foldPainter;
    }

    public Gutter(TextArea textArea) {
        this.textArea = textArea;
        this.enabled = true;
        this.selectionAreaEnabled = true;
        this.selectionAreaWidth = 12;
        this.setAutoscrolls(true);
        this.setOpaque(true);
        this.setRequestFocusEnabled(false);
        this.extensionMgr = new ExtensionManager();
        this.mouseHandler = new MouseHandler();
        this.addMouseListener(this.mouseHandler);
        this.addMouseMotionListener(this.mouseHandler);
        this.bufferListener = new BufferAdapter(){

            @Override
            public void bufferLoaded(JEditBuffer jEditBuffer) {
                Gutter.this.updateLineNumberWidth();
            }

            @Override
            public void contentInserted(JEditBuffer jEditBuffer, int n, int n2, int n3, int n4) {
                if (n3 != 0) {
                    Gutter.this.updateLineNumberWidth();
                }
            }

            @Override
            public void contentRemoved(JEditBuffer jEditBuffer, int n, int n2, int n3, int n4) {
                if (n3 != 0) {
                    Gutter.this.updateLineNumberWidth();
                }
            }
        };
        this.updateBorder();
        this.setFoldPainter(textArea.getFoldPainter());
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHints(this.textArea.getPainter().renderingHints);
        Rectangle rectangle = graphics2D.getClipBounds();
        graphics2D.setColor(this.getBackground());
        int n = this.isSelectionAreaEnabled() ? 12 : rectangle.width;
        graphics2D.fillRect(rectangle.x, rectangle.y, n, rectangle.height);
        if (this.isSelectionAreaEnabled()) {
            if (this.selectionAreaBgColor == null) {
                this.selectionAreaBgColor = this.getBackground();
            }
            graphics2D.setColor(this.selectionAreaBgColor);
            graphics2D.fillRect(rectangle.x + 12, rectangle.y, rectangle.width - 12, rectangle.height);
        }
        if (this.textArea.getBuffer().isLoading()) {
            return;
        }
        int n2 = this.textArea.getPainter().getLineHeight();
        if (n2 == 0) {
            return;
        }
        int n3 = (rectangle.y + rectangle.height - 1) / n2;
        int n4 = rectangle.y / n2;
        if (n3 - n4 > this.textArea.getVisibleLines()) {
            Log.log(9, this, "BUG: firstLine=" + n4);
            Log.log(9, this, "     lastLine=" + n3);
            Log.log(9, this, "     visibleLines=" + this.textArea.getVisibleLines());
            Log.log(9, this, "     height=" + this.getHeight());
            Log.log(9, this, "     painter.height=" + n2);
            Log.log(9, this, "     clip.y=" + rectangle.y);
            Log.log(9, this, "     clip.height=" + rectangle.height);
            Log.log(9, this, "     lineHeight=" + n2);
        }
        int n5 = rectangle.y - rectangle.y % n2;
        this.extensionMgr.paintScreenLineRange(this.textArea, graphics2D, n4, n3, n5, n2);
        int n6 = n4;
        while (n6 <= n3) {
            this.paintLine(graphics2D, n6, n5);
            ++n6;
            n5 += n2;
        }
    }

    public void addExtension(TextAreaExtension textAreaExtension) {
        this.extensionMgr.addExtension(0, textAreaExtension);
        this.repaint();
    }

    public void addExtension(int n, TextAreaExtension textAreaExtension) {
        this.extensionMgr.addExtension(n, textAreaExtension);
        this.repaint();
    }

    public void removeExtension(TextAreaExtension textAreaExtension) {
        this.extensionMgr.removeExtension(textAreaExtension);
        this.repaint();
    }

    public TextAreaExtension[] getExtensions() {
        return this.extensionMgr.getExtensions();
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        if (this.textArea.getBuffer().isLoading()) {
            return null;
        }
        return this.extensionMgr.getToolTipText(mouseEvent.getX(), mouseEvent.getY());
    }

    public void setBorder(int n, Color color, Color color2, Color color3) {
        this.borderWidth = n;
        this.focusBorder = new CompoundBorder(new MatteBorder(0, 0, 0, n, color3), new MatteBorder(0, 0, 0, n, color));
        this.noFocusBorder = new CompoundBorder(new MatteBorder(0, 0, 0, n, color3), new MatteBorder(0, 0, 0, n, color2));
        this.updateBorder();
    }

    public void updateBorder() {
        if (this.textArea.hasFocus()) {
            this.setBorder(this.focusBorder);
        } else {
            this.setBorder(this.noFocusBorder);
        }
    }

    @Override
    public void setBorder(Border border) {
        super.setBorder(border);
        if (border == null) {
            this.collapsedSize.width = 0;
            this.collapsedSize.height = 0;
        } else {
            Insets insets = border.getBorderInsets(this);
            this.collapsedSize.width = 12 + insets.right;
            if (this.isSelectionAreaEnabled()) {
                this.collapsedSize.width += this.selectionAreaWidth;
            }
            this.collapsedSize.height = this.gutterSize.height = insets.top + insets.bottom;
            this.lineNumberWidth = this.fm.charWidth('5') * this.getLineNumberDigitCount();
            this.gutterSize.width = 12 + insets.right + this.lineNumberWidth;
        }
        this.revalidate();
    }

    public void setMinLineNumberDigitCount(int n) {
        if (n == this.minLineNumberDigits) {
            return;
        }
        this.minLineNumberDigits = n;
        if (this.textArea.getBuffer() != null) {
            this.updateLineNumberWidth();
        }
    }

    private int getMinLineNumberDigitCount() {
        return this.minLineNumberDigits;
    }

    private int getLineNumberDigitCount() {
        JEditBuffer jEditBuffer = this.textArea.getBuffer();
        int n = this.getMinLineNumberDigitCount();
        if (jEditBuffer == null) {
            return n;
        }
        int n2 = jEditBuffer.getLineCount();
        int n3 = 0;
        while (n2 > 0) {
            n2 /= 10;
            ++n3;
        }
        return n3 < n ? n : n3;
    }

    void setBuffer(JEditBuffer jEditBuffer) {
        if (this.buffer != null) {
            this.buffer.removeBufferListener(this.bufferListener);
        }
        this.buffer = jEditBuffer;
        if (this.buffer != null) {
            this.buffer.addBufferListener(this.bufferListener);
        }
        this.updateLineNumberWidth();
    }

    private void updateLineNumberWidth() {
        Font font = this.getFont();
        if (font != null) {
            this.setFont(this.getFont());
        }
    }

    void dispose() {
        if (this.buffer != null) {
            this.buffer.removeBufferListener(this.bufferListener);
            this.buffer = null;
        }
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.fm = this.getFontMetrics(font);
        Border border = this.getBorder();
        if (border != null) {
            this.lineNumberWidth = this.fm.charWidth('5') * this.getLineNumberDigitCount();
            this.gutterSize.width = 12 + border.getBorderInsets((Component)this).right + this.lineNumberWidth;
            this.revalidate();
        }
    }

    public void setGutterEnabled(boolean bl) {
        this.enabled = bl;
        this.revalidate();
    }

    public boolean isSelectionAreaEnabled() {
        return this.selectionAreaEnabled;
    }

    public void setSelectionAreaEnabled(boolean bl) {
        if (this.isSelectionAreaEnabled() == bl) {
            return;
        }
        this.selectionAreaEnabled = bl;
        this.collapsedSize.width = bl ? (this.collapsedSize.width += this.selectionAreaWidth) : (this.collapsedSize.width -= this.selectionAreaWidth);
        this.revalidate();
    }

    public void setSelectionAreaBackground(Color color) {
        this.selectionAreaBgColor = color;
        this.repaint();
    }

    public void setSelectionAreaWidth(int n) {
        this.selectionAreaWidth = n;
        this.revalidate();
    }

    public Color getHighlightedForeground() {
        return this.intervalHighlight;
    }

    public void setHighlightedForeground(Color color) {
        this.intervalHighlight = color;
    }

    public Color getCurrentLineForeground() {
        return this.currentLineHighlight;
    }

    public void setCurrentLineForeground(Color color) {
        this.currentLineHighlight = color;
    }

    public Color getFoldColor() {
        return this.foldColor;
    }

    public void setFoldColor(Color color) {
        this.foldColor = color;
    }

    @Override
    public Dimension getPreferredSize() {
        if (!this.enabled) {
            return this.disabledSize;
        }
        if (this.expanded) {
            return this.gutterSize;
        }
        return this.collapsedSize;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public int getLineNumberAlignment() {
        return this.alignment;
    }

    public void setLineNumberAlignment(int n) {
        if (this.alignment == n) {
            return;
        }
        this.alignment = n;
        this.repaint();
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public void setExpanded(boolean bl) {
        if (this.expanded == bl) {
            return;
        }
        this.expanded = bl;
        this.textArea.revalidate();
    }

    public void toggleExpanded() {
        this.setExpanded(!this.expanded);
    }

    public int getHighlightInterval() {
        return this.interval;
    }

    public void setHighlightInterval(int n) {
        if (n <= 1) {
            n = 0;
        }
        this.interval = n;
        this.repaint();
    }

    public boolean isCurrentLineHighlightEnabled() {
        return this.currentLineHighlightEnabled;
    }

    public void setCurrentLineHighlightEnabled(boolean bl) {
        if (this.currentLineHighlightEnabled == bl) {
            return;
        }
        this.currentLineHighlightEnabled = bl;
        this.repaint();
    }

    public final Color getStructureHighlightColor() {
        return this.structureHighlightColor;
    }

    public final void setStructureHighlightColor(Color color) {
        this.structureHighlightColor = color;
        this.repaint();
    }

    public final boolean isStructureHighlightEnabled() {
        return this.structureHighlight;
    }

    public final void setStructureHighlightEnabled(boolean bl) {
        this.structureHighlight = bl;
        this.repaint();
    }

    public void setSelectionPopupHandler(GutterPopupHandler gutterPopupHandler) {
        this.mouseHandler.selectionPopupHandler = gutterPopupHandler;
    }

    public GutterPopupHandler getSelectionPopupHandler() {
        return this.mouseHandler.selectionPopupHandler;
    }

    public void setMouseActionsProvider(MouseActionsProvider mouseActionsProvider) {
        this.mouseHandler.mouseActions = mouseActionsProvider;
    }

    private void paintLine(Graphics2D graphics2D, int n, int n2) {
        int n3;
        Object object;
        JEditBuffer jEditBuffer = this.textArea.getBuffer();
        if (jEditBuffer.isLoading()) {
            return;
        }
        FontMetrics fontMetrics = this.textArea.getPainter().getFontMetrics();
        int n4 = this.textArea.getPainter().getLineHeight();
        int n5 = fontMetrics.getAscent();
        ChunkCache.LineInfo lineInfo = this.textArea.chunkCache.getLineInfo(n);
        int n6 = lineInfo.physicalLine;
        if (n6 == -1) {
            return;
        }
        boolean bl = true;
        if (lineInfo.firstSubregion && jEditBuffer.isFoldStart(n6)) {
            bl = false;
            this.foldPainter.paintFoldStart(this, graphics2D, n, n6, this.textArea.displayManager.isLineVisible(n6 + 1), n2, n4, jEditBuffer);
        } else if (lineInfo.lastSubregion && jEditBuffer.isFoldEnd(n6)) {
            bl = false;
            this.foldPainter.paintFoldEnd(this, graphics2D, n, n6, n2, n4, jEditBuffer);
        } else if (this.structureHighlight) {
            object = this.textArea.getStructureMatch();
            n3 = this.textArea.getCaretLine();
            if (this.textArea.isStructureHighlightVisible() && n6 >= Math.min(n3, ((StructureMatcher.Match)object).startLine) && n6 <= Math.max(n3, ((StructureMatcher.Match)object).startLine)) {
                int n7;
                int n8 = n3 > this.textArea.getLastPhysicalLine() ? Integer.MAX_VALUE : (this.textArea.displayManager.isLineVisible(this.textArea.getCaretLine()) ? this.textArea.getScreenLineOfOffset(this.textArea.getCaretPosition()) : -1);
                if (n8 > (n7 = ((StructureMatcher.Match)object).startLine > this.textArea.getLastPhysicalLine() ? Integer.MAX_VALUE : (this.textArea.displayManager.isLineVisible(((StructureMatcher.Match)object).startLine) ? this.textArea.getScreenLineOfOffset(((StructureMatcher.Match)object).start) : -1))) {
                    int n9 = n8;
                    n8 = n7;
                    n7 = n9;
                }
                graphics2D.setColor(this.structureHighlightColor);
                bl = false;
                if (n7 == n8) {
                    bl = true;
                } else if (n == n8) {
                    graphics2D.fillRect(5, n2 + n4 / 2, 5, 2);
                    graphics2D.fillRect(5, n2 + n4 / 2, 2, n4 - n4 / 2);
                } else if (n == n7) {
                    graphics2D.fillRect(5, n2, 2, n4 / 2);
                    graphics2D.fillRect(5, n2 + n4 / 2, 5, 2);
                } else if (n > n8 && n < n7) {
                    graphics2D.fillRect(5, n2, 2, n4);
                }
            }
        }
        if (bl && jEditBuffer.getFoldLevel(n6) > 0) {
            this.foldPainter.paintFoldMiddle(this, graphics2D, n, n6, n2, n4, jEditBuffer);
        }
        if (lineInfo.firstSubregion && this.expanded) {
            object = Integer.toString(n6 + 1);
            switch (this.alignment) {
                case 4: {
                    n3 = this.lineNumberWidth - (this.fm.stringWidth((String)object) + 1);
                    break;
                }
                case 0: {
                    n3 = (this.lineNumberWidth - this.fm.stringWidth((String)object)) / 2;
                    break;
                }
                default: {
                    n3 = 0;
                }
            }
            if (n6 == this.textArea.getCaretLine() && this.currentLineHighlightEnabled) {
                graphics2D.setColor(this.currentLineHighlight);
            } else if (this.interval > 1 && (n6 + 1) % this.interval == 0) {
                graphics2D.setColor(this.intervalHighlight);
            } else {
                graphics2D.setColor(this.getForeground());
            }
            graphics2D.drawString((String)object, 12 + n3, n5 + n2);
        }
    }

    class MouseHandler
    extends MouseInputAdapter {
        MouseActionsProvider mouseActions;
        boolean drag;
        int toolTipInitialDelay;
        int toolTipReshowDelay;
        int selectionStart;
        boolean selectLines;
        int selAnchorLine;
        GutterPopupHandler selectionPopupHandler;

        MouseHandler() {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
            this.toolTipInitialDelay = toolTipManager.getInitialDelay();
            this.toolTipReshowDelay = toolTipManager.getReshowDelay();
            toolTipManager.setInitialDelay(0);
            toolTipManager.setReshowDelay(0);
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
            toolTipManager.setInitialDelay(this.toolTipInitialDelay);
            toolTipManager.setReshowDelay(this.toolTipReshowDelay);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            boolean bl;
            Gutter.this.textArea.requestFocus();
            boolean bl2 = bl = mouseEvent.getX() >= Gutter.this.getWidth() - Gutter.this.borderWidth * 2;
            if (TextAreaMouseHandler.isPopupTrigger(mouseEvent) || bl) {
                if (this.selectionPopupHandler != null && !bl && mouseEvent.getX() > 12) {
                    int n = mouseEvent.getY() / Gutter.this.textArea.getPainter().getLineHeight();
                    int n2 = ((Gutter)Gutter.this).textArea.chunkCache.getLineInfo((int)n).physicalLine;
                    if (n2 >= 0) {
                        this.selectionPopupHandler.handlePopup(mouseEvent.getX(), mouseEvent.getY(), n2);
                        return;
                    }
                }
                mouseEvent.translatePoint(-Gutter.this.getWidth(), 0);
                ((Gutter)Gutter.this).textArea.mouseHandler.mousePressed(mouseEvent);
                this.drag = true;
            } else {
                String string;
                String string2;
                JEditBuffer jEditBuffer = Gutter.this.textArea.getBuffer();
                int n = mouseEvent.getY() / Gutter.this.textArea.getPainter().getLineHeight();
                int n3 = ((Gutter)Gutter.this).textArea.chunkCache.getLineInfo((int)n).physicalLine;
                if (n3 == -1) {
                    return;
                }
                if (mouseEvent.getX() >= 12) {
                    this.selectionStart = Gutter.this.textArea.getLineStartOffset(n3);
                    int n4 = this.getFoldEndOffset(n3);
                    Selection.Range range = new Selection.Range(this.selectionStart, n4);
                    if (Gutter.this.textArea.isMultipleSelectionEnabled()) {
                        Gutter.this.textArea.addToSelection(range);
                    } else {
                        Gutter.this.textArea.setSelection(range);
                    }
                    Gutter.this.textArea.moveCaretPosition(n4, false);
                    this.selectLines = true;
                    this.selAnchorLine = n3;
                    return;
                }
                if (jEditBuffer.isFoldStart(n3)) {
                    string2 = "toggle-fold";
                    string = "fold";
                } else if (Gutter.this.structureHighlight && Gutter.this.textArea.isStructureHighlightVisible() && Gutter.this.textArea.lineInStructureScope(n3)) {
                    string2 = "match-struct";
                    string = "struct";
                } else {
                    return;
                }
                String string3 = null;
                if (this.mouseActions != null) {
                    string3 = this.mouseActions.getActionForEvent(mouseEvent, string);
                }
                if (string3 == null) {
                    string3 = string2;
                }
                StructureMatcher.Match match = Gutter.this.textArea.getStructureMatch();
                if (string3.equals("select-fold")) {
                    ((Gutter)Gutter.this).textArea.displayManager.expandFold(n3, true);
                    Gutter.this.textArea.selectFold(n3);
                } else if (string3.equals("narrow-fold")) {
                    int[] nArray = jEditBuffer.getFoldAtLine(n3);
                    ((Gutter)Gutter.this).textArea.displayManager.narrow(nArray[0], nArray[1]);
                } else if (string3.startsWith("toggle-fold")) {
                    if (((Gutter)Gutter.this).textArea.displayManager.isLineVisible(n3 + 1)) {
                        Gutter.this.textArea.collapseFold(n3);
                    } else if (string3.endsWith("-fully")) {
                        ((Gutter)Gutter.this).textArea.displayManager.expandFold(n3, true);
                    } else {
                        ((Gutter)Gutter.this).textArea.displayManager.expandFold(n3, false);
                    }
                } else if (string3.equals("match-struct")) {
                    if (match != null) {
                        Gutter.this.textArea.setCaretPosition(match.end);
                    }
                } else if (string3.equals("select-struct")) {
                    if (match != null) {
                        match.matcher.selectMatch(Gutter.this.textArea);
                    }
                } else if (string3.equals("narrow-struct") && match != null) {
                    int n5 = Math.min(match.startLine, Gutter.this.textArea.getCaretLine());
                    int n6 = Math.max(match.endLine, Gutter.this.textArea.getCaretLine());
                    ((Gutter)Gutter.this).textArea.displayManager.narrow(n5, n6);
                }
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (this.drag) {
                mouseEvent.translatePoint(-Gutter.this.getWidth(), 0);
                ((Gutter)Gutter.this).textArea.mouseHandler.mouseDragged(mouseEvent);
            } else if (this.selectLines) {
                int n;
                int n2;
                int n3;
                int n4 = mouseEvent.getY() / Gutter.this.textArea.getPainter().getLineHeight();
                if (mouseEvent.getY() < 0) {
                    Gutter.this.textArea.scrollUpLine();
                    n3 = Gutter.this.textArea.getFirstPhysicalLine();
                } else if (mouseEvent.getY() >= Gutter.this.getHeight()) {
                    Gutter.this.textArea.scrollDownLine();
                    n3 = Gutter.this.textArea.getLastPhysicalLine();
                } else {
                    n3 = ((Gutter)Gutter.this).textArea.chunkCache.getLineInfo((int)n4).physicalLine;
                }
                if (n3 < this.selAnchorLine) {
                    n2 = Gutter.this.textArea.getLineStartOffset(n3);
                    n = this.getFoldEndOffset(this.selAnchorLine);
                    Gutter.this.textArea.moveCaretPosition(n2, false);
                } else {
                    n2 = Gutter.this.textArea.getLineStartOffset(this.selAnchorLine);
                    n = this.getFoldEndOffset(n3);
                    Gutter.this.textArea.moveCaretPosition(n, false);
                }
                Gutter.this.textArea.resizeSelection(n2, n, 0, false);
            }
        }

        private int getFoldEndOffset(int n) {
            int n2;
            JEditBuffer jEditBuffer = Gutter.this.textArea.getBuffer();
            if (n == jEditBuffer.getLineCount() - 1 || ((Gutter)Gutter.this).textArea.displayManager.isLineVisible(n + 1)) {
                n2 = n;
            } else {
                int[] nArray = jEditBuffer.getFoldAtLine(n);
                n2 = nArray[1];
            }
            if (n2 == jEditBuffer.getLineCount() - 1) {
                return jEditBuffer.getLineEndOffset(n2) - 1;
            }
            return jEditBuffer.getLineEndOffset(n2);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            Selection selection;
            if (this.drag && mouseEvent.getX() >= Gutter.this.getWidth() - Gutter.this.borderWidth * 2) {
                mouseEvent.translatePoint(-Gutter.this.getWidth(), 0);
                ((Gutter)Gutter.this).textArea.mouseHandler.mouseReleased(mouseEvent);
            }
            if (this.selectLines && (selection = Gutter.this.textArea.getSelectionAtOffset(this.selectionStart)) != null) {
                Registers.setRegister('%', Gutter.this.textArea.getSelectedText(selection));
            }
            this.drag = false;
            this.selectLines = false;
        }
    }
}

