/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.selection;

import de.jensd.fx.glyphs.GlyphIcons;
import de.jensd.fx.glyphs.GlyphsDude;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Labeled;
import javafx.scene.control.Tooltip;
import org.apache.commons.lang3.StringUtils;
import org.pdfsam.pdf.PdfDescriptorLoadingStatus;
import org.pdfsam.support.RequireUtils;

public class LoadingStatusIndicatorUpdater
implements Consumer<PdfDescriptorLoadingStatus> {
    private Labeled indicator;

    public LoadingStatusIndicatorUpdater(Labeled indicator) {
        RequireUtils.requireNotNull(indicator, "Cannot set loading status on a null indicator");
        this.indicator = indicator;
    }

    @Override
    public void accept(PdfDescriptorLoadingStatus t) {
        GlyphIcons icon = Optional.ofNullable(t).map(PdfDescriptorLoadingStatus::getIcon).orElse(null);
        if (Objects.nonNull(icon)) {
            GlyphsDude.setIcon(this.indicator, icon, ContentDisplay.CENTER);
        } else {
            this.indicator.setGraphic(null);
        }
        if (t != null && StringUtils.isNotBlank(t.getDescription())) {
            this.indicator.setTooltip(new Tooltip(t.getDescription()));
        } else {
            this.indicator.setTooltip(null);
        }
    }
}

