/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox.component;

import java.io.IOException;
import org.sejda.impl.sambox.component.PDDocumentHandler;
import org.sejda.io.SeekableSources;
import org.sejda.model.exception.TaskIOException;
import org.sejda.model.exception.TaskWrongPasswordException;
import org.sejda.model.input.PdfFileSource;
import org.sejda.model.input.PdfSourceOpener;
import org.sejda.model.input.PdfStreamSource;
import org.sejda.model.input.PdfURLSource;
import org.sejda.sambox.input.PDFParser;
import org.sejda.sambox.pdmodel.PDDocument;
import org.sejda.sambox.pdmodel.encryption.InvalidPasswordException;

public class DefaultPdfSourceOpener
implements PdfSourceOpener<PDDocumentHandler> {
    private static final String WRONG_PWD_MESSAGE = "Unable to open the document due to a wrong password.";
    private static final String ERROR_MESSAGE = "An error occurred opening the source: %s.";

    @Override
    public PDDocumentHandler open(PdfURLSource source) throws TaskIOException {
        try {
            PDDocument document = PDFParser.parse(SeekableSources.onTempFileSeekableSourceFrom(source.getSource().openStream()), source.getPassword());
            return new PDDocumentHandler(document);
        }
        catch (InvalidPasswordException ipe) {
            throw new TaskWrongPasswordException(WRONG_PWD_MESSAGE, ipe);
        }
        catch (IOException e) {
            throw new TaskIOException(String.format(ERROR_MESSAGE, source), e);
        }
    }

    @Override
    public PDDocumentHandler open(PdfFileSource source) throws TaskIOException {
        try {
            PDDocument document = PDFParser.parse(SeekableSources.seekableSourceFrom(source.getSource()), source.getPassword());
            return new PDDocumentHandler(document);
        }
        catch (InvalidPasswordException ipe) {
            throw new TaskWrongPasswordException(WRONG_PWD_MESSAGE, ipe);
        }
        catch (IOException e) {
            throw new TaskIOException(String.format(ERROR_MESSAGE, source), e);
        }
    }

    @Override
    public PDDocumentHandler open(PdfStreamSource source) throws TaskIOException {
        try {
            PDDocument document = PDFParser.parse(SeekableSources.onTempFileSeekableSourceFrom(source.getSource()), source.getPassword());
            return new PDDocumentHandler(document);
        }
        catch (InvalidPasswordException ipe) {
            throw new TaskWrongPasswordException(WRONG_PWD_MESSAGE, ipe);
        }
        catch (IOException e) {
            throw new TaskIOException(String.format(ERROR_MESSAGE, source), e);
        }
    }
}

