/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.element.old.custom;

import com.baselet.control.HandlerElementMap;
import com.baselet.control.basics.Converter;
import com.baselet.control.enums.AlignHorizontal;
import com.baselet.control.enums.Direction;
import com.baselet.control.enums.LineType;
import com.baselet.control.util.Utils;
import com.baselet.custom.CustomFunction;
import com.baselet.diagram.DiagramHandler;
import com.baselet.diagram.draw.helper.ColorOwn;
import com.baselet.element.interfaces.GridElement;
import com.baselet.element.old.OldGridElement;
import com.baselet.element.old.custom.StyleShape;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.QuadCurve2D;
import java.awt.geom.RoundRectangle2D;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;

public abstract class CustomElement
extends OldGridElement {
    protected float zoom;
    private boolean bugfix;
    protected Graphics2D g2;
    protected float temp;
    protected int width;
    protected int height;
    protected Composite[] composites;
    private String code;
    private final Vector<StyleShape> shapes = new Vector();
    private final Vector<Text> texts = new Vector();
    private LineType tmpLineType;
    private int tmpLineThickness;
    private Color tmpFgColor;
    private Color tmpBgColor;
    private float tmpAlpha;
    private boolean specialLine;
    private boolean specialFgColor;
    private boolean specialBgColor;
    private boolean wordWrap = false;
    private boolean allowResize = true;

    public abstract void paint();

    public final void setCode(String code) {
        this.code = code;
    }

    public final String getCode() {
        return this.code;
    }

    private void drawShapes() {
        this.g2.setColor(this.bgColor);
        this.g2.setComposite(this.composites[1]);
        for (StyleShape s : this.shapes) {
            boolean bl = this.specialBgColor = !s.getBgColor().equals(this.bgColor);
            if (this.specialBgColor) {
                this.g2.setColor(s.getBgColor());
                this.g2.setComposite(AlphaComposite.getInstance(3, s.getAlpha()));
            }
            this.g2.fill(s.getShape());
            if (!this.specialBgColor) continue;
            this.g2.setColor(this.bgColor);
            this.g2.setComposite(this.composites[1]);
        }
        this.g2.setComposite(this.composites[0]);
        this.g2.setColor(this.fgColor);
        for (StyleShape s : this.shapes) {
            this.specialLine = s.getLineType() != LineType.SOLID || (double)s.getLineThickness() != 1.0;
            boolean bl = this.specialFgColor = !s.getFgColor().equals(Converter.convert(ColorOwn.DEFAULT_FOREGROUND));
            if (this.specialLine) {
                this.g2.setStroke(Utils.getStroke(s.getLineType(), s.getLineThickness()));
            }
            if (this.specialFgColor) {
                if (HandlerElementMap.getHandlerForElement(this).getDrawPanel().getSelector().isSelected(this)) {
                    this.g2.setColor(Converter.convert(ColorOwn.SELECTION_FG));
                } else {
                    this.g2.setColor(s.getFgColor());
                }
            }
            this.g2.draw(s.getShape());
            if (this.specialLine) {
                this.g2.setStroke(Utils.getStroke(LineType.SOLID, 1.0f));
            }
            if (!this.specialFgColor) continue;
            this.g2.setColor(this.fgColor);
        }
        for (Text t : this.texts) {
            boolean applyZoom = true;
            if (t.fixedSize != null) {
                HandlerElementMap.getHandlerForElement(this).getFontHandler().setFontSize((double)t.fixedSize);
                applyZoom = false;
            }
            HandlerElementMap.getHandlerForElement(this).getFontHandler().writeText(this.g2, t.text, (double)t.x, (double)t.y, t.align, applyZoom);
            if (t.fixedSize == null) continue;
            HandlerElementMap.getHandlerForElement(this).getFontHandler().resetFontSize();
        }
        this.texts.clear();
        this.shapes.clear();
    }

    @Override
    public final void paintEntity(Graphics g) {
        this.g2 = (Graphics2D)g;
        this.composites = this.colorize(this.g2);
        this.g2.setFont(HandlerElementMap.getHandlerForElement(this).getFontHandler().getFont());
        this.g2.setColor(this.fgColor);
        this.zoom = HandlerElementMap.getHandlerForElement(this).getZoomFactor();
        this.bugfix = (double)this.zoom < 0.25;
        this.temp = this.getRectangle().width;
        this.width = Math.round(this.temp / this.zoom);
        this.temp = this.getRectangle().height;
        this.height = Math.round(this.temp / this.zoom);
        this.width = this.onGrid(this.width);
        this.height = this.onGrid(this.height);
        this.resetAll();
        this.paint();
        this.width = this.onGrid(this.width);
        this.height = this.onGrid(this.height);
        this.width = (int)((float)this.width * this.zoom);
        this.height = (int)((float)this.height * this.zoom);
        this.drawShapes();
        if (!this.bugfix) {
            this.setSize(this.width + 1, this.height + 1);
        }
    }

    @Override
    public GridElement cloneFromMe() {
        CustomElement e = (CustomElement)super.cloneFromMe();
        e.code = this.code;
        return e;
    }

    @CustomFunction(param_defaults="text,x,y")
    protected final int print(String text, int x, int inY) {
        int y = inY;
        List<String> list = this.wordWrap ? CustomElement.splitString(text, this.width, HandlerElementMap.getHandlerForElement(this)) : Arrays.asList(text);
        for (String s : list) {
            this.texts.add(new Text(s, (int)((float)x * this.zoom), (int)((float)y * this.zoom), AlignHorizontal.LEFT));
            y += this.textHeight();
        }
        return y - inY;
    }

    @CustomFunction(param_defaults="text,y")
    protected final int printLeft(String text, int inY) {
        int y = inY;
        List<String> list = this.wordWrap ? CustomElement.splitString(text, this.width, HandlerElementMap.getHandlerForElement(this)) : Arrays.asList(text);
        for (String s : list) {
            this.texts.add(new Text(s, (int)HandlerElementMap.getHandlerForElement(this).getFontHandler().getDistanceBetweenTexts(), (int)((float)y * this.zoom), AlignHorizontal.LEFT));
            y += this.textHeight();
        }
        return y - inY;
    }

    @CustomFunction(param_defaults="text,y")
    protected final int printRight(String text, int inY) {
        int y = inY;
        List<String> list = this.wordWrap ? CustomElement.splitString(text, this.width, HandlerElementMap.getHandlerForElement(this)) : Arrays.asList(text);
        for (String s : list) {
            this.texts.add(new Text(s, (int)((float)this.width * this.zoom - (float)this.textWidth(s, true)), (int)((float)y * this.zoom), AlignHorizontal.LEFT));
            y += this.textHeight();
        }
        return y - inY;
    }

    @CustomFunction(param_defaults="text,y")
    protected final int printCenter(String text, int inY) {
        int y = inY;
        List<String> list = this.wordWrap ? CustomElement.splitString(text, this.width, HandlerElementMap.getHandlerForElement(this)) : Arrays.asList(text);
        for (String s : list) {
            this.texts.add(new Text(s, (int)(((float)this.onGrid(this.width) * this.zoom - (float)this.textWidth(s, true)) / 2.0f), (int)((float)y * this.zoom), AlignHorizontal.LEFT));
            y += this.textHeight();
        }
        return y - inY;
    }

    @CustomFunction(param_defaults="text,x,y,fixedFontSize")
    protected final int printFixedSize(String text, int x, int inY, int fixedFontSize) {
        int y = inY;
        List<String> list = this.wordWrap ? CustomElement.splitString(text, this.width, HandlerElementMap.getHandlerForElement(this)) : Arrays.asList(text);
        for (String s : list) {
            this.texts.add(new Text(s, x, y, AlignHorizontal.LEFT, fixedFontSize));
            y += this.textHeight();
        }
        return y - inY;
    }

    @CustomFunction(param_defaults="value")
    protected final int onGrid(double value) {
        return this.onGrid(value, false);
    }

    @CustomFunction(param_defaults="value, roundUp")
    protected final int onGrid(double value, boolean roundUp) {
        if (value % 10.0 != 0.0) {
            value -= value % 10.0;
            if (roundUp) {
                value += 10.0;
            }
        }
        if (this.bugfix) {
            value -= 1.0;
        }
        return (int)value;
    }

    @CustomFunction(param_defaults="value1,value2")
    protected final int min(int value1, int value2) {
        return Math.min(value1, value2);
    }

    @CustomFunction(param_defaults="value1,value2")
    protected final int max(int value1, int value2) {
        return Math.max(value1, value2);
    }

    @CustomFunction(param_defaults="minWidth, minHeight, horizontalSpacing")
    protected final void setAutoresize(int minWidth, int minHeight, int horizontalSpacing) {
        if (!this.isManualResized()) {
            this.height = minHeight;
            this.width = minWidth;
            for (String textline : Utils.decomposeStrings(this.getPanelAttributes())) {
                this.height += this.textHeight();
                this.width = Math.max(this.textWidth(textline, false) + 10 + horizontalSpacing, this.width);
            }
            if (this.height < minHeight) {
                this.height = minHeight;
            }
            if (this.width < minWidth) {
                this.width = minWidth;
            }
        }
    }

    @Override
    @CustomFunction(param_defaults="")
    public final boolean isManualResized() {
        return super.isManualResized();
    }

    @CustomFunction(param_defaults="wordWrap")
    public final void setWordWrap(boolean wordWrap) {
        this.wordWrap = wordWrap;
    }

    @CustomFunction(param_defaults="")
    public final boolean isWordWrap() {
        return this.wordWrap;
    }

    @CustomFunction(param_defaults="x, y, width, height, start, extent")
    protected final void drawArcOpen(float x, float y, float width, float height, float start, float extent) {
        this.shapes.add(new StyleShape(new Arc2D.Float(x * this.zoom, y * this.zoom, width * this.zoom, height * this.zoom, start, extent, 0), this.tmpLineType, this.tmpLineThickness, this.tmpFgColor, this.tmpBgColor, this.tmpAlpha));
    }

    @CustomFunction(param_defaults="x, y, width, height, start, extent")
    protected final void drawArcChord(float x, float y, float width, float height, float start, float extent) {
        this.shapes.add(new StyleShape(new Arc2D.Float(x * this.zoom, y * this.zoom, width * this.zoom, height * this.zoom, start, extent, 1), this.tmpLineType, this.tmpLineThickness, this.tmpFgColor, this.tmpBgColor, this.tmpAlpha));
    }

    @CustomFunction(param_defaults="x, y, width, height, start, extent")
    protected final void drawArcPie(float x, float y, float width, float height, float start, float extent) {
        this.shapes.add(new StyleShape(new Arc2D.Float(x * this.zoom, y * this.zoom, width * this.zoom, height * this.zoom, start, extent, 2), this.tmpLineType, this.tmpLineThickness, this.tmpFgColor, this.tmpBgColor, this.tmpAlpha));
    }

    @CustomFunction(param_defaults="x, y, radius")
    protected final void drawCircle(int x, int y, int radius) {
        this.shapes.add(new StyleShape(new Ellipse2D.Float((int)((float)(x - radius) * this.zoom), (int)((float)(y - radius) * this.zoom), (int)((float)(radius * 2) * this.zoom), (int)((float)(radius * 2) * this.zoom)), this.tmpLineType, this.tmpLineThickness, this.tmpFgColor, this.tmpBgColor, this.tmpAlpha));
    }

    @CustomFunction(param_defaults="x1, y1, ctrlx1, ctrly1, ctrlx2, ctrly2, x2, y2")
    protected final void drawCurveCubic(float x1, float y1, float ctrlx1, float ctrly1, float ctrlx2, float ctrly2, float x2, float y2) {
        this.shapes.add(new StyleShape(new CubicCurve2D.Float(x1 * this.zoom, y1 * this.zoom, ctrlx1 * this.zoom, ctrly1 * this.zoom, ctrlx2 * this.zoom, ctrly2 * this.zoom, x2 * this.zoom, y2 * this.zoom), this.tmpLineType, this.tmpLineThickness, this.tmpFgColor, this.tmpBgColor, this.tmpAlpha));
    }

    @CustomFunction(param_defaults="x1, y1, ctrlx, ctrly, x2, y2")
    protected final void drawCurveQuad(float x1, float y1, float ctrlx, float ctrly, float x2, float y2) {
        this.shapes.add(new StyleShape(new QuadCurve2D.Float(x1 * this.zoom, y1 * this.zoom, ctrlx * this.zoom, ctrly * this.zoom, x2 * this.zoom, y2 * this.zoom), this.tmpLineType, this.tmpLineThickness, this.tmpFgColor, this.tmpBgColor, this.tmpAlpha));
    }

    @CustomFunction(param_defaults="x, y, radiusX, radiusYs")
    protected final void drawEllipse(int x, int y, int radiusX, int radiusY) {
        this.shapes.add(new StyleShape(new Ellipse2D.Float((int)((float)(x - radiusX) * this.zoom), (int)((float)(y - radiusY) * this.zoom), (int)((float)(radiusX * 2) * this.zoom), (int)((float)(radiusY * 2) * this.zoom)), this.tmpLineType, this.tmpLineThickness, this.tmpFgColor, this.tmpBgColor, this.tmpAlpha));
    }

    @CustomFunction(param_defaults="x1, y1, x2, y2")
    protected final void drawLine(int x1, int y1, int x2, int y2) {
        this.shapes.add(new StyleShape(new Line2D.Float((int)((float)x1 * this.zoom), (int)((float)y1 * this.zoom), (int)((float)x2 * this.zoom), (int)((float)y2 * this.zoom)), this.tmpLineType, this.tmpLineThickness, this.tmpFgColor, this.tmpBgColor, this.tmpAlpha));
    }

    @CustomFunction(param_defaults="y")
    protected final void drawLineHorizontal(int y) {
        this.shapes.add(new StyleShape(new Line2D.Float((int)(0.0f * this.zoom), (int)((float)y * this.zoom), HandlerElementMap.getHandlerForElement(this).realignToGrid(false, (int)((float)this.width * this.zoom), true), (int)((float)y * this.zoom)), this.tmpLineType, this.tmpLineThickness, this.tmpFgColor, this.tmpBgColor, this.tmpAlpha));
    }

    @CustomFunction(param_defaults="x")
    protected final void drawLineVertical(int x) {
        this.shapes.add(new StyleShape(new Line2D.Float((int)((float)x * this.zoom), (int)(0.0f * this.zoom), (int)((float)x * this.zoom), HandlerElementMap.getHandlerForElement(this).realignToGrid(false, (int)((float)this.height * this.zoom), true)), this.tmpLineType, this.tmpLineThickness, this.tmpFgColor, this.tmpBgColor, this.tmpAlpha));
    }

    @CustomFunction(param_defaults="polygon")
    protected final void drawPolygon(Polygon polygon) {
        int i = 0;
        while (i < polygon.xpoints.length) {
            int n = i++;
            polygon.xpoints[n] = (int)((float)polygon.xpoints[n] * this.zoom);
        }
        i = 0;
        while (i < polygon.ypoints.length) {
            int n = i++;
            polygon.ypoints[n] = (int)((float)polygon.ypoints[n] * this.zoom);
        }
        this.shapes.add(new StyleShape(polygon, this.tmpLineType, this.tmpLineThickness, this.tmpFgColor, this.tmpBgColor, this.tmpAlpha));
    }

    @CustomFunction(param_defaults="x, y, width, height")
    protected final void drawRectangle(int x, int y, int width, int height) {
        this.shapes.add(new StyleShape(new Rectangle((int)((float)x * this.zoom), (int)((float)y * this.zoom), (int)((float)width * this.zoom), (int)((float)height * this.zoom)), this.tmpLineType, this.tmpLineThickness, this.tmpFgColor, this.tmpBgColor, this.tmpAlpha));
    }

    @CustomFunction(param_defaults="x, y, width, height, arcw, arch")
    protected final void drawRectangleRound(int x, int y, int width, int height, float arcw, float arch) {
        this.shapes.add(new StyleShape(new RoundRectangle2D.Float((int)((float)x * this.zoom), (int)((float)y * this.zoom), (int)((float)width * this.zoom), (int)((float)height * this.zoom), arcw * this.zoom, arch * this.zoom), this.tmpLineType, this.tmpLineThickness, this.tmpFgColor, this.tmpBgColor, this.tmpAlpha));
    }

    @CustomFunction(param_defaults="shape")
    protected final void drawShape(Shape shape) {
        this.shapes.add(new StyleShape(shape, this.tmpLineType, this.tmpLineThickness, this.tmpFgColor, this.tmpBgColor, this.tmpAlpha));
    }

    @CustomFunction(param_defaults="lineType")
    protected final void setLineType(int lineType) {
        this.tmpLineType = lineType == 0 ? LineType.SOLID : (lineType == 1 ? LineType.DASHED : (lineType == 2 ? LineType.DOTTED : (lineType == 3 ? LineType.DOUBLE : (lineType == 4 ? LineType.DOUBLE_DASHED : (lineType == 5 ? LineType.DOUBLE_DOTTED : LineType.SOLID)))));
    }

    @CustomFunction(param_defaults="lineThickness")
    protected final void setLineThickness(int lineThickness) {
        this.tmpLineThickness = lineThickness;
    }

    @CustomFunction(param_defaults="foregroundColor")
    protected final void setForegroundColor(String fgColorString) {
        this.tmpFgColor = Converter.convert(ColorOwn.forStringOrNull((String)fgColorString, (ColorOwn.Transparency)ColorOwn.Transparency.FOREGROUND));
        if (this.tmpFgColor == null) {
            this.tmpFgColor = this.fgColor;
        }
    }

    @CustomFunction(param_defaults="backgroundColor")
    protected final void setBackgroundColor(String bgColorString) {
        this.tmpBgColor = Converter.convert(ColorOwn.forStringOrNull((String)bgColorString, (ColorOwn.Transparency)ColorOwn.Transparency.FOREGROUND));
        if (this.tmpBgColor == null) {
            this.tmpBgColor = this.bgColor;
        }
        this.tmpAlpha = bgColorString.equals("none") ? 0.0f : 0.5f;
    }

    @CustomFunction(param_defaults="")
    protected final void resetAll() {
        this.tmpLineThickness = 1;
        this.tmpLineType = LineType.SOLID;
        this.tmpFgColor = this.fgColor;
        this.tmpBgColor = this.bgColor;
        this.tmpAlpha = this.alphaFactor;
    }

    protected final int textHeight() {
        return (int)(HandlerElementMap.getHandlerForElement(this).getFontHandler().getFontSize(false) + HandlerElementMap.getHandlerForElement(this).getFontHandler().getDistanceBetweenTexts(false));
    }

    protected final int textWidth(String text, boolean applyZoom) {
        return (int)(HandlerElementMap.getHandlerForElement(this).getFontHandler().getTextSize(text, applyZoom).getWidth() + (double)((int)HandlerElementMap.getHandlerForElement(this).getFontHandler().getDistanceBetweenTexts(applyZoom)));
    }

    protected final int textWidth(String text) {
        return this.textWidth(text, false);
    }

    protected final void allowResize(boolean allow) {
        this.allowResize = allow;
    }

    @Override
    public Set<Direction> getResizeArea(int x, int y) {
        if (this.allowResize) {
            return super.getResizeArea(x, y);
        }
        return new HashSet<Direction>();
    }

    private static List<String> splitString(String text, float width, DiagramHandler handler) {
        StringBuilder stringBuilder = new StringBuilder(text);
        int lastEmptyChar = -1;
        int firstCharInLine = 0;
        for (int i = 0; i < text.length(); ++i) {
            if (stringBuilder.charAt(i) == ' ') {
                lastEmptyChar = i;
            } else if (stringBuilder.charAt(i) == '\n') {
                lastEmptyChar = -1;
                firstCharInLine = i + 1;
            }
            if (!(handler.getFontHandler().getTextWidth(text.substring(firstCharInLine, i), false) + 15.0 > (double)width)) continue;
            if (lastEmptyChar != -1) {
                stringBuilder.setCharAt(lastEmptyChar, '\n');
                firstCharInLine = lastEmptyChar + 1;
                lastEmptyChar = -1;
                continue;
            }
            stringBuilder.insert(i, '\n');
            firstCharInLine = i + 1;
        }
        return Arrays.asList(stringBuilder.toString().split("\\n"));
    }

    @Override
    public boolean isDeprecated() {
        return false;
    }

    private static class Text {
        private final String text;
        private final int x;
        private final int y;
        private final AlignHorizontal align;
        private Integer fixedSize;

        private Text(String text, int x, int y, AlignHorizontal align) {
            this.text = text;
            this.x = x;
            this.y = y;
            this.align = align;
        }

        private Text(String text, int x, int y, AlignHorizontal align, Integer fixedSize) {
            this.text = text;
            this.x = x;
            this.y = y;
            this.align = align;
            this.fixedSize = fixedSize;
        }
    }
}

