/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.BoundFunction;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.DefaultErrorReporter;
import org.mozilla.javascript.Delegator;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.Evaluator;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.IdScriptableObject;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.NativeCall;
import org.mozilla.javascript.NativeFunction;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.UniqueTag;

public class BaseFunction
extends IdScriptableObject
implements Function {
    static final long serialVersionUID = 5311394446546053859L;
    private static final Object FUNCTION_TAG = "Function";
    private static final int Id_length = 1;
    private static final int Id_arity = 2;
    private static final int Id_name = 3;
    private static final int Id_prototype = 4;
    private static final int Id_arguments = 5;
    private static final int MAX_INSTANCE_ID = 5;
    private static final int Id_constructor = 1;
    private static final int Id_toString = 2;
    private static final int Id_toSource = 3;
    private static final int Id_apply = 4;
    private static final int Id_call = 5;
    private static final int Id_bind = 6;
    private static final int MAX_PROTOTYPE_ID = 6;
    private Object prototypeProperty;
    private Object argumentsObj = NOT_FOUND;
    private int prototypePropertyAttributes = 6;
    private int argumentsAttributes = 6;

    static void init(Scriptable scriptable, boolean bl) {
        BaseFunction baseFunction = new BaseFunction();
        baseFunction.prototypePropertyAttributes = 7;
        baseFunction.exportAsJSClass(6, scriptable, bl);
    }

    public BaseFunction() {
    }

    public BaseFunction(Scriptable scriptable, Scriptable scriptable2) {
        super(scriptable, scriptable2);
    }

    @Override
    public String getClassName() {
        return "Function";
    }

    @Override
    public String getTypeOf() {
        return this.avoidObjectDetection() ? "undefined" : "function";
    }

    @Override
    public boolean hasInstance(Scriptable scriptable) {
        Object object = ScriptableObject.getProperty((Scriptable)this, "prototype");
        if (object instanceof Scriptable) {
            return ScriptRuntime.jsDelegatesTo(scriptable, (Scriptable)object);
        }
        throw ScriptRuntime.typeError1("msg.instanceof.bad.prototype", this.getFunctionName());
    }

    @Override
    protected int getMaxInstanceId() {
        return 5;
    }

    @Override
    protected int findInstanceIdInfo(String string) {
        int n;
        int n2 = 0;
        String string2 = null;
        switch (string.length()) {
            case 4: {
                string2 = "name";
                n2 = 3;
                break;
            }
            case 5: {
                string2 = "arity";
                n2 = 2;
                break;
            }
            case 6: {
                string2 = "length";
                n2 = 1;
                break;
            }
            case 9: {
                char c = string.charAt(0);
                if (c == 'a') {
                    string2 = "arguments";
                    n2 = 5;
                    break;
                }
                if (c != 'p') break;
                string2 = "prototype";
                n2 = 4;
                break;
            }
        }
        if (string2 != null && string2 != string && !string2.equals(string)) {
            n2 = 0;
        }
        if (n2 == 0) {
            return super.findInstanceIdInfo(string);
        }
        switch (n2) {
            case 1: 
            case 2: 
            case 3: {
                n = 7;
                break;
            }
            case 4: {
                if (!this.hasPrototypeProperty()) {
                    return 0;
                }
                n = this.prototypePropertyAttributes;
                break;
            }
            case 5: {
                n = this.argumentsAttributes;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return BaseFunction.instanceIdInfo(n, n2);
    }

    @Override
    protected String getInstanceIdName(int n) {
        switch (n) {
            case 1: {
                return "length";
            }
            case 2: {
                return "arity";
            }
            case 3: {
                return "name";
            }
            case 4: {
                return "prototype";
            }
            case 5: {
                return "arguments";
            }
        }
        return super.getInstanceIdName(n);
    }

    @Override
    protected Object getInstanceIdValue(int n) {
        switch (n) {
            case 1: {
                return ScriptRuntime.wrapInt(this.getLength());
            }
            case 2: {
                return ScriptRuntime.wrapInt(this.getArity());
            }
            case 3: {
                return this.getFunctionName();
            }
            case 4: {
                return this.getPrototypeProperty();
            }
            case 5: {
                return this.getArguments();
            }
        }
        return super.getInstanceIdValue(n);
    }

    @Override
    protected void setInstanceIdValue(int n, Object object) {
        switch (n) {
            case 4: {
                if ((this.prototypePropertyAttributes & 1) == 0) {
                    this.prototypeProperty = object != null ? object : UniqueTag.NULL_VALUE;
                }
                return;
            }
            case 5: {
                if (object == NOT_FOUND) {
                    Kit.codeBug();
                }
                if (this.defaultHas("arguments")) {
                    this.defaultPut("arguments", object);
                } else if ((this.argumentsAttributes & 1) == 0) {
                    this.argumentsObj = object;
                }
                return;
            }
            case 1: 
            case 2: 
            case 3: {
                return;
            }
        }
        super.setInstanceIdValue(n, object);
    }

    @Override
    protected void setInstanceIdAttributes(int n, int n2) {
        switch (n) {
            case 4: {
                this.prototypePropertyAttributes = n2;
                return;
            }
            case 5: {
                this.argumentsAttributes = n2;
                return;
            }
        }
        super.setInstanceIdAttributes(n, n2);
    }

    @Override
    protected void fillConstructorProperties(IdFunctionObject idFunctionObject) {
        idFunctionObject.setPrototype(this);
        super.fillConstructorProperties(idFunctionObject);
    }

    @Override
    protected void initPrototypeId(int n) {
        String string;
        int n2;
        switch (n) {
            case 1: {
                n2 = 1;
                string = "constructor";
                break;
            }
            case 2: {
                n2 = 0;
                string = "toString";
                break;
            }
            case 3: {
                n2 = 1;
                string = "toSource";
                break;
            }
            case 4: {
                n2 = 2;
                string = "apply";
                break;
            }
            case 5: {
                n2 = 1;
                string = "call";
                break;
            }
            case 6: {
                n2 = 1;
                string = "bind";
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(n));
            }
        }
        this.initPrototypeMethod(FUNCTION_TAG, n, string, n2);
    }

    static boolean isApply(IdFunctionObject idFunctionObject) {
        return idFunctionObject.hasTag(FUNCTION_TAG) && idFunctionObject.methodId() == 4;
    }

    static boolean isApplyOrCall(IdFunctionObject idFunctionObject) {
        if (idFunctionObject.hasTag(FUNCTION_TAG)) {
            switch (idFunctionObject.methodId()) {
                case 4: 
                case 5: {
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public Object execIdCall(IdFunctionObject idFunctionObject, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        if (!idFunctionObject.hasTag(FUNCTION_TAG)) {
            return super.execIdCall(idFunctionObject, context, scriptable, scriptable2, objectArray);
        }
        int n = idFunctionObject.methodId();
        switch (n) {
            case 1: {
                return BaseFunction.jsConstructor(context, scriptable, objectArray);
            }
            case 2: {
                BaseFunction baseFunction = this.realFunction(scriptable2, idFunctionObject);
                int n2 = ScriptRuntime.toInt32(objectArray, 0);
                return baseFunction.decompile(n2, 0);
            }
            case 3: {
                BaseFunction baseFunction = this.realFunction(scriptable2, idFunctionObject);
                int n3 = 0;
                int n4 = 2;
                if (objectArray.length != 0) {
                    n3 = ScriptRuntime.toInt32(objectArray[0]);
                    if (n3 >= 0) {
                        n4 = 0;
                    } else {
                        n3 = 0;
                    }
                }
                return baseFunction.decompile(n3, n4);
            }
            case 4: 
            case 5: {
                return ScriptRuntime.applyOrCall(n == 4, context, scriptable, scriptable2, objectArray);
            }
            case 6: {
                Object[] objectArray2;
                Scriptable scriptable3;
                if (!(scriptable2 instanceof Callable)) {
                    throw ScriptRuntime.notFunctionError(scriptable2);
                }
                Callable callable = (Callable)((Object)scriptable2);
                int n5 = objectArray.length;
                if (n5 > 0) {
                    scriptable3 = ScriptRuntime.toObjectOrNull(context, objectArray[0], scriptable);
                    objectArray2 = new Object[n5 - 1];
                    System.arraycopy(objectArray, 1, objectArray2, 0, n5 - 1);
                } else {
                    scriptable3 = null;
                    objectArray2 = ScriptRuntime.emptyArgs;
                }
                return new BoundFunction(context, scriptable, callable, scriptable3, objectArray2);
            }
        }
        throw new IllegalArgumentException(String.valueOf(n));
    }

    private BaseFunction realFunction(Scriptable scriptable, IdFunctionObject idFunctionObject) {
        Object object = scriptable.getDefaultValue(ScriptRuntime.FunctionClass);
        if (object instanceof Delegator) {
            object = ((Delegator)object).getDelegee();
        }
        if (object instanceof BaseFunction) {
            return (BaseFunction)object;
        }
        throw ScriptRuntime.typeError1("msg.incompat.call", idFunctionObject.getFunctionName());
    }

    public void setImmunePrototypeProperty(Object object) {
        if ((this.prototypePropertyAttributes & 1) != 0) {
            throw new IllegalStateException();
        }
        this.prototypeProperty = object != null ? object : UniqueTag.NULL_VALUE;
        this.prototypePropertyAttributes = 7;
    }

    protected Scriptable getClassPrototype() {
        Object object = this.getPrototypeProperty();
        if (object instanceof Scriptable) {
            return (Scriptable)object;
        }
        return ScriptableObject.getObjectPrototype(this);
    }

    @Override
    public Object call(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        return Undefined.instance;
    }

    @Override
    public Scriptable construct(Context context, Scriptable scriptable, Object[] objectArray) {
        Scriptable scriptable2 = this.createObject(context, scriptable);
        if (scriptable2 != null) {
            Object object = this.call(context, scriptable, scriptable2, objectArray);
            if (object instanceof Scriptable) {
                scriptable2 = (Scriptable)object;
            }
        } else {
            Scriptable scriptable3;
            Object object = this.call(context, scriptable, null, objectArray);
            if (!(object instanceof Scriptable)) {
                throw new IllegalStateException("Bad implementaion of call as constructor, name=" + this.getFunctionName() + " in " + this.getClass().getName());
            }
            scriptable2 = (Scriptable)object;
            if (scriptable2.getPrototype() == null && scriptable2 != (scriptable3 = this.getClassPrototype())) {
                scriptable2.setPrototype(scriptable3);
            }
            if (scriptable2.getParentScope() == null && scriptable2 != (scriptable3 = this.getParentScope())) {
                scriptable2.setParentScope(scriptable3);
            }
        }
        return scriptable2;
    }

    public Scriptable createObject(Context context, Scriptable scriptable) {
        NativeObject nativeObject = new NativeObject();
        nativeObject.setPrototype(this.getClassPrototype());
        nativeObject.setParentScope(this.getParentScope());
        return nativeObject;
    }

    String decompile(int n, int n2) {
        boolean bl;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = bl = 0 != (n2 & 1);
        if (!bl) {
            stringBuilder.append("function ");
            stringBuilder.append(this.getFunctionName());
            stringBuilder.append("() {\n\t");
        }
        stringBuilder.append("[native code, arity=");
        stringBuilder.append(this.getArity());
        stringBuilder.append("]\n");
        if (!bl) {
            stringBuilder.append("}\n");
        }
        return stringBuilder.toString();
    }

    public int getArity() {
        return 0;
    }

    public int getLength() {
        return 0;
    }

    public String getFunctionName() {
        return "";
    }

    protected boolean hasPrototypeProperty() {
        return this.prototypeProperty != null || this instanceof NativeFunction;
    }

    protected Object getPrototypeProperty() {
        Object object = this.prototypeProperty;
        if (object == null) {
            object = this instanceof NativeFunction ? this.setupDefaultPrototype() : Undefined.instance;
        } else if (object == UniqueTag.NULL_VALUE) {
            object = null;
        }
        return object;
    }

    private synchronized Object setupDefaultPrototype() {
        if (this.prototypeProperty != null) {
            return this.prototypeProperty;
        }
        NativeObject nativeObject = new NativeObject();
        int n = 2;
        nativeObject.defineProperty("constructor", this, 2);
        this.prototypeProperty = nativeObject;
        Scriptable scriptable = BaseFunction.getObjectPrototype(this);
        if (scriptable != nativeObject) {
            nativeObject.setPrototype(scriptable);
        }
        return nativeObject;
    }

    private Object getArguments() {
        Object object;
        Object object2 = object = this.defaultHas("arguments") ? this.defaultGet("arguments") : this.argumentsObj;
        if (object != NOT_FOUND) {
            return object;
        }
        Context context = Context.getContext();
        NativeCall nativeCall = ScriptRuntime.findFunctionActivation(context, this);
        return nativeCall == null ? null : nativeCall.get("arguments", (Scriptable)nativeCall);
    }

    private static Object jsConstructor(Context context, Scriptable scriptable, Object[] objectArray) {
        int n = objectArray.length;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("function ");
        if (context.getLanguageVersion() != 120) {
            stringBuilder.append("anonymous");
        }
        stringBuilder.append('(');
        for (int i = 0; i < n - 1; ++i) {
            if (i > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(ScriptRuntime.toString(objectArray[i]));
        }
        stringBuilder.append(") {");
        if (n != 0) {
            String string = ScriptRuntime.toString(objectArray[n - 1]);
            stringBuilder.append(string);
        }
        stringBuilder.append("\n}");
        String string = stringBuilder.toString();
        int[] nArray = new int[1];
        String string2 = Context.getSourcePositionFromStack(nArray);
        if (string2 == null) {
            string2 = "<eval'ed string>";
            nArray[0] = 1;
        }
        String string3 = ScriptRuntime.makeUrlForGeneratedScript(false, string2, nArray[0]);
        Scriptable scriptable2 = ScriptableObject.getTopLevelScope(scriptable);
        ErrorReporter errorReporter = DefaultErrorReporter.forEval(context.getErrorReporter());
        Evaluator evaluator = Context.createInterpreter();
        if (evaluator == null) {
            throw new JavaScriptException("Interpreter not present", string2, nArray[0]);
        }
        return context.compileFunction(scriptable2, string, evaluator, errorReporter, string3, 1, null);
    }

    @Override
    protected int findPrototypeId(String string) {
        int n;
        block8: {
            n = 0;
            String string2 = null;
            switch (string.length()) {
                case 4: {
                    char c = string.charAt(0);
                    if (c == 'b') {
                        string2 = "bind";
                        n = 6;
                        break;
                    }
                    if (c != 'c') break;
                    string2 = "call";
                    n = 5;
                    break;
                }
                case 5: {
                    string2 = "apply";
                    n = 4;
                    break;
                }
                case 8: {
                    char c = string.charAt(3);
                    if (c == 'o') {
                        string2 = "toSource";
                        n = 3;
                        break;
                    }
                    if (c != 't') break;
                    string2 = "toString";
                    n = 2;
                    break;
                }
                case 11: {
                    string2 = "constructor";
                    n = 1;
                    break;
                }
            }
            if (string2 == null || string2 == string || string2.equals(string)) break block8;
            n = 0;
        }
        return n;
    }
}

