/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.cache.StringInterner;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshot;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshotter;
import org.gradle.api.internal.changedetection.state.FilesSnapshotSet;
import org.gradle.api.internal.changedetection.state.OutputFilesSnapshotSerializer;
import org.gradle.internal.serialize.DefaultSerializerRegistry;
import org.gradle.internal.serialize.Serializer;
import org.gradle.internal.serialize.SerializerRegistry;
import org.gradle.util.ChangeListener;

public class OutputFilesCollectionSnapshotter
implements FileCollectionSnapshotter {
    private final FileCollectionSnapshotter snapshotter;
    private final StringInterner stringInterner;

    public OutputFilesCollectionSnapshotter(FileCollectionSnapshotter snapshotter, StringInterner stringInterner) {
        this.snapshotter = snapshotter;
        this.stringInterner = stringInterner;
    }

    public void registerSerializers(SerializerRegistry registry) {
        DefaultSerializerRegistry nested = new DefaultSerializerRegistry();
        this.snapshotter.registerSerializers((SerializerRegistry)nested);
        registry.register(OutputFilesSnapshot.class, (Serializer)new OutputFilesSnapshotSerializer((Serializer<FileCollectionSnapshot>)nested.build(FileCollectionSnapshot.class), this.stringInterner));
    }

    public FileCollectionSnapshot emptySnapshot() {
        return new OutputFilesSnapshot(Collections.<String, Boolean>emptyMap(), this.snapshotter.emptySnapshot());
    }

    public OutputFilesSnapshot snapshot(FileCollection files, boolean allowReuse) {
        HashMap<String, Boolean> roots = new HashMap<String, Boolean>();
        for (File file : files.getFiles()) {
            roots.put(this.stringInterner.intern(file.getAbsolutePath()), file.exists());
        }
        return new OutputFilesSnapshot(roots, this.snapshotter.snapshot(files, allowReuse));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class OutputFilesSnapshot
    implements FileCollectionSnapshot {
        final Map<String, Boolean> roots;
        final FileCollectionSnapshot filesSnapshot;

        public OutputFilesSnapshot(Map<String, Boolean> roots, FileCollectionSnapshot filesSnapshot) {
            this.roots = roots;
            this.filesSnapshot = filesSnapshot;
        }

        @Override
        public Collection<File> getFiles() {
            return this.filesSnapshot.getFiles();
        }

        @Override
        public FilesSnapshotSet getSnapshot() {
            return this.filesSnapshot.getSnapshot();
        }

        @Override
        public FileCollectionSnapshot updateFrom(FileCollectionSnapshot newSnapshot) {
            OutputFilesSnapshot newOutputsSnapshot = (OutputFilesSnapshot)newSnapshot;
            return new OutputFilesSnapshot(this.roots, this.filesSnapshot.updateFrom(newOutputsSnapshot.filesSnapshot));
        }

        @Override
        public FileCollectionSnapshot applyAllChangesSince(FileCollectionSnapshot oldSnapshot, FileCollectionSnapshot target) {
            OutputFilesSnapshot oldOutputsSnapshot = (OutputFilesSnapshot)oldSnapshot;
            OutputFilesSnapshot targetOutputsSnapshot = (OutputFilesSnapshot)target;
            return new OutputFilesSnapshot(this.roots, this.filesSnapshot.applyAllChangesSince(oldOutputsSnapshot.filesSnapshot, targetOutputsSnapshot.filesSnapshot));
        }

        @Override
        public FileCollectionSnapshot.ChangeIterator<String> iterateContentChangesSince(FileCollectionSnapshot oldSnapshot, Set<FileCollectionSnapshot.ChangeFilter> filters) {
            OutputFilesSnapshot other = (OutputFilesSnapshot)oldSnapshot;
            final FileCollectionSnapshot.ChangeIterator<String> rootFileIdIterator = this.iterateRootFileIdChanges(other);
            final FileCollectionSnapshot.ChangeIterator<String> fileIterator = this.filesSnapshot.iterateContentChangesSince(other.filesSnapshot, filters);
            return new FileCollectionSnapshot.ChangeIterator<String>(){

                @Override
                public boolean next(ChangeListener<String> listener) {
                    if (rootFileIdIterator.next(listener)) {
                        return true;
                    }
                    return fileIterator.next(listener);
                }
            };
        }

        private FileCollectionSnapshot.ChangeIterator<String> iterateRootFileIdChanges(OutputFilesSnapshot other) {
            HashMap<String, Boolean> added = new HashMap<String, Boolean>(this.roots);
            added.keySet().removeAll(other.roots.keySet());
            final Iterator addedIterator = added.keySet().iterator();
            HashMap<String, Boolean> removed = new HashMap<String, Boolean>(other.roots);
            removed.keySet().removeAll(this.roots.keySet());
            final Iterator removedIterator = removed.keySet().iterator();
            HashSet<String> changed = new HashSet<String>();
            for (Map.Entry<String, Boolean> current : this.roots.entrySet()) {
                Boolean otherValue = other.roots.get(current.getKey());
                if (otherValue == null || !otherValue.booleanValue() || otherValue.equals(current.getValue())) continue;
                changed.add(current.getKey());
            }
            final Iterator changedIterator = changed.iterator();
            return new FileCollectionSnapshot.ChangeIterator<String>(){

                @Override
                public boolean next(ChangeListener<String> listener) {
                    if (addedIterator.hasNext()) {
                        listener.added((String)addedIterator.next());
                        return true;
                    }
                    if (removedIterator.hasNext()) {
                        listener.removed((String)removedIterator.next());
                        return true;
                    }
                    if (changedIterator.hasNext()) {
                        listener.changed((String)changedIterator.next());
                        return true;
                    }
                    return false;
                }
            };
        }
    }
}

