/*! grafana - v3.0.4 - 2016-06-01
 * Copyright (c) 2016 Torkel Ödegaard; Licensed Apache-2.0 */

define("app/core/partials",["app/core/core_module"],function(a){a["default"].run(["$templateCache",function(a){"use strict";a.put("public/app/core/components/navbar/navbar.html",'<div class="navbar-inner"><a class="navbar-brand-btn pointer" ng-click="ctrl.contextSrv.toggleSideMenu()"><span class="navbar-brand-btn-background"><img src="public/img/grafana_icon.svg"></span><i class="icon-gf icon-gf-grafana_wordmark"></i> <i class="fa fa-caret-down"></i> <i class="fa fa-chevron-left"></i> </a><a href="{{ctrl.titleUrl}}" class="navbar-page-btn" ng-show="ctrl.title"><i class="{{ctrl.icon}}" ng-show="ctrl.icon"></i> <img ng-src="{{ctrl.iconUrl}}" ng-show="ctrl.iconUrl">{{ctrl.title}}</a><div ng-transclude></div></div>'),a.put("public/app/core/components/search/search.html",'<div class="search-container" ng-if="ctrl.isOpen"><div class="search-field-wrapper"><span style="position: relative"><input type="text" placeholder="Find dashboards by name" give-focus="ctrl.giveSearchFocus" tabindex="1" ng-keydown="ctrl.keyDown($event)" ng-model="ctrl.query.query" ng-model-options="{ debounce: 500 }" spellcheck="false" ng-change="ctrl.search()"></span><div class="search-switches"><i class="fa fa-filter"></i> <a class="pointer" href="javascript:void 0;" ng-click="ctrl.showStarred()" tabindex="2"><i class="fa fa-remove" ng-show="ctrl.query.starred"></i> starred </a>| <a class="pointer" href="javascript:void 0;" ng-click="ctrl.getTags()" tabindex="3"><i class="fa fa-remove" ng-show="ctrl.tagsMode"></i> tags </a><span ng-if="ctrl.query.tag.length">| <span ng-repeat="tagName in ctrl.query.tag"><a ng-click="ctrl.removeTag(tagName, $event)" tag-color-from-name="tagName" class="label label-tag"><i class="fa fa-remove"></i> {{tagName}}</a></span></span></div></div><div class="search-results-container" ng-if="ctrl.tagsMode"><div class="row"><div class="span6 offset1"><div ng-repeat="tag in ctrl.results" class="pointer" style="width: 180px; float: left" ng-class="{\'selected\': $index === ctrl.selectedIndex }" ng-click="ctrl.filterByTag(tag.term, $event)"><a class="search-result-tag label label-tag" tag-color-from-name="tag.term"><i class="fa fa-tag"></i> <span>{{tag.term}} &nbsp;({{tag.count}})</span></a></div></div></div></div><div class="search-results-container" ng-if="!ctrl.tagsMode"><h6 ng-hide="ctrl.results.length">No dashboards matching your query were found.</h6><a class="search-item pointer search-item-{{row.type}}" bindonce ng-repeat="row in ctrl.results" ng-class="{\'selected\': $index == ctrl.selectedIndex}" ng-href="{{row.url}}"><span class="search-result-tags"><span ng-click="ctrl.filterByTag(tag, $event)" ng-repeat="tag in row.tags" tag-color-from-name="tag" class="label label-tag">{{tag}} </span><i class="fa" ng-class="{\'fa-star\': row.isStarred, \'fa-star-o\': !row.isStarred}"></i> </span><span class="search-result-link"><i class="fa search-result-icon"></i> <span bo-text="row.title"></span></span></a></div><div class="search-button-row"><button class="btn btn-inverse pull-left" ng-click="ctrl.newDashboard()" ng-show="ctrl.contextSrv.isEditor"><i class="fa fa-plus"></i> New</button> <a class="btn btn-inverse pull-left" href="import/dashboard" ng-show="ctrl.contextSrv.isEditor"><i class="fa fa-download"></i> Import</a><div class="clearfix"></div></div></div>'),a.put("public/app/core/components/sidemenu/sidemenu.html",'<ul class="sidemenu"><li class="sidemenu-org-section" ng-if="::ctrl.isSignedIn" class="dropdown"><a class="sidemenu-org" href="profile"><div class="sidemenu-org-avatar"><img ng-src="{{::ctrl.user.gravatarUrl}}"> <span class="sidemenu-org-avatar--missing"><i class="fa fa-fw fa-user"></i></span></div><div class="sidemenu-org-details"><span class="sidemenu-org-user sidemenu-item-text">{{::ctrl.user.name}}</span> <span class="sidemenu-org-name sidemenu-item-text">{{::ctrl.user.orgName}}</span></div></a><i class="fa fa-caret-right"></i><ul class="dropdown-menu" role="menu"><li ng-repeat="menuItem in ctrl.orgMenu" ng-class="::menuItem.cssClass"><span ng-show="::menuItem.section">{{::menuItem.section}}</span> <a href="{{::menuItem.url}}" ng-show="::menuItem.url" target="{{::menuItem.target}}"><i class="{{::menuItem.icon}}" ng-show="::menuItem.icon"></i> {{::menuItem.text}}</a></li></ul></li><li ng-repeat="item in ::ctrl.mainLinks" class="dropdown"><a href="{{::item.url}}" class="sidemenu-item sidemenu-main-link" target="{{::item.target}}"><span class="icon-circle sidemenu-icon"><i class="{{::item.icon}}" ng-show="::item.icon"></i> <img ng-src="{{::item.img}}" ng-show="::item.img"> </span><span class="sidemenu-item-text">{{::item.text}}</span> <span class="fa fa-caret-right" ng-if="::item.children"></span></a><ul class="dropdown-menu" role="menu" ng-if="::item.children"><li ng-repeat="child in ::item.children" ng-class="{divider: child.divider}"><a href="{{::child.url}}"><i class="{{::child.icon}}" ng-show="::child.icon"></i> {{::child.text}}</a></li></ul></li><li ng-show="::!ctrl.isSignedIn"><a href="login" class="sidemenu-item" target="_self"><span class="icon-circle sidemenu-icon"><i class="fa fa-fw fa-sign-in"></i></span> <span class="sidemenu-item-text">Sign in</span></a></li><li><a class="sidemenu-item" target="_self" ng-hide="ctrl.contextSrv.pinned" ng-click="ctrl.contextSrv.setPinnedState(true)"><span class="icon-circle sidemenu-icon"><i class="fa fa-fw fa-thumb-tack"></i></span> <span class="sidemenu-item-text">Pin</span></a></li></ul>'),a.put("public/app/features/admin/partials/admin_home.html",'<navbar icon="fa fa-fw fa-cogs" title="Admin" title-url="admin"></navbar><div class="page-container"><div class="page-header"><h1>Server Administration</h1></div><a class="btn btn-inverse" href="admin/users">Manage Users </a><a class="btn btn-inverse" href="admin/orgs">Manage Organizations </a><a class="btn btn-inverse" href="admin/settings">View Server Settings </a><a class="btn btn-inverse" href="admin/stats">View Server Stats </a><a class="btn btn-inverse" href="styleguide">Style guide</a></div>'),a.put("public/app/features/admin/partials/edit_org.html",'<navbar icon="fa fa-fw fa-cogs" title="Admin" title-url="admin"><a href="admin/orgs" class="navbar-page-btn"><i class="icon-gf icon-gf-users"></i> Orgs</a></navbar><div class="page-container"><div class="page-header"><h1>Edit Organization</h1></div><form name="orgDetailsForm" class="gf-form-group"><div class="gf-form"><span class="gf-form-label width-10">Name</span> <input type="text" required ng-model="org.name" class="gf-form-input max-width-14"></div><div class="gf-form-button-row"><button type="submit" class="btn btn-success" ng-click="update()" ng-show="!createMode">Update</button></div></form><h3 class="page-heading">Organization Users</h3><table class="grafana-options-table"><tr><th>Username</th><th>Email</th><th>Role</th><th></th></tr><tr ng-repeat="orgUser in orgUsers"><td>{{orgUser.login}}</td><td>{{orgUser.email}}</td><td><select type="text" ng-model="orgUser.role" class="gf-form-input max-width-8" ng-options="f for f in [\'Viewer\', \'Editor\', \'Read Only Editor\', \'Admin\']" ng-change="updateOrgUser(orgUser)"></select></td><td style="width: 1%"><a ng-click="removeOrgUser(orgUser)" class="btn btn-danger btn-mini"><i class="fa fa-remove"></i></a></td></tr></table></div>'),a.put("public/app/features/admin/partials/edit_user.html",'<navbar icon="fa fa-fw fa-cogs" title="Admin" title-url="admin"><a href="admin/users" class="navbar-page-btn"><i class="icon-gf icon-gf-users"></i> Users</a></navbar><div class="page-container"><div class="page-header"><h1>Edit User</h1></div><form name="userForm" class="gf-form-group"><div class="gf-form"><span class="gf-form-label width-10">Name</span> <input type="text" required ng-model="user.name" class="gf-form-input max-width-25"></div><div class="gf-form"><span class="gf-form-label width-10">Email</span> <input type="email" ng-model="user.email" class="gf-form-input max-width-25"></div><div class="gf-form"><span class="gf-form-label width-10">Username</span> <input type="text" ng-model="user.login" class="gf-form-input max-width-25"></div><div class="gf-form-button-row"><button type="submit" class="btn btn-success" ng-click="update()" ng-show="!createMode">Update</button></div></form><h3 class="page-heading">Change password</h3><form name="passwordForm" class="gf-form-group"><div class="gf-form"><span class="gf-form-label width-10">New password</span> <input type="password" required ng-minlength="4" ng-model="password" class="gf-form-input max-width-25"></div><div class="gf-form-button-row"><button type="submit" class="btn btn-success" ng-click="setPassword()">Update</button></div></form><h3 class="page-heading">Permissions</h3><form name="passwordForm" class="gf-form-group"><div class="gf-form"><editor-checkbox text="Grafana Admin" model="permissions.isGrafanaAdmin" style="line-height: 1.5rem"></editor-checkbox></div><div class="gf-form-button-row"><button type="submit" class="btn btn-success" ng-click="updatePermissions()">Update</button></div></form><h3 class="page-heading">Organizations</h3><form name="addOrgForm" class="gf-form-group"><div class="gf-form-inline"><div class="gf-form"><span class="gf-form-label width-12">Add organization</span> <input type="text" ng-model="newOrg.name" bs-typeahead="searchOrgs" required class="gf-form-input max-width-20" placeholder="organization name"></div><div class="gf-form"><span class="gf-form-label">Role</span><select type="text" ng-model="newOrg.role" class="gf-form-input width-10" ng-options="f for f in [\'Viewer\', \'Editor\', \'Read Only Editor\', \'Admin\']"></select></div><div class="gf-form"><button class="btn btn-success gf-form-btn" ng-click="addOrgUser()">Add</button></div></div></form><table class="grafana-options-table"><tr><th>Name</th><th>Role</th><th></th></tr><tr ng-repeat="org in orgs"><td>{{org.name}} <span class="label label-info" ng-show="org.orgId === user.orgId">Current</span></td><td><select type="text" ng-model="org.role" class="gf-form-input max-width-12" ng-options="f for f in [\'Viewer\', \'Editor\', \'Read Only Editor\', \'Admin\']" ng-change="updateOrgUser(org)"></select></td><td style="width: 1%"><a ng-click="removeOrgUser(org)" class="btn btn-danger btn-mini"><i class="fa fa-remove"></i></a></td></tr></table></div>'),a.put("public/app/features/admin/partials/new_user.html",'<navbar icon="fa fa-fw fa-cogs" title="Admin" title-url="admin"><a href="admin/users" class="navbar-page-btn"><i class="icon-gf icon-gf-users"></i> Users</a></navbar><div class="page-container"><div class="page-header"><h1>Add new user</h1></div><form name="userForm" class="gf-form-group"><div class="gf-form"><span class="gf-form-label width-10">Name</span> <input type="text" required ng-model="user.name" class="gf-form-input max-width-20"></div><div class="gf-form"><span class="gf-form-label width-10">Email</span> <input type="email" ng-model="user.email" class="gf-form-input max-width-20"></div><div class="gf-form"><span class="gf-form-label width-10">Username</span> <input type="text" ng-model="user.login" class="gf-form-input max-width-20"></div><div class="gf-form"><span class="gf-form-label width-10">Password</span> <input type="password" required ng-model="user.password" class="gf-form-input max-width-20"></div><div class="gf-form-button-row"><button type="submit" class="btn btn-success" ng-click="create()">Create</button></div></form></div>'),a.put("public/app/features/admin/partials/orgs.html",'<navbar icon="fa fa-fw fa-cogs" title="Admin" title-url="admin"><a href="admin/orgs" class="navbar-page-btn"><i class="icon-gf icon-gf-users"></i> Orgs</a></navbar><div class="page-container"><div class="page-header"><h1>Organizations</h1></div><table class="filter-table form-inline"><thead><tr><th>Id</th><th>Name</th><th></th></tr></thead><tbody><tr ng-repeat="org in orgs"><td>{{org.id}}</td><td>{{org.name}}</td><td class="text-right"><a href="admin/orgs/edit/{{org.id}}" class="btn btn-inverse btn-small"><i class="fa fa-edit"></i> Edit </a>&nbsp;&nbsp; <a ng-click="deleteOrg(org)" class="btn btn-danger btn-small"><i class="fa fa-remove"></i></a></td></tr></tbody></table></div>'),a.put("public/app/features/admin/partials/settings.html",'<navbar icon="fa fa-fw fa-cogs" title="Admin" title-url="admin"></navbar><div class="page-container"><div class="page-header"><h1>Server settings</h1></div><div class="grafana-info-box span8" style="margin: 20px 0 25px 0">These system settings are defined in grafana.ini or grafana.custom.ini (or overriden in ENV variables). To change these you currently need to restart grafana.</div><table class="grafana-options-table"><tr ng-repeat-start="(secName, secValue) in settings"><td class="admin-settings-section">{{secName}}</td><td></td></tr><tr ng-repeat="(keyName, keyValue) in secValue" ng-repeat-end><td style="padding-left: 25px">{{keyName}}</td><td>{{keyValue}}</td></tr></table></div>'),a.put("public/app/features/admin/partials/stats.html",'<navbar icon="fa fa-fw fa-cogs" title="Admin" title-url="admin"></navbar><div class="page-container"><div class="page-header"><h1>Stats</h1></div><table class="filter-table form-inline"><thead><tr><th>Name</th><th>Value</th></tr></thead><tbody><tr><td>Total dashboards</td><td>{{ctrl.stats.dashboard_count}}</td></tr><tr><td>Total users</td><td>{{ctrl.stats.user_count}}</td></tr><tr><td>Total organizations</td><td>{{ctrl.stats.org_count}}</td></tr><tr><td>Total datasources</td><td>{{ctrl.stats.data_source_count}}</td></tr><tr><td>Total playlists</td><td>{{ctrl.stats.playlist_count}}</td></tr><tr><td>Total snapshots</td><td>{{ctrl.stats.db_snapshot_count}}</td></tr><tr><td>Total dashboard tags</td><td>{{ctrl.stats.db_tag_count}}</td></tr><tr><td>Total starred dashboards</td><td>{{ctrl.stats.starred_db_count}}</td></tr></tbody></table></div>'),a.put("public/app/features/admin/partials/users.html",'<navbar icon="fa fa-fw fa-cogs" title="Admin" title-url="admin"><a href="admin/users" class="navbar-page-btn"><i class="icon-gf icon-gf-users"></i> Users</a></navbar><div class="page-container"><div class="page-header"><h1>Users</h1><a class="btn btn-success" href="admin/users/create"><i class="fa fa-plus"></i> Add new user</a></div><table class="filter-table form-inline"><thead><tr><th>Id</th><th>Name</th><th>Login</th><th>Email</th><th style="white-space: nowrap">Grafana Admin</th><th></th></tr></thead><tbody><tr ng-repeat="user in users"><td>{{user.id}}</td><td>{{user.name}}</td><td>{{user.login}}</td><td>{{user.email}}</td><td>{{user.isAdmin}}</td><td class="text-right"><a href="admin/users/edit/{{user.id}}" class="btn btn-inverse btn-small"><i class="fa fa-edit"></i> Edit </a>&nbsp;&nbsp; <a ng-click="deleteUser(user)" class="btn btn-danger btn-small"><i class="fa fa-remove"></i></a></td></tr></tbody></table></div>'),a.put("public/app/features/annotations/partials/editor.html",'<div ng-controller="AnnotationsEditorCtrl" ng-init="init()"><div class="tabbed-view-header"><h2 class="tabbed-view-title">Annotations</h2><ul class="gf-tabs"><li class="gf-tabs-item"><a class="gf-tabs-link" ng-click="mode = \'list\';" ng-class="{active: mode === \'list\'}">List</a></li><li class="gf-tabs-item" ng-show="mode === \'edit\'"><a class="gf-tabs-link" ng-class="{active: mode === \'edit\'}">{{currentAnnotation.name}}</a></li><li class="gf-tabs-item" ng-show="mode === \'new\'"><span class="active gf-tabs-link">New</span></li></ul><button class="tabbed-view-close-btn" ng-click="dismiss();"><i class="fa fa-remove"></i></button></div><div class="tabbed-view-body"><div class="editor-row row" ng-if="mode === \'list\'"><div ng-if="annotations.length === 0"><em>No annotations defined</em></div><table class="grafana-options-table"><tr ng-repeat="annotation in annotations"><td style="width:90%"><i class="fa fa-bolt" style="color:{{annotation.iconColor}}"></i> &nbsp; {{annotation.name}}</td><td style="width: 1%"><i ng-click="_.move(annotations,$index,$index-1)" ng-hide="$first" class="pointer fa fa-arrow-up"></i></td><td style="width: 1%"><i ng-click="_.move(annotations,$index,$index+1)" ng-hide="$last" class="pointer fa fa-arrow-down"></i></td><td style="width: 1%"><a ng-click="edit(annotation)" class="btn btn-inverse btn-mini"><i class="fa fa-edit"></i> Edit</a></td><td style="width: 1%"><a ng-click="removeAnnotation(annotation)" class="btn btn-danger btn-mini"><i class="fa fa-remove"></i></a></td></tr></table></div><div class="gf-form" ng-show="mode === \'list\'"><div class="gf-form-button-row"><a type="button" class="btn gf-form-button btn-success" ng-click="mode = \'new\';"><i class="fa fa-plus"></i>&nbsp;&nbsp;New</a></div></div><div class="annotations-basic-settings" ng-if="mode === \'edit\' || mode === \'new\'"><div class="gf-form-group"><div class="gf-form-inline"><div class="gf-form gf-size-max-xxl"><span class="gf-form-label">Name</span> <input type="text" class="gf-form-input" ng-model="currentAnnotation.name" placeholder="name"></div><div class="gf-form"><span class="gf-form-label max-width-10">Datasource</span><div class="gf-form-select-wrapper"><select class="gf-form-input gf-size-auto" ng-model="currentAnnotation.datasource" ng-options="f.name as f.name for f in datasources" ng-change="datasourceChanged()"></select></div></div><div class="gf-form"><label class="gf-form-label"><span>Color</span></label><spectrum-picker class="gf-form-input" ng-model="currentAnnotation.iconColor"></spectrum-picker></div></div></div><rebuild-on-change property="currentDatasource"><plugin-component type="annotations-query-ctrl"></plugin-component></rebuild-on-change><div class="gf-form"><div class="gf-form-button-row p-y-0"><button ng-show="mode === \'new\'" type="button" class="btn gf-form-button btn-success" ng-click="add()">Add</button> <button ng-show="mode === \'edit\'" type="button" class="btn btn-success pull-left" ng-click="update()">Update</button></div></div></div></div></div>'),a.put("public/app/features/dashboard/dashnav/dashnav.html",'<navbar><a class="pointer navbar-page-btn" ng-if="::!dashboardMeta.isSnapshot" ng-click="openSearch()"><i class="icon-gf icon-gf-dashboard"></i> <span>{{dashboard.title}}</span> <i class="fa fa-caret-down"></i> </a><a class="pointer navbar-page-btn" ng-if="::dashboardMeta.isSnapshot" bs-tooltip="titleTooltip" data-placement="bottom" ng-click="openSearch()"><i class="icon-gf icon-gf-snapshot"></i> <span>{{dashboard.title}} <em class="small">&nbsp;&nbsp;(snapshot)</em></span></a><ul class="nav pull-left dashnav-action-icons"><li ng-show="::dashboardMeta.canStar"><a class="pointer" ng-click="starDashboard()"><i class="fa" ng-class="{\'fa-star-o\': !dashboardMeta.isStarred, \'fa-star\': dashboardMeta.isStarred}" style="color: orange"></i></a></li><li ng-show="::dashboardMeta.canShare" class="dropdown"><a class="pointer" ng-click="hideTooltip($event)" bs-tooltip="\'Share dashboard\'" data-placement="bottom" data-toggle="dropdown"><i class="fa fa-share-square-o"></i></a><ul class="dropdown-menu"><li><a class="pointer" ng-click="shareDashboard(0)"><i class="fa fa-link"></i> Link to Dashboard</a></li><li><a class="pointer" ng-click="shareDashboard(1)"><i class="icon-gf icon-gf-snapshot"></i>Snapshot sharing</a></li></ul></li><li ng-show="::dashboardMeta.canSave"><a ng-click="saveDashboard()" bs-tooltip="\'Save dashboard <br> CTRL+S\'" data-placement="bottom"><i class="fa fa-save"></i></a></li><li ng-if="::showSettingsMenu" class="dropdown"><a class="pointer" ng-click="hideTooltip($event)" bs-tooltip="\'Manage dashboard\'" data-placement="bottom" data-toggle="dropdown"><i class="fa fa-cog"></i></a><ul class="dropdown-menu"><li ng-if="dashboardMeta.canEdit"><a class="pointer" ng-click="openEditView(\'settings\');">Settings</a></li><li ng-if="dashboardMeta.canEdit"><a class="pointer" ng-click="openEditView(\'annotations\');">Annotations</a></li><li ng-if="dashboardMeta.canEdit"><a class="pointer" ng-click="openEditView(\'templating\');">Templating</a></li><li ng-if="dashboardMeta.canEdit"><a class="pointer" ng-click="exportDashboard();">Export</a></li><li ng-if="dashboardMeta.canEdit"><a class="pointer" ng-click="editJson();">View JSON</a></li><li ng-if="contextSrv.isEditor && !dashboard.editable"><a class="pointer" ng-click="makeEditable();">Make Editable</a></li><li ng-if="contextSrv.isEditor"><a class="pointer" ng-click="saveDashboardAs();">Save As...</a></li><li ng-if="dashboardMeta.canSave"><a class="pointer" ng-click="deleteDashboard();">Delete dashboard</a></li></ul></li></ul><ul class="nav dash-playlist-actions" ng-if="playlistSrv"><li><a ng-click="playlistSrv.prev()"><i class="fa fa-step-backward"></i></a></li><li><a ng-click="playlistSrv.stop()"><i class="fa fa-stop"></i></a></li><li><a ng-click="playlistSrv.next()"><i class="fa fa-step-forward"></i></a></li></ul><ul class="nav pull-right"><li ng-show="dashboard.meta.fullscreen" class="dashnav-back-to-dashboard"><a ng-click="exitFullscreen()">Back to dashboard</a></li><li ng-if="dashboard"><gf-time-picker dashboard="dashboard"></gf-time-picker></li></ul></navbar>'),a.put("public/app/features/dashboard/partials/globalAlerts.html",'<topnav title="Alerting" subnav="false"><ul class="nav"><li class="active"><a href="global-alerts">Global Alerts</a></li></ul></topnav><div class="page-container"><div class="page-wide"><h1>Global alerts</h1><div class="filter-controls-filters"><div class="tight-form last"><ul class="tight-form-list"><li class="tight-form-item">Filters:</li><li class="tight-form-item">Alert State</li><li></li><li class="tight-form-item">Dashboards</li><li></li><li class="tight-form-item"><a class="pointer"><i class="fa fa-pencil"></i></a></li></ul><div class="clearfix"></div></div></div><ul class="filter-controls-actions"><li><div class="dropdown"><button class="btn btn-inverse dropdown-toggle" data-toggle="dropdown"><input class="cr1" id="state-enabled" type="checkbox"><label for="state-enabled" class="cr1"></label><span class="caret"></span></button><ul class="dropdown-menu" role="menu"><li><a>All</a></li></ul></div></li><li><div class="dropdown"><button class="btn btn-inverse dropdown-toggle" data-toggle="dropdown">Bulk Actions &nbsp; <span class="caret"></span></button><ul class="dropdown-menu" role="menu"><li><a>Update notifications</a></li></ul></div></li><li><button class="btn btn-inverse" data-toggle="dropdown"><i class="fa fa-fw fa-th-large"></i> New Dashboard from selected</button></li><li><span class="filter-controls-actions-selected">2 selected, showing 6 of 6 total</span></li></ul><ul class="filter-list"><li><ul class="filter-list-card"><li class="filter-list-card-select"><input class="cr1" id="alert1" type="checkbox"><label for="alert1" class="cr1"></label></li><li><div class="filter-list-card-controls"><div class="filter-list-card-links"><span class="filter-list-card-link"><i class="fa fa-fw fa-th-large"></i>: <a href="">OpSec Super Sekret</a></span> <span class="filter-list-card-link">Panel: <a href="">Prod CPU Data Writes</a></span></div><div class="filter-list-card-config"><a href="#"><i class="fa fa-cog"></i></a></div><div class="filter-list-card-expand" ng-click="alert1.expanded = !alert1.expanded"><i class="fa fa-angle-right" ng-show="!alert1.expanded"></i> <i class="fa fa-angle-down" ng-show="alert1.expanded"></i></div></div><span class="filter-list-card-title">Prod CPU Data Writes</span> <span class="filter-list-card-status"><span class="filter-list-card-state online">Online</span> for 19 hours</span></li></ul><div class="filter-list-card-details" ng-show="alert1.expanded"><h5 class="filter-list-card-details-heading">Alert query <a>configure alerting</a></h5><div class="tight-form last"><ul class="tight-form-list"><li class="tight-form-item" style="min-width: 15px; text-align: center">A</li><li class="tight-form-item">apps</li><li class="tight-form-item"><i class="fa fa-asterisk"><i></i></i></li><li class="tight-form-item">fakesite</li><li class="tight-form-item">counters</li><li class="tight-form-item">requests</li><li class="tight-form-item">count</li><li class="tight-form-item">scaleToSeconds(1)</li><li class="tight-form-item">aliasByNode(2)</li></ul><div class="clearfix"></div></div></div></li><li><ul class="filter-list-card"><li class="filter-list-card-select"><input class="cr1" id="alert2" type="checkbox" checked="checked"><label for="alert2" class="cr1"></label></li><li><div class="filter-list-card-controls"><div class="filter-list-card-links"><span class="filter-list-card-link"><i class="fa fa-fw fa-th-large"></i>: <a href="">OpSec Insanely Super Duper Sekret</a></span> <span class="filter-list-card-link">Panel: <a href="">client side full page load</a></span></div><div class="filter-list-card-config"><a href="#"><i class="fa fa-cog"></i></a></div><div class="filter-list-card-expand" ng-click="alert2.expanded = !alert2.expanded"><i class="fa fa-angle-right" ng-show="!alert2.expanded"></i> <i class="fa fa-angle-down" ng-show="alert2.expanded"></i></div></div><span class="filter-list-card-title">Prod DB Reads</span> <span class="filter-list-card-status"><span class="filter-list-card-state warn">Warn</span> for 1 hour</span></li></ul><div class="filter-list-card-details" ng-show="alert2.expanded"><h5 class="filter-list-card-details-heading">Alert query <a>configure alerting</a></h5><div class="tight-form last"><ul class="tight-form-list"><li class="tight-form-item" style="min-width: 15px; text-align: center">A</li><li class="tight-form-item">apps</li><li class="tight-form-item"><i class="fa fa-asterisk"><i></i></i></li><li class="tight-form-item">fakesite</li><li class="tight-form-item">counters</li><li class="tight-form-item">requests</li><li class="tight-form-item">count</li><li class="tight-form-item">scaleToSeconds(1)</li><li class="tight-form-item">aliasByNode(2)</li></ul><div class="clearfix"></div></div></div></li><li><ul class="filter-list-card"><li class="filter-list-card-select"><input class="cr1" id="alert3" type="checkbox" checked="checked"><label for="alert3" class="cr1"></label></li><li><div class="filter-list-card-controls"><div class="filter-list-card-links"><span class="filter-list-card-link"><i class="fa fa-fw fa-th-large"></i>: <a href="">OpSec Mildly Sekret</a></span> <span class="filter-list-card-link">Panel: <a href="">Memory/CPU</a></span></div><div class="filter-list-card-config"><a href="#"><i class="fa fa-cog"></i></a></div><div class="filter-list-card-expand" ng-click="alert3.expanded = !alert3.expanded"><i class="fa fa-angle-right" ng-show="!alert3.expanded"></i> <i class="fa fa-angle-down" ng-show="alert3.expanded"></i></div></div><span class="filter-list-card-title">Prod CPU Data Writes</span> <span class="filter-list-card-status"><span class="filter-list-card-state critical">Online</span> for 10 minutes</span></li></ul><div class="filter-list-card-details" ng-show="alert3.expanded"><h5 class="filter-list-card-details-heading">Alert query <a>configure alerting</a></h5><div class="tight-form last"><ul class="tight-form-list"><li class="tight-form-item" style="min-width: 15px; text-align: center">A</li><li class="tight-form-item">apps</li><li class="tight-form-item"><i class="fa fa-asterisk"><i></i></i></li><li class="tight-form-item">fakesite</li><li class="tight-form-item">counters</li><li class="tight-form-item">requests</li><li class="tight-form-item">count</li><li class="tight-form-item">scaleToSeconds(1)</li><li class="tight-form-item">aliasByNode(2)</li></ul><div class="clearfix"></div></div></div></li><li><ul class="filter-list-card"><li class="filter-list-card-select"><input class="cr1" id="alert4" type="checkbox"><label for="alert4" class="cr1"></label></li><li><div class="filter-list-card-controls"><div class="filter-list-card-links"><span class="filter-list-card-link"><i class="fa fa-fw fa-th-large"></i>: <a href="">OpSec Super Sekret</a></span> <span class="filter-list-card-link">Panel: <a href="">Stacked lines</a></span></div><div class="filter-list-card-config"><a href="#"><i class="fa fa-cog"></i></a></div><div class="filter-list-card-expand" ng-click="alert4.expanded = !alert4.expanded"><i class="fa fa-angle-right" ng-show="!alert4.expanded"></i> <i class="fa fa-angle-down" ng-show="alert4.expanded"></i></div></div><span class="filter-list-card-title">Critical Thing</span> <span class="filter-list-card-status"><span class="filter-list-card-state online">Online</span> for 5 weeks</span></li></ul><div class="filter-list-card-details" ng-show="alert4.expanded"><h5 class="filter-list-card-details-heading">Alert query <a>configure alerting</a></h5><div class="tight-form last"><ul class="tight-form-list"><li class="tight-form-item" style="min-width: 15px; text-align: center">A</li><li class="tight-form-item">apps</li><li class="tight-form-item"><i class="fa fa-asterisk"><i></i></i></li><li class="tight-form-item">fakesite</li><li class="tight-form-item">counters</li><li class="tight-form-item">requests</li><li class="tight-form-item">count</li><li class="tight-form-item">scaleToSeconds(1)</li><li class="tight-form-item">aliasByNode(2)</li></ul><div class="clearfix"></div></div></div></li><li><ul class="filter-list-card"><li class="filter-list-card-select"><input class="cr1" id="alert5" type="checkbox"><label for="alert5" class="cr1"></label></li><li><div class="filter-list-card-controls"><div class="filter-list-card-links"><span class="filter-list-card-link"><i class="fa fa-fw fa-th-large"></i>: <a href="">OpSec Public</a></span> <span class="filter-list-card-link">Panel: <a href="">More Critical Thing</a></span></div><div class="filter-list-card-config"><a href="#"><i class="fa fa-cog"></i></a></div><div class="filter-list-card-expand" ng-click="alert5.expanded = !alert5.expanded"><i class="fa fa-angle-right" ng-show="!alert5.expanded"></i> <i class="fa fa-angle-down" ng-show="alert5.expanded"></i></div></div><span class="filter-list-card-title">More Critical Thing</span> <span class="filter-list-card-status"><span class="filter-list-card-state online">Online</span> for 2 months</span></li></ul><div class="filter-list-card-details" ng-show="alert5.expanded"><h5 class="filter-list-card-details-heading">Alert query <a>configure alerting</a></h5><div class="tight-form last"><ul class="tight-form-list"><li class="tight-form-item" style="min-width: 15px; text-align: center">A</li><li class="tight-form-item">apps</li><li class="tight-form-item"><i class="fa fa-asterisk"><i></i></i></li><li class="tight-form-item">fakesite</li><li class="tight-form-item">counters</li><li class="tight-form-item">requests</li><li class="tight-form-item">count</li><li class="tight-form-item">scaleToSeconds(1)</li><li class="tight-form-item">aliasByNode(2)</li></ul><div class="clearfix"></div></div></div></li></ul></div></div>'),a.put("public/app/features/dashboard/partials/graphiteImport.html",'<div ng-controller="GraphiteImportCtrl" ng-init="init()"><div ng-if="datasources.length > 0"><h2 class="page-heading">Load dashboard from Graphite-Web</h2><div class="gf-form-group"><div class="gf-form-inline"><div class="gf-form"><span class="gf-form-label width-10">Data source</span></div><div class="gf-form"><div class="gf-form-select-wrapper"><select type="text" ng-model="options.sourceName" class="gf-form-input gf-size-auto" ng-options="f for f in datasources"></select></div></div><div class="gf-form"><button class="btn btn-success pull-right" ng-click="listAll()">List dashboards</button></div></div></div><table class="grafana-options-table" style="margin-top: 20px"><tr ng-repeat="dash in dashboards"><td style="">{{dash.name}}</td><td><button class="btn btn-inverse pull-right" ng-click="import(dash.name)">Load</button></td></tr></table></div></div>'),a.put("public/app/features/dashboard/partials/import.html",'<navbar title="Import" title-url="import/dashboard" icon="fa fa-download"></navbar><div class="page-container"><div class="page-header"><h1>Import file <em style="font-size: 14px;padding-left: 10px"><i class="fa fa-info-circle"></i> Load dashboard from local .json file</em></h1></div><div class="gf-form-group"><form class="gf-form"><input type="file" id="dashupload" dash-upload><br></form></div><h5 class="section-heading">Migrate dashboards <em style="font-size: 14px;padding-left: 10px"><i class="fa fa-info-circle"></i> Import dashboards from Elasticsearch or InfluxDB</em></h5><div class="gf-form-inline gf-form-group"><div class="gf-form"><div class="gf-form-label">Dashboard source</div><div class="gf-form-select-wrapper"><select class="gf-form-input gf-size-auto" ng-model="sourceName" ng-options="f for f in datasources"></select></div></div><div class="gf-form"><button class="btn btn-success gf-form-btn" ng-click="startImport()">Import</button></div></div><h5 class="section-heading" ng-if="importing">{{infoText}}</h5><div class="editor-row" ng-if="importing"><div class="editor-row row"><table class="grafana-options-table span5"><tr ng-repeat="dash in imported"><td>{{dash.name}}</td><td>{{dash.info}}</td></tr></table></div></div><div ng-include="\'public/app/features/dashboard/partials/graphiteImport.html\'"></div></div>'),
a.put("public/app/features/dashboard/partials/saveDashboardAs.html",'<div class="modal-body" ng-controller="SaveDashboardAsCtrl" ng-init="init();"><div class="modal-header"><h2 class="modal-header-title"><i class="fa fa-copy"></i> <span class="p-l-1">Save As...</span></h2><a class="modal-header-close" ng-click="dismiss();"><i class="fa fa-remove"></i></a></div><div class="modal-content"><div class="p-t-2"><div class="gf-form"><label class="gf-form-label">New name</label><input type="text" class="gf-form-input" ng-model="clone.title" give-focus="true" ng-keydown="keyDown($event)"></div></div><div class="gf-form-button-row text-center"><a class="btn btn-success" ng-click="saveClone();">Save</a> <a class="btn-text" ng-click="dismiss();">Cancel</a></div></div></div>'),a.put("public/app/features/dashboard/partials/settings.html",'<div class="tabbed-view-header"><h2 class="tabbed-view-title">Settings</h2><ul class="gf-tabs"><li class="gf-tabs-item" ng-repeat="tab in ::[\'General\', \'Rows\', \'Links\', \'Time picker\', \'Metadata\']"><a class="gf-tabs-link" ng-click="editor.index = $index" ng-class="{active: editor.index === $index}">{{::tab}}</a></li></ul><button class="tabbed-view-close-btn" ng-click="dismiss();"><i class="fa fa-remove"></i></button></div><div class="tabbed-view-body"><div ng-if="editor.index == 0"><div class="gf-form-group section"><h5 class="section-heading">Details</h5><div class="gf-form"><label class="gf-form-label width-7">Title</label><input type="text" class="gf-form-input width-25" ng-model="dashboard.title"></div><div class="gf-form"><label class="gf-form-label width-7">Tags<info-popover mode="right-normal">Press enter to a add tag</info-popover></label><bootstrap-tagsinput ng-model="dashboard.tags" tagclass="label label-tag" placeholder="add tags"></bootstrap-tagsinput></div><div class="gf-form"><label class="gf-form-label width-7">Timezone</label><div class="gf-form-select-wrapper"><select ng-model="dashboard.timezone" class="gf-form-input" ng-options="f.value as f.text for f in [{value: \'\', text: \'Default\'}, {value: \'browser\', text: \'Local browser time\'},{value: \'utc\', text: \'UTC\'}]" ng-change="timezoneChanged()"></select></div></div></div><div class="section"><h5 class="section-heading">Toggles</h5><div class="gf-form-group"><gf-form-switch class="gf-form" label="Editable" tooltip="Uncheck, then save and reload to disable all dashboard editing" checked="dashboard.editable" label-class="width-11"></gf-form-switch><gf-form-switch class="gf-form" label="Hide Controls" tooltip="Hide row controls. Shortcut: CTRL+H" checked="dashboard.hideControls" label-class="width-11"></gf-form-switch><gf-form-switch class="gf-form" label="Shared Crosshair" tooltip="Shared Crosshair line on all graphs. Shortcut: CTRL+O" checked="dashboard.sharedCrosshair" label-class="width-11"></gf-form-switch></div></div></div><div ng-if="editor.index == 1"><h5 class="section-heading">Rows settings</h5><div class="gf-form-group"><div class="gf-form-inline" ng-repeat="row in dashboard.rows"><div class="gf-form"><span class="gf-form-label">Title</span> <input type="text" class="gf-form-input max-width-14" ng-model="row.title"></div><gf-form-switch class="gf-form" label="Show title" checked="row.showTitle" switch-class="max-width-6"></gf-form-switch><div class="gf-form"><button class="btn btn-inverse gf-form-btn" ng-click="_.move(dashboard.rows,$index,$index-1)"><i ng-class="{\'invisible\': $first}" class="fa fa-arrow-up"></i></button> <button class="btn btn-inverse gf-from-btn" ng-click="_.move(dashboard.rows,$index,$index+1)"><i ng-class="{\'invisible\': $last}" class="fa fa-arrow-down"></i></button> <button class="btn btn-inverse gf-form-btn" ng-click="dashboard.rows = _.without(dashboard.rows,row)"><i class="fa fa-trash"></i></button></div></div></div></div><div ng-if="editor.index == 2"><dash-links-editor></dash-links-editor></div><div ng-if="editor.index == 3"><gf-time-picker-settings dashboard="dashboard"></gf-time-picker-settings></div><div ng-if="editor.index == 4"><h5 class="section-heading">Dashboard info</h5><div class="gf-form-group"><div class="gf-form"><span class="gf-form-label width-10">Last updated at:</span> <span class="gf-form-label width-18">{{formatDate(dashboardMeta.updated)}}</span></div><div class="gf-form"><span class="gf-form-label width-10">Last updated by:</span> <span class="gf-form-label width-18">{{dashboardMeta.updatedBy}}&nbsp;</span></div><div class="gf-form"><span class="gf-form-label width-10">Created at:</span> <span class="gf-form-label width-18">{{formatDate(dashboardMeta.created)}}&nbsp;</span></div><div class="gf-form"><span class="gf-form-label width-10">Created by:</span> <span class="gf-form-label width-18">{{dashboardMeta.createdBy}}&nbsp;</span></div><div class="gf-form"><span class="gf-form-label width-10">Current version:</span> <span class="gf-form-label width-18">{{dashboardMeta.version}}&nbsp;</span></div></div></div></div>'),a.put("public/app/features/dashboard/partials/shareModal.html",'<div class="modal-body" ng-controller="ShareModalCtrl" ng-init="init()"><div class="modal-header"><h2 class="modal-header-title">{{modalTitle}}</h2><ul class="gf-tabs"><li class="gf-tabs-item" ng-repeat="tab in tabs"><a class="gf-tabs-link" ng-click="editor.index = $index" ng-class="{active: editor.index === $index}">{{::tab.title}}</a></li></ul><a class="modal-header-close" ng-click="dismiss();"><i class="fa fa-remove"></i></a></div><div class="modal-content" ng-repeat="tab in tabs" ng-if="editor.index == $index"><div ng-include src="tab.src" class="share-modal-body"></div></div></div><script type="text/ng-template" id="shareEmbed.html"><div class="share-modal-big-icon">\n		<i class="fa fa-code"></i>\n	</div>\n\n	<div class="share-snapshot-header">\n		<p class="share-snapshot-info-text">\n			The html code below can be pasted and included in another web page. Unless anonymous access\n			is enabled the user viewing that page need to be signed into grafana for the graph to load.\n		</p>\n	</div>\n\n	<div ng-include src="\'shareLinkOptions.html\'"></div>\n\n	<div class="gf-form-group section">\n		<div class="gf-form width-30">\n			<textarea rows="5" data-share-panel-url class="gf-form-input width-30" ng-model=\'iframeHtml\'></textarea>\n		</div>\n	</div></script><script type="text/ng-template" id="shareLinkOptions.html"><div class="gf-form-group section">\n		<gf-form-switch class="gf-form"\n			label="Current time range" label-class="width-12" switch-class="max-width-6"\n			checked="options.forCurrent" on-change="buildUrl()">\n		</gf-form-switch>\n		<gf-form-switch class="gf-form"\n			label="Template variables" label-class="width-12" switch-class="max-width-6"\n			checked="options.includeTemplateVars" on-change="buildUrl()">\n		</gf-form-switch>\n		<div class="gf-form">\n			<span class="gf-form-label width-12">Theme</span>\n			<div class="gf-form-select-wrapper width-6">\n				<select class="gf-form-input" ng-model="options.theme" ng-options="f as f for f in [\'current\', \'dark\', \'light\']" ng-change="buildUrl()"></select>\n			</div>\n		</div>\n	</div></script><script type="text/ng-template" id="shareLink.html"><div class="share-modal-big-icon">\n		<i class="fa fa-link"></i>\n	</div>\n\n	<div ng-include src="\'shareLinkOptions.html\'"></div>\n	<div>\n		<div class="gf-form-group section">\n			<div class="gf-form-inline">\n				<div class="gf-form width-30">\n					<input type="text" data-share-panel-url class="gf-form-input" ng-model="shareUrl"></input>\n				</div>\n				<div class="gf-form pull-right">\n					<button class="btn btn-inverse pull-right" data-clipboard-text="{{shareUrl}}" clipboard-button><i class="fa fa-clipboard"></i> Copy</button>\n				</div>\n			</div>\n		</div>\n	</div>\n	<div class="gf-form section" ng-show="modeSharePanel">\n		<a href="{{imageUrl}}" target="_blank"><i class="fa fa-camera"></i> Direct link rendered image</a>\n	</div></script><script type="text/ng-template" id="shareSnapshot.html"><div class="ng-cloak" ng-cloak ng-controller="ShareSnapshotCtrl" ng-init="init()">\n		<div class="share-modal-big-icon">\n			<i ng-if="loading" class="fa fa-spinner fa-spin"></i>\n			<i ng-if="!loading" class="icon-gf icon-gf-snapshot"></i>\n		</div>\n\n		<div class="share-snapshot-header" ng-if="step === 1">\n			<p class="share-snapshot-info-text">\n				A snapshot is an instant way to share an interactive dashboard publicly.\n				When created, we <strong>strip sensitive data</strong> like queries (metric, template and annotation) and panel links,\n				leaving only the visible metric data and series names embedded into your dashboard.\n			</p>\n			<p class="share-snapshot-info-text">\n				Keep in mind, your <strong>snapshot can be viewed by anyone</strong> that has the link and can reach the URL.\n				Share wisely.\n			</p>\n		</div>\n\n		<div class="share-snapshot-header" ng-if="step === 3">\n			<p class="share-snapshot-info-text">\n				The snapshot has now been deleted. If it you have already accessed it once, It might take up to an hour before it is removed from\n				browser caches or CDN caches.\n			</p>\n		</div>\n\n		<div class="gf-form-group share-modal-options">\n			<div class="gf-form" ng-if="step === 1">\n				<span class="gf-form-label width-12">Snapshot name</span>\n				<input type="text" ng-model="snapshot.name" class="gf-form-input max-width-15" >\n			</div>\n			<div class="gf-form" ng-if="step === 1">\n				<span class="gf-form-label width-12">Expire</span>\n				<div class="gf-form-select-wrapper max-width-15">\n					<select class="gf-form-input" ng-model="snapshot.expires" ng-options="f.value as f.text for f in expireOptions"></select>\n				</div>\n			</div>\n\n			<div class="gf-form" ng-if="step === 2" style="margin-top: 40px">\n				<div class="gf-form-row">\n					<a href="{{snapshotUrl}}" class="large share-snapshot-link" target="_blank">\n						<i class="fa fa-external-link-square"></i>\n						{{snapshotUrl}}\n					</a>\n					<br>\n					<button class="btn btn-inverse btn-large" data-clipboard-text="{{snapshotUrl}}" clipboard-button><i class="fa fa-clipboard"></i> Copy Link</button>\n				</div>\n			</div>\n		</div>\n\n		<div ng-if="step === 1" class="gf-form-buttons-row">\n			<button class="btn btn-success btn-large" ng-click="createSnapshot()" ng-disabled="loading">\n				<i class="fa fa-save"></i>\n				Local Snapshot\n			</button>\n			<button class="btn btn-primary btn-large" ng-if="externalEnabled" ng-click="createSnapshot(true)" ng-disabled="loading">\n				<i class="fa fa-cloud-upload"></i>\n				{{sharingButtonText}}\n			</button>\n		</div>\n\n		<div class="pull-right" ng-if="step === 2" style="padding: 5px">\n			Did you make a mistake? <a class="pointer" ng-click="deleteSnapshot()" target="_blank">delete snapshot.</a>\n		</div>\n	</div>\n\n</div></script>'),a.put("public/app/features/dashboard/submenu/submenu.html",'<div class="submenu-controls"><ul ng-if="ctrl.dashboard.templating.list.length > 0"><li ng-repeat="variable in ctrl.variables" ng-hide="variable.hide === 2" class="submenu-item"><span class="submenu-item-label template-variable" ng-hide="variable.hide === 1">{{variable.label || variable.name}}:</span><value-select-dropdown variable="variable" on-updated="ctrl.variableUpdated(variable)" get-values-for-tag="ctrl.getValuesForTag(variable, tagKey)"></value-select-dropdown></li></ul><ul ng-if="ctrl.dashboard.annotations.list.length > 0"><li ng-repeat="annotation in ctrl.dashboard.annotations.list" class="submenu-item annotation-segment" ng-class="{\'annotation-disabled\': !annotation.enable}"><a ng-click="ctrl.disableAnnotation(annotation)"><i class="fa fa-bolt" style="color:{{annotation.iconColor}}"></i> {{annotation.name}} <input class="cr1" id="hideYAxis" type="checkbox" ng-model="annotation.enable" ng-checked="annotation.enable"><label for="hideYAxis" class="cr1"></label></a></li></ul><ul class="pull-right" ng-if="ctrl.dashboard.links.length > 0"><dash-links-container links="ctrl.dashboard.links"></dash-links-container></ul><div class="clearfix"></div></div>'),a.put("public/app/features/dashboard/timepicker/dropdown.html",'<div class="row pull-right"><form name="timeForm" class="gf-timepicker-absolute-section"><h3>Time range</h3><label class="small">From:</label><div class="gf-form-inline"><div class="gf-form max-width-28"><input type="text" class="gf-form-input input-large" ng-model="ctrl.timeRaw.from" input-datetime></div><div class="gf-form"><button class="btn gf-form-btn btn-primary" type="button" ng-click="openFromPicker=!openFromPicker"><i class="fa fa-calendar"></i></button></div></div><div ng-if="openFromPicker"><datepicker ng-model="ctrl.absolute.fromJs" class="gf-timepicker-component" show-weeks="false" ng-change="ctrl.absoluteFromChanged()"></datepicker></div><label class="small">To:</label><div class="gf-form-inline"><div class="gf-form max-width-28"><input type="text" class="gf-form-input input-large" ng-model="ctrl.timeRaw.to" input-datetime></div><div class="gf-form"><button class="btn gf-form-btn btn-primary" type="button" ng-click="openToPicker=!openToPicker"><i class="fa fa-calendar"></i></button></div></div><div ng-if="openToPicker"><datepicker ng-model="ctrl.absolute.toJs" class="gf-timepicker-component" show-weeks="false" ng-change="ctrl.absoluteToChanged()"></datepicker></div><label class="small">Refreshing every:</label><div class="gf-form-inline"><div class="gf-form max-width-28"><select ng-model="ctrl.refresh.value" class="gf-form-input input-medium" ng-options="f.value as f.text for f in ctrl.refresh.options"></select></div><div class="gf-form"><button type="submit" class="btn gf-form-btn btn-secondary" ng-click="ctrl.applyCustom();" ng-disabled="!timeForm.$valid">Apply</button></div></div></form><div class="gf-timepicker-relative-section"><h3>Quick ranges</h3><ul ng-repeat="group in ctrl.timeOptions"><li bindonce ng-repeat="option in group" ng-class="{active: option.active}"><a ng-click="ctrl.setRelativeFilter(option)" bo-text="option.display"></a></li></ul></div></div><div class="clearfix"></div>'),a.put("public/app/features/dashboard/timepicker/settings.html",'<div class="editor-row"><div class="gf-form-group"><div class="gf-form"><span class="gf-form-label width-10">Auto-refresh</span> <input type="text" class="gf-form-input max-width-25" ng-model="ctrl.panel.refresh_intervals" array-join></div><div class="gf-form"><span class="gf-form-label width-10">Now delay now-</span> <input type="text" class="gf-form-input max-width-25" ng-model="ctrl.panel.nowDelay" placeholder="0m" valid-time-span bs-tooltip="\'Enter 1m to ignore the last minute (because it can contain incomplete metrics)\'" data-placement="right"></div></div></div>'),a.put("public/app/features/dashboard/timepicker/timepicker.html",'<ul class="nav gf-timepicker-nav"><li class="dashnav-move-timeframe gf-timepicker-time-control" bs-tooltip="\'Shift time backward <br> (left arrow key)\'" data-placement="bottom"><a ng-click="ctrl.move(-1)"><i class="fa fa-chevron-left"></i></a></li><li class="dashnav-zoom-out gf-timepicker-time-control" bs-tooltip="\'Time range zoom out <br> CTRL+Z\'" data-placement="bottom"><a ng-click="ctrl.zoom(2)">Zoom Out</a></li><li class="dashnav-move-timeframe gf-timepicker-time-control" bs-tooltip="\'Shift time forward <br> (right arrow key)\'" data-placement="bottom"><a ng-click="ctrl.move(1)"><i class="fa fa-chevron-right"></i></a></li><li><a bs-tooltip="ctrl.tooltip" data-placement="bottom" ng-click="ctrl.openDropdown()" class="gf-timepicker-nav-btn"><i class="fa fa-clock-o"></i> <span ng-bind="ctrl.rangeString"></span> <span ng-show="ctrl.isUtc" class="gf-timepicker-utc">UTC </span><span ng-show="ctrl.dashboard.refresh" class="text-warning">&nbsp; Refresh every {{ctrl.dashboard.refresh}}</span></a></li><li class="dashnav-refresh-action"><a ng-click="ctrl.timeSrv.refreshDashboard()"><i class="fa fa-refresh"></i></a></li></ul>'),a.put("public/app/features/dashlinks/editor.html",'<div class="editor-row"><h5 class="section-heading">Links and Dash Navigation</h5><div ng-repeat="link in dashboard.links"><div class="gf-form-group"><div class="gf-form-inline"><div class="gf-form"><span class="gf-form-label width-6">Type</span><div class="gf-form-select-wrapper width-10"><select class="gf-form-input" ng-model="link.type" ng-options="f for f in [\'dashboards\',\'link\']" ng-change="updated()"></select></div></div><div class="gf-form" ng-show="link.type === \'dashboards\'"><span class="gf-form-label">With tags</span><bootstrap-tagsinput ng-model="link.tags" tagclass="label label-tag" placeholder="add tags"></bootstrap-tagsinput></div><div class="gf-form" ng-show="link.type === \'dashboards\'"><editor-checkbox text="As dropdown" model="link.asDropdown" change="updated()"></editor-checkbox></div><div class="gf-form max-width-30" ng-show="link.type === \'link\'"><li class="gf-form-label width-6">Url</li><input type="text" ng-model="link.url" class="gf-form-input" ng-model-onblur ng-change="updated()"></div><div class="gf-form"><button class="btn btn-inverse btn-mini" ng-click="moveLink($index, -1)" ng-hide="$first"><i class="fa fa-arrow-up"></i></button></div><div class="gf-form"><button class="btn btn-inverse btn-mini" ng-click="moveLink($index, 1)" ng-hide="$last"><i class="fa fa-arrow-down"></i></button></div><div class="gf-form"><button class="btn btn-inverse btn-mini" ng-click="deleteLink($index)"><i class="fa fa-trash"></i></button></div></div><div class="gf-form" ng-show="link.type === \'dashboards\' && link.asDropdown"><span class="gf-form-label width-6">Title</span> <input type="text" ng-model="link.title" class="gf-form-input max-width-25" ng-model-onblur ng-change="updated()"></div><div class="gf-form-inline" ng-show="link.type === \'link\'"><div class="gf-form"><span class="gf-form-label width-6">Title</span> <input type="text" ng-model="link.title" class="gf-form-input max-width-10" ng-model-onblur ng-change="updated()"></div><div class="gf-form"><span class="gf-form-label width-6">Tooltip</span> <input type="text" ng-model="link.tooltip" class="gf-form-input max-width-10" placeholder="Open dashboard" ng-model-onblur ng-change="updated()"></div><div class="gf-form"><span class="gf-form-label width-6">Icon</span><div class="gf-form-select-wrapper max-width-10"><select class="gf-form-input" ng-model="link.icon" ng-options="k as k for (k, v) in iconMap" ng-change="updated()"></select></div></div></div><div class="gf-form-inline"><div class="gf-form"><span class="gf-form-label width-6">Include</span><editor-checkbox text="Time range" model="link.keepTime" change="updated()"></editor-checkbox><editor-checkbox text="Variable values" model="link.includeVars" change="updated()"></editor-checkbox><editor-checkbox text="Open in new tab " model="link.targetBlank" change="updated()"></editor-checkbox></div></div></div></div></div><button class="btn btn-inverse" ng-click="addLink()"><i class="fa fa-plus"></i> Add link</button>'),a.put("public/app/features/org/partials/apikeyModal.html",'<div class="modal-body"><div class="modal-header"><h2 class="modal-header-title"><i class="fa fa-key"></i> <span class="p-l-1">API Key Created</span></h2><a class="modal-header-close" ng-click="dismiss();"><i class="fa fa-remove"></i></a></div><div class="modal-content"><div class="gf-form-group"><div class="gf-form"><span class="gf-form-label">Key</span> <span class="gf-form-label">{{key}}</span></div></div><div class="grafana-info-box" style="border: 0">You will only be able to view this key here once! It is not stored in this form. So be sure to copy it now.<br><br>You can authenticate request using the Authorization HTTP header, example:<br><br><pre class="small">\ncurl -H "Authorization: Bearer your_key_above" http://your.grafana.com/api/dashboards/db/mydash\n			</pre></div></div></div>'),a.put("public/app/features/org/partials/change_password.html",'<navbar icon="icon-gf icon-gf-users" title="Profile" title-url="profile"></navbar><div class="page-container"><div class="page-header"><h1>Change password</h1></div><form name="userForm" class="gf-form-group"><div class="gf-form"><span class="gf-form-label width-10">Old Password</span> <input class="gf-form-input max-width-21" type="password" required ng-model="command.oldPassword"></div><div class="gf-form"><span class="gf-form-label width-10">New Password</span> <input class="gf-form-input max-width-21" type="password" required ng-minlength="4" ng-model="command.newPassword"></div><div class="gf-form"><span class="gf-form-label width-10">Confirm Password</span> <input class="gf-form-input max-width-21" type="password" required ng-minlength="4" ng-model="command.confirmNew"></div><div class="gf-form-button-row"><button type="submit" class="btn btn-success" ng-click="changePassword()">Change Password</button> <a class="btn-text" href="profile">Cancel</a></div></form></div>'),a.put("public/app/features/org/partials/invite.html",'<div class="modal-body" ng-controller="UserInviteCtrl" ng-init="init()"><div class="modal-header"><h2 class="modal-header-title">Invite Users</h2><a class="modal-header-close" ng-click="dismiss();"><i class="fa fa-remove"></i></a></div><div class="modal-content"><div class="modal-tagline p-b-2">Send invite or add existing Grafana users to the organization <span class="highlight-word">{{contextSrv.user.orgName}}</span></div><form name="inviteForm"><div class="gf-form-group"><div class="gf-form-inline" ng-repeat="invite in invites"><div class="gf-form max-width-21"><span class="gf-form-label">Email or Username</span> <input type="text" ng-model="invite.loginOrEmail" required class="gf-form-input" placeholder="email@test.com"></div><div class="gf-form max-width-14"><span class="gf-form-label">Name</span> <input type="text" ng-model="invite.name" class="gf-form-input" placeholder="name (optional)"></div><div class="gf-form max-width-10"><span class="gf-form-label">Role</span><select ng-model="invite.role" class="gf-form-input" ng-options="f for f in [\'Viewer\', \'Editor\', \'Read Only Editor\', \'Admin\']"></select></div><div class="gf-form gf-size-auto"><a class="gf-form-label pointer" tabindex="1" ng-click="removeInvite(invite)"><i class="fa fa-remove"></i></a></div></div></div><div class="gf-form-inline gf-form-group"><div class="gf-form"><a class="btn btn-inverse btn-small" ng-click="addInvite()"><i class="fa fa-plus"></i> Invite another</a></div><div class="gf-form"><editor-checkbox text="Skip sending invite email" model="options.skipEmails" change="targetBlur()"></editor-checkbox></div></div><div class="gf-form-button-row"><button type="submit" class="btn btn-success" ng-click="sendInvites();">Invite Users</button> <a class="btn-text" ng-click="dismiss()">Cancel</a></div><div class="clearfix"></div></form></div></div>'),a.put("public/app/features/org/partials/newOrg.html",'<navbar title="Organization" icon="icon-gf icon-gf-users"></navbar><div class="page-container" ng-form="playlistEditForm"><div class="page-header"><h1>New Organization</h1></div><p class="playlist-description">Each organization contains their own dashboards, data sources and configuration, and cannot be shared between orgs. While users may belong to more than one, mutiple organization are most frequently used in multi-tenant deployments.</p><form><div class="gf-form-group"><div class="gf-form"><span class="gf-form-label width-10">Org. name</span> <input type="text" ng-model="newOrg.name" required class="gf-form-input max-width-21" placeholder="organization name"></div><br><div class="gf-form-buttons-row"><button type="submit" class="btn btn-success" ng-click="createOrg()">Create</button></div></div></form></div>'),a.put("public/app/features/org/partials/orgApiKeys.html",'<navbar icon="icon-gf icon-gf-users" title="Organization" title-url="org"></navbar><div class="page-container"><div class="page-header"><h1>API Keys</h1></div><h3 class="page-heading">Add new</h3><form name="addTokenForm" class="gf-form-group"><div class="gf-form-inline"><div class="gf-form max-width-21"><span class="gf-form-label">Add a key</span> <input type="text" class="gf-form-input" ng-model="token.name" placeholder="Name"></div><div class="gf-form"><span class="gf-form-label">Role</span><select class="gf-form-input gf-size-auto" ng-model="token.role" ng-options="r for r in roleTypes"></select></div><div class="gf-form"><button class="btn gf-form-btn btn-success" ng-click="addToken()">Add</button></div></div></form><h3 class="page-heading">Existing Keys</h3><table class="filter-table"><thead><tr><th>Name</th><th>Role</th><th style="width: 34px"></th></tr></thead><tbody><tr ng-repeat="t in tokens"><td>{{t.name}}</td><td>{{t.role}}</td><td><a ng-click="removeToken(t.id)" class="btn btn-danger btn-mini"><i class="fa fa-remove"></i></a></td></tr></tbody></table></div>'),a.put("public/app/features/org/partials/orgDetails.html",'<navbar icon="icon-gf icon-gf-users" title="Organization" title-url="org"></navbar><div class="page-container"><div class="page-header"><h1>Org Preferences</h1></div><h3 class="page-heading">General</h3><form name="orgForm" class="gf-form-group"><div class="gf-form-inline"><div class="gf-form max-width-28"><span class="gf-form-label width-6">Name</span> <input class="gf-form-input" type="text" required ng-model="org.name"></div><div class="gf-form"><button type="submit" class="btn gf-form-btn btn-success" ng-click="update()">Update</button></div></div></form><prefs-control mode="org"></prefs-control><h3 class="page-heading">Address</h3><form name="addressForm" class="gf-form-group"><div class="gf-form-inline"><div class="gf-form max-width-28"><span class="gf-form-label width-7">Address1</span> <input class="gf-form-input" type="text" ng-model="address.address1"></div><div class="gf-form max-width-28"><span class="gf-form-label width-7">Address2</span> <input class="gf-form-input" type="text" ng-model="address.address2"></div></div><div class="gf-form-inline"><div class="gf-form max-width-28"><span class="gf-form-label width-7">City</span> <input class="gf-form-input" type="text" ng-model="address.city"></div><div class="gf-form max-width-28"><span class="gf-form-label width-7">Postal code</span> <input class="gf-form-input" type="text" ng-model="address.zipCode"></div></div><div class="gf-form-inline"><div class="gf-form max-width-28"><span class="gf-form-label width-7">State</span> <input class="gf-form-input" type="text" ng-model="address.state"></div><div class="gf-form max-width-28"><span class="gf-form-label width-7">Country</span> <input class="gf-form-input" type="text" ng-model="address.country"></div></div><div class="gf-form-button-row"><button type="submit" class="btn btn-success" ng-click="updateAddress()">Update</button></div></form><h3 class="page-heading">Admin Pages</h3><div class="gf-form-group"><div class="gf-form-inline"><div class="gf-form"><a href="org/users" class="btn gf-form-btn btn-inverse">Users &amp; Roles</a></div><div class="gf-form"><a href="org/apikeys" class="btn gf-form-btn btn-inverse">API Keys</a></div></div></div></div>'),a.put("public/app/features/org/partials/orgUsers.html",'<navbar icon="icon-gf icon-gf-users" title="Organization Users" title-url="org/users"></navbar><div class="page-container"><div class="page-header"><h1>Organization users</h1><div class="page-header-tabs"><button class="btn btn-success" ng-click="ctrl.openInviteModal()"><i class="fa fa-plus"></i> Add or Invite</button><ul class="gf-tabs"><li class="gf-tabs-item"><a class="gf-tabs-link" ng-click="ctrl.editor.index = 0" ng-class="{active: ctrl.editor.index === 0}">Users ({{ctrl.users.length}})</a></li><li class="gf-tabs-item"><a class="gf-tabs-link" ng-click="ctrl.editor.index = 1" ng-class="{active: ctrl.editor.index === 1}">Pending Invitations ({{ctrl.pendingInvites.length}})</a></li></ul></div></div><div ng-if="ctrl.editor.index === 0" class="tab-content"><table class="filter-table form-inline"><thead><tr><th>Login</th><th>Email</th><th>Role</th><th style="width: 34px"></th></tr></thead><tr ng-repeat="user in ctrl.users"><td>{{user.login}}</td><td><span class="ellipsis">{{user.email}}</span></td><td><select type="text" ng-model="user.role" class="input-medium" ng-options="f for f in [\'Viewer\', \'Editor\', \'Read Only Editor\', \'Admin\']" ng-change="ctrl.updateOrgUser(user)"></select></td><td><a ng-click="ctrl.removeUser(user)" class="btn btn-danger btn-mini"><i class="fa fa-remove"></i></a></td></tr></table></div><div ng-if="ctrl.editor.index === 1"><table class="filter-table form-inline"><thead><tr><th>Email</th><th>Name</th><th></th></tr></thead><tbody ng-repeat="invite in ctrl.pendingInvites"><tr ng-click="invite.expanded = !invite.expanded" ng-class="{\'expanded\': invite.expanded}"><td>{{invite.email}}</td><td>{{invite.name}}</td><td class="text-right"><button class="btn btn-inverse btn-mini" data-clipboard-text="{{invite.url}}" clipboard-button ng-click="ctrl.copyInviteToClipboard($event)"><i class="fa fa-clipboard"></i> Copy Invite</button> &nbsp; <button class="btn btn-inverse btn-mini">Details <i ng-show="!invite.expanded" class="fa fa-caret-right"></i> <i ng-show="invite.expanded" class="fa fa-caret-down"></i></button></td></tr><tr ng-show="invite.expanded"><td colspan="3"><a href="{{invite.url}}">{{invite.url}}</a><br><br>&nbsp; <button class="btn btn-inverse btn-mini" ng-click="ctrl.revokeInvite(invite, $event)"><i class="fa fa-remove" style="color: red"></i> Revoke invite</button> <span style="padding-left: 15px">Invited: <em>{{invite.createdOn | date: \'shortDate\'}} by {{invite.invitedBy}}</em></span></td></tr></tbody></table></div></div>'),a.put("public/app/features/org/partials/profile.html",'<navbar icon="icon-gf icon-gf-users" title="Profile" title-url="profile"></navbar><div class="page-container"><div class="page-header"><h1>Profile</h1></div><form name="ctrl.userForm" class="gf-form-group"><h3 class="page-heading">Information</h3><div class="gf-form"><span class="gf-form-label width-9">Name</span> <input class="gf-form-input max-width-21" type="text" required ng-model="ctrl.user.name"></div><div class="gf-form"><span class="gf-form-label width-9">Email</span> <input class="gf-form-input max-width-21" type="email" required ng-model="ctrl.user.email"></div><div class="gf-form"><span class="gf-form-label width-9">Username</span> <input class="gf-form-input max-width-21" type="text" required ng-model="ctrl.user.login"></div><div class="gf-form-button-row"><button type="submit" class="btn btn-success" ng-click="ctrl.update()">Update</button></div></form><prefs-control mode="user"></prefs-control><h3 class="page-heading">Password</h3><div class="gf-form-group"><a href="profile/password" class="btn btn-inverse">Change Password</a></div><h3 class="page-heading">Organizations</h3><div class="gf-form-group"><table class="filter-table form-inline"><thead><tr><th>Name</th><th>Role</th><th></th></tr></thead><tbody><tr ng-repeat="org in ctrl.orgs"><td>{{org.name}}</td><td>{{org.role}}</td><td class="text-right"><span class="btn btn-primary btn-mini" ng-show="org.orgId === contextSrv.user.orgId">Current </span><a ng-click="setUsingOrg(org)" class="btn btn-inverse btn-mini" ng-show="org.orgId !== contextSrv.user.orgId">Select</a></td></tr></tbody></table></div></div>'),a.put("public/app/features/org/partials/select_org.html",'<div class="container"><div class="signup-page-background"></div><div class="login-box"><div class="login-box-logo"><img src="img/logo_transparent_200x75.png"></div><div class="invite-box"><h3><i class="fa fa-users"></i>&nbsp; Change active organization</h3><div class="modal-tagline">You have been added to another Organization<br>due to an open invitation!<br><br>Please select which organization you want to<br>use right now (you can change this later at any time).</div><div style="display: inline-block; width: 400px; margin: 30px 0"><table class="grafana-options-table"><tr ng-repeat="org in orgs"><td class="nobg max-width-btns"><a ng-click="setUsingOrg(org)" class="btn btn-inverse">{{org.name}} ({{org.role}})</a></td></tr></table></div></div><div class="row" style="margin-top: 50px"><div class="version-footer text-center small">Grafana version: {{buildInfo.version}}, commit: {{buildInfo.commit}}, build date: {{buildInfo.buildstamp | date: \'yyyy-MM-dd HH:mm:ss\' }}</div></div></div></div>'),
a.put("public/app/features/panel/partials/panelTime.html",'<div class="gf-form-group"><div class="gf-form"><span class="gf-form-label"><i class="fa fa-clock-o"></i> </span><span class="gf-form-label width-12">Override relative time</span> <span class="gf-form-label width-6">Last</span> <input type="text" class="gf-form-input max-width-8" placeholder="1h" empty-to-null ng-model="ctrl.panel.timeFrom" valid-time-span ng-change="ctrl.refresh()" ng-model-onblur></div><div class="gf-form"><span class="gf-form-label"><i class="fa fa-clock-o"></i> </span><span class="gf-form-label width-12">Add time shift</span> <span class="gf-form-label width-6">Amount</span> <input type="text" class="gf-form-input max-width-8" placeholder="1h" empty-to-null ng-model="ctrl.panel.timeShift" valid-time-span ng-change="ctrl.refresh()" ng-model-onblur></div><div class="gf-form-inline"><div class="gf-form"><span class="gf-form-label"><i class="fa fa-clock-o"></i></span></div><gf-form-switch class="gf-form max-width-30" label="Hide time override info" label-class="width-12" checked="ctrl.panel.hideTimeOverride" switch-class="max-width-6" on-change="ctrl.refresh()"></gf-form-switch></div></div>'),a.put("public/app/features/panel/partials/query_editor_row.html",'<div class="gf-form-query"><div class="gf-form"><label class="gf-form-label gf-form-query-letter-cell"><a class="pointer" tabindex="1" ng-click="ctrl.toggleCollapse()"><span ng-class="{muted: !ctrl.canCollapse}" class="gf-form-query-letter-cell-carret"><i class="fa fa-caret-down" ng-hide="ctrl.collapsed"></i> <i class="fa fa-caret-right" ng-show="ctrl.collapsed"></i> </span><span class="gf-form-query-letter-cell-letter">{{ctrl.target.refId}}</span> <em class="gf-form-query-letter-cell-ds" ng-show="ctrl.target.datasource">({{ctrl.target.datasource}})</em></a></label></div><div class="gf-form-query-content gf-form-query-content--collapsed" ng-if="ctrl.collapsed"><div class="gf-form"><label class="gf-form-label pointer gf-form-label--grow" ng-click="ctrl.toggleCollapse()">{{ctrl.collapsedText}}</label></div></div><div ng-transclude class="gf-form-query-content" ng-if="!ctrl.collapsed"></div><div class="gf-form"><label class="gf-form-label dropdown"><a class="pointer dropdown-toggle" data-toggle="dropdown" tabindex="1"><i class="fa fa-bars"></i></a><ul class="dropdown-menu pull-right" role="menu"><li role="menuitem" ng-if="ctrl.hasTextEditMode"><a tabindex="1" ng-click="ctrl.toggleEditorMode()">Toggle Edit Mode</a></li><li role="menuitem"><a tabindex="1" ng-click="ctrl.duplicateQuery()">Duplicate</a></li><li role="menuitem"><a tabindex="1" ng-click="ctrl.moveQuery(-1)">Move up</a></li><li role="menuitem"><a tabindex="1" ng-click="ctrl.moveQuery(1)">Move down</a></li></ul></label><label class="gf-form-label"><a ng-click="ctrl.toggleHideQuery()" role="menuitem"><i class="fa fa-eye"></i></a></label><label class="gf-form-label"><a class="pointer" tabindex="1" ng-click="ctrl.removeQuery(ctrl.target)"><i class="fa fa-trash"></i></a></label></div></div><div class="tight-form" ng-if="false"><ul class="tight-form-list pull-right"><li ng-show="ctrl.error" class="tight-form-item"><a bs-tooltip="ctrl.error" style="color: rgb(229, 189, 28)" role="menuitem"><i class="fa fa-warning"></i></a></li><li class="tight-form-item small" ng-show="ctrl.target.datasource"><em>{{ctrl.target.datasource}}</em></li><li class="tight-form-item" ng-if="ctrl.toggleEditorMode"><a class="pointer" tabindex="1" ng-click="ctrl.toggleEditorMode()"><i class="fa fa-pencil"></i></a></li><li class="tight-form-item"><div class="dropdown"><a class="pointer dropdown-toggle" data-toggle="dropdown" tabindex="1"><i class="fa fa-bars"></i></a><ul class="dropdown-menu pull-right" role="menu"><li role="menuitem"><a tabindex="1" ng-click="ctrl.duplicateQuery()">Duplicate</a></li><li role="menuitem"><a tabindex="1" ng-click="ctrl.moveQuery(-1)">Move up</a></li><li role="menuitem"><a tabindex="1" ng-click="ctrl.moveQuery(1)">Move down</a></li></ul></div></li><li class="tight-form-item last"><a class="pointer" tabindex="1" ng-click="ctrl.removeQuery(target)"><i class="fa fa-trash"></i></a></li></ul><ul class="tight-form-list"><li class="tight-form-item" style="min-width: 15px; text-align: center">{{ctrl.target.refId}}</li><li><a class="tight-form-item" ng-click="ctrl.toggleHideQuery()" role="menuitem"><i class="fa fa-eye"></i></a></li></ul><ul class="tight-form-list" ng-transclude></ul><div class="clearfix"></div></div>'),a.put("public/app/features/panel/partials/soloPanel.html",'<div class="main"><div class="row-fluid"><div class="span12"><div class="panel nospace" ng-if="panel" style="width: 100%"><plugin-component type="panel"></plugin-component></div></div></div></div>'),a.put("public/app/features/panellinks/module.html",'<div class="editor-row"><h5 class="section-heading">Drilldown / detail link<tip>These links appear in the dropdown menu in the panel menu.</tip></h5><div ng-repeat="link in panel.links" style="margin-top: 20px"><div class="gf-form-group"><div class="gf-form-inline"><div class="gf-form width-2"><i class="fa fa-fw fa-unlink"></i></div><div class="gf-form"><span class="gf-form-label width-7">Type</span><div class="gf-form-select-wrapper width-14"><select class="gf-form-input" ng-model="link.type" ng-options="f for f in [\'dashboard\',\'absolute\']"></select></div></div><div class="gf-form"><span class="gf-form-label width-7" ng-show="link.type === \'dashboard\'">Dashboard</span> <input ng-show="link.type === \'dashboard\'" type="text" ng-model="link.dashboard" bs-typeahead="searchDashboards" class="gf-form-input max-width-14" ng-blur="dashboardChanged(link)"> <span class="gf-form-label width-7" ng-show="link.type === \'absolute\'">Url</span> <input ng-show="link.type === \'absolute\'" type="text" ng-model="link.url" class="gf-form-input max-width-14"></div><div class="gf-form"><button class="btn-inverse gf-form-btn btn-small" ng-click="deleteLink(link)"><i class="fa fa-trash"></i></button></div></div><div class="gf-form-inline"><div class="gf-form width-2"><i class="fa fa-fw fa-unlink invisible"></i></div><div class="gf-form"><div class="gf-form-label width-7">Title</div><input type="text" ng-model="link.title" class="gf-form-input"></div><div class="gf-form"><span class="gf-form-label width-7">Url params</span> <input type="text" ng-model="link.params" class="gf-form-input"></div></div><div class="gf-form-inline"><div class="gf-form width-2"><i class="fa fa-fw fa-unlink invisible"></i></div><div class="gf-form"><editor-checkbox text="Keep current time range" model="link.keepTime"></editor-checkbox><editor-checkbox text="Add current variable values" model="link.includeVars"></editor-checkbox><editor-checkbox text="Open in new tab " model="link.targetBlank"></editor-checkbox></div></div></div></div></div><div class="editor-row"><button class="btn btn-inverse" ng-click="addLink()"><i class="fa fa-plus"></i> Add link</button></div>'),a.put("public/app/features/playlist/partials/playlist.html",'<navbar icon="fa fa-fw fa-list" title="Playlists" title-url="playlists"></navbar><div class="page-container" ng-form="playlistEditForm"><div class="page-header"><h1 ng-show="ctrl.isNew()">New Playlist</h1><h1 ng-show="!ctrl.isNew()">Edit Playlist</h1></div><p class="playlist-description">A playlist rotates through a pre-selected list of Dashboards. A Playlist can be a great way to build situational awareness, or just show off your metrics to your team or visitors.</p><div class="gf-form-group"><div class="gf-form"><span class="gf-form-label width-7">Name</span> <input type="text" required ng-model="ctrl.playlist.name" class="gf-form-input max-width-21"></div><div class="gf-form"><span class="gf-form-label width-7">Interval</span> <input type="text" required ng-model="ctrl.playlist.interval" placeholder="5m" class="gf-form-input max-width-21"></div></div><div class="gf-form-group"><h3 class="page-headering">Dashboards</h3></div><div class="row"><div class="col-md-6"><div class="playlist-search-containerwrapper"><div class="max-width-32"><h5 class="page-headering playlist-column-header">Available</h5><div style=""><playlist-search class="playlist-search-container" search-started="ctrl.searchStarted(promise)"></playlist-search></div></div></div><div ng-if="ctrl.filteredDashboards.length > 0"><table class="grafana-options-table playlist-available-list"><tr ng-repeat="playlistItem in ctrl.filteredDashboards"><td><i class="icon-gf icon-gf-dashboard"></i> &nbsp;&nbsp;{{playlistItem.title}} <i class="fa fa-star" ng-show="playlistItem.isStarred"></i></td><td class="add-dashboard"><button class="btn btn-inverse btn-mini pull-right" ng-click="ctrl.addPlaylistItem(playlistItem)"><i class="fa fa-plus"></i> Add to playlist</button></td></tr></table></div><div class="playlist-search-results-container" ng-if="ctrl.filteredTags.length > 0;"><table class="grafana-options-table playlist-available-list"><tr ng-repeat="tag in ctrl.filteredTags"><td><a class="search-result-tag label label-tag" tag-color-from-name="tag.term"><i class="fa fa-tag"></i> <span>{{tag.term}} &nbsp;({{tag.count}})</span></a></td><td class="add-dashboard"><button class="btn btn-inverse btn-mini pull-right" ng-click="ctrl.addTagPlaylistItem(tag)"><i class="fa fa-plus"></i> Add to playlist</button></td></tr></table></div></div><div class="col-md-6"><h5 class="page headering playlist-column-header">Selected</h5><table class="grafana-options-table playlist-available-list"><tr ng-repeat="playlistItem in ctrl.playlistItems"><td ng-if="playlistItem.type === \'dashboard_by_id\'"><i class="icon-gf icon-gf-dashboard"></i>&nbsp;&nbsp;{{playlistItem.title}}</td><td ng-if="playlistItem.type === \'dashboard_by_tag\'"><a class="search-result-tag label label-tag" tag-color-from-name="playlistItem.title"><i class="fa fa-tag"></i> <span>{{playlistItem.title}}</span></a></td><td class="selected-playlistitem-settings"><button class="btn btn-inverse btn-mini" ng-hide="$first" ng-click="ctrl.movePlaylistItemUp(playlistItem)"><i class="fa fa-arrow-up"></i></button> <button class="btn btn-inverse btn-mini" ng-hide="$last" ng-click="ctrl.movePlaylistItemDown(playlistItem)"><i class="fa fa-arrow-down"></i></button> <button class="btn btn-inverse btn-mini" ng-click="ctrl.removePlaylistItem(playlistItem)"><i class="fa fa-remove"></i></button></td></tr></table></div></div><div class="clearfix"></div><div class="gf-form-button-row"><a class="btn btn-success" ng-show="ctrl.isNew()" ng-disabled="ctrl.playlistEditForm.$invalid || ctrl.isPlaylistEmpty()" ng-click="ctrl.savePlaylist(ctrl.playlist, ctrl.playlistItems)">Create new playlist</a> <a class="btn btn-success" ng-show="!ctrl.isNew()" ng-disabled="ctrl.playlistEditForm.$invalid || ctrl.isPlaylistEmpty()" ng-click="ctrl.savePlaylist(ctrl.playlist, ctrl.playlistItems)">Save</a> <a class="btn-text" ng-click="ctrl.backToList()">Cancel</a></div></div>'),a.put("public/app/features/playlist/partials/playlist_search.html",'<div class="playlist-search-field-wrapper"><span style="position: relative"><input type="text" placeholder="Find dashboards by name" tabindex="1" ng-keydown="ctrl.keyDown($event)" ng-model="ctrl.query.query" ng-model-options="{ debounce: 500 }" spellcheck="false" ng-change="ctrl.searchDashboards()"><div class="playlist-search-switches"><i class="fa fa-filter"></i> <a class="pointer" href="javascript:void 0;" ng-click="ctrl.showStarred()" tabindex="2"><i class="fa fa-remove" ng-show="ctrl.query.starred"></i> starred </a>| <a class="pointer" href="javascript:void 0;" ng-click="ctrl.getTags()" tabindex="3"><i class="fa fa-remove" ng-show="ctrl.tagsMode"></i> tags </a><span ng-if="ctrl.query.tag.length">| <span ng-repeat="tagName in ctrl.query.tag"><a ng-click="ctrl.removeTag(tagName, $event)" tag-color-from-name="ctrl.tagName" class="label label-tag"><i class="fa fa-remove"></i> {{tagName}}</a></span></span></div></span></div>'),a.put("public/app/features/playlist/partials/playlists.html",'<navbar icon="fa fa-fw fa-list" title="Playlists" title-url="playlists"></navbar><div class="page-container"><div class="page-header"><h1>Saved playlists</h1><a class="btn btn-success pull-right" href="playlists/create"><i class="fa fa-plus"></i> New Playlist</a></div><table class="filter-table" style="margin-top: 20px"><thead><th><strong>Name</strong></th><th><strong>Start url</strong></th><th style="width: 68px"></th><th style="width: 68px"></th><th style="width: 25px"></th></thead><tr ng-repeat="playlist in ctrl.playlists"><td><a href="playlists/edit/{{playlist.id}}">{{playlist.name}}</a></td><td><a href="playlists/play/{{playlist.id}}">playlists/play/{{playlist.id}}</a></td><td class="text-center"><a href="playlists/play/{{playlist.id}}" class="btn btn-inverse btn-small"><i class="fa fa-play"></i> Play</a></td><td class="text-right"><a href="playlists/edit/{{playlist.id}}" class="btn btn-inverse btn-small"><i class="fa fa-edit"></i> Edit</a></td><td class="text-right"><a ng-click="ctrl.removePlaylist(playlist)" class="btn btn-danger btn-small"><i class="fa fa-remove"></i></a></td></tr></table></div>'),a.put("public/app/features/plugins/import_list/import_list.html",'<div class="gf-form-group" ng-if="ctrl.dashboards.length"><table class="filter-table"><tbody><tr ng-repeat="dash in ctrl.dashboards"><td class="width-1"><i class="icon-gf icon-gf-dashboard"></i></td><td><a href="dashboard/{{dash.installedUri}}" ng-show="dash.installed">{{dash.title}} </a><span ng-show="!dash.installed">{{dash.title}}</span></td><td>v{{dash.revision}} <span ng-if="dash.installed">&nbsp;(Imported v{{dash.installedRevision}}) <span></span></span></td><td style="text-align: right"><button class="btn btn-secondary" ng-click="ctrl.import(dash, false)" ng-show="!dash.installed">Import</button> <button class="btn btn-secondary" ng-click="ctrl.import(dash, true)" ng-show="dash.installed">Update</button> <button class="btn btn-danger" ng-click="ctrl.remove(dash)" ng-show="dash.installed">Delete</button></td></tr></tbody></table></div>'),a.put("public/app/features/plugins/partials/ds_edit.html",'<navbar title="Data Sources" title-url="datasources" icon="icon-gf icon-gf-datasources"></navbar><div class="page-container"><div class="page-header"><h1 ng-show="ctrl.isNew">Add data source</h1><h1 ng-hide="ctrl.isNew">Edit data source</h1><div class="page-header-tabs" ng-show="ctrl.hasDashboards"><ul class="gf-tabs"><li class="gf-tabs-item"><a class="gf-tabs-link" ng-click="ctrl.tabIndex = 0" ng-class="{active: ctrl.tabIndex === 0}">Config</a></li><li class="gf-tabs-item"><a class="gf-tabs-link" ng-click="ctrl.tabIndex = 1" ng-class="{active: ctrl.tabIndex === 1}">Dashboards</a></li></ul></div></div><div ng-if="ctrl.tabIndex === 0" class="tab-content"><form name="ctrl.editForm" ng-if="ctrl.current"><div class="gf-form-group"><div class="gf-form-inline"><div class="gf-form"><span class="gf-form-label width-7">Name</span> <input class="gf-form-input max-width-21" type="text" ng-model="ctrl.current.name" placeholder="My data source name" required><info-popover offset="0px -135px" mode="right-absolute">The name is used when you select the data source in panels. The <em>Default</em> data source is preselected in new panels.</info-popover></div><gf-form-switch class="gf-form" label="Default" checked="ctrl.current.isDefault" switch-class="max-width-6"></gf-form-switch></div><div class="gf-form"><span class="gf-form-label width-7">Type</span><div class="gf-form-select-wrapper max-width-23"><select class="gf-form-input" ng-model="ctrl.current.type" ng-options="v.id as v.name for v in ctrl.types" ng-change="ctrl.typeChanged()"></select></div></div></div><rebuild-on-change property="ctrl.datasourceMeta.id"><plugin-component type="datasource-config-ctrl"></plugin-component></rebuild-on-change><div ng-if="ctrl.testing" class="gf-form-group"><h5 ng-show="!ctrl.testing.done">Testing.... <i class="fa fa-spiner fa-spin"></i></h5><div class="alert-{{ctrl.testing.status}} alert"><div class="alert-title">{{ctrl.testing.title}}</div><div ng-bind="ctrl.testing.message"></div></div></div><div class="gf-form-button-row"><button type="submit" class="btn btn-success" ng-show="ctrl.isNew" ng-click="ctrl.saveChanges()">Add</button> <button type="submit" class="btn btn-success" ng-show="!ctrl.isNew" ng-click="ctrl.saveChanges()">Save &amp; Test</button> <button type="submit" class="btn btn-danger" ng-show="!ctrl.isNew" ng-click="ctrl.delete()">Delete</button> <a class="btn btn-link" href="datasources">Cancel</a></div></form></div><div ng-if="ctrl.tabIndex === 1" class="tab-content"><dashboard-import-list plugin="ctrl.datasourceMeta" datasource="ctrl.current"></dashboard-import-list></div></div>'),a.put("public/app/features/plugins/partials/ds_http_settings.html",'<div class="gf-form-group"><h3 class="page-heading">Http settings</h3><div class="gf-form-inline"><div class="gf-form max-width-30"><span class="gf-form-label width-7">Url</span> <input class="gf-form-input" type="text" ng-model="current.url" placeholder="for example: http://localhost:8081" ng-pattern="/^(ftp|http|https):\\/\\/(\\w+:{0,1}\\w*@)?(\\S+)(:[0-9]+)?(\\/|\\/([\\w#!:.?+=&%@!\\-\\/]))?$/" required><info-popover mode="right-absolute"><p>Specify a complete HTTP url (for example http://your_server:8080)</p><span ng-show="current.access === \'direct\'">Your access method is <em>Direct</em>, this means the url needs to be accessable from the browser. </span><span ng-show="current.access === \'proxy\'">Your access method is currently <em>Proxy</em>, this means the url needs to be accessable from the grafana backend.</span></info-popover></div></div><div class="gf-form-inline"><div class="gf-form max-width-30"><span class="gf-form-label width-7">Access</span><div class="gf-form-select-wrapper gf-form-select-wrapper--has-help-icon max-width-24"><select class="gf-form-input" ng-model="current.access" ng-options="f for f in [\'direct\', \'proxy\']"></select><info-popover mode="right-absolute">Direct = url is used directly from browser<br>Proxy = Grafana backend will proxy the request</info-popover></div></div></div><div class="gf-form-inline"><div class="gf-form"><label class="gf-form-label width-7">Http Auth</label></div><gf-form-switch class="gf-form" label="Basic Auth" checked="current.basicAuth" switch-class="max-width-6"></gf-form-switch><gf-form-switch class="gf-form" label="With Credentials" checked="current.withCredentials" switch-class="max-width-6"></gf-form-switch></div><div class="gf-form" ng-if="current.basicAuth"><span class="gf-form-label width-7">User </span><input class="gf-form-input max-width-21" type="text" ng-model="current.basicAuthUser" placeholder="user" required></div><div class="gf-form" ng-if="current.basicAuth"><span class="gf-form-label width-7">Passord </span><input class="gf-form-input max-width-21" type="password" ng-model="current.basicAuthPassword" placeholder="password" required></div></div>'),a.put("public/app/features/plugins/partials/ds_list.html",'<navbar title="Data Sources" title-url="datasources" icon="icon-gf icon-gf-datasources"></navbar><div class="page-container"><div class="page-header"><h1>Data Sources</h1><a class="btn btn-success" href="datasources/new"><i class="fa fa-plus"></i> Add data source</a></div><section class="card-section" layout-mode><layout-selector></layout-selector><ol class="card-list"><li class="card-item-wrapper" ng-repeat="ds in ctrl.datasources"><a class="card-item" href="datasources/edit/{{ds.id}}/"><div class="card-item-header"><div class="card-item-type">{{ds.type}}</div></div><div class="card-item-body"><figure class="card-item-figure"><img ng-src="{{ds.typeLogoUrl}}"></figure><div class="card-item-details"><div class="card-item-name">{{ds.name}} <span ng-if="ds.isDefault"><span class="btn btn-secondary btn-mini">default</span></span></div><div class="card-item-sub-name">{{ds.url}}</div></div></div></a></li></ol></section><div ng-if="ctrl.datasources.length === 0"><em>No data sources defined</em></div></div>'),a.put("public/app/features/plugins/partials/plugin_edit.html",'<navbar title="Plugins" title-url="plugins" icon="icon-gf icon-gf-apps"></navbar><div class="page-container" ng-init="ctrl.init()"><div class="page-header"><div class="plugin-header"><span class="plugin-header-logo"><img ng-src="{{ctrl.model.info.logos.large}}"></span><div class="plugin-header-info-block"><h1 class="plugin-header-name">{{ctrl.model.name}}</h1><div class="plugin-header-author">By {{ctrl.model.info.author.name}}</div><div class="plugin-header-stamps"><span class="plugin-header-stamps-type"><i class="{{ctrl.pluginIcon}}"></i> {{ctrl.model.type}}</span></div></div></div><ul class="gf-tabs"><li class="gf-tabs-item" ng-repeat="tab in ctrl.tabs"><a class="gf-tabs-link" ng-click="ctrl.tabIndex = $index" ng-class="{active: ctrl.tabIndex === $index}">{{::tab}}</a></li></ul></div><div class="page-body"><div class="tab-content page-content-with-sidebar" ng-if="ctrl.tabIndex === 0"><div ng-bind-html="ctrl.readmeHtml" class="plugin-markdown-readme"></div></div><div class="tab-content page-content-with-sidebar" ng-if="ctrl.tabIndex === 1"><div ng-if="ctrl.model.id"><plugin-component type="app-config-ctrl"></plugin-component><div class="gf-form-button-row"><button type="submit" class="btn btn-success" ng-click="ctrl.enable()" ng-show="!ctrl.model.enabled">Enable</button> <button type="submit" class="btn btn-success" ng-click="ctrl.update()" ng-show="ctrl.model.enabled">Update</button> <button type="submit" class="btn btn-danger" ng-click="ctrl.disable()" ng-show="ctrl.model.enabled">Disable</button></div></div></div><div class="tab-content page-content-with-sidebar" ng-if="ctrl.tabIndex === 2"><dashboard-import-list plugin="ctrl.model"></dashboard-import-list></div><aside class="page-sidebar"><section class="page-sidebar-section"><h4>Version</h4><span>{{ctrl.model.info.version}}</span><div ng-show="ctrl.model.hasUpdate"><a ng-click="ctrl.updateAvailable()" bs-tooltip="ctrl.model.latestVersion">Update Available!</a></div></section><section class="page-sidebar-section" ng-show="ctrl.model.type === \'app\'"><h5>Includes<ul class="ui-list plugin-info-list"><li ng-repeat="plug in ctrl.includes" class="plugin-info-list-item"><i class="{{plug.icon}}"></i> {{plug.name}}</li></ul></h5></section><section class="page-sidebar-section"><h5>Dependencies<ul class="ui-list plugin-info-list"><li class="plugin-info-list-item"><img src="public/img/grafana_icon.svg">Grafana {{ctrl.model.dependencies.grafanaVersion}}</li><li ng-repeat="plugDep in ctrl.model.dependencies.plugins" class="plugin-info-list-item"><i class="{{plugDep.icon}}"></i> {{plugDep.name}} {{plugDep.version}}</li></ul></h5></section><section class="page-sidebar-section"><h5>Links<ul class="ui-list"><li ng-repeat="link in ctrl.model.info.links"><a href="{{link.url}}" class="external-link" target="_blank">{{link.name}}</a></li></ul></h5></section></aside></div></div>'),a.put("public/app/features/plugins/partials/plugin_list.html",'<navbar title="Plugins" icon="icon-gf icon-gf-apps" title-url="plugins"></navbar><div class="page-container"><div class="page-header"><h1>Plugins</h1><div class="page-header-tabs"><ul class="gf-tabs"><li class="gf-tabs-item"><a class="gf-tabs-link" href="plugins?type=panel" ng-class="{active: ctrl.tabIndex === 0}">Panels</a></li><li class="gf-tabs-item"><a class="gf-tabs-link" href="plugins?type=datasource" ng-class="{active: ctrl.tabIndex === 1}">Data sources</a></li><li class="gf-tabs-item"><a class="gf-tabs-link" href="plugins?type=app" ng-class="{active: ctrl.tabIndex === 2}">Apps</a></li></ul></div></div><section class="card-section" layout-mode><layout-selector></layout-selector><ol class="card-list"><li class="card-item-wrapper" ng-repeat="plugin in ctrl.plugins"><a class="card-item" href="plugins/{{plugin.id}}/edit"><div class="card-item-header"><div class="card-item-type"><i class="icon-gf icon-gf-{{plugin.type}}"></i> {{plugin.type}}</div><div class="card-item-notice" ng-show="plugin.hasUpdate"><span bs-tooltip="plugin.latestVersion">Update available!</span></div></div><div class="card-item-body"><figure class="card-item-figure"><img ng-src="{{plugin.info.logos.small}}"></figure><div class="card-item-details"><div class="card-item-name">{{plugin.name}}</div><div class="card-item-sub-name">By {{plugin.info.author.name}}</div></div></div></a></li></ol></section></div>'),a.put("public/app/features/plugins/partials/plugin_page.html",'<navbar icon-url="{{ctrl.appLogoUrl}}" title="{{ctrl.appModel.name}}" title-url="{{ctrl.appModel.defaultNavUrl}}"></navbar><div class="page-container"><div ng-if="ctrl.page"><plugin-component type="app-page"></plugin-component></div></div>'),a.put("public/app/features/plugins/partials/update_instructions.html",'<div class="modal-body"><div class="modal-header"><h2 class="modal-header-title"><i class="fa fa-cloud-download"></i> <span class="p-l-1">Update Plugin</span></h2><a class="modal-header-close" ng-click="dismiss();"><i class="fa fa-remove"></i></a></div><div class="modal-content"><div class="gf-form-group"><p>Type the following on the command line to update {{plugin.name}}.</p><pre><code>grafana-cli plugins update {{plugin.id}}</code></pre><span class="small">Check out {{plugin.name}} on <a href="https://grafana.net/plugins/{{plugin.id}}">Grafana.net</a> for README and changelog. If you do not have access to the command line, ask your Grafana administator.</span></div><p class="pluginlist-none-installed"><img class="pluginlist-inline-logo" src="public/img/grafana_icon.svg"><strong>Pro tip</strong>: To update all plugins at once, type <code class="code--small">grafana-cli plugins update-all</code> on the command line.</p></div></div>'),a.put("public/app/features/snapshot/partials/snapshots.html",'<navbar icon="icon-gf icon-gf-snapshot" title="Snapshots" title-url="dashboard/snapshots"></navbar><div class="page-container"><div class="page-header"><h1>Available snapshots</h1></div><table class="filter-table" style="margin-top: 20px"><thead><th><strong>Name</strong></th><th><strong>Snapshot url</strong></th><th style="width: 70px"></th><th style="width: 25px"></th></thead><tr ng-repeat="snapshot in ctrl.snapshots"><td><a href="dashboard/snapshot/{{snapshot.key}}">{{snapshot.name}}</a></td><td><a href="dashboard/snapshot/{{snapshot.key}}">dashboard/snapshot/{{snapshot.key}}</a></td><td class="text-center"><a href="dashboard/snapshot/{{snapshot.key}}" class="btn btn-inverse btn-mini"><i class="fa fa-eye"></i> View</a></td><td class="text-right"><a ng-click="ctrl.removeSnapshot(snapshot)" class="btn btn-danger btn-mini"><i class="fa fa-remove"></i></a></td></tr></table></div>'),a.put("public/app/features/styleguide/styleguide.html",'<navbar icon="fa fa-fw fa-adjust" title="Style Guide" title-url="styleguide"></navbar><div class="page-container"><div class="page-header"><h1>Style Guide</h1><a class="btn btn-success" ng-click="ctrl.switchTheme()"><i class="fa fa-random"></i> Switch theme </a><a class="btn btn-inverse" ng-click="ctrl.switchTheme()"><i class="fa fa-refresh"></i> Reload</a><div class="page-header-tabs"><ul class="gf-tabs"><li class="gf-tabs-item" ng-repeat="page in ctrl.pages"><a class="gf-tabs-link" href="styleguide/{{page}}" ng-class="{active: ctrl.page[page]}">{{page}}</a></li></ul></div></div><div class="tab-pane" ng-if="ctrl.page.colors"><ul><li class="style-guide-color-card" ng-repeat="color in ctrl.colors" style="background-color: {{color.value}}"><strong>${{color.name}}</strong> <em>{{color.value}}</em></li></ul></div><div class="tab-pane" ng-if="ctrl.page.buttons"><div ng-repeat="variant in ctrl.buttonVariants" class="row"><div ng-repeat="btnSize in ctrl.buttonSizes" class="style-guide-button-list p-a-2 col-md-4"><button ng-repeat="buttonName in ctrl.buttonNames" class="btn btn{{variant}}{{buttonName}} {{btnSize}}">btn{{variant}}{{buttonName}}</button></div></div></div><div class="tab-pane" ng-if="ctrl.page.forms">forms</div></div>'),a.put("public/app/features/templating/partials/editor.html",'<div ng-controller="TemplateEditorCtrl" ng-init="init()"><div class="tabbed-view-header"><h2 class="tabbed-view-title">Templating</h2><ul class="gf-tabs"><li class="gf-tabs-item"><a class="gf-tabs-link" ng-click="mode = \'list\';" ng-class="{active: mode === \'list\'}">Variables</a></li><li class="gf-tabs-item" ng-show="mode === \'edit\'"><a class="gf-tabs-link" ng-class="{active: mode === \'edit\'}">Edit</a></li><li class="gf-tabs-item" ng-show="mode === \'new\'"><span class="active gf-tabs-link">New</span></li></ul><button class="tabbed-view-close-btn" ng-click="dismiss();dashboard.refresh();"><i class="fa fa-remove"></i></button></div><div class="tabbed-view-body"><div ng-if="mode === \'list\'"><div ng-if="variables.length === 0"><em>No template variables defined</em></div><table class="grafana-options-table"><tr ng-repeat="variable in variables"><td style="width: 1%"><span class="template-variable">${{variable.name}}</span></td><td class="max-width" style="max-width: 200px">{{variable.query}}</td><td style="width: 1%"><i ng-click="_.move(variables,$index,$index-1)" ng-hide="$first" class="pointer fa fa-arrow-up"></i></td><td style="width: 1%"><i ng-click="_.move(variables,$index,$index+1)" ng-hide="$last" class="pointer fa fa-arrow-down"></i></td><td style="width: 1%"><a ng-click="duplicate(variable)" class="btn btn-inverse btn-mini">Duplicate</a></td><td style="width: 1%"><a ng-click="edit(variable)" class="btn btn-inverse btn-mini"><i class="fa fa-edit"></i> Edit</a></td><td style="width: 1%"><a ng-click="removeVariable(variable)" class="btn btn-danger btn-mini"><i class="fa fa-remove"></i></a></td></tr></table></div><div class="gf-form" ng-show="mode === \'list\'"><div class="gf-form-button-row"><a type="button" class="btn gf-form-button btn-success" ng-click="mode = \'new\';"><i class="fa fa-plus"></i>&nbsp;&nbsp;New</a></div></div><div ng-if="mode === \'edit\' || mode === \'new\'"><h5 class="section-heading">Variable</h5><div class="gf-form-group"><div class="gf-form-inline"><div class="gf-form max-width-19"><span class="gf-form-label width-6">Name</span> <input type="text" class="gf-form-input" placeholder="name" ng-model="current.name"></div><div class="gf-form max-width-19"><span class="gf-form-label width-6">Type<info-popover mode="right-normal"><dl><dt>Query</dt><dd>Variable values are fetched from a metric names query to a data source</dd><dt>Interval</dt><dd>Timespan variable type</dd><dt>Datasource</dt><dd>Dynamically switch data sources using this type of variable</dd><dt>Custom</dt><dd>Define variable values manually</dd></dl><a href="http://docs.grafana.org/reference/templating" target="_blank">Templating docs</a></info-popover></span><div class="gf-form-select-wrapper max-width-17"><select class="gf-form-input" ng-model="current.type" ng-options="f.value as f.text for f in variableTypes" ng-change="typeChanged()"></select></div></div></div><div class="gf-form-inline"><div class="gf-form max-width-19"><span class="gf-form-label width-6">Label</span> <input type="text" class="gf-form-input" ng-model="current.label" placeholder="optional display name"></div><div class="gf-form max-width-19"><span class="gf-form-label width-6">Hide</span><div class="gf-form-select-wrapper max-width-15"><select class="gf-form-input" ng-model="current.hide" ng-options="f.value as f.text for f in hideOptions"></select></div></div></div></div><div ng-show="current.type === \'interval\'" class="gf-form-group"><h5 class="section-heading">Interval Options</h5><div class="gf-form"><span class="gf-form-label width-9">Values</span> <input type="text" class="gf-form-input" placeholder="name" ng-model="current.query" placeholder="1m,10m,1h,6h,1d,7d" ng-model-onblur ng-change="runQuery()"></div><div class="gf-form"><span class="gf-form-label width-9">Auto option</span><editor-checkbox text="Enable" model="current.auto" change="runQuery()"></editor-checkbox></div><div class="gf-form-inline"><div class="gf-form"><span class="gf-form-label width-9" ng-show="current.auto">Auto steps<tip>How many times should the current time range be divided to calculate the value</tip></span><div class="gf-form-select-wrapper max-width-10" ng-show="current.auto"><select class="gf-form-input" ng-model="current.auto_count" ng-options="f for f in [2,3,4,5,10,20,30,40,50,100,200,300,400,500]" ng-change="runQuery()"></select></div></div><div class="gf-form"><span class="gf-form-label" ng-show="current.auto">Min interval<tip>The calculated value will not go below this threshold</tip></span><input type="text" class="gf-form-input max-width-10" ng-show="current.auto" ng-model="current.auto_min" ng-change="runQuery()" placeholder="10s"></div></div></div><div ng-show="current.type === \'custom\'" class="gf-form-group"><h5 class="section-heading">Custom Options</h5><div class="gf-form"><span class="gf-form-label width-13">Values seperated by comma</span> <input type="text" class="gf-form-input" ng-model="current.query" ng-blur="runQuery()" placeholder="1, 10, 20, myvalue"></div></div><div ng-show="current.type === \'query\'" class="gf-form-group"><h5 class="section-heading">Query Options</h5><div class="gf-form-inline"><div class="gf-form max-width-21"><span class="gf-form-label width-7" ng-show="current.type === \'query\'">Data source</span><div class="gf-form-select-wrapper max-width-14"><select class="gf-form-input" ng-model="current.datasource" ng-options="f.value as f.name for f in datasources"></select></div></div><div class="gf-form max-width-21"><span class="gf-form-label width-7">Refresh<info-popover mode="right-normal">When to update the values of this variable.</info-popover></span><div class="gf-form-select-wrapper max-width-14"><select class="gf-form-input" ng-model="current.refresh" ng-options="f.value as f.text for f in refreshOptions"></select></div></div></div><div class="gf-form"><span class="gf-form-label width-7">Query</span> <input type="text" class="gf-form-input" ng-model="current.query" placeholder="metric name or tags query" ng-model-onblur ng-change="runQuery()"></div><div class="gf-form"><span class="gf-form-label width-7">Regex<info-popover mode="right-normal">Optional, if you want to extract part of a series name or metric node segment.</info-popover></span><input type="text" class="gf-form-input" ng-model="current.regex" placeholder="/.*-(.*)-.*/" ng-model-onblur ng-change="runQuery()"></div></div><div ng-show="current.type === \'datasource\'" class="gf-form-group"><h5 class="section-heading">Data source options</h5><div class="gf-form"><label class="gf-form-label width-12">Type</label><div class="gf-form-select-wrapper max-width-18"><select class="gf-form-input" ng-model="current.query" ng-options="f.value as f.text for f in datasourceTypes" ng-change="runQuery()"></select></div></div><div class="gf-form"><label class="gf-form-label width-12">Instance name filter<info-popover mode="right-normal">Regex filter for which data source instances to choose from in the variable value dropdown. Leave empty for all.<br><br>Example: <code>/^prod/</code></info-popover></label><input type="text" class="gf-form-input max-width-18" ng-model="current.regex" placeholder="/.*-(.*)-.*/" ng-model-onblur ng-change="runQuery()"></div></div><div class="section gf-form-group" ng-hide="current.type === \'datasource\'"><h5 class="section-heading">Selection Options</h5><div class="section"><gf-form-switch class="gf-form" label="Multi-value" label-class="width-10" tooltip="Enables multiple values to be selected at the same time" checked="current.multi" on-change="runQuery()"></gf-form-switch><gf-form-switch class="gf-form" label="Include All option" label-class="width-10" checked="current.includeAll" on-change="runQuery()"></gf-form-switch></div><div class="gf-form" ng-if="current.includeAll"><span class="gf-form-label width-10">Custom all value</span> <input type="text" class="gf-form-input max-width-15" ng-model="current.allValue" placeholder="blank = auto"></div></div><div class="gf-form-group" ng-if="current.type === \'query\'"><h5>Value groups/tags (Experimental feature)</h5><div class="gf-form"><editor-checkbox text="Enable" model="current.useTags" change="runQuery()"></editor-checkbox></div><div class="gf-form last" ng-if="current.useTags"><span class="gf-form-label width-10">Tags query</span> <input type="text" class="gf-form-input" ng-model="current.tagsQuery" placeholder="metric name or tags query" ng-model-onblur></div><div class="gf-form" ng-if="current.useTags"><li class="gf-form-label width-10">Tag values query</li><input type="text" class="gf-form-input" ng-model="current.tagValuesQuery" placeholder="apps.$tag.*" ng-model-onblur></div></div><div class="gf-form-group"><h5>Preview of values (shows max 20)</h5><div class="gf-form-inline"><div class="gf-form" ng-repeat="option in current.options | limitTo: 20"><span class="gf-form-label">{{option.text}}</span></div></div></div></div><div class="gf-form-button-row p-y-0"><button type="button" class="btn btn-success" ng-show="mode === \'edit\'" ng-click="update();">Update</button> <button type="button" class="btn btn-success" ng-show="mode === \'new\'" ng-click="add();">Add</button></div></div></div>'),
a.put("public/app/partials/bootstrap/tab.html",'<li ng-class="{active: active, disabled: disabled}"><a href ng-click="select()" tab-heading-transclude>{{heading}}</a></li>'),a.put("public/app/partials/bootstrap/tabset.html",'<div><ul class="nav nav-tabs" ng-class="{\'nav-stacked\': vertical, \'nav-justified\': justified}" ng-transclude></ul><div class="tab-content"><div class="tab-pane" ng-repeat="tab in tabs" ng-class="{active: tab.active}" tab-content-transclude="tab"></div></div></div>'),a.put("public/app/partials/confirm_modal.html",'<div class="modal-body"><div class="modal-header"><h2 class="modal-header-title"><i class="fa {{icon}}"></i> <span class="p-l-1">{{title}}</span></h2><a class="modal-header-close" ng-click="dismiss();"><i class="fa fa-remove"></i></a></div><div class="modal-content text-center"><div class="confirm-modal-text">{{text}}<div class="confirm-modal-text2" ng-show="text2">{{text2}}</div></div><div class="confirm-modal-buttons"><button type="button" class="btn btn-inverse" ng-click="dismiss()">{{noText}}</button> <button type="button" class="btn btn-danger" ng-click="onConfirm();dismiss();">{{yesText}}</button></div></div></div>'),a.put("public/app/partials/dashboard.html",'<div dash-class ng-if="dashboard"><dashnav></dashnav><div class="dashboard-container"><div dash-editor-view></div><dashboard-search></dashboard-search><div class="clearfix"></div><dashboard-submenu ng-if="submenuEnabled" dashboard="dashboard"></dashboard-submenu><div class="clearfix"></div><div class="grafana-row" ng-controller="RowCtrl" ng-repeat="(row_name, row) in dashboard.rows" row-height><div class="row-control"><div class="row-control-inner"><div class="row-close" ng-show="row.collapse" data-placement="bottom"><div class="row-close-buttons"><span class="row-button" ng-click="toggleRow(row)"><i bs-tooltip="\'Expand row\'" data-placement="right" class="fa fa-caret-left pointer"></i></span></div><div class="row-text pointer" ng-click="toggleRow(row)" ng-bind="row.title | interpolateTemplateVars:this"></div></div><div class="row-open" ng-show="!row.collapse"><div class="row-tab dropdown" ng-show="dashboardMeta.canEdit" ng-hide="dashboard.meta.fullscreen"><span class="row-tab-button dropdown-toggle" data-toggle="dropdown"><i class="fa fa-bars"></i></span><ul class="dropdown-menu dropdown-menu-right" role="menu" aria-labelledby="drop1"><li><a ng-click="toggleRow(row)">Collapse row</a></li><li class="dropdown-submenu"><a href="javascript:void(0);">Add Panel</a><ul class="dropdown-menu"><li bindonce ng-repeat="(key, value) in panels"><a ng-click="addPanelDefault(key)" bo-text="value.name"></a></li></ul></li><li class="dropdown-submenu"><a href="javascript:void(0);">Set height</a><ul class="dropdown-menu"><li><a ng-click="setHeight(\'25px\')">25 px</a></li><li><a ng-click="setHeight(\'100px\')">100 px</a></li><li><a ng-click="setHeight(\'150px\')">150 px</a></li><li><a ng-click="setHeight(\'200px\')">200 px</a></li><li><a ng-click="setHeight(\'250px\')">250 px</a></li><li><a ng-click="setHeight(\'300px\')">300 px</a></li><li><a ng-click="setHeight(\'350px\')">350 px</a></li><li><a ng-click="setHeight(\'450px\')">450 px</a></li><li><a ng-click="setHeight(\'500px\')">500 px</a></li><li><a ng-click="setHeight(\'600px\')">600 px</a></li><li><a ng-click="setHeight(\'700px\')">700 px</a></li></ul></li><li class="dropdown-submenu"><a href="javascript:void(0);">Move</a><ul class="dropdown-menu"><li><a ng-click="moveRow(\'up\')">Up</a></li><li><a ng-click="moveRow(\'down\')">Down</a></li><li><a ng-click="moveRow(\'top\')">To top</a></li><li><a ng-click="moveRow(\'bottom\')">To Bottom</a></li></ul></li><li><a ng-click="editRow()">Row editor</a></li><li><a ng-click="deleteRow()">Delete row</a></li></ul></div></div></div><div class="panels-wrapper" ng-if="!row.collapse"><div class="row-text pointer" ng-click="toggleRow(row)" ng-if="row.showTitle" ng-bind="row.title | interpolateTemplateVars:this"></div><div ng-repeat="panel in row.panels track by panel.id" class="panel" ui-draggable="!dashboard.meta.fullscreen" drag="panel.id" ui-on-drop="onDrop($data, row, panel)" drag-handle-class="drag-handle" panel-width><plugin-component type="panel" class="panel-margin"></plugin-component></div><div panel-drop-zone class="panel panel-drop-zone" ui-on-drop="onDrop($data, row)" data-drop="true"><div class="panel-container" style="background: transparent"><div style="text-align: center"><em>Drop here</em></div></div></div><div class="clearfix"></div></div></div></div><div ng-show="dashboardMeta.canEdit" class="row-fluid add-row-panel-hint" ng-hide="dashboard.meta.fullscreen"><div class="span12" style="text-align:right"><span style="margin-right: 10px" ng-click="addRowDefault()" class="pointer btn btn-secondary btn-small"><span><i class="fa fa-plus"></i> ADD ROW</span></span></div></div></div></div>'),a.put("public/app/partials/edit_json.html",'<div ng-controller="JsonEditorCtrl"><div class="tabbed-view-header"><h2 class="tabbed-view-title">JSON</h2><button class="tabbed-view-close-btn" ng-click="dismiss()"><i class="fa fa-remove"></i></button></div><div class="tabbed-view-body"><div class="gf-form"><textarea class="gf-form-input" ng-model="json" rows="20" spellcheck="false"></textarea></div><div class="gf-form-button-row"><button type="button" class="btn btn-success" ng-show="canUpdate" ng-click="update(); dismiss();">Update</button></div></div></div>'),a.put("public/app/partials/error.html",'<div class="row-fluid" style="margin-top: 100px"><div class="span2"></div><div class="grafana-info-box span8 text-center"><h3>Page not found (404)</h3></div><div class="span2"></div></div>'),a.put("public/app/partials/help_modal.html",'<div class="modal-body"><div class="modal-header"><h2 class="modal-header-title"><i class="fa fa-keyboard-o"></i> <span class="p-l-1">Keyboard shortcuts</span></h2><a class="modal-header-close" ng-click="dismiss();"><i class="fa fa-remove"></i></a></div><div class="modal-content"><table class="shortcut-table"><tr><th></th><th style="text-align: left">Dashboard wide shortcuts</th></tr><tr><td style="text-align: right"><span class="label label-info">ESC</span></td><td>Exit fullscreen edit/view mode, close search or any editor view</td></tr><tr><td><span class="label label-info">F</span></td><td>Open dashboard search view (also contains import/playlist controls)</td></tr><tr><td><span class="label label-info">R</span></td><td>Refresh (Fetches new data and rerenders panels)</td></tr><tr><td><span class="label label-info">left arrow key</span></td><td>Shift time backward</td></tr><tr><td><span class="label label-info">right arrow key</span></td><td>Shift time forward</td></tr><tr><td><span class="label label-info">CTRL+S</span></td><td>Save dashboard</td></tr><tr><td><span class="label label-info">CTRL+E</span></td><td>Export dashboard</td></tr><tr><td><span class="label label-info">CTRL+H</span></td><td>Hide row controls</td></tr><tr><td><span class="label label-info">CTRL+Z</span></td><td>Zoom out</td></tr><tr><td><span class="label label-info">CTRL+I</span></td><td>Quick snapshot</td></tr><tr><td><span class="label label-info">CTRL+O</span></td><td>Enable/Disable shared graph crosshair</td></tr></table></div></div>'),a.put("public/app/partials/inspector.html",'<div class="modal-body" ng-controller="InspectCtrl" ng-init="init()"><div class="modal-header"><h2 class="modal-header-title">Inspector</h2><ul class="gf-tabs"><li class="gf-tabs-item" ng-repeat="tab in [\'Request\', \'Response\', \'JS Error\']"><a class="gf-tabs-link" ng-click="editor.index = $index" ng-class="{active: editor.index === $index}">{{::tab}}</a></li></ul><a class="modal-header-close" ng-click="dismiss();"><i class="fa fa-remove"></i></a></div><div class="modal-content"><div ng-if="editor.index == 0"><h5 class="section-heading">Request details</h5><table class="filter-table gf-form-group"><tr><td>Url</td><td>{{inspector.error.config.url}}</td></tr><tr><td>Method</td><td>{{inspector.error.config.method}}</td></tr><tr ng-repeat="(key, value) in inspector.error.config.headers"><td>{{key}}</td><td>{{value}}</td></tr></table><h5 class="section-heading">Request parameters</h5><table class="filter-table"><tr ng-repeat="param in request_parameters"><td>{{param.key}}</td><td>{{param.value}}</td></tr></table></div><div ng-if="editor.index == 1"><h5 ng-show="message">{{message}}</h5><pre class="small">\n{{response}}\n			</pre></div><div ng-if="editor.index == 2"><label>Message:</label><pre>\n{{message}}\n</pre><label>Stack trace:</label><pre>\n			{{stack_trace}}\n		</pre></div></div></div>'),a.put("public/app/partials/login.html",'<div class="login-container container"><div class="login-box"><div class="login-box-logo"><img class="logo-icon" src="public/img/grafana_icon.svg"><br><i class="icon-gf icon-gf-grafana_wordmark"></i></div><div class="login-inner-box"><div class="login-tab-header"><button class="btn-login-tab" ng-click="loginMode = true;" ng-class="{active: loginMode}">Log in</button> <button class="btn-login-tab" ng-click="loginMode = false;" ng-class="{active: !loginMode}" ng-show="!disableUserSignUp">Sign up</button></div><form name="loginForm" class="login-form gf-form-group"><div class="gf-form" ng-if="loginMode"><span class="gf-form-label width-7">User</span> <input type="text" name="username" class="gf-form-input max-width-14" required ng-model="formModel.user" placeholder="{{loginHint}}"></div><div class="gf-form" ng-if="loginMode"><span class="gf-form-label width-7">Password</span> <input type="password" name="password" class="gf-form-input max-width-14" required ng-model="formModel.password" id="inputPassword" placeholder="password"></div><div class="gf-form" ng-if="!loginMode"><span class="gf-form-label width-7">Email</span> <input type="email" class="gf-form-input max-width-14" required ng-model="formModel.email" placeholder="email"></div><div class="gf-form-button-row"><button type="submit" class="btn btn-large p-x-3" ng-click="submit();" ng-class="{\'btn-inverse\': !loginForm.$valid, \'btn-primary\': loginForm.$valid}">{{submitBtnText}}</button></div></form><div ng-if="loginMode"><div class="text-center login-divider" ng-if="oauthEnabled"><div class="login-divider-line"><span class="login-divider-text">Or login with</span></div></div><div class="clearfix"></div><div class="login-oauth text-center" ng-if="oauthEnabled"><a class="btn btn-large btn-google" href="login/google" target="_self" ng-if="googleAuthEnabled"><i class="fa fa-google"></i> with Google </a><a class="btn btn-large btn-github" href="login/github" target="_self" ng-if="githubAuthEnabled"><i class="fa fa-github"></i> with Github</a></div></div><div class="clearfix"></div><div class="text-center password-recovery"><div class="text-center"><a href="user/password/send-reset-email">Forgot your password?</a></div></div></div><div class="row" style="margin-top: 50px"><div class="version-footer text-center small">Grafana version: {{buildInfo.version}}, commit: {{buildInfo.commit}}, build date: {{buildInfo.buildstamp | date: \'yyyy-MM-dd HH:mm:ss\' }}</div><div class="version-footer text-center small" ng-show="buildInfo.hasUpdate"><a class="external-link" target="_blank" href="http://grafana.org/download">New Grafana Version Available ({{buildInfo.latestVersion}})</a></div></div></div></div>'),a.put("public/app/partials/metrics.html",'<div class="query-editor-rows gf-form-group"><div ng-repeat="target in ctrl.panel.targets" ng-class="{\'gf-form-disabled\': target.hide}"><rebuild-on-change property="ctrl.panel.datasource || target.datasource" show-null="true"><plugin-component type="query-ctrl"></plugin-component></rebuild-on-change></div></div><metrics-ds-selector panel-ctrl="ctrl"></metrics-ds-selector><div class="gf-form-group"><rebuild-on-change property="ctrl.panel.datasource" show-null="true"><plugin-component type="query-options-ctrl"></plugin-component></rebuild-on-change></div>'),a.put("public/app/partials/modal.html",'<div class="modal-header"><button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button><h3>{{modal.title}}</h3></div><div class="modal-body"><div ng-bind-html="modal.body"></div></div><div class="modal-footer"><button type="button" class="btn btn-danger" ng-click="dismiss()">Close</button></div>'),a.put("public/app/partials/panelgeneral.html",'<div class="gf-form-group"><div class="gf-form-inline"><div class="gf-form max-width-21"><span class="gf-form-label width-8">Title</span> <input type="text" class="gf-form-input" ng-model="ctrl.panel.title"></div><div class="gf-form"><span class="gf-form-label width-6">Span</span><select class="gf-form-input gf-size-auto" ng-model="ctrl.panel.span" ng-options="f for f in [0,1,2,3,4,5,6,7,8,9,10,11,12]"></select></div><div class="gf-form max-width-26"><span class="gf-form-label width-8">Height</span> <input type="text" class="gf-form-input max-width-6" ng-model="ctrl.panel.height" placeholder="100px"><editor-checkbox text="Transparent" model="ctrl.panel.transparent"></editor-checkbox></div></div><div class="gf-form-inline"><div class="gf-form max-width-21"><span class="gf-form-label width-8">Repeat Panel</span><select class="gf-form-input" ng-model="ctrl.panel.repeat" ng-options="f.name as f.name for f in ctrl.dashboard.templating.list"><option value=""></option></select></div><div class="gf-form"><span class="gf-form-label width-6">Min span</span><select class="gf-form-input" ng-model="ctrl.panel.minSpan" ng-options="f for f in [1,2,3,4,5,6,7,8,9,10,11,12]"><option value=""></option></select></div></div></div><panel-links-editor panel="ctrl.panel"></panel-links-editor>'),a.put("public/app/partials/reset_password.html",'<div class="login-container container"><div class="login-box"><div class="login-box-logo"><img class="logo-icon" src="public/img/grafana_icon.svg"><br><i class="icon-gf icon-gf-grafana_wordmark"></i></div><div class="login-inner-box"><div class="login-tab-header"><button class="btn-login-tab" class="active">Reset password</button></div><form name="sendResetForm" class="login-form gf-form-group" ng-show="mode === \'send\'"><div class="gf-form"><span class="gf-form-label width-7">User</span> <input type="text" name="username" class="gf-form-input max-width-14" required ng-model="formModel.userOrEmail" placeholder="email or username"></div><div class="gf-form-button-row"><button type="submit" class="btn btn-large" ng-click="sendResetEmail();" ng-class="{\'btn-inverse\': !sendResetForm.$valid, \'btn-primary\': sendResetForm.$valid}">Send reset instructions</button></div></form><h5 style="text-align: center; padding: 20px" ng-if="mode === \'email-sent\'">An email with a reset link as been sent to the email address, you should receive it shortly.</h5><form name="resetForm" class="login-form gf-form-group" ng-show="mode === \'reset\'"><div class="gf-form"><span class="gf-form-label width-10">New Password</span> <input type="password" name="NewPassword" class="gf-form-input max-width-14" required ng-minlength="4" ng-model="formModel.newPassword" placeholder="password" watch-change="formModel.newPassword = inputValue;"></div><div class="gf-form"><span class="gf-form-label width-10">Confirm Password</span> <input type="password" name="ConfirmPassword" class="gf-form-input max-width-14" required ng-minlength="4" ng-model="formModel.confirmPassword" placeholder="confirm password"></div><div style="margin-left: 141px; width: 207px"><password-strength password="formModel.newPassword"></password-strength></div><div class="gf-form-button-row"><button type="submit" class="btn" ng-click="submitReset();" ng-class="{\'btn-inverse\': !resetForm.$valid, \'btn-primary\': resetForm.$valid}">Reset Password</button></div></form></div><div class="row" style="margin-top: 20px"><div class="text-center"><a href="login">Back to login</a></div></div></div></div>'),a.put("public/app/partials/roweditor.html",'<div class="tabbed-view-header"><h2 class="tabbed-view-title">Row settings</h2><button class="tabbed-view-close-btn" ng-click="dismiss();"><i class="fa fa-remove"></i></button></div><div class="tabbed-view-body"><div class="row"><div class="col-md-8"><div class="page-heading"><h5>Row details</h5></div><div class="gf-form-group"><div class="gf-form-inline"><div class="gf-form"><span class="gf-form-label width-6">Title</span> <input type="text" class="gf-form-input max-width-14" ng-model="row.title"></div><div class="gf-form"><span class="gf-form-label width-6">Height</span> <input type="text" class="gf-form-input max-width-8" ng-model="row.height"><editor-checkbox text="Show Title" model="row.showTitle"></editor-checkbox></div></div></div></div><div class="col-md-4"><div class="page-heading"><h5>Templating options</h5></div><div class="gf-form-group"><div class="gf-form"><span class="gf-form-label">Repeat Row</span><div class="gf-form-select-wrapper max-width-10"><select class="gf-form-input" ng-model="row.repeat" ng-options="f.name as f.name for f in dashboard.templating.list"><option value=""></option></select></div></div></div></div></div></div>'),a.put("public/app/partials/signup_invited.html",'<div class="container"><div class="signup-page-background"></div><div class="login-box"><div class="login-box-logo"><img class="logo-icon" src="public/img/grafana_icon.svg"><br><i class="icon-gf icon-gf-grafana_wordmark"></i></div><div class="invite-box"><h3>Hello {{greeting}}.</h3><div class="modal-tagline p-b-2"><em>{{invitedBy}}</em> has invited you to join Grafana and the organization <span class="highlight-word">{{contextSrv.user.orgName}}</span><br>Please complete the following to accept your invitation and continue:</div><form name="inviteForm" class="login-form gf-form-group"><div class="gf-form"><span class="gf-form-label width-7">Email</span> <input type="email" name="email" class="gf-form-input max-width-21" required ng-model="formModel.email" placeholder="Email"></div><div class="gf-form"><span class="gf-form-label width-7">Name</span> <input type="text" name="name" class="gf-form-input max-width-21" ng-model="formModel.name" placeholder="Name (optional)"></div><div class="gf-form"><span class="gf-form-label width-7">Username</span> <input type="text" name="username" class="gf-form-input max-width-21" required ng-model="formModel.username" placeholder="Username"></div><div class="gf-form"><span class="gf-form-label width-7">Password</span> <input type="password" name="password" class="gf-form-input max-width-21" required ng-model="formModel.password" id="inputPassword" placeholder="password"></div><div style="margin-left: 7.5rem; width: 254px"><password-strength password="formModel.password"></password-strength></div><div class="gf-form-button-row"><button type="submit" class="btn btn-inverse" ng-click="submit();" ng-class="{\'btn-inverse\': !inviteForm.$valid, \'btn-primary\': inviteForm.$valid}">Continue</button></div></form></div></div></div>'),a.put("public/app/partials/signup_step2.html",'<div class="container"><div class="signup-page-background"></div><div class="login-box"><div class="login-box-logo"><img class="logo-icon" src="public/img/grafana_icon.svg"><br><i class="icon-gf icon-gf-grafana_wordmark"></i></div><div class="invite-box"><h3>You\'re almost there.</h3><div class="modal-tagline">We just need a couple of more bits of<br>information to finish creating your account.</div><div style="display: inline-block; margin-top: 25px; width: 300px"><div class="editor-option"><label class="small">Your email:</label><span class="large">{{formModel.email}}</span></div></div><br><br><form name="signUpForm" class="login-form gf-form-group"><div class="gf-form" ng-if="verifyEmailEnabled"><span class="gf-form-label width-9">Email code<tip>Email verification code (sent to your email)</tip></span><input type="text" class="gf-form-input max-width-14" ng-model="formModel.code" required></div><div class="gf-form" ng-if="!autoAssignOrg"><span class="gf-form-label width-9">Org. name</span> <input type="text" name="orgName" class="gf-form-input max-width-14" ng-model="formModel.orgName" placeholder="Name your organization"></div><div class="gf-form"><span class="gf-form-label width-9">Your name</span> <input type="text" name="name" class="gf-form-input max-width-14" ng-model="formModel.name" placeholder="(optional)"></div><div class="gf-form"><span class="gf-form-label width-9">Username</span> <input type="text" class="gf-form-input max-width-14" required ng-model="formModel.username" placeholder="Username" autocomplete="off"></div><div class="gf-form"><span class="gf-form-label width-9">Password</span> <input type="password" class="gf-form-input max-width-14" required ng-model="formModel.password" id="inputPassword" placeholder="password" autocomplete="off"></div><div style="margin-left: 7.5rem; width: 254px"><password-strength password="formModel.password"></password-strength></div><div class="gf-form-button-row"><button type="submit" class="btn" ng-click="ctrl.submit();" ng-class="{\'btn-inverse\': !signUpForm.$valid, \'btn-primary\': signUpForm.$valid}">Continue</button></div></form></div></div></div>'),a.put("public/app/partials/unsaved-changes.html",'<div class="modal-body"><div class="modal-header"><h2 class="modal-header-title"><i class="fa fa-exclamation"></i> <span class="p-l-1">Unsaved changes</span></h2><a class="modal-header-close" ng-click="dismiss();"><i class="fa fa-remove"></i></a></div><div class="modal-content text-center"><div class="confirm-modal-text">What do you want to do?</div><div class="confirm-modal-buttons"><button type="button" class="btn btn-inverse" ng-click="dismiss()">Cancel</button> <button type="button" class="btn btn-danger" ng-click="ignore();dismiss()">Ignore</button> <button type="button" class="btn btn-success" ng-click="save();dismiss();">Save</button></div></div></div>'),a.put("public/app/partials/valueSelectDropdown.html",'<div class="variable-link-wrapper"><a ng-click="vm.show()" class="variable-value-link">{{vm.linkText}} <span ng-repeat="tag in vm.selectedTags" bs-tooltip="tag.valuesText" data-placement="bottom"><span class="label-tag" tag-color-from-name="tag.text">&nbsp;&nbsp;<i class="fa fa-tag"></i>&nbsp; {{tag.text}} </span></span><i class="fa fa-caret-down"></i> </a><input type="text" class="hidden-input input-small" style="display: none" ng-keydown="vm.keyDown($event)" ng-model="vm.search.query" ng-change="vm.queryChanged()"><div class="variable-value-dropdown" ng-if="vm.dropdownVisible" ng-class="{\'multi\': vm.variable.multi, \'single\': !vm.variable.multi}"><div class="variable-options-wrapper"><div class="variable-options-column"><a class="variable-options-column-header" ng-if="vm.variable.multi" ng-class="{\'many-selected\': vm.selectedValues.length > 1}" bs-tooltip="\'Clear selections\'" data-placement="top" ng-click="vm.clearSelections()"><span class="variable-option-icon"></span> Selected ({{vm.selectedValues.length}}) </a><a class="variable-option pointer" ng-repeat="option in vm.search.options" ng-class="{\'selected\': option.selected, \'highlighted\': $index === vm.highlightIndex}" ng-click="vm.selectValue(option, $event)"><span class="variable-option-icon"></span> <span>{{option.text}}</span></a></div><div class="variable-options-column" ng-if="vm.tags.length"><div class="variable-options-column-header text-center">Tags</div><a class="variable-option-tag pointer" ng-repeat="tag in vm.tags" ng-click="vm.selectTag(tag, $event)" ng-class="{\'selected\': tag.selected}"><span class="fa fa-fw variable-option-icon"></span> <span class="label-tag" tag-color-from-name="tag.text">{{tag.text}}&nbsp;&nbsp;<i class="fa fa-tag"></i>&nbsp;</span></a></div></div></div></div>'),a.put("public/app/plugins/datasource/cloudwatch/partials/annotations.editor.html",'<cloudwatch-query-parameter target="ctrl.annotation" datasource="ctrl.datasource"></cloudwatch-query-parameter><div class="editor-row" style="padding: 2rem 0"><div class="section"><h5>Prefix matching</h5><div class="editor-option"><editor-checkbox text="Enable" model="ctrl.annotation.prefixMatching"></editor-checkbox></div><div class="editor-option" ng-if="ctrl.annotation.prefixMatching"><label class="small">Action</label><input type="text" class="input-small" ng-model="ctrl.annotation.actionPrefix"></div><div class="editor-option" ng-if="ctrl.annotation.prefixMatching"><label class="small">Alarm Name</label><input type="text" class="input-small" ng-model="ctrl.annotation.alarmNamePrefix"></div></div></div>'),a.put("public/app/plugins/datasource/cloudwatch/partials/config.html",'<h3 class="page-heading">CloudWatch details</h3><div class="gf-form-group max-width-30"><div class="gf-form"><label class="gf-form-label width-13">Credentials profile name</label><input type="text" class="gf-form-input max-width-18" ng-model="ctrl.current.database" placeholder="default"><info-popover mode="right-absolute">Credentials profile name, as specified in ~/.aws/credentials, leave blank for default</info-popover></div><div class="gf-form"><label class="gf-form-label width-13">Default Region</label><div class="gf-form-select-wrapper max-width-18 gf-form-select-wrapper--has-help-icon"><select class="gf-form-input" ng-model="ctrl.current.jsonData.defaultRegion" ng-options="region for region in [\'ap-northeast-1\', \'ap-northeast-2\', \'ap-southeast-1\', \'ap-southeast-2\', \'cn-north-1\', \'eu-central-1\', \'eu-west-1\', \'sa-east-1\', \'us-east-1\', \'us-west-1\', \'us-west-2\']"></select><info-popover mode="right-absolute">Specify the region, such as for US West (Oregon) use ` us-west-2 ` as the region.</info-popover></div></div><div class="gf-form"><label class="gf-form-label width-13">Custom Metrics namespace</label><input type="text" class="gf-form-input max-width-18" ng-model="ctrl.current.jsonData.customMetricsNamespaces" placeholder="Namespace1,Namespace2"><info-popover mode="right-absolute">Namespaces of Custom Metrics</info-popover></div></div>'),a.put("public/app/plugins/datasource/cloudwatch/partials/query.editor.html",'<query-editor-row query-ctrl="ctrl" can-collapse="false"><cloudwatch-query-parameter target="ctrl.target" datasource="ctrl.datasource" on-change="ctrl.refresh()"></cloudwatch-query-parameter></query-editor-row>'),a.put("public/app/plugins/datasource/cloudwatch/partials/query.parameter.html",'<div class="gf-form-inline"><div class="gf-form"><label class="gf-form-label query-keyword width-7">Metric</label><metric-segment segment="regionSegment" get-options="getRegions()" on-change="regionChanged()"></metric-segment><metric-segment segment="namespaceSegment" get-options="getNamespaces()" on-change="namespaceChanged()"></metric-segment><metric-segment segment="metricSegment" get-options="getMetrics()" on-change="metricChanged()"></metric-segment></div><div class="gf-form"><label class="gf-form-label query-keyword">Stats</label></div><div class="gf-form" ng-repeat="segment in statSegments"><metric-segment segment="segment" get-options="getStatSegments(segment, $index)" on-change="statSegmentChanged(segment, $index)"></metric-segment></div><div class="gf-form gf-form--grow"><div class="gf-form-label gf-form-label--grow"></div></div></div><div class="gf-form-inline"><div class="gf-form"><label class="gf-form-label query-keyword width-7">Dimensions</label><metric-segment ng-repeat="segment in dimSegments" segment="segment" get-options="getDimSegments(segment, $index)" on-change="dimSegmentChanged(segment, $index)"></metric-segment></div><div class="gf-form gf-form--grow"><div class="gf-form-label gf-form-label--grow"></div></div></div><div class="gf-form-inline"><div class="gf-form"><label class="gf-form-label query-keyword width-7">Period<info-popover mode="right-normal">Interval between points in seconds</info-popover></label><input type="text" class="gf-form-input" ng-model="target.period" spellcheck="false" placeholder="auto" ng-model-onblur ng-change="onChange()"></div><div class="gf-form max-width-30"><label class="gf-form-label query-keyword width-7">Alias</label><input type="text" class="gf-form-input" ng-model="target.alias" spellcheck="false" ng-model-onblur ng-change="onChange()"><info-popover mode="right-absolute">Alias replacement variables:<ul ng-non-bindable><li>{{metric}}</li><li>{{stat}}</li><li>{{namespace}}</li><li>{{region}}</li><li>{{DIMENSION_NAME}}</li></ul></info-popover></div><div class="gf-form gf-form--grow"><div class="gf-form-label gf-form-label--grow"></div></div></div>'),a.put("public/app/plugins/datasource/elasticsearch/partials/annotations.editor.html",'<div class="gf-form-group"><div class="gf-form" ng-if="ctrl.annotation.index"><span class="gf-form-label width-14">Index name</span> <input type="text" class="gf-form-input max-width-20" ng-model="ctrl.annotation.index" placeholder="events-*"></div><div class="gf-form"><span class="gf-form-label width-14">Search query (lucene)<tip>Use [[filterName]] in query to replace part of the query with a filter value</tip></span><input type="text" class="gf-form-input max-width-20" ng-model="ctrl.annotation.query" placeholder="tags:deploy"></div></div><div class="gf-form-group"><h6>Field mappings</h6><div class="gf-form-inline"><div class="gf-form"><span class="gf-form-label width-10">Time</span> <input type="text" class="gf-form-input max-width-16" ng-model="ctrl.annotation.timeField" placeholder="@timestamp"></div><div class="gf-form"><span class="gf-form-label width-10">Title</span> <input type="text" class="gf-form-input max-width-16" ng-model="ctrl.annotation.titleField" placeholder="desc"></div></div><div class="gf-form-inline"><div class="gf-form"><span class="gf-form-label width-10">Tags</span> <input type="text" class="gf-form-input max-width-16" ng-model="ctrl.annotation.tagsField" placeholder="tags"></div><div class="gf-form"><span class="gf-form-label width-10">Text</span> <input type="text" class="gf-form-input max-width-16" ng-model="ctrl.annotation.textField" placeholder=""></div></div></div>'),a.put("public/app/plugins/datasource/elasticsearch/partials/bucket_agg.html",'<div class="gf-form-inline"><div class="gf-form"><label class="gf-form-label query-keyword width-7"><span ng-show="isFirst">Group by</span> <span ng-hide="isFirst">Then by</span></label><metric-segment-model property="agg.type" options="bucketAggTypes" on-change="onTypeChanged()" custom="false" css-class="width-10"></metric-segment-model><metric-segment-model ng-if="agg.field" property="agg.field" get-options="getFieldsInternal()" on-change="onChange()" css-class="width-12"></metric-segment-model></div><div class="gf-form gf-form--grow"><label class="gf-form-label gf-form-label--grow"><a ng-click="toggleOptions()"><i class="fa fa-caret-down" ng-show="showOptions"></i> <i class="fa fa-caret-right" ng-hide="showOptions"></i> {{settingsLinkText}}</a></label></div><div class="gf-form"><label class="gf-form-label" ng-if="isFirst"><a class="pointer" ng-click="addBucketAgg()"><i class="fa fa-plus"></i></a></label><label class="gf-form-label"><a class="pointer" ng-click="removeBucketAgg()"><i class="fa fa-minus"></i></a></label></div></div><div class="gf-form-group" ng-if="showOptions"><div ng-if="agg.type === \'date_histogram\'"><div class="gf-form offset-width-7"><label class="gf-form-label width-10">Interval</label><metric-segment-model property="agg.settings.interval" get-options="getIntervalOptions()" on-change="onChangeInternal()" css-class="width-12" custom="true"></metric-segment-model></div><div class="gf-form offset-width-7"><label class="gf-form-label width-10">Min Doc Count</label><input type="number" class="gf-form-input max-width-12" ng-model="agg.settings.min_doc_count" ng-blur="onChangeInternal()"></div><div class="gf-form offset-width-7"><label class="gf-form-label width-10">Trim edges<info-popover mode="right-normal">Trim the edges on the timeseries datapoints</info-popover></label><input class="gf-form-input max-width-12" type="number" ng-model="agg.settings.trimEdges" ng-change="onChangeInternal()"></div></div><div ng-if="agg.type === \'terms\'"><div class="gf-form offset-width-7"><label class="gf-form-label width-10">Order</label><metric-segment-model property="agg.settings.order" options="orderOptions" on-change="onChangeInternal()" css-class="width-12"></metric-segment-model></div><div class="gf-form offset-width-7"><label class="gf-form-label width-10">Size</label><metric-segment-model property="agg.settings.size" options="sizeOptions" on-change="onChangeInternal()" css-class="width-12"></metric-segment-model></div><div class="gf-form offset-width-7"><label class="gf-form-label width-10">Order By</label><metric-segment-model property="agg.settings.orderBy" options="orderByOptions" on-change="onChangeInternal()" css-class="width-12"></metric-segment-model></div></div><div ng-if="agg.type === \'filters\'"><div class="gf-form-inline offset-width-7" ng-repeat="filter in agg.settings.filters"><div class="gf-form"><label class="gf-form-label width-10">Query {{$index + 1}}</label><input type="text" class="gf-form-input max-width-12" ng-model="filter.query" spellcheck="false" placeholder="Lucene query" ng-blur="onChangeInternal()"></div><div class="gf-form"><label class="gf-form-label" ng-if="$first"><a class="pointer" ng-click="addFiltersQuery()"><i class="fa fa-plus"></i></a></label><label class="gf-form-label" ng-if="!$first"><a class="pointer" ng-click="removeFiltersQuery(filter)"><i class="fa fa-minus"></i></a></label></div></div></div><div ng-if="agg.type === \'geohash_grid\'"><div class="gf-form offset-width-7"><label class="gf-form-label width-10">Precision</label><input type="number" class="gf-form-input max-width-12" ng-model="agg.settings.precision" spellcheck="false" placeholder="3" ng-blur="onChangeInternal()"></div></div></div>'),
a.put("public/app/plugins/datasource/elasticsearch/partials/config.html",'<datasource-http-settings current="ctrl.current"></datasource-http-settings><h3 class="page-heading">Elasticsearch details</h3><div class="gf-form-group"><div class="gf-form-inline"><div class="gf-form max-width-25"><span class="gf-form-label width-9">Index name</span> <input class="gf-form-input" type="text" ng-model="ctrl.current.database" placeholder="" required></div><div class="gf-form width-14"><span class="gf-form-label width-9">Pattern</span><select class="gf-form-input gf-size-auto" ng-model="ctrl.current.jsonData.interval" ng-options="f.value as f.name for f in ctrl.indexPatternTypes" ng-change="ctrl.indexPatternTypeChanged()"></select></div></div><div class="gf-form max-width-25"><span class="gf-form-label width-9">Time field name</span> <input class="gf-form-input" type="text" ng-model="ctrl.current.jsonData.timeField" placeholder="" required ng-init=""></div><div class="gf-form"><span class="gf-form-label width-9">Version</span><select class="gf-form-input gf-size-auto" ng-model="ctrl.current.jsonData.esVersion" ng-options="f.value as f.name for f in ctrl.esVersions"></select></div></div><h3 class="page-heading">Default query settings</h3><div class="gf-form-group"><div class="gf-form"><span class="gf-form-label">Group by time interval</span> <input class="gf-form-input max-width-9" type="text" ng-model="ctrl.current.jsonData.timeInterval" spellcheck="false" placeholder="example: >10s"></div></div>'),a.put("public/app/plugins/datasource/elasticsearch/partials/metric_agg.html",'<div class="gf-form-inline" ng-class="{\'gf-form-disabled\': agg.hide}"><div class="gf-form"><label class="gf-form-label query-keyword width-7">Metric &nbsp; <a ng-click="toggleShowMetric()" bs-tooltip="\'Click to toggle show / hide metric\'"><i class="fa fa-eye" ng-hide="agg.hide"></i> <i class="fa fa-eye-slash" ng-show="agg.hide"></i></a></label></div><div class="gf-form"><metric-segment-model property="agg.type" options="metricAggTypes" on-change="onTypeChange()" custom="false" css-class="width-10"></metric-segment-model><metric-segment-model ng-if="aggDef.requiresField" property="agg.field" get-options="getFieldsInternal()" on-change="onChange()" css-class="width-12"></metric-segment-model><metric-segment-model ng-if="aggDef.isPipelineAgg" property="agg.pipelineAgg" options="pipelineAggOptions" on-change="onChangeInternal()" custom="false" css-class="width-12"></metric-segment-model></div><div class="gf-form gf-form--grow"><label class="gf-form-label gf-form-label--grow"><a ng-click="toggleOptions()" ng-if="settingsLinkText"><i class="fa fa-caret-down" ng-show="showOptions"></i> <i class="fa fa-caret-right" ng-hide="showOptions"></i> {{settingsLinkText}}</a></label></div><div class="gf-form"><label class="gf-form-label" ng-if="isFirst"><a class="pointer" ng-click="addMetricAgg()"><i class="fa fa-plus"></i></a></label><label class="gf-form-label" ng-if="!isSingle"><a class="pointer" ng-click="removeMetricAgg()"><i class="fa fa-minus"></i></a></label></div></div><div class="gf-form-group" ng-if="showOptions"><div class="gf-form offset-width-7" ng-if="agg.type === \'derivative\'"><label class="gf-form-label width-10">Unit</label><input type="text" class="gf-form-input max-width-12" ng-model="agg.settings.unit" ng-blur="onChangeInternal()" spellcheck="false"></div><div class="gf-form offset-width-7" ng-if="agg.type === \'moving_avg\'"><label class="gf-form-label width-10">Window</label><input type="number" class="gf-form-input max-width-12" ng-model="agg.settings.window" ng-blur="onChangeInternal()" spellcheck="false"></div><div class="gf-form offset-width-7" ng-if="agg.type === \'moving_avg\'"><label class="gf-form-label width-10">Model</label><input type="text" class="gf-form-input max-width-12" ng-change="onChangeInternal()" ng-model="agg.settings.model" blur="onChange()" spellcheck="false"></div><div class="gf-form offset-width-7" ng-if="agg.type === \'percentiles\'"><label class="gf-form-label width-10">Percentiles</label><input type="text" class="gf-form-input max-width-12" ng-model="agg.settings.percents" array-join ng-blur="onChange()"></div><div ng-if="agg.type === \'extended_stats\'"><gf-form-switch ng-repeat="stat in extendedStats" class="gf-form offset-width-7" label="{{stat.text}}" label-class="width-10" checked="agg.meta[stat.value]" on-change="onChangeInternal()"></gf-form-switch><div class="gf-form offset-width-7"><label class="gf-form-label width-10">Sigma</label><input type="number" class="gf-form-input max-width-12" placeholder="3" ng-model="agg.settings.sigma" ng-blur="onChange()"></div></div><div class="gf-form offset-width-7" ng-if="aggDef.supportsInlineScript"><label class="gf-form-label width-10">Script</label><input type="text" class="gf-form-input max-width-12" empty-to-null ng-model="agg.inlineScript" ng-blur="onChangeInternal()" spellcheck="false" placeholder="_value * 1"></div><div class="gf-form offset-width-7" ng-if="aggDef.supportsMissing"><label class="gf-form-label width-10">Missing<tip>The missing parameter defines how documents that are missing a value should be treated. By default they will be ignored but it is also possible to treat them as if they had a value</tip></label><input type="number" class="gf-form-input max-width-12" empty-to-null ng-model="agg.settings.missing" ng-blur="onChangeInternal()" spellcheck="false"></div></div>'),a.put("public/app/plugins/datasource/elasticsearch/partials/query.editor.html",'<query-editor-row query-ctrl="ctrl" can-collapse="true"><div class="gf-form-inline"><div class="gf-form gf-form--grow"><label class="gf-form-label query-keyword width-7">Query</label><input type="text" class="gf-form-input" ng-model="ctrl.target.query" spellcheck="false" placeholder="Lucene query" ng-blur="ctrl.refresh()"></div><div class="gf-form max-width-15"><label class="gf-form-label query-keyword">Alias</label><input type="text" class="gf-form-input" ng-model="ctrl.target.alias" spellcheck="false" placeholder="alias patterns" ng-blur="ctrl.refresh()"></div></div><div ng-repeat="agg in ctrl.target.metrics"><elastic-metric-agg target="ctrl.target" index="$index" get-fields="ctrl.getFields($fieldType)" on-change="ctrl.queryUpdated()" es-version="ctrl.esVersion"></elastic-metric-agg></div><div ng-repeat="agg in ctrl.target.bucketAggs"><elastic-bucket-agg target="ctrl.target" index="$index" get-fields="ctrl.getFields($fieldType)" on-change="ctrl.queryUpdated()"></elastic-bucket-agg></div></query-editor-row>'),a.put("public/app/plugins/datasource/elasticsearch/partials/query.options.html",'<section class="grafana-metric-options"><div class="gf-form-group"><div class="gf-form"><span class="gf-form-label"><i class="fa fa-wrench"></i> </span><span class="gf-form-label">Group by time interval</span> <input type="text" class="gf-form-input max-width-10" ng-model="ctrl.panelCtrl.panel.interval" ng-blur="ctrl.panelCtrl.refresh();" spellcheck="false" placeholder="example: >10s"> <span class="gf-form-label"><i class="fa fa-question-circle" bs-tooltip="\'Set a low limit by having a greater sign: example: >60s\'" data-placement="right"></i></span></div><div class="gf-form"><span class="gf-form-label"><i class="fa fa-info-circle"></i> </span><span class="gf-form-label width-23"><a ng-click="ctrl.panelCtrl.toggleEditorHelp(1);" bs-tooltip="\'click to show helpful info\'" data-placement="bottom">alias patterns</a></span></div></div></section><div class="pull-left"><div class="grafana-info-box" style="border: 0" ng-if="ctrl.panelCtrl.editorHelpIndex === 1"><h5>Alias patterns</h5><ul ng-non-bindable><li>{{term fieldname}} = replaced with value of term group by</li><li>{{metric}} = replaced with metric name (ex. Average, Min, Max)</li><li>{{field}} = replaced with the metric field name</li></ul></div></div>'),a.put("public/app/plugins/datasource/grafana-live/partials/query.editor.html",'<query-editor-row ctrl="ctrl"><li class="tight-form-item">Stream</li><li><input type="text" class="tight-form-input input-large" ng-model="ctrl.target.stream"></li></query-editor-row>'),a.put("public/app/plugins/datasource/grafana/partials/query.editor.html",'<query-editor-row query-ctrl="ctrl" can-collapse="false"><div class="gf-form-inline"><div class="gf-form"><label class="gf-form-label">Test metric (fake data source)</label></div></div></query-editor-row>'),a.put("public/app/plugins/datasource/graphite/partials/annotations.editor.html",'<div class="gf-form-group"><div class="gf-form"><span class="gf-form-label width-13">Graphite metrics query</span> <input type="text" class="gf-form-input" ng-model="ctrl.annotation.target" placeholder=""></div><div class="gf-form"><span class="gf-form-label width-13">Or Graphite events query</span> <input type="text" class="gf-form-input" ng-model="ctrl.annotation.tags" placeholder=""></div></div>'),a.put("public/app/plugins/datasource/graphite/partials/config.html",'<datasource-http-settings current="ctrl.current"></datasource-http-settings>'),a.put("public/app/plugins/datasource/graphite/partials/query.editor.html",'<query-editor-row query-ctrl="ctrl" has-text-edit-mode="true"><div class="gf-form" ng-show="ctrl.target.textEditor"><input type="text" class="gf-form-input" ng-model="ctrl.target.target" spellcheck="false" ng-blur="ctrl.refresh()"></div><div ng-hide="ctrl.target.textEditor"><div class="gf-form-inline"><div ng-repeat="segment in ctrl.segments" role="menuitem" class="gf-form"><metric-segment segment="segment" get-options="ctrl.getAltSegments($index)" on-change="ctrl.segmentValueChanged(segment, $index)"></metric-segment></div><div ng-repeat="func in ctrl.functions" class="gf-form"><span graphite-func-editor class="gf-form-label query-part"></span></div><div class="gf-form dropdown"><span graphite-add-func></span></div><div class="gf-form gf-form--grow"><div class="gf-form-label gf-form-label--grow"></div></div></div></div></query-editor-row>'),a.put("public/app/plugins/datasource/graphite/partials/query.options.html",'<section class="grafana-metric-options gf-form-group"><div class="gf-form-inline"><div class="gf-form max-width-15"><span class="gf-form-label width-8">Cache timeout </span><input type="text" class="gf-form-input" ng-model="ctrl.panelCtrl.panel.cacheTimeout" bs-tooltip="\'Graphite parameter to override memcache default timeout (unit is seconds)\'" data-placement="right" spellcheck="false" placeholder="60"></div><div class="gf-form max-width-15"><span class="gf-form-label">Max data points</span> <input type="text" class="gf-form-input" ng-model="ctrl.panelCtrl.panel.maxDataPoints" bs-tooltip="\'Override max data points, automatically set to graph width in pixels.\'" data-placement="right" ng-model-onblur ng-change="ctrl.panelCtrl.refresh()" spellcheck="false" placeholder="auto"></div></div><div class="gf-form-inline"><div class="gf-form"><span class="gf-form-label width-12"><i class="fa fa-info-circle"></i> <a ng-click="ctrl.panelCtrl.toggleEditorHelp(1);" bs-tooltip="\'click to show helpful info\'" data-placement="bottom">Shorter legend names </a></span><span class="gf-form-label width-12"><i class="fa fa-info-circle"></i> <a ng-click="ctrl.panelCtrl.toggleEditorHelp(2);" bs-tooltip="\'click to show helpful info\'" data-placement="bottom">Series as parameters </a></span><span class="gf-form-label width-7"><i class="fa fa-info-circle"></i> <a ng-click="ctrl.panelCtrl.toggleEditorHelp(3)" bs-tooltip="\'click to show helpful info\'" data-placement="bottom">Stacking </a></span><span class="gf-form-label width-8"><i class="fa fa-info-circle"></i> <a ng-click="ctrl.panelCtrl.toggleEditorHelp(4)" bs-tooltip="\'click to show helpful info\'" data-placement="bottom">Templating </a></span><span class="gf-form-label width-10"><i class="fa fa-info-circle"></i> <a ng-click="ctrl.panelCtrl.toggleEditorHelp(5)" bs-tooltip="\'click to show helpful info\'" data-placement="bottom">max data points</a></span></div></div></section><div class="editor-row"><div class="pull-left"><div class="grafana-info-box span8" ng-if="ctrl.panelCtrl.editorHelpIndex === 1"><h5>Shorter legend names</h5><ul><li>alias() function to specify a custom series name</li><li>aliasByNode(2) to alias by a specific part of your metric path</li><li>aliasByNode(2, -1) you can add multiple segment paths, and use negative index</li><li>groupByNode(2, \'sum\') is useful if you have 2 wildcards in your metric path and want to sumSeries and group by</li></ul></div><div class="grafana-info-box span8" ng-if="ctrl.panelCtrl.editorHelpIndex === 2"><h5>Series as parameter</h5><ul><li>Some graphite functions allow you to have many series arguments</li><li>Use #[A-Z] to use a graphite query as parameter to a function</li><li>Examples:<ul><li>asPercent(#A, #B)</li><li>prod.srv-01.counters.count - asPercent(#A) : percentage of count in comparison with A query</li><li>prod.srv-01.counters.count - sumSeries(#A) : sum count and series A</li><li>divideSeries(#A, #B)</li></ul></li><li>If a query is added only to be used as a parameter, hide it from the graph with the eye icon</li></ul></div><div class="grafana-info-box span6" ng-if="ctrl.panelCtrl.editorHelpIndex === 3"><h5>Stacking</h5><ul><li>You find the stacking option under Display Styles tab</li><li>When stacking is enabled make sure null point mode is set to \'null as zero\'</li></ul></div><div class="grafana-info-box span6" ng-if="ctrl.panelCtrl.editorHelpIndex === 4"><h5>Templating</h5><ul><li>You can use a template variable in place of metric names</li><li>You can use a template variable in place of function parameters</li><li>You enable the templating feature in Dashboard settings / Feature toggles</li></ul></div><div class="grafana-info-box span6" ng-if="ctrl.panelCtrl.editorHelpIndex === 5"><h5>Max data points</h5><ul><li>Every graphite request is issued with a maxDataPoints parameter</li><li>Graphite uses this parameter to consolidate the real number of values down to this number</li><li>If there are more real values, then by default they will be consolidated using averages</li><li>This could hide real peaks and max values in your series</li><li>You can change how point consolidation is made using the consolidateBy graphite function</li><li>Point consolidation will effect series legend values (min,max,total,current)</li><li>If you override maxDataPoint and set a high value performance can be severely effected</li></ul></div></div></div>'),a.put("public/app/plugins/datasource/influxdb/partials/annotations.editor.html",'<h5 class="section-heading">Query</h5><div class="gf-form-group"><div class="gf-form"><input type="text" class="gf-form-input" ng-model="ctrl.annotation.query" placeholder="select text from events where $timeFilter"></div></div><h5 class="section-heading">Column mappings<tip>If your influxdb query returns more than one column you need to specify the column names below. An annotation event is composed of a title, tags, and an additional text field.</tip></h5><div class="gf-form-group"><div class="gf-form-inline"><div class="gf-form"><span class="gf-form-label width-4">Title</span> <input type="text" class="gf-form-input max-width-10" ng-model="ctrl.annotation.titleColumn" placeholder=""></div><div class="gf-form"><span class="gf-form-label width-4">Tags</span> <input type="text" class="gf-form-input max-width-10" ng-model="ctrl.annotation.tagsColumn" placeholder=""></div><div class="gf-form"><span class="gf-form-label width-4">Text</span> <input type="text" class="gf-form-input max-width-10" ng-model="ctrl.annotation.textColumn" placeholder=""></div></div></div>'),a.put("public/app/plugins/datasource/influxdb/partials/config.html",'<datasource-http-settings current="ctrl.current"></datasource-http-settings><h3 class="page-heading">InfluxDB Details</h3><div class="gf-form-group"><div class="gf-form-inline"><div class="gf-form max-width-30"><span class="gf-form-label width-7">Database</span> <input type="text" class="gf-form-input" ng-model="ctrl.current.database" placeholder="" required></div></div><div class="gf-form-inline"><div class="gf-form max-width-15"><span class="gf-form-label width-7">User</span> <input type="text" class="gf-form-input" ng-model="ctrl.current.user" placeholder="" required></div><div class="gf-form max-width-15"><span class="gf-form-label width-7">Password</span> <input type="password" class="gf-form-input" ng-model="ctrl.current.password" placeholder="" required></div></div></div><div class="gf-form-group"><div class="gf-form max-width-21"><span class="gf-form-label">Default group by time</span> <input type="text" class="gf-form-input width-6" ng-model="ctrl.current.jsonData.timeInterval" spellcheck="false" placeholder="example: >10s"><i class="fa fa-question-circle" bs-tooltip="\'Set a low limit by having a greater sign: example: >10s\'" data-placement="right"></i></div></div>'),a.put("public/app/plugins/datasource/influxdb/partials/query.editor.html",'<query-editor-row query-ctrl="ctrl" can-collapse="true" has-text-edit-mode="true"><div class="gf-form" ng-if="ctrl.target.rawQuery"><input type="text" class="gf-form-input" ng-model="ctrl.target.query" spellcheck="false" ng-blur="ctrl.refresh()"></div><div ng-if="!ctrl.target.rawQuery"><div class="gf-form-inline"><div class="gf-form"><label class="gf-form-label query-keyword width-7">FROM</label><metric-segment segment="ctrl.policySegment" get-options="ctrl.getPolicySegments()" on-change="ctrl.policyChanged()"></metric-segment><metric-segment segment="ctrl.measurementSegment" get-options="ctrl.getMeasurements()" on-change="ctrl.measurementChanged()"></metric-segment></div><div class="gf-form"><label class="gf-form-label query-keyword">WHERE</label></div><div class="gf-form" ng-repeat="segment in ctrl.tagSegments"><metric-segment segment="segment" get-options="ctrl.getTagsOrValues(segment, $index)" on-change="ctrl.tagSegmentUpdated(segment, $index)"></metric-segment></div><div class="gf-form gf-form--grow"><div class="gf-form-label gf-form-label--grow"></div></div></div><div class="gf-form-inline" ng-repeat="selectParts in ctrl.queryModel.selectModels"><div class="gf-form"><label class="gf-form-label query-keyword width-7"><span ng-show="$index === 0">SELECT</span>&nbsp;</label></div><div class="gf-form" ng-repeat="part in selectParts"><influx-query-part-editor class="gf-form-label query-part" part="part" remove-action="ctrl.removeSelectPart(selectParts, part)" part-updated="ctrl.selectPartUpdated(selectParts, part)" get-options="ctrl.getPartOptions(part)"></influx-query-part-editor></div><div class="gf-form"><label class="dropdown" dropdown-typeahead="ctrl.selectMenu" dropdown-typeahead-on-select="ctrl.addSelectPart(selectParts, $item, $subItem)"></label></div><div class="gf-form gf-form--grow"><div class="gf-form-label gf-form-label--grow"></div></div></div><div class="gf-form-inline"><div class="gf-form"><label class="gf-form-label query-keyword width-7"><span>GROUP BY</span></label><influx-query-part-editor ng-repeat="part in ctrl.queryModel.groupByParts" part="part" class="gf-form-label query-part" remove-action="ctrl.removeGroupByPart(part, $index)" part-updated="ctrl.refresh();" get-options="ctrl.getPartOptions(part)"></influx-query-part-editor></div><div class="gf-form"><metric-segment segment="ctrl.groupBySegment" get-options="ctrl.getGroupByOptions()" on-change="ctrl.groupByAction(part, $index)"></metric-segment></div><div class="gf-form gf-form--grow"><div class="gf-form-label gf-form-label--grow"></div></div></div></div><div class="gf-form-inline"><div class="gf-form max-width-30"><label class="gf-form-label query-keyword width-7">ALIAS BY</label><input type="text" class="gf-form-input" ng-model="ctrl.target.alias" spellcheck="false" placeholder="Naming pattern" ng-blur="ctrl.refresh()"></div><div class="gf-form"><label class="gf-form-label">Format as</label><div class="gf-form-select-wrapper"><select class="gf-form-input gf-size-auto" ng-model="ctrl.target.resultFormat" ng-options="f.value as f.text for f in ctrl.resultFormats" ng-change="ctrl.refresh()"></select></div></div><div class="gf-form gf-form--grow"><div class="gf-form-label gf-form-label--grow"></div></div></div></query-editor-row>'),a.put("public/app/plugins/datasource/influxdb/partials/query.options.html",'<section class="grafana-metric-options"><div class="gf-form-group"><div class="gf-form-inline"><div class="gf-form"><span class="gf-form-label"><i class="fa fa-wrench"></i></span> <span class="gf-form-label width-11">Group by time interval</span> <input type="text" class="gf-form-input" ng-model="ctrl.panelCtrl.panel.interval" ng-blur="ctrl.panelCtrl.refresh();" spellcheck="false" placeholder="example: >10s"> <span class="gf-form-label"><i class="fa fa-question-circle" bs-tooltip="\'Set a low limit by having a greater sign: example: >60s\'" data-placement="right"></i></span></div></div><div class="gf-form-inline"><div class="gf-form"><span class="gf-form-label width-10"><a ng-click="ctrl.panelCtrl.toggleEditorHelp(1);" bs-tooltip="\'click to show helpful info\'" data-placement="bottom"><i class="fa fa-info-circle"></i> &nbsp;alias patterns </a></span><span class="gf-form-label width-10"><a ng-click="ctrl.panelCtrl.toggleEditorHelp(2)" bs-tooltip="\'click to show helpful info\'" data-placement="bottom"><i class="fa fa-info-circle"></i> &nbsp;stacking &amp; and fill </a></span><span class="gf-form-label width-10"><a ng-click="ctrl.panelCtrl.toggleEditorHelp(3)" bs-tooltip="\'click to show helpful info\'" data-placement="bottom"><i class="fa fa-info-circle"></i> &nbsp;group by time</a></span></div></div></div></section><div class="editor-row"><div class="pull-left"><div class="grafana-info-box span6" ng-if="ctrl.panelCtrl.editorHelpIndex === 1"><h5>Alias patterns</h5><ul><li>$m = replaced with measurement name</li><li>$measurement = replaced with measurement name</li><li>$1 - $9 = replaced with part of measurement name (if you separate your measurement name with dots)</li><li>$col = replaced with column name</li><li>$tag_hostname = replaced with the value of the hostname tag</li><li>You can also use [[tag_hostname]] pattern replacement syntax</li></ul></div><div class="grafana-info-box span6" ng-if="ctrl.panelCtrl.editorHelpIndex === 2"><h5>Stacking and fill</h5><ul><li>When stacking is enabled it important that points align</li><li>If there are missing points for one series it can cause gaps or missing bars</li><li>You must use fill(0), and select a group by time low limit</li><li>Use the group by time option below your queries and specify for example &gt;10s if your metrics are written every 10 seconds</li><li>This will insert zeros for series that are missing measurements and will make stacking work properly</li></ul></div><div class="grafana-info-box span6" ng-if="ctrl.panelCtrl.editorHelpIndex === 3"><h5>Group by time</h5><ul><li>Group by time is important, otherwise the query could return many thousands of datapoints that will slow down Grafana</li><li>Leave the group by time field empty for each query and it will be calculated based on time range and pixel width of the graph</li><li>If you use fill(0) or fill(null) set a low limit for the auto group by time interval</li><li>The low limit can only be set in the group by time option below your queries</li><li>You set a low limit by adding a greater sign before the interval</li><li>Example: &gt;60s if you write metrics to InfluxDB every 60 seconds</li></ul></div></div></div>'),a.put("public/app/plugins/datasource/influxdb/partials/query_part.html",'<div class="tight-form-func-controls"><span class="pointer fa fa-remove" ng-click="removeActionInternal()"></span></div><a ng-click="toggleControls()" class="query-part-name">{{part.def.type}}</a><span>(</span><span class="query-part-parameters"></span><span>)</span>'),a.put("public/app/plugins/datasource/opentsdb/partials/annotations.editor.html",'<div class="gf-form-group"><div class="gf-form"><span class="gf-form-label width-13">OpenTSDB metrics query</span> <input type="text" class="gf-form-input" ng-model="ctrl.annotation.target" placeholder="events.eventname"></div><div class="gf-form"><span class="gf-form-label width-13">Show Global Annotations?</span><editor-checkbox text="" model="ctrl.annotation.isGlobal"></editor-checkbox></div></div>'),a.put("public/app/plugins/datasource/opentsdb/partials/config.html",'<datasource-http-settings current="ctrl.current"></datasource-http-settings><h5>Opentsdb settings</h5><div class="gf-form"><span class="gf-form-label width-7">Version </span><span class="gf-form-select-wrapper"><select class="gf-form-input gf-size-auto" ng-model="ctrl.current.jsonData.tsdbVersion" ng-options="v.value as v.name for v in ctrl.tsdbVersions"></select></span></div><div class="gf-form"><span class="gf-form-label width-7">Resolution </span><span class="gf-form-select-wrapper"><select class="gf-form-input gf-size-auto" ng-model="ctrl.current.jsonData.tsdbResolution" ng-options="v.value as v.name for v in ctrl.tsdbResolutions"></select></span></div>'),a.put("public/app/plugins/datasource/opentsdb/partials/query.editor.html",'<query-editor-row query-ctrl="ctrl" can-collapse="false"><div class="gf-form-inline"><div class="gf-form max-width-25"><label class="gf-form-label query-keyword width-8">Metric<label class="gf-form-label" bs-tooltip="ctrl.errors.metric" style="color: rgb(229, 189, 28)" ng-show="ctrl.errors.metric"><i class="fa fa-warning"></i></label></label><input type="text" class="gf-form-input" ng-model="ctrl.target.metric" spellcheck="false" bs-typeahead="ctrl.suggestMetrics" placeholder="metric name" data-min-length="0" data-items="100" ng-blur="ctrl.targetBlur()"></div><div class="gf-form"><label class="gf-form-label query-keyword">Aggregator <a bs-tooltip="ctrl.errors.aggregator" style="color: rgb(229, 189, 28)" ng-show="ctrl.errors.aggregator"><i class="fa fa-warning"></i></a></label><div class="gf-form-select-wrapper max-width-15"><select ng-model="ctrl.target.aggregator" class="gf-form-input" ng-options="agg for agg in ctrl.aggregators" ng-change="ctrl.targetBlur()"></select></div></div><div class="gf-form max-width-20"><label class="gf-form-label query-keyword width-6">Alias:<info-popover mode="right-normal">Use patterns like $tag_tagname to replace part of the alias for a tag value</info-popover></label><input type="text" class="gf-form-input" ng-model="ctrl.target.alias" spellcheck="false" placeholder="series alias" data-min-length="0" data-items="100" ng-blur="ctrl.targetBlur()"></div><div class="gf-form gf-form--grow"><div class="gf-form-label gf-form-label--grow"></div></div></div><div class="gf-form-inline"><div class="gf-form max-width-25"><label class="gf-form-label query-keyword width-8">Down sample</label><input type="text" class="gf-form-input" ng-model="ctrl.target.downsampleInterval" ng-model-onblur ng-change="ctrl.targetBlur()" placeholder="interval"><info-popover mode="right-absolute">blank for auto, or for example <code>1m</code></info-popover></div><div class="gf-form"><label class="gf-form-label query-keyword">Aggregator</label><div class="gf-form-select-wrapper"><select ng-model="ctrl.target.downsampleAggregator" class="gf-form-input" ng-options="agg for agg in ctrl.aggregators" ng-change="ctrl.targetBlur()"></select></div></div><div class="gf-form" ng-if="ctrl.tsdbVersion >= 2"><label class="gf-form-label query-keyword width-6">Fill</label><div class="gf-form-select-wrapper"><select ng-model="ctrl.target.downsampleFillPolicy" class="gf-form-input" ng-options="agg for agg in ctrl.fillPolicies" ng-change="ctrl.targetBlur()"></select></div></div><gf-form-switch class="gf-form" label="Disable downsampling" label-class="query-keyword" checked="ctrl.target.disableDownsampling" on-change="ctrl.targetBlur()"></gf-form-switch><div class="gf-form gf-form--grow"><div class="gf-form-label gf-form-label--grow"></div></div></div><div class="gf-form-inline" ng-if="ctrl.tsdbVersion >= 2"><div class="gf-form"><label class="gf-form-label query-keyword width-8">Filters<info-popover mode="right-normal">Filters does not work with tags, either of the two will work but not both.</info-popover></label><div ng-repeat="fil in ctrl.target.filters track by $index" class="gf-form-label">{{fil.tagk}}&nbsp;=&nbsp;{{fil.type}}&#40;{{fil.filter}}&#41;&nbsp;&#44&nbsp;groupBy&nbsp;=&nbsp;{{fil.groupBy}} <a ng-click="ctrl.editFilter(fil, $index)"><i class="fa fa-pencil"></i> </a><a ng-click="ctrl.removeFilter($index)"><i class="fa fa-remove"></i></a></div><label class="gf-form-label query-keyword" ng-hide="ctrl.addFilterMode"><a ng-click="ctrl.addFilter()"><i class="fa fa-plus"></i></a></label></div><div class="gf-form-inline" ng-show="ctrl.addFilterMode"><div class="gf-form"><input type="text" class="gf-form-input" spellcheck="false" bs-typeahead="ctrl.suggestTagKeys" data-min-length="0" data-items="100" ng-model="ctrl.target.currentFilterKey" placeholder="key"></div><div class="gf-form"><label class="gf-form-label query-keyword">Type</label><div class="gf-form-select-wrapper"><select ng-model="ctrl.target.currentFilterType" class="gf-form-input" ng-options="filType for filType in ctrl.filterTypes"></select></div></div><div class="gf-form"><input type="text" class="gf-form-input" spellcheck="false" bs-typeahead="ctrl.suggestTagValues" data-min-length="0" data-items="100" ng-model="ctrl.target.currentFilterValue" placeholder="filter"></div><gf-form-switch class="gf-form" label="Group by" label-class="query-keyword" checked="ctrl.target.currentFilterGroupBy" on-change="ctrl.targetBlur()"></gf-form-switch><div class="gf-form" ng-show="ctrl.addFilterMode"><label class="gf-form-label" ng-show="ctrl.errors.filters"><a bs-tooltip="ctrl.errors.filters" style="color: rgb(229, 189, 28)"><i class="fa fa-warning"></i></a></label><label class="gf-form-label"><a ng-click="ctrl.addFilter()" ng-hide="ctrl.errors.filters">add filter</a> <a ng-click="ctrl.closeAddFilterMode()"><i class="fa fa-remove"></i></a></label></div></div><div class="gf-form gf-form--grow"><div class="gf-form-label gf-form-label--grow"></div></div></div><div class="gf-form-inline"><div class="gf-form"><label class="gf-form-label query-keyword width-8">Tags<info-popover mode="right-normal" ng-if="ctrl.tsdbVersion >= 2">Please use filters, tags are deprecated in opentsdb 2.2</info-popover></label></div><div class="gf-form" ng-repeat="(key, value) in ctrl.target.tags track by $index" class="gf-form"><label class="gf-form-label">{{key}}&nbsp;=&nbsp;{{value}} <a ng-click="ctrl.editTag(key, value)"><i class="fa fa-pencil"></i> </a><a ng-click="ctrl.removeTag(key)"><i class="fa fa-remove"></i></a></label></div><div class="gf-form" ng-hide="ctrl.addTagMode"><label class="gf-form-label query-keyword"><a ng-click="ctrl.addTag()"><i class="fa fa-plus"></i></a></label></div><div class="gf-form" ng-show="ctrl.addTagMode"><input type="text" class="gf-form-input" spellcheck="false" bs-typeahead="ctrl.suggestTagKeys" data-min-length="0" data-items="100" ng-model="ctrl.target.currentTagKey" placeholder="key"><input type="text" class="gf-form-input" spellcheck="false" bs-typeahead="ctrl.suggestTagValues" data-min-length="0" data-items="100" ng-model="ctrl.target.currentTagValue" placeholder="value"><label class="gf-form-label" ng-show="ctrl.errors.tags"><a bs-tooltip="ctrl.errors.tags" style="color: rgb(229, 189, 28)"><i class="fa fa-warning"></i></a></label><label class="gf-form-label"><a ng-click="ctrl.addTag()" ng-hide="ctrl.errors.tags">add tag</a> <a ng-click="ctrl.closeAddTagMode()"><i class="fa fa-remove"></i></a></label></div><div class="gf-form gf-form--grow"><div class="gf-form-label gf-form-label--grow"></div></div></div><div class="gf-form-inline"><gf-form-switch class="gf-form" label="Rate" label-class="width-8 query-keyword" checked="ctrl.target.shouldComputeRate" on-change="ctrl.targetBlur()"></gf-form-switch><gf-form-switch ng-hide="!ctrl.target.shouldComputeRate" class="gf-form" label="Counter" label-class="query-keyword" checked="ctrl.target.isCounter" on-change="ctrl.targetBlur()"></gf-form-switch><div class="gf-form" ng-hide="!ctrl.target.isCounter || !ctrl.target.shouldComputeRate"><label class="gf-form-label query-keyword">Counter Max</label><input type="text" class="gf-form-input" ng-disabled="!ctrl.target.shouldComputeRate" ng-model="ctrl.target.counterMax" spellcheck="false" placeholder="max value" ng-model-onblur ng-blur="ctrl.targetBlur()"><label class="gf-form-label query-keyword">Reset Value</label><input type="text" class="tight-form-input input-small" ng-disabled="!ctrl.target.shouldComputeRate" ng-model="ctrl.target.counterResetValue" spellcheck="false" placeholder="reset value" ng-model-onblur ng-blur="ctrl.targetBlur()"></div><div class="gf-form gf-form--grow"><div class="gf-form-label gf-form-label--grow"></div></div></div></query-editor-row>'),
a.put("public/app/plugins/datasource/prometheus/partials/annotations.editor.html",'<h5 class="section-heading">Search expression<div class="gf-form-group"><div class="gf-form"><input type="text" class="gf-form-input" ng-model="ctrl.annotation.expr" placeholder="ALERTS"></div></div><div class="gf-form-group"><h5 class="section-heading">Field formats<div class="gf-form-inline"><div class="gf-form"><span class="gf-form-label width-5">Title</span> <input type="text" class="gf-form-input max-width-9" ng-model="ctrl.annotation.titleFormat" placeholder="alertname"></div><div class="gf-form"><span class="gf-form-label width-5">Tags</span> <input type="text" class="gf-form-input max-width-9" ng-model="ctrl.annotation.tagKeys" placeholder="label1,label2"></div><div class="gf-form-inline"><div class="gf-form"><span class="gf-form-label width-5">Text</span> <input type="text" class="gf-form-input max-width-9" ng-model="ctrl.annotation.textFormat" placeholder="instance"></div></div></div></h5></div></h5>'),a.put("public/app/plugins/datasource/prometheus/partials/config.html",'<datasource-http-settings current="ctrl.current"></datasource-http-settings>'),a.put("public/app/plugins/datasource/prometheus/partials/query.editor.html",'<query-editor-row query-ctrl="ctrl" can-collapse="false"><div class="gf-form-inline"><div class="gf-form gf-form--grow"><label class="gf-form-label width-8">Query</label><input type="text" class="gf-form-input" ng-model="ctrl.target.expr" spellcheck="false" placeholder="query expression" data-min-length="0" data-items="100" ng-model-onblur ng-change="ctrl.refreshMetricData()"></div><div class="gf-form max-width-22"><label class="gf-form-label">Metric lookup</label><input type="text" class="gf-form-input" ng-model="ctrl.target.metric" spellcheck="false" bs-typeahead="ctrl.suggestMetrics" placeholder="metric name" data-min-length="0" data-items="100"></div></div><div class="gf-form-inline"><div class="gf-form max-width-26"><label class="gf-form-label width-8">Legend format</label><input type="text" class="gf-form-input" ng-model="ctrl.target.legendFormat" spellcheck="false" placeholder="legend format" data-min-length="0" data-items="1000" ng-model-onblur ng-change="ctrl.refreshMetricData()"></div><div class="gf-form"><label class="gf-form-label width-5">Step</label><input type="text" class="gf-form-input max-width-5" ng-model="ctrl.target.interval" data-placement="right" spellcheck="false" placeholder="{{ctrl.panelCtrl.interval}}" data-min-length="0" data-items="100" ng-model-onblur ng-change="ctrl.refreshMetricData()"><info-popover mode="right-absolute">Leave blank for auto handling based on time range and panel width</info-popover></div><div class="gf-form"><label class="gf-form-label">Resolution</label><div class="gf-form-select-wrapper max-width-15"><select ng-model="ctrl.target.intervalFactor" class="gf-form-input" ng-options="r.factor as r.label for r in ctrl.resolutions" ng-change="ctrl.refreshMetricData()"></select></div><label class="gf-form-label"><a href="{{ctrl.linkToPrometheus}}" target="_blank" bs-tooltip="\'Link to Graph in Prometheus\'"><i class="fa fa-share-square-o"></i></a></label></div><div class="gf-form gf-form--grow"><div class="gf-form-label gf-form-label--grow"></div></div></div></query-editor-row>'),a.put("public/app/plugins/panel/dashlist/editor.html",'<div><div class="section gf-form-group"><h5 class="section-heading">Options</h5><gf-form-switch class="gf-form" label="Starred" label-class="width-9" checked="ctrl.panel.starred" on-change="ctrl.refresh()"></gf-form-switch><gf-form-switch class="gf-form" label="Recently viewed" label-class="width-9" checked="ctrl.panel.recent" on-change="ctrl.refresh()"></gf-form-switch><gf-form-switch class="gf-form" label="Search" label-class="width-9" checked="ctrl.panel.search" on-change="ctrl.refresh()"></gf-form-switch><gf-form-switch class="gf-form" label="Show headings" label-class="width-9" checked="ctrl.panel.headings" on-change="ctrl.refresh()"></gf-form-switch><div class="gf-form"><span class="gf-form-label width-9">Max items</span> <input class="gf-form-input max-width-5" type="number" ng-model="ctrl.panel.limit" ng-model-onblur ng-change="ctrl.refresh()"></div></div><div class="section gf-form-group"><h5 class="section-heading">Search</h5><div class="gf-form"><span class="gf-form-label width-6">Query</span> <input type="text" class="gf-form-input" placeholder="title query" ng-model="ctrl.panel.query" ng-change="ctrl.refresh()" ng-model-onblur></div><div class="gf-form"><span class="gf-form-label width-6">Tags</span><bootstrap-tagsinput ng-model="ctrl.panel.tags" tagclass="label label-tag" placeholder="add tags" on-tags-updated="ctrl.refresh()"></bootstrap-tagsinput></div></div></div>'),a.put("public/app/plugins/panel/dashlist/module.html",'<div class="dashlist" ng-repeat="group in ctrl.groups"><div class="dashlist-section" ng-if="group.show"><h6 class="dashlist-section-header" ng-show="ctrl.panel.headings">{{group.header}}</h6><div class="dashlist-item" ng-repeat="dash in group.list"><a class="dashlist-link dashlist-link-{{dash.type}}" href="dashboard/{{dash.uri}}"><span class="dashlist-title">{{dash.title}} </span><span class="dashlist-star"><i class="fa" ng-class="{\'fa-star\': dash.isStarred, \'fa-star-o\': dash.isStarred === false}"></i></span></a></div></div></div>'),a.put("public/app/plugins/panel/graph/tab_axes.html",'<div class="editor-row"><div class="section gf-form-group" ng-repeat="yaxis in ctrl.panel.yaxes"><h5 class="section-heading" ng-show="$index === 0">Left Y</h5><h5 class="section-heading" ng-show="$index === 1">Right Y</h5><gf-form-switch class="gf-form" label="Show" label-class="width-5" checked="yaxis.show" on-change="ctrl.render()"></gf-form-switch><div ng-if="yaxis.show"><div class="gf-form"><label class="gf-form-label width-5">Unit</label><div class="gf-form-dropdown-typeahead max-width-15" ng-model="yaxis.format" dropdown-typeahead2="ctrl.unitFormats" dropdown-typeahead-on-select="ctrl.setUnitFormat(yaxis, $subItem)"></div></div><div class="gf-form"><label class="gf-form-label width-5">Scale</label><div class="gf-form-select-wrapper max-width-15"><select class="gf-form-input" ng-model="yaxis.logBase" ng-options="v as k for (k, v) in ctrl.logScales" ng-change="ctrl.render()"></select></div></div><div class="gf-form-inline"><div class="gf-form max-width-10"><label class="gf-form-label width-5">Y-Min</label><input type="number" class="gf-form-input" placeholder="auto" empty-to-null ng-model="yaxis.min" ng-change="ctrl.render()" ng-model-onblur></div><div class="gf-form max-width-10"><label class="gf-form-label width-5">Y-Max</label><input type="number" class="gf-form-input" placeholder="auto" empty-to-null ng-model="yaxis.max" ng-change="ctrl.render()" ng-model-onblur></div></div><div class="gf-form"><label class="gf-form-label width-5">Label</label><input type="text" class="gf-form-input max-width-20" ng-model="yaxis.label" ng-change="ctrl.render()" ng-model-onblur></div></div></div><div class="section gf-form-group"><h5 class="section-heading">X-Axis</h5><gf-form-switch class="gf-form" label="Show" label-class="width-5" checked="ctrl.panel.xaxis.show" on-change="ctrl.render()"></gf-form-switch></div><div class="section gf-form-group"><h5 class="section-heading">Thresholds</h5><div class="gf-form-inline"><div class="gf-form"><label class="gf-form-label width-6">Level 1</label><input type="number" class="gf-form-input max-width-5" ng-model="ctrl.panel.grid.threshold1" ng-change="ctrl.render()" ng-model-onblur></div><div class="gf-form"><label class="gf-form-label width-5">Color</label><div class="gf-form-label"><spectrum-picker ng-model="ctrl.panel.grid.threshold1Color" ng-change="ctrl.render()"></spectrum-picker></div></div></div><div class="gf-form-inline"><div class="gf-form"><label class="gf-form-label width-6">Level 2</label><input type="number" class="gf-form-input max-width-5" ng-model="ctrl.panel.grid.threshold2" ng-change="ctrl.render()" ng-model-onblur></div><div class="gf-form"><label class="gf-form-label width-5">Color</label><div class="gf-form-label"><spectrum-picker ng-model="ctrl.panel.grid.threshold2Color" ng-change="ctrl.render()"></spectrum-picker></div></div></div><gf-form-switch class="gf-form" label="Line Mode" label-class="width-6" checked="ctrl.panel.grid.thresholdLine" on-change="ctrl.render()"></gf-form-switch></div></div>'),a.put("public/app/plugins/panel/graph/tab_display.html",'<div class="editor-row"><div class="section gf-form-group"><h5 class="section-heading">Draw Modes</h5><gf-form-switch class="gf-form" label="Bars" label-class="width-5" checked="ctrl.panel.bars" on-change="ctrl.render()"></gf-form-switch><gf-form-switch class="gf-form" label="Lines" label-class="width-5" checked="ctrl.panel.lines" on-change="ctrl.render()"></gf-form-switch><gf-form-switch class="gf-form" label="Points" label-class="width-5" checked="ctrl.panel.points" on-change="ctrl.render()"></gf-form-switch></div><div class="section gf-form-group"><h5 class="section-heading">Mode Options</h5><div class="gf-form" ng-show="ctrl.panel.lines"><label class="gf-form-label width-8">Fill</label><div class="gf-form-select-wrapper max-width-5"><select class="gf-form-input" ng-model="ctrl.panel.fill" ng-options="f for f in [0,1,2,3,4,5,6,7,8,9,10]" ng-change="ctrl.render()"></select></div></div><div class="gf-form" ng-show="ctrl.panel.lines"><label class="gf-form-label width-8">Line Width</label><div class="gf-form-select-wrapper max-width-5"><select class="gf-form-input" ng-model="ctrl.panel.linewidth" ng-options="f for f in [0,1,2,3,4,5,6,7,8,9,10]" ng-change="ctrl.render()"></select></div></div><div class="gf-form" ng-show="ctrl.panel.points"><label class="gf-form-label width-8">Point Radius</label><div class="gf-form-select-wrapper max-width-5"><select class="gf-form-input" ng-model="ctrl.panel.pointradius" ng-options="f for f in [1,2,3,4,5,6,7,8,9,10]" ng-change="ctrl.render()"></select></div></div><gf-form-switch class="gf-form" label="Staircase" label-class="width-8" checked="ctrl.panel.steppedLine" on-change="ctrl.render()"></gf-form-switch></div><div class="section gf-form-group"><h5 class="section-heading">Misc options</h5><div class="gf-form"><label class="gf-form-label width-7">Null value</label><div class="gf-form-select-wrapper"><select class="gf-form-input max-width-8" ng-model="ctrl.panel.nullPointMode" ng-options="f for f in [\'connected\', \'null\', \'null as zero\']" ng-change="ctrl.render()"></select></div></div><div class="gf-form"><label class="gf-form-label width-7">Renderer</label><div class="gf-form-select-wrapper max-width-8"><select class="gf-form-input" ng-model="ctrl.panel.renderer" ng-options="f for f in [\'flot\', \'png\']" ng-change="ctrl.render()"></select></div></div><div class="gf-form"><label class="gf-form-label width-7">Tooltip mode</label><div class="gf-form-select-wrapper max-width-8"><select class="gf-form-input" ng-model="ctrl.panel.tooltip.shared" ng-options="f.value as f.text for f in [{text: \'All series\', value: true}, {text: \'Single\', value: false}]" ng-change="ctrl.render()"></select></div></div></div><div class="section gf-form-group"><h5 class="section-heading">Multiple Series</h5><gf-form-switch class="gf-form" label="Stack" label-class="width-7" checked="ctrl.panel.stack" on-change="ctrl.render()"></gf-form-switch><gf-form-switch class="gf-form" ng-show="ctrl.panel.stack" label="Percent" label-class="width-7" checked="ctrl.panel.percentage" on-change="ctrl.render()"></gf-form-switch><div class="gf-form" ng-show="ctrl.panel.stack"><label class="gf-form-label width-7">Tooltip value</label><div class="gf-form-select-wrapper max-width-8"><select class="gf-form-input" ng-model="ctrl.panel.tooltip.value_type" ng-options="f for f in [\'cumulative\',\'individual\']" ng-change="ctrl.render()"></select></div></div></div></div><div class="editor-row"><div class="section gf-form-group"><h5>Series specific overrides<tip>Regex match example: /server[0-3]/i</tip></h5><div class="tight-form-container"><div class="tight-form" ng-repeat="override in ctrl.panel.seriesOverrides" ng-controller="SeriesOverridesCtrl"><ul class="tight-form-list"><li class="tight-form-item"><i class="fa fa-remove pointer" ng-click="ctrl.removeSeriesOverride(override)"></i></li><li class="tight-form-item">alias or regex</li><li><input type="text" ng-model="override.alias" bs-typeahead="getSeriesNames" ng-blur="ctrl.render()" data-min-length="0" data-items="100" class="input-medium tight-form-input"></li><li class="tight-form-item" ng-repeat="option in currentOverrides"><i class="pointer fa fa-remove" ng-click="removeOverride(option)"></i> <span ng-show="option.propertyName === \'color\'">Color: <i class="fa fa-circle" ng-style="{color:option.value}"></i> </span><span ng-show="option.propertyName !== \'color\'">{{option.name}}: {{option.value}}</span></li><li class="dropdown" dropdown-typeahead="overrideMenu" dropdown-typeahead-on-select="setOverride($item, $subItem)"></li></ul><div class="clearfix"></div></div></div><button class="btn btn-inverse" style="margin-top: 20px" ng-click="ctrl.addSeriesOverride()">Add series specific option</button></div></div>'),a.put("public/app/plugins/panel/graph/tab_legend.html",'<div class="editor-row"><div class="section gf-form-group"><h5 class="section-heading">Options</h5><gf-form-switch class="gf-form" label="Show" label-class="width-7" checked="ctrl.panel.legend.show" on-change="ctrl.refresh()"></gf-form-switch><gf-form-switch class="gf-form" label="As Table" label-class="width-7" checked="ctrl.panel.legend.alignAsTable" on-change="ctrl.render()"></gf-form-switch><gf-form-switch class="gf-form" label="To the right" label-class="width-7" checked="ctrl.panel.legend.rightSide" on-change="ctrl.render()"></gf-form-switch><div ng-if="ctrl.panel.legend.rightSide" class="gf-form"><label class="gf-form-label width-7">Width</label><input type="number" class="gf-form-input max-width-5" placeholder="250" bs-tooltip="\'Set a min-width for the legend side table/block\'" data-placement="right" ng-model="ctrl.panel.legend.sideWidth" ng-change="ctrl.render()" ng-model-onblur></div></div><div class="section gf-form-group"><h5 class="section-heading">Values</h5><div class="gf-form-inline"><gf-form-switch class="gf-form" label="Min" label-class="width-4" checked="ctrl.panel.legend.min" on-change="ctrl.legendValuesOptionChanged()"></gf-form-switch><gf-form-switch class="gf-form max-width-12" label="Max" label-class="width-6" switch-class="max-width-5" checked="ctrl.panel.legend.max" on-change="ctrl.legendValuesOptionChanged()"></gf-form-switch></div><div class="gf-form-inline"><gf-form-switch class="gf-form" label="Avg" label-class="width-4" checked="ctrl.panel.legend.avg" on-change="ctrl.legendValuesOptionChanged()"></gf-form-switch><gf-form-switch class="gf-form max-width-12" label="Current" label-class="width-6" switch-class="max-width-5" checked="ctrl.panel.legend.current" on-change="ctrl.legendValuesOptionChanged()"></gf-form-switch></div><div class="gf-form-inline"><gf-form-switch class="gf-form" label="Total" label-class="width-4" checked="ctrl.panel.legend.total" on-change="ctrl.legendValuesOptionChanged()"></gf-form-switch><div class="gf-form"><label class="gf-form-label width-6">Decimals</label><input type="number" class="gf-form-input width-5" placeholder="auto" bs-tooltip="\'Override automatic decimal precision for legend and tooltips\'" data-placement="right" ng-model="ctrl.panel.decimals" ng-change="ctrl.render()" ng-model-onblur></div></div></div><div class="section gf-form-group"><h5 class="section-heading">Hide series</h5><gf-form-switch class="gf-form" label="With only nulls" label-class="width-10" checked="ctrl.panel.legend.hideEmpty" on-change="ctrl.render()"></gf-form-switch><gf-form-switch class="gf-form" label="With only zeros" label-class="width-10" checked="ctrl.panel.legend.hideZero" on-change="ctrl.render()"></gf-form-switch></div></div>'),a.put("public/app/plugins/panel/pluginlist/editor.html",'<div class="gf-form-group"><div class="gf-form-inline"><div class="gf-form"><span class="gf-form-label width-10">Mode</span><div class="gf-form-select-wrapper max-width-10"><select class="gf-form-input" ng-model="ctrl.panel.mode" ng-options="f for f in ctrl.modes" ng-change="ctrl.refresh()"></select></div></div><div class="gf-form" ng-show="ctrl.panel.mode === \'recently viewed\'"><span class="gf-form-label"><i class="grafana-tip fa fa-question-circle ng-scope" bs-tooltip="\'WARNING: This list will be cleared when clearing browser cache\'" data-original-title="" title=""></i></span></div></div><div class="gf-form-inline" ng-if="ctrl.panel.mode === \'search\'"><div class="gf-form"><span class="gf-form-label width-10">Search options</span> <span class="gf-form-label">Query</span> <input type="text" class="gf-form-input" placeholder="title query" ng-model="ctrl.panel.query" ng-change="ctrl.refresh()" ng-model-onblur></div><div class="gf-form"><span class="gf-form-label">Tags</span><bootstrap-tagsinput ng-model="ctrl.panel.tags" tagclass="label label-tag" placeholder="add tags" on-tags-updated="ctrl.refresh()"></bootstrap-tagsinput></div></div><div class="gf-form-inline"><div class="gf-form"><span class="gf-form-label width-10">Limit number to</span> <input class="gf-form-input" type="number" ng-model="ctrl.panel.limit" ng-model-onblur ng-change="ctrl.refresh()"></div></div></div>'),a.put("public/app/plugins/panel/pluginlist/module.html",'<div class="pluginlist"><div class="pluginlist-section" ng-repeat="category in ctrl.viewModel"><h6 class="pluginlist-section-header">{{category.header}}</h6><div class="pluginlist-item" ng-repeat="plugin in category.list"><a class="pluginlist-link pluginlist-link-{{plugin.state}} pointer" href="{{plugin.defaultNavUrl}}"><span><img ng-src="{{plugin.info.logos.small}}" class="pluginlist-image"> <span class="pluginlist-title">{{plugin.name}}</span> <span class="pluginlist-version">v{{plugin.info.version}}</span> </span><span class="pluginlist-message pluginlist-message--update" ng-show="plugin.hasUpdate" ng-click="ctrl.updateAvailable(plugin, $event)" bs-tooltip="\'New version: \' + plugin.latestVersion">Update available! </span><span class="pluginlist-message pluginlist-message--enable" ng-show="!plugin.enabled && !plugin.hasUpdate">Enable now </span><span class="pluginlist-message pluginlist-message--no-update" ng-show="plugin.enabled && !plugin.hasUpdate">Up to date</span></a></div><div class="pluginlist-item" ng-show="category.list.length === 0"><a class="pluginlist-link pluginlist-link-{{plugin.state}}" href="https://grafana.net/plugins"><span class="pluginlist-none-installed">None installed. <span class="pluginlist-emphasis">Browse Grafana.net</span></span></a></div></div></div>'),a.put("public/app/plugins/panel/singlestat/editor.html",'<div class="editor-row"><div class="section tight-form-container" style="margin-bottom: 20px"><div class="tight-form"><ul class="tight-form-list"><li class="tight-form-item" style="width: 80px"><strong>Big value</strong></li><li class="tight-form-item">Prefix</li><li><input type="text" class="input-small tight-form-input" ng-model="ctrl.panel.prefix" ng-change="ctrl.render()" ng-model-onblur></li><li class="tight-form-item">Value</li><li><select class="input-small tight-form-input" ng-model="ctrl.panel.valueName" ng-options="f for f in [\'min\',\'max\',\'avg\', \'current\', \'total\']" ng-change="ctrl.render()"></select></li><li class="tight-form-item">Postfix</li><li><input type="text" class="input-small tight-form-input last" ng-model="ctrl.panel.postfix" ng-change="ctrl.render()" ng-model-onblur></li></ul><div class="clearfix"></div></div><div class="tight-form"><ul class="tight-form-list"><li class="tight-form-item" style="width: 80px"><strong>Font size</strong></li><li class="tight-form-item">Prefix</li><li><select class="input-small tight-form-input" ng-model="ctrl.panel.prefixFontSize" ng-options="f for f in ctrl.fontSizes" ng-change="ctrl.render()"></select></li><li class="tight-form-item">Value</li><li><select class="input-small tight-form-input" ng-model="ctrl.panel.valueFontSize" ng-options="f for f in ctrl.fontSizes" ng-change="ctrl.render()"></select></li><li class="tight-form-item">Postfix</li><li><select class="input-small tight-form-input last" ng-model="ctrl.panel.postfixFontSize" ng-options="f for f in ctrl.fontSizes" ng-change="ctrl.render()"></select></li></ul><div class="clearfix"></div></div><div class="tight-form"><ul class="tight-form-list"><li class="tight-form-item" style="width: 80px"><strong>Unit</strong></li><li class="dropdown" style="width: 266px" ng-model="ctrl.panel.format" dropdown-typeahead="ctrl.unitFormats" dropdown-typeahead-on-select="ctrl.setUnitFormat($subItem)"></li><li class="tight-form-item">Decimals</li><li><input type="number" class="input-small tight-form-input last" placeholder="auto" bs-tooltip="\'Override automatic decimal precision for legend and tooltips\'" data-placement="right" ng-model="ctrl.panel.decimals" ng-change="ctrl.render()" ng-model-onblur></li></ul><div class="clearfix"></div></div></div></div><div class="editor-row"><div class="section" style="margin-bottom: 20px"><div class="tight-form last"><ul class="tight-form-list"><li class="tight-form-item" style="width: 80px"><strong>Coloring</strong></li><li class="tight-form-item">Background&nbsp; <input class="cr1" id="ctrl.panel.colorBackground" type="checkbox" ng-model="ctrl.panel.colorBackground" ng-checked="ctrl.panel.colorBackground" ng-change="ctrl.render()"><label for="ctrl.panel.colorBackground" class="cr1"></label></li><li class="tight-form-item">Value&nbsp; <input class="cr1" id="ctrl.panel.colorValue" type="checkbox" ng-model="ctrl.panel.colorValue" ng-checked="ctrl.panel.colorValue" ng-change="ctrl.render()"><label for="ctrl.panel.colorValue" class="cr1"></label></li><li class="tight-form-item">Thresholds<tip>Define two threshold values&lt;br /&gt; 50,80 will produce: &lt;50 = Green, 50:80 = Yellow, &gt;80 = Red</tip></li><li><input type="text" class="input-large tight-form-input" ng-model="ctrl.panel.thresholds" ng-blur="ctrl.render()" placeholder="50,80"></li><li class="tight-form-item">Colors</li><li class="tight-form-item"><spectrum-picker ng-model="ctrl.panel.colors[0]" ng-change="ctrl.render()"></spectrum-picker><spectrum-picker ng-model="ctrl.panel.colors[1]" ng-change="ctrl.render()"></spectrum-picker><spectrum-picker ng-model="ctrl.panel.colors[2]" ng-change="ctrl.render()"></spectrum-picker></li><li class="tight-form-item last"><a class="pointer" ng-click="ctrl.invertColorOrder()">invert order</a></li></ul><div class="clearfix"></div></div></div></div><div class="editor-row"><div class="section" style="margin-bottom: 20px"><div class="tight-form last"><ul class="tight-form-list"><li class="tight-form-item" style="width: 80px"><strong>Spark lines</strong></li><li class="tight-form-item">Show&nbsp; <input class="cr1" id="ctrl.panel.sparkline.show" type="checkbox" ng-model="ctrl.panel.sparkline.show" ng-checked="ctrl.panel.sparkline.show" ng-change="ctrl.render()"><label for="ctrl.panel.sparkline.show" class="cr1"></label></li><li class="tight-form-item">Background mode&nbsp; <input class="cr1" id="ctrl.panel.sparkline.full" type="checkbox" ng-model="ctrl.panel.sparkline.full" ng-checked="ctrl.panel.sparkline.full" ng-change="ctrl.render()"><label for="ctrl.panel.sparkline.full" class="cr1"></label></li><li class="tight-form-item">Line Color</li><li class="tight-form-item"><spectrum-picker ng-model="ctrl.panel.sparkline.lineColor" ng-change="ctrl.render()"></spectrum-picker></li><li class="tight-form-item">Fill Color</li><li class="tight-form-item last"><spectrum-picker ng-model="ctrl.panel.sparkline.fillColor" ng-change="ctrl.render()"></spectrum-picker></li></ul><div class="clearfix"></div></div></div></div><div class="editor-row"><div class="section" style="margin-bottom: 20px"><div class="tight-form"><ul class="tight-form-list"><li class="tight-form-item" style="width: 80px"><strong>Gauge</strong></li><li class="tight-form-item">Show&nbsp; <input class="cr1" id="panel.gauge.show" type="checkbox" ng-model="ctrl.panel.gauge.show" ng-checked="ctrl.panel.gauge.show" ng-change="ctrl.render()"><label for="panel.gauge.show" class="cr1"></label></li><li class="tight-form-item">Min</li><li><input type="number" class="input-small tight-form-input" ng-model="ctrl.panel.gauge.minValue" ng-blur="ctrl.render()" placeholder="0"></li><li class="tight-form-item last">Max</li><li><input type="number" class="input-small tight-form-input last" ng-model="ctrl.panel.gauge.maxValue" ng-blur="ctrl.render()" placeholder="100"><span class="alert-state-critical" ng-show="ctrl.invalidGaugeRange">&nbsp; <i class="fa fa-warning"></i> Min value is bigger than max.</span></li></ul><div class="clearfix"></div></div><div class="tight-form last"><li class="tight-form-item">Threshold labels&nbsp; <input class="cr1" id="panel.gauge.thresholdLabels" type="checkbox" ng-model="ctrl.panel.gauge.thresholdLabels" ng-checked="ctrl.panel.gauge.thresholdLabels" ng-change="ctrl.render()"><label for="panel.gauge.thresholdLabels" class="cr1"></label></li><li class="tight-form-item">Threshold markers&nbsp; <input class="cr1" id="panel.gauge.thresholdMarkers" type="checkbox" ng-model="ctrl.panel.gauge.thresholdMarkers" ng-checked="ctrl.panel.gauge.thresholdMarkers" ng-change="ctrl.render()"><label for="panel.gauge.thresholdMarkers" class="cr1"></label></li><div class="clearfix"></div></div></div></div><div class="editor-row"><div class="section" style="margin-bottom: 20px"><div class="tight-form last"><ul class="tight-form-list"><li class="tight-form-item"><strong>Value to text mapping</strong></li><li class="tight-form-item" ng-repeat-start="map in ctrl.panel.valueMaps"><i class="fa fa-remove pointer" ng-click="ctrl.removeValueMap(map)"></i></li><li><input type="text" ng-model="map.value" placeholder="value" class="input-mini tight-form-input" ng-blur="ctrl.render()"></li><li class="tight-form-item"><i class="fa fa-arrow-right"></i></li><li ng-repeat-end><input type="text" placeholder="text" ng-model="map.text" class="input-mini tight-form-input" ng-blur="ctrl.render()"></li><li><a class="pointer tight-form-item last" ng-click="ctrl.addValueMap();"><i class="fa fa-plus"></i></a></li></ul><div class="clearfix"></div></div></div></div>'),a.put("public/app/plugins/panel/singlestat/module.html",'<div class="singlestat-panel"></div>'),a.put("public/app/plugins/panel/table/editor.html",'<div class="editor-row"><div class="section"><h5>Data</h5><div class="tight-form-container"><div class="tight-form"><ul class="tight-form-list"><li class="tight-form-item" style="width: 140px">To Table Transform</li><li><select class="input-large tight-form-input" ng-model="editor.panel.transform" ng-options="k as v.description for (k, v) in editor.transformers" ng-change="editor.transformChanged()"></select></li></ul><div class="clearfix"></div></div><div class="tight-form"><ul class="tight-form-list"><li class="tight-form-item" style="width: 140px">Columns</li><li class="tight-form-item" ng-repeat="column in editor.panel.columns"><i class="pointer fa fa-remove" ng-click="editor.removeColumn(column)"></i> <span>{{column.text}}</span></li><li><metric-segment segment="editor.addColumnSegment" get-options="editor.getColumnOptions()" on-change="editor.addColumn()"></metric-segment></li></ul><div class="clearfix"></div></div></div></div><div class="section"><h5>Table Display</h5><div class="tight-form-container"><div class="tight-form"><ul class="tight-form-list"><li class="tight-form-item">Pagination (Page size)</li><li><input type="number" class="input-small tight-form-input" placeholder="100" empty-to-null ng-model="editor.panel.pageSize" ng-change="editor.render()" ng-model-onblur></li><li class="tight-form-item"><editor-checkbox text="Scroll" model="editor.panel.scroll" change="editor.render()"></editor-checkbox></li><li class="tight-form-item">Font size</li><li><select class="input-small tight-form-input" ng-model="editor.panel.fontSize" ng-options="f for f in editor.fontSizes" ng-change="editor.render()"></select></li></ul><div class="clearfix"></div></div></div></div></div><div class="editor-row" style="margin-top: 20px"><h5>Column Styles</h5><div class="tight-form-container"><div ng-repeat="style in editor.panel.styles"><div class="tight-form"><ul class="tight-form-list pull-right"><li class="tight-form-item last"><i class="fa fa-remove pointer" ng-click="editor.removeColumnStyle(style)"></i></li></ul><ul class="tight-form-list"><li class="tight-form-item">Name or regex</li><li><input type="text" ng-model="style.pattern" bs-typeahead="editor.getColumnNames" ng-blur="editor.render()" data-min-length="0" data-items="100" class="input-medium tight-form-input"></li><li class="tight-form-item" style="width: 86px">Type</li><li><select class="input-small tight-form-input" ng-model="style.type" ng-options="c.value as c.text for c in editor.columnTypes" ng-change="editor.render()" style="width: 150px"></select></li></ul><ul class="tight-form-list" ng-if="style.type === \'date\'"><li class="tight-form-item">Format</li><li><metric-segment-model property="style.dateFormat" options="editor.dateFormats" on-change="editor.render()" custom="true"></metric-segment-model></li></ul><div class="clearfix"></div></div><div class="tight-form" ng-if="style.type === \'number\'"><ul class="tight-form-list"><li class="tight-form-item text-right" style="width: 93px">Coloring</li><li><select class="input-small tight-form-input" ng-model="style.colorMode" ng-options="c.value as c.text for c in editor.colorModes" ng-change="editor.render()" style="width: 150px"></select></li><li class="tight-form-item">Thresholds<tip>Comma seperated values</tip></li><li><input type="text" class="input-small tight-form-input" style="width: 150px" ng-model="style.thresholds" ng-blur="editor.render()" placeholder="50,80" array-join></li><li class="tight-form-item" style="width: 60px">Colors</li><li class="tight-form-item"><spectrum-picker ng-model="style.colors[0]" ng-change="editor.render()"></spectrum-picker><spectrum-picker ng-model="style.colors[1]" ng-change="editor.render()"></spectrum-picker><spectrum-picker ng-model="style.colors[2]" ng-change="editor.render()"></spectrum-picker></li><li class="tight-form-item last"><a class="pointer" ng-click="editor.invertColorOrder($index)">invert order</a></li></ul><div class="clearfix"></div></div><div class="tight-form" ng-if="style.type === \'number\'"><ul class="tight-form-list"><li class="tight-form-item text-right" style="width: 93px">Unit</li><li class="dropdown" style="width: 150px" ng-model="style.unit" dropdown-typeahead="editor.unitFormats" dropdown-typeahead-on-select="editor.setUnitFormat(style, $subItem)"></li><li class="tight-form-item" style="width: 86px">Decimals</li><li style="width: 105px"><input type="number" class="input-mini tight-form-input" ng-model="style.decimals" ng-change="render()" ng-model-onblur></li></ul><div class="clearfix"></div></div></div></div><button class="btn btn-inverse" style="margin-top: 20px" ng-click="editor.addColumnStyle()">Add column style rule</button></div>'),a.put("public/app/plugins/panel/table/module.html",'<div class="table-panel-container"><div class="table-panel-header-bg"></div><div class="table-panel-scroll"><table class="table-panel-table"><thead><tr><th ng-repeat="col in ctrl.table.columns"><div class="table-panel-table-header-inner pointer" ng-click="ctrl.toggleColumnSort(col, $index)">{{col.text}} <span class="table-panel-table-header-controls" ng-if="col.sort"><i class="fa fa-caret-down" ng-show="col.desc"></i> <i class="fa fa-caret-up" ng-hide="col.desc"></i></span></div></th></tr></thead><tbody></tbody></table></div></div><div class="table-panel-footer"></div>'),a.put("public/app/plugins/panel/table/options.html","<grafana-panel-table-editor></grafana-panel-table-editor>"),
a.put("public/app/plugins/panel/text/editor.html","<div class=\"gf-form-group\"><div class=\"gf-form-inline\"><div class=\"gf-form\"><span class=\"gf-form-label\">Mode</span> <span class=\"gf-form-select-wrapper\"><select class=\"gf-form-input\" ng-model=\"ctrl.panel.mode\" ng-options=\"f for f in ['html','markdown','text']\"></select></span></div><div class=\"gf-form\" ng-show=\"ctrl.panel.mode == 'text'\"><span class=\"gf-form-label\">Font Size</span> <span class=\"gf-form-select-wrapper\"><select class=\"gf-form-input\" ng-model=\"ctrl.panel.style['font-size']\" ng-options=\"f for f in ['6pt','7pt','8pt','10pt','12pt','14pt','16pt','18pt','20pt','24pt','28pt','32pt','36pt','42pt','48pt','52pt','60pt','72pt']\"></select></span></div></div></div><h3 class=\"page-heading\">Content</h3><span ng-show=\"ctrl.panel.mode == 'markdown'\">(This area uses <a target=\"_blank\" href=\"http://en.wikipedia.org/wiki/Markdown\">Markdown</a>. HTML is not supported)</span><textarea class=\"gf-form-input\" ng-model=\"ctrl.panel.content\" rows=\"20\" style=\"width:95%\" ng-change=\"ctrl.render()\" ng-model-onblur>\n</textarea>"),a.put("public/app/plugins/panel/text/module.html",'<p class="panel-text-content" ng-bind-html="ctrl.content" ng-show="ctrl.content"></p>'),a.put("public/app/plugins/panel/unknown/module.html",'<div class="text-center" style="padding-top: 2rem">Unknown panel type: <strong>{{ctrl.panel.type}}</strong></div>')}])});