/*
 * Decompiled with CFR 0.152.
 */
package jspecview.app;

import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import javajs.J2SRequireImport;
import javajs.api.EventManager;
import javajs.api.GenericMouseInterface;
import javajs.awt.event.Event;
import jspecview.api.JSVPanel;
import org.jmol.util.Logger;

@J2SRequireImport(value={Event.class})
public class GenericMouse
implements GenericMouseInterface {
    protected EventManager pd;
    protected JSVPanel jsvp;
    protected int xWhenPressed;
    protected int yWhenPressed;
    protected int modifiersWhenPressed10;
    protected boolean isMouseDown;
    private boolean disposed;

    public GenericMouse(JSVPanel jsvp) {
        this.jsvp = jsvp;
        this.pd = jsvp.getPanelData();
    }

    @Override
    public void clear() {
    }

    @Override
    public boolean processEvent(int id, int x, int y, int modifiers, long time) {
        if (this.pd == null) {
            if (!this.disposed && id == 501 && (modifiers & 4) != 0) {
                this.jsvp.showMenu(x, y);
            }
            return true;
        }
        if (id != -1) {
            modifiers = GenericMouse.applyLeftMouse(modifiers);
        }
        switch (id) {
            case -1: {
                this.wheeled(time, x, modifiers | 0x20);
                break;
            }
            case 501: {
                this.xWhenPressed = x;
                this.yWhenPressed = y;
                this.modifiersWhenPressed10 = modifiers;
                this.pressed(time, x, y, modifiers, false);
                break;
            }
            case 506: {
                this.dragged(time, x, y, modifiers);
                break;
            }
            case 504: {
                this.entered(time, x, y);
                break;
            }
            case 505: {
                this.exited(time, x, y);
                break;
            }
            case 503: {
                this.moved(time, x, y, modifiers);
                break;
            }
            case 502: {
                this.released(time, x, y, modifiers);
                if (x != this.xWhenPressed || y != this.yWhenPressed || modifiers != this.modifiersWhenPressed10) break;
                this.clicked(time, x, y, modifiers, 1);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public void mouseEntered(MouseEvent e) {
        this.entered(e.getWhen(), e.getX(), e.getY());
    }

    public void mouseExited(MouseEvent e) {
        this.exited(e.getWhen(), e.getX(), e.getY());
    }

    public void mouseMoved(MouseEvent e) {
        this.moved(e.getWhen(), e.getX(), e.getY(), e.getModifiers());
    }

    public void mousePressed(MouseEvent e) {
        this.pressed(e.getWhen(), e.getX(), e.getY(), e.getModifiers(), e.isPopupTrigger());
    }

    public void mouseDragged(MouseEvent e) {
        int modifiers = e.getModifiers();
        if ((modifiers & 0x1C) == 0) {
            modifiers |= 0x10;
        }
        this.dragged(e.getWhen(), e.getX(), e.getY(), modifiers);
    }

    public void mouseReleased(MouseEvent e) {
        this.released(e.getWhen(), e.getX(), e.getY(), e.getModifiers());
    }

    public void mouseClicked(MouseEvent e) {
        this.clicked(e.getWhen(), e.getX(), e.getY(), e.getModifiers(), e.getClickCount());
    }

    public void mouseWheelMoved(MouseWheelEvent e) {
        e.consume();
        this.wheeled(e.getWhen(), e.getWheelRotation(), e.getModifiers() | 0x20);
    }

    public void keyTyped(KeyEvent ke) {
        if (this.pd == null) {
            return;
        }
        char ch = ke.getKeyChar();
        int modifiers = ke.getModifiers();
        Logger.info("MouseManager keyTyped: " + ch + " " + ('\u0000' + ch) + " " + modifiers);
        if (this.pd.keyTyped(ch, modifiers)) {
            ke.consume();
        }
    }

    public void keyPressed(KeyEvent ke) {
        if (this.pd != null && this.pd.keyPressed(ke.getKeyCode(), ke.getModifiers())) {
            ke.consume();
        }
    }

    public void keyReleased(KeyEvent ke) {
        if (this.pd != null) {
            this.pd.keyReleased(ke.getKeyCode());
        }
    }

    protected void entered(long time, int x, int y) {
        if (this.pd != null) {
            this.pd.mouseEnterExit(time, x, y, false);
        }
    }

    protected void exited(long time, int x, int y) {
        if (this.pd != null) {
            this.pd.mouseEnterExit(time, x, y, true);
        }
    }

    protected void clicked(long time, int x, int y, int modifiers, int clickCount) {
        if (this.pd != null) {
            this.pd.mouseAction(2, time, x, y, 1, modifiers);
        }
    }

    protected void moved(long time, int x, int y, int modifiers) {
        if (this.pd == null) {
            return;
        }
        if (this.isMouseDown) {
            this.pd.mouseAction(1, time, x, y, 0, GenericMouse.applyLeftMouse(modifiers));
        } else {
            this.pd.mouseAction(0, time, x, y, 0, modifiers & 0xFFFFFFE3);
        }
    }

    protected void wheeled(long time, int rotation, int modifiers) {
        if (this.pd != null) {
            this.pd.mouseAction(3, time, 0, rotation, 0, modifiers);
        }
    }

    protected void pressed(long time, int x, int y, int modifiers, boolean isPopupTrigger) {
        if (this.pd == null) {
            if (!this.disposed) {
                this.jsvp.showMenu(x, y);
            }
            return;
        }
        this.isMouseDown = true;
        this.pd.mouseAction(4, time, x, y, 0, modifiers);
    }

    protected void released(long time, int x, int y, int modifiers) {
        if (this.pd == null) {
            return;
        }
        this.isMouseDown = false;
        this.pd.mouseAction(5, time, x, y, 0, modifiers);
    }

    protected void dragged(long time, int x, int y, int modifiers) {
        if (this.pd == null) {
            return;
        }
        if ((modifiers & 0x14) == 20) {
            modifiers = modifiers & 0xFFFFFFFB | 2;
        }
        this.pd.mouseAction(1, time, x, y, 0, modifiers);
    }

    protected static int applyLeftMouse(int modifiers) {
        return (modifiers & 0x1C) == 0 ? modifiers | 0x10 : modifiers;
    }

    @Override
    public void processTwoPointGesture(float[][][] touches) {
    }

    @Override
    public void dispose() {
        this.pd = null;
        this.jsvp = null;
        this.disposed = true;
    }
}

