/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.providers.http.org.jsoup.parser;

import org.apache.maven.wagon.providers.http.org.jsoup.helper.DescendableLinkedList;
import org.apache.maven.wagon.providers.http.org.jsoup.helper.Validate;
import org.apache.maven.wagon.providers.http.org.jsoup.nodes.Document;
import org.apache.maven.wagon.providers.http.org.jsoup.nodes.Element;
import org.apache.maven.wagon.providers.http.org.jsoup.parser.CharacterReader;
import org.apache.maven.wagon.providers.http.org.jsoup.parser.ParseErrorList;
import org.apache.maven.wagon.providers.http.org.jsoup.parser.Token;
import org.apache.maven.wagon.providers.http.org.jsoup.parser.Tokeniser;

abstract class TreeBuilder {
    CharacterReader reader;
    Tokeniser tokeniser;
    protected Document doc;
    protected DescendableLinkedList<Element> stack;
    protected String baseUri;
    protected Token currentToken;
    protected ParseErrorList errors;

    TreeBuilder() {
    }

    protected void initialiseParse(String input, String baseUri, ParseErrorList errors) {
        Validate.notNull(input, "String input must not be null");
        Validate.notNull(baseUri, "BaseURI must not be null");
        this.doc = new Document(baseUri);
        this.reader = new CharacterReader(input);
        this.errors = errors;
        this.tokeniser = new Tokeniser(this.reader, errors);
        this.stack = new DescendableLinkedList();
        this.baseUri = baseUri;
    }

    Document parse(String input, String baseUri) {
        return this.parse(input, baseUri, ParseErrorList.noTracking());
    }

    Document parse(String input, String baseUri, ParseErrorList errors) {
        this.initialiseParse(input, baseUri, errors);
        this.runParser();
        return this.doc;
    }

    protected void runParser() {
        Token token;
        do {
            token = this.tokeniser.read();
            this.process(token);
        } while (token.type != Token.TokenType.EOF);
    }

    protected abstract boolean process(Token var1);

    protected Element currentElement() {
        return (Element)this.stack.getLast();
    }
}

