/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.util;

import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.Handle;
import CH.ifa.draw.util.Undoable;
import CH.ifa.draw.util.UndoableAdapter;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

public class UndoableHandle
implements Handle {
    private Handle myWrappedHandle;
    private DrawingView myDrawingView;

    public UndoableHandle(Handle newWrappedHandle, DrawingView newDrawingView) {
        this.setWrappedHandle(newWrappedHandle);
        this.setDrawingView(newDrawingView);
    }

    public Point locate() {
        return this.getWrappedHandle().locate();
    }

    public void invokeStart(int x, int y, Drawing drawing) {
        this.getWrappedHandle().invokeStart(x, y, drawing);
    }

    public void invokeStart(int x, int y, DrawingView view) {
        this.getWrappedHandle().invokeStart(x, y, view);
    }

    public void invokeStep(int dx, int dy, Drawing drawing) {
        this.getWrappedHandle().invokeStep(dx, dy, drawing);
    }

    public void invokeStep(int x, int y, int anchorX, int anchorY, DrawingView view) {
        this.getWrappedHandle().invokeStep(x, y, anchorX, anchorY, view);
    }

    public void invokeEnd(int x, int y, int anchorX, int anchorY, DrawingView view) {
        this.getWrappedHandle().invokeEnd(x, y, anchorX, anchorY, view);
        Undoable undoableActivity = this.getWrappedHandle().getUndoActivity();
        if (undoableActivity != null && undoableActivity.isUndoable()) {
            this.getDrawingView().editor().getUndoManager().pushUndo(undoableActivity);
            this.getDrawingView().editor().getUndoManager().clearRedos();
        }
    }

    public void invokeEnd(int dx, int dy, Drawing drawing) {
        this.getWrappedHandle().invokeEnd(dx, dy, drawing);
    }

    public Figure owner() {
        return this.getWrappedHandle().owner();
    }

    public Rectangle displayBox() {
        return this.getWrappedHandle().displayBox();
    }

    public boolean containsPoint(int x, int y) {
        return this.getWrappedHandle().containsPoint(x, y);
    }

    public void draw(Graphics g) {
        this.getWrappedHandle().draw(g);
    }

    protected void setWrappedHandle(Handle newWrappedHandle) {
        this.myWrappedHandle = newWrappedHandle;
    }

    protected Handle getWrappedHandle() {
        return this.myWrappedHandle;
    }

    public DrawingView getDrawingView() {
        return this.myDrawingView;
    }

    protected void setDrawingView(DrawingView newDrawingView) {
        this.myDrawingView = newDrawingView;
    }

    public Undoable getUndoActivity() {
        return new UndoableAdapter(this.getDrawingView());
    }

    public void setUndoActivity(Undoable newUndoableActivity) {
    }
}

