/*
 * Decompiled with CFR 0.152.
 */
package jde.wizards;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Vector;
import jde.util.DynamicClassLoader;
import jde.wizards.MethodFactory;
import jde.wizards.NameFactory;
import jde.wizards.Signature;

public class MethodOverrideFactory
extends MethodFactory {
    static MethodOverrideFactory overrideFactory;
    Vector candidates = new Vector();
    String baseClassName;
    String methodName;

    public MethodOverrideFactory() {
    }

    public MethodOverrideFactory(NameFactory factory) {
        super(factory);
    }

    private Vector getOverrideableMethods(Class cl, String methodName) {
        Vector<Method> m = new Vector<Method>();
        Class baseClass = cl;
        while (baseClass != null) {
            Method[] methods = baseClass.getDeclaredMethods();
            int i = 0;
            while (i < methods.length) {
                int methodModifiers;
                if (methods[i].getName().equals(methodName) && (Modifier.isPublic(methodModifiers = methods[i].getModifiers()) || Modifier.isProtected(methodModifiers)) && !Modifier.isFinal(methodModifiers)) {
                    m.addElement(methods[i]);
                }
                ++i;
            }
            baseClass = baseClass.getSuperclass();
        }
        return m;
    }

    public static void getCandidateSignatures(String baseClassName, String methodName) {
        if (overrideFactory == null) {
            overrideFactory = new MethodOverrideFactory();
        } else {
            overrideFactory.flush();
        }
        MethodOverrideFactory.overrideFactory.baseClassName = baseClassName;
        MethodOverrideFactory.overrideFactory.methodName = methodName;
        try {
            DynamicClassLoader dcl = new DynamicClassLoader();
            Vector methods = overrideFactory.getOverrideableMethods(dcl.loadClass(baseClassName), methodName);
            int i = 0;
            while (i < methods.size()) {
                Method m = (Method)methods.elementAt(i);
                Signature s = new Signature(m, overrideFactory);
                boolean containsSignature = false;
                int j = 0;
                while (j < MethodOverrideFactory.overrideFactory.candidates.size()) {
                    if (s.equals(MethodOverrideFactory.overrideFactory.candidates.elementAt(j))) {
                        containsSignature = true;
                        break;
                    }
                    ++j;
                }
                if (!containsSignature) {
                    MethodOverrideFactory.overrideFactory.candidates.addElement(s);
                }
                ++i;
            }
            int n = MethodOverrideFactory.overrideFactory.candidates.size();
            if (n > 0) {
                String res = "(list ";
                int i2 = 0;
                while (i2 < n) {
                    Signature s = (Signature)MethodOverrideFactory.overrideFactory.candidates.elementAt(i2);
                    s.setTruncating(false);
                    String p = s.getParameters(s.getMethod().getParameterTypes(), false);
                    s.setTruncating(true);
                    res = res + "\"" + methodName + "(" + p + ")\" ";
                    ++i2;
                }
                res = res + ")";
                MethodFactory.println(res);
            } else {
                MethodFactory.println("(error \"Could not find any method named " + methodName + " in " + baseClassName + " or any of its superclasses.\")");
            }
        }
        catch (ClassNotFoundException ee) {
            MethodFactory.println("(error \"Could not find class " + baseClassName + "\")");
        }
    }

    public static void getMethodSkeletonExpression(int variant) {
        Signature s = (Signature)MethodOverrideFactory.overrideFactory.candidates.elementAt(variant);
        String skel = overrideFactory.getMethodSkeletonExpression(s);
        MethodFactory.println(skel);
        MethodOverrideFactory.overrideFactory.imports.clear();
        Method m = s.getMethod();
        Class<?>[] types = m.getParameterTypes();
        int i = 0;
        while (i < types.length) {
            overrideFactory.registerImport(types[i]);
            ++i;
        }
        types = m.getExceptionTypes();
        int i2 = 0;
        while (i2 < types.length) {
            overrideFactory.registerImport(types[i2]);
            ++i2;
        }
        overrideFactory.registerImport(m.getReturnType());
    }

    public static void getImportedClasses() {
        MethodFactory.println(overrideFactory.getImportsAsList());
    }

    public void flush() {
        super.flush();
        this.candidates.removeAllElements();
    }

    public static void main(String[] args) {
        String className = "javax.swing.AbstractAction";
        String methodName = "actionPerformed";
        if (args.length == 2) {
            className = args[0];
            methodName = args[1];
        }
        System.out.println("Class: " + className);
        System.out.println("Method: " + methodName);
        MethodOverrideFactory.getCandidateSignatures(className, methodName);
    }
}

