/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks;

import java.util.Iterator;
import java.util.Set;

class ClassResolver {
    private final String mPkg;
    private final Set mImports;
    private final ClassLoader mLoader;

    ClassResolver(ClassLoader aLoader, String aPkg, Set aImports) {
        this.mLoader = aLoader;
        this.mPkg = aPkg;
        this.mImports = aImports;
    }

    Class resolve(String aName) throws ClassNotFoundException {
        String fqn;
        if (this.isLoadable(aName)) {
            return this.safeLoad(aName);
        }
        Iterator it = this.mImports.iterator();
        while (it.hasNext()) {
            String imp = (String)it.next();
            if (!imp.endsWith(aName) || !this.isLoadable(imp)) continue;
            return this.safeLoad(imp);
        }
        if (this.mPkg != null && this.isLoadable(fqn = this.mPkg + "." + aName)) {
            return this.safeLoad(fqn);
        }
        String langClass = "java.lang." + aName;
        if (this.isLoadable(langClass)) {
            return this.safeLoad(langClass);
        }
        it = this.mImports.iterator();
        while (it.hasNext()) {
            String fqn2;
            String imp = (String)it.next();
            if (!imp.endsWith(".*") || !this.isLoadable(fqn2 = imp.substring(0, imp.lastIndexOf(46) + 1) + aName)) continue;
            return this.safeLoad(fqn2);
        }
        return this.safeLoad(aName);
    }

    boolean isLoadable(String aName) {
        try {
            this.safeLoad(aName);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    Class safeLoad(String aName) throws ClassNotFoundException {
        return Class.forName(aName, false, this.mLoader);
    }
}

