/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.pipeline.bucketmetrics;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalMultiBucketAggregation;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.elasticsearch.search.aggregations.pipeline.BucketHelpers;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.aggregations.pipeline.SiblingPipelineAggregator;
import org.elasticsearch.search.aggregations.support.AggregationPath;
import org.elasticsearch.search.aggregations.support.format.ValueFormatter;
import org.elasticsearch.search.aggregations.support.format.ValueFormatterStreams;

public abstract class BucketMetricsPipelineAggregator
extends SiblingPipelineAggregator {
    protected ValueFormatter formatter;
    protected BucketHelpers.GapPolicy gapPolicy;

    public BucketMetricsPipelineAggregator() {
    }

    protected BucketMetricsPipelineAggregator(String name, String[] bucketsPaths, BucketHelpers.GapPolicy gapPolicy, ValueFormatter formatter, Map<String, Object> metaData) {
        super(name, bucketsPaths, metaData);
        this.gapPolicy = gapPolicy;
        this.formatter = formatter;
    }

    @Override
    public final InternalAggregation doReduce(Aggregations aggregations, InternalAggregation.ReduceContext context) {
        this.preCollection();
        List<String> bucketsPath = AggregationPath.parse(this.bucketsPaths()[0]).getPathElementsAsStringList();
        for (Aggregation aggregation : aggregations) {
            if (!aggregation.getName().equals(bucketsPath.get(0))) continue;
            bucketsPath = bucketsPath.subList(1, bucketsPath.size());
            InternalMultiBucketAggregation multiBucketsAgg = (InternalMultiBucketAggregation)aggregation;
            List<? extends MultiBucketsAggregation.Bucket> buckets = multiBucketsAgg.getBuckets();
            for (int i = 0; i < buckets.size(); ++i) {
                MultiBucketsAggregation.Bucket bucket = buckets.get(i);
                Double bucketValue = BucketHelpers.resolveBucketValue(multiBucketsAgg, bucket, bucketsPath, this.gapPolicy);
                if (bucketValue == null || Double.isNaN(bucketValue)) continue;
                this.collectBucketValue(bucket.getKeyAsString(), bucketValue);
            }
        }
        return this.buildAggregation(Collections.EMPTY_LIST, this.metaData());
    }

    protected void preCollection() {
    }

    protected abstract InternalAggregation buildAggregation(List<PipelineAggregator> var1, Map<String, Object> var2);

    protected abstract void collectBucketValue(String var1, Double var2);

    @Override
    public final void doReadFrom(StreamInput in) throws IOException {
        this.formatter = ValueFormatterStreams.readOptional(in);
        this.gapPolicy = BucketHelpers.GapPolicy.readFrom(in);
        this.innerReadFrom(in);
    }

    protected void innerReadFrom(StreamInput in) throws IOException {
    }

    @Override
    public final void doWriteTo(StreamOutput out) throws IOException {
        ValueFormatterStreams.writeOptional(this.formatter, out);
        this.gapPolicy.writeTo(out);
        this.innerWriteTo(out);
    }

    protected void innerWriteTo(StreamOutput out) throws IOException {
    }
}

