/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Named;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.util.StringUtils;
import net.sf.freecol.common.util.Utils;
import org.w3c.dom.Element;

public class ModelMessage
extends StringTemplate {
    private String sourceId;
    private String displayId;
    private MessageType messageType;
    private boolean beenDisplayed = false;
    private static final String DISPLAY_TAG = "display";
    private static final String HAS_BEEN_DISPLAYED_TAG = "hasBeenDisplayed";
    private static final String MESSAGE_TYPE_TAG = "messageType";
    private static final String SOURCE_TAG = "source";

    public ModelMessage(String id, FreeColGameObject source) {
        this(MessageType.DEFAULT, id, source, ModelMessage.getDefaultDisplay(MessageType.DEFAULT, source));
    }

    public ModelMessage(String id, FreeColGameObject source, FreeColObject display) {
        this(MessageType.DEFAULT, id, source, display);
    }

    public ModelMessage(MessageType messageType, String id, FreeColGameObject source) {
        this(messageType, id, source, ModelMessage.getDefaultDisplay(messageType, source));
    }

    public ModelMessage(MessageType messageType, String id, String defaultId, FreeColGameObject source) {
        this(messageType, id, defaultId, source, ModelMessage.getDefaultDisplay(messageType, source));
    }

    public ModelMessage(MessageType messageType, String id, FreeColGameObject source, FreeColObject display) {
        this(messageType, id, null, source, display);
    }

    public ModelMessage(MessageType messageType, String id, String defaultId, FreeColGameObject source, FreeColObject display) {
        super(id, defaultId, StringTemplate.TemplateType.TEMPLATE);
        this.messageType = messageType;
        this.sourceId = source.getId();
        this.displayId = display != null ? display.getId() : source.getId();
    }

    public ModelMessage(FreeColXMLReader xr) throws XMLStreamException {
        this.readFromXML(xr);
    }

    public ModelMessage(Element element) {
        this.readFromXMLElement(element);
    }

    public String getSourceId() {
        return this.sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public String getDisplayId() {
        return this.displayId;
    }

    public void setDisplayId(String displayId) {
        this.displayId = displayId;
    }

    public void divert(FreeColGameObject newSource) {
        if (Utils.equals(this.displayId, this.sourceId)) {
            this.displayId = newSource.getId();
        }
        this.sourceId = newSource.getId();
    }

    public MessageType getMessageType() {
        return this.messageType;
    }

    public void setMessageType(MessageType messageType) {
        this.messageType = messageType;
    }

    public boolean hasBeenDisplayed() {
        return this.beenDisplayed;
    }

    public void setBeenDisplayed(boolean beenDisplayed) {
        this.beenDisplayed = beenDisplayed;
    }

    private static FreeColObject getDefaultDisplay(MessageType messageType, FreeColGameObject source) {
        FreeColObject o = null;
        switch (messageType) {
            case SONS_OF_LIBERTY: 
            case GOVERNMENT_EFFICIENCY: {
                o = source.getSpecification().getGoodsType("model.goods.bells");
                break;
            }
            case UNIT_IMPROVED: 
            case UNIT_DEMOTED: 
            case UNIT_LOST: 
            case UNIT_ADDED: 
            case LOST_CITY_RUMOUR: 
            case COMBAT_RESULT: 
            case DEMANDS: 
            case GOODS_MOVEMENT: {
                o = source;
                break;
            }
            case BUILDING_COMPLETED: {
                o = source.getSpecification().getGoodsType("model.goods.hammers");
                break;
            }
            default: {
                if (!(source instanceof Player)) break;
                o = source;
            }
        }
        return o;
    }

    public String getIgnoredMessageKey() {
        switch (this.getMessageType()) {
            case WAREHOUSE_CAPACITY: {
                String key = this.getSourceId();
                switch (this.getTemplateType()) {
                    case TEMPLATE: {
                        for (String k : this.getKeys()) {
                            if (!"%goods%".equals(k)) continue;
                            key = key + "-" + this.getReplacement(k).getId();
                        }
                        break;
                    }
                }
                return key;
            }
        }
        return null;
    }

    public List<Object> splitLinks(Player player) {
        FreeColGameObject source = player.getGame().getMessageSource(this);
        ArrayList<Object> result = new ArrayList<Object>();
        result.add(Messages.message(this));
        for (String key : this.getKeys()) {
            String val;
            JButton b = Utility.getMessageButton(key, val = Messages.message(this.getReplacement(key)), player, source);
            if (b == null) continue;
            ArrayList<Object> next = new ArrayList<Object>();
            for (Object e : result) {
                if (e instanceof String) {
                    int index;
                    String str = (String)e;
                    int start = 0;
                    while ((index = str.indexOf(val, start)) >= 0) {
                        if (index > start) {
                            next.add(str.substring(start, index));
                        }
                        next.add(b);
                        start = index + val.length();
                    }
                    next.add(str.substring(start, str.length()));
                    continue;
                }
                next.add(e);
            }
            result = next;
        }
        return result;
    }

    @Override
    public ModelMessage add(String key, String value) {
        return (ModelMessage)super.add(key, value);
    }

    @Override
    public ModelMessage add(String value) {
        return (ModelMessage)super.add(value);
    }

    @Override
    public ModelMessage addName(String key, String value) {
        return (ModelMessage)super.addName(key, value);
    }

    @Override
    public ModelMessage addName(String value) {
        return (ModelMessage)super.addName(value);
    }

    @Override
    public ModelMessage addName(String key, FreeColObject object) {
        return (ModelMessage)super.addName(key, object);
    }

    @Override
    public ModelMessage addNamed(String key, Named named) {
        return (ModelMessage)super.addNamed(key, named);
    }

    @Override
    public ModelMessage addAmount(String key, Number amount) {
        return (ModelMessage)super.addAmount(key, amount);
    }

    @Override
    public ModelMessage addStringTemplate(String key, StringTemplate template) {
        return (ModelMessage)super.addStringTemplate(key, template);
    }

    @Override
    public ModelMessage addStringTemplate(StringTemplate template) {
        return (ModelMessage)super.addStringTemplate(template);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ModelMessage) {
            ModelMessage m = (ModelMessage)o;
            return this.sourceId.equals(m.sourceId) && this.messageType == m.messageType && super.equals(m);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = 37 * hash + this.sourceId.hashCode();
        return 37 * hash + this.messageType.ordinal();
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        xw.writeAttribute(SOURCE_TAG, this.sourceId);
        if (this.displayId != null) {
            xw.writeAttribute(DISPLAY_TAG, this.displayId);
        }
        xw.writeAttribute(MESSAGE_TYPE_TAG, this.messageType);
        xw.writeAttribute(HAS_BEEN_DISPLAYED_TAG, this.beenDisplayed);
    }

    @Override
    public void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        this.sourceId = xr.getAttribute(SOURCE_TAG, null);
        this.displayId = xr.getAttribute(DISPLAY_TAG, null);
        this.messageType = xr.getAttribute(MESSAGE_TYPE_TAG, MessageType.class, MessageType.DEFAULT);
        this.beenDisplayed = xr.getAttribute(HAS_BEEN_DISPLAYED_TAG, false);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append("ModelMessage<").append(this.hashCode()).append(", ").append(this.sourceId == null ? "null" : this.sourceId).append(", ").append(this.displayId == null ? "null" : this.displayId).append(", ").append(super.toString()).append(", ").append(this.messageType).append(" >");
        return sb.toString();
    }

    @Override
    public String getXMLTagName() {
        return ModelMessage.getXMLElementTagName();
    }

    public static String getXMLElementTagName() {
        return "modelMessage";
    }

    public static enum MessageType implements Named
    {
        DEFAULT(""),
        WARNING("model.option.guiShowWarning"),
        SONS_OF_LIBERTY("model.option.guiShowSonsOfLiberty"),
        GOVERNMENT_EFFICIENCY("model.option.guiShowGovernmentEfficiency"),
        WAREHOUSE_CAPACITY("model.option.guiShowWarehouseCapacity"),
        UNIT_IMPROVED("model.option.guiShowUnitImproved"),
        UNIT_DEMOTED("model.option.guiShowUnitDemoted"),
        UNIT_LOST("model.option.guiShowUnitLost"),
        UNIT_ADDED("model.option.guiShowUnitAdded"),
        BUILDING_COMPLETED("model.option.guiShowBuildingCompleted"),
        FOREIGN_DIPLOMACY("model.option.guiShowForeignDiplomacy"),
        MARKET_PRICES("model.option.guiShowMarketPrices"),
        LOST_CITY_RUMOUR(null),
        MISSING_GOODS("model.option.guiShowMissingGoods"),
        TUTORIAL("model.option.guiShowTutorial"),
        COMBAT_RESULT(null),
        GIFT_GOODS("model.option.guiShowGifts"),
        DEMANDS("model.option.guiShowDemands"),
        GOODS_MOVEMENT("model.option.guiShowGoodsMovement");

        private final String optionName;

        private MessageType(String optionName) {
            this.optionName = optionName;
        }

        public String getOptionName() {
            return this.optionName;
        }

        private String getKey() {
            return "messageType." + StringUtils.getEnumKey(this);
        }

        @Override
        public String getNameKey() {
            return Messages.nameKey("model." + this.getKey());
        }
    }
}

